/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHashLinkedBuckets;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Hash"}, include={"Enumerable"}, overrides={RubyHashLinkedBuckets.class})
public class RubyHash
extends RubyObject
implements Map {
    public static final int DEFAULT_INSPECT_STR_SIZE = 20;
    protected Object state;
    protected static final byte COMPARE_BY_IDENTITY = 1;
    protected static final byte RUBY2_KEYWORD = 2;
    protected static final byte PROCDEFAULT_HASH = 4;
    protected static final RubyHashEntry NULL_ENTRY;
    @Deprecated
    public static final RubyHashEntry NO_ENTRY;
    @Deprecated
    public static final int[] MRI_PRIMES;
    public static final VisitorWithState<RubyArray> StoreValueVisitor;
    static final VisitorWithState SetValueVisitor;
    @Deprecated(since="10.0.0.0", forRemoval=true)
    private static final VisitorWithState<MarshalStream> MarshalDumpVisitor;

    public static RubyClass createHashClass(ThreadContext context, RubyClass Object2, RubyModule Enumerable) {
        return (RubyClass)((RubyModule)((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "Hash", Object2, (runtime2, klass) -> new RubyHashLinkedBuckets(runtime2, klass)).reifiedClass(RubyHash.class)).kindOf(new RubyModule.JavaClassKindOf(RubyHash.class))).classIndex(ClassIndex.HASH)).include(context, Enumerable)).defineMethods(context, RubyHash.class);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.HASH;
    }

    @JRubyMethod(name={"[]"}, rest=true, meta=true)
    public static IRubyObject create(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (args2.length == 1) {
            IRubyObject tmp = TypeConverter.convertToTypeWithCheck(args2[0], Access.hashClass(context), "to_hash");
            if (!tmp.isNil()) {
                return new RubyHashLinkedBuckets(context.runtime, (RubyClass)recv2, (RubyHash)tmp);
            }
            RubyClass Array2 = Access.arrayClass(context);
            IRubyObject nil = context.nil;
            tmp = TypeConverter.convertToTypeWithCheck(args2[0], Array2, "to_ary");
            if (tmp != nil) {
                RubyHash hash2 = (RubyHash)((RubyClass)recv2).allocate(context);
                RubyArray arr = (RubyArray)tmp;
                int j = arr.getLength();
                for (int i2 = 0; i2 < j; ++i2) {
                    IRubyObject e = arr.entry(i2);
                    IRubyObject v = TypeConverter.convertToTypeWithCheck(e, Array2, "to_ary");
                    IRubyObject val = nil;
                    if (v == nil) {
                        throw Error.argumentError(context, "wrong element type " + String.valueOf(e.getMetaClass()) + " at " + i2 + " (expected array)");
                    }
                    switch (((RubyArray)v).getLength()) {
                        default: {
                            throw Error.argumentError(context, "invalid number of elements (" + ((RubyArray)v).getLength() + " for 1..2)");
                        }
                        case 2: {
                            val = ((RubyArray)v).entry(1);
                        }
                        case 1: 
                    }
                    IRubyObject key2 = ((RubyArray)v).entry(0);
                    hash2.fastASetCheckString(context.runtime, key2, val);
                }
                return hash2;
            }
        }
        if ((args2.length & 1) != 0) {
            throw Error.argumentError(context, "odd number of arguments for Hash");
        }
        RubyHash hash3 = (RubyHash)((RubyClass)recv2).allocate(context);
        for (int i3 = 0; i3 < args2.length; i3 += 2) {
            hash3.fastASetCheckString(context.runtime, args2[i3], args2[i3 + 1]);
        }
        return hash3;
    }

    @JRubyMethod(name={"try_convert"}, meta=true)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject recv2, IRubyObject args2) {
        return TypeConverter.convertToTypeWithCheck(args2, Access.hashClass(context), "to_hash");
    }

    public static final RubyHash newHash(Ruby runtime2) {
        return RubyHashLinkedBuckets.newLBHash(runtime2);
    }

    public static final RubyHash newSmallHash(Ruby runtime2) {
        return RubyHashLinkedBuckets.newLBHash(runtime2, 1);
    }

    public static RubyHash newKwargs(Ruby runtime2, String key2, IRubyObject value2) {
        return RubyHash.newHash(runtime2, runtime2.newSymbol(key2), value2);
    }

    public static RubyHash newHash(Ruby runtime2, IRubyObject key2, IRubyObject value2) {
        RubyHash kwargs = RubyHash.newSmallHash(runtime2);
        kwargs.fastASetSmall(key2, value2);
        return kwargs;
    }

    public static final RubyHash newHash(Ruby runtime2, Map valueMap, IRubyObject defaultValue) {
        assert (defaultValue != null);
        return new RubyHashLinkedBuckets(runtime2, valueMap, defaultValue);
    }

    protected RubyHash(Ruby runtime2, RubyClass klass, boolean objectSpace, int unused2) {
        super(runtime2, klass, objectSpace);
        assert (this.getClass() != RubyHash.class);
    }

    @Deprecated
    public RubyHash(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        assert (this.getClass() == RubyHash.class);
        this.setDelegate(this);
    }

    @Deprecated
    public RubyHash(Ruby runtime2, RubyClass klass, boolean objectSpace) {
        super(runtime2, klass, objectSpace);
        assert (this.getClass() == RubyHash.class);
        this.setDelegate(new RubyHashLinkedBuckets(runtime2, klass, objectSpace));
    }

    @Deprecated
    public RubyHash(Ruby runtime2) {
        super(runtime2, runtime2.getHash());
        assert (this.getClass() == RubyHash.class);
        this.setDelegate(RubyHashLinkedBuckets.newLBHash(runtime2));
    }

    @Deprecated
    public RubyHash(Ruby runtime2, IRubyObject defaultValue) {
        super(runtime2, runtime2.getHash());
        assert (this.getClass() == RubyHash.class);
        this.setDelegate(RubyHashLinkedBuckets.newLBHash(runtime2, defaultValue));
    }

    private RubyHash getDelegate() {
        return (RubyHash)this.state;
    }

    private void setDelegate(RubyHash state2) {
        this.state = state2;
    }

    public IRubyObject internalPut(IRubyObject key2, IRubyObject value2) {
        return this.getDelegate().internalPut(key2, value2);
    }

    boolean internalPutIfNoKey(IRubyObject key2, IRubyObject value2) {
        return this.getDelegate().internalPutIfNoKey(key2, value2);
    }

    protected IRubyObject internalGet(IRubyObject key2) {
        return this.getDelegate().internalGet(key2);
    }

    @Deprecated
    RubyHashEntry getEntry(IRubyObject key2) {
        return this.getDelegate().getEntry(key2);
    }

    public <T> void visitAll(ThreadContext context, VisitorWithStateI visitor) {
        this.getDelegate().visitAll(context, visitor);
    }

    public <T> void visitAll(ThreadContext context, VisitorWithState visitor, T state2) {
        this.getDelegate().visitAll(context, visitor, state2);
    }

    protected <T> void visitLimited(ThreadContext context, VisitorWithState visitor, long size2, T state2) {
        this.getDelegate().visitLimited(context, visitor, size2, state2);
    }

    public <T> boolean allSymbols() {
        return this.getDelegate().allSymbols();
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        return this.getDelegate().initialize(context, block);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject _default, Block block) {
        return this.getDelegate().initialize(context, _default, block);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, keywords=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject _default, IRubyObject hash2, Block block) {
        return this.getDelegate().initialize(context, _default, hash2, block);
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context) {
        return this.getDelegate().default_value_get(context);
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context, IRubyObject arg2) {
        return this.getDelegate().default_value_get(context, arg2);
    }

    @JRubyMethod(name={"default="})
    public IRubyObject default_value_set(ThreadContext context, IRubyObject defaultValue) {
        return this.getDelegate().default_value_set(context, defaultValue);
    }

    @JRubyMethod
    public IRubyObject default_proc(ThreadContext context) {
        return this.getDelegate().default_proc(context);
    }

    @JRubyMethod(name={"default_proc="})
    public IRubyObject set_default_proc(ThreadContext context, IRubyObject proc2) {
        return this.getDelegate().set_default_proc(context, proc2);
    }

    public void modify() {
        this.getDelegate().modify();
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return this.getDelegate().inspect(context);
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum rb_size(ThreadContext context) {
        return this.getDelegate().rb_size(context);
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        return this.getDelegate().empty_p(context);
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a(ThreadContext context) {
        return this.getDelegate().to_a(context);
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return this.getDelegate().to_s(context);
    }

    @JRubyMethod(name={"rehash"})
    public RubyHash rehash(ThreadContext context) {
        return this.getDelegate().rehash(context);
    }

    @JRubyMethod(name={"to_hash"})
    public RubyHash to_hash(ThreadContext context) {
        return this.getDelegate().to_hash(context);
    }

    @JRubyMethod
    public RubyHash to_h(ThreadContext context, Block block) {
        return this.getDelegate().to_h(context, block);
    }

    protected RubyHash to_h_block(ThreadContext context, Block block) {
        return this.getDelegate().to_h_block(context, block);
    }

    @Override
    public RubyHash convertToHash() {
        return this.getDelegate().convertToHash();
    }

    public void fastASet(IRubyObject key2, IRubyObject value2) {
        this.getDelegate().fastASet(key2, value2);
    }

    public void fastASetSmall(IRubyObject key2, IRubyObject value2) {
        this.getDelegate().fastASetSmall(key2, value2);
    }

    public void fastASetSmallPair(ThreadContext context, IRubyObject _pair) {
        this.getDelegate().fastASetSmallPair(context, _pair);
    }

    public void fastASetCheckString(Ruby runtime2, IRubyObject key2, IRubyObject value2) {
        this.getDelegate().fastASetCheckString(runtime2, key2, value2);
    }

    public void fastASetSmallCheckString(Ruby runtime2, IRubyObject key2, IRubyObject value2) {
        this.getDelegate().fastASetSmallCheckString(runtime2, key2, value2);
    }

    public void fastASet(Ruby runtime2, IRubyObject key2, IRubyObject value2, boolean prepareString) {
        this.getDelegate().fastASet(runtime2, key2, value2, prepareString);
    }

    public void fastASetSmall(Ruby runtime2, IRubyObject key2, IRubyObject value2, boolean prepareString) {
        this.getDelegate().fastASetSmall(runtime2, key2, value2, prepareString);
    }

    @JRubyMethod(name={"[]=", "store"})
    public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        return this.getDelegate().op_aset(context, key2, value2);
    }

    public IRubyObject fastARef(IRubyObject key2) {
        return this.getDelegate().fastARef(key2);
    }

    public RubyBoolean compare(ThreadContext context, VisitorWithState<RubyHash> visitor, IRubyObject other, boolean eql2) {
        return this.getDelegate().compare(context, visitor, other, eql2);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return this.getDelegate().op_equal(context, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql(ThreadContext context, IRubyObject other) {
        return this.getDelegate().op_eql(context, other);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
        return this.getDelegate().op_aref(context, key2);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        return this.getDelegate().op_lt(context, other);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        return this.getDelegate().op_le(context, other);
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        return this.getDelegate().op_gt(context, other);
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        return this.getDelegate().op_ge(context, other);
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return this.getDelegate().hash(context);
    }

    public IRubyObject fetch(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.getDelegate().fetch(context, args2, block);
    }

    @JRubyMethod(rest=true)
    public IRubyObject except(ThreadContext context, IRubyObject[] keys2) {
        return this.getDelegate().except(context, keys2);
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, Block block) {
        return this.getDelegate().fetch(context, key2, block);
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, IRubyObject _default, Block block) {
        return this.getDelegate().fetch(context, key2, _default, block);
    }

    @JRubyMethod(name={"has_key?", "key?", "include?", "member?"})
    public RubyBoolean has_key_p(ThreadContext context, IRubyObject key2) {
        return this.getDelegate().has_key_p(context, key2);
    }

    public boolean hasKey(IRubyObject key2) {
        return this.getDelegate().hasKey(key2);
    }

    @JRubyMethod(name={"has_value?", "value?"})
    public RubyBoolean has_value_p(ThreadContext context, IRubyObject expected) {
        return this.getDelegate().has_value_p(context, expected);
    }

    public RubyHash eachCommon(ThreadContext context, Block block) {
        return this.getDelegate().eachCommon(context, block);
    }

    @JRubyMethod(name={"each", "each_pair"})
    public IRubyObject each(ThreadContext context, Block block) {
        return this.getDelegate().each(context, block);
    }

    public RubyHash each_pairCommon(ThreadContext context, Block block) {
        return this.getDelegate().each_pairCommon(context, block);
    }

    public RubyHash each_valueCommon(ThreadContext context, Block block) {
        return this.getDelegate().each_valueCommon(context, block);
    }

    @JRubyMethod
    public IRubyObject each_value(ThreadContext context, Block block) {
        return this.getDelegate().each_value(context, block);
    }

    public RubyHash each_keyCommon(ThreadContext context, Block block) {
        return this.getDelegate().each_keyCommon(context, block);
    }

    @JRubyMethod
    public IRubyObject each_key(ThreadContext context, Block block) {
        return this.getDelegate().each_key(context, block);
    }

    @JRubyMethod(name={"transform_keys"}, rest=true)
    public IRubyObject transform_keys(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.getDelegate().transform_keys(context, args2, block);
    }

    @JRubyMethod(name={"transform_values"})
    public IRubyObject transform_values(ThreadContext context, Block block) {
        return this.getDelegate().transform_values(context, block);
    }

    @JRubyMethod(name={"transform_keys!"}, rest=true)
    public IRubyObject transform_keys_bang(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.getDelegate().transform_keys_bang(context, args2, block);
    }

    @JRubyMethod(name={"transform_values!"})
    public IRubyObject transform_values_bang(ThreadContext context, Block block) {
        return this.getDelegate().transform_values_bang(context, block);
    }

    @JRubyMethod(name={"select!"}, alias={"filter!"})
    public IRubyObject select_bang(ThreadContext context, Block block) {
        return this.getDelegate().select_bang(context, block);
    }

    @JRubyMethod
    public IRubyObject keep_if(ThreadContext context, Block block) {
        return this.getDelegate().keep_if(context, block);
    }

    public boolean keep_ifCommon(ThreadContext context, Block block) {
        return this.getDelegate().keep_ifCommon(context, block);
    }

    @JRubyMethod
    public IRubyObject key(ThreadContext context, IRubyObject expected) {
        return this.getDelegate().key(context, expected);
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys(ThreadContext context) {
        return this.getDelegate().keys(context);
    }

    public RubyArray keys() {
        return this.getDelegate().keys();
    }

    @JRubyMethod(name={"values"})
    public RubyArray values(ThreadContext context) {
        return this.getDelegate().values(context);
    }

    public RubyArray rb_values(ThreadContext context) {
        return this.getDelegate().rb_values(context);
    }

    @JRubyMethod(name={"shift"})
    public IRubyObject shift(ThreadContext context) {
        return this.getDelegate().shift(context);
    }

    public boolean fastDelete(IRubyObject key2) {
        return this.getDelegate().fastDelete(key2);
    }

    @JRubyMethod
    public IRubyObject delete(ThreadContext context, IRubyObject key2, Block block) {
        return this.getDelegate().delete(context, key2, block);
    }

    public IRubyObject delete(IRubyObject key2) {
        return this.getDelegate().delete(key2);
    }

    public IRubyObject delete(ThreadContext context, IRubyObject key2) {
        return this.getDelegate().delete(context, key2);
    }

    @JRubyMethod(name={"select"}, alias={"filter"})
    public IRubyObject select(ThreadContext context, Block block) {
        return this.getDelegate().select(context, block);
    }

    @JRubyMethod(name={"slice"}, rest=true)
    public RubyHash slice(ThreadContext context, IRubyObject[] args2) {
        return this.getDelegate().slice(context, args2);
    }

    public RubyHash delete_ifInternal(ThreadContext context, Block block) {
        return this.getDelegate().delete_ifInternal(context, block);
    }

    @JRubyMethod
    public IRubyObject delete_if(ThreadContext context, Block block) {
        return this.getDelegate().delete_if(context, block);
    }

    public RubyHash rejectInternal(ThreadContext context, Block block) {
        return this.getDelegate().rejectInternal(context, block);
    }

    @JRubyMethod
    public IRubyObject reject(ThreadContext context, Block block) {
        return this.getDelegate().reject(context, block);
    }

    public IRubyObject reject_bangInternal(ThreadContext context, Block block) {
        return this.getDelegate().reject_bangInternal(context, block);
    }

    @JRubyMethod(name={"reject!"})
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        return this.getDelegate().reject_bang(context, block);
    }

    @JRubyMethod(name={"clear"})
    public RubyHash rb_clear(ThreadContext context) {
        return this.getDelegate().rb_clear(context);
    }

    @JRubyMethod(name={"invert"})
    public RubyHash invert(ThreadContext context) {
        return this.getDelegate().invert(context);
    }

    @JRubyMethod(name={"merge!", "update"}, rest=true)
    public RubyHash merge_bang(ThreadContext context, IRubyObject[] others, Block block) {
        return this.getDelegate().merge_bang(context, others, block);
    }

    public void addAll(ThreadContext context, RubyHash otherHash) {
        this.getDelegate().addAll(context, otherHash);
    }

    @JRubyMethod(rest=true)
    public RubyHash merge(ThreadContext context, IRubyObject[] others, Block block) {
        return this.getDelegate().merge(context, others, block);
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public RubyHash initialize_copy(ThreadContext context, IRubyObject other) {
        return this.getDelegate().initialize_copy(context, other);
    }

    @JRubyMethod(name={"replace"})
    public RubyHash replace(ThreadContext context, IRubyObject other) {
        return this.getDelegate().replace(context, other);
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public RubyArray values_at(ThreadContext context, IRubyObject[] args2) {
        return this.getDelegate().values_at(context, args2);
    }

    @JRubyMethod(name={"fetch_values"}, rest=true)
    public RubyArray fetch_values(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.getDelegate().fetch_values(context, args2, block);
    }

    @JRubyMethod(name={"assoc"})
    public IRubyObject assoc(ThreadContext context, IRubyObject obj) {
        return this.getDelegate().assoc(context, obj);
    }

    @JRubyMethod(name={"rassoc"})
    public IRubyObject rassoc(ThreadContext context, IRubyObject obj) {
        return this.getDelegate().rassoc(context, obj);
    }

    @JRubyMethod
    public IRubyObject flatten(ThreadContext context) {
        return this.getDelegate().flatten(context);
    }

    @JRubyMethod
    public IRubyObject flatten(ThreadContext context, IRubyObject level2) {
        return this.getDelegate().flatten(context, level2);
    }

    @JRubyMethod(name={"compact"})
    public IRubyObject compact(ThreadContext context) {
        return this.getDelegate().compact(context);
    }

    @JRubyMethod(name={"compact!"})
    public IRubyObject compact_bang(ThreadContext context) {
        return this.getDelegate().compact_bang(context);
    }

    @JRubyMethod(name={"compare_by_identity"})
    public IRubyObject compare_by_identity(ThreadContext context) {
        return this.getDelegate().compare_by_identity(context);
    }

    @JRubyMethod(name={"compare_by_identity?"})
    public IRubyObject compare_by_identity_p(ThreadContext context) {
        return this.getDelegate().compare_by_identity_p(context);
    }

    @Override
    @JRubyMethod
    public IRubyObject dup(ThreadContext context) {
        return this.getDelegate().dup(context);
    }

    @Override
    public IRubyObject rbClone(ThreadContext context, IRubyObject opts) {
        return super.rbClone(context, opts);
    }

    public IRubyObject rbClone(ThreadContext context) {
        return super.rbClone(context, context.nil);
    }

    @JRubyMethod(name={"any?"})
    public IRubyObject any_p(ThreadContext context, Block block) {
        return this.getDelegate().any_p(context, block);
    }

    @JRubyMethod(name={"any?"})
    public IRubyObject any_p(ThreadContext context, IRubyObject pattern, Block block) {
        return this.getDelegate().any_p(context, pattern, block);
    }

    public RubyHash dupFast(ThreadContext context) {
        return this.getDelegate().dupFast(context);
    }

    public RubyHash withRuby2Keywords(boolean ruby2Keywords) {
        return this.getDelegate().withRuby2Keywords(ruby2Keywords);
    }

    public boolean hasDefaultProc() {
        return this.getDelegate().hasDefaultProc();
    }

    public IRubyObject getIfNone() {
        return this.getDelegate().getIfNone();
    }

    @JRubyMethod
    public IRubyObject deconstruct_keys(ThreadContext context, IRubyObject _arg1) {
        return this.getDelegate().deconstruct_keys(context, _arg1);
    }

    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0) {
        return this.getDelegate().dig(context, arg0);
    }

    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        return this.getDelegate().dig(context, arg0, arg1);
    }

    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.getDelegate().dig(context, arg0, arg1, arg2);
    }

    @JRubyMethod(name={"dig"}, required=1, rest=true, checkArity=false)
    public IRubyObject dig(ThreadContext context, IRubyObject[] args2) {
        return this.getDelegate().dig(context, args2);
    }

    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context) {
        return this.getDelegate().to_proc(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject ruby2_keywords_hash(ThreadContext context, IRubyObject _self, IRubyObject arg2) {
        TypeConverter.checkType(context, arg2, Access.hashClass(context));
        RubyHash hash2 = (RubyHash)arg2.dup();
        hash2.setRuby2KeywordHash(true);
        return hash2;
    }

    @JRubyMethod(meta=true, name={"ruby2_keywords_hash?"})
    public static IRubyObject ruby2_keywords_hash_p(ThreadContext context, IRubyObject _self, IRubyObject arg2) {
        TypeConverter.checkType(context, arg2, Access.hashClass(context));
        return Convert.asBoolean(context, ((RubyHash)arg2).isRuby2KeywordHash());
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static void marshalTo(RubyHash hash2, MarshalStream output) throws IOException {
        ThreadContext context = hash2.getRuntime().getCurrentContext();
        output.registerLinkTarget(context, hash2);
        int hashSize = hash2.size();
        output.writeInt(hashSize);
        try {
            hash2.visitLimited(context, MarshalDumpVisitor, hashSize, output);
        }
        catch (VisitorIOException e) {
            throw (IOException)e.getCause();
        }
        if (hash2.getIfNone() != UNDEF) {
            output.dumpObject(hash2.getIfNone());
        }
    }

    public static void marshalTo(ThreadContext context, final RubyOutputStream out, RubyHash hash2, MarshalDumper output) {
        output.registerObject(hash2);
        int hashSize = hash2.size();
        output.writeInt(out, hashSize);
        try {
            hash2.visitLimited(context, new VisitorWithState<MarshalDumper>(){

                @Override
                public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, MarshalDumper state2) {
                    state2.dumpObject(context, out, key2);
                    state2.dumpObject(context, out, value2);
                }
            }, hashSize, output);
        }
        catch (VisitorIOException e) {
            throw Error.toRubyException(context, (IOException)e.getCause());
        }
        if (hash2.getIfNone() != UNDEF) {
            output.dumpObject(context, out, hash2.getIfNone());
        }
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static RubyHash unmarshalFrom(UnmarshalStream input, boolean defaultValue) throws IOException {
        Ruby runtime2 = input.getRuntime();
        RubyHash result2 = (RubyHash)input.entry(RubyHash.newHash(runtime2));
        int size2 = input.unmarshalInt();
        for (int i2 = 0; i2 < size2; ++i2) {
            result2.fastASetCheckString(runtime2, input.unmarshalObject(), input.unmarshalObject());
        }
        if (defaultValue) {
            result2.default_value_set(runtime2.getCurrentContext(), input.unmarshalObject());
        }
        return result2;
    }

    public static RubyHash unmarshalFrom(ThreadContext context, RubyInputStream in, MarshalLoader input, boolean defaultValue, boolean identity) {
        RubyHash result2 = Create.newHash(context);
        if (identity) {
            result2.setComparedByIdentity(true);
        }
        result2 = (RubyHash)input.entry(result2);
        int size2 = input.unmarshalInt(context, in);
        for (int i2 = 0; i2 < size2; ++i2) {
            result2.fastASetCheckString(context.runtime, input.unmarshalObject(context, in), input.unmarshalObject(context, in));
        }
        if (defaultValue) {
            result2.default_value_set(context, input.unmarshalObject(context, in));
        }
        return result2;
    }

    @Override
    public Class getJavaClass() {
        return Map.class;
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.getDelegate().containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.getDelegate().containsValue(value2);
    }

    public Object get(Object key2) {
        return this.getDelegate().get(key2);
    }

    public Object put(Object key2, Object value2) {
        return this.getDelegate().put(key2, value2);
    }

    public Object remove(Object key2) {
        return this.getDelegate().remove(key2);
    }

    public void putAll(Map map2) {
        this.getDelegate().putAll(map2);
    }

    @Override
    public void clear() {
        this.getDelegate().clear();
    }

    @Override
    public boolean equals(Object other) {
        return this.getDelegate().equals(other);
    }

    public Set keySet() {
        return this.getDelegate().keySet();
    }

    public Collection values() {
        return this.getDelegate().values();
    }

    public Set entrySet() {
        return this.getDelegate().entrySet();
    }

    public Set directKeySet() {
        return this.getDelegate().directKeySet();
    }

    public Collection directValues() {
        return this.getDelegate().directValues();
    }

    public Set directEntrySet() {
        return this.getDelegate().directEntrySet();
    }

    public boolean isComparedByIdentity() {
        return this.getDelegate().isComparedByIdentity();
    }

    public void setComparedByIdentity(boolean comparedByIdentity) {
        this.getDelegate().setComparedByIdentity(comparedByIdentity);
    }

    public boolean isRuby2KeywordHash() {
        return this.getDelegate().isRuby2KeywordHash();
    }

    public void setRuby2KeywordHash(boolean value2) {
        this.getDelegate().setRuby2KeywordHash(value2);
    }

    protected void set(int flag, boolean set2) {
        this.getDelegate().set(flag, set2);
    }

    protected boolean get(int flag) {
        return this.getDelegate().get(flag);
    }

    @Deprecated(since="9.1.3.0")
    public final void visitAll(Visitor visitor) {
        this.visitLimited(this.getRuntime().getCurrentContext(), visitor, -1L, null);
    }

    static {
        NO_ENTRY = NULL_ENTRY = new RubyHashEntry();
        MRI_PRIMES = new int[]{11, 19, 37, 67, 131, 283, 521, 1033, 2053, 4099, 8219, 16427, 32771, 65581, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000055, 0};
        StoreValueVisitor = new VisitorWithState<RubyArray>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubyArray values2) {
                values2.storeInternal(context, index2, value2);
            }
        };
        SetValueVisitor = new VisitorWithState<RubyArray>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject val, int index2, RubyArray target2) {
                target2.eltInternalSet(index2, val);
            }
        };
        MarshalDumpVisitor = new VisitorWithState<MarshalStream>(){

            @Override
            public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, MarshalStream output) {
                try {
                    output.dumpObject(key2);
                    output.dumpObject(value2);
                }
                catch (IOException e) {
                    throw new VisitorIOException(e);
                }
            }
        };
    }

    public static final class RubyHashEntry
    implements Map.Entry {
        final IRubyObject key;
        IRubyObject value;
        RubyHashEntry next;
        RubyHashEntry prevAdded;
        RubyHashEntry nextAdded;
        final int hash;

        RubyHashEntry() {
            this.key = RubyBasicObject.NEVER;
            this.hash = -1;
        }

        public RubyHashEntry(int h, IRubyObject k, IRubyObject v, RubyHashEntry e, RubyHashEntry head) {
            this.key = k;
            this.value = v;
            this.next = e;
            this.hash = h;
            if (head != null) {
                RubyHashEntry prevAdded = head.prevAdded;
                RubyHashEntry nextAdded = head;
                this.prevAdded = prevAdded;
                prevAdded.nextAdded = this;
                this.nextAdded = nextAdded;
                nextAdded.prevAdded = this;
            }
        }

        public RubyHashEntry(RubyHashEntry oldEntry, int newHash) {
            RubyHashEntry prevAdded;
            this.hash = newHash;
            this.key = oldEntry.key;
            this.value = oldEntry.value;
            this.next = oldEntry.next;
            this.prevAdded = prevAdded = oldEntry.prevAdded;
            prevAdded.nextAdded = this;
            RubyHashEntry nextAdded = oldEntry.nextAdded;
            if (nextAdded != null) {
                this.nextAdded = nextAdded;
                nextAdded.prevAdded = this;
            }
        }

        public void detach() {
            if (this.prevAdded != null) {
                this.prevAdded.nextAdded = this.nextAdded;
                this.nextAdded.prevAdded = this.prevAdded;
                this.prevAdded = null;
            }
        }

        public boolean isLive() {
            return this.prevAdded != null;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getJavaifiedKey() {
            return this.key.toJava(Object.class);
        }

        public Object getValue() {
            return this.value;
        }

        public Object getJavaifiedValue() {
            return this.value.toJava(Object.class);
        }

        public Object setValue(Object value2) {
            IRubyObject oldValue = this.value;
            if (!(value2 instanceof IRubyObject)) {
                throw new UnsupportedOperationException("directEntrySet() doesn't support setValue for non IRubyObject instance entries, convert them manually or use entrySet() instead");
            }
            this.value = (IRubyObject)value2;
            return oldValue;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof RubyHashEntry)) {
                return false;
            }
            RubyHashEntry otherEntry = (RubyHashEntry)other;
            return !(this.key != otherEntry.key && !this.key.eql(otherEntry.key) || this.value != otherEntry.value && !this.value.equals(otherEntry.value));
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }

    public static interface VisitorWithStateI {
        public void visit(ThreadContext var1, RubyHash var2, IRubyObject var3, IRubyObject var4, int var5);
    }

    public static abstract class VisitorWithState<T> {
        public abstract void visit(ThreadContext var1, RubyHash var2, IRubyObject var3, IRubyObject var4, int var5, T var6);
    }

    protected static class VisitorIOException
    extends RuntimeException {
        VisitorIOException(Throwable cause2) {
            super(cause2);
        }
    }

    public static abstract class Visitor
    extends VisitorWithState {
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Object state2) {
            this.visit(key2, value2);
        }

        public abstract void visit(IRubyObject var1, IRubyObject var2);
    }
}

