/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.CRC32;
import com.jcraft.jzlib.JZlib;
import java.util.zip.Adler32;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.zlib.JZlibDeflate;
import org.jruby.ext.zlib.JZlibInflate;
import org.jruby.ext.zlib.JZlibRubyGzipReader;
import org.jruby.ext.zlib.JZlibRubyGzipWriter;
import org.jruby.ext.zlib.RubyGzipFile;
import org.jruby.ext.zlib.ZStream;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"Zlib"})
public class RubyZlib {
    public static final String ZLIB_VERSION = "1.2.3.3";
    public static final String VERSION = "0.6.0";

    public static RubyModule createZlibModule(ThreadContext context) {
        RubyClass Object2 = Access.objectClass(context);
        RubyClass StandardError2 = Access.standardErrorClass(context);
        Object Zlib2 = Define.defineModule(context, "Zlib").defineMethods(context, RubyZlib.class);
        Object ZlibError = ((RubyModule)Zlib2).defineClassUnder(context, "Error", StandardError2, StandardError2.getAllocator());
        ObjectAllocator errorAllocator = ((RubyClass)ZlibError).getAllocator();
        ((RubyModule)Zlib2).defineClassUnder(context, "StreamEnd", (RubyClass)ZlibError, errorAllocator);
        ((RubyModule)Zlib2).defineClassUnder(context, "StreamError", (RubyClass)ZlibError, errorAllocator);
        ((RubyModule)Zlib2).defineClassUnder(context, "BufError", (RubyClass)ZlibError, errorAllocator);
        ((RubyModule)Zlib2).defineClassUnder(context, "NeedDict", (RubyClass)ZlibError, errorAllocator);
        ((RubyModule)Zlib2).defineClassUnder(context, "MemError", (RubyClass)ZlibError, errorAllocator);
        ((RubyModule)Zlib2).defineClassUnder(context, "VersionError", (RubyClass)ZlibError, errorAllocator);
        ((RubyModule)Zlib2).defineClassUnder(context, "DataError", (RubyClass)ZlibError, errorAllocator);
        RubyClass GzipFile = (RubyClass)((RubyModule)((RubyModule)Zlib2).defineClassUnder(context, "GzipFile", Object2, RubyGzipFile::new)).defineMethods(context, RubyGzipFile.class);
        GzipFile.defineClassUnder(context, "Error", (RubyClass)ZlibError, errorAllocator);
        Object GZipFileError = GzipFile.defineClassUnder(context, "Error", (RubyClass)ZlibError, errorAllocator);
        ObjectAllocator fileErrorAllocator = ((RubyClass)ZlibError).getAllocator();
        ((RubyModule)GZipFileError).addReadAttribute(context, "input");
        GzipFile.defineClassUnder(context, "CRCError", (RubyClass)GZipFileError, fileErrorAllocator);
        GzipFile.defineClassUnder(context, "NoFooter", (RubyClass)GZipFileError, fileErrorAllocator);
        GzipFile.defineClassUnder(context, "LengthError", (RubyClass)GZipFileError, fileErrorAllocator);
        ((RubyModule)((RubyModule)((RubyModule)Zlib2).defineClassUnder(context, "GzipReader", GzipFile, JZlibRubyGzipReader::new)).include(context, Access.enumerableModule(context))).defineMethods(context, JZlibRubyGzipReader.class);
        ((RubyModule)((RubyModule)Zlib2).defineClassUnder(context, "GzipWriter", GzipFile, JZlibRubyGzipWriter::new)).defineMethods(context, JZlibRubyGzipWriter.class);
        ((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)Zlib2).defineConstant(context, "ZLIB_VERSION", Create.newString(context, ZLIB_VERSION))).defineConstant(context, "VERSION", Create.newString(context, VERSION))).defineConstant(context, "BINARY", Convert.asFixnum(context, (byte)0))).defineConstant(context, "ASCII", Convert.asFixnum(context, (byte)1))).defineConstant(context, "UNKNOWN", Convert.asFixnum(context, (byte)2))).defineConstant(context, "DEF_MEM_LEVEL", Convert.asFixnum(context, 8))).defineConstant(context, "MAX_MEM_LEVEL", Convert.asFixnum(context, 9))).defineConstant(context, "OS_UNIX", Convert.asFixnum(context, (byte)3))).defineConstant(context, "OS_UNKNOWN", Convert.asFixnum(context, (byte)-1))).defineConstant(context, "OS_CODE", Convert.asFixnum(context, (byte)11))).defineConstant(context, "OS_ZSYSTEM", Convert.asFixnum(context, (byte)8))).defineConstant(context, "OS_VMCMS", Convert.asFixnum(context, (byte)4))).defineConstant(context, "OS_VMS", Convert.asFixnum(context, (byte)2))).defineConstant(context, "OS_RISCOS", Convert.asFixnum(context, (byte)13))).defineConstant(context, "OS_MACOS", Convert.asFixnum(context, (byte)7))).defineConstant(context, "OS_OS2", Convert.asFixnum(context, (byte)6))).defineConstant(context, "OS_AMIGA", Convert.asFixnum(context, (byte)1))).defineConstant(context, "OS_QDOS", Convert.asFixnum(context, (byte)12))).defineConstant(context, "OS_WIN32", Convert.asFixnum(context, (byte)11))).defineConstant(context, "OS_ATARI", Convert.asFixnum(context, (byte)5))).defineConstant(context, "OS_MSDOS", Convert.asFixnum(context, (byte)0))).defineConstant(context, "OS_CPM", Convert.asFixnum(context, (byte)9))).defineConstant(context, "OS_TOPS20", Convert.asFixnum(context, (byte)10))).defineConstant(context, "DEFAULT_STRATEGY", Convert.asFixnum(context, 0))).defineConstant(context, "FILTERED", Convert.asFixnum(context, 1))).defineConstant(context, "HUFFMAN_ONLY", Convert.asFixnum(context, 2))).defineConstant(context, "NO_FLUSH", Convert.asFixnum(context, 0))).defineConstant(context, "SYNC_FLUSH", Convert.asFixnum(context, 2))).defineConstant(context, "FULL_FLUSH", Convert.asFixnum(context, 3))).defineConstant(context, "FINISH", Convert.asFixnum(context, 4))).defineConstant(context, "NO_COMPRESSION", Convert.asFixnum(context, 0))).defineConstant(context, "BEST_SPEED", Convert.asFixnum(context, 1))).defineConstant(context, "DEFAULT_COMPRESSION", Convert.asFixnum(context, -1))).defineConstant(context, "BEST_COMPRESSION", Convert.asFixnum(context, 9))).defineConstant(context, "MAX_WBITS", Convert.asFixnum(context, 15));
        RubyClass ZStream2 = (RubyClass)((RubyModule)((RubyModule)((RubyModule)Zlib2).defineClassUnder(context, "ZStream", Object2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, ZStream.class)).undefMethods(context, "new");
        ((RubyModule)((RubyModule)Zlib2).defineClassUnder(context, "Inflate", ZStream2, JZlibInflate::new)).defineMethods(context, JZlibInflate.class);
        ((RubyModule)((RubyModule)Zlib2).defineClassUnder(context, "Deflate", ZStream2, JZlibDeflate::new)).defineMethods(context, JZlibDeflate.class);
        Access.kernelModule(context).callMethod(context, "require", (IRubyObject)Create.newString(context, "stringio"));
        return Zlib2;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject zlib_version(IRubyObject recv2) {
        return RubyZlib.zlib_version(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"zlib_version"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject zlib_version(ThreadContext context, IRubyObject recv2) {
        return ((RubyModule)recv2).getConstant(context, "ZLIB_VERSION");
    }

    @JRubyMethod(name={"crc32"}, optional=2, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc32(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        ByteList bytes2 = !(args2 = Arity.scanArgs(context, args2, 0, 2))[0].isNil() ? args2[0].convertToString().getByteList() : null;
        long start2 = !args2[1].isNil() ? Convert.toLong(context, args2[1]) : 0L;
        boolean slowPath = (start2 &= 0xFFFFFFFFL) != 0L;
        int bytesLength = bytes2 == null ? 0 : bytes2.length();
        long result2 = 0L;
        if (bytes2 != null) {
            java.util.zip.CRC32 checksum = new java.util.zip.CRC32();
            checksum.update(bytes2.getUnsafeBytes(), bytes2.begin(), bytesLength);
            result2 = checksum.getValue();
        }
        if (slowPath) {
            result2 = JZlib.crc32_combine(start2, result2, bytesLength);
        }
        return Convert.asFixnum(context, result2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject crc32(IRubyObject recv2, IRubyObject[] args2) {
        return RubyZlib.crc32(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(name={"adler32"}, optional=2, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject adler32(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        ByteList bytes2 = !(args2 = Arity.scanArgs(context, args2, 0, 2))[0].isNil() ? args2[0].convertToString().getByteList() : null;
        int start2 = !args2[1].isNil() ? (int)Convert.toLong(context, args2[1]) : 1;
        Adler32 checksum = new Adler32();
        if (bytes2 != null) {
            checksum.update(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        long result2 = checksum.getValue();
        if (start2 != 1) {
            result2 = JZlib.adler32_combine(start2, result2, bytes2.length());
        }
        return Convert.asFixnum(context, result2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject adler32(IRubyObject recv2, IRubyObject[] args2) {
        return RubyZlib.adler32(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(module=true)
    public static IRubyObject inflate(ThreadContext context, IRubyObject recv2, IRubyObject string2) {
        return JZlibInflate.s_inflate(context, recv2, string2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject deflate(IRubyObject recv2, IRubyObject[] args2) {
        return RubyZlib.deflate(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(required=1, optional=1, checkArity=false, module=true)
    public static IRubyObject deflate(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return JZlibDeflate.s_deflate(context, recv2, args2);
    }

    @JRubyMethod(name={"crc_table"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc_table(ThreadContext context, IRubyObject recv2) {
        int[] table = CRC32.getCRC32Table();
        RubyArray<?> result2 = Create.allocArray(context, table.length);
        for (int j : table) {
            result2.append(context, Convert.asFixnum(context, (long)j & 0xFFFFFFFFL));
        }
        return result2;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject crc_table(IRubyObject recv2) {
        return RubyZlib.crc_table(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"crc32_combine"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc32_combine(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        long crc1 = Convert.toLong(context, arg0);
        long crc2 = Convert.toLong(context, arg1);
        long len2 = Convert.toLong(context, arg2);
        return Convert.asFixnum(context, JZlib.crc32_combine(crc1, crc2, len2));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject crc32_combine(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyZlib.crc32_combine(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg0, arg1, arg2);
    }

    @JRubyMethod(name={"adler32_combine"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject adler32_combine(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        long adler1 = Convert.toLong(context, arg0);
        long adler2 = Convert.toLong(context, arg1);
        long len2 = Convert.toLong(context, arg2);
        return Convert.asFixnum(context, JZlib.adler32_combine(adler1, adler2, len2));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject adler32_combine(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyZlib.adler32_combine(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg0, arg1, arg2);
    }

    static RaiseException newZlibError(ThreadContext context, String message2) {
        return RubyZlib.newZlibError(context, "Error", message2);
    }

    static RaiseException newBufError(ThreadContext context, String message2) {
        return RubyZlib.newZlibError(context, "BufError", message2);
    }

    static RaiseException newDictError(ThreadContext context, String message2) {
        return RubyZlib.newZlibError(context, "NeedDict", message2);
    }

    static RaiseException newStreamError(ThreadContext context, String message2) {
        return RubyZlib.newZlibError(context, "StreamError", message2);
    }

    static RaiseException newDataError(ThreadContext context, String message2) {
        return RubyZlib.newZlibError(context, "DataError", message2);
    }

    static RaiseException newZlibError(ThreadContext context, String klass, String message2) {
        return RaiseException.from(context.runtime, Access.getClass(context, "Zlib", klass), message2);
    }

    static RaiseException newGzipFileError(ThreadContext context, String message2) {
        return RubyZlib.newGzipFileError(context, "Error", message2);
    }

    static RaiseException newCRCError(ThreadContext context, String message2) {
        return RubyZlib.newGzipFileError(context, "CRCError", message2);
    }

    static RaiseException newNoFooter(ThreadContext context, String message2) {
        return RubyZlib.newGzipFileError(context, "NoFooter", message2);
    }

    static RaiseException newLengthError(ThreadContext context, String message2) {
        return RubyZlib.newGzipFileError(context, "LengthError", message2);
    }

    static RaiseException newGzipFileError(ThreadContext context, String klass, String message2) {
        RubyClass errorClass = Access.getClass(context, "Zlib", "GzipFile", klass);
        RubyException excn = RubyException.newException(context.runtime, errorClass, message2);
        excn.setInstanceVariable("@input", context.nil);
        return excn.toThrowable();
    }

    static int FIXNUMARG(ThreadContext context, IRubyObject obj, int ifnil) {
        return obj.isNil() ? ifnil : Convert.toInt(context, obj);
    }

    @JRubyClass(name={"Zlib::DataError"}, parent="Zlib::Error")
    public static class DataError
    extends Error {
    }

    @JRubyClass(name={"Zlib::VersionError"}, parent="Zlib::Error")
    public static class VersionError
    extends Error {
    }

    @JRubyClass(name={"Zlib::MemError"}, parent="Zlib::Error")
    public static class MemError
    extends Error {
    }

    @JRubyClass(name={"Zlib::NeedDict"}, parent="Zlib::Error")
    public static class NeedDict
    extends Error {
    }

    @JRubyClass(name={"Zlib::BufError"}, parent="Zlib::Error")
    public static class BufError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamError"}, parent="Zlib::Error")
    public static class StreamError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamEnd"}, parent="Zlib::Error")
    public static class StreamEnd
    extends Error {
    }

    @JRubyClass(name={"Zlib::Error"}, parent="StandardError")
    public static class Error {
    }
}

