/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.thread;

import java.util.concurrent.locks.ReentrantLock;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;

@JRubyClass(name={"Mutex"})
public class Mutex
extends RubyObject
implements DataType {
    final ReentrantLock lock = new ReentrantLock();
    volatile RubyThread lockingThread;

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static Mutex newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Mutex result2 = new Mutex(context.runtime, (RubyClass)recv2);
        result2.callInit(context, args2, block);
        return result2;
    }

    public Mutex(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    public static RubyClass setup(ThreadContext context, RubyClass Thread2, RubyClass Object2) {
        return (RubyClass)Object2.setConstant(context, "Mutex", (IRubyObject)((RubyModule)((RubyClass)Thread2.defineClassUnder(context, "Mutex", Object2, Mutex::new)).reifiedClass(Mutex.class)).defineMethods(context, Mutex.class));
    }

    @JRubyMethod(name={"locked?"})
    public RubyBoolean locked_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isLocked());
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @JRubyMethod
    public RubyBoolean try_lock(ThreadContext context) {
        return Convert.asBoolean(context, this.tryLock(context));
    }

    public boolean tryLock(ThreadContext context) {
        if (this.lock.isHeldByCurrentThread()) {
            return false;
        }
        boolean locked2 = context.getThread().tryLock(this.lock);
        if (locked2) {
            this.lockingThread = context.getThread();
        }
        return locked2;
    }

    @JRubyMethod
    public IRubyObject lock(ThreadContext context) {
        RubyThread thread2 = context.getThread();
        RubyThread parentThread = context.getFiberCurrentThread();
        this.checkRelocking(context);
        RubyThread lockingThread = this.lockingThread;
        if (lockingThread == parentThread && context.getFiber() != lockingThread.getContext().getFiber()) {
            throw context.runtime.newThreadError("deadlock; lock already owned by another fiber belonging to the same thread");
        }
        if (!thread2.tryLock(this.lock)) {
            while (true) {
                try {
                    context.getThread().lockInterruptibly(this.lock);
                }
                catch (InterruptedException ex) {
                    context.pollThreadEvents();
                    continue;
                }
                break;
            }
        }
        try {
            thread2.pollThreadEvents(context);
        }
        catch (Throwable t) {
            if (this.lock.isHeldByCurrentThread()) {
                thread2.unlock(this.lock);
            }
            Helpers.throwException(t);
        }
        this.lockingThread = parentThread;
        return this;
    }

    @JRubyMethod
    public IRubyObject unlock(ThreadContext context) {
        if (!this.isLocked()) {
            throw context.runtime.newThreadError("Mutex is not locked");
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw context.runtime.newThreadError("Mutex is not owned by calling thread");
        }
        boolean hasQueued = this.lock.hasQueuedThreads();
        this.lockingThread = null;
        context.getThread().unlock(this.lock);
        return hasQueued ? context.nil : this;
    }

    @JRubyMethod
    public IRubyObject sleep(ThreadContext context) {
        return this.sleep(context, context.nil);
    }

    @JRubyMethod
    public IRubyObject sleep(ThreadContext context, IRubyObject timeout2) {
        long beg = System.currentTimeMillis();
        try {
            RubyThread thread2 = context.getThread();
            if (timeout2.isNil()) {
                thread2.sleep(this.lock);
            } else {
                double t = RubyTime.convertTimeInterval(context, timeout2);
                long millis = (long)(t * 1000.0);
                if (Double.compare(t, 0.0) != 0 && millis != 0L) {
                    thread2.sleep(this.lock, millis);
                }
            }
        }
        catch (IllegalMonitorStateException imse) {
            throw context.runtime.newThreadError("Attempt to unlock a mutex which is not locked");
        }
        catch (InterruptedException ex) {
            context.pollThreadEvents();
        }
        return Convert.asFixnum(context, (System.currentTimeMillis() - beg) / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject synchronize(ThreadContext context, Block block) {
        this.lock(context);
        try {
            IRubyObject iRubyObject = block.yieldSpecific(context);
            return iRubyObject;
        }
        finally {
            this.unlock(context);
        }
    }

    @JRubyMethod(name={"owned?"})
    public IRubyObject owned_p(ThreadContext context) {
        return Convert.asBoolean(context, this.lock.isHeldByCurrentThread());
    }

    private void checkRelocking(ThreadContext context) {
        if (this.lock.isHeldByCurrentThread()) {
            throw context.runtime.newThreadError("deadlock; recursive locking");
        }
    }
}

