/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyHashLinkedBuckets;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ext.ripper.RipperParser;
import org.jruby.ext.ripper.RipperParserBase;
import org.jruby.ext.ripper.SyntaxException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.ByteListLexerSource;
import org.jruby.lexer.GetsLexerSource;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.LexingCommon;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRipper
extends RubyObject {
    private RipperParserBase parser = null;
    private IRubyObject filename = null;
    private boolean parseStarted = false;
    private static int singleStateLexStateNames = 13;
    private static String[] lexStateNames = new String[]{"BEG", "END", "ENDARG", "ENDFN", "ARG", "CMDARG", "MID", "FNAME", "DOT", "CLASS", "LABEL", "LABELED", "FITEM", "VALUE", "BEG_ANY", "ARG_ANY", "END_ANY"};
    private static int[] lexStateValues = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 1, 577, 48, 14};

    public static RubyClass initRipper(ThreadContext context) {
        RubyClass Ripper = (RubyClass)((RubyModule)((RubyModule)Define.defineClass(context, "Ripper", Access.objectClass(context), RubyRipper::new).defineMethods(context, RubyRipper.class)).defineConstant(context, "SCANNER_EVENT_TABLE", RubyRipper.createScannerEventTable(context))).defineConstant(context, "PARSER_EVENT_TABLE", RubyRipper.createParserEventTable(context));
        RubyRipper.defineLexStateConstants(context, Ripper);
        return Ripper;
    }

    private static void defineLexStateConstants(ThreadContext context, RubyClass ripper2) {
        for (int i2 = 0; i2 < lexStateNames.length; ++i2) {
            ripper2.defineConstant(context, "EXPR_" + lexStateNames[i2], Convert.asFixnum(context, lexStateValues[i2]));
        }
    }

    private static RubyHash createScannerEventTable(ThreadContext context) {
        RubyHashLinkedBuckets hash2 = RubyHashLinkedBuckets.newLBHash(context.runtime);
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "CHAR"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "__end__"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "backref"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "backtick"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "comma"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "comment"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "const"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "cvar"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "embdoc"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "embdoc_beg"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "embdoc_end"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "embexpr_beg"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "embexpr_end"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "embvar"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "float"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "gvar"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "heredoc_beg"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "heredoc_end"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "ident"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "ignored_nl"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "imaginary"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "int"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "ivar"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "kw"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "label"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "label_end"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "lbrace"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "lbracket"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "lparen"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "nl"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "op"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "period"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "qsymbols_beg"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "qwords_beg"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "rational"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "rbrace"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "rbracket"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "regexp_beg"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "regexp_end"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "rparen"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "semicolon"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "sp"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "symbeg"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "symbols_beg"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "tlambda"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "tlambeg"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "tstring_beg"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "tstring_content"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "tstring_end"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "words_beg"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "words_sep"), Convert.asFixnum(context, 1));
        return hash2;
    }

    private static RubyHash createParserEventTable(ThreadContext context) {
        RubyHashLinkedBuckets hash2 = RubyHashLinkedBuckets.newLBHash(context.runtime);
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "BEGIN"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "END"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "alias"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "alias_error"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "aref"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "aref_field"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "arg_ambiguous"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "arg_paren"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "args_add"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "args_add_block"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "args_add_star"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "args_forward"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "args_new"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "array"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "aryptn"), Convert.asFixnum(context, 4));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "assign"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "assign_error"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "assoc_new"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "assoc_splat"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "assoclist_from_args"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "bare_assoc_hash"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "begin"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "binary"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "block_var"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "blockarg"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "bodystmt"), Convert.asFixnum(context, 4));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "brace_block"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "break"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "call"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "case"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "class"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "class_name_error"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "command"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "command_call"), Convert.asFixnum(context, 4));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "const_path_field"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "const_path_ref"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "const_ref"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "def"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "defined"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "defs"), Convert.asFixnum(context, 5));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "do_block"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "dot2"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "dot3"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "dyna_symbol"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "else"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "elsif"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "ensure"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "excessed_comma"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "fcall"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "field"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "fndptn"), Convert.asFixnum(context, 4));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "for"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "hash"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "heredoc_dedent"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "hshptn"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "if"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "if_mod"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "ifop"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "in"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "kwrest_param"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "lambda"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "magic_comment"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "massign"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "method_add_arg"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "method_add_block"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "mlhs_add"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "mlhs_add_post"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "mlhs_add_star"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "mlhs_new"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "mlhs_paren"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "module"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "mrhs_add"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "mrhs_add_star"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "mrhs_new"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "mrhs_new_from_args"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "next"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "nokw_param"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "opassign"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "operator_ambiguous"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "param_error"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "params"), Convert.asFixnum(context, 7));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "paren"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "parse_error"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "program"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "qsymbols_add"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "qsymbols_new"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "qwords_add"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "qwords_new"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "redo"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "regexp_add"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "regexp_literal"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "regexp_new"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "rescue"), Convert.asFixnum(context, 4));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "rescue_mod"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "rest_param"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "retry"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "return"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "return0"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "sclass"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "stmts_add"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "stmts_new"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "string_add"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "string_concat"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "string_content"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "string_dvar"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "string_embexpr"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "string_literal"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "super"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "symbol"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "symbol_literal"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "symbols_add"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "symbols_new"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "top_const_field"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "top_const_ref"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "unary"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "undef"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "unless"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "unless_mod"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "until"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "until_mod"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "var_alias"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "var_field"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "var_ref"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "vcall"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "void_stmt"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "when"), Convert.asFixnum(context, 3));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "while"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "while_mod"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "word_add"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "word_new"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "words_add"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "words_new"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "xstring_add"), Convert.asFixnum(context, 2));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "xstring_literal"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "xstring_new"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "yield"), Convert.asFixnum(context, 1));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "yield0"), Convert.asFixnum(context, 0));
        ((RubyHash)hash2).fastASet(Convert.asSymbol(context, "zsuper"), Convert.asFixnum(context, 0));
        return hash2;
    }

    private RubyRipper(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src) {
        return this.initialize(context, src, null, null);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src, IRubyObject file2) {
        return this.initialize(context, src, file2, null);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src, IRubyObject file2, IRubyObject line) {
        this.filename = this.filenameAsString(context, file2).dup();
        this.parser = new RipperParser(context, this, this.source(context, src, this.filename.asJavaString(), this.lineAsInt(context, line)));
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject column(ThreadContext context) {
        if (!this.parser.hasStarted()) {
            throw Error.argumentError(context, "method called for uninitialized object");
        }
        return !this.parseStarted ? context.nil : Convert.asFixnum(context, this.parser.getColumn());
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext context) {
        return context.runtime.getEncodingService().getEncoding(this.parser.encoding());
    }

    @JRubyMethod(name={"end_seen?"})
    public IRubyObject end_seen_p(ThreadContext context) {
        return Convert.asBoolean(context, this.parser.isEndSeen());
    }

    @JRubyMethod(name={"error?"})
    public IRubyObject error_p(ThreadContext context) {
        return Convert.asBoolean(context, this.parser.isError());
    }

    @JRubyMethod
    public IRubyObject filename(ThreadContext context) {
        return this.filename;
    }

    @JRubyMethod
    public IRubyObject lineno(ThreadContext context) {
        if (!this.parser.hasStarted()) {
            throw Error.argumentError(context, "method called for uninitialized object");
        }
        return !this.parseStarted ? context.nil : Convert.asFixnum(context, this.parser.getLineno());
    }

    @JRubyMethod
    public IRubyObject state(ThreadContext context) {
        int state2 = this.parser.getState();
        return state2 == 0 ? context.nil : Convert.asFixnum(context, state2);
    }

    @JRubyMethod
    public IRubyObject token(ThreadContext context) {
        return context.runtime.newString(this.parser.lexer.tokenByteList());
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext context) {
        this.parseStarted = true;
        try {
            return this.parser.parse(true);
        }
        catch (IOException e) {
            System.out.println("ERRROR: " + String.valueOf(e));
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject yydebug(ThreadContext context) {
        return Convert.asBoolean(context, this.parser.getYYDebug());
    }

    @JRubyMethod(name={"yydebug="})
    public IRubyObject yydebug_set(ThreadContext context, IRubyObject arg2) {
        this.parser.setYYDebug(arg2.isTrue());
        return arg2;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject dedent_string(ThreadContext context, IRubyObject self2, IRubyObject _input, IRubyObject _width) {
        RubyString input = _input.convertToString();
        int wid = Convert.toInt(context, _width);
        input.modifyAndClearCodeRange();
        int col = LexingCommon.dedent_string(input.getByteList(), wid);
        return Convert.asFixnum(context, col);
    }

    @JRubyMethod
    public IRubyObject dedent_string(ThreadContext context, IRubyObject _input, IRubyObject _width) {
        return RubyRipper.dedent_string(context, this, _input, _width);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject lex_state_name(ThreadContext context, IRubyObject self2, IRubyObject lexStateParam) {
        int lexState = Convert.toInt(context, lexStateParam);
        boolean needsSeparator = false;
        RubyString name2 = null;
        for (int i2 = 0; i2 < singleStateLexStateNames; ++i2) {
            if ((lexState & lexStateValues[i2]) == 0) continue;
            if (!needsSeparator) {
                name2 = context.runtime.newString(lexStateNames[i2]);
                needsSeparator = true;
                continue;
            }
            name2.cat(124);
            name2.catString(lexStateNames[i2]);
        }
        if (name2 == null) {
            name2 = context.runtime.newString("EXPR_NONE");
        }
        return name2;
    }

    private LexerSource source(ThreadContext context, IRubyObject src, String filename2, int lineno2) {
        DynamicMethod method2 = src.getMetaClass().searchMethod("gets");
        if (method2.isUndefined() || method2.getVisibility() == Visibility.PRIVATE) {
            return new ByteListLexerSource(filename2, lineno2, src.convertToString().getByteList(), null);
        }
        return new GetsLexerSource(filename2, lineno2, src, null);
    }

    private IRubyObject filenameAsString(ThreadContext context, IRubyObject filename2) {
        if (filename2 == null || filename2.isNil()) {
            return context.runtime.newString("(ripper)");
        }
        return filename2.convertToString();
    }

    private int lineAsInt(ThreadContext context, IRubyObject line) {
        if (line == null || line.isNil()) {
            return 0;
        }
        return Convert.toInt(context, line.convertToInteger()) - 1;
    }
}

