/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.lang.ref.Cleaner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jruby.embed.internal.LocalContext;

class ThreadLocalContext {
    private final ConcurrentHashMap<LocalContextCleaningAction, Object> contextRefs = new ConcurrentHashMap();
    private final Cleaner cleaner = Cleaner.create();
    private final Supplier<LocalContext> localContextFactory;
    private volatile ThreadLocal<AtomicReference<LocalContextCleaningAction>> contextHolder = new ThreadLocal<AtomicReference<LocalContextCleaningAction>>(){

        @Override
        protected AtomicReference<LocalContextCleaningAction> initialValue() {
            LocalContextCleaningAction ctx = new LocalContextCleaningAction(ThreadLocalContext.this.contextRefs, ThreadLocalContext.this.localContextFactory.get());
            AtomicReference<LocalContextCleaningAction> ref = new AtomicReference<LocalContextCleaningAction>(ctx);
            Cleaner.Cleanable cleanable = ThreadLocalContext.this.cleaner.register(ref, ctx);
            if (ThreadLocalContext.this.contextHolder == null) {
                cleanable.clean();
            }
            return ref;
        }
    };

    public ThreadLocalContext(Supplier<LocalContext> localContextFactory) {
        this.localContextFactory = localContextFactory;
    }

    public LocalContext get() {
        return (LocalContext)this.contextHolder.get().get().get();
    }

    public void terminate() {
        this.contextHolder = null;
        for (LocalContextCleaningAction ref : this.contextRefs.keySet()) {
            ref.run();
        }
    }

    private static class LocalContextCleaningAction
    extends AtomicReference<LocalContext>
    implements Runnable {
        private static final long serialVersionUID = 1L;
        private final ConcurrentHashMap<LocalContextCleaningAction, Object> contextRefs;

        private LocalContextCleaningAction(ConcurrentHashMap<LocalContextCleaningAction, Object> contextRefs, LocalContext context) {
            super(context);
            this.contextRefs = contextRefs;
            contextRefs.put(this, this);
        }

        @Override
        public void run() {
            LocalContext lc = this.getAndSet(null);
            if (lc != null) {
                lc.remove();
            }
            this.contextRefs.remove(this);
        }
    }
}

