/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import com.headius.backport9.stack.StackWalker;
import java.io.ByteArrayOutputStream;
import java.lang.invoke.CallSite;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import jnr.constants.platform.Errno;
import jnr.posix.POSIX;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyEnumerator;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyRandom;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.RubyTime;
import org.jruby.RubyUnboundMethod;
import org.jruby.RubyUncaughtThrowError;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Access;
import org.jruby.api.Check;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.RubyWarnings;
import org.jruby.exceptions.CatchThrow;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.ShellLauncher;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;
import org.jruby.util.func.ObjectIntIntFunction;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PopenExecutor;

@JRubyModule(name={"Kernel"})
public class RubyKernel {
    private static BigInteger SIXTEEN = BigInteger.valueOf(16L);
    private static BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    private static final ByteList uncaught_throw_p = new ByteList(new byte[]{117, 110, 99, 97, 117, 103, 104, 116, 32, 116, 104, 114, 111, 119, 32, 37, 112});

    public static RubyModule finishKernelModule(ThreadContext context, RubyModule Kernel2, RubyInstanceConfig config2) {
        Kernel2.defineMethods(context, RubyKernel.class);
        Kernel2.set(2, false);
        Ruby runtime2 = context.runtime;
        runtime2.setPrivateMethodMissing(new MethodMissingMethod(Kernel2, Visibility.PRIVATE, CallType.NORMAL));
        runtime2.setProtectedMethodMissing(new MethodMissingMethod(Kernel2, Visibility.PROTECTED, CallType.NORMAL));
        runtime2.setVariableMethodMissing(new MethodMissingMethod(Kernel2, Visibility.PUBLIC, CallType.VARIABLE));
        runtime2.setSuperMethodMissing(new MethodMissingMethod(Kernel2, Visibility.PUBLIC, CallType.SUPER));
        runtime2.setNormalMethodMissing(new MethodMissingMethod(Kernel2, Visibility.PUBLIC, CallType.NORMAL));
        if (config2.isAssumeLoop()) {
            Kernel2.defineMethods(context, LoopMethods.class);
        }
        if (config2.getKernelGsubDefined()) {
            MethodIndex.addMethodReadFields("gsub", FrameField.LASTLINE, FrameField.BACKREF);
            Kernel2.addMethod(context, "gsub", new JavaMethod(Kernel2, Visibility.PRIVATE, "gsub"){

                @Override
                public IRubyObject call(ThreadContext context1, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    return switch (args2.length) {
                        case 1 -> RubyKernel.gsub(context1, self2, args2[0], block);
                        case 2 -> RubyKernel.gsub(context1, self2, args2[0], args2[1], block);
                        default -> throw Error.argumentError(context1, String.format("wrong number of arguments %d for 1..2", args2.length));
                    };
                }
            });
        }
        RubyKernel.recacheBuiltinMethods(runtime2, Kernel2);
        return Kernel2;
    }

    static void recacheBuiltinMethods(Ruby runtime2, RubyModule kernelModule) {
        runtime2.setRespondToMethod(kernelModule.searchMethod("respond_to?"));
        runtime2.setRespondToMissingMethod(kernelModule.searchMethod("respond_to_missing?"));
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject at_exit(ThreadContext context, IRubyObject recv2, Block block) {
        if (!block.isGiven()) {
            throw Error.argumentError(context, "called without a block");
        }
        return context.runtime.pushExitBlock(context.runtime.newProc(Block.Type.PROC, block));
    }

    @JRubyMethod(name={"autoload?"}, required=1, module=true, visibility=Visibility.PRIVATE, reads={FrameField.SCOPE})
    public static IRubyObject autoload_p(ThreadContext context, IRubyObject recv2, IRubyObject symbol) {
        RubyModule module = IRRuntimeHelpers.getCurrentClassBase(context, recv2);
        return module == null || module.isNil() ? context.nil : module.autoload_p(context, symbol);
    }

    @JRubyMethod(required=2, module=true, visibility=Visibility.PRIVATE, reads={FrameField.SCOPE})
    public static IRubyObject autoload(ThreadContext context, IRubyObject recv2, IRubyObject symbol, IRubyObject file2) {
        RubyModule module = IRRuntimeHelpers.getCurrentClassBase(context, recv2).getRealModule();
        if (module == null || module.isNil()) {
            throw Error.typeError(context, "Can not set autoload on singleton class");
        }
        return module.autoload(context, symbol, file2);
    }

    public static IRubyObject method_missing(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        Visibility lastVis = context.getLastVisibility();
        CallType lastCallType = context.getLastCallType();
        if (args2.length == 0 || !((iRubyObject = args2[0]) instanceof RubySymbol)) {
            throw Error.argumentError(context, "no id given");
        }
        RubySymbol sym = (RubySymbol)iRubyObject;
        return RubyKernel.methodMissingDirect(context, recv2, sym, lastVis, lastCallType, args2);
    }

    protected static IRubyObject methodMissingDirect(ThreadContext context, IRubyObject recv2, RubySymbol symbol, Visibility lastVis, CallType lastCallType, IRubyObject[] args2) {
        return RubyKernel.methodMissing(context, recv2, symbol.idString(), lastVis, lastCallType, args2, true);
    }

    public static IRubyObject methodMissing(ThreadContext context, IRubyObject recv2, String name2, Visibility lastVis, CallType lastCallType, IRubyObject[] args2) {
        return RubyKernel.methodMissing(context, recv2, name2, lastVis, lastCallType, args2, false);
    }

    public static IRubyObject methodMissing(ThreadContext context, IRubyObject recv2, String name2, Visibility lastVis, CallType lastCallType, IRubyObject[] args2, boolean dropFirst) {
        Ruby runtime2 = context.runtime;
        boolean privateCall = false;
        if (lastCallType == CallType.VARIABLE || lastCallType == CallType.FUNCTIONAL) {
            privateCall = true;
        } else if (lastVis == Visibility.PUBLIC) {
            privateCall = true;
        }
        if (lastCallType == CallType.VARIABLE) {
            throw runtime2.newNameError(RubyKernel.getMethodMissingFormat(lastVis, lastCallType), recv2, name2, privateCall);
        }
        throw runtime2.newNoMethodError(RubyKernel.getMethodMissingFormat(lastVis, lastCallType), recv2, name2, RubyArray.newArrayMayCopy(runtime2, args2, dropFirst ? 1 : 0), privateCall);
    }

    private static String getMethodMissingFormat(Visibility visibility, CallType callType) {
        String format = "undefined method '%s' for %s%s%s";
        if (visibility == Visibility.PRIVATE) {
            format = "private method '%s' called for %s%s%s";
        } else if (visibility == Visibility.PROTECTED) {
            format = "protected method '%s' called for %s%s%s";
        } else if (callType == CallType.VARIABLE) {
            format = "undefined local variable or method '%s' for %s%s%s";
        } else if (callType == CallType.SUPER) {
            format = "super: no superclass method '%s' for %s%s%s";
        }
        return format;
    }

    @JRubyMethod(name={"open"}, required=1, optional=3, checkArity=false, module=true, visibility=Visibility.PRIVATE, keywords=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        boolean redirect = false;
        int callInfo = ThreadContext.resetCallInfo(context);
        boolean keywords = ThreadContext.hasKeywords(callInfo);
        if (args2.length >= 1) {
            if (args2[0].respondsTo("to_open")) {
                redirect = true;
            } else {
                IRubyObject tmp = args2[0];
                if ((tmp = RubyFile.get_path(context, tmp)) == context.nil) {
                    redirect = true;
                } else {
                    IRubyObject cmd = PopenExecutor.checkPipeCommand(context, tmp);
                    if (cmd != context.nil) {
                        Warn.warnDeprecatedForRemovalAlternate(context, "Calling Kernel#open with a leading '|'", "4.0", "IO.popen");
                        if (PopenExecutor.nativePopenAvailable(context.runtime)) {
                            args2[0] = cmd;
                            return PopenExecutor.popen(context, args2, Access.ioClass(context), block);
                        }
                        throw Error.argumentError(context, "pipe open is not supported without native subprocess logic");
                    }
                }
            }
        }
        int maxArgs = keywords ? 5 : 4;
        Arity.checkArgumentCount(context, args2, 1, maxArgs);
        if (redirect) {
            if (keywords) {
                context.callInfo = 2;
            }
            IRubyObject io2 = args2[0].callMethod(context, "to_open", Arrays.copyOfRange(args2, 1, args2.length));
            RubyIO.ensureYieldClose(context, io2, block);
            return io2;
        }
        context.callInfo = callInfo;
        return RubyIO.open(context, Access.fileClass(context), args2, block);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject getc(ThreadContext context, IRubyObject recv2) {
        Warn.warn(context, "getc is obsolete; use STDIN.getc instead");
        IRubyObject defin = Access.globalVariables(context).get("$stdin");
        return RubyKernel.sites((ThreadContext)context).getc.call(context, defin, defin);
    }

    @JRubyMethod(optional=1, keywords=true, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gets(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject ArgsFile = Access.argsFile(context);
        return recv2 == ArgsFile ? RubyArgsFile.gets(context, ArgsFile, args2) : RubyKernel.sites((ThreadContext)context).gets.call(context, ArgsFile, ArgsFile, args2);
    }

    @JRubyMethod(optional=1, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        RubyString message2 = null;
        if (argc == 1) {
            message2 = args2[0].convertToString();
            IRubyObject stderr = Access.globalVariables(context).get("$stderr");
            RubyKernel.sites((ThreadContext)context).puts.call(context, stderr, stderr, (IRubyObject)message2);
        }
        throw RubyKernel.exit(context, new IRubyObject[]{context.fals, message2}, false);
    }

    @JRubyMethod(name={"Array"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_array(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return TypeConverter.rb_Array(context, object);
    }

    @JRubyMethod(name={"Complex"}, required=1, optional=1, keywords=true, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject a2;
        IRubyObject a1;
        boolean raise2 = true;
        int argc = args2.length;
        IRubyObject opts = IRRuntimeHelpers.receiveKeywords(context, args2, false, true, false);
        if (opts instanceof RubyHash) {
            --argc;
        }
        switch (argc) {
            case 1: {
                a1 = args2[0];
                a2 = null;
                break;
            }
            case 2: {
                a1 = args2[0];
                a2 = args2[1];
                break;
            }
            default: {
                Arity.raiseArgumentError(context, argc, 1, 2);
                return null;
            }
        }
        if (opts instanceof RubyHash) {
            RubyHash kwargs = (RubyHash)opts;
            raise2 = ArgsUtil.hasExceptionOption(context, kwargs, raise2);
        }
        RubyClass Complex2 = context.runtime.getComplex();
        if (args2.length > 0 && a1.getMetaClass() == Complex2 && a2 == null) {
            return a1;
        }
        return RubyComplex.convertCommon(context, Complex2, a1, a2, raise2);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        RubyClass rational = context.runtime.getRational();
        return RubyKernel.sites((ThreadContext)context).convert_rational.call(context, (IRubyObject)rational, (IRubyObject)rational, arg0);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        RubyClass rational = context.runtime.getRational();
        return RubyKernel.sites((ThreadContext)context).convert_rational.call(context, (IRubyObject)rational, (IRubyObject)rational, arg0, arg1);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        RubyClass rational = context.runtime.getRational();
        return RubyKernel.sites((ThreadContext)context).convert_rational.call(context, (IRubyObject)rational, (IRubyObject)rational, arg0, arg1, arg2);
    }

    @JRubyMethod(name={"Float"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_float(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return RubyKernel.new_float(context, object, true);
    }

    @JRubyMethod(name={"Float"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_float(ThreadContext context, IRubyObject recv2, IRubyObject object, IRubyObject opts) {
        boolean exception2 = RubyKernel.checkExceptionOpt(context, context.runtime.getFloat(), opts);
        return RubyKernel.new_float(context, object, exception2);
    }

    private static boolean checkExceptionOpt(ThreadContext context, RubyClass rubyClass, IRubyObject opts) {
        IRubyObject maybeOpts = ArgsUtil.getOptionsArg(context.runtime, opts, false);
        if (maybeOpts.isNil()) {
            return true;
        }
        IRubyObject exObj = ArgsUtil.extractKeywordArg(context, opts, "exception");
        if (exObj != context.tru && exObj != context.fals) {
            throw Error.argumentError(context, "'" + rubyClass.getName(context) + "': expected true or false as exception: " + String.valueOf(exObj));
        }
        return exObj.isTrue();
    }

    @Deprecated(since="10.0.0.0")
    public static RubyFloat new_float(IRubyObject recv2, IRubyObject object) {
        return (RubyFloat)RubyKernel.new_float(((RubyBasicObject)recv2).getCurrentContext(), object, true);
    }

    public static RubyFloat new_float(Ruby runtime2, IRubyObject object) {
        return (RubyFloat)RubyKernel.new_float(runtime2.getCurrentContext(), object, true);
    }

    public static RubyFloat new_float(ThreadContext context, IRubyObject object) {
        return (RubyFloat)RubyKernel.new_float(context, object, true);
    }

    private static RaiseException floatError(ThreadContext context, ByteList string2) {
        throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "invalid value for Float(): ", Create.newString(context, string2)));
    }

    @Deprecated(since="10.0.0.0")
    public static double parseHexidecimalExponentString2(Ruby runtime2, ByteList str) {
        return RubyKernel.parseHexidecimalExponentString2(runtime2.getCurrentContext(), str);
    }

    public static double parseHexidecimalExponentString2(ThreadContext context, ByteList str) {
        int digit;
        byte[] bytes2 = str.unsafeBytes();
        int length2 = str.length();
        if (length2 <= 2) {
            throw RubyKernel.floatError(context, str);
        }
        int sign2 = 1;
        int i2 = str.begin();
        byte letter = bytes2[i2];
        if (letter != 43 && letter == 45) {
            sign2 = -1;
            ++i2;
        }
        int n = ++i2;
        ++i2;
        letter = bytes2[n];
        if (letter != 48) {
            throw RubyKernel.floatError(context, str);
        }
        if ((letter = bytes2[i2++]) != 120) {
            throw RubyKernel.floatError(context, str);
        }
        int exponent2 = 0;
        int explicitExponent = 0;
        int explicitExponentSign = 1;
        boolean periodFound = false;
        boolean explicitExponentFound = false;
        BigInteger value2 = BigInteger.valueOf(0L);
        if (i2 == length2 || bytes2[i2] == 95 || bytes2[i2] == 112 || bytes2[i2] == 80) {
            throw RubyKernel.floatError(context, str);
        }
        while (i2 < length2 && !explicitExponentFound) {
            letter = bytes2[i2];
            switch (letter) {
                case 46: {
                    periodFound = true;
                    break;
                }
                case 80: 
                case 112: {
                    if (bytes2[i2 - 1] == 95 || i2 == length2 - 1) {
                        throw RubyKernel.floatError(context, str);
                    }
                    explicitExponentFound = true;
                    break;
                }
                case 95: {
                    break;
                }
                default: {
                    digit = Character.digit(letter, 16);
                    if (Character.forDigit(digit, 16) == '\u0000') {
                        throw RubyKernel.floatError(context, str);
                    }
                    value2 = value2.multiply(SIXTEEN).add(BigInteger.valueOf(digit));
                    if (!periodFound) break;
                    ++exponent2;
                }
            }
            ++i2;
        }
        if (explicitExponentFound) {
            if (bytes2[i2] == 45) {
                explicitExponentSign = -1;
                ++i2;
            } else if (bytes2[i2] == 43) {
                ++i2;
            } else if (bytes2[i2] == 95) {
                throw RubyKernel.floatError(context, str);
            }
            while (i2 < length2) {
                letter = bytes2[i2];
                if (letter == 95) {
                    if (i2 == length2 - 1) {
                        throw RubyKernel.floatError(context, str);
                    }
                } else {
                    digit = Character.digit(letter, 10);
                    if (Character.forDigit(digit, 10) == '\u0000') {
                        throw RubyKernel.floatError(context, str);
                    }
                    explicitExponent = explicitExponent * 10 + digit;
                }
                ++i2;
            }
        }
        int scaleFactor = 4 * exponent2 - explicitExponent * explicitExponentSign;
        return (double)sign2 * Math.scalb(value2.doubleValue(), -scaleFactor);
    }

    public static IRubyObject new_float(ThreadContext context, IRubyObject object, boolean exception2) {
        Ruby runtime2;
        block14: {
            runtime2 = context.runtime;
            if (object instanceof RubyInteger) {
                return RubyKernel.new_float(context, (RubyInteger)object);
            }
            if (object instanceof RubyFloat) {
                return object;
            }
            if (object instanceof RubyString) {
                RubyString str = (RubyString)object;
                str.verifyAsciiCompatible();
                ByteList bytes2 = str.getByteList();
                if (bytes2.isEmpty()) {
                    if (!exception2) {
                        return context.nil;
                    }
                    throw Error.argumentError(context, "invalid value for Float(): " + String.valueOf(object.inspect(context)));
                }
                if (RubyKernel.isHexValue(bytes2)) {
                    if (bytes2.indexOf(112) != -1 || bytes2.indexOf(80) != -1) {
                        return Convert.asFloat(context, RubyKernel.parseHexidecimalExponentString2(context, bytes2));
                    }
                    IRubyObject inum = ConvertBytes.byteListToInum(runtime2, bytes2, 16, true, exception2);
                    if (!exception2 && inum.isNil()) {
                        return inum;
                    }
                    return ((RubyInteger)inum).toFloat();
                }
                return RubyNumeric.str2fnum(runtime2, str, true, exception2);
            }
            if (object.isNil()) {
                if (exception2) {
                    throw Error.typeError(context, "can't convert nil into Float");
                }
                return object;
            }
            try {
                IRubyObject flote = TypeConverter.convertToType(context, object, runtime2.getFloat(), RubyKernel.sites((ThreadContext)context).to_f_checked, false);
                if (flote instanceof RubyFloat) {
                    return flote;
                }
            }
            catch (RaiseException re) {
                if (!exception2) break block14;
                throw re;
            }
        }
        if (!exception2) {
            return context.nil;
        }
        return TypeConverter.handleUncoercibleObject(runtime2, object, runtime2.getFloat(), true);
    }

    static RubyFloat new_float(ThreadContext context, RubyInteger num) {
        double d;
        if (num instanceof RubyBignum) {
            RubyBignum big = (RubyBignum)num;
            d = RubyBignum.big2dbl(big);
        } else {
            d = num.asDouble(context);
        }
        return Convert.asFloat(context, d);
    }

    static RubyFloat new_float(Ruby runtime2, RubyInteger num) {
        if (num instanceof RubyBignum) {
            return RubyFloat.newFloat(runtime2, RubyBignum.big2dbl((RubyBignum)num));
        }
        return RubyFloat.newFloat(runtime2, num.getDoubleValue());
    }

    static boolean isHexValue(ByteList bytes2) {
        int length2 = bytes2.getRealSize();
        int index2 = length2 >= 1 && bytes2.get(0) == 45 ? 1 : 0;
        return length2 >= index2 + 2 && bytes2.get(index2) == 48 && (bytes2.get(index2 + 1) == 120 || bytes2.get(index2 + 1) == 88);
    }

    @JRubyMethod(name={"Hash"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_hash(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        if (arg2 == context.nil) {
            return Create.newHash(context);
        }
        IRubyObject tmp = TypeConverter.checkHashType(context, RubyKernel.sites((ThreadContext)context).to_hash_checked, arg2);
        if (tmp == context.nil) {
            if (arg2 instanceof RubyArray && ((RubyArray)arg2).isEmpty()) {
                return Create.newHash(context);
            }
            throw Error.typeError(context, "can't convert ", arg2, " into Hash");
        }
        return tmp;
    }

    @JRubyMethod(name={"Integer"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_integer(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        return TypeConverter.convertToInteger(context, object, 0, true);
    }

    @JRubyMethod(name={"Integer"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_integer(ThreadContext context, IRubyObject recv2, IRubyObject object, IRubyObject baseOrOpts) {
        IRubyObject maybeOpts = ArgsUtil.getOptionsArg(context.runtime, baseOrOpts, false);
        if (maybeOpts.isNil()) {
            return TypeConverter.convertToInteger(context, object, Convert.toInt(context, baseOrOpts), true);
        }
        boolean exception2 = RubyKernel.checkExceptionOpt(context, Access.integerClass(context), maybeOpts);
        return TypeConverter.convertToInteger(context, object, 0, exception2);
    }

    @JRubyMethod(name={"Integer"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_integer(ThreadContext context, IRubyObject recv2, IRubyObject object, IRubyObject base, IRubyObject opts) {
        boolean exception2 = RubyKernel.checkExceptionOpt(context, context.runtime.getInteger(), opts);
        IRubyObject baseInteger = TypeConverter.convertToInteger(context, base, 0, exception2);
        return baseInteger.isNil() ? baseInteger : TypeConverter.convertToInteger(context, object, ((RubyInteger)baseInteger).asInt(context), exception2);
    }

    @JRubyMethod(name={"String"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_string(ThreadContext context, IRubyObject recv2, IRubyObject object) {
        JavaSites.KernelSites sites = RubyKernel.sites(context);
        IRubyObject tmp = TypeConverter.checkStringType(context, sites.to_str_checked, object, Access.stringClass(context));
        if (tmp == context.nil) {
            tmp = TypeConverter.convertToType(context, object, Access.stringClass(context), RubyKernel.sites((ThreadContext)context).to_s_checked);
        }
        return tmp;
    }

    @JRubyMethod(rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject p(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyThread.uninterruptible(context, args2, RubyKernel::pBody);
    }

    private static IRubyObject pBody(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        int argc = args2.length;
        RubyArray<?> ret = context.nil;
        IRubyObject defout = Access.globalVariables(context).get("$>");
        IRubyObject defaultRS = Access.globalVariables(context).getDefaultSeparator();
        boolean defoutWriteBuiltin = defout instanceof RubyIO && defout.getMetaClass().isMethodBuiltin("write");
        for (int i2 = 0; i2 < argc; ++i2) {
            IRubyObject obj = args2[i2];
            IRubyObject str = RubyBasicObject.rbInspect(context, obj);
            if (defoutWriteBuiltin) {
                ((RubyIO)defout).write(context, str, true);
                ((RubyIO)defout).write(context, defaultRS, true);
                continue;
            }
            RubyIO.write(context, defout, str);
            RubyIO.write(context, defout, defaultRS);
        }
        if (argc == 1) {
            ret = args2[0];
        } else if (argc > 1) {
            ret = RubyArray.newArray(runtime2, args2);
        }
        if (defout instanceof RubyIO) {
            ((RubyIO)defout).flush(context);
        }
        return ret;
    }

    @JRubyMethod(module=true)
    public static IRubyObject public_method(ThreadContext context, IRubyObject recv2, IRubyObject symbol) {
        return recv2.getMetaClass().newMethod(context, recv2, symbol.asJavaString(), null, true, Visibility.PUBLIC, true, false);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject putc(ThreadContext context, IRubyObject recv2, IRubyObject ch) {
        IRubyObject defout = Access.globalVariables(context).get("$>");
        if (recv2 == defout) {
            return RubyIO.putc(context, recv2, ch);
        }
        return RubyKernel.sites((ThreadContext)context).putc.call(context, defout, defout, ch);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2) {
        IRubyObject defout = Access.globalVariables(context).get("$>");
        if (recv2 == defout) {
            return RubyIO.puts0(context, recv2);
        }
        return RubyKernel.sites((ThreadContext)context).puts.call(context, defout, defout);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        IRubyObject defout = Access.globalVariables(context).get("$>");
        if (recv2 == defout) {
            return RubyIO.puts1(context, recv2, arg0);
        }
        return RubyKernel.sites((ThreadContext)context).puts.call(context, defout, defout, arg0);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject defout = Access.globalVariables(context).get("$>");
        if (recv2 == defout) {
            return RubyIO.puts2(context, recv2, arg0, arg1);
        }
        return RubyKernel.sites((ThreadContext)context).puts.call(context, defout, defout, arg0, arg1);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject defout = Access.globalVariables(context).get("$>");
        if (recv2 == defout) {
            return RubyIO.puts3(context, recv2, arg0, arg1, arg2);
        }
        return RubyKernel.sites((ThreadContext)context).puts.call(context, defout, defout, arg0, arg1, arg2);
    }

    @JRubyMethod(rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject defout = Access.globalVariables(context).get("$>");
        if (recv2 == defout) {
            return RubyIO.puts(context, recv2, args2);
        }
        return RubyKernel.sites((ThreadContext)context).puts.call(context, defout, defout, args2);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE})
    public static IRubyObject print(ThreadContext context, IRubyObject recv2) {
        return RubyIO.print0(context, Access.globalVariables(context).get("$>"));
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject print(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
        return RubyIO.print1(context, Access.globalVariables(context).get("$>"), arg0);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject print(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return RubyIO.print2(context, Access.globalVariables(context).get("$>"), arg0, arg1);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject print(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyIO.print3(context, Access.globalVariables(context).get("$>"), arg0, arg1, arg2);
    }

    @JRubyMethod(rest=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE})
    public static IRubyObject print(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.print(context, Access.globalVariables(context).get("$>"), args2);
    }

    @JRubyMethod(rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject printf(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject out;
        if (args2.length == 0) {
            return context.nil;
        }
        if (args2[0] instanceof RubyString) {
            out = Access.globalVariables(context).get("$>");
        } else {
            out = args2[0];
            args2 = Arrays.copyOfRange(args2, 1, args2.length);
        }
        RubyIO.write(context, out, RubyKernel.sprintf(context, recv2, args2));
        return context.nil;
    }

    @JRubyMethod(optional=1, keywords=true, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line = RubyKernel.gets(context, recv2, args2);
        if (line.isNil()) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    @JRubyMethod(optional=1, keywords=true, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArgsFile.readlines(context, Access.argsFile(context), args2);
    }

    @JRubyMethod(name={"respond_to_missing?"}, visibility=Visibility.PRIVATE)
    public static IRubyObject respond_to_missing_p(ThreadContext context, IRubyObject recv2, IRubyObject symbol) {
        return context.fals;
    }

    @JRubyMethod(name={"respond_to_missing?"}, visibility=Visibility.PRIVATE)
    public static IRubyObject respond_to_missing_p(ThreadContext context, IRubyObject recv2, IRubyObject symbol, IRubyObject isPrivate) {
        return context.fals;
    }

    private static RubyString getLastlineString(ThreadContext context) {
        IRubyObject line = context.getLastLine();
        if (line.isNil()) {
            throw Error.typeError(context, "$_ value need to be String (nil given).");
        }
        if (!(line instanceof RubyString)) {
            throw Error.typeError(context, "$_ value need to be String (", line, " given).");
        }
        return (RubyString)line;
    }

    @JRubyMethod(required=1, optional=3, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject select(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyIO.select(context, recv2, args2);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sleep(ThreadContext context, IRubyObject recv2) {
        return RubyKernel.sleepCommon(context, 0L);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sleep(ThreadContext context, IRubyObject recv2, IRubyObject timeout2) {
        if (timeout2.isNil()) {
            return RubyKernel.sleep(context, recv2);
        }
        long nanoseconds = (long)(RubyTime.convertTimeInterval(context, timeout2) * 1.0E9);
        if (nanoseconds == 0L) {
            return RubyFixnum.zero(context.runtime);
        }
        return RubyKernel.sleepCommon(context, nanoseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RubyFixnum sleepCommon(ThreadContext context, long nanoseconds) {
        long startTime = System.nanoTime();
        RubyThread rubyThread = context.getThread();
        boolean interrupted = false;
        try {
            long loopStartTime;
            do {
                long remainingNanos;
                loopStartTime = System.nanoTime();
                long milliseconds = TimeUnit.NANOSECONDS.toMillis(nanoseconds);
                if (rubyThread.sleep(milliseconds, remainingNanos = nanoseconds - TimeUnit.MILLISECONDS.toNanos(milliseconds))) continue;
                break;
            } while ((nanoseconds -= System.nanoTime() - loopStartTime) > 0L);
        }
        catch (InterruptedException ie) {
            interrupted = true;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return Convert.asFixnum(context, Math.round((double)(System.nanoTime() - startTime) / 1.0E9));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject exit(IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.exit(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        throw RubyKernel.exit(context, args2, false);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject exit_bang(IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.exit_bang(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(name={"exit!"}, optional=1, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        throw RubyKernel.exit(context, args2, true);
    }

    private static RuntimeException exit(ThreadContext context, IRubyObject[] args2, boolean hard) {
        IRubyObject iRubyObject;
        int status2 = hard ? 1 : 0;
        String message2 = null;
        if (args2.length > 0) {
            RubyObject argument = (RubyObject)args2[0];
            status2 = argument instanceof RubyBoolean ? (argument.isFalse() ? 1 : 0) : Convert.toInt(context, argument);
        }
        if (args2.length == 2 && (iRubyObject = args2[1]) instanceof RubyString) {
            RubyString string2 = (RubyString)iRubyObject;
            message2 = string2.toString();
        }
        if (hard) {
            if (context.runtime.getInstanceConfig().isHardExit()) {
                System.exit(status2);
            } else {
                return new MainExitException(status2, true);
            }
        }
        return message2 == null ? context.runtime.newSystemExit(status2) : context.runtime.newSystemExit(status2, message2);
    }

    @JRubyMethod(name={"global_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray global_variables(ThreadContext context, IRubyObject recv2) {
        GlobalVariables globals = Access.globalVariables(context);
        RubyArray<?> globalVariables = Create.allocArray(context, globals.size());
        globals.eachName(context, globalVariables, (c, g, s2) -> g.append((ThreadContext)c, Convert.asSymbol(c, s2)));
        return globalVariables;
    }

    @JRubyMethod(name={"local_variables"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.SCOPE})
    public static RubyArray local_variables(ThreadContext context, IRubyObject recv2) {
        return context.getCurrentStaticScope().getLocalVariables(context);
    }

    @JRubyMethod(name={"binding"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public static RubyBinding binding(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyBinding.newBinding(context.runtime, context.currentBinding());
    }

    @JRubyMethod(name={"block_given?", "iterator?"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.BLOCK})
    public static RubyBoolean block_given_p(ThreadContext context, IRubyObject recv2) {
        return Convert.asBoolean(context, context.getCurrentFrame().getBlock().isGiven());
    }

    public static RubyBoolean blockGiven(ThreadContext context, IRubyObject recv2, Block frameBlock) {
        return Convert.asBoolean(context, frameBlock.isGiven());
    }

    @JRubyMethod(name={"sprintf", "format"}, required=1, rest=true, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sprintf(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject arg2;
        if (args2.length == 0) {
            throw Error.argumentError(context, "sprintf must have at least one argument");
        }
        RubyString str = RubyString.stringValue(args2[0]);
        if (args2.length == 2 && args2[1] instanceof RubyHash) {
            arg2 = args2[1];
        } else {
            RubyArray newArgs = RubyArray.newArrayMayCopy(context.runtime, args2);
            newArgs.shift(context);
            arg2 = newArgs;
        }
        return str.op_format(context, arg2);
    }

    @Deprecated(since="9.2.5.0")
    public static IRubyObject sprintf(IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.sprintf(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    public static IRubyObject raise(ThreadContext context, IRubyObject self2, IRubyObject arg0) {
        RubyHash opt;
        if (arg0 instanceof RubyHash && !(opt = (RubyHash)arg0).isEmpty() && opt.has_key_p(context, Convert.asSymbol(context, "cause")) == context.tru) {
            throw Error.argumentError(context, "only cause is given with no arguments");
        }
        IRubyObject cause2 = context.getErrorInfo();
        RubyKernel.maybeRaiseJavaException(context, arg0);
        RaiseException raise2 = arg0 instanceof RubyString ? ((RubyException)context.runtime.getRuntimeError().newInstance(context, arg0)).toThrowable() : RubyKernel.convertToException(context, arg0, null).toThrowable();
        RubyException exception2 = raise2.getException();
        if (context.runtime.isDebug()) {
            RubyKernel.printExceptionSummary(context, exception2);
        }
        if (exception2.getCause() == null && cause2 != exception2) {
            exception2.setCause(cause2);
        }
        throw raise2;
    }

    @JRubyMethod(name={"raise", "fail"}, optional=3, checkArity=false, module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject raise(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubySymbol key2;
        RubyHash opt;
        IRubyObject last2;
        int argc = Arity.checkArgumentCount(context, args2, 0, 3);
        boolean forceCause = false;
        IRubyObject cause2 = null;
        if (argc > 0 && (last2 = args2[argc - 1]) instanceof RubyHash && !(opt = (RubyHash)last2).isEmpty() && opt.has_key_p(context, key2 = Convert.asSymbol(context, "cause")) == context.tru) {
            cause2 = opt.delete(context, key2, Block.NULL_BLOCK);
            forceCause = true;
            if (opt.isEmpty() && --argc == 0) {
                throw Error.argumentError(context, "only cause is given with no arguments");
            }
        }
        if (argc > 0 && cause2 == null) {
            cause2 = context.getErrorInfo();
        }
        RubyKernel.maybeRaiseJavaException(context, args2, argc);
        RaiseException raise2 = switch (argc) {
            case 0 -> {
                IRubyObject lastException = Access.globalVariables(context).get("$!");
                if (lastException.isNil()) {
                    yield RaiseException.from(context.runtime, Access.runtimeErrorClass(context), "");
                }
                yield ((RubyException)lastException).toThrowable();
            }
            case 1 -> {
                if (args2[0] instanceof RubyString) {
                    yield ((RubyException)Access.runtimeErrorClass(context).newInstance(context, args2, block)).toThrowable();
                }
                yield RubyKernel.convertToException(context, args2[0], null).toThrowable();
            }
            case 2 -> RubyKernel.convertToException(context, args2[0], args2[1]).toThrowable();
            default -> {
                RubyException exception = RubyKernel.convertToException(context, args2[0], args2[1]);
                exception.setBacktrace(context, args2[2]);
                yield exception.toThrowable();
            }
        };
        RubyException exception2 = raise2.getException();
        if (context.runtime.isDebug()) {
            RubyKernel.printExceptionSummary(context, exception2);
        }
        if (forceCause || argc > 0 && exception2.getCause() == null && cause2 != exception2) {
            exception2.setCause(cause2);
        }
        throw raise2;
    }

    private static void maybeRaiseJavaException(ThreadContext context, IRubyObject[] args2, int argc) {
        IRubyObject maybeException = null;
        switch (argc) {
            case 0: {
                maybeException = Access.globalVariables(context).get("$!");
                break;
            }
            case 1: {
                if (args2.length != 1) break;
                maybeException = args2[0];
            }
        }
        RubyKernel.maybeRaiseJavaException(context, maybeException);
    }

    private static void maybeRaiseJavaException(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof ConcreteJavaProxy) {
            Object maybeThrowable = ((ConcreteJavaProxy)arg2).getObject();
            if (!(maybeThrowable instanceof Throwable)) {
                throw Error.typeError(context, "can't raise a non-Throwable Java object");
            }
            Throwable ex = (Throwable)maybeThrowable;
            Helpers.throwException(ex);
            return;
        }
    }

    private static RubyException convertToException(ThreadContext context, IRubyObject obj, IRubyObject optionalMessage) {
        IRubyObject exception2;
        if (!obj.respondsTo("exception")) {
            throw Error.typeError(context, "exception class/object expected");
        }
        IRubyObject iRubyObject = exception2 = optionalMessage == null ? obj.callMethod(context, "exception") : obj.callMethod(context, "exception", optionalMessage);
        if (!RubyException.class.isInstance(exception2)) {
            throw Error.typeError(context, "exception object expected");
        }
        return (RubyException)exception2;
    }

    private static void printExceptionSummary(ThreadContext context, RubyException rEx) {
        RubyStackTraceElement[] elements = rEx.getBacktraceElements();
        RubyStackTraceElement firstElement = elements.length > 0 ? elements[0] : new RubyStackTraceElement("", "", "(empty)", 0, false);
        String msg = String.format("Exception '%s' at %s:%s - %s\n", rEx.getMetaClass(), firstElement.getFileName(), firstElement.getLineNumber(), TypeConverter.convertToType(rEx, Access.stringClass(context), "to_s"));
        context.runtime.getErrorStream().print(msg);
    }

    @JRubyMethod(name={"require"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject require(ThreadContext context, IRubyObject recv2, IRubyObject name2, Block block) {
        IRubyObject tmp = name2.checkStringType();
        RubyString requireName = tmp != context.nil ? (RubyString)tmp : RubyFile.get_path(context, name2);
        return RubyKernel.requireCommon(context, requireName, block);
    }

    private static IRubyObject requireCommon(ThreadContext context, RubyString name2, Block block) {
        String path2 = Check.checkEmbeddedNulls(context, name2).toString();
        return Convert.asBoolean(context, Access.loadService(context).require(path2));
    }

    @JRubyMethod(name={"require_relative"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.SCOPE})
    public static IRubyObject require_relative(ThreadContext context, IRubyObject recv2, IRubyObject name2) {
        RubyString relativePath = RubyFile.get_path(context, name2);
        String file2 = context.getCurrentStaticScope().getFile();
        if (file2 == null || file2.equals("-") || file2.equals("-e") || file2.matches("\\A\\((.*)\\)")) {
            throw context.runtime.newLoadError("cannot infer basepath");
        }
        file2 = Access.loadService(context).getPathForLocation(file2);
        RubyClass fileClass = Access.fileClass(context);
        IRubyObject realpath2 = RubyFile.realpath(context, (IRubyObject)fileClass, Create.newString(context, file2));
        IRubyObject dirname2 = RubyFile.dirname(context, (IRubyObject)fileClass, realpath2);
        IRubyObject absoluteFeature = RubyFile.expand_path(context, (IRubyObject)fileClass, (IRubyObject)relativePath, dirname2);
        return RubyKernel.require(context, Access.kernelModule(context), absoluteFeature, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"load"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load(ThreadContext context, IRubyObject recv2, IRubyObject path2, Block block) {
        return RubyKernel.loadCommon(context, RubyFile.get_path(context, path2), false);
    }

    @JRubyMethod(name={"load"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject wrap2, Block block) {
        return RubyKernel.loadCommon(context, RubyFile.get_path(context, path2), wrap2);
    }

    @Deprecated(since="9.4-")
    public static IRubyObject load(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyKernel.load(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2, block);
    }

    public static IRubyObject load(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return RubyKernel.load(context, recv2, args2[0], block);
            }
            case 2: {
                return RubyKernel.load(context, recv2, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 1, 2);
        return null;
    }

    private static IRubyObject loadCommon(ThreadContext context, RubyString path2, boolean wrap2) {
        Access.loadService(context).load(path2.toString(), wrap2);
        return context.tru;
    }

    private static IRubyObject loadCommon(ThreadContext context, RubyString path2, IRubyObject wrap2) {
        String file2 = path2.toString();
        if (wrap2.isNil() || wrap2 instanceof RubyBoolean) {
            Access.loadService(context).load(file2, wrap2.isTrue());
        } else {
            Access.loadService(context).load(file2, wrap2);
        }
        return context.tru;
    }

    @JRubyMethod(name={"eval"}, required=1, optional=3, checkArity=false, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public static IRubyObject eval(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 4);
        return RubyKernel.evalCommon(context, recv2, args2);
    }

    private static IRubyObject evalCommon(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Binding binding2;
        RubyString src = args2[0].convertToString();
        boolean bindingGiven = args2.length > 1 && args2[1] != context.nil;
        Binding binding3 = binding2 = bindingGiven ? RubyKernel.getBindingForEval(context, args2[1]) : context.currentBinding();
        if (args2.length > 2) {
            binding2.setFile(args2[2].convertToString().toString());
            if (args2.length > 3) {
                binding2.setLine(Convert.toInt(context, args2[3]) - 1);
            } else {
                binding2.setLine(0);
            }
        } else {
            binding2.setFile("(eval at " + context.getSingleBacktrace().getFileAndLine() + ")");
            binding2.setLine(0);
        }
        String frameName = context.getCompositeName();
        if (frameName != null) {
            binding2.setMethod(frameName);
        }
        if (bindingGiven) {
            recv2 = binding2.getSelf();
        }
        return Interpreter.evalWithBinding(context, recv2, src, binding2, bindingGiven);
    }

    private static Binding getBindingForEval(ThreadContext context, IRubyObject scope) {
        if (scope instanceof RubyBinding) {
            RubyBinding binding2 = (RubyBinding)scope;
            return binding2.getBinding().cloneForEval();
        }
        throw Error.typeError(context, scope, "Binding");
    }

    @JRubyMethod(name={"caller"}, module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject caller(ThreadContext context, IRubyObject recv2) {
        return RubyKernel.callerInternal(context, recv2, null, null);
    }

    @JRubyMethod(name={"caller"}, module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject caller(ThreadContext context, IRubyObject recv2, IRubyObject level2) {
        return RubyKernel.callerInternal(context, recv2, level2, null);
    }

    @JRubyMethod(name={"caller"}, module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject caller(ThreadContext context, IRubyObject recv2, IRubyObject level2, IRubyObject length2) {
        return RubyKernel.callerInternal(context, recv2, level2, length2);
    }

    private static IRubyObject callerInternal(ThreadContext context, IRubyObject recv2, IRubyObject level2, IRubyObject length2) {
        if (length2 != null && length2.isNil()) {
            length2 = null;
        }
        if (length2 == null) {
            return RubyKernel.withLevelAndLength(context, level2, length2, 1, (ctx, lev, len) -> ThreadContext.WALKER8.walk(stream -> ctx.createCallerBacktrace(lev, len, (Stream<StackWalker.StackFrame>)stream)));
        }
        return RubyKernel.withLevelAndLength(context, level2, length2, 1, (ctx, lev, len) -> ThreadContext.WALKER.walk(stream -> ctx.createCallerBacktrace(lev, len, (Stream<StackWalker.StackFrame>)stream)));
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject caller_locations(ThreadContext context, IRubyObject recv2) {
        return RubyKernel.callerLocationsInternal(context, null, null);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject caller_locations(ThreadContext context, IRubyObject recv2, IRubyObject level2) {
        return RubyKernel.callerLocationsInternal(context, level2, null);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject caller_locations(ThreadContext context, IRubyObject recv2, IRubyObject level2, IRubyObject length2) {
        return RubyKernel.callerLocationsInternal(context, level2, length2);
    }

    private static IRubyObject callerLocationsInternal(ThreadContext context, IRubyObject level2, IRubyObject length2) {
        if (length2 == null) {
            return RubyKernel.withLevelAndLength(context, level2, length2, 1, (ctx, lev, len) -> ThreadContext.WALKER8.walk(stream -> ctx.createCallerLocations(lev, len, (Stream<StackWalker.StackFrame>)stream)));
        }
        return RubyKernel.withLevelAndLength(context, level2, length2, 1, (ctx, lev, len) -> ThreadContext.WALKER.walk(stream -> ctx.createCallerLocations(lev, len, (Stream<StackWalker.StackFrame>)stream)));
    }

    static <R> R withLevelAndLength(ThreadContext context, IRubyObject level2, IRubyObject length2, int defaultLevel, ObjectIntIntFunction<ThreadContext, R> func) {
        int lev;
        int len = 0x1000000;
        if (length2 != null) {
            lev = Convert.toInt(context, level2);
            len = Convert.toInt(context, length2);
        } else if (level2 instanceof RubyRange) {
            RubyRange range = (RubyRange)level2;
            IRubyObject first2 = range.begin(context);
            lev = first2.isNil() ? 0 : Convert.toInt(context, first2);
            IRubyObject last2 = range.end(context);
            len = last2.isNil() ? 0x1000000 : Convert.toInt(context, last2) - lev;
            if (!range.isExcludeEnd()) {
                ++len;
            }
            len = len < 0 ? 0 : len;
        } else {
            lev = level2 != null ? Convert.toInt(context, level2) : defaultLevel;
        }
        if (lev < 0) {
            throw Error.argumentError(context, "negative level (" + lev + ")");
        }
        if (len < 0) {
            throw Error.argumentError(context, "negative size (" + len + ")");
        }
        return func.apply(context, lev, len);
    }

    @JRubyMethod(name={"catch"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbCatch(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.rbCatch(context, recv2, new RubyObject(Access.objectClass(context)), block);
    }

    @JRubyMethod(name={"catch"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbCatch(ThreadContext context, IRubyObject recv2, IRubyObject tag2, Block block) {
        new CatchThrow(tag2);
        return CatchThrow.enter(context, tag2, block);
    }

    @JRubyMethod(name={"throw"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbThrow(ThreadContext context, IRubyObject recv2, IRubyObject tag2, Block block) {
        return RubyKernel.rbThrowInternal(context, tag2, null);
    }

    @JRubyMethod(name={"throw"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbThrow(ThreadContext context, IRubyObject recv2, IRubyObject tag2, IRubyObject value2, Block block) {
        return RubyKernel.rbThrowInternal(context, tag2, value2);
    }

    private static IRubyObject rbThrowInternal(ThreadContext context, IRubyObject tag2, IRubyObject arg2) {
        context.setErrorInfo(context.nil);
        CatchThrow continuation = context.getActiveCatch(tag2);
        if (continuation != null) {
            IRubyObject[] iRubyObjectArray;
            if (arg2 == null) {
                iRubyObjectArray = IRubyObject.NULL_ARRAY;
            } else {
                IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
                iRubyObjectArray = iRubyObjectArray2;
                iRubyObjectArray2[0] = arg2;
            }
            continuation.args = iRubyObjectArray;
            throw continuation;
        }
        IRubyObject value2 = arg2 == null ? context.nil : arg2;
        throw RubyKernel.uncaughtThrow(context, tag2, value2, Create.newSharedString(context, uncaught_throw_p));
    }

    private static RaiseException uncaughtThrow(ThreadContext context, IRubyObject tag2, IRubyObject value2, RubyString message2) {
        return RubyUncaughtThrowError.newUncaughtThrowError(context, tag2, value2, message2).toThrowable();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject warn(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        if (arg2 instanceof RubyHash) {
            return RubyKernel.warn(context, recv2, new IRubyObject[]{arg2});
        }
        if (!context.runtime.getVerbose().isNil()) {
            RubyKernel.warnObj(context, recv2, arg2, context.nil);
        }
        return context.nil;
    }

    private static void warnObj(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject category) {
        if (arg2 instanceof RubyArray) {
            RubyArray argAry = arg2.convertToArray();
            for (int i2 = 0; i2 < argAry.size(); ++i2) {
                RubyKernel.warnObj(context, recv2, argAry.eltOk(i2), category);
            }
            return;
        }
        RubyKernel.warnStr(context, recv2, arg2.asString(), category);
    }

    static void warnStr(ThreadContext context, IRubyObject recv2, RubyString message2, IRubyObject category) {
        RubyModule warning;
        if (!message2.endsWithAsciiChar('\n')) {
            message2 = Create.dupString(context, message2).cat(10, USASCIIEncoding.INSTANCE);
        }
        if (recv2 == (warning = context.runtime.getWarning())) {
            RubyWarnings.warn(context, message2);
            return;
        }
        DynamicMethod method2 = ((CachingCallSite)RubyKernel.sites((ThreadContext)context).warn).retrieveCache((IRubyObject)warning).method;
        if (method2.getSignature().isOneArgument()) {
            RubyKernel.sites((ThreadContext)context).warn.call(context, recv2, (IRubyObject)warning, (IRubyObject)message2);
        } else {
            RubyHash keywords = RubyHash.newHash(context.runtime, Convert.asSymbol(context, "category"), category);
            context.callInfo = 2;
            RubyKernel.sites((ThreadContext)context).warn.call(context, recv2, (IRubyObject)warning, (IRubyObject)message2, (IRubyObject)keywords);
        }
    }

    @JRubyMethod(module=true, rest=true, visibility=Visibility.PRIVATE, omit=true)
    public static IRubyObject warn(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject opts;
        boolean explicitUplevel = false;
        int uplevel = 0;
        IRubyObject category = context.nil;
        int argMessagesLen = args2.length;
        if (argMessagesLen > 0 && (opts = TypeConverter.checkHashType(context.runtime, args2[argMessagesLen - 1])) != context.nil) {
            --argMessagesLen;
            IRubyObject[] ret = ArgsUtil.extractKeywordArgs(context, (RubyHash)opts, "uplevel", "category");
            if (ret[0] != null && !ret[0].isNil()) {
                explicitUplevel = true;
                uplevel = Convert.toInt(context, ret[0]);
                if (uplevel < 0) {
                    throw Error.argumentError(context, "negative level (" + uplevel + ")");
                }
            }
            if (ret[1] != null) {
                category = ret[1].isNil() ? context.nil : TypeConverter.convertToType(ret[1], Access.symbolClass(context), "to_sym");
            }
        }
        int i2 = 0;
        if (!context.runtime.getVerbose().isNil() && argMessagesLen > 0) {
            if (explicitUplevel && argMessagesLen > 0) {
                RubyKernel.warnStr(context, recv2, RubyKernel.buildWarnMessage(context, uplevel, args2[0]), category);
                i2 = 1;
            }
            while (i2 < argMessagesLen) {
                RubyKernel.warnObj(context, recv2, args2[i2], category);
                ++i2;
            }
        }
        return context.nil;
    }

    private static RubyString buildWarnMessage(ThreadContext context, int uplevel, IRubyObject arg2) {
        RubyStackTraceElement element = context.getSingleBacktraceExact(uplevel);
        RubyString message2 = RubyString.newStringLight(context.runtime, 32);
        if (element != null) {
            message2.catString(element.getFileName()).cat(58).catString(Integer.toString(element.getLineNumber())).catString(": warning: ");
        } else {
            message2.catString("warning: ");
        }
        RubyString arg1 = arg2.asString();
        return (RubyString)message2.op_plus(context, arg1);
    }

    @JRubyMethod(module=true, alias={"then"})
    public static IRubyObject yield_self(ThreadContext context, IRubyObject recv2, Block block) {
        if (block.isGiven()) {
            return block.yield(context, recv2);
        }
        return RubyEnumerator.enumeratorizeWithSize(context, recv2, "yield_self", RubyKernel::objectSize);
    }

    private static IRubyObject objectSize(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return RubyFixnum.one(context.runtime);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject set_trace_func(ThreadContext context, IRubyObject recv2, IRubyObject trace_func, Block block) {
        if (trace_func.isNil()) {
            context.traceEvents.setTraceFunction(null);
        } else {
            if (!(trace_func instanceof RubyProc)) {
                throw Error.typeError(context, "trace_func needs to be Proc.");
            }
            context.traceEvents.setTraceFunction((RubyProc)trace_func);
        }
        return trace_func;
    }

    @JRubyMethod(required=1, optional=1, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trace_var(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        RubyProc proc2 = null;
        String var = args2[0].toString();
        if (var.charAt(0) != '$') {
            return context.nil;
        }
        if (argc == 1) {
            proc2 = RubyProc.newProc(context.runtime, block, Block.Type.PROC);
        } else if (argc == 2) {
            if (args2[1] instanceof RubyString) {
                RubyString rubyString = Create.newString(context, "proc {");
                RubyString s2 = rubyString.catWithCodeRange((RubyString)args2[1]).cat(125);
                proc2 = (RubyProc)RubyKernel.evalCommon(context, recv2, new IRubyObject[]{s2});
            } else {
                proc2 = (RubyProc)TypeConverter.convertToType(args2[1], context.runtime.getProc(), "to_proc", true);
            }
        }
        Access.globalVariables(context).setTraceVar(var, proc2);
        return context.nil;
    }

    @JRubyMethod(required=1, optional=1, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject untrace_var(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        String var = args2[0].toString();
        if (var.charAt(0) != '$') {
            return context.nil;
        }
        if (argc > 1) {
            ArrayList<IRubyObject> success = new ArrayList<IRubyObject>(argc);
            for (int i2 = 1; i2 < argc; ++i2) {
                if (!Access.globalVariables(context).untraceVar(var, args2[i2])) continue;
                success.add(args2[i2]);
            }
            return RubyArray.newArray(context.runtime, success);
        }
        Access.globalVariables(context).untraceVar(var);
        return context.nil;
    }

    @JRubyMethod(required=1, optional=1, checkArity=false)
    public static IRubyObject define_singleton_method(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        RubyClass singleton_class2 = recv2.singletonClass(context);
        if (argc > 1) {
            RubyUnboundMethod method2;
            RubyModule owner2;
            IRubyObject arg1 = args2[1];
            if (context.runtime.getUnboundMethod().isInstance(arg1) && (owner2 = (RubyModule)(method2 = (RubyUnboundMethod)arg1).owner(context)).isSingleton() && (!recv2.getMetaClass().isSingleton() || !recv2.getMetaClass().isKindOfModule(owner2))) {
                throw Error.typeError(context, "can't bind singleton method to a different class");
            }
            return singleton_class2.defineMethodFromCallable(context, args2[0], args2[1], Visibility.PUBLIC);
        }
        return singleton_class2.defineMethodFromBlock(context, args2[0], block, Visibility.PUBLIC);
    }

    @JRubyMethod(name={"proc"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyProc proc(ThreadContext context, IRubyObject recv2, Block block) {
        return context.runtime.newProc(Block.Type.PROC, block);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static RubyProc lambda(ThreadContext context, IRubyObject recv2, Block block) {
        if (block.type == Block.Type.PROC) {
            throw Error.argumentError(context, "the lambda method requires a literal block");
        }
        return context.runtime.newProc(Block.Type.LAMBDA, block);
    }

    @Deprecated(since="9.1.3.0")
    public static RubyProc proc_1_9(ThreadContext context, IRubyObject recv2, Block block) {
        return RubyKernel.proc(context, recv2, block);
    }

    @JRubyMethod(name={"loop"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject loop(ThreadContext context, IRubyObject recv2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, recv2, "loop", RubyKernel::loopSize);
        }
        IRubyObject oldExc = context.getErrorInfo();
        try {
            while (true) {
                block.yieldSpecific(context);
                context.pollThreadEvents();
            }
        }
        catch (RaiseException ex) {
            RubyClass StopIteration2 = context.runtime.getStopIteration();
            if (StopIteration2.isInstance(ex.getException())) {
                context.setErrorInfo(oldExc);
                return ex.getException().callMethod("result");
            }
            throw ex;
        }
    }

    private static IRubyObject loopSize(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return RubyFloat.newFloat(context.runtime, Double.POSITIVE_INFINITY);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject test(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
        return RubyKernel.testCommon(context, recv2, RubyKernel.getTestCommand(context, arg0), arg1, null);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject test(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyKernel.testCommon(context, recv2, RubyKernel.getTestCommand(context, arg0), arg1, arg2);
    }

    private static IRubyObject testCommon(ThreadContext context, IRubyObject recv2, int cmd, IRubyObject arg1, IRubyObject arg2) {
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: {
                if (arg2 != null) break;
                throw Error.argumentError(context, 2, 3);
            }
            default: {
                if (arg1 != null) break;
                throw Error.argumentError(context, 1, 2);
            }
        }
        switch (cmd) {
            case 65: {
                return context.runtime.newFileStat(RubyFile.fileResource(context, arg1).path(), false).atime(context);
            }
            case 98: {
                return RubyFileTest.blockdev_p(context, recv2, arg1);
            }
            case 99: {
                return RubyFileTest.chardev_p(context, recv2, arg1);
            }
            case 67: {
                return context.runtime.newFileStat(RubyFile.fileResource(context, arg1).path(), false).ctime(context);
            }
            case 100: {
                return RubyFileTest.directory_p(context, recv2, arg1);
            }
            case 101: {
                return RubyFileTest.exist_p(context, recv2, arg1);
            }
            case 102: {
                return RubyFileTest.file_p(context, recv2, arg1);
            }
            case 103: {
                return RubyFileTest.setgid_p(context, recv2, arg1);
            }
            case 71: {
                return RubyFileTest.grpowned_p(context, recv2, arg1);
            }
            case 107: {
                return RubyFileTest.sticky_p(context, recv2, arg1);
            }
            case 77: {
                return context.runtime.newFileStat(RubyFile.fileResource(context, arg1).path(), false).mtime(context);
            }
            case 108: {
                return RubyFileTest.symlink_p(context, recv2, arg1);
            }
            case 111: {
                return RubyFileTest.owned_p(context, recv2, arg1);
            }
            case 79: {
                return RubyFileTest.rowned_p(context, recv2, arg1);
            }
            case 112: {
                return RubyFileTest.pipe_p(context, recv2, arg1);
            }
            case 114: {
                return RubyFileTest.readable_p(context, recv2, arg1);
            }
            case 82: {
                return RubyFileTest.readable_p(context, recv2, arg1);
            }
            case 115: {
                return RubyFileTest.size_p(context, recv2, arg1);
            }
            case 83: {
                return RubyFileTest.socket_p(context, recv2, arg1);
            }
            case 117: {
                return RubyFileTest.setuid_p(context, recv2, arg1);
            }
            case 119: {
                return RubyFileTest.writable_p(context, recv2, arg1);
            }
            case 87: {
                return RubyFileTest.writable_p(context, recv2, arg1);
            }
            case 120: {
                return RubyFileTest.executable_p(context, recv2, arg1);
            }
            case 88: {
                return RubyFileTest.executable_real_p(context, recv2, arg1);
            }
            case 122: {
                return RubyFileTest.zero_p(context, recv2, arg1);
            }
            case 61: {
                return context.runtime.newFileStat(arg1.convertToString().toString(), false).mtimeEquals(context, arg2);
            }
            case 60: {
                return context.runtime.newFileStat(arg1.convertToString().toString(), false).mtimeLessThan(context, arg2);
            }
            case 62: {
                return context.runtime.newFileStat(arg1.convertToString().toString(), false).mtimeGreaterThan(context, arg2);
            }
            case 45: {
                return RubyFileTest.identical_p(context, recv2, arg1, arg2);
            }
        }
        throw new InternalError("unreachable code reached!");
    }

    private static int getTestCommand(ThreadContext context, IRubyObject arg0) {
        int n;
        IRubyObject iRubyObject = arg0;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n2 = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFixnum.class, RubyString.class}, (Object)iRubyObject2, n2)) {
                case 0: {
                    RubyFixnum fixnum = (RubyFixnum)iRubyObject2;
                    n = fixnum.asInt(context);
                    break block7;
                }
                case 1: {
                    RubyString str = (RubyString)iRubyObject2;
                    if (str.getByteList().isEmpty()) {
                        n2 = 2;
                        continue block7;
                    }
                    n = str.getByteList().charAt(0);
                    break block7;
                }
                default: {
                    n = Convert.toInt(context, arg0);
                    break block7;
                }
            }
            break;
        }
        int cmd = n;
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 71: 
            case 77: 
            case 79: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 119: 
            case 120: 
            case 122: {
                break;
            }
            default: {
                throw Error.argumentError(context, "unknown command ?" + (char)cmd);
            }
        }
        return cmd;
    }

    @JRubyMethod(name={"`"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject backquote(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        long[] tuple;
        Ruby runtime2 = context.runtime;
        if (PopenExecutor.nativePopenAvailable(runtime2)) {
            str = str.convertToString();
            context.setLastExitStatus(context.nil);
            IRubyObject port = PopenExecutor.pipeOpen(context, str, "r", 4097, null);
            if (port.isNil()) {
                return Create.newEmptyString(context);
            }
            OpenFile fptr = ((RubyIO)port).getOpenFileChecked();
            IRubyObject result2 = fptr.readAll(context, fptr.remainSize(), context.nil);
            ((RubyIO)port).rbIoClose(context);
            return result2;
        }
        IRubyObject[] args2 = new IRubyObject[]{str.convertToString()};
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            tuple = ShellLauncher.runAndWaitPid(runtime2, args2, output, false);
        }
        catch (Exception e) {
            tuple = new long[]{127L, -1L};
        }
        context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, tuple[0] << 8, tuple[1]));
        byte[] out = output.toByteArray();
        int length2 = out.length;
        if (Platform.IS_WINDOWS) {
            int newPos = 0;
            for (int pos2 = 0; pos2 < length2; ++pos2) {
                byte curr = out[pos2];
                if (pos2 == length2 - 1) {
                    out[newPos++] = curr;
                    break;
                }
                byte next2 = out[pos2 + 1];
                if (curr == 13 && next2 == 10) continue;
                out[newPos++] = curr;
            }
            length2 = newPos;
        }
        ByteList buf = new ByteList(out, 0, length2, runtime2.getDefaultExternalEncoding(), false);
        return Create.newString(context, buf);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.srandCommon(context, recv2);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyRandom.srandCommon(context, recv2, arg2);
    }

    @JRubyMethod(name={"rand"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rand(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.randFloat(context);
    }

    @JRubyMethod(name={"rand"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rand(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyRandom.randKernel(context, recv2, arg2);
    }

    @JRubyMethod(rest=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyFixnum spawn(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyProcess.spawn(context, recv2, args2);
    }

    @JRubyMethod(required=1, optional=9, checkArity=false, module=true, notImplemented=true, visibility=Visibility.PRIVATE)
    public static IRubyObject syscall(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("Kernel#syscall is not implemented in JRuby");
    }

    @JRubyMethod(name={"system"}, required=1, rest=true, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject system(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        boolean needChdir;
        Arity.checkArgumentCount(context, args2, 1, -1);
        Ruby runtime2 = context.runtime;
        boolean bl = needChdir = !runtime2.getCurrentDirectory().equals(runtime2.getPosix().getcwd());
        if (PopenExecutor.nativePopenAvailable(runtime2)) {
            context.setLastExitStatus(context.nil);
            PopenExecutor executor = new PopenExecutor();
            return executor.systemInternal(context, args2, null);
        }
        int resultCode = RubyKernel.systemCommon(context, recv2, args2);
        switch (resultCode) {
            case 0: {
                return runtime2.getTrue();
            }
            case 127: {
                return runtime2.getNil();
            }
        }
        return runtime2.getFalse();
    }

    private static int systemCommon(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        long[] tuple;
        Ruby runtime2 = context.runtime;
        try {
            args2 = RubyKernel.dropLastArgIfOptions(context, args2);
            if (!Platform.IS_WINDOWS && args2[args2.length - 1].asJavaString().matches(".*[^&]&\\s*")) {
                ShellLauncher.runWithoutWait(runtime2, args2);
                return 0;
            }
            tuple = ShellLauncher.runAndWaitPid(runtime2, args2);
        }
        catch (Exception e) {
            tuple = new long[]{127L, -1L};
        }
        context.setLastExitStatus(RubyProcess.RubyStatus.newProcessStatus(runtime2, tuple[0] << 8, tuple[1]));
        return (int)tuple[0];
    }

    private static IRubyObject[] dropLastArgIfOptions(ThreadContext context, IRubyObject[] args2) {
        IRubyObject lastArg = args2[args2.length - 1];
        if (lastArg instanceof RubyHash) {
            RubyHash hash2 = (RubyHash)lastArg;
            if (!hash2.isEmpty()) {
                Warn.warn(context, "system does not support options in JRuby yet: " + String.valueOf(lastArg));
            }
            return Arrays.copyOf(args2, args2.length - 1);
        }
        return args2;
    }

    public static IRubyObject exec(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyKernel.execCommon(context, null, args2[0], null, args2);
    }

    @JRubyMethod(required=4, visibility=Visibility.PRIVATE)
    public static IRubyObject _exec_internal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject env = args2[0];
        IRubyObject prog = args2[1];
        IRubyObject options2 = args2[2];
        RubyArray cmdArgs = (RubyArray)args2[3];
        if (options2 instanceof RubyHash) {
            RubyKernel.checkExecOptions(context, (RubyHash)options2);
        }
        return RubyKernel.execCommon(context, env, prog, options2, cmdArgs.toJavaArray(context));
    }

    static void checkExecOptions(ThreadContext context, RubyHash opts) {
        RubyIO.checkValidSpawnOptions(context, opts);
        RubyIO.checkUnsupportedOptions(context, opts, RubyIO.UNSUPPORTED_SPAWN_OPTIONS, "unsupported exec option");
    }

    private static IRubyObject execCommon(ThreadContext context, IRubyObject env, IRubyObject prog, IRubyObject options2, IRubyObject[] args2) {
        RubyHash envMap;
        if (args2.length == 1) {
            RubyString command = args2[0].convertToString();
            if (command.isEmpty()) {
                throw context.runtime.newErrnoENOENTError(command.toString());
            }
            for (byte b2 : command.getBytes()) {
                if (b2 != 0) continue;
                throw Error.argumentError(context, "string contains null byte");
            }
        }
        Ruby runtime2 = context.runtime;
        if (env != null && env != context.nil && (envMap = env.convertToHash()) != null) {
            runtime2.getENV().merge_bang(context, new IRubyObject[]{envMap}, Block.NULL_BLOCK);
        }
        boolean nativeFailed = false;
        boolean nativeExec = Options.NATIVE_EXEC.load();
        boolean jmxStopped = false;
        System.setProperty("user.dir", runtime2.getCurrentDirectory());
        if (nativeExec) {
            IRubyObject oldExc = context.getErrorInfo();
            try {
                ShellLauncher.LaunchConfig cfg = new ShellLauncher.LaunchConfig(runtime2, args2, true);
                if (cfg.shouldRunInShell()) {
                    cfg.verifyExecutableForShell();
                } else {
                    cfg.verifyExecutableForDirect();
                }
                String progStr = cfg.getExecArgs()[0];
                String[] argv2 = cfg.getExecArgs();
                jmxStopped = runtime2.getBeanManager().tryShutdownAgent();
                POSIX posix = runtime2.getPosix();
                posix.chdir(System.getProperty("user.dir"));
                if (Platform.IS_WINDOWS) {
                    posix.exec(progStr, argv2);
                } else {
                    RubyHash ENV = runtime2.getENV();
                    ArrayList<CallSite> envStrings = new ArrayList<CallSite>(ENV.size() + 1);
                    for (Map.Entry envEntry : ENV.entrySet()) {
                        envStrings.add((CallSite)((Object)((String)envEntry.getKey() + "=" + (String)envEntry.getValue())));
                    }
                    envStrings.add(null);
                    int status2 = posix.execve(progStr, argv2, envStrings.toArray(new String[envStrings.size()]));
                    if (Platform.IS_WSL && status2 == -1 && posix.errno() == Errno.ENOMEM.intValue()) {
                        posix.exec(progStr, argv2);
                    }
                }
                nativeFailed = true;
            }
            catch (RaiseException e) {
                context.setErrorInfo(oldExc);
            }
            catch (Exception e) {
                throw runtime2.newErrnoENOENTError("cannot execute: " + e.getLocalizedMessage());
            }
        }
        if (nativeFailed) {
            if (jmxStopped && runtime2.getBeanManager().tryRestartAgent()) {
                runtime2.registerMBeans();
            }
            throw runtime2.newErrnoFromLastPOSIXErrno();
        }
        int resultCode = ShellLauncher.execAndWait(runtime2, args2);
        throw RubyKernel.exit(context, new IRubyObject[]{Convert.asFixnum(context, resultCode)}, true);
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE, notImplemented=true)
    public static IRubyObject fork(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby runtime2 = context.runtime;
        throw runtime2.newNotImplementedError("fork is not available on this platform");
    }

    @JRubyMethod(name={"to_enum", "enum_for"}, rest=true, keywords=true)
    public static IRubyObject obj_to_enum(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        int callInfo = context.callInfo;
        String method2 = "each";
        RubyEnumerator.SizeFn<IRubyObject> sizeFn = null;
        if (args2.length > 0) {
            method2 = RubySymbol.retrieveIDSymbol(args2[0]).asJavaString();
            args2 = Arrays.copyOfRange(args2, 1, args2.length);
        }
        if (block.isGiven()) {
            sizeFn = (ctx, recv2, args1) -> {
                ctx.callInfo = callInfo;
                return block.yieldValues(ctx, args1);
            };
        }
        boolean keywords = (callInfo & 2) != 0 && (callInfo & 8) == 0;
        ThreadContext.resetCallInfo(context);
        return RubyEnumerator.enumeratorizeWithSize(context, self2, method2, args2, sizeFn, keywords);
    }

    @JRubyMethod(name={"__method__"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.METHODNAME}, omit=true)
    public static IRubyObject __method__(ThreadContext context, IRubyObject recv2) {
        String frameName = context.getFrameName();
        return frameName == null || frameName == "(root)" ? context.nil : Convert.asSymbol(context, frameName);
    }

    @JRubyMethod(name={"__callee__"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.METHODNAME}, omit=true)
    public static IRubyObject __callee__(ThreadContext context, IRubyObject recv2) {
        String frameName = context.getCalleeName();
        return frameName == null || frameName == "(root)" ? context.nil : Convert.asSymbol(context, frameName);
    }

    @JRubyMethod(name={"__dir__"}, module=true, visibility=Visibility.PRIVATE, reads={FrameField.FILENAME})
    public static IRubyObject __dir__(ThreadContext context, IRubyObject recv2) {
        String __FILE__ = context.getSingleBacktrace().getFileName();
        __FILE__ = Access.loadService(context).getPathForLocation(__FILE__);
        RubyString path2 = RubyFile.expandPathInternal(context, Create.newString(context, __FILE__), null, false, true);
        return Create.newString(context, RubyFile.dirname(context, path2.asJavaString()));
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject singleton_class(IRubyObject recv2) {
        return RubyKernel.singleton_class(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(module=true)
    public static IRubyObject singleton_class(ThreadContext context, IRubyObject recv2) {
        return recv2.singletonClass(context);
    }

    @JRubyMethod(rest=true, keywords=true, reads={FrameField.SCOPE})
    public static IRubyObject public_send(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        int length2;
        if (args2.length == 0) {
            throw Error.argumentError(context, "no method name given");
        }
        String name2 = RubySymbol.idStringFromObject(context, args2[0]);
        if (args2.length > 1) {
            args2[args2.length - 1] = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, args2[args2.length - 1]);
        }
        args2 = (length2 = args2.length - 1) == 0 ? IRubyObject.NULL_ARRAY : ArraySupport.newCopy(args2, 1, length2);
        RubyClass klass = RubyBasicObject.getMetaClass(recv2);
        CacheEntry entry = klass.searchWithRefinements(name2, context.getCurrentStaticScope());
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined() || method2.getVisibility() != Visibility.PUBLIC) {
            return Helpers.callMethodMissing(context, recv2, klass, method2.getVisibility(), name2, CallType.NORMAL, args2, block);
        }
        return method2.call(context, recv2, entry.sourceModule, name2, args2, block);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject eql_p(IRubyObject self2, IRubyObject obj) {
        return RubyKernel.eql_p(((RubyBasicObject)self2).getCurrentContext(), self2, obj);
    }

    @JRubyMethod(name={"eql?"})
    public static IRubyObject eql_p(ThreadContext context, IRubyObject self2, IRubyObject obj) {
        return ((RubyBasicObject)self2).eql_p(context, obj);
    }

    @JRubyMethod(name={"==="})
    public static IRubyObject op_eqq(ThreadContext context, IRubyObject self2, IRubyObject other) {
        return ((RubyBasicObject)self2).op_eqq(context, other);
    }

    @JRubyMethod(name={"<=>"})
    public static IRubyObject op_cmp(ThreadContext context, IRubyObject self2, IRubyObject other) {
        return ((RubyBasicObject)self2).op_cmp(context, other);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject initialize_copy(IRubyObject self2, IRubyObject original) {
        return RubyKernel.initialize_copy(((RubyBasicObject)self2).getCurrentContext(), self2, original);
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public static IRubyObject initialize_copy(ThreadContext context, IRubyObject self2, IRubyObject original) {
        return ((RubyBasicObject)self2).initialize_copy(context, original);
    }

    @JRubyMethod(name={"initialize_clone"}, required=1, visibility=Visibility.PRIVATE)
    public static IRubyObject initialize_clone(ThreadContext context, IRubyObject self2, IRubyObject original) {
        return RubyKernel.sites((ThreadContext)context).initialize_copy.call(context, self2, self2, original);
    }

    @JRubyMethod(name={"initialize_dup"}, required=1, visibility=Visibility.PRIVATE)
    public static IRubyObject initialize_dup(ThreadContext context, IRubyObject self2, IRubyObject original) {
        return RubyKernel.sites((ThreadContext)context).initialize_copy.call(context, self2, self2, original);
    }

    @Deprecated(since="9.2.0.0")
    public static RubyBoolean respond_to_p(IRubyObject self2, IRubyObject mname) {
        return ((RubyBasicObject)self2).respond_to_p(mname);
    }

    @Deprecated(since="9.2.0.0")
    public static RubyBoolean respond_to_p(IRubyObject self2, IRubyObject mname, IRubyObject includePrivate) {
        return ((RubyBasicObject)self2).respond_to_p(mname, includePrivate);
    }

    @JRubyMethod(name={"respond_to?"})
    public static IRubyObject respond_to_p(ThreadContext context, IRubyObject self2, IRubyObject name2) {
        return ((RubyBasicObject)self2).respond_to_p(context, name2, false);
    }

    @JRubyMethod(name={"respond_to?"})
    public static IRubyObject respond_to_p(ThreadContext context, IRubyObject self2, IRubyObject name2, IRubyObject includePrivate) {
        return ((RubyBasicObject)self2).respond_to_p(context, name2, includePrivate.isTrue());
    }

    @Deprecated(since="10.0.0.0")
    public static RubyFixnum hash(IRubyObject self2) {
        return ((RubyBasicObject)self2).hash(((RubyBasicObject)self2).getCurrentContext());
    }

    @JRubyMethod
    public static RubyFixnum hash(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).hash(context);
    }

    @JRubyMethod(name={"class"})
    public static RubyClass type(IRubyObject self2) {
        return ((RubyBasicObject)self2).type();
    }

    @JRubyMethod(name={"clone"})
    public static IRubyObject rbClone(ThreadContext context, IRubyObject self2) {
        return self2.rbClone();
    }

    @JRubyMethod(name={"clone"})
    public static IRubyObject rbClone(ThreadContext context, IRubyObject self2, IRubyObject opts) {
        return ((RubyBasicObject)self2).rbClone(context, opts);
    }

    @JRubyMethod
    public static IRubyObject dup(IRubyObject self2) {
        return ((RubyBasicObject)self2).dup();
    }

    @JRubyMethod(optional=1, checkArity=false)
    public static IRubyObject display(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return ((RubyBasicObject)self2).display(context, args2);
    }

    @JRubyMethod
    public static IRubyObject freeze(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).freeze(context);
    }

    @JRubyMethod(name={"frozen?"})
    public static RubyBoolean frozen_p(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).frozen_p(context);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject inspect(IRubyObject self2) {
        return RubyKernel.inspect(((RubyBasicObject)self2).getCurrentContext(), self2);
    }

    @JRubyMethod(name={"inspect"})
    public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
        return self2.inspect(context);
    }

    @JRubyMethod(name={"instance_of?"})
    public static RubyBoolean instance_of_p(ThreadContext context, IRubyObject self2, IRubyObject type2) {
        return ((RubyBasicObject)self2).instance_of_p(context, type2);
    }

    @JRubyMethod(name={"itself"})
    public static IRubyObject itself(IRubyObject self2) {
        return self2;
    }

    @JRubyMethod(name={"kind_of?", "is_a?"})
    public static RubyBoolean kind_of_p(ThreadContext context, IRubyObject self2, IRubyObject type2) {
        return ((RubyBasicObject)self2).kind_of_p(context, type2);
    }

    @JRubyMethod(name={"methods"}, optional=1, checkArity=false)
    public static IRubyObject methods(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return ((RubyBasicObject)self2).methods(context, args2);
    }

    @Deprecated(since="10.0.3.0")
    public static IRubyObject object_id(IRubyObject self2) {
        return self2.id();
    }

    @JRubyMethod(name={"object_id"})
    public static IRubyObject object_id(ThreadContext context, IRubyObject self2) {
        return self2.__id__(context);
    }

    @JRubyMethod(name={"public_methods"}, optional=1, checkArity=false)
    public static IRubyObject public_methods(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return ((RubyBasicObject)self2).public_methods(context, args2);
    }

    @JRubyMethod(name={"protected_methods"}, optional=1, checkArity=false)
    public static IRubyObject protected_methods(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return ((RubyBasicObject)self2).protected_methods(context, args2);
    }

    @JRubyMethod(name={"private_methods"}, optional=1, checkArity=false)
    public static IRubyObject private_methods(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return ((RubyBasicObject)self2).private_methods(context, args2);
    }

    @JRubyMethod(name={"singleton_methods"}, optional=1, checkArity=false)
    public static RubyArray singleton_methods(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return ((RubyBasicObject)self2).singleton_methods(context, args2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject singleton_method(IRubyObject self2, IRubyObject symbol) {
        return RubyKernel.singleton_method(((RubyBasicObject)self2).getCurrentContext(), self2, symbol);
    }

    @JRubyMethod(name={"singleton_method"})
    public static IRubyObject singleton_method(ThreadContext context, IRubyObject self2, IRubyObject symbol) {
        return ((RubyBasicObject)self2).singleton_method(context, symbol);
    }

    @JRubyMethod(name={"method"}, required=1, reads={FrameField.SCOPE})
    public static IRubyObject method(ThreadContext context, IRubyObject self2, IRubyObject symbol) {
        return ((RubyBasicObject)self2).method(context, symbol, context.getCurrentStaticScope());
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject to_s(IRubyObject self2) {
        return RubyKernel.to_s(((RubyBasicObject)self2).getCurrentContext(), self2);
    }

    @JRubyMethod(name={"to_s"})
    public static IRubyObject to_s(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).to_s(context);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject extend(IRubyObject self2, IRubyObject[] args2) {
        return RubyKernel.extend(((RubyBasicObject)self2).getCurrentContext(), self2, args2);
    }

    @JRubyMethod(name={"extend"}, required=1, rest=true, checkArity=false)
    public static IRubyObject extend(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, -1);
        return ((RubyBasicObject)self2).extend(args2);
    }

    @JRubyMethod(name={"send"}, omit=true, keywords=true)
    public static IRubyObject send(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block) {
        return ((RubyBasicObject)self2).send(context, arg0, block);
    }

    @JRubyMethod(name={"send"}, omit=true, keywords=true)
    public static IRubyObject send(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return ((RubyBasicObject)self2).send(context, arg0, arg1, block);
    }

    @JRubyMethod(name={"send"}, omit=true, keywords=true)
    public static IRubyObject send(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return ((RubyBasicObject)self2).send(context, arg0, arg1, arg2, block);
    }

    @JRubyMethod(name={"send"}, required=1, rest=true, checkArity=false, omit=true, keywords=true)
    public static IRubyObject send(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        Arity.checkArgumentCount(context, args2, 1, -1);
        return ((RubyBasicObject)self2).send(context, args2, block);
    }

    @JRubyMethod(name={"nil?"})
    public static IRubyObject nil_p(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).nil_p(context);
    }

    @JRubyMethod(name={"!~"}, writes={FrameField.BACKREF})
    public static IRubyObject op_not_match(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        return ((RubyBasicObject)self2).op_not_match(context, arg2);
    }

    @JRubyMethod(name={"instance_variable_defined?"})
    public static IRubyObject instance_variable_defined_p(ThreadContext context, IRubyObject self2, IRubyObject name2) {
        return ((RubyBasicObject)self2).instance_variable_defined_p(context, name2);
    }

    @JRubyMethod(name={"instance_variable_get"})
    public static IRubyObject instance_variable_get(ThreadContext context, IRubyObject self2, IRubyObject name2) {
        return ((RubyBasicObject)self2).instance_variable_get(context, name2);
    }

    @JRubyMethod(name={"instance_variable_set"})
    public static IRubyObject instance_variable_set(IRubyObject self2, IRubyObject name2, IRubyObject value2) {
        return ((RubyBasicObject)self2).instance_variable_set(name2, value2);
    }

    @JRubyMethod(name={"remove_instance_variable"})
    public static IRubyObject remove_instance_variable(ThreadContext context, IRubyObject self2, IRubyObject name2, Block block) {
        return ((RubyBasicObject)self2).remove_instance_variable(context, name2, block);
    }

    @JRubyMethod(name={"instance_variables"})
    public static RubyArray instance_variables(ThreadContext context, IRubyObject self2) {
        return ((RubyBasicObject)self2).instance_variables(context);
    }

    public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context).dup();
        if (!str.gsub_bang(context, arg0, block).isNil()) {
            context.setLastLine(str);
        }
        return str;
    }

    public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context).dup();
        if (!str.gsub_bang(context, arg0, arg1, block).isNil()) {
            context.setLastLine(str);
        }
        return str;
    }

    public static IRubyObject rbClone(IRubyObject self2) {
        return RubyKernel.rbClone(self2.getRuntime().getCurrentContext(), self2);
    }

    private static JavaSites.KernelSites sites(ThreadContext context) {
        return context.sites.Kernel;
    }

    @Deprecated(since="9.1.0.0")
    public static IRubyObject methodMissing(ThreadContext context, IRubyObject recv2, String name2, Visibility lastVis, CallType lastCallType, IRubyObject[] args2, Block block) {
        return RubyKernel.methodMissing(context, recv2, name2, lastVis, lastCallType, args2);
    }

    @Deprecated(since="9.1.16.0")
    private static IRubyObject caller(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 0: {
                return RubyKernel.caller(context, recv2);
            }
            case 1: {
                return RubyKernel.caller(context, recv2, args2[0]);
            }
            case 2: {
                return RubyKernel.caller(context, recv2, args2[0], args2[1]);
            }
        }
        Arity.checkArgumentCount(context, args2, 0, 2);
        return null;
    }

    @Deprecated(since="9.1.16.0")
    public static IRubyObject caller_locations(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return RubyKernel.caller_locations(context, recv2);
            }
            case 1: {
                return RubyKernel.caller_locations(context, recv2, args2[0]);
            }
            case 2: {
                return RubyKernel.caller_locations(context, recv2, args2[0], args2[1]);
            }
        }
        Arity.checkArgumentCount(context, args2, 0, 2);
        return null;
    }

    @Deprecated(since="9.2.7.0")
    public static IRubyObject require(IRubyObject recv2, IRubyObject name2, Block block) {
        return RubyKernel.require(((RubyBasicObject)recv2).getCurrentContext(), recv2, name2, block);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject op_match(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        Warn.warn(context, "deprecated Object#=~ is called on " + String.valueOf(((RubyBasicObject)self2).type()) + "; it always returns nil");
        return ((RubyBasicObject)self2).op_match(context, arg2);
    }

    @Deprecated(since="9.3.0.0")
    public static IRubyObject autoload(IRubyObject recv2, IRubyObject symbol, IRubyObject file2) {
        return RubyKernel.autoload(((RubyBasicObject)recv2).getCurrentContext(), recv2, symbol, file2);
    }

    @Deprecated(since="9.3.0.0")
    public static IRubyObject rand(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return RubyRandom.randFloat(context);
            }
            case 1: {
                return RubyRandom.randKernel(context, recv2, args2[0]);
            }
        }
        throw Error.argumentError(context, args2.length, 0, 1);
    }

    @Deprecated(since="9.4.0.0")
    public static IRubyObject method(IRubyObject self2, IRubyObject symbol) {
        return ((RubyBasicObject)self2).method(symbol);
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject tap(ThreadContext context, IRubyObject recv2, Block block) {
        if (block.getProcObject() != null) {
            block.getProcObject().call(context, recv2);
        } else {
            block.yield(context, recv2);
        }
        return recv2;
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject sleep(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return RubyKernel.sleep(context, recv2);
            }
            case 1: {
                return RubyKernel.sleep(context, recv2, args2[0]);
            }
        }
        throw Error.argumentError(context, args2.length, 0, 1);
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject test(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 2: {
                return RubyKernel.test(context, recv2, args2[0], args2[1]);
            }
            case 3: {
                return RubyKernel.test(context, recv2, args2[0], args2[1], args2[2]);
            }
        }
        throw Error.argumentError(context, args2.length, 2, 3);
    }

    public static class MethodMissingMethod
    extends JavaMethod.JavaMethodNBlock {
        private final Visibility visibility;
        private final CallType callType;

        MethodMissingMethod(RubyModule implementationClass, Visibility visibility, CallType callType) {
            super(implementationClass, Visibility.PRIVATE, "method_missing");
            this.callType = callType;
            this.visibility = visibility;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return RubyKernel.methodMissing(context, self2, name2, this.visibility, this.callType, args2);
        }
    }

    public static class LoopMethods {
        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
            return context.setLastLine(RubyKernel.getLastlineString(context).gsub(context, arg0, block));
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject gsub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return context.setLastLine(RubyKernel.getLastlineString(context).gsub(context, arg0, arg1, block));
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject sub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
            return context.setLastLine(RubyKernel.getLastlineString(context).sub(context, arg0, block));
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject sub(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return context.setLastLine(RubyKernel.getLastlineString(context).sub(context, arg0, arg1, block));
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject chop(ThreadContext context, IRubyObject recv2) {
            return context.setLastLine(RubyKernel.getLastlineString(context).chop(context));
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject chomp(ThreadContext context, IRubyObject recv2) {
            return context.setLastLine(RubyKernel.getLastlineString(context).chomp(context));
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
        public static IRubyObject chomp(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
            return context.setLastLine(RubyKernel.getLastlineString(context).chomp(context, arg0));
        }
    }
}

