/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.stream.Stream;
import org.jruby.Ruby;
import org.jruby.RubyArrayNative;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.JRubyAPI;
import org.jruby.api.Warn;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Builtins;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.specialized.RubyArrayOneObject;
import org.jruby.specialized.RubyArrayTwoObject;
import org.jruby.util.TypeConverter;
import org.jruby.util.collections.StringArraySet;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Array"}, include={"Enumerable"}, overrides={RubyArrayNative.class, RubyArrayOneObject.class, RubyArrayTwoObject.class, StringArraySet.class})
public abstract class RubyArray<T extends IRubyObject>
extends RubyObject
implements List,
RandomAccess {
    public static final int DEFAULT_INSPECT_STR_SIZE = 10;

    public static RubyClass createArrayClass(ThreadContext context, RubyClass Object2, RubyModule Enumerable) {
        return (RubyClass)((RubyModule)((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "Array", Object2, RubyArray::newEmptyArray).reifiedClass(RubyArray.class)).kindOf(new RubyModule.JavaClassKindOf(RubyArray.class))).classIndex(ClassIndex.ARRAY)).include(context, Enumerable)).defineMethods(context, RubyArray.class);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.ARRAY;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject create(IRubyObject klass, IRubyObject[] args2, Block block) {
        return RubyArray.create(klass.getRuntime().getCurrentContext(), klass, args2, block);
    }

    @JRubyMethod(name={"[]"}, rest=true, meta=true)
    public static IRubyObject create(ThreadContext context, IRubyObject klass, IRubyObject[] args2, Block block) {
        return RubyArrayNative.create(context, klass, args2, block);
    }

    protected RubyArray(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    protected RubyArray(RubyClass klass) {
        super(klass.runtime, klass);
    }

    protected RubyArray(Ruby runtime2, RubyClass klass, boolean objectSpace) {
        super(runtime2, klass, objectSpace);
    }

    public static RubyArray<?> newArray(Ruby runtime2, int len) {
        return RubyArrayNative.newArray(runtime2, len);
    }

    public static RubyArray<?> newArray(ThreadContext context, int len) {
        return RubyArrayNative.newArray(context, len);
    }

    public static RubyArray<?> newArrayLight(Ruby runtime2, int len) {
        return RubyArrayNative.newArrayLight(runtime2, len);
    }

    @Deprecated(since="10.0.0.0")
    public static final RubyArray<?> newArray(Ruby runtime2) {
        return RubyArray.newArray(runtime2.getCurrentContext());
    }

    public static RubyArray<?> newArray(ThreadContext context) {
        return RubyArrayNative.newArray(context);
    }

    public static RubyArray<?> newArrayLight(Ruby runtime2) {
        return RubyArrayNative.newArrayLight(runtime2);
    }

    public static RubyArray<?> newArray(Ruby runtime2, IRubyObject obj) {
        return RubyArrayNative.newArray(runtime2, obj);
    }

    public static RubyArray<?> newArrayLight(Ruby runtime2, IRubyObject obj) {
        return RubyArrayNative.newArrayLight(runtime2, obj);
    }

    public static RubyArray<?> newArrayLight(RubyClass arrayClass, IRubyObject obj) {
        return RubyArrayNative.newArrayLight(arrayClass, obj);
    }

    public static RubyArray<?> newArrayLight(Ruby runtime2, IRubyObject car, IRubyObject cdr) {
        return RubyArrayNative.newArrayLight(runtime2, car, cdr);
    }

    public static RubyArray<?> newArrayLight(RubyClass arrayClass, IRubyObject car, IRubyObject cdr) {
        return RubyArrayNative.newArrayLight(arrayClass, car, cdr);
    }

    public static RubyArray<?> newArrayLight(Ruby runtime2, IRubyObject ... objs) {
        return RubyArrayNative.newArrayLight(runtime2, objs);
    }

    public static RubyArray<?> newArray(Ruby runtime2, IRubyObject car, IRubyObject cdr) {
        return RubyArrayNative.newArray(runtime2, car, cdr);
    }

    public static RubyArray<?> newArray(Ruby runtime2, IRubyObject first2, IRubyObject second2, IRubyObject third) {
        return RubyArrayNative.newArray(runtime2, first2, second2, third);
    }

    public static RubyArray<?> newArray(Ruby runtime2, IRubyObject first2, IRubyObject second2, IRubyObject third, IRubyObject fourth) {
        return RubyArrayNative.newArray(runtime2, first2, second2, third, fourth);
    }

    public static RubyArray<?> newEmptyArray(Ruby runtime2) {
        return RubyArrayNative.newEmptyArray(runtime2);
    }

    public static RubyArray<?> newEmptyArray(Ruby runtime2, RubyClass klass) {
        return RubyArrayNative.newEmptyArray(runtime2, klass);
    }

    public static RubyArray<?> newArray(Ruby runtime2, IRubyObject[] args2) {
        return RubyArrayNative.newArray(runtime2, args2);
    }

    public static RubyArray<?> newArray(Ruby runtime2, Collection<? extends IRubyObject> collection) {
        return RubyArrayNative.newArray(runtime2, collection);
    }

    public static RubyArray<?> newArray(Ruby runtime2, List<? extends IRubyObject> list2) {
        return RubyArrayNative.newArray(runtime2, list2);
    }

    public static RubyArray<?> newSharedArray(RubyClass arrayClass, IRubyObject[] shared) {
        return RubyArrayNative.newSharedArray(arrayClass, shared);
    }

    public static RubyArray newArrayMayCopy(Ruby runtime2, IRubyObject ... args2) {
        return RubyArrayNative.newArrayMayCopy(runtime2, args2);
    }

    public static RubyArray newArrayMayCopy(Ruby runtime2, IRubyObject[] args2, int start2) {
        return RubyArrayNative.newArrayMayCopy(runtime2, args2, start2);
    }

    public static RubyArray newArrayMayCopy(Ruby runtime2, IRubyObject[] args2, int start2, int length2) {
        return RubyArrayNative.newArrayMayCopy(runtime2, args2, start2, length2);
    }

    public static RubyArray newArrayNoCopy(Ruby runtime2, IRubyObject ... args2) {
        return RubyArrayNative.newArrayNoCopy(runtime2, args2);
    }

    public static RubyArray newArrayNoCopy(Ruby runtime2, IRubyObject[] args2, int begin2) {
        return RubyArrayNative.newArrayNoCopy(runtime2, args2, begin2);
    }

    public static RubyArray newArrayNoCopy(Ruby runtime2, IRubyObject[] args2, int begin2, int length2) {
        return RubyArrayNative.newArrayNoCopy(runtime2, args2, begin2, length2);
    }

    public static RubyArray newArrayNoCopyLight(Ruby runtime2, IRubyObject[] args2) {
        return RubyArrayNative.newArrayNoCopyLight(runtime2, args2);
    }

    @Deprecated(since="10.0.0.0")
    protected static final void checkLength(Ruby runtime2, long length2) {
        RubyArray.checkLength(runtime2.getCurrentContext(), length2);
    }

    public static final int checkLength(ThreadContext context, long length2) {
        if (length2 < 0L) {
            throw Error.argumentError(context, "negative array size (or size too big)");
        }
        if (length2 >= Integer.MAX_VALUE) {
            throw Error.argumentError(context, "array size too big");
        }
        return (int)length2;
    }

    @Deprecated(since="9.4-")
    public final List<IRubyObject> getList() {
        return Arrays.asList(this.toJavaArray());
    }

    public abstract int getLength();

    @Deprecated(since="10.0.0.0")
    public IRubyObject[] toJavaArray() {
        return this.toJavaArray(this.getCurrentContext());
    }

    public abstract IRubyObject[] toJavaArray(ThreadContext var1);

    public abstract IRubyObject[] toJavaArrayUnsafe();

    public abstract IRubyObject[] toJavaArrayMaybeUnsafe();

    public abstract boolean isSharedJavaArray(RubyArray var1);

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public abstract IRubyObject initialize(ThreadContext var1, Block var2);

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public abstract IRubyObject initialize(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public abstract IRubyObject initialize(ThreadContext var1, IRubyObject var2, IRubyObject var3, Block var4);

    @Override
    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public abstract IRubyObject initialize_copy(ThreadContext var1, IRubyObject var2);

    public abstract RubyArray aryDup();

    @Deprecated(since="10.0.0.0")
    public IRubyObject replace(IRubyObject orig) {
        return this.replace(this.getCurrentContext(), orig);
    }

    @JRubyMethod(name={"replace"})
    public abstract IRubyObject replace(ThreadContext var1, IRubyObject var2);

    @Override
    public abstract RubyString to_s(ThreadContext var1);

    public abstract boolean includes(ThreadContext var1, IRubyObject var2);

    protected abstract boolean includesByEql(ThreadContext var1, IRubyObject var2);

    @Override
    @JRubyMethod(name={"hash"})
    public abstract RubyFixnum hash(ThreadContext var1);

    public abstract IRubyObject store(long var1, IRubyObject var3);

    @JRubyAPI
    public abstract IRubyObject store(ThreadContext var1, long var2, IRubyObject var4);

    protected abstract void storeInternal(ThreadContext var1, int var2, IRubyObject var3);

    protected abstract IRubyObject elt(long var1);

    public abstract T eltOk(long var1);

    public abstract T eltSetOk(long var1, T var3);

    public abstract T eltSetOk(int var1, T var2);

    public abstract IRubyObject entry(long var1);

    public abstract IRubyObject entry(int var1);

    public abstract T eltInternal(int var1);

    public abstract T eltInternalSet(int var1, T var2);

    @Deprecated(since="9.4-")
    public IRubyObject fetch(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.fetch(context, args2[0], block);
            }
            case 2: {
                return this.fetch(context, args2[0], args2[1], block);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(rest=true)
    public abstract IRubyObject fetch_values(ThreadContext var1, IRubyObject[] var2, Block var3);

    @JRubyMethod
    public abstract IRubyObject fetch(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod
    public abstract IRubyObject fetch(ThreadContext var1, IRubyObject var2, IRubyObject var3, Block var4);

    public static RubyArray aryToAry(ThreadContext context, IRubyObject obj) {
        IRubyObject tmp = TypeConverter.checkArrayType(context, obj);
        return tmp != context.nil ? (RubyArray<?>)tmp : RubyArray.newArray(context.runtime, obj);
    }

    @Deprecated(since="9.2.5.0")
    public static RubyArray aryToAry(IRubyObject obj) {
        return RubyArray.aryToAry(obj.getRuntime().getCurrentContext(), obj);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject insert(IRubyObject arg2) {
        return this.insert(this.getCurrentContext(), arg2);
    }

    @JRubyMethod(name={"insert"})
    public abstract IRubyObject insert(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject insert(IRubyObject arg1, IRubyObject arg2) {
        return this.insert(this.getCurrentContext(), arg1, arg2);
    }

    @JRubyMethod(name={"insert"})
    public abstract IRubyObject insert(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    @Deprecated(since="10.0.0.0")
    public IRubyObject insert(IRubyObject[] args2) {
        return this.insert(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"insert"}, required=1, rest=true, checkArity=false)
    public abstract IRubyObject insert(ThreadContext var1, IRubyObject[] var2);

    @Deprecated(since="10.0.0.0")
    public RubyArray transpose() {
        return this.transpose(this.getCurrentContext());
    }

    @JRubyMethod(name={"transpose"})
    public abstract RubyArray transpose(ThreadContext var1);

    @Deprecated(since="10.0.0.0")
    public IRubyObject values_at(IRubyObject[] args2) {
        return this.values_at(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public abstract IRubyObject values_at(ThreadContext var1, IRubyObject[] var2);

    public abstract IRubyObject subseqLight(long var1, long var3);

    public abstract IRubyObject subseq(RubyClass var1, long var2, long var4, boolean var6);

    @JRubyMethod(name={"length"}, alias={"size"})
    public abstract RubyFixnum length(ThreadContext var1);

    @Deprecated(since="10.0.0.0")
    public RubyFixnum length() {
        return this.length(this.getCurrentContext());
    }

    protected static IRubyObject size(ThreadContext context, RubyArray self2, IRubyObject[] args2) {
        return self2.length(context);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray<?> append(IRubyObject item) {
        return this.append(this.getCurrentContext(), item);
    }

    @JRubyMethod(name={"<<"})
    public abstract RubyArray append(ThreadContext var1, IRubyObject var2);

    @Deprecated
    public RubyArray<?> push_m(IRubyObject[] items) {
        return this.push(items);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray push(IRubyObject item) {
        this.append(item);
        return this;
    }

    @JRubyMethod(name={"push"}, alias={"append"})
    public abstract RubyArray push(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public RubyArray<?> push(IRubyObject[] items) {
        return this.push(this.getCurrentContext(), items);
    }

    @JRubyMethod(name={"push"}, alias={"append"}, rest=true)
    public abstract RubyArray push(ThreadContext var1, IRubyObject[] var2);

    @JRubyMethod
    public abstract IRubyObject pop(ThreadContext var1);

    @JRubyMethod
    public abstract IRubyObject pop(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"shift"})
    public abstract IRubyObject shift(ThreadContext var1);

    @JRubyMethod(name={"shift"})
    public abstract IRubyObject shift(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject unshift() {
        return this.unshift(this.getCurrentContext());
    }

    @JRubyMethod(name={"unshift"}, alias={"prepend"})
    public abstract IRubyObject unshift(ThreadContext var1);

    @Deprecated(since="10.0.0.0")
    public IRubyObject unshift(IRubyObject item) {
        return this.unshift(this.getCurrentContext(), item);
    }

    @JRubyMethod(name={"unshift"}, alias={"prepend"})
    public abstract IRubyObject unshift(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject unshift(IRubyObject[] items) {
        return this.unshift(this.getCurrentContext(), items);
    }

    @JRubyMethod(name={"unshift"}, alias={"prepend"}, rest=true)
    public abstract IRubyObject unshift(ThreadContext var1, IRubyObject[] var2);

    @JRubyMethod(name={"include?"})
    public abstract RubyBoolean include_p(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject aref(IRubyObject[] args2) {
        ThreadContext context = this.getCurrentContext();
        return switch (args2.length) {
            case 1 -> this.aref(context, args2[0]);
            case 2 -> this.aref(context, args2[0], args2[1]);
            default -> {
                Arity.raiseArgumentError(context, args2.length, 1, 2);
                yield null;
            }
        };
    }

    @Deprecated(since="9.4.0.0")
    public IRubyObject aref(IRubyObject arg0) {
        return this.aref(this.getCurrentContext(), arg0);
    }

    @JRubyMethod(name={"[]", "slice"})
    public abstract IRubyObject aref(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject aref(IRubyObject arg0, IRubyObject arg1) {
        return this.aref(this.getCurrentContext(), arg0, arg1);
    }

    @JRubyMethod(name={"[]", "slice"})
    public abstract IRubyObject aref(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    @Deprecated(since="9.4-")
    public IRubyObject aset(IRubyObject[] args2) {
        return switch (args2.length) {
            case 2 -> this.aset(args2[0], args2[1]);
            case 3 -> this.aset(args2[0], args2[1], args2[2]);
            default -> throw Error.argumentError(this.getCurrentContext(), "wrong number of arguments (" + args2.length + " for 2)");
        };
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject aset(IRubyObject arg0, IRubyObject arg1) {
        return this.aset(this.getCurrentContext(), arg0, arg1);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject aset(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.aset(this.getCurrentContext(), arg0, arg1, arg2);
    }

    @JRubyMethod(name={"[]="})
    public abstract IRubyObject aset(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    @JRubyMethod(name={"[]="})
    public abstract IRubyObject aset(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4);

    @Deprecated(since="10.0.0.0")
    public IRubyObject at(IRubyObject pos2) {
        return this.at(this.getCurrentContext(), pos2);
    }

    @JRubyMethod(name={"at"})
    public abstract IRubyObject at(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"concat"})
    public abstract RubyArray concat(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public RubyArray aryAppend(RubyArray y) {
        return this.aryAppend(this.getCurrentContext(), y);
    }

    public abstract RubyArray aryAppend(ThreadContext var1, RubyArray<?> var2);

    @JRubyMethod(name={"concat"}, rest=true)
    public abstract RubyArray concat(ThreadContext var1, IRubyObject[] var2);

    public abstract RubyArray concat(IRubyObject var1);

    @Override
    @JRubyMethod(name={"inspect"}, alias={"to_s"})
    public abstract RubyString inspect(ThreadContext var1);

    @Deprecated(since="9.4-")
    public IRubyObject first(IRubyObject[] args2) {
        return switch (args2.length) {
            case 0 -> this.first(this.getCurrentContext());
            case 1 -> this.first(this.getCurrentContext(), args2[0]);
            default -> {
                Arity.raiseArgumentError(this.getCurrentContext(), args2.length, 0, 1);
                yield null;
            }
        };
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject first() {
        return this.first(this.getCurrentContext());
    }

    @JRubyMethod(name={"first"})
    @JRubyAPI
    public abstract IRubyObject first(ThreadContext var1);

    @Deprecated(since="10.0.0.0")
    public IRubyObject first(IRubyObject arg0) {
        return this.first(this.getCurrentContext(), arg0);
    }

    @JRubyMethod(name={"first"})
    @JRubyAPI
    public abstract IRubyObject first(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="9.4-")
    public IRubyObject last(IRubyObject[] args2) {
        return switch (args2.length) {
            case 0 -> this.last(this.getCurrentContext());
            case 1 -> this.last(this.getCurrentContext(), args2[0]);
            default -> {
                Arity.raiseArgumentError(this.getCurrentContext(), args2.length, 0, 1);
                yield null;
            }
        };
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject last() {
        return this.last(this.getCurrentContext());
    }

    @JRubyMethod(name={"last"})
    @JRubyAPI
    public abstract IRubyObject last(ThreadContext var1);

    @Deprecated(since="10.0.0.0")
    public IRubyObject last(IRubyObject arg0) {
        return this.last(this.getCurrentContext(), arg0);
    }

    @JRubyMethod(name={"last"})
    public abstract IRubyObject last(ThreadContext var1, IRubyObject var2);

    @JRubyMethod
    public abstract IRubyObject each(ThreadContext var1, Block var2);

    public abstract IRubyObject eachSlice(ThreadContext var1, int var2, Block var3);

    @JRubyMethod
    public abstract IRubyObject each_slice(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod
    public abstract IRubyObject each_index(ThreadContext var1, Block var2);

    @JRubyMethod
    public abstract IRubyObject reverse_each(ThreadContext var1, Block var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject join19(ThreadContext context, IRubyObject sep) {
        return this.join(context, sep);
    }

    @JRubyMethod(name={"join"})
    public abstract IRubyObject join(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject join19(ThreadContext context) {
        return this.join(context);
    }

    @JRubyMethod(name={"join"})
    public abstract IRubyObject join(ThreadContext var1);

    @Override
    @JRubyMethod(name={"to_a"})
    public abstract RubyArray to_a(ThreadContext var1);

    @Deprecated(since="10.0.0.0")
    public IRubyObject to_ary() {
        return this;
    }

    @Deprecated(since="9.3.0.0")
    public IRubyObject to_h(ThreadContext context) {
        return this.to_h(context, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"to_ary"})
    public final IRubyObject to_ary(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"to_h"})
    public abstract IRubyObject to_h(ThreadContext var1, Block var2);

    @Override
    public final RubyArray convertToArray() {
        return this;
    }

    @Override
    public final IRubyObject checkArrayType() {
        return this;
    }

    @Override
    @JRubyMethod(name={"=="})
    public abstract IRubyObject op_equal(ThreadContext var1, IRubyObject var2);

    public abstract RubyBoolean compare(ThreadContext var1, CallSite var2, IRubyObject var3);

    @JRubyMethod(name={"eql?"})
    public abstract IRubyObject eql(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject compact_bang() {
        return this.compact_bang(this.getCurrentContext());
    }

    @JRubyMethod(name={"compact!"})
    public abstract IRubyObject compact_bang(ThreadContext var1);

    @Deprecated(since="10.0.0.0")
    public IRubyObject compact() {
        return this.compact(this.getCurrentContext());
    }

    @JRubyMethod(name={"compact"})
    public abstract IRubyObject compact(ThreadContext var1);

    @Deprecated(since="10.0.0.0")
    public IRubyObject empty_p() {
        return this.empty_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"empty?"})
    public abstract IRubyObject empty_p(ThreadContext var1);

    @Deprecated(since="10.0.0.0")
    public IRubyObject rb_clear() {
        return this.rb_clear(this.getCurrentContext());
    }

    @JRubyMethod(name={"clear"})
    public abstract IRubyObject rb_clear(ThreadContext var1);

    @JRubyMethod
    public abstract IRubyObject fill(ThreadContext var1, Block var2);

    @JRubyMethod
    public abstract IRubyObject fill(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod
    public abstract IRubyObject fill(ThreadContext var1, IRubyObject var2, IRubyObject var3, Block var4);

    @JRubyMethod
    public abstract IRubyObject fill(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, Block var5);

    public abstract IRubyObject index(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"index", "find_index"})
    public abstract IRubyObject index(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod(name={"index", "find_index"})
    public abstract IRubyObject index(ThreadContext var1, Block var2);

    @JRubyMethod
    public abstract IRubyObject bsearch(ThreadContext var1, Block var2);

    @JRubyMethod
    public abstract IRubyObject bsearch_index(ThreadContext var1, Block var2);

    @JRubyMethod
    public abstract IRubyObject rindex(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod
    public abstract IRubyObject rindex(ThreadContext var1, Block var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject indexes(IRubyObject[] args2) {
        return this.indexes(this.getCurrentContext(), args2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject indexes(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        Warn.warn(context, "Array#indexes is deprecated; use Array#values_at");
        if (argc == 1) {
            return Create.newArray(context, args2[0]);
        }
        RubyArrayNative ary = RubyArrayNative.newBlankArrayInternal(context.runtime, argc);
        for (int i2 = 0; i2 < argc; ++i2) {
            ary.storeInternal(context, i2, this.aref(context, args2[i2]));
        }
        ary.realLength = argc;
        return ary;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject reverse_bang() {
        return this.reverse_bang(this.getCurrentContext());
    }

    @JRubyMethod(name={"reverse!"})
    public abstract IRubyObject reverse_bang(ThreadContext var1);

    @Deprecated(since="10.0.0.0")
    public IRubyObject reverse() {
        return this.reverse(this.getCurrentContext());
    }

    @JRubyMethod(name={"reverse"})
    @JRubyAPI
    public abstract IRubyObject reverse(ThreadContext var1);

    @JRubyMethod(name={"collect"})
    public abstract IRubyObject rbCollect(ThreadContext var1, Block var2);

    @JRubyMethod(name={"map"})
    public abstract IRubyObject map(ThreadContext var1, Block var2);

    @JRubyMethod(name={"collect!"})
    public abstract IRubyObject collect_bang(ThreadContext var1, Block var2);

    @JRubyMethod(name={"map!"})
    public abstract IRubyObject map_bang(ThreadContext var1, Block var2);

    @JRubyMethod(name={"select"}, alias={"filter"})
    public abstract IRubyObject select(ThreadContext var1, Block var2);

    @JRubyMethod(name={"select!"}, alias={"filter!"})
    public abstract IRubyObject select_bang(ThreadContext var1, Block var2);

    @JRubyMethod
    public abstract IRubyObject keep_if(ThreadContext var1, Block var2);

    @JRubyMethod
    public final IRubyObject deconstruct(ThreadContext context) {
        return this;
    }

    @JRubyMethod
    public abstract IRubyObject delete(ThreadContext var1, IRubyObject var2, Block var3);

    @Deprecated(since="10.0.0.0")
    public IRubyObject delete_at(int pos2) {
        return this.delete_at(this.getCurrentContext(), pos2);
    }

    public abstract IRubyObject delete_at(ThreadContext var1, int var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject delete_at(IRubyObject obj) {
        return this.delete_at(this.getCurrentContext(), obj);
    }

    @JRubyMethod(name={"delete_at"})
    public abstract IRubyObject delete_at(ThreadContext var1, IRubyObject var2);

    @JRubyMethod
    public abstract IRubyObject reject(ThreadContext var1, Block var2);

    @JRubyMethod(name={"reject!"})
    public abstract IRubyObject reject_bang(ThreadContext var1, Block var2);

    @JRubyMethod
    public abstract IRubyObject delete_if(ThreadContext var1, Block var2);

    @JRubyMethod(optional=1, rest=true, checkArity=false)
    public abstract IRubyObject zip(ThreadContext var1, IRubyObject[] var2, Block var3);

    @Override
    @JRubyMethod(name={"<=>"})
    public abstract IRubyObject op_cmp(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="9.4-")
    public IRubyObject slice_bang(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.slice_bang(args2[0]);
            }
            case 2: {
                return this.slice_bang(args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(this.getCurrentContext(), args2.length, 1, 2);
        return null;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject slice_bang(IRubyObject arg0) {
        return this.slice_bang(this.getCurrentContext(), arg0);
    }

    @JRubyMethod(name={"slice!"})
    public abstract IRubyObject slice_bang(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject slice_bang(IRubyObject arg0, IRubyObject arg1) {
        return this.slice_bang(this.getCurrentContext(), arg0, arg1);
    }

    @JRubyMethod(name={"slice!"})
    public abstract IRubyObject slice_bang(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    @JRubyMethod(name={"assoc"})
    public abstract IRubyObject assoc(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"rassoc"})
    public abstract IRubyObject rassoc(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"flatten!"})
    public abstract IRubyObject flatten_bang(ThreadContext var1);

    @JRubyMethod(name={"flatten!"})
    public abstract IRubyObject flatten_bang(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"flatten"})
    public abstract IRubyObject flatten(ThreadContext var1);

    @JRubyMethod(name={"flatten"})
    public abstract IRubyObject flatten(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"count"})
    public abstract IRubyObject count(ThreadContext var1, Block var2);

    @JRubyMethod(name={"count"})
    public abstract IRubyObject count(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod(name={"nitems"})
    public abstract IRubyObject nitems(ThreadContext var1);

    @Deprecated(since="10.0.0.0")
    public IRubyObject nitems() {
        return this.nitems(this.getCurrentContext());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_plus(IRubyObject obj) {
        return this.op_plus(this.getCurrentContext(), obj);
    }

    @JRubyMethod(name={"+"})
    public abstract IRubyObject op_plus(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"*"})
    public abstract IRubyObject op_times(ThreadContext var1, IRubyObject var2);

    protected abstract RubyHash makeHash(Ruby var1);

    protected abstract RubyHash makeHash(RubyHash var1);

    @JRubyMethod(name={"uniq!"})
    public abstract IRubyObject uniq_bang(ThreadContext var1, Block var2);

    @JRubyMethod(name={"uniq"})
    public abstract IRubyObject uniq(ThreadContext var1, Block var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_diff(IRubyObject other) {
        return this.op_diff(this.getCurrentContext(), other);
    }

    @JRubyMethod(name={"-"})
    public abstract IRubyObject op_diff(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"difference"}, rest=true)
    public abstract IRubyObject difference(ThreadContext var1, IRubyObject[] var2);

    @JRubyMethod(rest=true)
    public abstract IRubyObject intersection(ThreadContext var1, IRubyObject[] var2);

    @JRubyMethod(name={"intersect?"})
    public abstract IRubyObject intersect_p(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_and(IRubyObject other) {
        return this.op_and(this.getCurrentContext(), other);
    }

    @JRubyMethod(name={"&"})
    public abstract IRubyObject op_and(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public IRubyObject op_or(IRubyObject other) {
        return this.op_or(this.getCurrentContext(), other);
    }

    @JRubyMethod(name={"|"})
    public abstract IRubyObject op_or(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"union"}, rest=true)
    public abstract IRubyObject union(ThreadContext var1, IRubyObject[] var2);

    protected abstract void unionInternal(ThreadContext var1, RubyArray ... var2);

    @JRubyMethod(name={"sort"})
    public abstract RubyArray sort(ThreadContext var1, Block var2);

    @JRubyMethod(name={"sort!"})
    public abstract IRubyObject sort_bang(ThreadContext var1, Block var2);

    @JRubyMethod(name={"sort_by!"})
    public abstract IRubyObject sort_by_bang(ThreadContext var1, Block var2);

    @JRubyMethod(name={"take"})
    public abstract IRubyObject take(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"take_while"})
    public abstract IRubyObject take_while(ThreadContext var1, Block var2);

    @JRubyMethod(name={"drop"})
    public abstract IRubyObject drop(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"drop_while"})
    public abstract IRubyObject drop_while(ThreadContext var1, Block var2);

    @JRubyMethod(name={"cycle"})
    public abstract IRubyObject cycle(ThreadContext var1, Block var2);

    @JRubyMethod(name={"cycle"})
    public abstract IRubyObject cycle(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod(name={"product"}, rest=true)
    public abstract IRubyObject product(ThreadContext var1, IRubyObject[] var2, Block var3);

    @JRubyMethod(name={"combination"})
    public abstract IRubyObject combination(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod(name={"repeated_combination"})
    public abstract IRubyObject repeatedCombination(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod(name={"permutation"})
    public abstract IRubyObject permutation(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod(name={"permutation"})
    public abstract IRubyObject permutation(ThreadContext var1, Block var2);

    @JRubyMethod(name={"repeated_permutation"})
    public abstract IRubyObject repeated_permutation(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod(name={"shuffle!"})
    public abstract IRubyObject shuffle_bang(ThreadContext var1);

    @JRubyMethod(name={"shuffle!"})
    public abstract IRubyObject shuffle_bang(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"shuffle"})
    public abstract IRubyObject shuffle(ThreadContext var1);

    @JRubyMethod(name={"shuffle"})
    public abstract IRubyObject shuffle(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"sample"})
    public abstract IRubyObject sample(ThreadContext var1);

    @JRubyMethod(name={"sample"})
    public abstract IRubyObject sample(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"sample"})
    public abstract IRubyObject sample(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    @JRubyMethod(name={"rotate!"})
    public abstract IRubyObject rotate_bang(ThreadContext var1);

    @JRubyMethod(name={"rotate!"})
    public abstract IRubyObject rotate_bang(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"rotate"})
    public abstract IRubyObject rotate(ThreadContext var1);

    @JRubyMethod(name={"rotate"})
    public abstract IRubyObject rotate(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"all?"})
    public abstract IRubyObject all_p(ThreadContext var1, Block var2);

    @JRubyMethod(name={"all?"})
    public abstract IRubyObject all_p(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod(name={"any?"})
    public abstract IRubyObject any_p(ThreadContext var1, Block var2);

    @JRubyMethod(name={"any?"})
    public abstract IRubyObject any_p(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod(name={"none?"})
    public abstract IRubyObject none_p(ThreadContext var1, Block var2);

    @JRubyMethod(name={"none?"})
    public abstract IRubyObject none_p(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod(name={"one?"})
    public abstract IRubyObject one_p(ThreadContext var1, Block var2);

    @JRubyMethod(name={"one?"})
    public abstract IRubyObject one_p(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod
    public abstract IRubyObject sum(ThreadContext var1, Block var2);

    @JRubyMethod
    public abstract IRubyObject sum(ThreadContext var1, IRubyObject var2, Block var3);

    public abstract IRubyObject find(ThreadContext var1, IRubyObject var2, Block var3);

    public abstract IRubyObject find_index(ThreadContext var1, Block var2);

    public abstract IRubyObject find_index(ThreadContext var1, IRubyObject var2);

    @Deprecated(since="10.0.0.0")
    public static RubyArray newBlankArray(Ruby runtime2, int size2) {
        return RubyArray.newBlankArray(runtime2.getCurrentContext(), size2);
    }

    public static RubyArray newBlankArray(ThreadContext context, int size2) {
        return RubyArrayNative.newBlankArray(context, size2);
    }

    @JRubyMethod(name={"try_convert"}, meta=true)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject self2, IRubyObject arg2) {
        return arg2.checkArrayType();
    }

    @JRubyMethod(name={"pack"})
    public abstract RubyString pack(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"pack"})
    public abstract RubyString pack(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    @JRubyMethod(name={"dig"})
    public abstract IRubyObject dig(ThreadContext var1, IRubyObject var2);

    @JRubyMethod(name={"dig"})
    public abstract IRubyObject dig(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    @JRubyMethod(name={"dig"})
    public abstract IRubyObject dig(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4);

    @JRubyMethod(name={"dig"}, required=1, rest=true, checkArity=false)
    public abstract IRubyObject dig(ThreadContext var1, IRubyObject[] var2);

    @JRubyMethod(name={"max"})
    public abstract IRubyObject max(ThreadContext var1, Block var2);

    @JRubyMethod(name={"max"})
    public abstract IRubyObject max(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod(name={"min"})
    public abstract IRubyObject min(ThreadContext var1, Block var2);

    @JRubyMethod(name={"min"})
    public abstract IRubyObject min(ThreadContext var1, IRubyObject var2, Block var3);

    @JRubyMethod
    public abstract IRubyObject minmax(ThreadContext var1, Block var2);

    @Override
    public Class getJavaClass() {
        return List.class;
    }

    @Deprecated(since="10.0.0.0")
    public void copyInto(IRubyObject[] target2, int start2) {
        this.copyInto(this.getCurrentContext(), target2, start2);
    }

    public abstract void copyInto(ThreadContext var1, IRubyObject[] var2, int var3);

    @Deprecated(since="10.0.0.0")
    public void copyInto(IRubyObject[] target2, int start2, int len) {
        this.copyInto(this.getCurrentContext(), target2, start2, len);
    }

    public abstract void copyInto(ThreadContext var1, IRubyObject[] var2, int var3, int var4);

    @Override
    public abstract boolean equals(Object var1);

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static void marshalTo(RubyArray array2, MarshalStream output) throws IOException {
        RubyArray.marshalTo(array2.getCurrentContext(), array2, output);
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static void marshalTo(ThreadContext context, RubyArray array2, MarshalStream output) throws IOException {
        output.registerLinkTarget(context, array2);
        int length2 = array2.getLength();
        output.writeInt(length2);
        for (int i2 = 0; i2 < length2; ++i2) {
            output.dumpObject((IRubyObject)array2.eltOk(i2));
        }
    }

    public static void marshalTo(ThreadContext context, RubyOutputStream out, RubyArray array2, MarshalDumper output) {
        output.registerObject(array2);
        int length2 = array2.getLength();
        output.writeInt(out, length2);
        for (int i2 = 0; i2 < length2; ++i2) {
            output.dumpObject(context, out, (IRubyObject)array2.eltOk(i2));
        }
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static RubyArray unmarshalFrom(UnmarshalStream input) throws IOException {
        int size2 = input.unmarshalInt();
        ThreadContext context = input.getRuntime().getCurrentContext();
        RubyArray result2 = (RubyArray)input.entry(Create.allocArray(context, size2));
        for (int i2 = 0; i2 < size2; ++i2) {
            result2.append(context, input.unmarshalObject());
        }
        return result2;
    }

    public static RubyArray unmarshalFrom(ThreadContext context, RubyInputStream in, MarshalLoader input) {
        int size2 = input.unmarshalInt(context, in);
        RubyArray result2 = (RubyArray)input.entry(Create.allocArray(context, size2));
        for (int i2 = 0; i2 < size2; ++i2) {
            result2.append(context, input.unmarshalObject(context, in));
        }
        return result2;
    }

    private static JavaSites.ArraySites sites(ThreadContext context) {
        return context.sites.Array;
    }

    @Deprecated(since="9.1.3.0")
    public void ensureCapacity(int minCapacity) {
        throw this.getRuntime().newNotImplementedError("RubyArray#ensure_capacity has been removed");
    }

    @Override
    @Deprecated(since="9.2.10.0")
    public RubyArray to_a() {
        throw this.getRuntime().newNotImplementedError("RubyArray#to_a has been removed");
    }

    @Deprecated(since="9.2.15.0")
    public IRubyObject shuffle(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.shuffle(context);
            }
            case 1: {
                return this.shuffle(context, args2[0]);
            }
        }
        throw Error.argumentError(context, args2.length, 0, 0);
    }

    @Deprecated(since="9.2.15.0")
    public IRubyObject shuffle_bang(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.shuffle_bang(context, context.nil);
            }
            case 1: {
                return this.shuffle_bang(context, args2[0]);
            }
        }
        throw Error.argumentError(context, args2.length, 0, 0);
    }

    @Deprecated(since="9.2.15.0")
    public IRubyObject sample(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.sample(context);
            }
            case 1: {
                return this.sample(context, args2[0]);
            }
            case 2: {
                return this.sample(context, args2[0], args2[1]);
            }
        }
        throw Error.argumentError(context, args2.length, 0, 1);
    }

    public abstract Stream<IRubyObject> rubyStream();

    public static class DefaultComparator
    implements Comparator<IRubyObject> {
        final ThreadContext context;
        private final boolean fixnumBypass;
        private final boolean stringBypass;

        public DefaultComparator(ThreadContext context) {
            this(context, true);
        }

        DefaultComparator(ThreadContext context, boolean honorOverride) {
            this.context = context;
            if (honorOverride && context != null) {
                this.fixnumBypass = !honorOverride || Builtins.checkIntegerCmp(context);
                this.stringBypass = !honorOverride || Builtins.checkStringCmp(context);
            } else {
                this.fixnumBypass = false;
                this.stringBypass = false;
            }
        }

        @Override
        public int compare(IRubyObject obj1, IRubyObject obj2) {
            if (this.fixnumBypass && obj1 instanceof RubyFixnum) {
                RubyFixnum fix1 = (RubyFixnum)obj1;
                if (obj2 instanceof RubyFixnum) {
                    RubyFixnum fix2 = (RubyFixnum)obj2;
                    return DefaultComparator.compareInteger(fix1, fix2);
                }
            }
            if (this.stringBypass && obj1 instanceof RubyString) {
                RubyString str1 = (RubyString)obj1;
                if (obj2 instanceof RubyString) {
                    RubyString str2 = (RubyString)obj2;
                    return DefaultComparator.compareString(str1, str2);
                }
            }
            return this.compareGeneric(obj1, obj2);
        }

        protected int compareGeneric(IRubyObject o1, IRubyObject o2) {
            ThreadContext context = this.context();
            return DefaultComparator.compareGeneric(context, RubyArray.sites((ThreadContext)context).op_cmp_sort, o1, o2);
        }

        protected ThreadContext context() {
            return this.context;
        }

        public static int compareInteger(RubyFixnum o1, RubyFixnum o2) {
            long b2;
            long a = o1.getValue();
            return a > (b2 = o2.getValue()) ? 1 : (a == b2 ? 0 : -1);
        }

        public static int compareString(RubyString o1, RubyString o2) {
            return o1.op_cmp(o2);
        }

        public static int compareGeneric(ThreadContext context, IRubyObject o1, IRubyObject o2) {
            return DefaultComparator.compareGeneric(context, RubyArray.sites((ThreadContext)context).op_cmp_sort, o1, o2);
        }

        public static int compareGeneric(ThreadContext context, CallSite op_cmp_sort, IRubyObject o1, IRubyObject o2) {
            IRubyObject ret = op_cmp_sort.call(context, o1, o1, o2);
            return RubyComparable.cmpint(context, ret, o1, o2);
        }
    }

    public static interface ArgumentVisitor {
        public IRubyObject visit(ThreadContext var1, IRubyObject var2, int var3);
    }
}

