/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.posix.POSIX;
import jnr.posix.Timeval;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.tz.FixedDateTimeZone;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.TypeError;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Builtins;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.ByteList;
import org.jruby.util.RubyDateFormatter;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.RubyTimeParser;
import org.jruby.util.Sprintf;
import org.jruby.util.time.TimeArgs;

@JRubyClass(name={"Time"}, include={"Comparable"})
public class RubyTime
extends RubyObject {
    public static final String UTC = "UTC";
    private static final BigDecimal ONE_MILLION_BD = BigDecimal.valueOf(1000000L);
    private static final BigDecimal ONE_BILLION_BD = BigDecimal.valueOf(1000000000L);
    public static final int TIME_SCALE = 1000000000;
    public static final int TIME_SCALE_DIGITS = 9;
    private DateTime dt;
    private long nsec;
    private IRubyObject zone;
    private static final DateTimeFormatter ONE_DAY_CTIME_FORMATTER = DateTimeFormat.forPattern("EEE MMM  d HH:mm:ss yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TWO_DAY_CTIME_FORMATTER = DateTimeFormat.forPattern("EEE MMM dd HH:mm:ss yyyy").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter INSPECT_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TZ_FORMATTER = DateTimeFormat.forPattern(" Z").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TO_S_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss Z").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter TO_S_UTC_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss 'UTC'").withLocale(Locale.ENGLISH);
    private static final Pattern TZ_PATTERN = Pattern.compile("([^-\\+\\d]+)?([\\+-]?)(\\d+)(?::(\\d+))?(?::(\\d+))?");
    private static final Pattern TIME_OFFSET_PATTERN = Pattern.compile("([\\+-])(\\d\\d):(\\d\\d)(?::(\\d\\d))?");
    private static final ByteList TZ_STRING = ByteList.create("TZ");
    private boolean isTzRelative = false;
    private static final DateTime TIME0 = new DateTime(0L, DateTimeZone.UTC);

    private void setIsTzRelative(boolean tzRelative) {
        this.isTzRelative = tzRelative;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.TIME;
    }

    @Deprecated(since="10.0.0.0")
    public static String getEnvTimeZone(Ruby runtime2) {
        return RubyTime.getEnvTimeZone(runtime2.getCurrentContext());
    }

    public static String getEnvTimeZone(ThreadContext context) {
        RubyString tz = context.runtime.tzVar;
        if (tz == null) {
            tz = Create.newString(context, TZ_STRING);
            tz.setFrozen(true);
            context.runtime.tzVar = tz;
        }
        RubyHash.RubyHashEntry entry = context.runtime.getENV().getEntry(tz);
        if (entry.key == null || entry.key == NEVER) {
            return null;
        }
        if (entry.key != tz) {
            context.runtime.tzVar = (RubyString)entry.key;
        }
        return entry.value instanceof RubyString ? entry.value.asJavaString() : null;
    }

    @Deprecated(since="10.0.0.0")
    public static DateTimeZone getLocalTimeZone(Ruby runtime2) {
        return RubyTime.getLocalTimeZone(runtime2.getCurrentContext());
    }

    public static DateTimeZone getLocalTimeZone(ThreadContext context) {
        String tz = RubyTime.getEnvTimeZone(context);
        return tz == null ? DateTimeZone.getDefault() : RubyTime.getTimeZoneFromTZString(context, tz);
    }

    @Deprecated(since="10.0.0.0")
    public static DateTimeZone getTimeZoneFromTZString(Ruby runtime2, String zone2) {
        return RubyTime.getTimeZoneFromTZString(runtime2.getCurrentContext(), zone2);
    }

    public static DateTimeZone getTimeZoneFromTZString(ThreadContext context, String zone2) {
        DateTimeZone cachedZone = context.runtime.getTimezoneCache().get(zone2);
        if (cachedZone != null) {
            return cachedZone;
        }
        DateTimeZone dtz = RubyTime.parseTZString(context, zone2);
        context.runtime.getTimezoneCache().put(zone2, dtz);
        return dtz;
    }

    private static DateTimeZone parseTZString(ThreadContext context, String zone2) {
        Matcher tzMatcher = TZ_PATTERN.matcher(zone2);
        if (tzMatcher.matches()) {
            String zoneName = tzMatcher.group(1);
            String sign2 = tzMatcher.group(2);
            String hours = tzMatcher.group(3);
            String minutes = tzMatcher.group(4);
            String seconds = tzMatcher.group(5);
            if (zoneName == null) {
                zoneName = "";
            }
            return RubyTime.getTimeZoneFromHHMM(context, zoneName, sign2.equals("-"), hours, minutes, seconds);
        }
        if (zone2.length() == 3) {
            switch (zone2.toUpperCase()) {
                case "MET": {
                    zone2 = "CET";
                    break;
                }
                case "ROC": {
                    zone2 = "Asia/Taipei";
                    break;
                }
                case "WET": {
                    zone2 = "Europe/Lisbon";
                    break;
                }
                case "UTC": {
                    zone2 = "Etc/UTC";
                    break;
                }
                case "GMT": {
                    zone2 = "Etc/GMT";
                }
            }
        }
        try {
            return DateTimeZone.forID(zone2);
        }
        catch (IllegalArgumentException e) {
            context.runtime.getWarnings().warning("Unrecognized time zone: " + zone2);
            return DateTimeZone.UTC;
        }
    }

    @Deprecated(since="10.0.0.0")
    public static DateTimeZone getTimeZoneFromString(Ruby runtime2, String zone2) {
        DateTimeZone cachedZone = runtime2.getTimezoneCache().get(zone2);
        if (cachedZone != null) {
            return cachedZone;
        }
        DateTimeZone dtz = RubyTime.parseZoneString(runtime2.getCurrentContext(), zone2);
        runtime2.getTimezoneCache().put(zone2, dtz);
        return dtz;
    }

    private static DateTimeZone parseZoneString(ThreadContext context, String zone2) {
        return RubyTime.parseTZString(context, zone2);
    }

    public static DateTimeZone getTimeZoneFromUtcOffset(ThreadContext context, IRubyObject arg2) {
        DateTimeZone dtz;
        String strOffset = arg2.toString();
        DateTimeZone cachedZone = context.runtime.getTimezoneCache().get(strOffset);
        if (cachedZone != null) {
            return cachedZone;
        }
        IRubyObject tmp = arg2.checkStringType();
        if (!tmp.isNil()) {
            RubyString tmpString = (RubyString)tmp;
            ByteList tmpBytes = tmpString.getByteList();
            int n = 0;
            int min2 = -1;
            int sec2 = -1;
            if (!tmpBytes.getEncoding().isAsciiCompatible()) {
                return null;
            }
            switch (tmpBytes.realSize()) {
                case 1: {
                    if (tmpBytes.get(0) == 90) {
                        return DateTimeZone.UTC;
                    }
                    if (tmpBytes.get(0) >= 65 && tmpBytes.get(0) <= 73) {
                        n = tmpBytes.get(0) - 65 + 1;
                    } else if (tmpBytes.get(0) >= 75 && tmpBytes.get(0) <= 77) {
                        n = tmpBytes.get(0) - 65;
                    } else if (tmpBytes.get(0) >= 78 && tmpBytes.get(0) <= 89) {
                        n = 77 - tmpBytes.get(0);
                    } else {
                        return null;
                    }
                    n *= 3600;
                    break;
                }
                case 3: {
                    if (!tmpBytes.toByteString().equals(UTC)) break;
                    return DateTimeZone.UTC;
                }
                case 5: {
                    min2 = 3;
                    break;
                }
                case 6: {
                    min2 = 4;
                    break;
                }
                case 7: {
                    sec2 = 5;
                    min2 = 3;
                    break;
                }
                case 9: {
                    sec2 = 7;
                    min2 = 4;
                    break;
                }
                default: {
                    return null;
                }
            }
            if (sec2 > -1) {
                if (sec2 == 7 && tmpBytes.get(sec2 - 1) != 58) {
                    return null;
                }
                if (!Character.isDigit(tmpBytes.get(sec2)) || !Character.isDigit(tmpBytes.get(sec2 + 1))) {
                    return null;
                }
                n += tmpBytes.get(sec2) * 10 + tmpBytes.get(sec2 + 1) - 528;
            }
            if (min2 > -1) {
                if (min2 == 4 && tmpBytes.get(min2 - 1) != 58) {
                    return null;
                }
                if (!Character.isDigit(tmpBytes.get(min2)) || !Character.isDigit(tmpBytes.get(min2 + 1))) {
                    return null;
                }
                if (tmpBytes.get(min2) > 53) {
                    return null;
                }
                n += (tmpBytes.get(min2) * 10 + tmpBytes.get(min2 + 1) - 528) * 60;
            }
            if (tmpBytes.realSize() >= 3) {
                byte first2 = (byte)tmpBytes.get(0);
                if (first2 != 43 && first2 != 45) {
                    return null;
                }
                if (!Character.isDigit(tmpBytes.get(1)) || !Character.isDigit(tmpBytes.get(2))) {
                    return null;
                }
                n += (tmpBytes.get(1) * 10 + tmpBytes.get(2) - 528) * 3600;
                if (first2 == 45) {
                    if (n == 0) {
                        return DateTimeZone.UTC;
                    }
                    n = -n;
                }
            }
            dtz = RubyTime.getTimeZoneWithOffset(context, "", n * 1000);
        } else {
            RubyNumeric numericOffset = RubyTime.numExact(context, arg2);
            int newOffset = (int)Math.round(numericOffset.convertToFloat().value * 1000.0);
            dtz = RubyTime.getTimeZoneWithOffset(context, "", newOffset);
        }
        context.runtime.getTimezoneCache().put(strOffset, dtz);
        return dtz;
    }

    @Deprecated(since="10.0.0.0")
    public static RaiseException invalidUTCOffset(Ruby runtime2) {
        return RubyTime.invalidUTCOffset(runtime2.getCurrentContext());
    }

    public static RaiseException invalidUTCOffset(ThreadContext context) {
        return Error.argumentError(context, "\"+HH:MM\" or \"-HH:MM\" expected for utc_offset");
    }

    @Deprecated(since="10.0.0.0")
    public static RaiseException invalidUTCOffset(Ruby runtime2, IRubyObject value2) {
        return RubyTime.invalidUTCOffset(runtime2.getCurrentContext(), value2);
    }

    public static RaiseException invalidUTCOffset(ThreadContext context, IRubyObject value2) {
        return Error.argumentError(context, RubyStringBuilder.str(context.runtime, "\"+HH:MM\", \"-HH:MM\", \"UTC\" or \"A\"..\"I\",\"K\"..\"Z\" expected for utc_offset: ", value2));
    }

    private static RubyNumeric numExact(ThreadContext context, IRubyObject v) {
        boolean hasTypeError = false;
        switch (v.getMetaClass().getClassIndex()) {
            case NIL: {
                throw Error.typeError(context, "can't convert nil into an exact number");
            }
            case INTEGER: {
                return (RubyInteger)v;
            }
            case RATIONAL: {
                break;
            }
            case STRING: {
                hasTypeError = true;
                break;
            }
            default: {
                IRubyObject tmp = v.getMetaClass().finvokeChecked(context, v, RubyTime.sites((ThreadContext)context).checked_to_r);
                if (tmp != null) {
                    if (!RubyTime.sites((ThreadContext)context).respond_to_to_int.respondsTo(context, v, v)) {
                        hasTypeError = true;
                        break;
                    }
                    v = tmp;
                    break;
                }
                tmp = Convert.checkToInteger(context, v);
                if (!tmp.isNil()) {
                    v = tmp;
                    break;
                }
                hasTypeError = true;
            }
        }
        switch (v.getMetaClass().getClassIndex()) {
            case INTEGER: {
                return (RubyInteger)v;
            }
            case RATIONAL: {
                if (!((RubyRational)v).getDenominator().isOne(context)) break;
                return ((RubyRational)v).getNumerator();
            }
            default: {
                hasTypeError = true;
            }
        }
        if (hasTypeError) {
            throw Error.typeError(context, "can't convert ", v, " into an exact number");
        }
        return (RubyNumeric)v;
    }

    private static DateTimeZone getTimeZoneFromHHMM(ThreadContext context, String name2, boolean positive, String hours, String minutes, String seconds) {
        int s2;
        int h = Integer.parseInt(hours);
        int m = minutes != null ? Integer.parseInt(minutes) : 0;
        int n = s2 = seconds != null ? Integer.parseInt(seconds) : 0;
        if (h > 23 || m > 59) {
            throw Error.argumentError(context, "utc_offset out of range");
        }
        int offset2 = (positive ? 1 : -1) * (h * 3600 + m * 60 + s2) * 1000;
        return RubyTime.timeZoneWithOffset(name2, offset2);
    }

    @Deprecated(since="10.0.0.0")
    public static DateTimeZone getTimeZone(Ruby runtime2, long seconds) {
        return RubyTime.getTimeZone(runtime2.getCurrentContext(), seconds);
    }

    public static DateTimeZone getTimeZone(ThreadContext context, long seconds) {
        if (seconds >= 86400L || seconds <= -86400L) {
            throw Error.argumentError(context, "utc_offset out of range");
        }
        return RubyTime.getTimeZoneWithOffset(context, "", (int)(seconds * 1000L));
    }

    @Deprecated(since="10.0.0.0")
    public static DateTimeZone getTimeZoneWithOffset(Ruby runtime2, String zoneName, int offset2) {
        return RubyTime.getTimeZoneWithOffset(runtime2.getCurrentContext(), zoneName, offset2);
    }

    public static DateTimeZone getTimeZoneWithOffset(ThreadContext context, String zoneName, int offset2) {
        zoneName = zoneName.trim();
        String zone2 = zoneName + offset2;
        DateTimeZone cachedZone = context.runtime.getTimezoneCache().get(zone2);
        if (cachedZone != null) {
            return cachedZone;
        }
        try {
            DateTimeZone dtz = RubyTime.timeZoneWithOffset(zoneName, offset2);
            if (zone2.length() > 0) {
                context.runtime.getTimezoneCache().put(zone2, dtz);
            }
            return dtz;
        }
        catch (IllegalArgumentException iae) {
            throw Error.argumentError(context, "utc_offset out of range");
        }
    }

    private static DateTimeZone timeZoneWithOffset(String zoneName, int offset2) {
        return zoneName.isEmpty() ? DateTimeZone.forOffsetMillis(offset2) : new FixedDateTimeZone(zoneName, null, offset2, offset2);
    }

    public RubyTime(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public RubyTime(Ruby runtime2, RubyClass rubyClass, DateTime dt) {
        super(runtime2, rubyClass);
        this.dt = dt;
    }

    public RubyTime(Ruby runtime2, RubyClass rubyClass, DateTime dt, boolean tzRelative) {
        super(runtime2, rubyClass);
        this.dt = dt;
        this.setIsTzRelative(tzRelative);
    }

    public static RubyClass createTimeClass(ThreadContext context, RubyClass Object2, RubyModule Comparable2) {
        return (RubyClass)((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "Time", Object2, RubyTime::new).reifiedClass(RubyTime.class)).classIndex(ClassIndex.TIME)).include(context, Comparable2)).defineMethods(context, RubyTime.class);
    }

    public void setNSec(long nsec2) {
        this.nsec = nsec2;
    }

    public long getNSec() {
        return this.nsec;
    }

    public void setUSec(long usec2) {
        this.nsec = 1000L * usec2;
    }

    public long getUSec() {
        return this.nsec / 1000L;
    }

    public void setZoneObject(IRubyObject zone2) {
        this.zone = zone2;
    }

    @Deprecated(since="9.2.0.0")
    public void updateCal(DateTime dt) {
        this.dt = dt;
    }

    public static RubyTime newTime(Ruby runtime2, long milliseconds) {
        return RubyTime.newTime(runtime2, new DateTime(milliseconds));
    }

    @Deprecated(since="10.0.0.0")
    public static RubyTime newTimeFromNanoseconds(Ruby runtime2, long nanoseconds) {
        return RubyTime.newTimeFromNanoseconds(runtime2.getCurrentContext(), nanoseconds);
    }

    public static RubyTime newTimeFromNanoseconds(ThreadContext context, long nanoseconds) {
        long milliseconds = nanoseconds / 1000000L;
        long extraNanoseconds = nanoseconds % 1000000L;
        return RubyTime.newTime(context.runtime, new DateTime(milliseconds, RubyTime.getLocalTimeZone(context)), extraNanoseconds);
    }

    public static RubyTime newTime(Ruby runtime2, DateTime dt) {
        return new RubyTime(runtime2, runtime2.getTime(), dt);
    }

    public static RubyTime newTime(Ruby runtime2, DateTime dt, long nsec2) {
        RubyTime t = new RubyTime(runtime2, runtime2.getTime(), dt);
        t.setNSec(nsec2);
        return t;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject original) {
        if (!(original instanceof RubyTime)) {
            throw Error.typeError(context, original, "Time");
        }
        RubyTime originalTime = (RubyTime)original;
        this.dt = originalTime.dt;
        this.nsec = originalTime.nsec;
        this.isTzRelative = originalTime.isTzRelative;
        this.zone = originalTime.zone;
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public RubyTime gmtime() {
        return this.gmtime(this.getCurrentContext());
    }

    @JRubyMethod(name={"gmtime", "utc", "to_time"})
    public RubyTime gmtime(ThreadContext context) {
        return this.adjustTimeZone(context, DateTimeZone.UTC, false);
    }

    public final RubyTime localtime() {
        return this.localtime(this.metaClass.runtime.getCurrentContext());
    }

    @JRubyMethod(name={"localtime"})
    public RubyTime localtime(ThreadContext context) {
        return this.adjustTimeZone(context, RubyTime.getLocalTimeZone(context), false);
    }

    @JRubyMethod(name={"localtime"})
    public RubyTime localtime(ThreadContext context, IRubyObject arg2) {
        this.setIsTzRelative(false);
        DateTimeZone zone2 = this.handleUTCDateTimeZone(context, arg2);
        if (zone2 == null) {
            throw RubyTime.invalidUTCOffset(context);
        }
        return this.adjustTimeZone(context, zone2, this.isTzRelative);
    }

    private RubyTime adjustTimeZone(ThreadContext context, DateTimeZone zone2, boolean isTzRelative) {
        boolean zoneOk = zone2.equals(this.dt.getZone());
        if (zoneOk && isTzRelative == this.isTzRelative) {
            return this;
        }
        if (this.isFrozen()) {
            throw context.runtime.newFrozenError("Time", this);
        }
        if (!zoneOk) {
            this.dt = this.dt.withZone(zone2);
        }
        this.setIsTzRelative(isTzRelative);
        return this;
    }

    @JRubyMethod(name={"gmt?", "utc?", "gmtime?"})
    public RubyBoolean gmt(ThreadContext context) {
        return Convert.asBoolean(context, this.isUTC());
    }

    @Deprecated(since="10.0.0.0")
    public RubyBoolean gmt() {
        return this.gmt(this.getRuntime().getCurrentContext());
    }

    public boolean isUTC() {
        return !this.isTzRelative && this.dt.getZone() == DateTimeZone.UTC;
    }

    @JRubyMethod(name={"getgm", "getutc"})
    public RubyTime getgm() {
        return RubyTime.newTime(this.metaClass.runtime, this.dt.withZone(DateTimeZone.UTC), this.nsec);
    }

    public final RubyTime getlocal() {
        return this.getlocal(this.metaClass.runtime.getCurrentContext());
    }

    @JRubyMethod(name={"getlocal"})
    public RubyTime getlocal(ThreadContext context) {
        return RubyTime.newTime(context.runtime, this.dt.withZone(RubyTime.getLocalTimeZone(context)), this.nsec);
    }

    @JRubyMethod(name={"getlocal"})
    public RubyTime getlocal(ThreadContext context, IRubyObject off) {
        RubyTime t;
        if (off == context.nil) {
            return RubyTime.newTime(context.runtime, this.dt.withZone(RubyTime.getLocalTimeZone(context)), this.nsec);
        }
        IRubyObject zone2 = off;
        if (RubyTime.maybeTimezoneObject(zone2) && RubyTime.zoneLocalTime(context, off, t = (RubyTime)this.dup())) {
            return t;
        }
        DateTimeZone dtz = RubyTime.getTimeZoneFromUtcOffset(context, off);
        if (dtz == null) {
            if (!RubyTime.zoneLocalTime(context, zone2 = this.findTimezone(context, zone2), t = (RubyTime)this.dup())) {
                throw RubyTime.invalidUTCOffset(context, zone2);
            }
            return t;
        }
        if (dtz == DateTimeZone.UTC) {
            return ((RubyTime)this.dup()).gmtime(context);
        }
        return ((RubyTime)this.dup()).adjustTimeZone(context, dtz, false);
    }

    @Deprecated(since="9.2.0.0")
    public RubyString strftime(IRubyObject format) {
        return this.strftime(this.getRuntime().getCurrentContext(), format);
    }

    @JRubyMethod
    public RubyString strftime(ThreadContext context, IRubyObject format) {
        RubyDateFormatter rdf = context.getRubyDateFormatter();
        return rdf.compileAndFormat(format.convertToString().getByteList(), false, this.dt, this.nsec, null);
    }

    @JRubyMethod(name={"xmlschema", "iso8601"}, optional=1, checkArity=false)
    public RubyString xmlschema(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        int fractionDigits = 0;
        if (args2.length > 0 && (fractionDigits = Convert.toInt(context, args2[0])) < 0) {
            fractionDigits = 0;
        }
        int sizeAfterYear = (this.isUTC() ? 16 : 21) + fractionDigits + (fractionDigits > 0 ? 1 : 0);
        int year2 = this.dt.getYear();
        int yearSize = 4;
        int yearScale = 1000;
        boolean yearNeg = false;
        if (year2 < 0) {
            yearNeg = true;
            year2 = -year2;
        }
        if (year2 > 9999) {
            int y = year2 / yearScale;
            while (y > 9) {
                y /= 10;
                ++yearSize;
                yearScale *= 10;
            }
        }
        byte[] buf = new byte[(yearNeg ? 1 : 0) + yearSize + sizeAfterYear];
        int pos2 = 0;
        if (yearNeg) {
            buf[pos2++] = 45;
        }
        pos2 = RubyTime.fillDigits(buf, pos2, year2, yearSize, yearScale);
        pos2 = RubyTime.fillDigitsAfterChar(buf, pos2, '-', this.dt.getMonthOfYear(), 2, 10);
        pos2 = RubyTime.fillDigitsAfterChar(buf, pos2, '-', this.dt.getDayOfMonth(), 2, 10);
        pos2 = RubyTime.fillDigitsAfterChar(buf, pos2, 'T', this.dt.getHourOfDay(), 2, 10);
        pos2 = RubyTime.fillDigitsAfterChar(buf, pos2, ':', this.dt.getMinuteOfHour(), 2, 10);
        pos2 = RubyTime.fillDigitsAfterChar(buf, pos2, ':', this.dt.getSecondOfMinute(), 2, 10);
        if (fractionDigits > 0) {
            pos2 = RubyTime.fillDigitsAfterChar(buf, pos2, '.', this.getNanos(), fractionDigits, 100000000);
        }
        if (this.isUTC()) {
            buf[pos2++] = 90;
        } else {
            int offset2 = this.dt.getZone().getOffset(this.dt.getMillis()) / 1000 / 60;
            char offsetSign = '+';
            if (offset2 < 0) {
                offset2 = -offset2;
                offsetSign = '-';
            }
            pos2 = RubyTime.fillDigitsAfterChar(buf, pos2, offsetSign, offset2 / 60, 2, 10);
            pos2 = RubyTime.fillDigitsAfterChar(buf, pos2, ':', offset2 % 60, 2, 10);
        }
        return Create.newString(context, new ByteList(buf, false));
    }

    private static int fillDigits(byte[] buf, int begin2, int number, int size2, int divisor) {
        int pos2 = begin2;
        for (int i2 = 0; i2 < size2; ++i2) {
            if (divisor > 0) {
                buf[pos2++] = (byte)(48 + number / divisor % 10);
                divisor /= 10;
                continue;
            }
            buf[pos2++] = 48;
        }
        return pos2;
    }

    private static int fillDigitsAfterChar(byte[] buf, int begin2, char firstChar, int number, int size2, int divisor) {
        buf[begin2] = (byte)firstChar;
        return RubyTime.fillDigits(buf, begin2 + 1, number, size2, divisor);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return Convert.asBoolean(context, RubyTime.safeCmp(context, this, other) == 0);
        }
        if (other == context.nil) {
            return context.fals;
        }
        return RubyComparable.op_equal(context, this, other);
    }

    private static int safeCmp(ThreadContext context, RubyTime self2, IRubyObject other) {
        int cmpResult = self2.metaClass == context.runtime.getTime() && Builtins.checkTimeCmp(context) ? self2.cmp((RubyTime)other) : Convert.toInt(context, RubyTime.sites((ThreadContext)context).cmp.call(context, (IRubyObject)self2, (IRubyObject)self2, other));
        return cmpResult;
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return Convert.asBoolean(context, RubyTime.safeCmp(context, this, other) >= 0);
        }
        return RubyComparable.op_ge(context, this, other);
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return Convert.asBoolean(context, RubyTime.safeCmp(context, this, other) > 0);
        }
        return RubyComparable.op_gt(context, this, other);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return Convert.asBoolean(context, RubyTime.safeCmp(context, this, other) <= 0);
        }
        return RubyComparable.op_le(context, this, other);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return Convert.asBoolean(context, RubyTime.safeCmp(context, this, other) < 0);
        }
        return RubyComparable.op_lt(context, this, other);
    }

    private int cmp(RubyTime other) {
        long millis = this.getTimeInMillis();
        long millis_other = other.getTimeInMillis();
        long nsec2 = this.nsec;
        long nsec_other = other.nsec;
        if (millis > millis_other || millis == millis_other && nsec2 > nsec_other) {
            return 1;
        }
        if (millis < millis_other || millis == millis_other && nsec2 < nsec_other) {
            return -1;
        }
        return 0;
    }

    public IRubyObject op_plus(IRubyObject other) {
        return this.op_plus(this.getRuntime().getCurrentContext(), other);
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            throw Error.typeError(context, "time + time?");
        }
        double adjustMillis = Convert.toDouble(context, RubyTime.numExact(context, other)) * 1000.0;
        return this.opPlusMillis(context.runtime, adjustMillis);
    }

    private RubyTime opPlusMillis(Ruby runtime2, double adjustMillis) {
        long currentMillis = this.getTimeInMillis();
        long newMillisPart = currentMillis + (long)adjustMillis;
        long adjustNanos = (long)((adjustMillis - Math.floor(adjustMillis)) * 1000000.0);
        long newNanosPart = this.nsec + adjustNanos;
        if (newNanosPart >= 1000000L) {
            newNanosPart -= 1000000L;
            ++newMillisPart;
        }
        RubyTime newTime = new RubyTime(runtime2, this.getMetaClass());
        newTime.dt = new DateTime(newMillisPart, this.dt.getZone());
        newTime.setNSec(newNanosPart);
        newTime.setIsTzRelative(this.isTzRelative);
        newTime.setZoneObject(this.zone);
        return newTime;
    }

    private RubyFloat opMinus(ThreadContext context, RubyTime other) {
        long timeInMillis = this.getTimeInMillis() - other.getTimeInMillis();
        double timeInSeconds = (double)timeInMillis / 1000.0 + (double)(this.getNSec() - other.getNSec()) / 1.0E9;
        return Convert.asFloat(context, timeInSeconds);
    }

    public IRubyObject op_minus(IRubyObject other) {
        return this.op_minus(this.getRuntime().getCurrentContext(), other);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            RubyTime time = (RubyTime)other;
            return this.opMinus(context, time);
        }
        return this.opMinus(context, Convert.toDouble(context, RubyTime.numExact(context, other)));
    }

    private RubyTime opMinus(ThreadContext context, double other) {
        long nano;
        long adjustmentInNanos = (long)(other * 1.0E9);
        long adjustmentInMillis = adjustmentInNanos / 1000000L;
        long adjustmentInNanosLeft = adjustmentInNanos % 1000000L;
        long time = this.getTimeInMillis() - adjustmentInMillis;
        if (this.nsec < adjustmentInNanosLeft) {
            --time;
            nano = 1000000L - (adjustmentInNanosLeft - this.nsec);
        } else {
            nano = this.nsec - adjustmentInNanosLeft;
        }
        RubyTime newTime = new RubyTime(context.runtime, this.getMetaClass());
        newTime.dt = new DateTime(time, this.dt.getZone());
        newTime.setNSec(nano);
        newTime.setIsTzRelative(this.isTzRelative);
        newTime.setZoneObject(this.zone);
        return newTime;
    }

    @Override
    @JRubyMethod(name={"==="})
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyTime) {
            return Convert.asBoolean(context, Convert.toInt(context, Helpers.invokedynamic(context, (IRubyObject)this, MethodNames.OP_CMP, other)) == 0);
        }
        return context.fals;
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        return other instanceof RubyTime ? Convert.asFixnum(context, this.cmp((RubyTime)other)) : RubyComparable.invcmp(context, RubyTime.sites((ThreadContext)context).recursive_cmp, this, other);
    }

    @Override
    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context, IRubyObject otherArg) {
        if (otherArg instanceof RubyTime) {
            RubyTime other = (RubyTime)otherArg;
            return this.nsec == other.nsec && this.getTimeInMillis() == other.getTimeInMillis() ? context.tru : context.fals;
        }
        return context.fals;
    }

    @JRubyMethod(name={"asctime", "ctime"})
    public RubyString asctime() {
        DateTimeFormatter simpleDateFormat = this.dt.getDayOfMonth() < 10 ? ONE_DAY_CTIME_FORMATTER : TWO_DAY_CTIME_FORMATTER;
        return RubyString.newString(this.getRuntime(), simpleDateFormat.print(this.dt), (Encoding)USASCIIEncoding.INSTANCE);
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        DateTimeFormatter simpleDateFormat = this.isUTC() ? TO_S_UTC_FORMATTER : TO_S_FORMATTER;
        return Create.newString(context, simpleDateFormat.print(this.getInspectDateTime()), (Encoding)USASCIIEncoding.INSTANCE);
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        DateTime dtz = this.getInspectDateTime();
        StringBuilder builder = new StringBuilder(INSPECT_FORMATTER.print(dtz));
        long nanos = this.getNanos();
        if (nanos != 0L) {
            int len;
            ByteList buf = new ByteList(9);
            Sprintf.sprintf(buf, (CharSequence)".%09d", (IRubyObject)Convert.asFixnum(context, nanos));
            for (len = buf.realSize(); buf.charAt(len - 1) == '0' && len > 0; --len) {
            }
            buf.setRealSize(len);
            builder.append(buf);
        }
        builder.append(this.isUTC() ? " UTC" : TZ_FORMATTER.print(dtz));
        return Create.newString(context, builder.toString(), (Encoding)USASCIIEncoding.INSTANCE);
    }

    private DateTime getInspectDateTime() {
        if (this.isTzRelative) {
            int offset2 = this.dt.getZone().toTimeZone().getOffset(this.dt.getMillis());
            return this.dt.withZone(DateTimeZone.forOffsetMillis(offset2));
        }
        return this.dt;
    }

    @Override
    public String toString() {
        return this.to_s(this.getRuntime().getCurrentContext()).asJavaString();
    }

    @Override
    @JRubyMethod
    public RubyArray to_a(ThreadContext context) {
        return Create.newArrayNoCopy(context, this.sec(), this.min(), this.hour(), this.mday(), this.month(), this.year(), this.wday(), this.yday(), this.isdst(), this.getTimezoneShortName(context));
    }

    private RubyString getTimezoneShortName(ThreadContext context) {
        return Create.newString(context, this.dt.getZone().getShortName(this.dt.getMillis()));
    }

    @JRubyMethod
    public RubyFloat to_f() {
        long millis = this.getTimeInMillis();
        long nanos = this.nsec;
        double secs = 0.0;
        if (millis != 0L) {
            secs += (double)millis / 1000.0;
        }
        if (nanos != 0L) {
            secs += (double)nanos / 1.0E9;
        }
        return RubyFloat.newFloat(this.getRuntime(), secs);
    }

    @JRubyMethod(name={"to_i", "tv_sec"})
    public RubyInteger to_i(ThreadContext context) {
        return Convert.asFixnum(context, this.to_i_long());
    }

    public long to_i_long() {
        return Math.floorDiv(this.getTimeInMillis(), 1000L);
    }

    @Deprecated(since="9.4-")
    public RubyInteger to_i() {
        return this.to_i(this.getCurrentContext());
    }

    @JRubyMethod(name={"nsec", "tv_nsec"})
    public RubyInteger nsec(ThreadContext context) {
        return Convert.asFixnum(context, this.getNanos());
    }

    @Deprecated(since="9.4-")
    public RubyInteger nsec() {
        return this.nsec(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject to_r(ThreadContext context) {
        return RubyRational.newRationalCanonicalize(context, this.getTimeInMillis() * 1000000L + this.nsec, 1000000000L);
    }

    @JRubyMethod(name={"usec", "tv_usec"})
    public RubyInteger usec(ThreadContext context) {
        return Convert.asFixnum(context, (long)(this.dt.getMillisOfSecond() * 1000) + this.getUSec());
    }

    @Deprecated(since="10.0.0.0")
    public RubyInteger usec() {
        return this.usec(this.getCurrentContext());
    }

    public long getTimeInMicros() {
        return this.getTimeInMillis() * 1000L + this.getUSec();
    }

    public int getMicros() {
        return (int)(this.getTimeInMillis() % 1000L) * 1000 + (int)this.getUSec();
    }

    public void setMicros(int micros) {
        long millis = this.getTimeInMillis();
        millis = millis - millis % 1000L + (long)(micros / 1000);
        this.dt = this.dt.withMillis(millis);
        this.nsec = micros % 1000 * 1000;
    }

    @Deprecated(since="9.4-")
    public void setMicroseconds(long micros) {
        this.setMicros((int)micros);
    }

    @Deprecated(since="9.4-")
    public long microseconds() {
        return this.getMicros();
    }

    public int getNanos() {
        return (int)((long)this.dt.getMillisOfSecond() * 1000000L + this.getNSec());
    }

    public void setNanos(int nanos) {
        long millis = this.getTimeInMillis();
        millis = millis - millis % 1000L + (long)(nanos / 1000000);
        this.dt = this.dt.withMillis(millis);
        this.nsec = nanos % 1000000;
    }

    @JRubyMethod
    public RubyInteger sec(ThreadContext context) {
        return Convert.asFixnum(context, this.dt.getSecondOfMinute());
    }

    @Deprecated(since="10.0.0.0")
    public RubyInteger sec() {
        return this.sec(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyInteger min(ThreadContext context) {
        return Convert.asFixnum(context, this.dt.getMinuteOfHour());
    }

    @Deprecated(since="10.0.0.0")
    public RubyInteger min() {
        return this.min(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyInteger hour(ThreadContext context) {
        return Convert.asFixnum(context, this.dt.getHourOfDay());
    }

    @Deprecated(since="10.0.0.0")
    public RubyInteger hour() {
        return this.hour(this.getCurrentContext());
    }

    @JRubyMethod(name={"mday", "day"})
    public RubyInteger mday(ThreadContext context) {
        return Convert.asFixnum(context, this.dt.getDayOfMonth());
    }

    @Deprecated(since="10.0.0.0")
    public RubyInteger mday() {
        return this.mday(this.getCurrentContext());
    }

    @JRubyMethod(name={"month", "mon"})
    public RubyInteger month(ThreadContext context) {
        return Convert.asFixnum(context, this.dt.getMonthOfYear());
    }

    @Deprecated(since="10.0.0.0")
    public RubyInteger month() {
        return this.month(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyInteger year(ThreadContext context) {
        return Convert.asFixnum(context, this.dt.getYear());
    }

    @Deprecated(since="10.0.0.0")
    public RubyInteger year() {
        return this.year(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyInteger wday(ThreadContext context) {
        return Convert.asFixnum(context, this.dt.getDayOfWeek() % 7);
    }

    @Deprecated(since="10.0.0.0")
    public RubyInteger wday() {
        return this.wday(this.getCurrentContext());
    }

    @JRubyMethod
    public RubyInteger yday(ThreadContext context) {
        return Convert.asFixnum(context, this.dt.getDayOfYear());
    }

    @Deprecated(since="10.0.0.0")
    public RubyInteger yday() {
        return this.yday(this.getCurrentContext());
    }

    @JRubyMethod(name={"sunday?"})
    public RubyBoolean sunday_p(ThreadContext context) {
        return Convert.asBoolean(context, this.dt.getDayOfWeek() % 7 == 0);
    }

    @JRubyMethod(name={"monday?"})
    public RubyBoolean monday_p(ThreadContext context) {
        return Convert.asBoolean(context, this.dt.getDayOfWeek() % 7 == 1);
    }

    @JRubyMethod(name={"tuesday?"})
    public RubyBoolean tuesday_p(ThreadContext context) {
        return Convert.asBoolean(context, this.dt.getDayOfWeek() % 7 == 2);
    }

    @JRubyMethod(name={"wednesday?"})
    public RubyBoolean wednesday_p(ThreadContext context) {
        return Convert.asBoolean(context, this.dt.getDayOfWeek() % 7 == 3);
    }

    @JRubyMethod(name={"thursday?"})
    public RubyBoolean thursday_p(ThreadContext context) {
        return Convert.asBoolean(context, this.dt.getDayOfWeek() % 7 == 4);
    }

    @JRubyMethod(name={"friday?"})
    public RubyBoolean friday_p(ThreadContext context) {
        return Convert.asBoolean(context, this.dt.getDayOfWeek() % 7 == 5);
    }

    @JRubyMethod(name={"saturday?"})
    public RubyBoolean saturday_p(ThreadContext context) {
        return Convert.asBoolean(context, this.dt.getDayOfWeek() % 7 == 6);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject subsec() {
        return this.subsec(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public RubyNumeric subsec(ThreadContext context) {
        long nanosec = (long)(this.dt.getMillisOfSecond() * 1000000) + this.nsec;
        RubyNumeric subsec2 = (RubyNumeric)RubyRational.newRationalCanonicalize(context, nanosec, 1000000000L);
        return subsec2.isZero(context) ? Convert.asFixnum(context, 0) : subsec2;
    }

    @JRubyMethod(name={"gmt_offset", "gmtoff", "utc_offset"})
    public RubyInteger gmt_offset(ThreadContext context) {
        int offset2 = this.dt.getZone().getOffset(this.dt.getMillis());
        return Convert.asFixnum(context, offset2 / 1000);
    }

    @Deprecated(since="9.4-")
    public RubyInteger gmt_offset() {
        return this.gmt_offset(this.getCurrentContext());
    }

    @JRubyMethod(name={"isdst", "dst?"})
    public RubyBoolean isdst(ThreadContext context) {
        return Convert.asBoolean(context, !this.dt.getZone().isStandardOffset(this.dt.getMillis()));
    }

    @Deprecated(since="10.0.0.0")
    public RubyBoolean isdst() {
        return this.isdst(this.getRuntime().getCurrentContext());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject zone() {
        return this.zone(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject zone(ThreadContext context) {
        if (this.zone != null) {
            return this.zone;
        }
        if (this.isUTC()) {
            return RubyString.newUSASCIIString(context.runtime, UTC);
        }
        if (this.isTzRelative) {
            return context.nil;
        }
        String zoneName = RubyTime.getRubyTimeZoneName(context, this.dt);
        if ("".equals(zoneName)) {
            return context.nil;
        }
        RubyString zone2 = Create.newString(context, zoneName);
        if (zone2.isAsciiOnly()) {
            zone2.setEncoding(USASCIIEncoding.INSTANCE);
        }
        return zone2;
    }

    @Deprecated(since="10.0.0.0")
    public String getZoneName() {
        return RubyTime.getRubyTimeZoneName(this.getCurrentContext(), this.dt);
    }

    @Deprecated(since="10.0.0.0")
    public static String getRubyTimeZoneName(Ruby runtime2, DateTime dt) {
        return RubyTime.getRubyTimeZoneName(runtime2.getCurrentContext(), dt);
    }

    public static String getRubyTimeZoneName(ThreadContext context, DateTime dt) {
        String tz = RubyTime.getEnvTimeZone(context);
        return RubyTime.getRubyTimeZoneName(tz == null ? "" : tz, dt);
    }

    public static String getRubyTimeZoneName(String envTZ, DateTime dt) {
        switch (envTZ) {
            case "Etc/UCT": 
            case "UCT": {
                return "UCT";
            }
            case "MET": {
                return RubyTime.inDaylighTime(dt) ? "MEST" : "MET";
            }
        }
        String zone2 = dt.getZone().getShortName(dt.getMillis());
        Matcher offsetMatcher = TIME_OFFSET_PATTERN.matcher(zone2);
        if (offsetMatcher.matches()) {
            if (zone2.equals("+00:00")) {
                zone2 = UTC;
            } else {
                zone2 = dt.getZone().getNameKey(dt.getMillis());
                if (zone2 == null) {
                    zone2 = "";
                }
            }
        }
        return zone2;
    }

    private static boolean inDaylighTime(DateTime dt) {
        return dt.getZone().toTimeZone().inDaylightTime(dt.toDate());
    }

    public void setDateTime(DateTime dt) {
        this.dt = dt;
    }

    public DateTime getDateTime() {
        return this.dt;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.hashCode());
    }

    @Override
    public int hashCode() {
        return (int)((this.dt.getMillis() / 1000L ^ (long)this.getMicros()) << 1) >> 1;
    }

    @JRubyMethod(name={"_dump"})
    public RubyString dump(ThreadContext context) {
        RubyString str = this.mdump(context);
        str.syncVariables(this);
        return str;
    }

    @JRubyMethod(name={"_dump"})
    public RubyString dump(ThreadContext context, IRubyObject arg2) {
        return this.dump(context);
    }

    @Deprecated(since="9.2.0.0")
    public RubyString dump(IRubyObject[] args2, Block unusedBlock) {
        RubyString str = (RubyString)this.mdump();
        str.syncVariables(this);
        return str;
    }

    @Deprecated(since="9.2.0.0")
    public RubyObject mdump() {
        return this.mdump(this.getCurrentContext());
    }

    private RubyString mdump(ThreadContext context) {
        int i2;
        DateTime dateTime = this.dt.toDateTime(DateTimeZone.UTC);
        byte[] dumpValue = new byte[8];
        long usec2 = this.nsec / 1000L;
        long nanosec = this.nsec % 1000L;
        int pe = Integer.MIN_VALUE | (this.isUTC() ? 1 : 0) << 30 | dateTime.getYear() - 1900 << 14 | dateTime.getMonthOfYear() - 1 << 10 | dateTime.getDayOfMonth() << 5 | dateTime.getHourOfDay();
        int se = dateTime.getMinuteOfHour() << 26 | dateTime.getSecondOfMinute() << 20 | dateTime.getMillisOfSecond() * 1000 + (int)usec2;
        for (i2 = 0; i2 < 4; ++i2) {
            dumpValue[i2] = (byte)(pe & 0xFF);
            pe >>>= 8;
        }
        for (i2 = 4; i2 < 8; ++i2) {
            dumpValue[i2] = (byte)(se & 0xFF);
            se >>>= 8;
        }
        RubyString string2 = Create.newString(context, new ByteList(dumpValue, false));
        this.copyInstanceVariablesInto(string2);
        if (nanosec != 0L) {
            string2.setInternalVariable("nano_num", Convert.asFixnum(context, nanosec));
            string2.setInternalVariable("nano_den", Convert.asFixnum(context, 1));
        }
        byte[] submicro = new byte[2];
        int len = 2;
        submicro[1] = (byte)(nanosec % 10L << 4);
        submicro[0] = (byte)((nanosec /= 10L) % 10L);
        submicro[0] = (byte)(submicro[0] | (byte)((nanosec /= 10L) % 10L << 4));
        if (submicro[1] == 0) {
            len = 1;
        }
        string2.setInternalVariable("submicro", Create.newString(context, submicro, 0, len));
        DateTimeZone zone2 = this.dt.getZone();
        if (zone2 != DateTimeZone.UTC) {
            long offset2 = zone2.getOffset(this.dt.getMillis());
            string2.setInternalVariable("offset", Convert.asFixnum(context, offset2 / 1000L));
            String zoneName = zone2.getShortName(this.dt.getMillis());
            if (!TIME_OFFSET_PATTERN.matcher(zoneName).matches()) {
                string2.setInternalVariable("zone", Create.newString(context, zoneName));
            }
        }
        return string2;
    }

    @JRubyMethod(optional=1, checkArity=false)
    public RubyTime round(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        int ndigits = this.getNdigits(context, args2);
        int _nsec = this.dt.getMillisOfSecond() * 1000000 + (int)this.nsec;
        int pow2 = (int)Math.pow(10.0, 9 - ndigits);
        int rounded = (_nsec + pow2 / 2) / pow2 * pow2;
        DateTime _dt = this.dt.withMillisOfSecond(0).plusMillis(rounded / 1000000);
        return RubyTime.newTime(context.runtime, _dt, rounded % 1000000);
    }

    @JRubyMethod(optional=1, checkArity=false)
    public RubyTime floor(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        int ndigits = this.getNdigits(context, args2);
        int _nsec = this.dt.getMillisOfSecond() * 1000000 + (int)this.nsec;
        int pow2 = (int)Math.pow(10.0, 9 - ndigits);
        int floored = _nsec / pow2 * pow2;
        DateTime _dt = this.dt.withMillisOfSecond(0).plusMillis(floored / 1000000);
        return RubyTime.newTime(context.runtime, _dt, floored % 1000000);
    }

    @JRubyMethod(optional=1, checkArity=false)
    public RubyTime ceil(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        int ndigits = this.getNdigits(context, args2);
        int _nsec = this.dt.getMillisOfSecond() * 1000000 + (int)this.nsec;
        int pow2 = (int)Math.pow(10.0, 9 - ndigits);
        int ceiled = _nsec;
        if (pow2 > 1) {
            ceiled = (_nsec + pow2) / pow2 * pow2;
        }
        DateTime _dt = this.dt.withMillisOfSecond(0).plusMillis(ceiled / 1000000);
        return RubyTime.newTime(context.runtime, _dt, ceiled % 1000000);
    }

    private int getNdigits(ThreadContext context, IRubyObject[] args2) {
        int ndigits;
        int n = ndigits = args2.length == 0 ? 0 : Convert.toInt(context, args2[0]);
        if (ndigits > 9) {
            ndigits = 9;
        }
        if (ndigits < 0) {
            throw Error.argumentError(context, "negative ndigits given");
        }
        return ndigits;
    }

    @Deprecated(since="9.2.0.0")
    public static IRubyObject s_new(IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        RubyTime time = new RubyTime(runtime2, (RubyClass)recv2, new DateTime(RubyTime.getLocalTimeZone(runtime2.getCurrentContext())));
        time.callInit(args2, block);
        return time;
    }

    @Deprecated(since="1.1.3")
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyTime.newInstance(context, recv2, args2);
    }

    @JRubyMethod(name={"now"}, meta=true, optional=1, checkArity=false, keywords=true)
    public static RubyTime newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        RubyTime obj = RubyTime.allocateInstance(context, (RubyClass)recv2);
        if (argc == 1) {
            obj.getMetaClass().getBaseCallSite(0).call(context, recv2, (IRubyObject)obj, args2);
        } else {
            obj.getMetaClass().getBaseCallSite(0).call(context, recv2, obj);
        }
        return obj;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject at(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyTime.at1(context, recv2, arg2);
    }

    @JRubyMethod(meta=true, keywords=true)
    public static IRubyObject at(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject maybeOpts = ArgsUtil.getOptionsArg(context, arg2);
        return maybeOpts.isNil() ? RubyTime.atOpts(context, recv2, arg1, arg2, Convert.asSymbol(context, "microsecond"), context.nil) : RubyTime.atOpts(context, recv2, arg1, context.nil, null, maybeOpts);
    }

    @JRubyMethod(meta=true, keywords=true)
    public static IRubyObject at(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        IRubyObject maybeOpts = ArgsUtil.getOptionsArg(context, arg3);
        return maybeOpts.isNil() ? RubyTime.atOpts(context, recv2, arg1, arg2, arg3, context.nil) : RubyTime.atOpts(context, recv2, arg1, arg2, null, arg3);
    }

    @JRubyMethod(required=1, optional=3, checkArity=false, meta=true)
    public static IRubyObject at(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return switch (args2.length) {
            case 1 -> RubyTime.at(context, recv2, args2[0]);
            case 2 -> RubyTime.at(context, recv2, args2[0], args2[1]);
            case 3 -> RubyTime.at(context, recv2, args2[0], args2[1], args2[2]);
            case 4 -> RubyTime.atOpts(context, recv2, args2[0], args2[1], args2[2], args2[3]);
            default -> throw Error.argumentError(context, args2.length, 1, 4);
        };
    }

    private static IRubyObject atOpts(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject opts) {
        IRubyObject zone2 = ArgsUtil.extractKeywordArg(context, "in", opts);
        if (arg2.isNil() && (arg3 == null || arg3.isNil())) {
            RubyTime time = RubyTime.at1(context, recv2, arg1);
            time = time.gmtime(context);
            if (!zone2.isNil()) {
                time = RubyTime.timeZoneLocal(context, zone2, time);
            }
            return time;
        }
        if (arg3 == null) {
            arg3 = Convert.asSymbol(context, "microsecond");
        }
        return RubyTime.atMulti(context, (RubyClass)recv2, arg1, arg2, arg3, zone2);
    }

    private static RubyTime at1(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyTime time;
        if (arg2 instanceof RubyTime) {
            RubyTime other = (RubyTime)arg2;
            time = new RubyTime(context.runtime, (RubyClass)recv2, other.dt);
            time.setNSec(other.getNSec());
        } else {
            long nanosecs;
            long millisecs;
            if ((arg2 = RubyTime.numExact(context, arg2)) instanceof RubyFloat) {
                RubyFloat flote = (RubyFloat)arg2;
                long seconds = flote.asLong(context);
                double dbl = flote.value;
                long nano = (long)((dbl - (double)seconds) * 1.0E9);
                if (dbl < 0.0 && nano != 0L) {
                    nano += 1000000000L;
                }
                millisecs = seconds * 1000L + nano / 1000000L;
                nanosecs = nano % 1000000L;
            } else if (arg2 instanceof RubyRational) {
                RubyRational rational = (RubyRational)arg2;
                BigInteger numerator2 = rational.getNumerator().asBigInteger(context);
                BigInteger denominator2 = rational.getDenominator().asBigInteger(context);
                BigDecimal nanosBD = new BigDecimal(numerator2).divide(new BigDecimal(denominator2), 50, RoundingMode.HALF_UP).multiply(ONE_BILLION_BD);
                BigInteger millis = nanosBD.divide(ONE_MILLION_BD).toBigInteger();
                BigInteger nanos = nanosBD.remainder(ONE_MILLION_BD).toBigInteger();
                millisecs = millis.longValue();
                nanosecs = nanos.longValue();
            } else {
                nanosecs = 0L;
                millisecs = Convert.toLong(context, arg2) * 1000L;
            }
            try {
                time = new RubyTime(context.runtime, (RubyClass)recv2, new DateTime(millisecs, RubyTime.getLocalTimeZone(context)));
            }
            catch (ArithmeticException | IllegalFieldValueException ex) {
                throw Error.rangeError(context, ex.getMessage());
            }
            time.setNSec(nanosecs);
        }
        return time;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RubyTime atMulti(ThreadContext context, RubyClass recv2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject zone2) {
        long millisecs;
        long nanosecs = 0L;
        arg1 = RubyTime.numExact(context, arg1);
        arg2 = RubyTime.numExact(context, arg2);
        if (arg1 instanceof RubyFloat || arg1 instanceof RubyRational) {
            double dbl = Convert.toDouble(context, arg1);
            millisecs = (long)(dbl * 1000.0);
            nanosecs = (long)(dbl * 1.0E9) % 1000000L;
        } else {
            millisecs = Convert.toLong(context, arg1) * 1000L;
        }
        if (!(arg3 instanceof RubySymbol)) throw Error.argumentError(context, "unexpected unit " + String.valueOf(arg3));
        RubySymbol unit = (RubySymbol)arg3;
        if (arg2 instanceof RubyFloat || arg2 instanceof RubyRational) {
            if (Convert.asSymbol(context, "microsecond").eql(unit) || Convert.asSymbol(context, "usec").eql(unit)) {
                double micros = Convert.toDouble(context, arg2);
                double nanos = micros * 1000.0;
                millisecs += (long)(nanos / 1000000.0);
                nanosecs += (long)(nanos % 1000000.0);
            } else if (Convert.asSymbol(context, "millisecond").eql(unit)) {
                double millis = Convert.toDouble(context, arg2);
                double nanos = millis * 1000000.0;
                millisecs += (long)(nanos / 1000000.0);
                nanosecs += (long)(nanos % 1000000.0);
            } else {
                if (!Convert.asSymbol(context, "nanosecond").eql(unit)) {
                    if (!Convert.asSymbol(context, "nsec").eql(unit)) throw Error.argumentError(context, "unexpected unit " + String.valueOf(arg3));
                }
                nanosecs += Convert.toLong(context, arg2);
            }
        } else if (Convert.asSymbol(context, "microsecond").eql(unit) || Convert.asSymbol(context, "usec").eql(unit)) {
            long micros = Convert.toLong(context, arg2);
            long nanos = micros * 1000L;
            millisecs += nanos / 1000000L;
            nanosecs += nanos % 1000000L;
        } else if (Convert.asSymbol(context, "millisecond").eql(unit)) {
            double millis = Convert.toLong(context, arg2);
            double nanos = millis * 1000000.0;
            millisecs = (long)((double)millisecs + nanos / 1000000.0);
            nanosecs = (long)((double)nanosecs + nanos % 1000000.0);
        } else {
            if (!Convert.asSymbol(context, "nanosecond").eql(unit)) {
                if (!Convert.asSymbol(context, "nsec").eql(unit)) throw Error.argumentError(context, "unexpected unit " + String.valueOf(arg3));
            }
            nanosecs += Convert.toLong(context, arg2);
        }
        long nanosecOverflow = nanosecs / 1000000L;
        RubyTime time = new RubyTime(context.runtime, recv2, new DateTime(millisecs + nanosecOverflow, RubyTime.getLocalTimeZone(context)));
        time.setNSec(nanosecs % 1000000L);
        if (zone2.isNil()) return time;
        return RubyTime.timeZoneLocal(context, zone2, time.gmtime(context));
    }

    @JRubyMethod(name={"local", "mktime"}, required=1, optional=9, checkArity=false, meta=true)
    public static RubyTime local(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 10);
        RubyTime time = RubyTime.allocateInstance(context, (RubyClass)recv2);
        TimeArgs timeArgs = new TimeArgs(context, args2);
        timeArgs.initializeTime(context, time, RubyTime.getLocalTimeZone(context));
        return time;
    }

    @Override
    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        return this.initializeNow(context, context.nil);
    }

    private IRubyObject initializeNow(ThreadContext context, IRubyObject zone2) {
        DateTime dt;
        long nsecs;
        long msecs;
        DateTimeZone dtz;
        boolean maybeZoneObj = false;
        if (zone2.isNil()) {
            dtz = RubyTime.getLocalTimeZone(context);
        } else if (zone2 == Convert.asSymbol(context, "dst")) {
            dtz = RubyTime.getLocalTimeZone(context);
        } else if (zone2 == Convert.asSymbol(context, "std")) {
            dtz = RubyTime.getLocalTimeZone(context);
        } else if (RubyTime.maybeTimezoneObject(zone2)) {
            maybeZoneObj = true;
            this.zone = zone2;
            dtz = DateTimeZone.UTC;
        } else {
            dtz = this.handleUTCDateTimeZone(context, zone2);
            if (dtz == null) {
                this.zone = this.findTimezone(context, zone2);
                maybeZoneObj = true;
                dtz = DateTimeZone.UTC;
            }
        }
        POSIX posix = context.runtime.getPosix();
        if (posix.isNative()) {
            try {
                Timeval tv = posix.allocateTimeval();
                posix.gettimeofday(tv);
                long secs = tv.sec();
                long usecs = tv.usec();
                msecs = secs * 1000L + usecs / 1000L;
                nsecs = usecs % 1000L * 1000L;
            }
            catch (RaiseException notImplementedError) {
                msecs = System.currentTimeMillis();
                nsecs = 0L;
            }
        } else {
            msecs = System.currentTimeMillis();
            nsecs = 0L;
        }
        this.dt = dt = new DateTime(msecs, dtz);
        this.setNSec(nsecs);
        if (maybeZoneObj) {
            if (RubyTime.zoneTimeLocal(context, zone2, this)) {
                return this;
            }
            dtz = RubyTime.getTimeZoneFromUtcOffset(context, zone2);
            if (dtz != null) {
                this.dt = dt.withZoneRetainFields(dtz);
            } else if (!RubyTime.zoneTimeLocal(context, zone2 = this.findTimezone(context, zone2), this)) {
                throw RubyTime.invalidUTCOffset(context, zone2);
            }
        }
        return context.nil;
    }

    private DateTimeZone handleUTCDateTimeZone(ThreadContext context, IRubyObject zone2) {
        DateTimeZone dtz = RubyTime.getTimeZoneFromUtcOffset(context, zone2);
        if (!(dtz == null || zone2 instanceof RubyString && (zone2.asJavaString().equals("Z") || zone2.asJavaString().equals(UTC) || zone2.asJavaString().equals("-00:00")))) {
            this.setIsTzRelative(true);
        }
        return dtz;
    }

    @JRubyMethod(name={"initialize"}, optional=8, checkArity=false, visibility=Visibility.PRIVATE, keywords=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject[] opts;
        boolean keywords = ThreadContext.hasKeywords(ThreadContext.resetCallInfo(context));
        int argc = args2.length;
        IRubyObject zone2 = context.nil;
        IRubyObject precision2 = Convert.asFixnum(context, 9);
        if (keywords && (opts = ArgsUtil.extractKeywordArgs(context, args2[args2.length - 1], "in", "precision")) != null) {
            --argc;
            if (opts[0] != null) {
                if (argc > 6) {
                    throw Error.argumentError(context, "timezone argument given as positional and keyword arguments");
                }
                zone2 = opts[0];
            }
            if (opts[1] != null) {
                precision2 = opts[1];
            }
        }
        if (argc > 6) {
            zone2 = args2[6];
        }
        IRubyObject nil = context.nil;
        return switch (argc) {
            case 0 -> this.initializeNow(context, zone2);
            case 1 -> this.timeInitParse(context, args2[0], zone2, precision2);
            case 2 -> this.initialize(context, args2[0], args2[1], nil, nil, nil, nil, nil, zone2);
            case 3 -> this.initialize(context, args2[0], args2[1], args2[2], nil, nil, nil, nil, zone2);
            case 4 -> this.initialize(context, args2[0], args2[1], args2[2], args2[3], nil, nil, nil, zone2);
            case 5 -> this.initialize(context, args2[0], args2[1], args2[2], args2[3], args2[4], nil, nil, zone2);
            case 6 -> this.initialize(context, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], nil, zone2);
            case 7 -> this.initialize(context, args2[0], args2[1], args2[2], args2[3], args2[4], args2[5], nil, zone2);
            default -> throw Error.argumentError(context, argc, 0, 7);
        };
    }

    private IRubyObject timeInitParse(ThreadContext context, IRubyObject arg2, IRubyObject zone2, IRubyObject precision2) {
        IRubyObject strArg = arg2.checkStringType();
        if (strArg.isNil()) {
            return this.initialize(context, arg2, context.nil, context.nil, context.nil, context.nil, context.nil, context.nil, zone2);
        }
        RubyString str = (RubyString)strArg;
        if (!str.getEncoding().isAsciiCompatible()) {
            throw Error.argumentError(context, "time string should have ASCII compatible encoding");
        }
        return new RubyTimeParser().parse(context, this, str, zone2, precision2);
    }

    private IRubyObject initialize(ThreadContext context, IRubyObject year2, IRubyObject month2, IRubyObject day, IRubyObject hour2, IRubyObject minute2, IRubyObject second2, IRubyObject usec2) {
        TimeArgs timeArgs = new TimeArgs(context, year2, month2, day, hour2, minute2, second2, usec2, false);
        timeArgs.initializeTime(context, this, RubyTime.getLocalTimeZone(context));
        return context.nil;
    }

    public IRubyObject initialize(ThreadContext context, IRubyObject year2, IRubyObject month2, IRubyObject day, IRubyObject hour2, IRubyObject minute2, IRubyObject second2, IRubyObject usec2, IRubyObject zone2) {
        DateTimeZone dtz;
        IRubyObject nil = context.nil;
        boolean maybeZoneObj = false;
        boolean dst = false;
        if (zone2.isNil()) {
            return this.initialize(context, year2, month2, day, hour2, minute2, second2, usec2);
        }
        if (zone2 == Convert.asSymbol(context, "dst")) {
            dst = true;
            dtz = RubyTime.getLocalTimeZone(context);
        } else if (zone2 == Convert.asSymbol(context, "std")) {
            dst = false;
            dtz = RubyTime.getLocalTimeZone(context);
        } else if (RubyTime.maybeTimezoneObject(zone2)) {
            maybeZoneObj = true;
            this.zone = zone2;
            dtz = DateTimeZone.UTC;
        } else {
            dtz = this.handleUTCDateTimeZone(context, zone2);
            if (dtz == null) {
                this.zone = this.findTimezone(context, zone2);
                maybeZoneObj = true;
                dtz = DateTimeZone.UTC;
            }
        }
        TimeArgs timeArgs = new TimeArgs(context, year2, month2, day, hour2, minute2, second2, usec2, dst);
        timeArgs.initializeTime(context, this, dtz);
        if (maybeZoneObj) {
            if (RubyTime.zoneTimeLocal(context, zone2, this)) {
                return this;
            }
            dtz = RubyTime.getTimeZoneFromUtcOffset(context, zone2);
            if (dtz != null) {
                this.dt = this.dt.withZoneRetainFields(dtz);
            } else {
                if ((zone2 = this.findTimezone(context, zone2)) == null) {
                    throw RubyTime.invalidUTCOffset(context);
                }
                if (!RubyTime.zoneTimeLocal(context, zone2, this)) {
                    throw RubyTime.invalidUTCOffset(context, zone2);
                }
            }
        }
        return nil;
    }

    private static boolean maybeTimezoneObject(IRubyObject obj) {
        return !obj.isNil() && !(obj instanceof RubyInteger) && !(obj instanceof RubyString);
    }

    private IRubyObject findTimezone(ThreadContext context, IRubyObject zone2) {
        IRubyObject foundZone = Helpers.invokeChecked(context, (IRubyObject)this.getMetaClass(), "find_timezone", zone2);
        if (foundZone == null || foundZone.isNil()) {
            throw RubyTime.invalidUTCOffset(context, zone2);
        }
        return foundZone;
    }

    @JRubyMethod(name={"utc", "gm"}, required=1, optional=9, checkArity=false, meta=true)
    public static RubyTime utc(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 10);
        RubyTime time = RubyTime.allocateInstance(context, (RubyClass)recv2);
        TimeArgs timeArgs = new TimeArgs(context, args2);
        timeArgs.initializeTime(context, time, DateTimeZone.UTC);
        return time;
    }

    private static RubyTime allocateInstance(ThreadContext context, RubyClass recv2) {
        return (RubyTime)recv2.allocate(context);
    }

    @Deprecated(since="9.2.0.0")
    public static RubyTime load(IRubyObject recv2, IRubyObject from, Block block) {
        ThreadContext context = recv2.getRuntime().getCurrentContext();
        return RubyTime.s_mload(context, RubyTime.allocateInstance(context, (RubyClass)recv2), from);
    }

    @JRubyMethod(name={"_load"}, meta=true)
    public static RubyTime load(ThreadContext context, IRubyObject recv2, IRubyObject from) {
        return RubyTime.s_mload(context, RubyTime.allocateInstance(context, (RubyClass)recv2), from);
    }

    @Override
    public Class<?> getJavaClass() {
        return java.util.Date.class;
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2 == java.util.Date.class || target2 == Comparable.class || target2 == Object.class) {
            return target2.cast(this.getJavaDate());
        }
        if (target2 == Calendar.class || target2 == GregorianCalendar.class) {
            return target2.cast(this.dt.toGregorianCalendar());
        }
        if (target2.isAssignableFrom(DateTime.class) && target2 != Serializable.class) {
            return target2.cast(this.dt);
        }
        if (target2 == Date.class) {
            return target2.cast(new Date(this.dt.getMillis()));
        }
        if (target2 == Time.class) {
            return target2.cast(new Time(this.dt.getMillis()));
        }
        if (target2 == Timestamp.class) {
            Timestamp timestamp = new Timestamp(this.dt.getMillis());
            timestamp.setNanos(this.getNanos());
            return target2.cast(timestamp);
        }
        if (target2 != Serializable.class) {
            if (target2.isAssignableFrom(Instant.class)) {
                return (T)this.toInstant();
            }
            if (target2.isAssignableFrom(LocalDateTime.class)) {
                return (T)this.toLocalDateTime();
            }
            if (target2.isAssignableFrom(ZonedDateTime.class)) {
                return (T)this.toZonedDateTime();
            }
            if (target2.isAssignableFrom(OffsetDateTime.class)) {
                return (T)this.toOffsetDateTime();
            }
        }
        return super.toJava(target2);
    }

    public long getTimeInMillis() {
        return this.dt.getMillis();
    }

    public int getYear() {
        return this.dt.getYear();
    }

    public int getMonth() {
        return this.dt.getMonthOfYear();
    }

    public int getDay() {
        return this.dt.getDayOfMonth();
    }

    public int getHour() {
        return this.dt.getHourOfDay();
    }

    public int getMinute() {
        return this.dt.getMinuteOfHour();
    }

    public int getSecond() {
        return this.dt.getSecondOfMinute();
    }

    public java.util.Date getJavaDate() {
        return this.dt.toDate();
    }

    public Instant toInstant() {
        long millis = this.getTimeInMillis();
        long sec2 = Math.floorDiv(millis, 1000L);
        long nanoAdj = this.getNSec() + Math.floorMod(millis, 1000L) * 1000000L;
        return Instant.ofEpochSecond(sec2, nanoAdj);
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.of(this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getNanos());
    }

    public ZonedDateTime toZonedDateTime() {
        return ZonedDateTime.of(this.toLocalDateTime(), ZoneId.of(this.dt.getZone().getID()));
    }

    public OffsetDateTime toOffsetDateTime() {
        int offset2 = this.dt.getZone().getOffset(this.dt.getMillis()) / 1000;
        return OffsetDateTime.of(this.toLocalDateTime(), ZoneOffset.ofTotalSeconds(offset2));
    }

    public static double convertTimeInterval(ThreadContext context, IRubyObject sec2) {
        double seconds;
        if (sec2 instanceof RubyNumeric) {
            RubyNumeric num = (RubyNumeric)sec2;
            seconds = num.asDouble(context);
        } else if (RubyTime.sites((ThreadContext)context).respond_to_divmod.respondsTo(context, sec2, sec2)) {
            IRubyObject result2 = RubyTime.sites((ThreadContext)context).divmod.call(context, sec2, sec2, 1L);
            if (!(result2 instanceof RubyArray)) {
                throw Error.typeError(context, "unexpected divmod result: into ", result2, "");
            }
            RubyArray arr = (RubyArray)result2;
            seconds = ((RubyNumeric)arr.eltOk(0L)).asDouble(context) + ((RubyNumeric)arr.eltOk(1L)).asDouble(context);
        } else {
            boolean raise2 = true;
            seconds = 0.0;
            if (sec2 instanceof JavaProxy) {
                try {
                    seconds = sec2.convertToFloat().value;
                    raise2 = false;
                }
                catch (TypeError typeError) {
                    // empty catch block
                }
            }
            if (raise2) {
                throw Error.typeError(context, "can't convert ", sec2, " into time interval");
            }
        }
        if (seconds < 0.0) {
            throw Error.argumentError(context, "time interval must not be negative");
        }
        return seconds;
    }

    private static RubyTime s_mload(ThreadContext context, RubyTime time, IRubyObject from) {
        int i2;
        DateTime dt = TIME0;
        byte[] fromAsBytes = from.convertToString().getBytes();
        if (fromAsBytes.length != 8) {
            throw Error.typeError(context, "marshaled time format differ");
        }
        int p2 = 0;
        int s2 = 0;
        for (i2 = 0; i2 < 4; ++i2) {
            p2 |= (fromAsBytes[i2] & 0xFF) << 8 * i2;
        }
        for (i2 = 4; i2 < 8; ++i2) {
            s2 |= (fromAsBytes[i2] & 0xFF) << 8 * (i2 - 4);
        }
        boolean utc2 = false;
        if ((p2 & Integer.MIN_VALUE) == 0) {
            dt = dt.withMillis((long)p2 * 1000L);
            time.setUSec((s2 & 0xFFFFF) % 1000);
        } else {
            utc2 = ((p2 &= Integer.MAX_VALUE) >>> 30 & 1) == 1;
            int year2 = (p2 >>> 14 & 0xFFFF) + 1900;
            int month2 = p2 >>> 10 & 0xF;
            if (month2 >= 12) {
                month2 -= 12;
                ++year2;
            }
            dt = dt.withYear(year2);
            dt = dt.withMonthOfYear(month2 + 1);
            dt = dt.withDayOfMonth(p2 >>> 5 & 0x1F);
            dt = dt.withHourOfDay(p2 & 0x1F);
            dt = dt.withMinuteOfHour(s2 >>> 26 & 0x3F);
            dt = dt.withSecondOfMinute(s2 >>> 20 & 0x3F);
            dt = dt.withMillisOfSecond((s2 & 0xFFFFF) / 1000);
            time.setUSec((s2 & 0xFFFFF) % 1000);
        }
        time.setDateTime(dt);
        if (!utc2) {
            time.localtime();
        }
        from.getInstanceVariables().copyInstanceVariablesInto(time);
        IRubyObject nano_num = (IRubyObject)from.getInternalVariables().getInternalVariable("nano_num");
        IRubyObject nano_den = (IRubyObject)from.getInternalVariables().getInternalVariable("nano_den");
        IRubyObject offsetVar = (IRubyObject)from.getInternalVariables().getInternalVariable("offset");
        IRubyObject zoneVar = (IRubyObject)from.getInternalVariables().getInternalVariable("zone");
        if (nano_num != null && nano_den != null) {
            long nanos = Convert.toLong(context, nano_num) / Convert.toLong(context, nano_den);
            time.nsec += nanos;
        }
        int offset2 = 0;
        if (offsetVar != null && offsetVar.respondsTo("to_int")) {
            IRubyObject $ex = context.getErrorInfo();
            try {
                offset2 = Convert.toInt(context, offsetVar) * 1000;
            }
            catch (TypeError typeError) {
                context.setErrorInfo($ex);
            }
        }
        String zone2 = "";
        if (zoneVar != null && zoneVar.respondsTo("to_str")) {
            IRubyObject $ex = context.getErrorInfo();
            try {
                zone2 = zoneVar.convertToString().toString();
            }
            catch (TypeError typeError) {
                context.setErrorInfo($ex);
            }
        }
        time.dt = dt.withZone(RubyTime.getTimeZoneWithOffset(context, zone2, offset2));
        return time;
    }

    public static boolean zoneTimeLocal(ThreadContext context, IRubyObject zone2, RubyTime time) {
        IRubyObject utc2 = Helpers.invokeChecked(context, zone2, "local_to_utc", time);
        if (utc2 == null) {
            return false;
        }
        long s2 = RubyTime.extractTime(context, utc2);
        DateTime dt = time.getDateTime();
        dt = dt.withZoneRetainFields(RubyTime.getTimeZoneWithOffset(context, "", (int)(dt.getMillis() - s2)));
        time.setDateTime(dt);
        time.setZoneObject(zone2);
        return true;
    }

    public static boolean zoneLocalTime(ThreadContext context, IRubyObject zone2, RubyTime time) {
        IRubyObject local2 = Helpers.invokeChecked(context, zone2, "utc_to_local", time);
        if (local2 == null) {
            return false;
        }
        long s2 = RubyTime.extractTime(context, local2);
        DateTime dt = time.getDateTime();
        dt = dt.withZone(RubyTime.getTimeZoneWithOffset(context, "", (int)(s2 - dt.getMillis())));
        time.setDateTime(dt);
        time.setZoneObject(zone2);
        return true;
    }

    public static RubyTime timeZoneLocal(ThreadContext context, IRubyObject off, RubyTime time) {
        IRubyObject zone2 = off;
        if (RubyTime.zoneLocalTime(context, zone2, time)) {
            return time;
        }
        time.setIsTzRelative(false);
        DateTimeZone dtz = time.handleUTCDateTimeZone(context, off);
        if (dtz == null) {
            if (!RubyTime.zoneLocalTime(context, zone2 = time.findTimezone(context, zone2), time)) {
                throw RubyTime.invalidUTCOffset(context, zone2);
            }
            return time;
        }
        time.adjustTimeZone(context, dtz, time.isTzRelative);
        return time;
    }

    private static long extractTime(ThreadContext context, IRubyObject time) {
        if (time instanceof RubyTime) {
            RubyTime tm = (RubyTime)time;
            return tm.getDateTime().withZoneRetainFields(DateTimeZone.UTC).getMillis();
        }
        long t = time instanceof RubyStruct ? Convert.toLong(context, ((RubyStruct)time).aref(context, Convert.asSymbol(context, "to_i"))) : Convert.toLong(context, time.callMethod(context, "to_i"));
        return t * 1000L;
    }

    private static JavaSites.TimeSites sites(ThreadContext context) {
        return context.sites.Time;
    }
}

