/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.JRubyAPI;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Rational"}, parent="Numeric")
public class RubyRational
extends RubyNumeric {
    private RubyInteger num;
    private RubyInteger den;
    private static boolean canonicalization = false;
    private static final long ML = (long)(Math.log(Double.MAX_VALUE) / Math.log(2.0) - 1.0);
    private static final ObjectMarshal RATIONAL_MARSHAL = new ObjectMarshal(){

        @Deprecated(since="10.0.0.0", forRemoval=true)
        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) {
            throw Error.typeError(runtime2.getCurrentContext(), "marshal_dump should be used instead for Rational");
        }

        public void marshalTo(ThreadContext context, RubyOutputStream out, Object obj, RubyClass type2, MarshalDumper marshalStream) {
            throw Error.typeError(context, "marshal_dump should be used instead for Rational");
        }

        @Deprecated(since="10.0.0.0", forRemoval=true)
        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            ThreadContext context = runtime2.getCurrentContext();
            RubyRational r = (RubyRational)RubyClass.DEFAULT_OBJECT_MARSHAL.unmarshalFrom(runtime2, type2, unmarshalStream);
            RubyInteger num = RubyRational.intCheck(context, r.removeInstanceVariable("@numerator"));
            RubyInteger den = RubyRational.intCheck(context, r.removeInstanceVariable("@denominator"));
            if (RubyRational.canonicalizeShouldNegate(context, den)) {
                num = num.negate(context);
                den = den.negate(context);
            }
            r.num = num;
            r.den = den;
            return r;
        }

        public Object unmarshalFrom(ThreadContext context, RubyInputStream in, RubyClass type2, MarshalLoader loader) {
            RubyRational r = (RubyRational)RubyClass.DEFAULT_OBJECT_MARSHAL.unmarshalFrom(context, in, type2, loader);
            RubyInteger num = RubyRational.intCheck(context, r.removeInstanceVariable("@numerator"));
            RubyInteger den = RubyRational.intCheck(context, r.removeInstanceVariable("@denominator"));
            if (RubyRational.canonicalizeShouldNegate(context, den)) {
                num = num.negate(context);
                den = den.negate(context);
            }
            r.num = num;
            r.den = den;
            return r;
        }
    };

    public static RubyClass createRationalClass(ThreadContext context, RubyClass Numeric2) {
        return ((RubyModule)((RubyModule)((RubyModule)((RubyClass)Define.defineClass(context, "Rational", Numeric2, RubyRational::new).reifiedClass(RubyRational.class)).marshalWith(RATIONAL_MARSHAL)).kindOf(new RubyModule.JavaClassKindOf(RubyRational.class))).classIndex(ClassIndex.RATIONAL)).defineMethods(context, RubyRational.class).tap(c -> c.singletonClass(context).undefMethods(context, "allocate", "new"));
    }

    private RubyRational(Ruby runtime2, RubyClass clazz, RubyInteger num, RubyInteger den) {
        super(runtime2, clazz);
        this.num = num;
        this.den = den;
    }

    private RubyRational(Ruby runtime2, RubyClass clazz) {
        super(runtime2, clazz);
        RubyFixnum zero = RubyFixnum.zero(runtime2);
        this.num = zero;
        this.den = zero;
    }

    public static RubyRational newRationalRaw(Ruby runtime2, IRubyObject x, IRubyObject y) {
        return RubyRational.newRational(runtime2, runtime2.getRational(), x, y);
    }

    static RubyRational newRationalRaw(Ruby runtime2, IRubyObject x) {
        return RubyRational.newRational(runtime2, runtime2.getRational(), x, RubyFixnum.one(runtime2));
    }

    static RubyNumeric newRationalCanonicalize(ThreadContext context, RubyInteger x) {
        return (RubyNumeric)RubyRational.newRationalCanonicalize(context, x, RubyFixnum.one(context.runtime));
    }

    public static IRubyObject newRationalCanonicalize(ThreadContext context, RubyInteger x, RubyInteger y) {
        return RubyRational.canonicalizeInternal(context, context.runtime.getRational(), x, y);
    }

    public static IRubyObject newRationalCanonicalize(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyRational.canonicalizeInternal(context, context.runtime.getRational(), (RubyInteger)x, (RubyInteger)y);
    }

    public static IRubyObject newRationalCanonicalize(ThreadContext context, long x, long y) {
        return RubyRational.canonicalizeInternal(context, context.runtime.getRational(), x, y);
    }

    public static IRubyObject newRationalCanonicalize(ThreadContext context, long x) {
        return RubyRational.canonicalizeInternal(context, context.runtime.getRational(), x, 1L);
    }

    static RubyNumeric newRationalNoReduce(ThreadContext context, RubyInteger x, RubyInteger y) {
        return RubyRational.canonicalizeInternalNoReduce(context, context.runtime.getRational(), x, y);
    }

    private static RubyNumeric newRationalNoReduce(ThreadContext context, RubyClass clazz, RubyInteger x, RubyInteger y) {
        return RubyRational.canonicalizeInternalNoReduce(context, clazz, x, y);
    }

    private static RubyRational newRationalBang(ThreadContext context, RubyClass clazz, IRubyObject x, IRubyObject y) {
        assert (!Numeric.f_negative_p(context, y) && !Numeric.f_zero_p(context, y));
        return RubyRational.newRational(context.runtime, clazz, x, y);
    }

    private static RubyRational newRationalBang(ThreadContext context, RubyClass clazz, IRubyObject x) {
        return RubyRational.newRationalBang(context, clazz, x, Convert.asFixnum(context, 1));
    }

    private static RubyRational newRationalBang(ThreadContext context, RubyClass clazz, long x) {
        return RubyRational.newRationalBang(context, clazz, Convert.asFixnum(context, x), Convert.asFixnum(context, 1));
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.RATIONAL;
    }

    public static void setCanonicalization(boolean canonical) {
        canonicalization = canonical;
    }

    private static RubyInteger intCheck(ThreadContext context, IRubyObject num) {
        if (num instanceof RubyInteger) {
            return (RubyInteger)num;
        }
        if (!(num instanceof RubyNumeric) || !RubyRational.integer_p_site(context).call(context, num, num).isTrue()) {
            throw Error.typeError(context, "not an integer");
        }
        return num.convertToInteger();
    }

    private static CallSite integer_p_site(ThreadContext context) {
        return context.sites.Numeric.integer;
    }

    static IRubyObject intValue(ThreadContext context, IRubyObject num, boolean raise2) {
        RubyInteger i2 = RubyInteger.toInteger(context, num);
        if (i2 == null) {
            if (raise2) {
                throw Error.typeError(context, "can't convert ", num, " into Rational");
            }
            return context.nil;
        }
        return i2;
    }

    private static RubyNumeric canonicalizeInternal(ThreadContext context, RubyClass clazz, RubyInteger num, RubyInteger den) {
        if (RubyRational.canonicalizeShouldNegate(context, den)) {
            num = num.negate(context);
            den = den.negate(context);
        }
        RubyInteger gcd2 = Numeric.f_gcd(context, num, den);
        RubyInteger _num = (RubyInteger)num.idiv(context, gcd2);
        RubyInteger _den = (RubyInteger)den.idiv(context, gcd2);
        if (canonicalization && Numeric.f_one_p(context, _den)) {
            return _num;
        }
        return RubyRational.newRational(context.runtime, clazz, _num, _den);
    }

    private static RubyNumeric canonicalizeInternal(ThreadContext context, RubyClass clazz, long num, long den) {
        if (den == 0L) {
            throw context.runtime.newZeroDivisionError();
        }
        if (num == Long.MIN_VALUE && den == Long.MIN_VALUE) {
            RubyRational.canonicalizeInternal(context, clazz, Convert.asFixnum(context, num), Convert.asFixnum(context, den));
        }
        long gcd2 = Numeric.i_gcd(num, den);
        RubyInteger _num = (RubyInteger)Convert.asFixnum(context, num).idiv(context, gcd2);
        RubyInteger _den = (RubyInteger)Convert.asFixnum(context, den).idiv(context, gcd2);
        if (canonicalization && _den.asLong(context) == 1L) {
            return _num;
        }
        return RubyRational.newRational(context.runtime, clazz, _num, _den);
    }

    private static RubyNumeric canonicalizeInternalNoReduce(ThreadContext context, RubyClass clazz, RubyInteger num, RubyInteger den) {
        if (RubyRational.canonicalizeShouldNegate(context, den)) {
            num = num.negate(context);
            den = den.negate(context);
        }
        if (canonicalization && Numeric.f_one_p(context, den)) {
            return num;
        }
        return RubyRational.newRational(context.runtime, clazz, num, den);
    }

    private static boolean canonicalizeShouldNegate(ThreadContext context, RubyInteger den) {
        int signum = den.signum(context);
        if (signum == 0) {
            throw context.runtime.newZeroDivisionError();
        }
        return signum < 0;
    }

    @Deprecated(since="1.1.4")
    public static IRubyObject newInstance(ThreadContext context, IRubyObject clazz, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyRational.newInstance(context, (RubyClass)clazz, args2[0]);
            }
            case 2: {
                return RubyRational.newInstance(context, (RubyClass)clazz, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 1, 1);
        return null;
    }

    @Deprecated(since="9.2.0.0")
    public static IRubyObject newInstance(ThreadContext context, IRubyObject clazz, IRubyObject num) {
        return RubyRational.newInstance(context, (RubyClass)clazz, num);
    }

    static IRubyObject newInstance(ThreadContext context, RubyClass clazz, IRubyObject num) {
        return RubyRational.newInstance(context, clazz, num, true);
    }

    static IRubyObject newInstance(ThreadContext context, RubyClass clazz, IRubyObject num, boolean raise2) {
        IRubyObject maybeInt = RubyRational.intValue(context, num, raise2);
        if (maybeInt.isNil()) {
            return maybeInt;
        }
        return RubyRational.canonicalizeInternal(context, clazz, maybeInt.convertToInteger(), RubyFixnum.one(context.runtime));
    }

    @Deprecated(since="9.2.0.0")
    public static IRubyObject newInstance(ThreadContext context, IRubyObject clazz, IRubyObject num, IRubyObject den) {
        return RubyRational.newInstance(context, (RubyClass)clazz, num, den);
    }

    static IRubyObject newInstance(ThreadContext context, RubyClass clazz, IRubyObject num, IRubyObject den) {
        return RubyRational.newInstance(context, clazz, num, den, true);
    }

    static IRubyObject newInstance(ThreadContext context, RubyClass clazz, IRubyObject num, IRubyObject den, boolean raise2) {
        IRubyObject maybeInt1 = RubyRational.intValue(context, num, raise2);
        IRubyObject maybeInt2 = RubyRational.intValue(context, den, raise2);
        if (maybeInt1.isNil()) {
            return maybeInt1;
        }
        if (maybeInt2.isNil()) {
            return maybeInt2;
        }
        return RubyRational.canonicalizeInternal(context, clazz, maybeInt1.convertToInteger(), maybeInt2.convertToInteger());
    }

    static RubyNumeric newInstance(ThreadContext context, RubyClass clazz, RubyInteger num, RubyInteger den) {
        return RubyRational.canonicalizeInternal(context, clazz, num, den);
    }

    public static RubyNumeric newInstance(ThreadContext context, RubyInteger num, RubyInteger den) {
        return RubyRational.canonicalizeInternal(context, context.runtime.getRational(), num, den);
    }

    public static RubyNumeric newInstance(ThreadContext context, RubyInteger num) {
        return RubyRational.canonicalizeInternal(context, context.runtime.getRational(), num, RubyFixnum.one(context.runtime));
    }

    public static IRubyObject newRationalConvert(ThreadContext context, IRubyObject x) {
        return RubyRational.newRationalConvert(context, x, RubyFixnum.one(context.runtime));
    }

    public static IRubyObject newRationalConvert(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyRational.convert(context, context.runtime.getRational(), x, y);
    }

    public static RubyRational newRational(Ruby runtime2, long x, long y) {
        RubyRational rat = new RubyRational(runtime2, runtime2.getRational(), runtime2.newFixnum(x), runtime2.newFixnum(y));
        rat.setFrozen(true);
        return rat;
    }

    static RubyRational newRational(Ruby runtime2, RubyClass clazz, IRubyObject x, IRubyObject y) {
        RubyRational rat = new RubyRational(runtime2, clazz, x.convertToInteger(), y.convertToInteger());
        rat.setFrozen(true);
        return rat;
    }

    public static IRubyObject rationalCanonicalize(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyRational) {
            RubyRational rational = (RubyRational)x;
            if (Numeric.f_one_p(context, rational.den)) {
                return rational.num;
            }
        }
        return x;
    }

    @Deprecated(since="1.1.4")
    public static IRubyObject convert(ThreadContext context, IRubyObject clazz, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyRational.convert(context, clazz, args2[0]);
            }
            case 2: {
                return RubyRational.convert(context, clazz, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject a1) {
        if (a1 == context.nil) {
            throw Error.typeError(context, "can't convert nil into Rational");
        }
        return RubyRational.convertCommon(context, (RubyClass)recv2, a1, context.nil, true);
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject a1, IRubyObject a2) {
        IRubyObject maybeKwargs = ArgsUtil.getOptionsArg(context.runtime, a2, false);
        boolean raise2 = true;
        IRubyObject nil = context.nil;
        if (maybeKwargs.isNil()) {
            if (a1 == nil || a2 == nil) {
                throw Error.typeError(context, "can't convert nil into Rational");
            }
        } else {
            a2 = nil;
            raise2 = ArgsUtil.hasExceptionOption(context, maybeKwargs, raise2);
            if (a1 == nil) {
                if (raise2) {
                    throw Error.typeError(context, "can't convert nil into Rational");
                }
                return nil;
            }
        }
        return RubyRational.convertCommon(context, (RubyClass)recv2, a1, a2, raise2);
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject a1, IRubyObject a2, IRubyObject kwargs) {
        IRubyObject maybeKwargs = ArgsUtil.getOptionsArg(context.runtime, kwargs, false);
        if (maybeKwargs.isNil()) {
            throw Error.argumentError(context, 3, 1, 2);
        }
        IRubyObject exception2 = ArgsUtil.extractKeywordArg(context, "exception", (RubyHash)maybeKwargs);
        boolean raise2 = exception2.isNil() ? true : exception2.isTrue();
        IRubyObject nil = context.nil;
        if (a1 == nil || a2 == nil) {
            if (raise2) {
                throw Error.typeError(context, "can't convert nil into Rational");
            }
            return nil;
        }
        return RubyRational.convertCommon(context, (RubyClass)recv2, a1, a2, raise2);
    }

    private static IRubyObject convertCommon(ThreadContext context, RubyClass clazz, IRubyObject a1, IRubyObject a2, boolean raise2) {
        IRubyObject tmp;
        RubyComplex a2c;
        RubyComplex a1c;
        if (a1 instanceof RubyComplex && Numeric.k_exact_p((a1c = (RubyComplex)a1).getImage()) && Numeric.f_zero_p(context, a1c.getImage())) {
            a1 = a1c.getReal();
        }
        if (a2 instanceof RubyComplex && Numeric.k_exact_p((a2c = (RubyComplex)a2).getImage()) && Numeric.f_zero_p(context, a2c.getImage())) {
            a2 = a2c.getReal();
        }
        if (!(a1 instanceof RubyInteger)) {
            if (a1 instanceof RubyFloat) {
                a1 = ((RubyFloat)a1).to_r(context);
            } else if (a1 instanceof RubyString) {
                a1 = RubyRational.str_to_r_strict(context, (RubyString)a1, raise2);
                if (!raise2 && a1.isNil()) {
                    return a1;
                }
            } else if (a1 instanceof RubyObject && !a1.respondsTo("to_r")) {
                try {
                    tmp = Convert.checkToInteger(context, a1);
                    if (!tmp.isNil()) {
                        a1 = tmp;
                    }
                }
                catch (RaiseException re) {
                    context.setErrorInfo(context.nil);
                }
            }
        }
        if (!(a2 instanceof RubyInteger)) {
            if (a2 instanceof RubyFloat) {
                a2 = ((RubyFloat)a2).to_r(context);
            } else if (a2 instanceof RubyString) {
                a2 = RubyRational.str_to_r_strict(context, (RubyString)a2, raise2);
                if (!raise2 && a2.isNil()) {
                    return a2;
                }
            } else if (!a2.isNil() & a2 instanceof RubyObject && !a2.respondsTo("to_r")) {
                try {
                    tmp = Convert.checkToInteger(context, a2);
                    if (!tmp.isNil()) {
                        a2 = tmp;
                    }
                }
                catch (RaiseException re) {
                    context.setErrorInfo(context.nil);
                }
            }
        }
        if (a1 instanceof RubyRational && (a2 == context.nil || Numeric.k_exact_p(a2) && Numeric.f_one_p(context, a2))) {
            return a1;
        }
        RubyClass rationalClazz = context.runtime.getRational();
        if (a2 == context.nil) {
            if (!(a1 instanceof RubyNumeric) || !Numeric.f_integer_p(context, (RubyNumeric)a1)) {
                if (!raise2) {
                    try {
                        IRubyObject ret = TypeConverter.convertToType(context, a1, rationalClazz, RubyRational.sites((ThreadContext)context).to_r_checked);
                        return ret;
                    }
                    catch (RaiseException re) {
                        context.setErrorInfo(context.nil);
                        return context.nil;
                    }
                }
                return TypeConverter.convertToType(context, a1, rationalClazz, RubyRational.sites((ThreadContext)context).to_r_checked);
            }
        } else {
            if (!(a1 instanceof RubyNumeric)) {
                try {
                    a1 = TypeConverter.convertToType(context, a1, rationalClazz, RubyRational.sites((ThreadContext)context).to_r_checked);
                }
                catch (RaiseException re) {
                    if (!raise2) {
                        context.setErrorInfo(context.nil);
                        return context.nil;
                    }
                    throw re;
                }
            }
            if (!(a2 instanceof RubyNumeric)) {
                try {
                    a2 = TypeConverter.convertToType(context, a2, rationalClazz, RubyRational.sites((ThreadContext)context).to_r_checked);
                }
                catch (RaiseException re) {
                    if (!raise2) {
                        context.setErrorInfo(context.nil);
                        return context.nil;
                    }
                    throw re;
                }
            }
            if (a1 instanceof RubyNumeric && a2 instanceof RubyNumeric && (!Numeric.f_integer_p(context, (RubyNumeric)a1) || !Numeric.f_integer_p(context, (RubyNumeric)a2))) {
                try {
                    IRubyObject tmp2 = TypeConverter.convertToType(context, a1, rationalClazz, RubyRational.sites((ThreadContext)context).to_r_checked, true);
                    a1 = tmp2 instanceof RubyRational ? tmp2 : context.nil;
                }
                catch (RaiseException e) {
                    context.setErrorInfo(context.nil);
                }
                return Numeric.f_div(context, a1, a2);
            }
        }
        a1 = RubyRational.intCheck(context, a1);
        if (a2.isNil()) {
            a2 = RubyFixnum.one(context.runtime);
        } else {
            if (!(a2 instanceof RubyInteger) && !raise2) {
                return context.nil;
            }
            a2 = RubyRational.intCheck(context, a2);
        }
        return RubyRational.newInstance(context, clazz, a1, a2, raise2);
    }

    @Override
    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        return this.num;
    }

    @Override
    @JRubyMethod(name={"denominator"})
    public IRubyObject denominator(ThreadContext context) {
        return this.den;
    }

    public RubyInteger getNumerator() {
        return this.num;
    }

    public RubyInteger getDenominator() {
        return this.den;
    }

    @Override
    public RubyRational convertToRational(ThreadContext context) {
        return this;
    }

    @Override
    public IRubyObject zero_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isZero(context));
    }

    @Override
    public final boolean isZero(ThreadContext context) {
        return this.num.isZero(context);
    }

    @Override
    public IRubyObject nonzero_p(ThreadContext context) {
        return this.isZero(context) ? context.nil : this;
    }

    @Override
    public IRubyObject isNegative(ThreadContext context) {
        return Convert.asBoolean(context, this.isNegativeNumber(context));
    }

    @Override
    public IRubyObject isPositive(ThreadContext context) {
        return Convert.asBoolean(context, this.isPositiveNumber(context));
    }

    @Override
    public boolean isNegativeNumber(ThreadContext context) {
        return this.signum(context) < 0;
    }

    @Override
    public boolean isPositiveNumber(ThreadContext context) {
        return this.signum(context) > 0;
    }

    @Deprecated(since="10.0.0.0")
    public final int signum() {
        return this.signum(this.getCurrentContext());
    }

    public final int signum(ThreadContext context) {
        return this.num.signum(context);
    }

    private static RubyInteger f_imul(ThreadContext context, long a, long b2) {
        if (a == 0L || b2 == 0L) {
            return Convert.asFixnum(context, 0);
        }
        if (a == 1L) {
            return Convert.asFixnum(context, b2);
        }
        if (b2 == 1L) {
            return Convert.asFixnum(context, a);
        }
        long c = a * b2;
        return c / a != b2 ? (RubyInteger)RubyBignum.newBignum(context.runtime, a).op_mul(context, b2) : Convert.asFixnum(context, c);
    }

    /*
     * Unable to fully structure code
     */
    private static RubyNumeric f_addsub(ThreadContext context, RubyClass metaClass, RubyInteger anum, RubyInteger aden, RubyInteger bnum, RubyInteger bden, boolean plus) {
        if (!(anum instanceof RubyFixnum)) ** GOTO lbl-1000
        anumf = (RubyFixnum)anum;
        if (!(aden instanceof RubyFixnum)) ** GOTO lbl-1000
        adenf = (RubyFixnum)aden;
        if (!(bnum instanceof RubyFixnum)) ** GOTO lbl-1000
        bnumf = (RubyFixnum)bnum;
        if (bden instanceof RubyFixnum) {
            bdenf = (RubyFixnum)bden;
            an = anumf.getValue();
            ad = adenf.getValue();
            bn = bnumf.getValue();
            bd = bdenf.getValue();
            ig = Numeric.i_gcd(ad, bd);
            g = Convert.asFixnum(context, ig);
            a = RubyRational.f_imul(context, an, bd / ig);
            b = RubyRational.f_imul(context, bn, ad / ig);
        } else lbl-1000:
        // 4 sources

        {
            g = Numeric.f_gcd(context, aden, bden);
            a = Numeric.f_mul(context, anum, Numeric.f_idiv(context, bden, g));
            b = Numeric.f_mul(context, bnum, Numeric.f_idiv(context, aden, g));
        }
        c = plus != false ? Numeric.f_add(context, a, b) : Numeric.f_sub(context, a, b);
        b = Numeric.f_idiv(context, aden, g);
        g = Numeric.f_gcd(context, c, g);
        newNum = Numeric.f_idiv(context, c, g);
        a = Numeric.f_idiv(context, bden, g);
        newDen = Numeric.f_mul(context, a, b);
        return RubyRational.newRationalNoReduce(context, metaClass, newNum, newDen);
    }

    @Override
    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyInteger) {
            return RubyRational.f_addsub(context, this.getMetaClass(), this.num, this.den, (RubyInteger)other, RubyFixnum.one(context.runtime), true);
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_add(context, RubyRational.r_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            return this.op_plus(context, (RubyRational)other);
        }
        return this.coerceBin(context, RubyRational.sites((ThreadContext)context).op_plus, other);
    }

    public final RubyNumeric op_plus(ThreadContext context, RubyRational other) {
        return RubyRational.f_addsub(context, this.getMetaClass(), this.num, this.den, other.num, other.den, true);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject op_add(ThreadContext context, IRubyObject other) {
        return this.op_plus(context, other);
    }

    @Override
    @JRubyMethod(name={"-"})
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyInteger) {
            return RubyRational.f_addsub(context, this.getMetaClass(), this.num, this.den, (RubyInteger)other, RubyFixnum.one(context.runtime), false);
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_sub(context, RubyRational.r_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            return this.op_minus(context, (RubyRational)other);
        }
        return this.coerceBin(context, RubyRational.sites((ThreadContext)context).op_minus, other);
    }

    public final RubyNumeric op_minus(ThreadContext context, RubyRational other) {
        return RubyRational.f_addsub(context, this.getMetaClass(), this.num, this.den, other.num, other.den, false);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject op_sub(ThreadContext context, IRubyObject other) {
        return this.op_minus(context, other);
    }

    @Override
    public IRubyObject op_uminus(ThreadContext context) {
        return RubyRational.newRationalNoReduce(context, this.num.negate(context), this.den);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static RubyNumeric f_muldiv(ThreadContext context, RubyClass clazz, RubyInteger anum, RubyInteger aden, RubyInteger bnum, RubyInteger bden, boolean mult) {
        RubyInteger newDen;
        RubyInteger newNum;
        if (!mult) {
            if (Numeric.f_negative_p(context, bnum)) {
                anum = anum.negate(context);
                bnum = bnum.negate(context);
            }
            RubyInteger tmp = bnum;
            bnum = bden;
            bden = tmp;
        }
        if (anum instanceof RubyFixnum) {
            RubyFixnum anumf = (RubyFixnum)anum;
            if (aden instanceof RubyFixnum) {
                RubyFixnum adenf = (RubyFixnum)aden;
                if (bnum instanceof RubyFixnum) {
                    RubyFixnum bnumf = (RubyFixnum)bnum;
                    if (bden instanceof RubyFixnum) {
                        RubyFixnum bdenf = (RubyFixnum)bden;
                        long an = anumf.getValue();
                        long ad = adenf.getValue();
                        long bn = bnumf.getValue();
                        long bd = bdenf.getValue();
                        long g1 = Numeric.i_gcd(an, bd);
                        long g2 = Numeric.i_gcd(ad, bn);
                        newNum = RubyRational.f_imul(context, an / g1, bn / g2);
                        newDen = RubyRational.f_imul(context, ad / g2, bd / g1);
                        return RubyRational.newRationalNoReduce(context, clazz, newNum, newDen);
                    }
                }
            }
        }
        RubyInteger g1 = Numeric.f_gcd(context, anum, bden);
        RubyInteger g2 = Numeric.f_gcd(context, aden, bnum);
        newNum = Numeric.f_mul(context, Numeric.f_idiv(context, anum, g1), Numeric.f_idiv(context, bnum, g2));
        newDen = Numeric.f_mul(context, Numeric.f_idiv(context, aden, g2), Numeric.f_idiv(context, bden, g1));
        return RubyRational.newRationalNoReduce(context, clazz, newNum, newDen);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyInteger) {
            return this.op_mul(context, (RubyInteger)other);
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_mul(context, RubyRational.r_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            RubyRational otherRational = (RubyRational)other;
            return RubyRational.f_muldiv(context, this.getMetaClass(), this.num, this.den, otherRational.num, otherRational.den, true);
        }
        return this.coerceBin(context, RubyRational.sites((ThreadContext)context).op_times, other);
    }

    public IRubyObject op_mul(ThreadContext context, RubyInteger other) {
        return RubyRational.f_muldiv(context, this.getMetaClass(), this.num, this.den, other, RubyFixnum.one(context.runtime), true);
    }

    @JRubyMethod(name={"/", "quo"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyInteger) {
            RubyInteger otherInteger = (RubyInteger)other;
            return this.op_div(context, otherInteger);
        }
        if (other instanceof RubyFloat) {
            IRubyObject fval = RubyRational.r_to_f(context, this);
            return context.sites.Float.op_quo.call(context, fval, fval, other);
        }
        if (other instanceof RubyRational) {
            RubyRational otherRational = (RubyRational)other;
            if (otherRational.isZero(context)) {
                throw context.runtime.newZeroDivisionError();
            }
            return RubyRational.f_muldiv(context, this.getMetaClass(), this.num, this.den, otherRational.num, otherRational.den, false);
        }
        return this.coerceBin(context, RubyRational.sites((ThreadContext)context).op_quo, other);
    }

    public final RubyNumeric op_div(ThreadContext context, RubyInteger other) {
        if (other.isZero(context)) {
            throw context.runtime.newZeroDivisionError();
        }
        return RubyRational.f_muldiv(context, this.getMetaClass(), this.num, this.den, other, Convert.asFixnum(context, 1), false);
    }

    @Override
    @JRubyMethod(name={"fdiv"})
    public IRubyObject fdiv(ThreadContext context, IRubyObject other) {
        return Numeric.f_div(context, RubyRational.r_to_f(context, this), other);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_expt(ThreadContext context, IRubyObject other) {
        if (Numeric.k_exact_p(other) && Numeric.f_zero_p(context, other)) {
            return RubyRational.newRationalBang(context, this.getMetaClass(), 1L);
        }
        if (other instanceof RubyRational) {
            RubyRational rat = (RubyRational)other;
            if (rat.den.isOne(context)) {
                other = rat.num;
            }
        }
        if (Numeric.k_numeric_p(other) && Numeric.k_exact_p(other) && this.den.isOne(context)) {
            if (this.num.isOne(context)) {
                return RubyRational.newRationalBang(context, this.getMetaClass(), 1L);
            }
            if (Numeric.f_minus_one_p(context, this.num) && Numeric.k_integer_p(other)) {
                return RubyRational.newRationalBang(context, this.getMetaClass(), Numeric.f_odd_p(context, other) ? -1L : 1L);
            }
            if (Numeric.f_zero_p(context, this.num)) {
                if (Numeric.f_negative_p(context, other)) {
                    throw context.runtime.newZeroDivisionError();
                }
                return RubyRational.newRationalBang(context, this.getMetaClass(), 0L);
            }
        }
        if (other instanceof RubyFixnum) {
            RubyNumeric den;
            RubyNumeric num;
            RubyFixnum otherFixnum = (RubyFixnum)other;
            if (otherFixnum.isPositiveNumber(context)) {
                num = (RubyNumeric)this.num.pow(context, other);
                den = (RubyNumeric)this.den.pow(context, other);
            } else if (otherFixnum.isNegativeNumber(context)) {
                RubyInteger negate2 = otherFixnum.negate(context);
                num = (RubyNumeric)this.den.pow(context, negate2);
                den = (RubyNumeric)this.num.pow(context, negate2);
            } else {
                den = Convert.asFixnum(context, 1);
                num = den;
            }
            if (num instanceof RubyFloat) {
                return den instanceof RubyFloat ? Convert.asFloat(context, Double.NaN) : num;
            }
            if (den instanceof RubyFloat) {
                num = Convert.asFixnum(context, 0);
                den = Convert.asFixnum(context, 1);
            }
            return RubyRational.newInstance(context, this.getMetaClass(), (IRubyObject)num, (IRubyObject)den);
        }
        if (other instanceof RubyBignum) {
            throw Error.argumentError(context, "exponent is too large");
        }
        if (other instanceof RubyFloat || other instanceof RubyRational) {
            return Numeric.f_expt(context, RubyRational.r_to_f(context, this), other);
        }
        return this.coerceBin(context, RubyRational.sites((ThreadContext)context).op_exp, other);
    }

    public final IRubyObject op_expt(ThreadContext context, long other) {
        if (other == 0L) {
            return RubyRational.newRationalBang(context, this.getMetaClass(), 1L);
        }
        if (this.den.isOne(context)) {
            if (this.num.isOne(context)) {
                return RubyRational.newRationalBang(context, this.getMetaClass(), 1L);
            }
            if (Numeric.f_minus_one_p(context, this.num)) {
                return RubyRational.newRationalBang(context, this.getMetaClass(), other % 2L != 0L ? -1L : 1L);
            }
            if (Numeric.f_zero_p(context, this.num)) {
                if (other < 0L) {
                    throw context.runtime.newZeroDivisionError();
                }
                return RubyRational.newRationalBang(context, this.getMetaClass(), 0L);
            }
        }
        return this.fix_expt(context, Convert.asFixnum(context, other), Long.signum(other));
    }

    private RubyNumeric fix_expt(ThreadContext context, RubyInteger other, int sign2) {
        RubyInteger tden;
        RubyInteger tnum;
        if (sign2 > 0) {
            tnum = (RubyInteger)Numeric.f_expt(context, this.num, other);
            tden = (RubyInteger)Numeric.f_expt(context, this.den, other);
        } else if (sign2 < 0) {
            RubyInteger otherNeg = other.negate(context);
            tnum = (RubyInteger)Numeric.f_expt(context, this.den, otherNeg);
            tden = (RubyInteger)Numeric.f_expt(context, this.num, otherNeg);
        } else {
            tden = Convert.asFixnum(context, 1);
            tnum = tden;
        }
        return RubyRational.newInstance(context, this.getMetaClass(), tnum, tden);
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            if (this.den instanceof RubyFixnum && ((RubyFixnum)this.den).getValue() == 1L) {
                return Numeric.f_cmp(context, (IRubyObject)this.num, other);
            }
            return Numeric.f_cmp(context, this, RubyRational.newRationalBang(context, this.getMetaClass(), other));
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_cmp(context, RubyRational.r_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            RubyInteger num2;
            RubyInteger num1;
            RubyRational otherRational = (RubyRational)other;
            if (this.num instanceof RubyFixnum && this.den instanceof RubyFixnum && otherRational.num instanceof RubyFixnum && otherRational.den instanceof RubyFixnum) {
                num1 = RubyRational.f_imul(context, ((RubyFixnum)this.num).getValue(), ((RubyFixnum)otherRational.den).getValue());
                num2 = RubyRational.f_imul(context, ((RubyFixnum)otherRational.num).getValue(), ((RubyFixnum)this.den).getValue());
            } else {
                num1 = Numeric.f_mul(context, this.num, otherRational.den);
                num2 = Numeric.f_mul(context, otherRational.num, this.den);
            }
            return Numeric.f_cmp(context, Numeric.f_sub(context, num1, num2), RubyFixnum.zero(context.runtime));
        }
        return this.coerceCmp(context, RubyRational.sites((ThreadContext)context).op_cmp, other);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return this.op_equal(context, (RubyInteger)other);
        }
        if (other instanceof RubyFloat) {
            return Numeric.f_equal(context, RubyRational.r_to_f(context, this), other);
        }
        if (other instanceof RubyRational) {
            return this.op_equal(context, (RubyRational)other);
        }
        return Numeric.f_equal(context, other, this);
    }

    public final IRubyObject op_equal(ThreadContext context, RubyInteger other) {
        RubyFixnum fixnum;
        if (this.num.isZero(context)) {
            return Convert.asBoolean(context, other.isZero(context));
        }
        RubyInteger rubyInteger = this.den;
        if (!(rubyInteger instanceof RubyFixnum) || (fixnum = (RubyFixnum)rubyInteger).getValue() != 1L) {
            return context.fals;
        }
        return Numeric.f_equal(context, this.num, other);
    }

    final RubyBoolean op_equal(ThreadContext context, RubyRational other) {
        if (this.num.isZero(context)) {
            return Convert.asBoolean(context, other.num.isZero(context));
        }
        return Convert.asBoolean(context, Numeric.f_equal(context, this.num, other.num).isTrue() && Numeric.f_equal(context, this.den, other.den).isTrue());
    }

    @Override
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyRational)) {
            return context.fals;
        }
        return this.op_equal(context, (RubyRational)other);
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject op_coerce(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return Create.newArray(context, (IRubyObject)RubyRational.newRationalBang(context, this.getMetaClass(), other), (IRubyObject)this);
        }
        if (other instanceof RubyFloat) {
            return Create.newArray(context, other, RubyRational.r_to_f(context, this));
        }
        if (other instanceof RubyRational) {
            return Create.newArray(context, other, (IRubyObject)this);
        }
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            if (Numeric.k_exact_p(otherComplex.getImage()) && Numeric.f_zero_p(context, otherComplex.getImage())) {
                return Create.newArray(context, (IRubyObject)RubyRational.newRationalBang(context, this.getMetaClass(), otherComplex.getReal()), (IRubyObject)this);
            }
            return Create.newArray(context, other, RubyComplex.newComplexCanonicalize(context, this));
        }
        throw Error.typeError(context, RubyStringBuilder.str(context.runtime, other.getMetaClass(), " can't be coerced into ", this.getMetaClass()));
    }

    @Override
    public IRubyObject idiv(ThreadContext context, IRubyObject other) {
        if (Convert.toDouble(context, other) == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return Numeric.f_floor(context, Numeric.f_div(context, this, other));
    }

    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        if (Convert.toDouble(context, other) == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return Numeric.f_sub(context, this, Numeric.f_mul(context, other, Numeric.f_floor(context, Numeric.f_div(context, this, other))));
    }

    @JRubyMethod(name={"divmod"})
    public IRubyObject op_divmod(ThreadContext context, IRubyObject other) {
        if (Convert.toDouble(context, other) == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        IRubyObject val = Numeric.f_floor(context, Numeric.f_div(context, this, other));
        return Create.newArray(context, val, Numeric.f_sub(context, this, Numeric.f_mul(context, other, val)));
    }

    @JRubyMethod(name={"remainder"})
    public IRubyObject op_rem(ThreadContext context, IRubyObject other) {
        IRubyObject val = Numeric.f_truncate(context, Numeric.f_div(context, this, other));
        return Numeric.f_sub(context, this, Numeric.f_mul(context, other, val));
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject op_abs(ThreadContext context) {
        if (!Numeric.f_negative_p(context, this)) {
            return this;
        }
        return Numeric.f_negate(context, this);
    }

    @Override
    @JRubyMethod(name={"floor"})
    public IRubyObject floor(ThreadContext context) {
        return this.roundCommon(context, null, RoundingMode.FLOOR);
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject floor(ThreadContext context, IRubyObject n) {
        return this.roundCommon(context, n, RoundingMode.FLOOR);
    }

    private IRubyObject mriFloor(ThreadContext context) {
        return this.num.idiv(context, this.den);
    }

    @Override
    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil(ThreadContext context) {
        return this.roundCommon(context, null, RoundingMode.CEILING);
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil(ThreadContext context, IRubyObject n) {
        return this.roundCommon(context, n, RoundingMode.CEILING);
    }

    private IRubyObject mriCeil(ThreadContext context) {
        return ((RubyInteger)((RubyInteger)this.num.op_uminus(context)).idiv(context, this.den)).op_uminus(context);
    }

    @Override
    public RubyInteger convertToInteger() {
        return this.mriTruncate(this.metaClass.runtime.getCurrentContext());
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i(ThreadContext context) {
        return this.mriTruncate(context);
    }

    @Override
    public BigInteger asBigInteger(ThreadContext context) {
        return this.convertToInteger().asBigInteger(context);
    }

    @Override
    @JRubyAPI
    public long asLong(ThreadContext context) {
        return this.convertToInteger().asLong(context);
    }

    @Override
    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate(ThreadContext context) {
        return this.roundCommon(context, null, RoundingMode.UNNECESSARY);
    }

    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate(ThreadContext context, IRubyObject n) {
        return this.roundCommon(context, n, RoundingMode.UNNECESSARY);
    }

    private RubyInteger mriTruncate(ThreadContext context) {
        if (this.num.isNegativeNumber(context)) {
            return ((RubyInteger)this.num.negate(context).idiv(context, this.den)).negate(context);
        }
        return (RubyInteger)this.num.idiv(context, this.den);
    }

    @Override
    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context) {
        return this.roundCommon(context, null, RoundingMode.HALF_UP);
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context, IRubyObject n) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context, n);
        if (opts != context.nil) {
            n = null;
        }
        return this.roundCommon(context, n, RubyNumeric.getRoundingMode(context, opts));
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round(ThreadContext context, IRubyObject n, IRubyObject opts) {
        opts = ArgsUtil.getOptionsArg(context, opts);
        return this.roundCommon(context, n, RubyNumeric.getRoundingMode(context, opts));
    }

    /*
     * Enabled aggressive block sorting
     */
    public IRubyObject roundCommon(ThreadContext context, IRubyObject n, RoundingMode mode2) {
        IRubyObject iRubyObject;
        RubyRational rat;
        IRubyObject s2;
        if (n == null) {
            return this.doRound(context, mode2);
        }
        if (!(n instanceof RubyInteger)) throw Error.typeError(context, "not an integer");
        RubyInteger nint = (RubyInteger)n;
        int nsign = nint.signum(context);
        RubyNumeric b2 = Numeric.f_expt(context, Convert.asFixnum(context, 10), nint);
        IRubyObject iRubyObject2 = s2 = nsign >= 0 ? this.op_mul(context, (RubyInteger)b2) : this.op_mul(context, b2);
        if (s2 instanceof RubyFloat) {
            RubyNumeric rubyNumeric;
            if (nsign < 0) {
                rubyNumeric = RubyFixnum.zero(context.runtime);
                return rubyNumeric;
            }
            rubyNumeric = this;
            return rubyNumeric;
        }
        RubyRational sr = s2 instanceof RubyRational ? (rat = (RubyRational)s2) : RubyRational.newRationalBang(context, this.getMetaClass(), s2);
        IRubyObject si = RubyRational.newRationalBang(context, this.getMetaClass(), sr.doRound(context, mode2)).op_div(context, b2);
        if (si instanceof RubyRational) {
            RubyRational r = (RubyRational)si;
            if (Numeric.f_cmp(context, nint, 1L).getValue() < 0L) {
                iRubyObject = r.truncate(context);
                return iRubyObject;
            }
        }
        iRubyObject = si;
        return iRubyObject;
    }

    private IRubyObject doRound(ThreadContext context, RoundingMode mode2) {
        return switch (mode2) {
            case RoundingMode.HALF_UP -> this.roundHalfUp(context);
            case RoundingMode.HALF_EVEN -> this.roundHalfEven(context);
            case RoundingMode.HALF_DOWN -> this.roundHalfDown(context);
            case RoundingMode.FLOOR -> this.mriFloor(context);
            case RoundingMode.CEILING -> this.mriCeil(context);
            case RoundingMode.UNNECESSARY -> this.mriTruncate(context);
            default -> throw Error.runtimeError(context, "BUG: invalid rounding mode: " + String.valueOf((Object)mode2));
        };
    }

    private RubyInteger roundHalfDown(ThreadContext context) {
        RubyInteger num = this.num;
        RubyInteger den = this.den;
        boolean neg = num.isNegativeNumber(context);
        if (neg) {
            num = (RubyInteger)num.op_uminus(context);
        }
        num = (RubyInteger)((RubyInteger)num.op_mul(context, 2L)).op_plus(context, den);
        num = (RubyInteger)num.op_minus(context, 1L);
        den = (RubyInteger)den.op_mul(context, 2L);
        num = (RubyInteger)num.idiv(context, den);
        if (neg) {
            num = (RubyInteger)num.op_uminus(context);
        }
        return num;
    }

    private RubyInteger roundHalfEven(ThreadContext context) {
        RubyInteger num = this.num;
        RubyInteger den = this.den;
        boolean neg = num.isNegativeNumber(context);
        if (neg) {
            num = (RubyInteger)num.op_uminus(context);
        }
        num = (RubyInteger)((RubyInteger)num.op_mul(context, 2L)).op_plus(context, den);
        den = (RubyInteger)den.op_mul(context, 2L);
        RubyArray qr = (RubyArray)num.divmod(context, den);
        num = (RubyInteger)qr.eltOk(0L);
        if (((RubyInteger)qr.eltOk(1L)).isZero(context)) {
            num = (RubyInteger)num.op_and(context, Convert.asFixnum(context, -2L));
        }
        if (neg) {
            num = (RubyInteger)num.op_uminus(context);
        }
        return num;
    }

    private RubyInteger roundHalfUp(ThreadContext context) {
        RubyInteger num = this.num;
        RubyInteger den = this.den;
        boolean neg = num.isNegativeNumber(context);
        if (neg) {
            num = (RubyInteger)num.op_uminus(context);
        }
        num = (RubyInteger)((RubyInteger)num.op_mul(context, 2L)).op_plus(context, den);
        den = (RubyInteger)den.op_mul(context, 2L);
        num = (RubyInteger)num.idiv(context, den);
        if (neg) {
            num = (RubyInteger)num.op_uminus(context);
        }
        return num;
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f(ThreadContext context) {
        return Convert.asFloat(context, this.asDouble(context));
    }

    @Override
    @JRubyAPI
    public double asDouble(ThreadContext context) {
        long e;
        if (Numeric.f_zero_p(context, this.num)) {
            return 0.0;
        }
        RubyInteger myNum = this.num;
        RubyInteger myDen = this.den;
        boolean minus = false;
        if (Numeric.f_negative_p(context, myNum)) {
            myNum = Numeric.f_negate(context, myNum);
            minus = true;
        }
        long nl = Numeric.i_ilog2(context, myNum);
        long dl = Numeric.i_ilog2(context, myDen);
        long ne = 0L;
        if (nl > ML) {
            ne = nl - ML;
            myNum = myNum.op_rshift(context, ne);
        }
        long de = 0L;
        if (dl > ML) {
            de = dl - ML;
            myDen = myDen.op_rshift(context, de);
        }
        if ((e = ne - de) > 1023L || e < -1022L) {
            Warn.warn(context, "out of Float range");
            return e > 0L ? Double.MAX_VALUE : 0.0;
        }
        double f = Convert.toDouble(context, myNum) / Convert.toDouble(context, myDen);
        if (minus) {
            f = -f;
        }
        if (Double.isInfinite(f = Numeric.ldexp(f, e)) || Double.isNaN(f)) {
            Warn.warn(context, "out of Float range");
        }
        return f;
    }

    @Deprecated(since="10.0.0.0")
    public double getDoubleValue(ThreadContext context) {
        return this.asDouble(context);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"rationalize"}, optional=1, checkArity=false)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject b2;
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        if (argc == 0) {
            return this.to_r(context);
        }
        if (Numeric.f_negative_p(context, this)) {
            return Numeric.f_negate(context, ((RubyRational)Numeric.f_abs(context, this)).rationalize(context, args2));
        }
        IRubyObject eps = Numeric.f_abs(context, args2[0]);
        IRubyObject a = Numeric.f_sub(context, this, eps);
        if (Numeric.f_equal(context, a, b2 = Numeric.f_add(context, this, eps)).isTrue()) {
            return this;
        }
        IRubyObject[] ans = Numeric.nurat_rationalize_internal(context, a, b2);
        return RubyRational.newInstance(context, this.metaClass, (RubyInteger)ans[0], (RubyInteger)ans[1]);
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return (RubyFixnum)Numeric.f_xor(context, (RubyInteger)Helpers.invokedynamic(context, (IRubyObject)this.num, MethodNames.HASH), (RubyInteger)Helpers.invokedynamic(context, (IRubyObject)this.den, MethodNames.HASH));
    }

    @Override
    public int hashCode() {
        return this.num.hashCode() ^ this.den.hashCode();
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public RubyString to_s(ThreadContext context) {
        RubyString str = Create.newString(context, new ByteList(10), (Encoding)USASCIIEncoding.INSTANCE);
        return str.append(this.num.to_s(context)).cat((byte)47).append(this.den.to_s(context));
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public RubyString inspect(ThreadContext context) {
        RubyString str = Create.newString(context, new ByteList(12), (Encoding)USASCIIEncoding.INSTANCE);
        str.cat((byte)40);
        str.append((RubyString)this.num.inspect(context));
        str.cat((byte)47);
        str.append((RubyString)this.den.inspect(context));
        str.cat((byte)41);
        return str;
    }

    @JRubyMethod(name={"marshal_dump"}, visibility=Visibility.PRIVATE)
    public IRubyObject marshal_dump(ThreadContext context) {
        RubyArray<?> dump2 = Create.newArray(context, (IRubyObject)this.num, (IRubyObject)this.den);
        if (this.hasVariables()) {
            dump2.syncVariables(this);
        }
        return dump2;
    }

    @JRubyMethod(name={"marshal_load"})
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        IRubyObject den;
        this.checkFrozen();
        RubyArray load2 = arg2.convertToArray();
        IRubyObject num = load2.size() > 0 ? load2.eltInternal(0) : context.nil;
        IRubyObject iRubyObject = den = load2.size() > 1 ? load2.eltInternal(1) : context.nil;
        if (den != context.nil && RubyRational.canonicalizeShouldNegate(context, den.convertToInteger())) {
            num = Numeric.f_negate(context, num);
            den = Numeric.f_negate(context, den);
        }
        RubyRational.intCheck(context, num);
        RubyRational.intCheck(context, den);
        this.num = (RubyInteger)num;
        this.den = (RubyInteger)den;
        if (load2.hasVariables()) {
            this.syncVariables(load2);
        }
        return this;
    }

    static IRubyObject[] str_to_r_internal(ThreadContext context, RubyString str, boolean raise2) {
        IRubyObject m;
        str.verifyAsciiCompatible();
        IRubyObject nil = context.nil;
        ByteList bytes2 = str.getByteList();
        if (bytes2.getRealSize() == 0) {
            return new IRubyObject[]{nil, str};
        }
        try {
            m = RubyRegexp.newDummyRegexp(context.runtime, Numeric.RationalPatterns.rat_pat).match_m(context, (IRubyObject)str, false);
        }
        catch (RaiseException re) {
            context.setErrorInfo(context.nil);
            return new IRubyObject[]{context.nil};
        }
        if (m != nil) {
            ByteList siBytes;
            RubyMatchData match2 = (RubyMatchData)m;
            IRubyObject si = match2.at(context, 1);
            RubyString nu = (RubyString)match2.at(context, 2);
            IRubyObject de = match2.at(context, 3);
            IRubyObject re = match2.post_match(context);
            RubyArray a = nu.split(context, RubyRegexp.newDummyRegexp(context.runtime, Numeric.RationalPatterns.an_e_pat));
            RubyString ifp = (RubyString)a.eltInternal(0);
            IRubyObject exp2 = a.size() != 2 ? nil : a.eltInternal(1);
            a = ifp.split(context, Create.newString(context, "."));
            Object ip2 = a.eltInternal(0);
            IRubyObject fp = a.size() != 2 ? nil : a.eltInternal(1);
            IRubyObject v = RubyRational.newRationalCanonicalize(context, (RubyInteger)Numeric.f_to_i(context, ip2));
            if (fp != nil) {
                int i2;
                bytes2 = fp.convertToString().getByteList();
                int count2 = 0;
                byte[] buf = bytes2.getUnsafeBytes();
                int end2 = i2 + bytes2.getRealSize();
                for (i2 = bytes2.getBegin(); i2 < end2; ++i2) {
                    if (!ASCIIEncoding.INSTANCE.isDigit(buf[i2])) continue;
                    ++count2;
                }
                RubyInteger l = (RubyInteger)Convert.asFixnum(context, 10).op_pow(context, count2);
                v = Numeric.f_mul(context, v, (IRubyObject)l);
                v = Numeric.f_add(context, v, Numeric.f_to_i(context, fp));
                v = Numeric.f_div(context, v, l);
            }
            if (si != nil && !(siBytes = si.convertToString().getByteList()).isEmpty() && siBytes.get(0) == 45) {
                v = Numeric.f_negate(context, v);
            }
            if (exp2 != nil) {
                IRubyObject denExp = Numeric.f_to_i(context, exp2);
                v = denExp instanceof RubyFixnum ? Numeric.f_mul(context, v, Numeric.f_expt(context, (IRubyObject)Convert.asFixnum(context, 10), denExp)) : (Numeric.f_negative_p(context, denExp) ? Convert.asFloat(context, 0.0) : Convert.asFloat(context, Double.POSITIVE_INFINITY));
            }
            if (de != nil) {
                IRubyObject denominator2 = Numeric.f_to_r(context, de);
                if (!raise2 && Numeric.f_zero_p(context, denominator2)) {
                    return new IRubyObject[]{nil, str};
                }
                v = Numeric.f_div(context, v, denominator2);
            }
            return new IRubyObject[]{v, re};
        }
        return new IRubyObject[]{nil, str};
    }

    private static IRubyObject str_to_r_strict(ThreadContext context, RubyString str, boolean raise2) {
        IRubyObject[] ary = RubyRational.str_to_r_internal(context, str, raise2);
        if (ary[0] == context.nil || ary[1].convertToString().getByteList().length() > 0) {
            if (raise2) {
                throw Error.argumentError(context, "invalid value for convert(): " + String.valueOf(str.inspect(context)));
            }
            return context.nil;
        }
        return ary[0];
    }

    public static IRubyObject numericQuo(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (x instanceof RubyComplex) {
            RubyComplex c = (RubyComplex)x;
            return c.op_div(context, y);
        }
        if (y instanceof RubyFloat) {
            return ((RubyNumeric)x).fdiv(context, y);
        }
        x = TypeConverter.convertToType(x, context.runtime.getRational(), "to_r");
        return ((RubyRational)x).op_div(context, y);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject op_floor(ThreadContext context) {
        return this.floor(context);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject op_floor(ThreadContext context, IRubyObject n) {
        return this.floor(context, n);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject op_ceil(ThreadContext context) {
        return this.ceil(context);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject op_ceil(ThreadContext context, IRubyObject n) {
        return this.ceil(context, n);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject op_idiv(ThreadContext context, IRubyObject other) {
        return this.idiv(context, other);
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject op_fdiv(ThreadContext context, IRubyObject other) {
        return this.fdiv(context, other);
    }

    private static JavaSites.RationalSites sites(ThreadContext context) {
        return context.sites.Rational;
    }

    private static IRubyObject r_to_f(ThreadContext context, RubyRational r) {
        return RubyRational.sites((ThreadContext)context).to_f.call(context, r, r);
    }
}

