/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArithmeticSequence;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.API;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.JRubyAPI;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callsite.RespondToCallSite;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Numeric;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Range"}, include={"Enumerable"})
public class RubyRange
extends RubyObject {
    private IRubyObject begin;
    private IRubyObject end;
    private boolean isBeginless;
    private boolean isExclusive;
    private boolean isEndless;
    private boolean isInited = false;
    private static final byte[] DOTDOTDOT = new byte[]{46, 46, 46};
    private static final ObjectMarshal RANGE_MARSHAL = new ObjectMarshal(){

        @Deprecated(since="10.0.0.0", forRemoval=true)
        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            RubyRange range = (RubyRange)obj;
            ThreadContext context = runtime2.getCurrentContext();
            marshalStream.registerLinkTarget(context, range);
            List<Variable<Object>> attrs = range.getMarshalVariableList();
            attrs.add(new VariableEntry<RubyBoolean>("excl", range.isExclusive ? context.tru : context.fals));
            attrs.add(new VariableEntry<IRubyObject>("begin", range.begin));
            attrs.add(new VariableEntry<IRubyObject>("end", range.end));
            marshalStream.dumpVariables(attrs);
        }

        public void marshalTo(ThreadContext context, RubyOutputStream out, Object obj, RubyClass type2, MarshalDumper marshalStream) {
            RubyRange range = (RubyRange)obj;
            marshalStream.registerObject(range);
            marshalStream.dumpVariables(context, out, range, 3, (marshal, c, o, v, receiver2) -> {
                receiver2.receive(marshal, c, o, "excl", v.isExclusive ? c.tru : c.fals);
                receiver2.receive(marshal, c, o, "begin", v.begin);
                receiver2.receive(marshal, c, o, "end", v.end);
            });
        }

        @Deprecated(since="10.0.0.0", forRemoval=true)
        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream input) throws IOException {
            ThreadContext context = runtime2.getCurrentContext();
            RubyRange range = (RubyRange)input.entry(type2.allocate(context));
            input.ivar(null, range, null);
            IRubyObject excl = (IRubyObject)range.removeInternalVariable("excl");
            IRubyObject begin2 = (IRubyObject)range.removeInternalVariable("begin");
            IRubyObject end2 = (IRubyObject)range.removeInternalVariable("end");
            if (begin2 == null) {
                begin2 = (IRubyObject)range.removeInternalVariable("begini");
            }
            if (end2 == null) {
                end2 = (IRubyObject)range.removeInternalVariable("endi");
            }
            if (begin2 == null || end2 == null || excl == null) {
                throw Error.argumentError(context, "bad value for range");
            }
            range.init(context, begin2, end2, excl.isTrue());
            return range;
        }

        public Object unmarshalFrom(ThreadContext context, RubyInputStream in, RubyClass type2, MarshalLoader input) {
            RubyRange range = (RubyRange)input.entry(type2.allocate(context));
            input.ivar(context, in, null, range, null);
            IRubyObject excl = (IRubyObject)range.removeInternalVariable("excl");
            IRubyObject begin2 = (IRubyObject)range.removeInternalVariable("begin");
            IRubyObject end2 = (IRubyObject)range.removeInternalVariable("end");
            if (begin2 == null) {
                begin2 = (IRubyObject)range.removeInternalVariable("begini");
            }
            if (end2 == null) {
                end2 = (IRubyObject)range.removeInternalVariable("endi");
            }
            if (begin2 == null || end2 == null || excl == null) {
                throw Error.argumentError(context, "bad value for range");
            }
            range.init(context, begin2, end2, excl.isTrue());
            return range;
        }
    };

    public static RubyClass createRangeClass(ThreadContext context, RubyClass Object2, RubyModule Enumerable) {
        RubyClass Range2 = (RubyClass)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyClass)Define.defineClass(context, "Range", Object2, RubyRange::new).reifiedClass(RubyRange.class)).marshalWith(RANGE_MARSHAL)).kindOf(new RubyModule.JavaClassKindOf(RubyRange.class))).classIndex(ClassIndex.RANGE)).include(context, Enumerable)).defineMethods(context, RubyRange.class);
        ((RubyModule)Range2.defineClassUnder(context, "BSearch", Object2, OBJECT_ALLOCATOR)).defineMethods(context, BSearch.class);
        Range2.setConstantVisibility(context, "BSearch", true);
        return Range2;
    }

    private RubyRange(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.begin = this.end = runtime2.getNil();
    }

    public static RubyRange newRange(ThreadContext context, IRubyObject begin2, IRubyObject end2, boolean isExclusive) {
        RubyRange range = new RubyRange(context.runtime, context.runtime.getRange());
        range.init(context, begin2, end2, isExclusive);
        range.isInited = true;
        return range;
    }

    public static RubyRange newBeginlessRange(ThreadContext context, long end2, boolean isExclusive) {
        Ruby runtime2 = context.runtime;
        RubyRange range = new RubyRange(runtime2, runtime2.getRange());
        range.init(context, context.nil, Convert.asFixnum(context, end2), isExclusive);
        range.isInited = true;
        return range;
    }

    public static RubyRange newEndlessRange(ThreadContext context, long begin2, boolean isExclusive) {
        Ruby runtime2 = context.runtime;
        RubyRange range = new RubyRange(runtime2, runtime2.getRange());
        range.init(context, Convert.asFixnum(context, begin2), context.nil, isExclusive);
        range.isInited = true;
        return range;
    }

    public static RubyRange newRange(ThreadContext context, long begin2, long end2, boolean isExclusive) {
        Ruby runtime2 = context.runtime;
        RubyRange range = new RubyRange(runtime2, runtime2.getRange());
        range.init(context, Convert.asFixnum(context, begin2), Convert.asFixnum(context, end2), isExclusive);
        range.isInited = true;
        return range;
    }

    public static RubyRange newInclusiveRange(ThreadContext context, IRubyObject begin2, IRubyObject end2) {
        return RubyRange.newRange(context, begin2, end2, false);
    }

    public static RubyRange newInclusiveRange(ThreadContext context, long begin2, long end2) {
        return RubyRange.newRange(context, begin2, end2, false);
    }

    public static RubyRange newExclusiveRange(ThreadContext context, IRubyObject begin2, IRubyObject end2) {
        return RubyRange.newRange(context, begin2, end2, true);
    }

    public static RubyRange newExclusiveRange(ThreadContext context, long begin2, long end2) {
        return RubyRange.newRange(context, begin2, end2, true);
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        RubyRange range = (RubyRange)clone2;
        range.begin = this.begin;
        range.end = this.end;
        range.isExclusive = this.isExclusive;
    }

    final boolean checkBegin(ThreadContext context, long length2) {
        long beg;
        long l = beg = this.isBeginless ? 0L : Convert.toLong(context, this.begin);
        return !(beg < 0L ? (beg += length2) < 0L : length2 < beg);
    }

    final long[] begLen(ThreadContext context, long len, int err) {
        long end2;
        long beg = this.isBeginless ? 0L : Convert.toLong(context, this.begin);
        long l = end2 = this.isEndless ? -1L : Convert.toLong(context, this.end);
        if (beg < 0L && (beg += len) < 0L) {
            if (err != 0) {
                throw Error.rangeError(context, beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw Error.rangeError(context, beg + ".." + (this.isExclusive ? "." : "") + end2 + " out of range");
                }
                return null;
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if (end2 < 0L) {
            end2 += len;
        }
        if (!this.isExclusive || this.isEndless) {
            ++end2;
        }
        if ((len = end2 - beg) < 0L) {
            len = 0L;
        }
        return new long[]{beg, len};
    }

    final long begLen0(ThreadContext context, long len) {
        long beg;
        long l = beg = this.isBeginless ? 0L : Convert.toLong(context, this.begin);
        if (beg < 0L && (beg += len) < 0L) {
            throw Error.rangeError(context, beg - len + ".." + (this.isExclusive ? "." : "") + String.valueOf(this.end) + " out of range");
        }
        return beg;
    }

    final long begLen1(ThreadContext context, long len, long beg) {
        long end2;
        long l = end2 = this.isEndless ? -1L : Convert.toLong(context, this.end);
        if (end2 < 0L) {
            end2 += len;
        }
        if (!this.isExclusive || this.isEndless) {
            ++end2;
        }
        if ((len = end2 - beg) < 0L) {
            len = 0L;
        }
        return len;
    }

    @Deprecated(since="10.0.0.0")
    final int[] begLenInt(int len, int err) {
        return this.begLenInt(this.getCurrentContext(), len, err);
    }

    final int[] begLenInt(ThreadContext context, int len, int err) {
        int end2;
        int beg = this.isBeginless ? 0 : Convert.toInt(context, this.begin);
        int n = end2 = this.isEndless ? -1 : Convert.toInt(context, this.end);
        if (beg < 0 && (beg += len) < 0) {
            if (err != 0) {
                throw Error.rangeError(context, String.valueOf(this.begin) + ".." + (this.isExclusive ? "." : "") + String.valueOf(this.end) + " out of range");
            }
            return null;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                if (err != 0) {
                    throw Error.rangeError(context, String.valueOf(this.begin) + ".." + (this.isExclusive ? "." : "") + String.valueOf(this.end) + " out of range");
                }
                return null;
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if (end2 < 0) {
            end2 += len;
        }
        if (!this.isExclusive || this.isEndless) {
            ++end2;
        }
        if ((len = end2 - beg) < 0) {
            len = 0;
        }
        return new int[]{beg, len};
    }

    private void init(ThreadContext context, IRubyObject begin2, IRubyObject end2, boolean isExclusive) {
        IRubyObject result2;
        if (!(begin2 instanceof RubyFixnum && end2 instanceof RubyFixnum || end2.isNil() || begin2.isNil() || !(result2 = Helpers.invokedynamic(context, begin2, MethodNames.OP_CMP, end2)).isNil())) {
            throw Error.argumentError(context, "bad value for range");
        }
        this.begin = begin2;
        this.end = end2;
        this.isExclusive = isExclusive;
        this.isEndless = end2.isNil();
        this.isBeginless = begin2.isNil();
        this.isInited = true;
        if (this.metaClass.getClassIndex() == ClassIndex.RANGE) {
            this.setFrozen(true);
        }
    }

    @JRubyMethod(required=2, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block unusedBlock) {
        Arity.checkArgumentCount(context, args2, 2, 3);
        if (this.isInited) {
            throw context.runtime.newFrozenError("'initialize' called twice", this);
        }
        this.checkFrozen();
        this.init(context, args2[0], args2[1], args2.length > 2 && args2[2].isTrue());
        this.isInited = true;
        return context.nil;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject original) {
        if (this.isInited) {
            throw context.runtime.newFrozenError("'initialize' called twice", this);
        }
        RubyRange other = (RubyRange)original;
        this.begin = other.begin;
        this.end = other.end;
        this.isExclusive = other.isExclusive;
        this.isEndless = other.end.isNil();
        this.isBeginless = other.begin.isNil();
        this.isInited = true;
        return context.nil;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        int exclusiveBit = this.isExclusive ? 1 : 0;
        long hash2 = exclusiveBit;
        hash2 = Helpers.hashStart(context.runtime, hash2);
        hash2 = Helpers.murmurCombine(hash2, Helpers.safeHashLong(context, this.begin));
        hash2 = Helpers.murmurCombine(hash2, Helpers.safeHashLong(context, this.end));
        hash2 = Helpers.murmurCombine(hash2, exclusiveBit << 24);
        hash2 = Helpers.hashEnd(hash2);
        return Convert.asFixnum(context, hash2);
    }

    private static RubyString inspectValue(ThreadContext context, IRubyObject value2) {
        return (RubyString)context.safeRecurse(RubyRange::inspectValueRecursive, value2, value2, "inspect", true);
    }

    private static IRubyObject inspectValueRecursive(ThreadContext context, IRubyObject state2, IRubyObject obj, boolean recur) {
        return recur ? Create.newString(context, ((RubyRange)obj).isExclusive ? "(... ... ...)" : "(... .. ...)") : RubyRange.inspect(context, obj);
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public RubyString inspect(ThreadContext context) {
        RubyString i1 = this.isBeginless && !this.isEndless ? Create.newEmptyString(context) : Create.dupString(context, RubyRange.inspectValue(context, this.begin));
        RubyString i2 = this.isEndless && !this.isBeginless ? Create.newEmptyString(context) : RubyRange.inspectValue(context, this.end);
        i1.cat(DOTDOTDOT, 0, this.isExclusive ? 3 : 2);
        i1.append(i2);
        return i1;
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return this.to_s(context.runtime);
    }

    private RubyString to_s(Ruby runtime2) {
        RubyString i1 = this.begin.asString().strDup(runtime2);
        RubyString i2 = this.end.asString();
        i1.cat(DOTDOTDOT, 0, this.isExclusive ? 3 : 2);
        i1.append(i2);
        return i1;
    }

    @JRubyMethod(name={"exclude_end?"})
    public RubyBoolean exclude_end_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isExclusive);
    }

    @Deprecated(since="10.0.0.0")
    public RubyBoolean exclude_end_p() {
        return this.exclude_end_p(this.getRuntime().getCurrentContext());
    }

    @Override
    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        return this.equalityInner(context, other, MethodNames.EQL);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return this.equalityInner(context, other, MethodNames.OP_EQUAL);
    }

    private IRubyObject equalityInner(ThreadContext context, IRubyObject other, MethodNames equalityCheck) {
        if (this == other) {
            return context.tru;
        }
        if (!(other instanceof RubyRange)) {
            return context.fals;
        }
        RubyRange otherRange = (RubyRange)other;
        return Convert.asBoolean(context, this.isExclusive == otherRange.isExclusive && Helpers.invokedynamic(context, this.begin, equalityCheck, otherRange.begin).isTrue() && Helpers.invokedynamic(context, this.end, equalityCheck, otherRange.end).isTrue());
    }

    private static boolean isZero(ThreadContext context, IRubyObject num) {
        RubyFixnum fix2;
        return num instanceof RubyFixnum && (fix2 = (RubyFixnum)num).isZero(context);
    }

    private static IRubyObject rangeLt(ThreadContext context, IRubyObject a, IRubyObject b2) {
        return RubyRange.rangeLess(context, a, b2) < 0 ? context.tru : null;
    }

    private static int rangeLess(ThreadContext context, IRubyObject a, IRubyObject b2) {
        IRubyObject result2 = RubyRange.sites((ThreadContext)context).op_cmp.call(context, a, a, b2);
        if (result2.isNil()) {
            return Integer.MAX_VALUE;
        }
        return RubyComparable.cmpint(context, result2, a, b2);
    }

    private static IRubyObject rangeLe(ThreadContext context, IRubyObject a, IRubyObject b2) {
        IRubyObject result2 = Helpers.invokedynamic(context, a, MethodNames.OP_CMP, b2);
        if (result2.isNil()) {
            return null;
        }
        int c = RubyComparable.cmpint(context, result2, a, b2);
        if (c == 0) {
            return RubyFixnum.zero(context.runtime);
        }
        return c < 0 ? context.tru : null;
    }

    private void rangeEach(ThreadContext context, RangeCallBack callback) {
        IRubyObject v = this.begin;
        if (this.isExclusive) {
            while (RubyRange.rangeLt(context, v, this.end) != null) {
                callback.doCall(context, v);
                v = v.callMethod(context, "succ");
                context.pollThreadEvents();
            }
        } else {
            IRubyObject c;
            while ((c = RubyRange.rangeLe(context, v, this.end)) != null && c.isTrue()) {
                callback.doCall(context, v);
                if (!RubyRange.isZero(context, c)) {
                    v = v.callMethod(context, "succ");
                    context.pollThreadEvents();
                    continue;
                }
                break;
            }
        }
    }

    private boolean coverRangeP(ThreadContext context, IRubyObject val) {
        if (this.begin.isNil() || RubyRange.rangeLess(context, this.begin, val) <= 0) {
            int excl;
            int n = excl = this.isExclusive ? 1 : 0;
            if (this.end.isNil() || RubyRange.rangeLess(context, val, this.end) <= -excl) {
                return true;
            }
        }
        return false;
    }

    private boolean coverRange(ThreadContext context, RubyRange val) {
        int cmp2;
        boolean valExcl;
        IRubyObject valBeg = val.begin;
        IRubyObject valEnd = val.end;
        boolean excl = this.isExclusive;
        boolean bl = valExcl = val.isExclusive;
        if (!this.end.isNil() && valEnd.isNil()) {
            return false;
        }
        if (!this.begin.isNil() && valBeg.isNil()) {
            return false;
        }
        if (!valBeg.isNil() && !valEnd.isNil() && RubyRange.rangeLess(context, valBeg, valEnd) > (val.isExclusive ? -1 : 0)) {
            return false;
        }
        if (!valBeg.isNil() && !this.coverRangeP(context, valBeg)) {
            return false;
        }
        if (!valEnd.isNil() && !this.end.isNil()) {
            IRubyObject rCmpEnd = RubyRange.sites((ThreadContext)context).op_cmp.call(context, this.end, this.end, valEnd);
            if (rCmpEnd.isNil()) {
                return false;
            }
            cmp2 = RubyComparable.cmpint(context, RubyRange.sites((ThreadContext)context).op_gt, RubyRange.sites((ThreadContext)context).op_lt, rCmpEnd, this.end, valEnd);
        } else {
            cmp2 = RubyRange.rangeLess(context, this.end, valEnd);
        }
        if (excl == valExcl) {
            return cmp2 >= 0;
        }
        if (excl) {
            return cmp2 > 0;
        }
        if (cmp2 >= 0) {
            return true;
        }
        IRubyObject nil = context.nil;
        IRubyObject valMax = API.rescueTypeError(context, nil, () -> RubyRange.sites((ThreadContext)context).max.call(context, this, val));
        if (valMax == nil) {
            return false;
        }
        cmp2 = RubyRange.rangeLess(context, this.end, valMax);
        return cmp2 >= 0 && cmp2 != Integer.MAX_VALUE;
    }

    @JRubyMethod
    public IRubyObject to_a(ThreadContext context, Block block) {
        if (this.isEndless) {
            throw Error.rangeError(context, "cannot convert endless range to an array");
        }
        return RubyEnumerable.to_a(context, this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @JRubyMethod(name={"each"})
    public IRubyObject each(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "each", RubyRange::size);
        }
        IRubyObject iRubyObject = this.begin;
        if (iRubyObject instanceof RubyFixnum) {
            RubyFixnum begFixnum = (RubyFixnum)iRubyObject;
            if (this.isEndless) {
                begFixnum.step(context, IRubyObject.NULL_ARRAY, block);
                return this;
            }
        }
        if (this.begin instanceof RubyFixnum && this.end instanceof RubyFixnum) {
            this.fixnumEach(context, block);
            return this;
        }
        if (this.begin instanceof RubySymbol && this.end instanceof RubySymbol) {
            this.begin.asString().uptoCommon(context, this.end.asString(), this.isExclusive, block, true);
            return this;
        }
        IRubyObject tmp = this.begin.checkStringType();
        if (!tmp.isNil()) {
            if (this.isEndless) {
                ((RubyString)tmp).uptoEndless(context, block);
                return this;
            }
            ((RubyString)tmp).uptoCommon(context, this.end, this.isExclusive, block);
            return this;
        }
        if (!RubyRange.discreteObject(context, this.begin)) {
            throw Error.typeError(context, "can't iterate from ", this.begin, "");
        }
        if (!this.end.isNil()) {
            this.rangeEach(context, (ctx, arg2) -> block.yield(ctx, arg2));
            return this;
        }
        IRubyObject beg = this.begin;
        while (true) {
            block.yield(context, beg);
            context.pollThreadEvents();
            beg = beg.callMethod(context, "succ");
        }
    }

    private void fixnumEach(ThreadContext context, Block block) {
        long to = ((RubyFixnum)this.end).getValue();
        if (this.isExclusive) {
            if (to == Long.MIN_VALUE) {
                return;
            }
            --to;
        }
        RubyInteger.fixnumUpto(context, ((RubyFixnum)this.begin).getValue(), to, block);
    }

    @JRubyMethod
    public IRubyObject reverse_each(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "reverse_each", RubyRange::reverseSize);
        }
        IRubyObject beg = this.begin;
        IRubyObject end2 = this.end;
        boolean excl = this.isExclusive;
        if (end2.isNil()) {
            throw Error.typeError(context, "can't iterate from ", end2, "");
        }
        if (beg instanceof RubyFixnum && end2 instanceof RubyFixnum) {
            RubyFixnum endFixnum = (RubyFixnum)end2;
            if (excl) {
                if (endFixnum.getValue() == Long.MIN_VALUE) {
                    return this;
                }
                end2 = endFixnum.op_minus(context, 1L);
            }
            this.reverseEachFixnum(context, beg, (RubyInteger)end2, block);
        } else if ((beg.isNil() || beg instanceof RubyInteger) && end2 instanceof RubyInteger) {
            RubyInteger endInteger = (RubyInteger)end2;
            if (excl) {
                endInteger = (RubyInteger)endInteger.op_minus(context, 1L);
            }
            this.reverseEachPositiveBignum(context, beg, endInteger, block);
            this.reverseEachFixnum(context, beg, endInteger, block);
            this.reverseEachNegativeBignum(context, beg, endInteger, block);
        } else {
            return RubyEnumerable.reverse_each(context, this, block);
        }
        return this;
    }

    private void reverseEachFixnum(ThreadContext context, IRubyObject beg, RubyInteger end2, Block block) {
        if (beg.isNil()) {
            beg = Convert.asFixnum(context, Long.MIN_VALUE);
        }
        this.reverseEachFixnum(context, (RubyInteger)beg, end2, block);
    }

    private void reverseEachFixnum(ThreadContext context, RubyInteger beg, RubyInteger end2, Block block) {
        long e;
        assert (!end2.isNil());
        if (!(beg instanceof RubyFixnum)) {
            if (!beg.isNil() && RubyRange.bignumPositive(context, beg)) {
                return;
            }
            beg = Convert.asFixnum(context, Long.MIN_VALUE);
        }
        if (!(end2 instanceof RubyFixnum)) {
            if (RubyRange.bignumNegative(context, end2)) {
                return;
            }
            end2 = Convert.asFixnum(context, Long.MAX_VALUE);
        }
        long b2 = ((RubyFixnum)beg).getValue();
        for (long i2 = e = ((RubyFixnum)end2).getValue(); i2 >= b2; --i2) {
            block.yieldSpecific(context, Convert.asFixnum(context, i2));
            if (i2 == b2) break;
        }
    }

    private void reverseEachPositiveBignum(ThreadContext context, IRubyObject beg, RubyInteger end2, Block block) {
        assert (!end2.isNil());
        if (end2 instanceof RubyFixnum || RubyRange.bignumNegative(context, end2)) {
            return;
        }
        if (beg.isNil() || beg instanceof RubyFixnum || RubyRange.bignumNegative(context, beg)) {
            beg = RubyBignum.newBignum(context.runtime, RubyBignum.LONG_MAX_PLUS_ONE);
        }
        this.reverseEachBignum(context, (RubyInteger)beg, end2, block);
    }

    private void reverseEachNegativeBignum(ThreadContext context, IRubyObject beg, RubyInteger end2, Block block) {
        assert (!end2.isNil());
        if (end2 instanceof RubyFixnum || RubyRange.bignumPositive(context, end2)) {
            end2 = RubyBignum.newBignum(context.runtime, RubyBignum.LONG_MIN_MINUS_ONE);
        }
        if (beg.isNil()) {
            this.reverseEachBignumBeginless(context, end2, block);
        }
        if (beg instanceof RubyFixnum || RubyRange.bignumPositive(context, beg)) {
            return;
        }
        this.reverseEachBignum(context, (RubyInteger)beg, end2, block);
    }

    private void reverseEachBignum(ThreadContext context, RubyInteger beg, RubyInteger end2, Block block) {
        IRubyObject c;
        assert (RubyRange.bignumPositive(context, beg) == RubyRange.bignumPositive(context, end2));
        RubyFixnum one = Convert.asFixnum(context, 1);
        RubyFixnum zero = Convert.asFixnum(context, 0);
        while (!(c = beg.op_cmp(context, end2)).equals(one)) {
            block.yieldSpecific(context, end2);
            if (c == zero) break;
            end2 = (RubyInteger)end2.op_minus(context, one);
        }
    }

    private void reverseEachBignumBeginless(ThreadContext context, RubyInteger end2, Block block) {
        assert (RubyRange.bignumNegative(context, end2));
        while (true) {
            block.yieldSpecific(context, end2);
            end2 = (RubyInteger)end2.op_minus(context, 1L);
        }
    }

    private static boolean bignumNegative(ThreadContext context, IRubyObject end2) {
        assert (end2 instanceof RubyBignum);
        RubyBignum bigEnd = (RubyBignum)end2;
        return bigEnd.signum(context) == -1;
    }

    private static boolean bignumPositive(ThreadContext context, IRubyObject num) {
        assert (num instanceof RubyBignum);
        RubyBignum bigNum = (RubyBignum)num;
        return bigNum.signum(context) == 1;
    }

    @JRubyMethod(name={"step"})
    public IRubyObject step(ThreadContext context, Block block) {
        return this.stepCommon(context, UNDEF, block);
    }

    @JRubyMethod(name={"step"})
    public IRubyObject step(ThreadContext context, IRubyObject step2, Block block) {
        return this.stepCommon(context, step2, block);
    }

    private IRubyObject stepEnumeratorize(ThreadContext context, IRubyObject stepArg, IRubyObject step2, String method2) {
        IRubyObject[] argc = stepArg == UNDEF ? IRubyObject.NULL_ARRAY : new IRubyObject[]{stepArg};
        if (step2 instanceof RubyNumeric && this.begin instanceof RubyNumeric && (this.end.isNil() || this.end instanceof RubyNumeric) || this.begin.isNil() && this.end instanceof RubyNumeric) {
            return RubyArithmeticSequence.newArithmeticSequence(context, this, method2, argc, this.begin, this.end, step2, this.isExclusive ? context.tru : context.fals);
        }
        if (this.begin.isNil()) {
            throw Error.argumentError(context, "#step for non-numeric beginless ranges is meaningless");
        }
        return RubyEnumerator.enumeratorize(context.runtime, (IRubyObject)this, method2, argc);
    }

    @JRubyMethod(name={"%"})
    public IRubyObject op_mod(ThreadContext context, IRubyObject step2) {
        return this.stepEnumeratorize(context, step2, step2, "%");
    }

    private IRubyObject stepCommon(ThreadContext context, IRubyObject stepArg, Block block) {
        block22: {
            int dir;
            boolean excl;
            IRubyObject v;
            IRubyObject step2;
            IRubyObject e;
            IRubyObject b2;
            block28: {
                block27: {
                    boolean stepIsNumeric;
                    boolean beginIsNumeric;
                    block26: {
                        IRubyObject symBegin;
                        block25: {
                            IRubyObject strBegin;
                            block24: {
                                block23: {
                                    b2 = this.begin;
                                    e = this.end;
                                    beginIsNumeric = b2 instanceof RubyNumeric;
                                    boolean endIsNumeric = e instanceof RubyNumeric;
                                    strBegin = b2.checkStringType();
                                    if (b2 instanceof RubySymbol) {
                                        RubySymbol symbol = (RubySymbol)b2;
                                        v0 = symbol.to_s(context);
                                    } else {
                                        v0 = symBegin = context.nil;
                                    }
                                    if (stepArg != UNDEF) {
                                        step2 = stepArg;
                                    } else if (beginIsNumeric || !strBegin.isNil() || !symBegin.isNil() || b2.isNil() && endIsNumeric) {
                                        step2 = Convert.asFixnum(context, 1);
                                    } else {
                                        throw Error.argumentError(context, "step is required for non-numeric ranges");
                                    }
                                    stepIsNumeric = step2 instanceof RubyNumeric;
                                    if (stepIsNumeric && beginIsNumeric && step2.op_eqq(context, Convert.asFixnum(context, 0)).isTrue()) {
                                        throw Error.argumentError(context, "step can't be 0");
                                    }
                                    if (!block.isGiven()) {
                                        return this.stepEnumeratorize(context, stepArg, step2, "step");
                                    }
                                    if (b2.isNil()) {
                                        throw Error.argumentError(context, "#step iteration for beginless ranges is meaningless");
                                    }
                                    v = b2;
                                    if (!(b2 instanceof RubyFixnum) || !e.isNil() || !(step2 instanceof RubyFixnum)) break block23;
                                    this.fixnumEndlessStep(context, step2, block);
                                    break block22;
                                }
                                if (!(b2 instanceof RubyFixnum)) break block24;
                                RubyFixnum bb = (RubyFixnum)b2;
                                if (!(e instanceof RubyFixnum)) break block24;
                                RubyFixnum ee = (RubyFixnum)e;
                                if (!(step2 instanceof RubyFixnum)) break block24;
                                RubyFixnum ss = (RubyFixnum)step2;
                                this.fixnumStep(context, bb, ee, ss, block);
                                break block22;
                            }
                            excl = this.isExclusive;
                            if (beginIsNumeric && stepIsNumeric && RubyNumeric.floatStep(context, b2, e, step2, excl, this.isEndless, block)) break block22;
                            if (strBegin.isNil() || !(step2 instanceof RubyFixnum)) break block25;
                            this.stringStep(context, step2, block, (RubyString)strBegin);
                            break block22;
                        }
                        if (symBegin.isNil() || !(step2 instanceof RubyFixnum)) break block26;
                        this.symbolStep(context, step2, block, (RubyString)symBegin);
                        break block22;
                    }
                    if (e.isNil()) {
                        while (true) {
                            block.yield(context, v);
                            v = v.callMethod(context, "+", step2);
                        }
                    }
                    if (!beginIsNumeric || !stepIsNumeric || RubyRange.rangeLess(context, step2, Convert.asFixnum(context, 0)) >= 0) break block27;
                    if (excl) {
                        while (RubyRange.rangeLess(context, e, v) < 0) {
                            block.yield(context, v);
                            v = v.callMethod(context, "+", step2);
                        }
                    } else {
                        int c;
                        while ((c = RubyRange.rangeLess(context, e, v)) <= 0) {
                            block.yield(context, v);
                            if (c != 0) {
                                v = v.callMethod(context, "+", step2);
                                continue;
                            }
                            break block22;
                        }
                    }
                    break block22;
                }
                dir = RubyRange.rangeLess(context, b2, e);
                if (dir != 0) break block28;
                if (excl) break block22;
                block.yield(context, v);
                break block22;
            }
            if (RubyRange.rangeLess(context, b2, b2.callMethod(context, "+", step2)) == dir) {
                if (excl) {
                    while (RubyRange.rangeLess(context, v, e) == dir) {
                        block.yield(context, v);
                        v = v.callMethod(context, "+", step2);
                    }
                } else {
                    int c;
                    while ((c = RubyRange.rangeLess(context, v, e)) == dir || c == 0) {
                        block.yield(context, v);
                        if (c != 0) {
                            v = v.callMethod(context, "+", step2);
                            continue;
                        }
                        break;
                    }
                }
            }
        }
        return this;
    }

    private void fixnumEndlessStep(ThreadContext context, IRubyObject step2, Block block) {
        long i2;
        long unit = Convert.toLong(context, step2);
        for (i2 = Convert.toLong(context, this.begin); i2 <= Long.MAX_VALUE - unit; i2 += unit) {
            block.yield(context, Convert.asFixnum(context, i2));
        }
        IRubyObject b2 = Convert.asFixnum(context, i2);
        while (true) {
            block.yield(context, b2);
            b2 = ((RubyInteger)b2).op_plus(context, step2);
        }
    }

    private void fixnumStep(ThreadContext context, RubyFixnum b2, RubyFixnum e, RubyFixnum s2, Block block) {
        long end2 = e.getValue();
        long unit = s2.getValue();
        long shortEnd = end2 - unit;
        if (unit < 0L) {
            long i2 = b2.getValue();
            if (i2 > end2) {
                block.yield(context, Convert.asFixnum(context, i2));
            }
            while (i2 > shortEnd) {
                block.yield(context, Convert.asFixnum(context, i2 += unit));
            }
            if (!this.isExclusive && i2 == shortEnd) {
                block.yield(context, Convert.asFixnum(context, i2 + unit));
            }
        } else {
            long i3 = b2.getValue();
            if (i3 < end2) {
                block.yield(context, Convert.asFixnum(context, i3));
            }
            while (i3 < shortEnd) {
                block.yield(context, Convert.asFixnum(context, i3 += unit));
            }
            if (!this.isExclusive && i3 == shortEnd) {
                block.yield(context, Convert.asFixnum(context, i3 + unit));
            }
        }
    }

    private void stringStep(ThreadContext context, IRubyObject step2, Block block, RubyString strBegin) {
        StepBlockCallBack callback = new StepBlockCallBack(block, RubyFixnum.one(context.runtime), step2);
        Block blockCallback = CallBlock.newCallClosure(context, this, Signature.ONE_ARGUMENT, callback);
        if (this.end.isNil()) {
            strBegin.uptoEndless(context, blockCallback);
        } else {
            strBegin.uptoCommon(context, this.end, this.isExclusive, blockCallback);
        }
    }

    private void symbolStep(ThreadContext context, IRubyObject step2, Block block, RubyString symBegin) {
        SymbolStepBlockCallBack callback = new SymbolStepBlockCallBack(block, RubyFixnum.one(context.runtime), step2);
        Block blockCallback = CallBlock.newCallClosure(context, this, Signature.ONE_ARGUMENT, callback);
        if (this.end.isNil()) {
            symBegin.uptoEndless(context, blockCallback);
        } else {
            symBegin.uptoCommon(context, this.end.asString(), this.isExclusive, blockCallback);
        }
    }

    private static IRubyObject size(ThreadContext ctx, RubyRange recv2, IRubyObject[] args2) {
        return recv2.size(ctx);
    }

    private static IRubyObject reverseSize(ThreadContext context, RubyRange recv2, IRubyObject[] args2) {
        IRubyObject b2;
        IRubyObject e = recv2.end;
        if (e.isNil()) {
            RubyRange.cantIterateFrom(context, e);
        }
        if ((b2 = recv2.begin) instanceof RubyInteger) {
            if (e instanceof RubyNumeric) {
                return RubyNumeric.intervalStepSize(context, b2, e, Convert.asFixnum(context, 1), recv2.isExclusive);
            }
            RubyRange.cantIterateFrom(context, e);
        }
        if (b2.isNil()) {
            if (e instanceof RubyInteger) {
                return Convert.asFloat(context, Double.POSITIVE_INFINITY);
            }
            RubyRange.cantIterateFrom(context, e);
        }
        if (!RubyRange.discreteObject(context, b2)) {
            RubyRange.cantIterateFrom(context, e);
        }
        return context.nil;
    }

    private static void cantIterateFrom(ThreadContext context, IRubyObject e) {
        throw Error.typeError(context, "can't iterate from " + String.valueOf(e));
    }

    private static IRubyObject stepSize(ThreadContext context, RubyRange self2, IRubyObject[] args2) {
        RubyFixnum zero;
        IRubyObject step2;
        IRubyObject begin2 = self2.begin;
        IRubyObject end2 = self2.end;
        if (args2 != null && args2.length > 0) {
            step2 = args2[0];
            if (!(step2 instanceof RubyNumeric)) {
                step2 = step2.convertToInteger();
            }
        } else {
            step2 = Convert.asFixnum(context, 1);
        }
        if (step2.callMethod(context, "<", zero = Convert.asFixnum(context, 0)).isTrue()) {
            throw Error.argumentError(context, "step can't be negative");
        }
        if (!step2.callMethod(context, ">", zero).isTrue()) {
            throw Error.argumentError(context, "step can't be 0");
        }
        if (begin2 instanceof RubyNumeric && end2 instanceof RubyNumeric) {
            return RubyNumeric.intervalStepSize(context, begin2, end2, step2, self2.isExclusive);
        }
        return context.nil;
    }

    @JRubyMethod(name={"include?", "member?"}, frame=true)
    public IRubyObject include_p(ThreadContext context, IRubyObject obj) {
        IRubyObject result2 = this.includeCommon(context, obj, false);
        if (result2 != UNDEF) {
            return result2;
        }
        return Helpers.invokeSuper(context, (IRubyObject)this, obj, Block.NULL_BLOCK);
    }

    private IRubyObject includeCommon(ThreadContext context, IRubyObject val, boolean useStringCover) {
        Ruby runtime2 = context.runtime;
        boolean iterable = this.begin instanceof RubyFixnum || this.end instanceof RubyFixnum || RubyRange.linearObject(context, this.begin) || RubyRange.linearObject(context, this.end);
        JavaSites.RangeSites sites = RubyRange.sites(context);
        JavaSites.CheckedSites to_int_checked = sites.to_int_checked;
        if (iterable || this.rangeIntegerEdge(context, runtime2.getInteger(), to_int_checked)) {
            return Convert.asBoolean(context, this.rangeIncludes(context, val));
        }
        if (this.rangeString()) {
            return RubyString.includeRange(context, (RubyString)this.begin, (RubyString)this.end, val, this.isExclusive);
        }
        return this.rangeIncludeFallback(context, val);
    }

    private IRubyObject rangeIncludeFallback(ThreadContext context, IRubyObject val) {
        boolean beginless = this.begin.isNil();
        boolean endless = this.end.isNil();
        if (beginless && endless && RubyRange.linearObject(context, val)) {
            return context.tru;
        }
        if (beginless || endless) {
            throw Error.typeError(context, "cannot determine inclusion in beginless/endless ranges");
        }
        return UNDEF;
    }

    private boolean rangeString() {
        return this.begin instanceof RubyString && this.end instanceof RubyString;
    }

    private boolean rangeIntegerEdge(ThreadContext context, RubyClass Integer2, JavaSites.CheckedSites to_int_checked) {
        return !TypeConverter.convertToTypeWithCheck(context, this.begin, Integer2, to_int_checked).isNil() || !TypeConverter.convertToTypeWithCheck(context, this.end, Integer2, to_int_checked).isNil();
    }

    private static boolean discreteObject(ThreadContext context, IRubyObject obj) {
        return RubyRange.sites((ThreadContext)context).respond_to_succ.respondsTo(context, obj, obj, false);
    }

    private static boolean linearObject(ThreadContext context, IRubyObject obj) {
        if (obj instanceof RubyFixnum || obj instanceof RubyFloat) {
            return true;
        }
        if (obj instanceof RubyBignum) {
            return true;
        }
        if (obj instanceof RubyNumeric) {
            return true;
        }
        return obj instanceof RubyTime;
    }

    @JRubyMethod(name={"==="})
    public IRubyObject eqq_p(ThreadContext context, IRubyObject obj) {
        return Convert.asBoolean(context, this.coverRangeP(context, obj));
    }

    @JRubyMethod(name={"cover?"})
    public RubyBoolean cover_p(ThreadContext context, IRubyObject obj) {
        boolean bl;
        if (obj instanceof RubyRange) {
            RubyRange range = (RubyRange)obj;
            bl = this.coverRange(context, range);
        } else {
            bl = this.coverRangeP(context, obj);
        }
        return Convert.asBoolean(context, bl);
    }

    private boolean rangeIncludes(ThreadContext context, IRubyObject val) {
        if (this.isBeginless || RubyRange.rangeLess(context, this.begin, val) <= 0) {
            int excl;
            int n = excl = this.isExclusive ? 1 : 0;
            if (this.isEndless || RubyRange.rangeLess(context, val, this.end) <= -excl) {
                return true;
            }
        }
        return false;
    }

    @JRubyMethod(frame=true)
    public IRubyObject min(ThreadContext context, Block block) {
        return this.min(context, null, block);
    }

    @JRubyMethod(frame=true)
    public IRubyObject min(ThreadContext context, IRubyObject arg2, Block block) {
        if (this.begin.isNil()) {
            throw Error.rangeError(context, "cannot get the minimum of beginless range");
        }
        if (block.isGiven()) {
            if (this.end.isNil()) {
                throw Error.rangeError(context, "cannot get the minimum of endless range with custom comparison method");
            }
            return arg2 != null ? Helpers.invokeSuper(context, (IRubyObject)this, arg2, block) : Helpers.invokeSuper(context, this, block);
        }
        if (arg2 != null) {
            return this.first(context, arg2);
        }
        int cmp2 = this.isEndless ? -1 : RubyComparable.cmpint(context, Helpers.invokedynamic(context, this.begin, MethodNames.OP_CMP, this.end), this.begin, this.end);
        return cmp2 > 0 || cmp2 == 0 && this.isExclusive ? context.nil : this.begin;
    }

    @JRubyMethod(frame=true)
    public IRubyObject max(ThreadContext context, Block block) {
        int cmp2;
        if (this.isEndless) {
            throw Error.rangeError(context, "cannot get the maximum of endless range");
        }
        if (block.isGiven() || this.isExclusive && !(this.end instanceof RubyNumeric)) {
            if (this.isBeginless) {
                throw Error.rangeError(context, "cannot get the maximum of beginless range with custom comparison method");
            }
            return Helpers.invokeSuper(context, this, block);
        }
        int n = cmp2 = this.isBeginless ? -1 : RubyComparable.cmpint(context, Helpers.invokedynamic(context, this.begin, MethodNames.OP_CMP, this.end), this.begin, this.end);
        if (cmp2 > 0) {
            return context.nil;
        }
        if (this.isExclusive) {
            IRubyObject iRubyObject;
            if (!(this.end instanceof RubyInteger)) {
                throw Error.typeError(context, "cannot exclude non Integer end value");
            }
            if (cmp2 == 0) {
                return context.nil;
            }
            if (!(this.begin instanceof RubyInteger)) {
                throw Error.typeError(context, "cannot exclude end value with non Integer begin value");
            }
            IRubyObject iRubyObject2 = this.end;
            if (iRubyObject2 instanceof RubyFixnum) {
                RubyFixnum fixnum = (RubyFixnum)iRubyObject2;
                iRubyObject = Convert.asFixnum(context, fixnum.getValue() - 1L);
            } else {
                iRubyObject = this.end.callMethod(context, "-", RubyFixnum.one(context.runtime));
            }
            return iRubyObject;
        }
        return this.end;
    }

    @JRubyMethod(frame=true)
    public IRubyObject max(ThreadContext context, IRubyObject arg2, Block block) {
        if (this.isEndless) {
            throw Error.rangeError(context, "cannot get the maximum element of endless range");
        }
        return Helpers.invokeSuper(context, (IRubyObject)this, arg2, block);
    }

    @JRubyMethod
    public IRubyObject first(ThreadContext context) {
        return this.first(context, null);
    }

    @JRubyMethod
    @JRubyAPI
    public IRubyObject begin(ThreadContext context) {
        return this.begin;
    }

    @JRubyMethod
    public IRubyObject first(final ThreadContext context, IRubyObject arg2) {
        if (this.isBeginless) {
            throw Error.rangeError(context, "cannot get the first element of beginless range");
        }
        if (arg2 == null) {
            return this.begin;
        }
        final int num = Convert.toInt(context, arg2);
        if (num < 0) {
            throw Error.argumentError(context, "negative array size (or size too big)");
        }
        final RubyArray<?> result2 = Create.allocArray(context, num);
        try {
            RubyEnumerable.callEach(context, RubyRange.sites((ThreadContext)context).each, this, Signature.ONE_ARGUMENT, new BlockCallback(){
                int n;
                {
                    this.n = num;
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    return this.call(ctx, largs[0], blk);
                }

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject larg, Block blk) {
                    if (this.n-- <= 0) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result2.append(context, larg);
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod
    public IRubyObject count(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            IRubyObject size2;
            if (this.isBeginless || this.isEndless) {
                return Convert.asFloat(context, Double.POSITIVE_INFINITY);
            }
            if (this.begin instanceof RubyInteger && !(size2 = this.size(context)).isNil()) {
                return size2;
            }
        }
        return RubyEnumerable.count(context, this, block);
    }

    @JRubyMethod
    public IRubyObject count(ThreadContext context, IRubyObject arg2, Block block) {
        return RubyEnumerable.count(context, this, arg2, block);
    }

    @JRubyMethod
    public IRubyObject minmax(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return Helpers.invokeSuper(context, (IRubyObject)this, (RubyModule)context.runtime.getRange(), "minmax", NULL_ARRAY, block);
        }
        return Create.newArray(context, this.callMethod("min"), this.callMethod("max"));
    }

    @JRubyMethod
    public IRubyObject last(ThreadContext context) {
        if (this.isEndless) {
            throw Error.rangeError(context, "cannot get the last element of endless range");
        }
        return this.end;
    }

    @JRubyMethod
    @JRubyAPI
    public IRubyObject end(ThreadContext context) {
        return this.end;
    }

    @JRubyMethod
    public IRubyObject last(ThreadContext context, IRubyObject arg2) {
        if (this.isEndless) {
            throw Error.rangeError(context, "cannot get the last element of endless range");
        }
        if (this.begin instanceof RubyInteger && this.end instanceof RubyInteger && this.getMetaClass().checkMethodBasicDefinition("each")) {
            return this.intRangeLast(context, arg2);
        }
        return ((RubyArray)RubyKernel.new_array(context, this, this)).last(context, arg2);
    }

    private RubyArray intRangeLast(ThreadContext context, IRubyObject arg2) {
        RubyInteger len;
        RubyFixnum one = Convert.asFixnum(context, 1);
        RubyInteger e = (RubyInteger)this.end;
        RubyInteger len1 = (RubyInteger)e.op_minus(context, this.begin);
        if (this.isExclusive) {
            e = (RubyInteger)e.op_minus(context, one);
            len = len1;
        } else {
            len = (RubyInteger)len1.op_plus(context, one);
        }
        if (len.isZero(context) || Numeric.f_negative_p(context, len)) {
            return Create.newEmptyArray(context);
        }
        long n = Convert.toLong(context, arg2);
        if (n < 0L) {
            throw Error.argumentError(context, "negative array size");
        }
        RubyInteger nv = Convert.asFixnum(context, n);
        if (Numeric.f_gt_p(context, nv, len)) {
            nv = len;
            n = Convert.toLong(context, nv);
        }
        RubyArray<?> array2 = Create.allocArray(context, n);
        RubyInteger b2 = (RubyInteger)e.op_minus(context, nv);
        while (n > 0L) {
            b2 = (RubyInteger)b2.op_plus(context, one);
            array2.append(context, b2);
            --n;
        }
        return array2;
    }

    @JRubyMethod
    public IRubyObject size(ThreadContext context) {
        if (this.begin instanceof RubyInteger) {
            if (this.end instanceof RubyNumeric) {
                return RubyNumeric.intervalStepSize(context, this.begin, this.end, RubyFixnum.one(context.runtime), this.isExclusive);
            }
            if (this.end.isNil()) {
                return Convert.asFloat(context, Double.POSITIVE_INFINITY);
            }
        }
        if (!this.discreteObject(this.begin)) {
            throw Error.typeError(context, RubyStringBuilder.str(context.runtime, "can't iterate from ", RubyStringBuilder.types(context, (RubyModule)this.begin.getMetaClass())));
        }
        return context.nil;
    }

    private boolean discreteObject(IRubyObject object) {
        return object.respondsTo("succ");
    }

    public final boolean isExcludeEnd() {
        return this.isExclusive;
    }

    public static RubyRange rangeFromRangeLike(ThreadContext context, IRubyObject rangeLike, CallSite beginSite, CallSite endSite, CallSite excludeEndSite) {
        IRubyObject begin2 = beginSite.call(context, rangeLike, rangeLike);
        IRubyObject end2 = endSite.call(context, rangeLike, rangeLike);
        IRubyObject excl = excludeEndSite.call(context, rangeLike, rangeLike);
        return RubyRange.newRange(context, begin2, end2, excl.isTrue());
    }

    public static boolean isRangeLike(ThreadContext context, IRubyObject obj, RespondToCallSite respond_to_begin, RespondToCallSite respond_to_end) {
        return respond_to_begin.respondsTo(context, obj, obj) && respond_to_end.respondsTo(context, obj, obj);
    }

    public static boolean isRangeLike(ThreadContext context, IRubyObject obj, JavaSites.CheckedSites begin_checked, JavaSites.CheckedSites end_checked, JavaSites.CheckedSites exclude_end_checked) {
        if (obj instanceof RubyArithmeticSequence) {
            return false;
        }
        return obj.checkCallMethod(context, begin_checked) != null && obj.checkCallMethod(context, end_checked) != null && obj.checkCallMethod(context, exclude_end_checked) != null;
    }

    public static IRubyObject rangeBeginLength(ThreadContext context, IRubyObject range, int len, int[] begLen, int err) {
        JavaSites.RangeSites sites = RubyRange.sites(context);
        if (!RubyRange.isRangeLike(context, range, sites.respond_to_begin, sites.respond_to_end)) {
            return context.fals;
        }
        IRubyObject _beg = sites.begin.call(context, range, range);
        IRubyObject _end = sites.end.call(context, range, range);
        boolean excludeEnd = sites.exclude_end.call(context, range, range).isTrue();
        int beg = _beg.isNil() ? 0 : Convert.toInt(context, _beg);
        int end2 = _end.isNil() ? -1 : Convert.toInt(context, _end);
        int origBeg = beg;
        int origEnd = end2;
        if (beg < 0 && (beg += len) < 0) {
            return RubyRange.rangeBeginLengthError(context, origBeg, origEnd, excludeEnd, err);
        }
        if (end2 < 0) {
            end2 += len;
        }
        if (!excludeEnd) {
            ++end2;
        }
        if (err == 0 || err == 2) {
            if (beg > len) {
                return RubyRange.rangeBeginLengthError(context, origBeg, origEnd, excludeEnd, err);
            }
            if (end2 > len) {
                end2 = len;
            }
        }
        if ((len = end2 - beg) < 0) {
            len = 0;
        }
        begLen[0] = beg;
        begLen[1] = len;
        return context.tru;
    }

    private static IRubyObject rangeBeginLengthError(ThreadContext context, int beg, int end2, boolean excludeEnd, int err) {
        if (err != 0) {
            throw Error.rangeError(context, beg + ".." + (excludeEnd ? "." : "") + end2 + " out of range");
        }
        return context.nil;
    }

    public static RangeLike rangeValues(ThreadContext context, IRubyObject range) {
        if (range instanceof RubyRange) {
            RubyRange vrange = (RubyRange)range;
            return new RangeLike(vrange.begin(context), vrange.end(context), vrange.isExcludeEnd());
        }
        if (range instanceof RubyArithmeticSequence) {
            return null;
        }
        if (range.respondsTo("begin") && range.respondsTo("end") && range.respondsTo("exclude_end?")) {
            return new RangeLike(Helpers.invoke(context, range, "begin"), Helpers.invoke(context, range, "end"), Helpers.invoke(context, range, "exclude_end?").isTrue());
        }
        return null;
    }

    private static JavaSites.RangeSites sites(ThreadContext context) {
        return context.sites.Range;
    }

    public static class BSearch {
        @JRubyMethod(meta=true)
        public static IRubyObject double_to_long_bits(ThreadContext context, IRubyObject bsearch2, IRubyObject flote) {
            return Convert.asFixnum(context, Double.doubleToLongBits(((RubyNumeric)flote).asDouble(context)));
        }

        @JRubyMethod(meta=true)
        public static IRubyObject long_bits_to_double(ThreadContext context, IRubyObject bsearch2, IRubyObject fixnum) {
            return Convert.asFloat(context, Double.longBitsToDouble(((RubyFixnum)fixnum).getValue()));
        }

        @JRubyMethod(meta=true)
        public static IRubyObject abs(ThreadContext context, IRubyObject bsearch2, IRubyObject flote) {
            return Convert.asFloat(context, Math.abs(((RubyFloat)flote).asDouble(context)));
        }
    }

    private static interface RangeCallBack {
        public void doCall(ThreadContext var1, IRubyObject var2);
    }

    private static class StepBlockCallBack
    implements RangeCallBack,
    BlockCallback {
        final Block block;
        IRubyObject iter;
        final IRubyObject step;
        transient RubyFixnum one;

        StepBlockCallBack(Block block, RubyFixnum iter, IRubyObject step2) {
            this.block = block;
            this.iter = iter;
            this.step = step2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block originalBlock) {
            this.doCall(context, args2[0]);
            return context.nil;
        }

        @Override
        public void doCall(ThreadContext context, IRubyObject arg2) {
            IRubyObject iRubyObject = this.iter;
            if (iRubyObject instanceof RubyFixnum) {
                RubyFixnum iterFixnum = (RubyFixnum)iRubyObject;
                this.iter = Convert.asFixnum(context, iterFixnum.getValue() - 1L);
            } else {
                iRubyObject = this.iter;
                if (iRubyObject instanceof RubyInteger) {
                    RubyInteger iterInteger = (RubyInteger)iRubyObject;
                    this.iter = iterInteger.op_minus(context, 1L);
                } else {
                    this.iter = this.iter.callMethod(context, "-", this.one(context));
                }
            }
            IRubyObject i2 = this.iter;
            if (i2 instanceof RubyInteger && ((RubyInteger)i2).isZero(context)) {
                this.doYield(context, arg2);
                this.iter = this.step;
            }
        }

        protected void doYield(ThreadContext context, IRubyObject arg2) {
            this.block.yield(context, arg2);
        }

        private RubyFixnum one(ThreadContext context) {
            RubyFixnum one = this.one;
            if (one == null) {
                one = this.one = RubyFixnum.one(context.runtime);
            }
            return one;
        }
    }

    private static class SymbolStepBlockCallBack
    extends StepBlockCallBack {
        SymbolStepBlockCallBack(Block block, RubyFixnum iter, IRubyObject step2) {
            super(block, iter, step2);
        }

        @Override
        protected void doYield(ThreadContext context, IRubyObject arg2) {
            this.block.yield(context, ((RubyString)arg2).intern(context));
        }
    }

    public static class RangeLike {
        final IRubyObject begin;
        final IRubyObject end;
        final boolean excl;

        RangeLike(IRubyObject begin2, IRubyObject end2, boolean excl) {
            this.begin = begin2;
            this.end = end2;
            this.excl = excl;
        }

        IRubyObject getRange(ThreadContext context) {
            return Helpers.invoke(context, this.end, "-", this.begin);
        }
    }
}

