/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.api.JRubyAPI;
import org.jruby.api.Warn;
import org.jruby.runtime.Builtins;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.SimpleHash;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Numeric;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Bignum"}, parent="Integer")
public class RubyBignum
extends RubyInteger
implements SimpleHash {
    private static final int BIT_SIZE = 64;
    private static final long MAX = Long.MAX_VALUE;
    public static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger LONG_MAX_PLUS_ONE = LONG_MAX.add(BigInteger.ONE);
    public static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger LONG_MIN_MINUS_ONE = LONG_MIN.subtract(BigInteger.ONE);
    public static final BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger INTEGER_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final BigInteger ULONG_MAX = BigInteger.valueOf(1L).shiftLeft(64).subtract(BigInteger.valueOf(1L));
    final BigInteger value;
    private static final long BIGLEN_LIMIT = 0x80000000L;

    public RubyBignum(Ruby runtime2, BigInteger value2) {
        super(runtime2, runtime2.getInteger());
        this.value = value2;
        this.setFrozen(true);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.BIGNUM;
    }

    @Override
    public Class<?> getJavaClass() {
        return BigInteger.class;
    }

    public static RubyBignum newBignum(Ruby runtime2, long value2) {
        return RubyBignum.newBignum(runtime2, BigInteger.valueOf(value2));
    }

    public static RubyBignum newBignum(Ruby runtime2, double value2) {
        try {
            return RubyBignum.newBignum(runtime2, RubyBignum.toBigInteger(value2));
        }
        catch (NumberFormatException nfe) {
            throw runtime2.newFloatDomainError(Double.toString(value2));
        }
    }

    public static BigInteger toBigInteger(double value2) {
        return new BigDecimal(value2).toBigInteger();
    }

    public static RubyInteger newBignorm(Ruby runtime2, double value2) {
        try {
            return RubyBignum.bignorm(runtime2, RubyBignum.toBigInteger(value2));
        }
        catch (NumberFormatException nfe) {
            throw runtime2.newFloatDomainError(Double.toString(value2));
        }
    }

    public static RubyBignum newBignum(Ruby runtime2, BigInteger value2) {
        return new RubyBignum(runtime2, value2);
    }

    public static RubyBignum newBignum(Ruby runtime2, String value2) {
        return new RubyBignum(runtime2, new BigInteger(value2));
    }

    @Override
    @JRubyAPI
    public BigInteger asBigInteger(ThreadContext context) {
        return this.value;
    }

    @Override
    @JRubyAPI
    public double asDouble(ThreadContext context) {
        return RubyBignum.big2dbl(this);
    }

    @Override
    @JRubyAPI
    public int asInt(ThreadContext context) {
        return this.getValue().intValue();
    }

    @Override
    @JRubyAPI
    public long asLong(ThreadContext context) {
        return this.value.longValue();
    }

    @Override
    public RubyClass singletonClass(ThreadContext context) {
        throw Error.typeError(context, "can't define singleton");
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    @JRubyAPI
    public int signum(ThreadContext context) {
        return this.value.signum();
    }

    @Override
    public RubyInteger negate(ThreadContext context) {
        return RubyBignum.bignorm(context.runtime, this.value.negate());
    }

    public static RubyInteger bignorm(Ruby runtime2, BigInteger bi) {
        return bi.compareTo(LONG_MIN) < 0 || bi.compareTo(LONG_MAX) > 0 ? RubyBignum.newBignum(runtime2, bi) : runtime2.newFixnum(bi.longValue());
    }

    public static long big2long(RubyBignum val) {
        BigInteger big = val.value;
        if (big.compareTo(LONG_MIN) < 0 || big.compareTo(LONG_MAX) > 0) {
            throw val.getRuntime().newRangeError("bignum too big to convert into 'long'");
        }
        return big.longValue();
    }

    public static long big2ulong(RubyBignum value2) {
        Ruby runtime2 = value2.getRuntime();
        BigInteger big = value2.getValue();
        return RubyBignum.big2ulong(runtime2, big);
    }

    public static long big2ulong(Ruby runtime2, BigInteger big) {
        if (big.compareTo(BigInteger.ZERO) < 0 || big.compareTo(ULONG_MAX) > 0) {
            throw runtime2.newRangeError("bignum out of range of unsigned long");
        }
        return big.longValue();
    }

    public static double big2dbl(RubyBignum val) {
        BigInteger big = val.value;
        double dbl = RubyBignum.convertToDouble(big);
        if (dbl == Double.NEGATIVE_INFINITY || dbl == Double.POSITIVE_INFINITY) {
            Warn.warning(val.getRuntime().getCurrentContext(), "Integer out of Float range");
        }
        return dbl;
    }

    private RubyFixnum checkShiftDown(ThreadContext context, RubyBignum other) {
        if (other.value.signum() == 0) {
            return RubyFixnum.zero(context.runtime);
        }
        if (this.value.compareTo(LONG_MIN) < 0 || this.value.compareTo(LONG_MAX) > 0) {
            return other.value.signum() >= 0 ? RubyFixnum.zero(context.runtime) : RubyFixnum.minus_one(context.runtime);
        }
        return null;
    }

    static double convertToDouble(BigInteger bigint) {
        long signum = bigint.signum() == -1 ? Long.MIN_VALUE : 0L;
        int len = (bigint = bigint.abs()).bitLength();
        if (len == 0) {
            return 0.0;
        }
        long exp2 = len + 1022;
        long frac2 = 0L;
        if (exp2 > 2047L) {
            exp2 = 2047L;
        } else {
            frac2 = bigint.shiftRight(len - 54).longValue() + 1L >> 1;
            if (frac2 == 0x20000000000000L && ++exp2 > 2047L) {
                exp2 = 2047L;
            }
        }
        return Double.longBitsToDouble(signum | exp2 << 52 | frac2 & 0xFFFFFFFFFFFFFL);
    }

    public static BigInteger fix2big(RubyFixnum arg2) {
        return RubyBignum.long2big(arg2.getValue());
    }

    public static BigInteger long2big(long arg2) {
        return BigInteger.valueOf(arg2);
    }

    @Override
    public IRubyObject ceil(ThreadContext context, IRubyObject arg2) {
        RubyBignum num = this;
        long ndigits = Convert.toLong(context, arg2);
        if (ndigits >= 0L) {
            return num;
        }
        RubyInteger f = (RubyInteger)Numeric.int_pow(context, 10L, -ndigits);
        return this.integerCeil(context, f);
    }

    @Override
    public IRubyObject floor(ThreadContext context, IRubyObject arg2) {
        long ndigits = Convert.toLong(context, arg2);
        if (ndigits >= 0L) {
            return this;
        }
        RubyInteger f = (RubyInteger)Numeric.int_pow(context, 10L, -ndigits);
        return this.integerFloor(context, f);
    }

    @Override
    public IRubyObject truncate(ThreadContext context, IRubyObject arg2) {
        BigInteger self2 = this.value;
        if (self2.compareTo(BigInteger.ZERO) == 1) {
            return this.floor(context, arg2);
        }
        if (self2.compareTo(BigInteger.ZERO) == -1) {
            return this.ceil(context, arg2);
        }
        return this;
    }

    @Override
    public RubyArray digits(ThreadContext context, IRubyObject baseArg) {
        BigInteger bigBase;
        BigInteger self2 = this.value;
        if (self2.compareTo(BigInteger.ZERO) == -1) {
            throw context.runtime.newMathDomainError("out of domain");
        }
        RubyInteger base = Convert.toInteger(context, baseArg);
        if (base instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)base;
            v0 = bignum.value;
        } else {
            v0 = bigBase = RubyBignum.long2big(base.asLong(context));
        }
        if (bigBase.signum() == -1) {
            throw Error.argumentError(context, "negative radix");
        }
        if (bigBase.compareTo(BigInteger.valueOf(2L)) == -1) {
            throw Error.argumentError(context, "invalid radix: " + String.valueOf(bigBase));
        }
        if (self2.signum() == 0) {
            return Create.newArray(context, (IRubyObject)Convert.asFixnum(context, 0));
        }
        if (self2.signum() <= 0) {
            return Create.newEmptyArray(context);
        }
        RubyArray<?> res = Create.allocArray(context, 16);
        do {
            BigInteger q = self2.mod(bigBase);
            res.append(context, RubyBignum.newBignum(context.runtime, q));
        } while ((self2 = self2.divide(bigBase)).signum() > 0);
        return res;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject to_s(IRubyObject[] args2) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        return switch (args2.length) {
            case 0 -> this.to_s(context);
            case 1 -> this.to_s(context, args2[0]);
            default -> throw Error.argumentError(context, args2.length, 1);
        };
    }

    @Override
    public RubyString to_s(ThreadContext context) {
        return RubyString.newUSASCIIString(context.runtime, this.value.toString(10));
    }

    @Override
    public RubyString to_s(ThreadContext context, IRubyObject arg0) {
        int base = Convert.toInt(context, arg0);
        if (base < 2 || base > 36) {
            throw Error.argumentError(context, "illegal radix " + base);
        }
        return RubyString.newUSASCIIString(context.runtime, this.value.toString(base));
    }

    @Override
    public IRubyObject coerce(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)other;
            return Create.newArray(context, (IRubyObject)RubyBignum.newBignum(context.runtime, fix2.getValue()), (IRubyObject)this);
        }
        if (other instanceof RubyBignum) {
            RubyBignum big = (RubyBignum)other;
            return Create.newArray(context, (IRubyObject)RubyBignum.newBignum(context.runtime, big.value), (IRubyObject)this);
        }
        return Create.newArray(context, (IRubyObject)RubyKernel.new_float(context, other), (IRubyObject)RubyKernel.new_float(context, (RubyInteger)this));
    }

    @Override
    public IRubyObject op_uminus(ThreadContext context) {
        return RubyBignum.bignorm(context.runtime, this.value.negate());
    }

    @Override
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject = other;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFixnum.class, RubyBignum.class, RubyFloat.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyFixnum fix = (RubyFixnum)iRubyObject2;
                yield this.op_plus(context, fix.getValue());
            }
            case 1 -> {
                RubyBignum big = (RubyBignum)iRubyObject2;
                yield this.op_plus(context, big.value);
            }
            case 2 -> {
                RubyFloat flote = (RubyFloat)iRubyObject2;
                yield this.addFloat(context, flote);
            }
            default -> this.addOther(context, other);
        };
    }

    @Override
    public final IRubyObject op_plus(ThreadContext context, long other) {
        BigInteger result2 = this.value.add(BigInteger.valueOf(other));
        if (other > 0L && this.value.signum() > 0) {
            return new RubyBignum(context.runtime, result2);
        }
        return RubyBignum.bignorm(context.runtime, result2);
    }

    public final IRubyObject op_plus(ThreadContext context, BigInteger other) {
        BigInteger result2 = this.value.add(other);
        if (this.value.signum() > 0 && other.signum() > 0) {
            return new RubyBignum(context.runtime, result2);
        }
        return RubyBignum.bignorm(context.runtime, result2);
    }

    private IRubyObject addFloat(ThreadContext context, RubyFloat other) {
        return Convert.asFloat(context, RubyBignum.big2dbl(this) + other.value);
    }

    private IRubyObject addOther(ThreadContext context, IRubyObject other) {
        return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).op_plus, other);
    }

    @Override
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject = other;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFixnum.class, RubyBignum.class, RubyFloat.class}, (Object)iRubyObject2, n)) {
            case 0 -> {
                RubyFixnum fixnum = (RubyFixnum)iRubyObject2;
                yield this.op_minus(context, fixnum.getValue());
            }
            case 1 -> {
                RubyBignum bignum = (RubyBignum)iRubyObject2;
                yield this.op_minus(context, bignum.value);
            }
            case 2 -> {
                RubyFloat flote = (RubyFloat)iRubyObject2;
                yield this.subtractFloat(flote);
            }
            default -> this.subtractOther(context, other);
        };
    }

    @Override
    public final IRubyObject op_minus(ThreadContext context, long other) {
        BigInteger result2 = this.value.subtract(BigInteger.valueOf(other));
        if (this.value.signum() < 0 && other > 0L) {
            return new RubyBignum(context.runtime, result2);
        }
        return RubyBignum.bignorm(context.runtime, result2);
    }

    public final IRubyObject op_minus(ThreadContext context, BigInteger other) {
        BigInteger result2 = this.value.subtract(other);
        if (this.value.signum() < 0 && other.signum() > 0) {
            return new RubyBignum(context.runtime, result2);
        }
        return RubyBignum.bignorm(context.runtime, result2);
    }

    private IRubyObject subtractFloat(RubyFloat other) {
        return RubyFloat.newFloat(this.getRuntime(), RubyBignum.big2dbl(this) - other.value);
    }

    private IRubyObject subtractOther(ThreadContext context, IRubyObject other) {
        return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).op_minus, other);
    }

    @Override
    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_mul(context, ((RubyFixnum)other).getValue());
        }
        if (!(other instanceof RubyBignum)) {
            if (other instanceof RubyFloat) {
                return RubyFloat.newFloat(context.runtime, RubyBignum.big2dbl(this) * ((RubyFloat)other).value);
            }
            return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).op_times, other);
        }
        return RubyBignum.bignorm(context.runtime, this.value.multiply(((RubyBignum)other).value));
    }

    @Override
    public final IRubyObject op_mul(ThreadContext context, long other) {
        return RubyBignum.bignorm(context.runtime, this.value.multiply(RubyBignum.long2big(other)));
    }

    private IRubyObject op_divide(ThreadContext context, IRubyObject other, boolean slash) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)other;
            otherValue = RubyBignum.fix2big(fixnum);
        } else if (other instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)other;
            otherValue = bignum.getValue();
        } else {
            if (other instanceof RubyFloat) {
                RubyFloat flote = (RubyFloat)other;
                double otherFloatValue = flote.getValue();
                if (!slash && otherFloatValue == 0.0) {
                    throw Error.zeroDivisionError(context);
                }
                double div2 = RubyBignum.big2dbl(this) / otherFloatValue;
                return slash ? Convert.asFloat(context, div2) : Convert.asInteger(context, div2);
            }
            return this.coerceBin(context, slash ? RubyBignum.sites((ThreadContext)context).op_quo : RubyBignum.sites((ThreadContext)context).div, other);
        }
        return this.divideImpl(context, otherValue);
    }

    private RubyInteger divideImpl(ThreadContext context, BigInteger otherValue) {
        BigInteger[] results;
        if (otherValue.signum() == 0) {
            throw Error.zeroDivisionError(context);
        }
        BigInteger result2 = this.value.signum() * otherValue.signum() == -1 ? ((results = this.value.divideAndRemainder(otherValue))[1].signum() != 0 ? results[0].subtract(BigInteger.ONE) : results[0]) : this.value.divide(otherValue);
        return RubyBignum.bignorm(context.runtime, result2);
    }

    @Override
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        return this.op_divide(context, other, true);
    }

    public IRubyObject op_div(ThreadContext context, long other) {
        return this.divideImpl(context, RubyBignum.long2big(other));
    }

    @Override
    public IRubyObject idiv(ThreadContext context, IRubyObject other) {
        return this.op_divide(context, other, false);
    }

    @Override
    public IRubyObject idiv(ThreadContext context, long other) {
        return this.divideImpl(context, RubyBignum.long2big(other));
    }

    @Override
    @JRubyMethod(name={"divmod"})
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)other;
            otherValue = RubyBignum.fix2big(fix2);
        } else if (other instanceof RubyBignum) {
            RubyBignum big = (RubyBignum)other;
            otherValue = big.value;
        } else {
            if (other instanceof RubyFloat) {
                RubyFloat flote = (RubyFloat)other;
                if (flote.value == 0.0) {
                    throw context.runtime.newZeroDivisionError();
                }
            }
            return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).divmod, other);
        }
        if (otherValue.signum() == 0) {
            throw context.runtime.newZeroDivisionError();
        }
        BigInteger[] results = this.value.divideAndRemainder(otherValue);
        if (this.value.signum() * otherValue.signum() == -1 && results[1].signum() != 0) {
            results[0] = results[0].subtract(BigInteger.ONE);
            results[1] = otherValue.add(results[1]);
        }
        return Create.newArray(context, (IRubyObject)RubyBignum.bignorm(context.runtime, results[0]), (IRubyObject)RubyBignum.bignorm(context.runtime, results[1]));
    }

    @Override
    @JRubyMethod(name={"%", "modulo"})
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_mod(context, ((RubyFixnum)other).getValue());
        }
        if (other instanceof RubyBignum) {
            BigInteger otherValue = ((RubyBignum)other).value;
            if (otherValue.signum() == 0) {
                throw context.runtime.newZeroDivisionError();
            }
            BigInteger result2 = this.value.mod(otherValue.abs());
            if (otherValue.signum() == -1 && result2.signum() != 0) {
                result2 = otherValue.add(result2);
            }
            return RubyBignum.bignorm(context.runtime, result2);
        }
        if (other instanceof RubyFloat && ((RubyFloat)other).value == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).op_mod, other);
    }

    @Override
    public IRubyObject op_mod(ThreadContext context, long other) {
        if (other == 0L) {
            throw context.runtime.newZeroDivisionError();
        }
        BigInteger result2 = this.value.mod(RubyBignum.long2big(other < 0L ? -other : other));
        if (other < 0L && result2.signum() != 0) {
            result2 = RubyBignum.long2big(other).add(result2);
        }
        return RubyBignum.bignorm(context.runtime, result2);
    }

    @Override
    public IRubyObject modulo(ThreadContext context, IRubyObject other) {
        return this.op_mod(context, other);
    }

    @Override
    IRubyObject modulo(ThreadContext context, long other) {
        return this.op_mod(context, other);
    }

    @Override
    @JRubyMethod(name={"remainder"})
    public IRubyObject remainder(ThreadContext context, IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFloat && ((RubyFloat)other).value == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
        if (other instanceof RubyFixnum) {
            otherValue = RubyBignum.fix2big((RubyFixnum)other);
        } else if (other instanceof RubyBignum) {
            otherValue = ((RubyBignum)other).value;
        } else {
            if (other instanceof RubyFloat && ((RubyFloat)other).value == 0.0) {
                throw context.runtime.newZeroDivisionError();
            }
            return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).remainder, other);
        }
        if (otherValue.signum() == 0) {
            throw context.runtime.newZeroDivisionError();
        }
        return RubyBignum.bignorm(context.runtime, this.value.remainder(otherValue));
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public IRubyObject quo(ThreadContext context, IRubyObject otherArg) {
        return super.quo(context, otherArg);
    }

    @Override
    @JRubyMethod(name={"**", "power"})
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        double d;
        if (other == Convert.asFixnum(context, 0)) {
            return Convert.asFixnum(context, 1);
        }
        if (other instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)other;
            d = flote.value;
            if (this.compareTo(Convert.asFixnum(context, 0)) == -1 && d != (double)Math.round(d)) {
                RubyComplex complex = RubyComplex.newComplexRaw(context.runtime, this);
                return RubyBignum.sites((ThreadContext)context).op_exp.call(context, (IRubyObject)complex, (IRubyObject)complex, other);
            }
        } else {
            if (other instanceof RubyBignum) {
                throw Error.argumentError(context, "exponent is too large");
            }
            if (other instanceof RubyFixnum) {
                RubyFixnum fixnum = (RubyFixnum)other;
                return this.op_pow(context, fixnum.getValue());
            }
            return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).op_exp, other);
        }
        return this.pow(context, d);
    }

    private RubyNumeric pow(ThreadContext context, double d) {
        double pow2 = Math.pow(RubyBignum.big2dbl(this), d);
        return Double.isInfinite(pow2) ? Convert.asFloat(context, pow2) : Convert.asInteger(context, pow2);
    }

    public final IRubyObject op_pow(ThreadContext context, long other) {
        if (other < 0L) {
            IRubyObject x = this.op_pow(context, -other);
            if (x instanceof RubyInteger) {
                return RubyRational.newRationalRaw(context.runtime, Convert.asFixnum(context, 1), x);
            }
            return Convert.asFloat(context, 1.0 / Convert.toDouble(context, x));
        }
        int xbits = this.value.bitLength() / 8;
        if ((long)xbits * other > 0x80000000L) {
            throw Error.argumentError(context, "exponent is too large");
        }
        return RubyBignum.newBignum(context.runtime, this.value.pow((int)other));
    }

    @Override
    public IRubyObject op_and(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBignum.bignorm(context.runtime, this.value.and(((RubyBignum)other).value));
        }
        if (other instanceof RubyFixnum) {
            return this.op_and(context, (RubyFixnum)other);
        }
        return this.coerceBit(context, RubyBignum.sites((ThreadContext)context).checked_op_and, other);
    }

    final RubyInteger op_and(ThreadContext context, RubyFixnum other) {
        return RubyBignum.bignorm(context.runtime, this.value.and(RubyBignum.fix2big(other)));
    }

    @Override
    public IRubyObject op_or(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBignum.bignorm(context.runtime, this.value.or(((RubyBignum)other).value));
        }
        if (other instanceof RubyFixnum) {
            return this.op_or(context, (RubyFixnum)other);
        }
        return this.coerceBit(context, RubyBignum.sites((ThreadContext)context).checked_op_or, other);
    }

    final RubyInteger op_or(ThreadContext context, RubyFixnum other) {
        return RubyBignum.bignorm(context.runtime, this.value.or(RubyBignum.fix2big(other)));
    }

    @Override
    public IRubyObject bit_length(ThreadContext context) {
        return Convert.asFixnum(context, this.value.bitLength());
    }

    @Override
    public IRubyObject op_xor(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBignum.bignorm(context.runtime, this.value.xor(((RubyBignum)other).value));
        }
        if (other instanceof RubyFixnum) {
            return RubyBignum.bignorm(context.runtime, this.value.xor(BigInteger.valueOf(((RubyFixnum)other).getValue())));
        }
        return this.coerceBit(context, RubyBignum.sites((ThreadContext)context).checked_op_xor, other);
    }

    @Override
    public IRubyObject op_neg(ThreadContext context) {
        return RubyBignum.newBignum(context.runtime, this.value.not());
    }

    @Override
    public IRubyObject op_lshift(ThreadContext context, IRubyObject other) {
        long shift2;
        while (true) {
            if (other instanceof RubyFixnum) {
                RubyFixnum fixnum = (RubyFixnum)other;
                shift2 = fixnum.getValue();
                if (shift2 >= 0L || (long)this.value.bitLength() > -shift2) break;
                return this.value.signum() >= 0 ? Convert.asFixnum(context, 0) : RubyFixnum.minus_one(context.runtime);
            }
            if (other instanceof RubyBignum) {
                RubyFixnum tmp;
                RubyBignum otherBignum = (RubyBignum)other;
                if (this.value.signum() == 0) {
                    return Convert.asFixnum(context, 0);
                }
                if (otherBignum.value.signum() < 0 && (tmp = otherBignum.checkShiftDown(context, this)) != null) {
                    return tmp;
                }
                if (otherBignum.value.compareTo(INTEGER_MAX) > 0) {
                    throw Error.rangeError(context, "shift width too big");
                }
                shift2 = otherBignum.asLong(context);
                break;
            }
            other = Convert.toInteger(context, other);
        }
        return this.op_lshift(context, shift2);
    }

    @Override
    public RubyInteger op_lshift(ThreadContext context, long shift2) {
        if (this.value.signum() == 0) {
            return RubyFixnum.zero(context.runtime);
        }
        if (shift2 > Integer.MAX_VALUE) {
            throw Error.rangeError(context, "shift width too big");
        }
        return RubyBignum.bignorm(context.runtime, this.value.shiftLeft((int)shift2));
    }

    @Override
    public IRubyObject op_rshift(ThreadContext context, IRubyObject other) {
        long shift2;
        while (true) {
            if (other instanceof RubyFixnum) {
                RubyFixnum fixnum = (RubyFixnum)other;
                shift2 = fixnum.getValue();
                if ((long)this.value.bitLength() > shift2) break;
                return this.value.signum() >= 0 ? Convert.asFixnum(context, 0) : RubyFixnum.minus_one(context.runtime);
            }
            if (other instanceof RubyBignum) {
                RubyFixnum tmp;
                RubyBignum otherBignum = (RubyBignum)other;
                if (this.value == BigInteger.ZERO) {
                    return Convert.asFixnum(context, 0);
                }
                if (otherBignum.value.signum() >= 0 && (tmp = otherBignum.checkShiftDown(context, this)) != null) {
                    return tmp;
                }
                if (otherBignum.value.compareTo(INTEGER_MIN) < 0) {
                    throw Error.rangeError(context, "shift width too big");
                }
                shift2 = otherBignum.asLong(context);
                break;
            }
            other = Convert.toInteger(context, other);
        }
        return this.op_rshift(context, shift2);
    }

    @Override
    public RubyInteger op_rshift(ThreadContext context, long shift2) {
        if (this.value.signum() == 0) {
            return RubyFixnum.zero(context.runtime);
        }
        if (shift2 < Integer.MIN_VALUE) {
            throw Error.rangeError(context, "shift width too big");
        }
        return RubyBignum.bignorm(context.runtime, this.value.shiftRight((int)shift2));
    }

    @Override
    public RubyBoolean odd_p(ThreadContext context) {
        return this.value.testBit(0) ? context.tru : context.fals;
    }

    @Override
    public RubyBoolean even_p(ThreadContext context) {
        return this.value.testBit(0) ? context.fals : context.tru;
    }

    @Override
    protected IRubyObject op_aref_subclass(ThreadContext context, IRubyObject other) {
        long position;
        if (other instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)other;
            other = RubyBignum.bignorm(context.runtime, bignum.value);
            if (other instanceof RubyBignum) {
                RubyBignum bignum2 = (RubyBignum)other;
                return Convert.asFixnum(context, bignum2.value.signum() >= 0 != (this.value.signum() == -1) ? 0 : 1);
            }
        }
        if ((position = Convert.toLong(context, other)) < 0L || position > Integer.MAX_VALUE) {
            return Convert.asFixnum(context, 0);
        }
        return Convert.asFixnum(context, this.value.testBit((int)position) ? 1 : 0);
    }

    private IRubyObject big_op(ThreadContext context, IRubyObject other, BIGNUM_OP_T op) {
        IRubyObject rel;
        if (other instanceof RubyInteger) {
            rel = this.op_cmp(context, other);
        } else if (other instanceof RubyFloat) {
            rel = this.float_cmp(context, (RubyFloat)other);
        } else {
            switch (op.ordinal()) {
                case 0: {
                    CallSite site = RubyBignum.sites((ThreadContext)context).op_gt;
                    break;
                }
                case 1: {
                    CallSite site = RubyBignum.sites((ThreadContext)context).op_ge;
                    break;
                }
                case 2: {
                    CallSite site = RubyBignum.sites((ThreadContext)context).op_lt;
                    break;
                }
                case 3: {
                    CallSite site = RubyBignum.sites((ThreadContext)context).op_le;
                }
            }
            return this.coerceRelOp(context, RubyBignum.sites((ThreadContext)context).op_gt, other);
        }
        if (rel.isNil()) {
            return context.fals;
        }
        int n = Convert.toInt(context, rel);
        IRubyObject ret = context.nil;
        switch (op.ordinal()) {
            case 0: {
                ret = n > 0 ? context.tru : context.fals;
                break;
            }
            case 1: {
                ret = n >= 0 ? context.tru : context.fals;
                break;
            }
            case 2: {
                ret = n < 0 ? context.tru : context.fals;
                break;
            }
            case 3: {
                ret = n <= 0 ? context.tru : context.fals;
            }
        }
        return ret;
    }

    @Override
    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        return this.big_op(context, other, BIGNUM_OP_T.BIGNUM_OP_GT);
    }

    @Override
    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        return this.big_op(context, other, BIGNUM_OP_T.BIGNUM_OP_LT);
    }

    @Override
    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        return this.big_op(context, other, BIGNUM_OP_T.BIGNUM_OP_GE);
    }

    @Override
    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        return this.big_op(context, other, BIGNUM_OP_T.BIGNUM_OP_LE);
    }

    private IRubyObject float_cmp(ThreadContext context, RubyFloat y) {
        Ruby runtime2 = context.runtime;
        double yd = y.value;
        if (Double.isNaN(yd)) {
            return context.nil;
        }
        if (Double.isInfinite(yd)) {
            if (yd > 0.0) {
                return RubyFixnum.minus_one(runtime2);
            }
            return RubyFixnum.one(runtime2);
        }
        double yi = yd > 0.0 ? Math.floor(yd) : Math.ceil(yd);
        double yf = yd - yi;
        IRubyObject rel = this.op_cmp(context, RubyBignum.newBignorm(runtime2, yi));
        if (yf == 0.0 || !rel.equals(RubyFixnum.zero(runtime2))) {
            return rel;
        }
        if (yf < 0.0) {
            return RubyFixnum.one(runtime2);
        }
        return RubyFixnum.minus_one(runtime2);
    }

    @Override
    public final int compareTo(IRubyObject other) {
        if (other instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)other;
            return this.value.compareTo(bignum.value);
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        return Convert.toInt(context, this.coerceCmp(context, RubyBignum.sites((ThreadContext)context).op_cmp, other));
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RubyBignum) {
            return this.value.compareTo(((RubyBignum)other).value) == 0;
        }
        return false;
    }

    @Override
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)other;
            otherValue = RubyBignum.fix2big(fix2);
        } else if (other instanceof RubyBignum) {
            RubyBignum big = (RubyBignum)other;
            otherValue = big.value;
        } else {
            if (other instanceof RubyFloat) {
                RubyFloat flt = (RubyFloat)other;
                return flt.isInfinite() ? Convert.asFixnum(context, flt.value > 0.0 ? -1 : 1) : RubyBignum.dbl_cmp(context.runtime, RubyBignum.big2dbl(this), flt.value);
            }
            return this.coerceCmp(context, RubyBignum.sites((ThreadContext)context).op_cmp, other);
        }
        return Convert.asFixnum(context, this.value.compareTo(otherValue));
    }

    @Override
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        BigInteger otherValue;
        if (other instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)other;
            otherValue = RubyBignum.fix2big(fixnum);
        } else if (other instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)other;
            otherValue = bignum.value;
        } else {
            if (other instanceof RubyFloat) {
                RubyFloat flote = (RubyFloat)other;
                double a = flote.value;
                if (Double.isNaN(a) || Double.isInfinite(a)) {
                    return context.fals;
                }
                return Convert.asBoolean(context, a == RubyBignum.big2dbl(this));
            }
            return other.op_eqq(context, this);
        }
        return Convert.asBoolean(context, this.value.compareTo(otherValue) == 0);
    }

    @Override
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        return this.op_equal(context, other);
    }

    @Override
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.longHashCode());
    }

    @Override
    public int hashCode() {
        return (int)this.longHashCode();
    }

    @Override
    public long longHashCode() {
        return Helpers.multAndMix(Ruby.getHashSeed0(), this.value.hashCode());
    }

    @Override
    public IRubyObject to_f(ThreadContext context) {
        return Convert.asFloat(context, this.asDouble(context));
    }

    @Deprecated(since="9.2.0.0")
    public IRubyObject abs() {
        return this.abs(this.getCurrentContext());
    }

    @Override
    public IRubyObject abs(ThreadContext context) {
        return RubyBignum.newBignum(context.runtime, this.value.abs());
    }

    @Override
    public IRubyObject size(ThreadContext context) {
        return Convert.asFixnum(context, (this.value.bitLength() + 7) / 8);
    }

    @Override
    public IRubyObject zero_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isZero(context));
    }

    @Override
    public final boolean isZero(ThreadContext context) {
        return this.value.signum() == 0;
    }

    @Override
    public IRubyObject nonzero_p(ThreadContext context) {
        return this.isZero(context) ? context.nil : this;
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static void marshalTo(RubyBignum bignum, MarshalStream output) throws IOException {
        ThreadContext context = bignum.getRuntime().getCurrentContext();
        output.registerLinkTarget(context, bignum);
        output.write(bignum.value.signum() >= 0 ? 43 : 45);
        BigInteger absValue = bignum.value.abs();
        byte[] digits2 = absValue.toByteArray();
        boolean oddLengthNonzeroStart = digits2.length % 2 != 0 && digits2[0] != 0;
        int shortLength = digits2.length / 2;
        if (oddLengthNonzeroStart) {
            ++shortLength;
        }
        output.writeInt(shortLength);
        for (int i2 = 1; i2 <= shortLength * 2 && i2 <= digits2.length; ++i2) {
            output.write(digits2[digits2.length - i2]);
        }
        if (oddLengthNonzeroStart) {
            output.write(0);
        }
    }

    public static void marshalTo(ThreadContext context, RubyOutputStream out, RubyBignum bignum, MarshalDumper output) {
        output.registerObject(bignum);
        RubyBignum.marshalBigInteger(out, output, bignum.value);
    }

    public static void marshalAsBignumTo(ThreadContext context, RubyOutputStream out, RubyFixnum fixnum, MarshalDumper output) {
        output.registerObject(fixnum);
        RubyBignum.marshalBigInteger(out, output, BigInteger.valueOf(fixnum.getValue()));
    }

    private static void marshalBigInteger(RubyOutputStream out, MarshalDumper output, BigInteger value2) {
        int b2 = value2.signum() >= 0 ? 43 : 45;
        out.write(b2);
        BigInteger absValue = value2.abs();
        byte[] digits2 = absValue.toByteArray();
        boolean oddLengthNonzeroStart = digits2.length % 2 != 0 && digits2[0] != 0;
        int shortLength = digits2.length / 2;
        if (oddLengthNonzeroStart) {
            ++shortLength;
        }
        output.writeInt(out, shortLength);
        for (int i2 = 1; i2 <= shortLength * 2 && i2 <= digits2.length; ++i2) {
            out.write(digits2[digits2.length - i2]);
        }
        if (oddLengthNonzeroStart) {
            out.write(0);
        }
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static RubyNumeric unmarshalFrom(UnmarshalStream input) throws IOException {
        boolean positive = input.readUnsignedByte() == 43;
        int shortLength = input.unmarshalInt();
        byte[] digits2 = new byte[shortLength * 2 + 1];
        for (int i2 = digits2.length - 1; i2 >= 1; --i2) {
            digits2[i2] = input.readSignedByte();
        }
        BigInteger value2 = new BigInteger(digits2);
        if (!positive) {
            value2 = value2.negate();
        }
        return RubyBignum.bignorm(input.getRuntime(), value2);
    }

    public static RubyNumeric unmarshalFrom(ThreadContext context, RubyInputStream in, MarshalLoader input) {
        boolean positive = input.readUnsignedByte(context, in) == 43;
        int shortLength = input.unmarshalInt(context, in);
        byte[] digits2 = new byte[shortLength * 2 + 1];
        for (int i2 = digits2.length - 1; i2 >= 1; --i2) {
            digits2[i2] = input.readSignedByte(context, in);
        }
        BigInteger value2 = new BigInteger(digits2);
        if (!positive) {
            value2 = value2.negate();
        }
        return RubyBignum.bignorm(context.runtime, value2);
    }

    @Override
    public IRubyObject fdivDouble(ThreadContext context, IRubyObject y) {
        double dy;
        double dx = this.asDouble(context);
        if (y instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)y;
            if (Double.isInfinite(dx)) {
                return this.fdivInt(context, BigDecimal.valueOf(fix2.getValue()));
            }
            dy = fix2.getValue();
        } else {
            if (y instanceof RubyBignum) {
                RubyBignum big = (RubyBignum)y;
                return this.fdivDouble(context, big);
            }
            if (y instanceof RubyFloat) {
                RubyFloat flote = (RubyFloat)y;
                dy = flote.value;
                if (Double.isNaN(dy)) {
                    return Convert.asFloat(context, dy);
                }
                if (Double.isInfinite(dx)) {
                    return this.fdivFloat(context, flote);
                }
            } else {
                return this.coerceBin(context, RubyBignum.sites((ThreadContext)context).fdiv, y);
            }
        }
        return Convert.asFloat(context, dx / dy);
    }

    final RubyFloat fdivDouble(ThreadContext context, RubyBignum y) {
        double dx = this.asDouble(context);
        double dy = RubyBignum.big2dbl(y);
        return Double.isInfinite(dx) || Double.isInfinite(dy) ? (RubyFloat)this.fdivInt(context, y) : Convert.asFloat(context, dx / dy);
    }

    public IRubyObject fdivInt(ThreadContext context, RubyBignum y) {
        return this.fdivInt(context, new BigDecimal(y.value));
    }

    private RubyFloat fdivInt(ThreadContext context, BigDecimal y) {
        return Convert.asFloat(context, new BigDecimal(this.value).divide(y).doubleValue());
    }

    public IRubyObject fdivFloat(ThreadContext context, RubyFloat y) {
        return context.runtime.newFloat(new BigDecimal(this.value).divide(new BigDecimal(y.value)).doubleValue());
    }

    @Override
    public IRubyObject isNegative(ThreadContext context) {
        if (Builtins.checkIntegerLt(context)) {
            return Convert.asBoolean(context, this.value.signum() < 0);
        }
        return RubyBignum.sites((ThreadContext)context).basic_op_lt.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)RubyFixnum.zero(context.runtime));
    }

    @Override
    public IRubyObject isPositive(ThreadContext context) {
        if (Builtins.checkIntegerGt(context)) {
            return Convert.asBoolean(context, this.value.signum() > 0);
        }
        return RubyBignum.sites((ThreadContext)context).basic_op_gt.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)RubyFixnum.zero(context.runtime));
    }

    @Override
    protected boolean int_round_zero_p(ThreadContext context, int ndigits) {
        long bytes2 = this.value.bitLength() / 8 + 1;
        return -0.415241 * (double)ndigits - 0.125 > (double)bytes2;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public IRubyObject numerator(ThreadContext context) {
        return this;
    }

    @Override
    public IRubyObject denominator(ThreadContext context) {
        return RubyFixnum.one(context.runtime);
    }

    @Override
    public RubyRational convertToRational(ThreadContext context) {
        return RubyRational.newRationalRaw(context.runtime, this, Convert.asFixnum(context, 1));
    }

    @Override
    public IRubyObject sqrt(ThreadContext context) {
        if (this.isNegativeNumber(context)) {
            throw context.runtime.newMathDomainError("Numerical argument is out of domain - isqrt");
        }
        return RubyBignum.bignorm(context.runtime, RubyBignum.floorSqrt(this.value));
    }

    private static JavaSites.BignumSites sites(ThreadContext context) {
        return context.sites.Bignum;
    }

    private static enum BIGNUM_OP_T {
        BIGNUM_OP_GT,
        BIGNUM_OP_GE,
        BIGNUM_OP_LT,
        BIGNUM_OP_LE;

    }
}

