/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jcodings.Encoding;
import org.jruby.EvalType;
import org.jruby.Finalizable;
import org.jruby.MetaClass;
import org.jruby.ObjectFlags;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Check;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.api.JRubyAPI;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.util.ArraySupport;
import org.jruby.util.IdUtil;
import org.jruby.util.Inspector;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

public class RubyBasicObject
implements Cloneable,
IRubyObject,
Serializable,
Comparable<IRubyObject>,
CoreObjectType,
InstanceVariables,
InternalVariables {
    protected transient RubyClass metaClass;
    protected byte flags;
    public transient Object[] varTable;
    public volatile transient byte varTableStamp;
    public static final String ERR_INSECURE_SET_INST_VAR = "Insecure: can't modify instance variable";
    static final byte FALSE = 1;
    static final byte NIL = 2;
    static final byte FROZEN = 4;
    @Deprecated(since="10.0.3.0")
    public static final int ALL_F = -1;
    @Deprecated(since="10.0.3.0")
    public static final int FALSE_F = 1;
    @Deprecated(since="10.0.3.0")
    public static final int NIL_F = 2;
    @Deprecated(since="10.0.3.0")
    public static final int FROZEN_F = ObjectFlags.FROZEN_F;
    public static final IRubyObject NEVER = new RubyBasicObject();
    public static final IRubyObject UNDEF = new RubyBasicObject();
    public static final ObjectAllocator BASICOBJECT_ALLOCATOR = RubyBasicObject::new;
    @Deprecated(since="9.1.3.0")
    public static final int FL_USHIFT = 4;
    @Deprecated(since="9.1.3.0")
    public static final int USER0_F = 16;
    @Deprecated(since="9.1.3.0")
    public static final int USER1_F = 32;
    @Deprecated(since="9.1.3.0")
    public static final int USER2_F = 64;
    @Deprecated(since="9.1.3.0")
    public static final int USER3_F = 128;
    @Deprecated(since="9.1.3.0")
    public static final int USER4_F = 256;
    @Deprecated(since="9.1.3.0")
    public static final int USER5_F = 512;
    @Deprecated(since="9.1.3.0")
    public static final int USER6_F = 1024;
    @Deprecated(since="9.1.3.0")
    public static final int USER7_F = 2048;
    @Deprecated(since="9.1.3.0")
    public static final int USER8_F = 4096;
    @Deprecated(since="9.1.3.0")
    public static final int USER9_F = 8192;
    @Deprecated(since="9.1.3.0")
    public static final int USERA_F = 16384;
    @Deprecated(since="9.1.3.0")
    public static final int REFINED_MODULE_F = 8192;
    @Deprecated(since="9.1.3.0")
    public static final int IS_OVERLAID_F = 16384;
    @Deprecated(since="9.1.3.0")
    public static final int COMPARE_BY_IDENTITY_F = 4096;
    @Deprecated(since="9.4.0.0")
    public static final int TAINTED_F = 0;
    @Deprecated(since="10.0.0.0")
    public static final long VAR_TABLE_OFFSET = -1L;
    @Deprecated(since="10.0.0.0")
    public static final long STAMP_OFFSET = -1L;

    private RubyBasicObject() {
    }

    public static void finishBasicObjectClass(ThreadContext context, RubyClass BasicObject) {
        ((RubyModule)BasicObject.classIndex(ClassIndex.OBJECT)).defineMethods(context, RubyBasicObject.class);
        RubyBasicObject.recacheBuiltinMethods(context, BasicObject);
    }

    static void recacheBuiltinMethods(ThreadContext context, RubyClass BasicObject) {
        context.runtime.setDefaultMethodMissing(BasicObject.searchMethod("method_missing"), BasicObject.metaClass.searchMethod("method_missing"));
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        return context.nil;
    }

    public RubyBasicObject(Ruby runtime2, RubyClass metaClass) {
        this.metaClass = metaClass;
        runtime2.addToObjectSpace(true, this);
    }

    public RubyBasicObject(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    protected RubyBasicObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace) {
        this.metaClass = metaClass;
        runtime2.addToObjectSpace(useObjectSpace, this);
    }

    protected final void testFrozen(String message2) {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(message2, this);
        }
    }

    protected final void testFrozen() {
        if (this.isFrozen()) {
            ThreadContext context = this.getRuntime().getCurrentContext();
            throw context.runtime.newFrozenError((this.isClass() ? "Class: " : (this.isModule() ? "Module: " : "object: ")) + String.valueOf(this.inspect(context)), this);
        }
    }

    @Deprecated(since="10.0.3.0")
    public final void setFlag(int flag, boolean set2) {
        if (flag == 4) {
            this.setFrozen(set2);
        } else {
            this.flags = set2 ? (byte)(this.flags | flag) : (byte)(this.flags & ~flag);
        }
    }

    @Deprecated(since="10.0.3.0")
    public final boolean getFlag(int flag) {
        if (flag == 4) {
            return this.isFrozen();
        }
        return (this.flags & flag) != 0;
    }

    @Override
    public final IRubyObject checkCallMethod(ThreadContext context, String name2) {
        return Helpers.invokeChecked(context, (IRubyObject)this, name2);
    }

    @Override
    public final IRubyObject checkCallMethod(ThreadContext context, JavaSites.CheckedSites sites) {
        return Helpers.invokeChecked(context, (IRubyObject)this, sites);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2) {
        return Helpers.invoke(context, this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject arg2) {
        return Helpers.invoke(context, (IRubyObject)this, name2, arg2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2) {
        return Helpers.invoke(context, (IRubyObject)this, name2, args2);
    }

    public final IRubyObject callMethod(String name2, IRubyObject ... args2) {
        return Helpers.invoke(this.metaClass.runtime.getCurrentContext(), (IRubyObject)this, name2, args2);
    }

    public final IRubyObject callMethod(String name2, IRubyObject arg2) {
        return Helpers.invoke(this.metaClass.runtime.getCurrentContext(), (IRubyObject)this, name2, arg2);
    }

    public final IRubyObject callMethod(String name2) {
        return Helpers.invoke(this.metaClass.runtime.getCurrentContext(), this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        return Helpers.invoke(context, (IRubyObject)this, name2, args2, block);
    }

    @Override
    public final boolean isNil() {
        return (this.flags & 2) != 0;
    }

    @Override
    public final boolean isTrue() {
        return (this.flags & 1) == 0;
    }

    public final boolean isFalse() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isFrozen() {
        return (this.flags & 4) != 0;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.flags = frozen ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public boolean isSpecialConst() {
        return this.isImmediate() || !this.isTrue();
    }

    public boolean isSpecialObject() {
        return this.isImmediate() || this instanceof RubyNumeric;
    }

    @Override
    public final RubyClass getMetaClass() {
        return this.metaClass;
    }

    public static RubyClass getMetaClass(IRubyObject arg2) {
        return ((RubyBasicObject)arg2).metaClass;
    }

    @Override
    public RubyClass getSingletonClass() {
        return this.singletonClass(this.getCurrentContext());
    }

    @Override
    @JRubyAPI
    public RubyClass singletonClass(ThreadContext context) {
        RubyClass klass = this.metaClass.toSingletonClass(context, this);
        if (this.isFrozen()) {
            klass.setFrozen(true);
        }
        return klass;
    }

    @Deprecated(since="10.0.0.0")
    public RubyClass makeMetaClass(RubyClass superClass) {
        return this.makeMetaClass(this.getCurrentContext(), superClass);
    }

    public RubyClass makeMetaClass(ThreadContext context, RubyClass superClass) {
        MetaClass klass = new MetaClass(context.runtime, superClass, this);
        this.setMetaClass(klass);
        klass.setMetaClass(superClass.getRealClass().metaClass);
        return klass;
    }

    public RubyClass makeMetaClassBootstrap(Ruby runtime2, RubyClass superClass, RubyClass Class2) {
        MetaClass klass = new MetaClass(runtime2, superClass, Class2, this);
        this.setMetaClass(klass);
        klass.setMetaClass(superClass.getRealClass().metaClass);
        return klass;
    }

    public void setMetaClass(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public final RubyClass getType() {
        return this.metaClass.getRealClass();
    }

    @Override
    public final boolean respondsTo(String name2) {
        Ruby runtime2 = this.metaClass.runtime;
        CacheEntry entry = this.metaClass.searchWithCache("respond_to?");
        DynamicMethod respondTo = entry.method;
        if (respondTo.equals(runtime2.getRespondToMethod()) && this.metaClass.searchMethod("respond_to_missing?").equals(runtime2.getRespondToMissingMethod())) {
            return this.metaClass.respondsToMethod(name2, false);
        }
        ThreadContext context = runtime2.getCurrentContext();
        RubySymbol mname = Convert.asSymbol(context, name2);
        if (respondTo.isUndefined()) {
            return RubyBasicObject.sites((ThreadContext)context).respond_to.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)mname).isTrue();
        }
        return respondTo.callRespondTo(context, this, "respond_to?", entry.sourceModule, mname);
    }

    @Override
    public final boolean respondsToMissing(String name2) {
        return this.respondsToMissing(name2, true);
    }

    @Override
    public final boolean respondsToMissing(String name2, boolean incPrivate) {
        CacheEntry entry = this.metaClass.searchWithCache("respond_to_missing?");
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return false;
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        return method2.call(context, (IRubyObject)this, entry.sourceModule, "respond_to_missing?", (IRubyObject)Convert.asSymbol(context, name2), incPrivate ? context.tru : context.fals).isTrue();
    }

    @Override
    public final Ruby getRuntime() {
        return this.metaClass.runtime;
    }

    @Deprecated(since="10.0.0.0")
    public final ThreadContext getCurrentContext() {
        return this.getRuntime().getCurrentContext();
    }

    @Override
    public Class<?> getJavaClass() {
        Object obj = JavaUtil.unwrapJava(this.dataGetStruct(), null);
        return obj != null ? obj.getClass() : this.getClass();
    }

    @Override
    public String asJavaString() {
        IRubyObject str = this.checkStringType();
        if (str.isNil()) {
            throw Error.typeError(this.getRuntime().getCurrentContext(), (IRubyObject)this, "String");
        }
        return str.asJavaString();
    }

    @Override
    public RubyString asString() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        IRubyObject str = sites.to_s.call(context, this, this);
        if (!(str instanceof RubyString)) {
            return Convert.anyToString(context, this);
        }
        return (RubyString)str;
    }

    @Override
    public RubyArray convertToArray() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        return (RubyArray)TypeConverter.convertToType(context, this, Access.arrayClass(context), RubyBasicObject.sites((ThreadContext)context).to_ary_checked);
    }

    @Override
    public RubyHash convertToHash() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        return (RubyHash)TypeConverter.convertToType(context, this, Access.hashClass(context), RubyBasicObject.sites((ThreadContext)context).to_hash_checked);
    }

    @Override
    public RubyFloat convertToFloat() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return (RubyFloat)TypeConverter.convertToType(context, this, runtime2.getFloat(), sites.to_f_checked);
    }

    @Override
    public RubyInteger convertToInteger() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        IRubyObject result2 = TypeConverter.convertToType(context, (IRubyObject)this, Access.integerClass(context), sites.to_int_checked, true);
        if (!(result2 instanceof RubyInteger)) {
            throw Error.typeError(context, "", this, "#to_int should return Integer");
        }
        return (RubyInteger)result2;
    }

    @Override
    public RubyInteger convertToInteger(String convertMethod) {
        IRubyObject result2;
        if (convertMethod.equals("to_int")) {
            return this.convertToInteger();
        }
        Ruby runtime2 = this.metaClass.runtime;
        if (convertMethod.equals("to_i")) {
            ThreadContext context = runtime2.getCurrentContext();
            JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
            result2 = TypeConverter.convertToType(context, (IRubyObject)this, runtime2.getInteger(), sites.to_i_checked, true);
        } else {
            result2 = TypeConverter.convertToType((IRubyObject)this, runtime2.getInteger(), convertMethod, true);
        }
        if (!(result2 instanceof RubyInteger)) {
            throw Error.typeError(runtime2.getCurrentContext(), RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, (RubyModule)this.getMetaClass()), "#", RubyStringBuilder.ids(runtime2, convertMethod), " should return Integer"));
        }
        return (RubyInteger)result2;
    }

    @Override
    public RubyString convertToString() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return (RubyString)TypeConverter.convertToType(context, this, Access.stringClass(context), sites.to_str_checked);
    }

    @Override
    public IRubyObject anyToString() {
        Ruby runtime2 = this.metaClass.runtime;
        return Convert.anyToString(runtime2.getCurrentContext(), this);
    }

    public RubyString decode(String id) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        return (RubyString)Convert.asSymbol(context, id).to_s(context);
    }

    @Override
    public IRubyObject checkStringType() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return TypeConverter.checkStringType(context, sites.to_str_checked, this);
    }

    @Override
    public IRubyObject checkArrayType() {
        Ruby runtime2 = this.metaClass.runtime;
        ThreadContext context = runtime2.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return TypeConverter.checkArrayType(context, sites.to_ary_checked, this);
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        return this.defaultToJava(target2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T defaultToJava(Class<T> target2) {
        if (target2 == Void.TYPE) {
            return null;
        }
        Object value2 = this.unwrap_java_object();
        if (value2 != null) {
            if (target2.isAssignableFrom(value2.getClass())) {
                this.getRuntime().getJavaSupport().getObjectProxyCache().put(value2, this);
                return (T)value2;
            }
        } else {
            if (JavaUtil.isDuckTypeConvertable(this.getClass(), target2)) {
                RubyBasicObject rubyBasicObject = this;
                synchronized (rubyBasicObject) {
                    if (this.unwrap_java_object() != null) {
                        return this.defaultToJava(target2);
                    }
                    return JavaUtil.convertProcToInterface(this.getRuntime().getCurrentContext(), this, target2);
                }
            }
            if (!target2.isAssignableFrom(this.getClass())) {
                throw Error.typeError(this.getRuntime().getCurrentContext(), "cannot convert instance of ", this, " to " + String.valueOf(target2));
            }
        }
        return (T)this;
    }

    private Object unwrap_java_object() {
        Object innerWrapper = this.dataGetStruct();
        if (innerWrapper instanceof JavaProxy) {
            return ((JavaProxy)innerWrapper).getObject();
        }
        return null;
    }

    @Override
    public IRubyObject dup() {
        if (this.isSpecialObject()) {
            return this;
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        IRubyObject dup2 = this.metaClass.getRealClass().allocate(context);
        RubyBasicObject.initCopy(context, dup2, this);
        RubyBasicObject.sites((ThreadContext)context).initialize_dup.call(context, dup2, dup2, (IRubyObject)this);
        return dup2;
    }

    private static void initCopy(ThreadContext context, IRubyObject clone2, IRubyObject original) {
        assert (!clone2.isFrozen()) : "frozen object (" + clone2.getMetaClass().getName(context) + ") allocated";
        original.copySpecialInstanceVariables(clone2);
        if (original.hasVariables()) {
            clone2.syncVariables(original);
            ((RubyBasicObject)clone2).dupFinalizer(context);
        }
        if (original instanceof RubyModule) {
            RubyModule cloneMod = (RubyModule)clone2;
            cloneMod.syncConstants((RubyModule)original);
            cloneMod.syncClassVariables((RubyModule)original);
        }
    }

    protected static boolean OBJ_INIT_COPY(IRubyObject obj, IRubyObject orig) {
        if (obj == orig) {
            return false;
        }
        RubyBasicObject.objInitCopy(obj, orig);
        return true;
    }

    protected static void objInitCopy(IRubyObject obj, IRubyObject orig) {
        if (obj == orig) {
            return;
        }
        ((RubyBasicObject)obj).checkFrozen();
        if (obj.getClass() != orig.getClass() || obj.getMetaClass().getRealClass() != orig.getMetaClass().getRealClass()) {
            throw Error.typeError(obj.getRuntime().getCurrentContext(), "initialize_copy should take same class object");
        }
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
    }

    @Override
    public IRubyObject rbClone() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        return this.rbCloneInternal(context, context.nil);
    }

    public IRubyObject rbClone(ThreadContext context, IRubyObject maybeOpts) {
        IRubyObject kwfreeze = ArgsUtil.getFreezeOpt(context, maybeOpts);
        return this.rbCloneInternal(context, kwfreeze);
    }

    protected RubyBasicObject dupSetup(ThreadContext context, RubyBasicObject dup2) {
        RubyBasicObject.initCopy(context, dup2, this);
        RubyBasicObject.sites((ThreadContext)context).initialize_dup.call(context, (IRubyObject)dup2, (IRubyObject)dup2, (IRubyObject)this);
        return dup2;
    }

    protected RubyBasicObject cloneSetup(ThreadContext context, RubyBasicObject clone2, IRubyObject freeze2) {
        clone2.setMetaClass(this.getSingletonClassCloneAndAttach(context, clone2));
        RubyBasicObject.initCopy(context, clone2, this);
        if (freeze2 == context.nil) {
            RubyString str;
            RubyBasicObject.sites((ThreadContext)context).initialize_clone.call(context, (IRubyObject)clone2, (IRubyObject)clone2, (IRubyObject)this);
            RubyBasicObject rubyBasicObject = this;
            if (rubyBasicObject instanceof RubyString && (str = (RubyString)rubyBasicObject).isChilled()) {
                if (str.isChilledLiteral()) {
                    ((RubyString)clone2).chill();
                } else {
                    ((RubyString)clone2).chill_symbol_string();
                }
            } else if (this.isFrozen()) {
                clone2.setFrozen(true);
            }
        } else {
            RubyHash opts = RubyHash.newHash(context.runtime, Convert.asSymbol(context, "freeze"), freeze2);
            context.callInfo = 2;
            RubyBasicObject.sites((ThreadContext)context).initialize_clone.call(context, (IRubyObject)clone2, (IRubyObject)clone2, (IRubyObject)this, (IRubyObject)opts);
            if (freeze2 == context.tru) {
                clone2.freeze(context);
            }
            if (clone2.getMetaClass().isSingleton()) {
                clone2.getMetaClass().setFrozen(clone2.isFrozen());
            }
        }
        return clone2;
    }

    private RubyBasicObject rbCloneInternal(ThreadContext context, IRubyObject freeze2) {
        if (this.isSpecialObject()) {
            if (freeze2 == context.fals) {
                throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "can't unfreeze ", RubyStringBuilder.types(context.runtime, (RubyModule)this.getType())));
            }
            return this;
        }
        RubyBasicObject clone2 = (RubyBasicObject)this.metaClass.getRealClass().allocate(context);
        return this.cloneSetup(context, clone2, freeze2);
    }

    @Deprecated(since="10.0.0.0")
    protected RubyClass getSingletonClassClone() {
        return this.getSingletonClassCloneAndAttach(null);
    }

    @Deprecated(since="10.0.0.0")
    protected RubyClass getSingletonClassCloneAndAttach(RubyBasicObject attach2) {
        return this.getSingletonClassCloneAndAttach(this.getCurrentContext(), attach2);
    }

    protected RubyClass getSingletonClassCloneAndAttach(ThreadContext context, RubyBasicObject attach2) {
        RubyClass klass = this.getMetaClass();
        if (!klass.isSingleton()) {
            return klass;
        }
        MetaClass clone2 = new MetaClass(context.runtime, klass.getSuperClass(), attach2);
        clone2.flags = klass.flags;
        clone2.setMetaClass(this instanceof RubyClass ? clone2 : klass.getSingletonClassCloneAndAttach(context, null));
        if (klass.hasVariables()) {
            clone2.syncVariables(klass);
        }
        clone2.syncConstants(klass);
        klass.cloneMethods(context, clone2);
        ((MetaClass)clone2.getMetaClass()).setAttached(clone2);
        return clone2;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public void dataWrapStruct(Object obj) {
        if (obj == null) {
            this.removeInternalVariable("__wrap_struct__");
        } else {
            this.fastSetInternalVariable("__wrap_struct__", obj);
        }
    }

    @Override
    public Object dataGetStruct() {
        return this.getInternalVariable("__wrap_struct__");
    }

    @Override
    @Deprecated
    public IRubyObject id() {
        return this.getRuntime().newFixnum(this.getObjectId());
    }

    @Override
    @JRubyMethod(name={"__id__"})
    public RubyInteger __id__(ThreadContext context) {
        return Convert.asFixnum(context, this.getObjectId());
    }

    protected long getObjectId() {
        return this.metaClass.getRealClass().getVariableTableManager().getObjectId(this);
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public IRubyObject inspect() {
        return this.inspect(this.getCurrentContext());
    }

    @Override
    public IRubyObject inspect(ThreadContext context) {
        return !this.isImmediate() && !(this instanceof RubyModule) && this.hasVariables() ? this.hashyInspect() : this.to_s(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IRubyObject hashyInspect() {
        Ruby runtime2 = this.getRuntime();
        RubyString part = Inspector.inspectPrefix(runtime2.getCurrentContext(), this.metaClass.getRealClass(), this.inspectHashCode());
        if (runtime2.isInspecting(this)) {
            EncodingUtils.encStrBufCat(runtime2, part, Inspector.SPACE_DOT_DOT_DOT_GT);
            return part;
        }
        try {
            runtime2.registerInspecting(this);
            RubyString rubyString = this.inspectObj(runtime2, part);
            return rubyString;
        }
        finally {
            runtime2.unregisterInspecting(this);
        }
    }

    public static IRubyObject rbInspect(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.runtime;
        RubyString str = RubyBasicObject.sites((ThreadContext)context).inspect.call(context, obj, obj).asString();
        Encoding enc = runtime2.getDefaultInternalEncoding();
        if (enc == null) {
            enc = runtime2.getDefaultExternalEncoding();
        }
        if (!enc.isAsciiCompatible()) {
            if (!str.isAsciiOnly()) {
                return RubyString.rbStrEscape(context, str);
            }
            return str;
        }
        if (str.getEncoding() != enc && !str.isAsciiOnly()) {
            return RubyString.rbStrEscape(context, str);
        }
        return str;
    }

    protected int inspectHashCode() {
        return System.identityHashCode(this);
    }

    private RubyString inspectObj(Ruby runtime2, RubyString part) {
        ThreadContext context = runtime2.getCurrentContext();
        boolean first2 = true;
        for (Map.Entry<String, VariableAccessor> entry : this.metaClass.getVariableTableManager().getVariableAccessorsForRead().entrySet()) {
            RubySymbol symbol;
            Object value2 = entry.getValue().get(this);
            if (!(value2 instanceof IRubyObject) || !(symbol = Convert.asSymbol(context, entry.getKey())).validInstanceVariableName()) continue;
            IRubyObject obj = (IRubyObject)value2;
            if (!first2) {
                EncodingUtils.encStrBufCat(runtime2, part, Inspector.COMMA);
            }
            EncodingUtils.encStrBufCat(runtime2, part, Inspector.SPACE);
            EncodingUtils.encStrBufCat(runtime2, part, symbol.asString().encode(context, Access.encodingService(context).convertEncodingToRubyEncoding(part.getEncoding())).asString().getByteList());
            EncodingUtils.encStrBufCat(runtime2, part, Inspector.EQUALS);
            EncodingUtils.encStrBufCat(runtime2, part, RubyBasicObject.sites((ThreadContext)context).inspect.call(context, obj, obj).convertToString().getByteList());
            first2 = false;
        }
        EncodingUtils.encStrBufCat(runtime2, part, Inspector.GT);
        return part;
    }

    @JRubyMethod(name={"!"})
    public IRubyObject op_not(ThreadContext context) {
        return Convert.asBoolean(context, !this.isTrue());
    }

    @JRubyMethod(name={"!="})
    public IRubyObject op_not_equal(ThreadContext context, IRubyObject other) {
        return Convert.asBoolean(context, !RubyBasicObject.sites((ThreadContext)context).op_equal.call(context, (IRubyObject)this, (IRubyObject)this, other).isTrue());
    }

    @Override
    public int compareTo(IRubyObject other) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        IRubyObject cmp2 = Helpers.invokedynamic(context, (IRubyObject)this, MethodNames.OP_CMP, other);
        if (!cmp2.isNil()) {
            return Convert.toInt(context, cmp2);
        }
        return 0;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return Convert.asBoolean(context, this == obj);
    }

    @Override
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return context.nil;
    }

    protected static boolean equalInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        return that == other || Helpers.invokedynamic(context, that, MethodNames.OP_EQUAL, other).isTrue();
    }

    protected static boolean eqlInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        return that == other || Helpers.invokedynamic(context, that, MethodNames.EQL, other).isTrue();
    }

    @Override
    public boolean eql(IRubyObject other) {
        return Helpers.invokedynamic(this.metaClass.runtime.getCurrentContext(), (IRubyObject)this, MethodNames.EQL, other).isTrue();
    }

    @Override
    @Deprecated(since="9.4.10.0")
    public void addFinalizer(IRubyObject f) {
        this.addFinalizer(this.getRuntime().getCurrentContext(), f);
    }

    @Override
    public IRubyObject addFinalizer(ThreadContext context, IRubyObject f) {
        Finalizer finalizer = (Finalizer)this.getInternalVariable("__finalizer__");
        if (finalizer == null) {
            IRubyObject fixnumId = this.registerWithObjectSpace(context);
            finalizer = new Finalizer(fixnumId);
            this.setInternalVariable("__finalizer__", finalizer);
            context.runtime.addFinalizer(finalizer);
        }
        return finalizer.addFinalizer(context, f);
    }

    private IRubyObject registerWithObjectSpace(ThreadContext context) {
        long id = this.getObjectId();
        RubyInteger fixnumId = this.__id__(context);
        this.getRuntime().getObjectSpace().registerObjectId(id, this);
        return fixnumId;
    }

    protected void dupFinalizer(ThreadContext context) {
        Finalizer finalizer = (Finalizer)this.getInternalVariable("__finalizer__");
        if (finalizer != null) {
            IRubyObject fixnumId = this.registerWithObjectSpace(context);
            finalizer = new Finalizer(fixnumId, finalizer);
            this.setInternalVariable("__finalizer__", finalizer);
            this.getRuntime().addFinalizer(finalizer);
        }
    }

    @Override
    public void removeFinalizers() {
        this.checkFrozen();
        Finalizer finalizer = (Finalizer)this.getInternalVariable("__finalizer__");
        if (finalizer != null) {
            finalizer.removeFinalizers();
            this.removeInternalVariable("__finalizer__");
            this.getRuntime().removeFinalizer(finalizer);
        }
    }

    @Override
    public Object getVariable(int index2) {
        return VariableAccessor.getVariable(this, index2);
    }

    @Override
    public void setVariable(int index2, Object value2) {
        this.ensureInstanceVariablesSettable();
        if (index2 < 0) {
            return;
        }
        this.metaClass.getVariableTableManager().setVariableInternal(this, index2, value2);
    }

    public final Object getFFIHandle() {
        return this.metaClass.getVariableTableManager().getFFIHandle(this);
    }

    public final void setFFIHandle(Object value2) {
        this.metaClass.getVariableTableManager().setFFIHandle(this, value2);
    }

    @Override
    public boolean hasVariables() {
        return this.metaClass.getVariableTableManager().hasVariables(this);
    }

    protected boolean hasInstanceVariables() {
        return this.metaClass.getVariableTableManager().hasInstanceVariables(this);
    }

    @Override
    public List<Variable<Object>> getVariableList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<Variable<Object>> list2 = new ArrayList<Variable<Object>>(ivarAccessors.size());
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            Object value2 = entry.getValue().get(this);
            if (value2 == null) continue;
            list2.add(new VariableEntry<Object>(entry.getKey(), value2));
        }
        return list2;
    }

    @Override
    public List<Variable<Object>> getMarshalVariableList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<Variable<Object>> list2 = new ArrayList<Variable<Object>>(ivarAccessors.size());
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            Object value2 = entry.getValue().get(this);
            if (value2 == null || !(value2 instanceof Serializable)) continue;
            list2.add(new VariableEntry<Object>(entry.getKey(), value2));
        }
        return list2;
    }

    @Override
    public List<String> getVariableNameList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<String> list2 = new ArrayList<String>(ivarAccessors.size());
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            Object value2 = entry.getValue().get(this);
            if (value2 == null) continue;
            list2.add(entry.getKey());
        }
        return list2;
    }

    protected boolean variableTableContains(String name2) {
        return this.metaClass.getVariableAccessorForRead(name2).get(this) != null;
    }

    protected Object variableTableFetch(String name2) {
        return this.metaClass.getVariableAccessorForRead(name2).get(this);
    }

    protected Object variableTableStore(String name2, Object value2) {
        this.metaClass.getVariableAccessorForWrite(name2).set(this, value2);
        return value2;
    }

    protected Object variableTableRemove(String name2) {
        return this.metaClass.getVariableTableManager().clearVariable(this, name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void variableTableSync(List<Variable<Object>> vars) {
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            for (Variable<Object> var : vars) {
                this.variableTableStore(var.getName(), var.getValue());
            }
        }
    }

    @Override
    public InternalVariables getInternalVariables() {
        return this;
    }

    @Override
    public boolean hasInternalVariable(String name2) {
        assert (!IdUtil.isRubyVariable(name2));
        return this.variableTableContains(name2);
    }

    @Override
    public Object getInternalVariable(String name2) {
        assert (!IdUtil.isRubyVariable(name2));
        return this.variableTableFetch(name2);
    }

    @Override
    public void setInternalVariable(String name2, Object value2) {
        assert (!IdUtil.isRubyVariable(name2));
        this.variableTableStore(name2, value2);
    }

    @Override
    public Object removeInternalVariable(String name2) {
        assert (!IdUtil.isRubyVariable(name2));
        return this.variableTableRemove(name2);
    }

    @Override
    public void syncVariables(IRubyObject other) {
        this.metaClass.getVariableTableManager().syncVariables(this, other);
    }

    @Override
    public InstanceVariables getInstanceVariables() {
        return this;
    }

    @Override
    public boolean hasInstanceVariable(String name2) {
        return this.variableTableContains(name2);
    }

    @Override
    public IRubyObject getInstanceVariable(String name2) {
        return (IRubyObject)this.variableTableFetch(name2);
    }

    @Override
    public IRubyObject setInstanceVariable(String name2, IRubyObject value2) {
        assert (value2 != null);
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableStore(name2, value2);
    }

    @Override
    public IRubyObject removeInstanceVariable(String name2) {
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableRemove(name2);
    }

    @Override
    public List<Variable<IRubyObject>> getInstanceVariableList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>(ivarAccessors.size());
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            String key2 = entry.getKey();
            Object value2 = entry.getValue().get(this);
            if (!(value2 instanceof IRubyObject) || !IdUtil.isInstanceVariable(key2)) continue;
            list2.add(new VariableEntry<IRubyObject>(key2, (IRubyObject)value2));
        }
        return list2;
    }

    @Override
    public List<String> getInstanceVariableNameList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<String> list2 = new ArrayList<String>(ivarAccessors.size());
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            String key2 = entry.getKey();
            Object value2 = entry.getValue().get(this);
            if (!(value2 instanceof IRubyObject) || !IdUtil.isInstanceVariable(key2)) continue;
            list2.add(key2);
        }
        return list2;
    }

    @Override
    public void forEachInstanceVariableName(Consumer<String> consumer) {
        this.metaClass.getVariableAccessorsForRead().forEach((name2, var) -> {
            if (IdUtil.isInstanceVariable(name2) && var.get(this) instanceof IRubyObject) {
                consumer.accept((String)name2);
            }
        });
    }

    @Override
    public void copyInstanceVariablesInto(InstanceVariables other) {
        this.forEachInstanceVariable(other::setInstanceVariable);
    }

    public void ensureInstanceVariablesSettable() {
        if (this.isFrozen()) {
            this.raiseFrozenError();
        }
    }

    @Override
    public void forEachInstanceVariable(BiConsumer<String, IRubyObject> accessor) {
        this.metaClass.getVariableAccessorsForRead().forEach((name2, var) -> {
            Object patt0$temp;
            if (IdUtil.isInstanceVariable(name2) && (patt0$temp = var.get(this)) instanceof IRubyObject) {
                IRubyObject rubyObject = (IRubyObject)patt0$temp;
                accessor.accept((String)name2, rubyObject);
            }
        });
    }

    private void raiseFrozenError() throws RaiseException {
        if (this instanceof RubyModule) {
            throw this.getRuntime().newFrozenError("class/module ", this);
        }
        throw this.getRuntime().newFrozenError(this);
    }

    @Override
    @Deprecated(since="9.0.0.0")
    public final int getNativeTypeIndex() {
        return this.getNativeClassIndex().ordinal();
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.BASICOBJECT;
    }

    public boolean isBuiltin(String methodName) {
        return this.metaClass.isMethodBuiltin(methodName);
    }

    @JRubyMethod(name={"singleton_method_added"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_added(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.nil;
    }

    @JRubyMethod(name={"singleton_method_removed"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_removed(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.nil;
    }

    @JRubyMethod(name={"singleton_method_undefined"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_undefined(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.nil;
    }

    @JRubyMethod(name={"method_missing"}, rest=true, module=true, omit=true, visibility=Visibility.PRIVATE)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        Visibility lastVis = context.getLastVisibility();
        CallType lastCallType = context.getLastCallType();
        if (args2.length == 0 || !((iRubyObject = args2[0]) instanceof RubySymbol)) {
            throw Error.argumentError(context, "no id given");
        }
        RubySymbol sym = (RubySymbol)iRubyObject;
        return RubyKernel.methodMissingDirect(context, recv2, sym, lastVis, lastCallType, args2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject send(ThreadContext context, Block block) {
        throw context.runtime.newArgumentError(0, 1);
    }

    @JRubyMethod(name={"__send__"}, omit=true, keywords=true)
    public IRubyObject send(ThreadContext context, IRubyObject arg0, Block block) {
        String name2 = RubySymbol.idStringFromObject(context, arg0);
        StaticScope staticScope = context.getCurrentStaticScope();
        return this.getMetaClass().finvokeWithRefinements(context, this, staticScope, name2, block);
    }

    @JRubyMethod(name={"__send__"}, omit=true, keywords=true)
    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        String name2 = RubySymbol.idStringFromObject(context, arg0);
        StaticScope staticScope = context.getCurrentStaticScope();
        arg1 = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, arg1);
        return this.getMetaClass().finvokeWithRefinements(context, (IRubyObject)this, staticScope, name2, arg1, block);
    }

    @JRubyMethod(name={"__send__"}, omit=true, keywords=true)
    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        String name2 = RubySymbol.idStringFromObject(context, arg0);
        StaticScope staticScope = context.getCurrentStaticScope();
        arg2 = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, arg2);
        return this.getMetaClass().finvokeWithRefinements(context, this, staticScope, name2, arg1, arg2, block);
    }

    @JRubyMethod(name={"__send__"}, required=1, rest=true, checkArity=false, omit=true, keywords=true)
    public IRubyObject send(ThreadContext context, IRubyObject[] args2, Block block) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        int callInfo = context.callInfo;
        if (argc > 0) {
            if ((callInfo & 1) != 0) {
                IRubyObject last2 = args2[argc - 1];
                if (last2 instanceof RubyHash && ((RubyHash)last2).isRuby2KeywordHash()) {
                    if (((RubyHash)last2).isEmpty()) {
                        args2 = ArraySupport.newCopy(args2, --argc);
                    } else {
                        args2[argc - 1] = ((RubyHash)last2).dupFast(context);
                        ((RubyHash)args2[argc - 1]).setRuby2KeywordHash(false);
                        context.callInfo |= 6;
                    }
                }
            } else if (argc > 1) {
                args2[argc - 1] = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, args2[argc - 1]);
            }
        }
        String name2 = RubySymbol.idStringFromObject(context, args2[0]);
        StaticScope staticScope = context.getCurrentStaticScope();
        int length2 = argc - 1;
        args2 = length2 == 0 ? IRubyObject.NULL_ARRAY : ArraySupport.newCopy(args2, 1, length2);
        return this.getMetaClass().finvokeWithRefinements(context, (IRubyObject)this, staticScope, name2, args2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject yieldUnder(ThreadContext context, RubyModule under, IRubyObject[] args2, Block block, EvalType evalType) {
        context.preExecuteUnder(this, under, block);
        IRubyObject savedBindingSelf = block.getBinding().getSelf();
        IRubyObject savedFrameSelf = block.getBinding().getFrame().getSelf();
        Visibility savedVisibility = block.getBinding().getVisibility();
        block.getBinding().setVisibility(Visibility.PUBLIC);
        try {
            if (args2.length == 1) {
                IRubyObject valueInYield = args2[0];
                IRubyObject iRubyObject = this.setupBlock(block, evalType).yieldNonArray(context, valueInYield, this);
                return iRubyObject;
            }
            RubyArray valueInYield = RubyArray.newArrayMayCopy(context.runtime, args2);
            IRubyObject iRubyObject = this.setupBlock(block, evalType).yieldArray(context, valueInYield, this);
            return iRubyObject;
        }
        finally {
            block.getBinding().setVisibility(savedVisibility);
            block.getBinding().setSelf(savedBindingSelf);
            block.getBinding().getFrame().setSelf(savedFrameSelf);
            context.postExecuteUnder();
        }
    }

    private Block setupBlock(Block block, EvalType evalType) {
        block = block.getProcObject() == null ? block.cloneBlockForEval(this, evalType) : block.deepCloneBlockForEval(this, evalType);
        block.getBinding().setVisibility(Visibility.PUBLIC);
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject yieldUnder(ThreadContext context, RubyModule under, Block block, EvalType evalType) {
        context.preExecuteUnder(this, under, block);
        try {
            IRubyObject iRubyObject = this.setupBlock(block, evalType).yieldNonArray(context, this, this);
            return iRubyObject;
        }
        finally {
            context.postExecuteUnder();
        }
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, Block block, EvalType evalType) {
        if (!block.isGiven()) {
            throw Error.argumentError(context, 0, 1, 3);
        }
        return this.yieldUnder(context, mod, block, evalType);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg2, Block block, EvalType evalType) {
        RubyString str;
        if (block.isGiven()) {
            throw Error.argumentError(context, 1, 0);
        }
        RubyString evalStr = arg2 instanceof RubyString ? (str = (RubyString)arg2) : arg2.convertToString();
        RubyStackTraceElement singleBacktrace = context.getSingleBacktrace();
        String file2 = "(eval at " + singleBacktrace.getFileName() + ":" + singleBacktrace.getLineNumber() + ")";
        int line = 0;
        return this.evalUnder(context, mod, evalStr, file2, line, evalType);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg0, IRubyObject arg1, Block block, EvalType evalType) {
        RubyString str;
        if (block.isGiven()) {
            throw Error.argumentError(context, 2, 0);
        }
        RubyString evalStr = arg0 instanceof RubyString ? (str = (RubyString)arg0) : arg0.convertToString();
        String file2 = arg1.convertToString().asJavaString();
        int line = 0;
        return this.evalUnder(context, mod, evalStr, file2, line, evalType);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block, EvalType evalType) {
        RubyString str;
        if (block.isGiven()) {
            throw Error.argumentError(context, 2, 0);
        }
        RubyString evalStr = arg0 instanceof RubyString ? (str = (RubyString)arg0) : arg0.convertToString();
        String file2 = arg1.convertToString().asJavaString();
        int line = Convert.toInt(context, arg2) - 1;
        return this.evalUnder(context, mod, evalStr, file2, line, evalType);
    }

    @Deprecated(since="10.0.0.0")
    protected RubyModule getInstanceEvalClass() {
        return this.getInstanceEvalClass(this.getCurrentContext());
    }

    protected RubyModule getInstanceEvalClass(ThreadContext context) {
        return this.isImmediate() ? context.runtime.getDummy() : this.singletonClass(context);
    }

    public IRubyObject evalUnder(ThreadContext context, RubyModule under, RubyString src, String file2, int line, EvalType evalType) {
        return Interpreter.evalSimple(context, under, this, src, file2, line, evalType);
    }

    @JRubyMethod(name={"equal?"})
    public IRubyObject equal_p(ThreadContext context, IRubyObject other) {
        return Convert.asBoolean(context, this == other);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject eql_p(IRubyObject obj) {
        return this.eql_p(this.getCurrentContext(), obj);
    }

    public IRubyObject eql_p(ThreadContext context, IRubyObject obj) {
        return this == obj ? context.tru : context.fals;
    }

    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (this == other || Helpers.invokedynamic(context, (IRubyObject)this, MethodNames.OP_EQUAL, other).isTrue()) {
            return RubyFixnum.zero(context.runtime);
        }
        return context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject initialize_copy(IRubyObject original) {
        return this.initialize_copy(this.getCurrentContext(), original);
    }

    public IRubyObject initialize_copy(ThreadContext context, IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != original.getMetaClass().getRealClass()) {
            throw Error.typeError(context, "initialize_copy should take same class object");
        }
        return this;
    }

    public void checkFrozen() {
        this.testFrozen();
    }

    @Deprecated(since="9.2.0.0")
    public final RubyBoolean respond_to_p(IRubyObject mname) {
        return this.getRuntime().newBoolean(this.getMetaClass().respondsToMethod(mname.asJavaString(), true));
    }

    @Deprecated(since="9.2.0.0")
    public final RubyBoolean respond_to_p(IRubyObject mname, IRubyObject includePrivate) {
        String name2 = mname.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, !includePrivate.isTrue()));
    }

    final RubyBoolean respond_to_p(ThreadContext context, IRubyObject methodName, boolean includePrivate) {
        RubySymbol name2 = Check.checkID(context, methodName);
        if (this.getMetaClass().respondsToMethod(name2.idString(), !includePrivate, context.getCurrentStaticScope())) {
            return context.tru;
        }
        Ruby runtime2 = context.runtime;
        IRubyObject result2 = RubyBasicObject.sites((ThreadContext)context).respond_to_missing.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)name2, (IRubyObject)runtime2.newBoolean(includePrivate));
        return context.runtime.newBoolean(result2.isTrue());
    }

    @Deprecated(since="10.0.0.0")
    public RubyFixnum hash() {
        return this.hash(this.getCurrentContext());
    }

    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, super.hashCode());
    }

    public RubyClass type() {
        return this.getMetaClass().getRealClass();
    }

    public IRubyObject display(ThreadContext context, IRubyObject[] args2) {
        IRubyObject port = args2.length == 0 ? Access.globalVariables(context).get("$>") : args2[0];
        port.callMethod(context, "write", this);
        return context.nil;
    }

    public IRubyObject freeze(ThreadContext context) {
        this.setFrozen(true);
        RubyClass metaClass = this.getMetaClass();
        if (metaClass.isSingleton()) {
            metaClass.setFrozen(true);
        }
        return this;
    }

    public RubyBoolean frozen_p(ThreadContext context) {
        return Convert.asBoolean(context, this.isFrozen());
    }

    public RubyBoolean instance_of_p(ThreadContext context, IRubyObject type2) {
        if (this.type() == type2) {
            return context.tru;
        }
        if (!(type2 instanceof RubyModule)) {
            throw Error.typeError(context, "class or module required");
        }
        return context.fals;
    }

    public RubyBoolean kind_of_p(ThreadContext context, IRubyObject type2) {
        return Convert.asBoolean(context, Convert.castAsModule(context, type2, "class or module required").isInstance(this));
    }

    public IRubyObject methods(ThreadContext context, IRubyObject ... args2) {
        return this.methodsImpl(context, args2.length != 1 || args2[0].isTrue());
    }

    final IRubyObject methodsImpl(ThreadContext context, boolean all) {
        RubyArray<?> methods2 = Create.newArray(context);
        HashSet<String> seen = new HashSet<String>();
        RubyClass metaClass = this.getMetaClass();
        if (metaClass.isSingleton()) {
            metaClass.populateInstanceMethodNames(context, seen, methods2, Visibility.PRIVATE, false, true, false);
            if (all) {
                metaClass.getSuperClass().populateInstanceMethodNames(context, seen, methods2, Visibility.PRIVATE, false, true, true);
            }
        } else if (all) {
            metaClass.populateInstanceMethodNames(context, seen, methods2, Visibility.PRIVATE, false, true, true);
        }
        return methods2;
    }

    @Deprecated(since="9.2.0.0")
    public final IRubyObject methods(ThreadContext context, IRubyObject[] args2, boolean useSymbols) {
        return this.methodsImpl(context, args2.length == 1 ? args2[0].isTrue() : true);
    }

    public IRubyObject public_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().instanceMethods(context, args2, Visibility.PUBLIC, true, false);
    }

    public IRubyObject protected_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().instanceMethods(context, args2, Visibility.PROTECTED, true, false);
    }

    public IRubyObject private_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().instanceMethods(context, args2, Visibility.PRIVATE, true, false);
    }

    public RubyArray singleton_methods(ThreadContext context, IRubyObject[] args2) {
        Set names2;
        boolean all = args2.length != 1 || args2[0].isTrue();
        RubyClass klass = this.metaClass;
        RubyModule origin = klass.getMethodLocation();
        Set set2 = names2 = klass.isSingleton() || all ? new HashSet() : Collections.EMPTY_SET;
        if (klass.isSingleton()) {
            origin.getMethods().forEach((k, v) -> {
                if (v.getVisibility() != Visibility.PRIVATE) {
                    names2.add(Convert.asSymbol(context, k));
                }
            });
            klass = klass.getSuperClass();
        }
        if (all) {
            while (klass != null && (klass.isSingleton() || klass.isIncluded())) {
                if (klass != origin) {
                    klass.getMethods().forEach((k, v) -> {
                        if (v.getVisibility() != Visibility.PRIVATE) {
                            names2.add(Convert.asSymbol(context, k));
                        }
                    });
                }
                klass = klass.getSuperClass();
            }
        }
        if (names2.isEmpty()) {
            return Create.newEmptyArray(context);
        }
        return RubyArray.newArray(context.runtime, names2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject singleton_method(IRubyObject name2) {
        return this.singleton_method(this.getCurrentContext(), name2);
    }

    public IRubyObject singleton_method(ThreadContext context, IRubyObject name2) {
        RubySymbol symbol = Check.checkID(context, name2);
        String methodName = symbol.idString();
        RubyClass klass = this.metaClass;
        if (klass.isSingleton()) {
            CacheEntry entry = klass.searchWithCache(methodName);
            if (klass == entry.method.getDefinedClass()) {
                RubyMethod newMethod = RubyMethod.newMethod(klass, methodName, klass, methodName, entry, this);
                return newMethod;
            }
        }
        throw Error.nameError(context, RubyStringBuilder.str(context.runtime, "undefined method '", symbol, "' for '", this.inspect(context), "'"), symbol);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject method(IRubyObject name2) {
        ThreadContext context = this.getCurrentContext();
        RubySymbol symbol = Check.checkID(context, name2);
        return this.getMetaClass().newMethod(context, this, symbol.idString(), null, true, null, true, true);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject method(IRubyObject name2, StaticScope refinedScope) {
        return this.method(this.getCurrentContext(), name2, refinedScope);
    }

    public IRubyObject method(ThreadContext context, IRubyObject name2, StaticScope refinedScope) {
        return this.getMetaClass().newMethod(context, this, Check.checkID(context, name2).idString(), refinedScope, true, null, true, true);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject to_s() {
        return this.to_s(this.getCurrentContext());
    }

    public IRubyObject to_s(ThreadContext context) {
        return Convert.anyToString(context, this);
    }

    public RubyArray to_a(ThreadContext context) {
        Warn.warn(context, "default 'to_a' will be obsolete");
        return Create.newArray(context, (IRubyObject)this);
    }

    @JRubyMethod(name={"instance_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(context), block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(context), arg0, block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(context), arg0, arg1, block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(context), arg0, arg1, arg2, block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_eval"}, rest=true, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval(ThreadContext context, IRubyObject[] args2, Block block) {
        return switch (args2.length) {
            case 0 -> this.instance_eval(context, block);
            case 1 -> this.instance_eval(context, args2[0], block);
            case 2 -> this.instance_eval(context, args2[0], args2[1], block);
            case 3 -> this.instance_eval(context, args2[0], args2[1], args2[2], block);
            default -> throw Error.argumentError(context, args2.length, 1, 3);
        };
    }

    @JRubyMethod(name={"instance_exec"}, rest=true, keywords=true, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_exec(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newLocalJumpErrorNoBlock();
        }
        return this.yieldUnder(context, this.getInstanceEvalClass(context), args2, block, EvalType.INSTANCE_EVAL);
    }

    public IRubyObject extend(IRubyObject[] args2) {
        int i2;
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject arg2 = args2[i2];
            if (!arg2.isModule()) {
                throw Error.typeError(context, arg2, "Module");
            }
            if (!((RubyModule)arg2).isRefinement()) continue;
            throw Error.typeError(context, "Cannot extend object with refinement");
        }
        for (i2 = args2.length - 1; i2 >= 0; --i2) {
            args2[i2].callMethod(context, "extend_object", this);
            args2[i2].callMethod(context, "extended", this);
        }
        return this;
    }

    public IRubyObject nil_p(ThreadContext context) {
        return context.fals;
    }

    public IRubyObject op_match(ThreadContext context, IRubyObject arg2) {
        return context.nil;
    }

    public IRubyObject op_not_match(ThreadContext context, IRubyObject arg2) {
        return Convert.asBoolean(context, !RubyBasicObject.sites((ThreadContext)context).match.call(context, (IRubyObject)this, (IRubyObject)this, arg2).isTrue());
    }

    public IRubyObject instance_variable_defined_p(ThreadContext context, IRubyObject name2) {
        return Convert.asBoolean(context, this.variableTableContains(this.validateInstanceVariable(name2)));
    }

    public IRubyObject instance_variable_get(ThreadContext context, IRubyObject name2) {
        Object value2 = this.variableTableFetch(this.validateInstanceVariable(name2));
        return value2 != null ? (IRubyObject)value2 : context.nil;
    }

    public IRubyObject instance_variable_set(IRubyObject name2, IRubyObject value2) {
        return (IRubyObject)this.variableTableStore(this.validateInstanceVariable(name2), value2);
    }

    public IRubyObject remove_instance_variable(ThreadContext context, IRubyObject name2, Block block) {
        String id = this.validateInstanceVariable(name2);
        this.ensureInstanceVariablesSettable();
        IRubyObject value2 = (IRubyObject)this.variableTableRemove(id);
        if (value2 != null) {
            return value2;
        }
        throw context.runtime.newNameError("instance variable %1$s not defined", (IRubyObject)this, name2);
    }

    public RubyArray instance_variables(ThreadContext context) {
        RubyArray<?> array2 = Create.allocArray(context, this.getMetaClass().getVariableAccessorsForRead().size());
        this.forEachInstanceVariableName(name2 -> array2.append(context, Convert.asSymbol(context, name2)));
        return array2;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IRubyObject) {
            ThreadContext context = this.metaClass.runtime.getCurrentContext();
            JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
            IRubyObject equals = Helpers.invokeChecked(context, (IRubyObject)this, sites.equals_checked, (IRubyObject)other);
            if (equals == null) {
                return false;
            }
            return equals.isTrue();
        }
        return false;
    }

    public int hashCode() {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        IRubyObject hashValue = Helpers.invokeChecked(context, (IRubyObject)this, RubyBasicObject.sites((ThreadContext)context).hash_checked);
        if (hashValue == null) {
            return super.hashCode();
        }
        if (hashValue instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)hashValue;
            return (int)fixnum.getValue();
        }
        return RubyBasicObject.nonFixnumHashCode(context, hashValue);
    }

    @Deprecated(since="10.0.0.0")
    protected static int nonFixnumHashCode(IRubyObject hashValue) {
        return RubyBasicObject.nonFixnumHashCode(hashValue.getRuntime().getCurrentContext(), hashValue);
    }

    protected static int nonFixnumHashCode(ThreadContext context, IRubyObject hashValue) {
        if (hashValue.isNil()) {
            throw Error.typeError(context, "no implicit conversion from nil to integer");
        }
        return ((RubyInteger)TypeConverter.convertToType(hashValue, Access.integerClass(context), "to_int")).asInt(context);
    }

    @Deprecated(since="9.2.0.0")
    protected String validateInstanceVariable(String name2) {
        if (IdUtil.isValidInstanceVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("'%1$s' is not allowable as an instance variable name", (IRubyObject)this, name2);
    }

    @Deprecated(since="9.2.0.0")
    protected String validateInstanceVariable(IRubyObject name2, String _unused_) {
        return this.validateInstanceVariable(name2);
    }

    protected String validateInstanceVariable(IRubyObject name2) {
        return RubySymbol.retrieveIDSymbol(name2, (sym, newSym) -> {
            if (!sym.validInstanceVariableName()) {
                throw this.getRuntime().newNameError("'%1$s' is not allowable as an instance variable name", (IRubyObject)this, name2);
            }
        }).idString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.metaClass.isSingleton()) {
            throw new IOException("can not serialize singleton object");
        }
        oos.defaultWriteObject();
        oos.writeUTF(this.metaClass.getName(this.metaClass.getRuntime().getCurrentContext()));
        this.metaClass.getVariableTableManager().serializeVariables(this, oos);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Ruby ruby = Ruby.getThreadLocalRuntime();
        if (ruby == null) {
            throw new IOException("No thread-local org.jruby.Ruby available; can't deserialize Ruby object. Set with Ruby#setThreadLocalRuntime.");
        }
        ois.defaultReadObject();
        this.metaClass = (RubyClass)ruby.getClassFromPath(ois.readUTF());
        this.metaClass.getVariableTableManager().deserializeVariables(this, ois);
    }

    private static JavaSites.BasicObjectSites sites(ThreadContext context) {
        return context.sites.BasicObject;
    }

    @Deprecated(since="1.7.0")
    protected RubyBasicObject(Ruby runtime2, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        this(runtime2, metaClass, useObjectSpace);
    }

    @Override
    @Deprecated(since="1.7.0")
    public IRubyObject callSuper(ThreadContext context, IRubyObject[] args2, Block block) {
        return Helpers.invokeSuper(context, (IRubyObject)this, args2, block);
    }

    @Override
    @Deprecated(since="1.7.0")
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2) {
        return Helpers.invoke(context, this, name2);
    }

    @Override
    @Deprecated(since="1.7.0")
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2, IRubyObject arg2) {
        return Helpers.invoke(context, (IRubyObject)this, name2, arg2, Block.NULL_BLOCK);
    }

    @Override
    @Deprecated(since="1.7.0")
    public RubyInteger convertToInteger(int methodIndex, String convertMethod) {
        return this.convertToInteger(convertMethod);
    }

    @Override
    @Deprecated(since="1.7.0")
    public int getVariableCount() {
        return this.getMetaClass().getVariableTableSize();
    }

    @Deprecated(since="1.7.0")
    protected boolean variableTableFastContains(String internedName) {
        return this.variableTableContains(internedName);
    }

    @Deprecated(since="1.7.0")
    protected Object variableTableFastFetch(String internedName) {
        return this.variableTableFetch(internedName);
    }

    @Deprecated(since="1.7.0")
    protected Object variableTableFastStore(String internedName, Object value2) {
        return this.variableTableStore(internedName, value2);
    }

    @Override
    @Deprecated(since="1.7.0")
    public boolean fastHasInternalVariable(String internedName) {
        return this.hasInternalVariable(internedName);
    }

    @Override
    @Deprecated(since="1.7.0")
    public Object fastGetInternalVariable(String internedName) {
        return this.getInternalVariable(internedName);
    }

    @Override
    @Deprecated(since="1.7.0")
    public void fastSetInternalVariable(String internedName, Object value2) {
        this.setInternalVariable(internedName, value2);
    }

    @Override
    @Deprecated(since="1.7.0")
    public void syncVariables(List<Variable<Object>> variables) {
        this.variableTableSync(variables);
    }

    @Override
    @Deprecated(since="1.7.0")
    public boolean fastHasInstanceVariable(String internedName) {
        return this.hasInstanceVariable(internedName);
    }

    @Override
    @Deprecated(since="1.7.0")
    public IRubyObject fastGetInstanceVariable(String internedName) {
        return this.getInstanceVariable(internedName);
    }

    @Override
    @Deprecated(since="1.7.0")
    public IRubyObject fastSetInstanceVariable(String internedName, IRubyObject value2) {
        return this.setInstanceVariable(internedName, value2);
    }

    @Override
    @Deprecated(since="9.0.0.0")
    public boolean isUntrusted() {
        return false;
    }

    @Override
    @Deprecated(since="9.0.0.0")
    public void setUntrusted(boolean untrusted) {
    }

    @Deprecated(since="9.0.0.0")
    public RubyBoolean untrusted_p(ThreadContext context) {
        return context.fals;
    }

    @Deprecated(since="9.0.0.0")
    public IRubyObject untrust(ThreadContext context) {
        return this;
    }

    @Deprecated(since="9.0.0.0")
    public IRubyObject trust(ThreadContext context) {
        return this;
    }

    @Deprecated(since="9.0.0.0")
    public final Object getNativeHandle() {
        return null;
    }

    @Deprecated(since="9.0.0.0")
    public final void setNativeHandle(Object value2) {
    }

    @Override
    @Deprecated(since="9.2.0.0")
    public synchronized Object dataGetStructChecked() {
        TypeConverter.checkData(this);
        return this.getInternalVariable("__wrap_struct__");
    }

    @Deprecated(since="9.2.10.0")
    public RubyArray to_a() {
        return this.to_a(this.getRuntime().getCurrentContext());
    }

    @Deprecated(since="9.4.0.0")
    public RubyBoolean tainted_p(ThreadContext context) {
        return context.fals;
    }

    @Deprecated(since="9.4.0.0")
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    @Deprecated(since="9.4.0.0")
    IRubyObject tainted() {
        return this;
    }

    @Deprecated(since="9.4.0.0")
    protected final void taint(Ruby runtime2) {
    }

    @Deprecated(since="9.4.0.0")
    public IRubyObject untaint(ThreadContext context) {
        return this;
    }

    @Override
    @Deprecated(since="9.4.0.0")
    public boolean isTaint() {
        return false;
    }

    @Override
    @Deprecated(since="9.4.0.0")
    public void setTaint(boolean taint2) {
    }

    @Override
    @Deprecated(since="9.4.0.0")
    public IRubyObject infectBy(IRubyObject obj) {
        return this;
    }

    @Deprecated(since="9.4.0.0")
    final RubyBasicObject infectBy(RubyBasicObject obj) {
        return this;
    }

    @Deprecated(since="9.4.0.0")
    final RubyBasicObject infectBy(int tuFlags) {
        return this;
    }

    public static class Finalizer
    implements Finalizable {
        private final IRubyObject id;
        private final AtomicBoolean finalized;
        private IRubyObject firstFinalizer;
        private List<IRubyObject> finalizers;

        public Finalizer(RubyFixnum id) {
            this((IRubyObject)id);
        }

        public Finalizer(IRubyObject id, Finalizer original) {
            this(id);
            this.firstFinalizer = original.firstFinalizer;
            this.finalizers = original.finalizers == null ? null : new ArrayList<IRubyObject>(original.finalizers);
        }

        Finalizer(IRubyObject id) {
            this.id = id;
            this.finalized = new AtomicBoolean(false);
        }

        @Deprecated(since="9.4.10.0")
        public void addFinalizer(IRubyObject finalizer) {
            this.addFinalizer(finalizer.getRuntime().getCurrentContext(), finalizer);
        }

        public IRubyObject addFinalizer(ThreadContext context, IRubyObject finalizer) {
            if (this.firstFinalizer == null) {
                this.firstFinalizer = finalizer;
                return finalizer;
            }
            IRubyObject existing = this.firstFinalizer;
            if (existing.op_equal(context, finalizer).isTrue()) {
                return existing;
            }
            if (this.finalizers == null) {
                this.finalizers = new ArrayList<IRubyObject>(4);
            } else {
                for (int i2 = 0; i2 < this.finalizers.size(); ++i2) {
                    existing = this.finalizers.get(i2);
                    if (!existing.op_equal(context, finalizer).isTrue()) continue;
                    return existing;
                }
            }
            this.finalizers.add(finalizer);
            return finalizer;
        }

        public void removeFinalizers() {
            this.firstFinalizer = null;
            this.finalizers = null;
        }

        @Override
        public void finalize() {
            if (this.finalized.compareAndSet(false, true)) {
                if (this.firstFinalizer != null) {
                    this.callFinalizer(this.firstFinalizer);
                }
                if (this.finalizers != null) {
                    for (int i2 = 0; i2 < this.finalizers.size(); ++i2) {
                        this.callFinalizer(this.finalizers.get(i2));
                    }
                }
            }
        }

        private void callFinalizer(IRubyObject finalizer) {
            ThreadContext context = finalizer.getRuntime().getCurrentContext();
            try {
                RubyBasicObject.sites((ThreadContext)context).call.call(context, finalizer, finalizer, this.id);
            }
            finally {
                context.setErrorInfo(context.nil);
            }
        }
    }
}

