/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.net.BindException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import jnr.constants.Constant;
import jnr.constants.ConstantSet;
import jnr.constants.platform.Errno;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joda.time.DateTimeZone;
import org.joni.WarnCallback;
import org.jruby.Finalizable;
import org.jruby.NativeException;
import org.jruby.ParseResult;
import org.jruby.Profile;
import org.jruby.RubyArgumentError;
import org.jruby.RubyArithmeticSequence;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyChain;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyComplex;
import org.jruby.RubyConcurrencyError;
import org.jruby.RubyContinuation;
import org.jruby.RubyConverter;
import org.jruby.RubyData;
import org.jruby.RubyDir;
import org.jruby.RubyDomainError;
import org.jruby.RubyEOFError;
import org.jruby.RubyEncoding;
import org.jruby.RubyEncodingError;
import org.jruby.RubyEnumerable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyException;
import org.jruby.RubyFatal;
import org.jruby.RubyFiberError;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyFloatDomainError;
import org.jruby.RubyFrozenError;
import org.jruby.RubyGC;
import org.jruby.RubyGenerator;
import org.jruby.RubyGlobal;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyIOBuffer;
import org.jruby.RubyIOError;
import org.jruby.RubyIndexError;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyInterrupt;
import org.jruby.RubyInterruptedRegexpError;
import org.jruby.RubyKernel;
import org.jruby.RubyKeyError;
import org.jruby.RubyLoadError;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyMarshal;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNameError;
import org.jruby.RubyNil;
import org.jruby.RubyNoMatchingPatternError;
import org.jruby.RubyNoMatchingPatternKeyError;
import org.jruby.RubyNoMemoryError;
import org.jruby.RubyNoMethodError;
import org.jruby.RubyNotImplementedError;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyProducer;
import org.jruby.RubyRandom;
import org.jruby.RubyRange;
import org.jruby.RubyRangeError;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubyRegexpError;
import org.jruby.RubyRuntimeError;
import org.jruby.RubyScriptError;
import org.jruby.RubySecurityError;
import org.jruby.RubySignal;
import org.jruby.RubySignalException;
import org.jruby.RubyStandardError;
import org.jruby.RubyStopIteration;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubySyntaxError;
import org.jruby.RubySystemCallError;
import org.jruby.RubySystemExit;
import org.jruby.RubySystemStackError;
import org.jruby.RubyThread;
import org.jruby.RubyThreadError;
import org.jruby.RubyThreadGroup;
import org.jruby.RubyTime;
import org.jruby.RubyTypeError;
import org.jruby.RubyUnboundMethod;
import org.jruby.RubyUncaughtThrowError;
import org.jruby.RubyYielder;
import org.jruby.RubyZeroDivisionError;
import org.jruby.TopSelfFactory;
import org.jruby.anno.TypePopulator;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.executable.RuntimeCache;
import org.jruby.ast.executable.Script;
import org.jruby.ast.executable.ScriptAndCode;
import org.jruby.common.RubyWarnings;
import org.jruby.compiler.Constantizable;
import org.jruby.compiler.JITCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.embed.Extension;
import org.jruby.exceptions.LocalJumpError;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.SystemExit;
import org.jruby.ext.JRubyPOSIXHandler;
import org.jruby.ext.coverage.CoverageData;
import org.jruby.ext.ffi.FFI;
import org.jruby.ext.fiber.ThreadFiber;
import org.jruby.ext.fiber.ThreadFiberLibrary;
import org.jruby.ext.jruby.JRubyUtilLibrary;
import org.jruby.ext.thread.ConditionVariable;
import org.jruby.ext.thread.Mutex;
import org.jruby.ext.thread.Queue;
import org.jruby.ext.thread.SizedQueue;
import org.jruby.ext.tracepoint.TracePoint;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.Compiler;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.runtime.IRReturnJump;
import org.jruby.java.util.ClassUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaPackage;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaSupportImpl;
import org.jruby.management.BeanManager;
import org.jruby.management.BeanManagerFactory;
import org.jruby.management.Caches;
import org.jruby.management.Config;
import org.jruby.management.InlineStats;
import org.jruby.management.Runtime;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.org.objectweb.asm.util.TraceClassVisitor;
import org.jruby.parser.Parser;
import org.jruby.parser.ParserManager;
import org.jruby.parser.ParserType;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.platform.Platform;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.Builtins;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.TraceEventManager;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.runtime.invokedynamic.InvokeDynamicSupport;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.runtime.load.CompiledScriptLoader;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.runtime.profile.ProfileCollection;
import org.jruby.runtime.profile.ProfilingService;
import org.jruby.runtime.profile.ProfilingServiceLookup;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.specialized.RubyObjectSpecializer;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.ByteList;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.ClassDefiningJRubyClassLoader;
import org.jruby.util.DefinedMessage;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.KCode;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.SecurityHelper;
import org.jruby.util.SelfFirstJRubyClassLoader;
import org.jruby.util.StrptimeParser;
import org.jruby.util.StrptimeToken;
import org.jruby.util.WeakIdentityHashMap;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.ConcurrentWeakHashMap;
import org.jruby.util.collections.IntHashMap;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.SelectorPool;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public final class Ruby
implements Constantizable {
    private static final Logger LOG = LoggerFactory.getLogger(Ruby.class);
    public static final int NIL_PREFILLED_ARRAY_SIZE = 128;
    private final IRubyObject[] nilPrefilledArray;
    private final IntHashMap<RubyClass> errnos = new IntHashMap(Errno.values().length);
    private RubyRandom defaultRandom;
    static final String ROOT_FRAME_NAME = "(root)";
    private final TraceEventManager traceEvents = new TraceEventManager(this);
    private static final Pattern ADDR_NOT_AVAIL_PATTERN = Pattern.compile("assign.*address");
    private final ThreadLocal<Map<Object, Object>> inspect = new ThreadLocal();
    private final ThreadLocal<FStringEqual> DEDUP_WRAPPER_CACHE = ThreadLocal.withInitial(FStringEqual::new);
    private final ConcurrentHashMap<String, Invalidator> constantNameInvalidators = new ConcurrentHashMap(16, 0.75f, 1);
    private final Invalidator checkpointInvalidator;
    private ThreadService threadService;
    private final short[] builtinBits = Builtins.allocate();
    private final POSIX posix;
    private POSIX nativePosix;
    private final ObjectSpace objectSpace = new ObjectSpace();
    private final RubySymbol.SymbolTable symbolTable;
    private boolean abortOnException = false;
    private boolean reportOnException = true;
    private boolean doNotReverseLookupEnabled = false;
    private volatile boolean objectSpaceEnabled;
    private boolean siphashEnabled;
    private IRubyObject regexpTimeout;
    private RubyClass regexpTimeoutError;
    private final IRubyObject topSelf;
    private RubyBinding topLevelBinding;
    private final RubyNil nilObject;
    private final IRubyObject[] singleNilArray;
    private final RubyBoolean trueObject;
    private final RubyBoolean falseObject;
    private final RubyString trueString;
    private final RubyString falseString;
    private final RubyString nilString;
    private final RubyString nilInspectString;
    private final RubyFixnum nilHash;
    private final RubyFixnum nilID;
    private final RubyFixnum trueHash;
    private final RubyFixnum trueID;
    private final RubyFixnum falseHash;
    final RubyFixnum[] fixnumCache = new RubyFixnum[2 * RubyFixnum.CACHE_OFFSET];
    final Object[] fixnumConstants = new Object[this.fixnumCache.length];
    private boolean warningsEnabled = true;
    private boolean verboseWarnings;
    private boolean verbose;
    private boolean debug;
    private IRubyObject verboseValue;
    private final Set<RubyWarnings.Category> warningCategories;
    private RubyThreadGroup defaultThreadGroup;
    private final RubyClass basicObjectClass;
    private final RubyClass objectClass;
    private final RubyClass moduleClass;
    private final RubyClass refinementClass;
    private final RubyClass classClass;
    private final RubyClass nilClass;
    private final RubyClass trueClass;
    private final RubyClass falseClass;
    private final RubyClass numericClass;
    private final RubyClass floatClass;
    private final RubyClass integerClass;
    private final RubyClass fixnumClass;
    private final RubyClass complexClass;
    private final RubyClass rationalClass;
    private final RubyClass enumeratorClass;
    private final RubyClass yielderClass;
    private final RubyClass fiberClass;
    private final RubyClass generatorClass;
    private final RubyClass chainClass;
    private final RubyClass aseqClass;
    private final RubyClass producerClass;
    private final RubyClass arrayClass;
    private final RubyClass hashClass;
    private final RubyClass rangeClass;
    private final RubyClass stringClass;
    private final RubyClass encodingClass;
    private final RubyClass converterClass;
    private final RubyClass symbolClass;
    private final RubyClass procClass;
    private final RubyClass bindingClass;
    private final RubyClass methodClass;
    private final RubyClass unboundMethodClass;
    private final RubyClass matchDataClass;
    private final RubyClass regexpClass;
    private final RubyClass timeClass;
    private final RubyClass dirClass;
    private RubyClass dateErrorClass;
    private final RubyClass fileClass;
    private final RubyClass fileStatClass;
    private final RubyClass ioClass;
    private final RubyClass ioBufferClass;
    private final RubyClass threadClass;
    private final RubyClass threadGroupClass;
    private final RubyClass continuationClass;
    private final RubyClass structClass;
    private final RubyClass exceptionClass;
    private final RubyClass dummyClass;
    private final RubyClass randomClass;
    private final RubyClass mutexClass;
    private final RubyClass conditionVariableClass;
    private final RubyClass queueClass;
    private final RubyClass closedQueueError;
    private final RubyClass sizedQueueClass;
    private final RubyClass dataClass;
    private RubyClass tmsStruct;
    private RubyClass passwdStruct;
    private RubyClass groupStruct;
    private RubyClass procStatusClass;
    private RubyClass runtimeError;
    private RubyClass frozenError;
    private RubyClass ioError;
    private RubyClass ioTimeoutError;
    private RubyClass scriptError;
    private RubyClass nameError;
    private RubyClass nameErrorMessage;
    private RubyClass noMethodError;
    private RubyClass signalException;
    private RubyClass rangeError;
    private RubyClass systemExit;
    private RubyClass localJumpError;
    private RubyClass nativeException;
    private RubyClass systemCallError;
    private RubyClass fatal;
    private RubyClass interrupt;
    private RubyClass typeError;
    private RubyClass noMatchingPatternError;
    private RubyClass noMatchingPatternKeyError;
    private RubyClass argumentError;
    private RubyClass uncaughtThrowError;
    private RubyClass indexError;
    private RubyClass stopIteration;
    private RubyClass syntaxError;
    private RubyClass standardError;
    private RubyClass loadError;
    private RubyClass notImplementedError;
    private RubyClass securityError;
    private RubyClass noMemoryError;
    private RubyClass regexpError;
    private RubyClass eofError;
    private RubyClass threadError;
    private RubyClass concurrencyError;
    private RubyClass systemStackError;
    private RubyClass zeroDivisionError;
    private RubyClass floatDomainError;
    private RubyClass mathDomainError;
    private RubyClass encodingError;
    private RubyClass encodingCompatibilityError;
    private RubyClass converterNotFoundError;
    private RubyClass undefinedConversionError;
    private RubyClass invalidByteSequenceError;
    private RubyClass fiberError;
    private RubyClass keyError;
    private RubyClass locationClass;
    private RubyClass interruptedRegexpError;
    private RubyClass bufferLockedError;
    private RubyClass bufferAllocationError;
    private RubyClass bufferAccessError;
    private RubyClass bufferInvalidatedError;
    private RubyClass bufferMaskError;
    private final RubyModule kernelModule;
    private final RubyModule comparableModule;
    private final RubyModule enumerableModule;
    private final RubyModule mathModule;
    private final RubyModule marshalModule;
    private final RubyModule fileTestModule;
    private final RubyModule gcModule;
    private final RubyModule objectSpaceModule;
    private final RubyModule processModule;
    private final RubyModule warningModule;
    private RubyModule etcModule;
    private RubyModule procUIDModule;
    private RubyModule procGIDModule;
    private RubyModule procSysModule;
    private RubyModule precisionModule;
    private RubyModule errnoModule;
    private RubyThread chdirCurrentThread;
    private RubyStackTraceElement chdirLocation;
    private DynamicMethod privateMethodMissing;
    private DynamicMethod protectedMethodMissing;
    private DynamicMethod variableMethodMissing;
    private DynamicMethod superMethodMissing;
    private DynamicMethod normalMethodMissing;
    private DynamicMethod defaultMethodMissing;
    private DynamicMethod defaultModuleMethodMissing;
    private DynamicMethod respondTo;
    private DynamicMethod respondToMissing;
    private GlobalVariable recordSeparatorVar;
    private volatile String currentDirectory;
    private volatile int currentLine = 0;
    private volatile IRubyObject argsFile;
    private final long startTime = System.currentTimeMillis();
    final RubyInstanceConfig config;
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private JavaSupport javaSupport;
    private final JRubyClassLoader jrubyClassLoader;
    public static final Module JRUBY_MODULE = Ruby.class.getModule();
    private final RubyObjectSpecializer objectSpecializer;
    private final BeanManager beanManager;
    private final InlineStats inlineStats;
    private final JITCompiler jitCompiler;
    private final Caches caches;
    private static volatile boolean securityRestricted = false;
    private final LoadService loadService;
    private final EncodingService encodingService;
    private final GlobalVariables globalVariables = new GlobalVariables(this);
    private final RubyWarnings warnings = new RubyWarnings(this);
    private final WarnCallback regexpWarnings = message2 -> this.getWarnings().warn(message2);
    private final List<ExitFunction> exitBlocks = Collections.synchronizedList(new LinkedList());
    private final List<ExitFunction> postExitBlocks = Collections.synchronizedList(new LinkedList());
    private Profile profile;
    private KCode kcode = KCode.NONE;
    private final AtomicInteger symbolLastId = new AtomicInteger(128);
    private final AtomicInteger moduleLastId = new AtomicInteger(0);
    private final ConcurrentWeakHashMap<RubyModule, Object> allModules = new ConcurrentWeakHashMap(128);
    private final Map<String, DateTimeZone> timeZoneCache = new HashMap<String, DateTimeZone>(1);
    private final Map<Finalizable, Object> finalizers = new WeakIdentityHashMap();
    private final Map<Finalizable, Object> internalFinalizers = new WeakIdentityHashMap();
    private final ReentrantLock finalizersMutex = new ReentrantLock();
    private final ReentrantLock internalFinalizersMutex = new ReentrantLock();
    private final ExecutorService executor;
    private final ExecutorService fiberExecutor;
    private final Object hierarchyLock = new Object();
    private final AtomicLong dynamicMethodSerial = new AtomicLong(1L);
    private volatile int moduleGeneration = 1;
    private static final VarHandle MODULE_GENERATION;
    private final Map<String, Map<String, String>> boundMethods = new ConcurrentHashMap<String, Map<String, String>>();
    private final SelectorPool selectorPool = new SelectorPool();
    private final RuntimeCache runtimeCache;
    public static final String ERRNO_BACKTRACE_MESSAGE = "errno backtraces disabled; run with -Xerrno.backtrace=true to enable";
    public static final String STOPIERATION_BACKTRACE_MESSAGE = "StopIteration backtraces disabled; run with -Xstop_iteration.backtrace=true to enable";
    private volatile int exceptionCount;
    private static final VarHandle EXCEPTION_COUNT;
    private volatile int backtraceCount;
    private static final VarHandle BACKTRACE_COUNT;
    private volatile int callerCount;
    private static final VarHandle CALLER_COUNT;
    private volatile int warningCount;
    private static final VarHandle WARNING_COUNT;
    private final boolean coreIsBooted;
    private final boolean runtimeIsBooted;
    private final RubyHash envObject;
    private volatile CoverageData coverageData;
    private static final VarHandle COVERAGE_DATA;
    private static volatile Ruby globalRuntime;
    private static final ThreadLocal<Ruby> threadLocalRuntime;
    final Random random;
    private static final long hashSeedK0;
    private static final long hashSeedK1;
    private final StaticScopeFactory staticScopeFactory;
    private final IRManager irManager;
    private FFI ffi;
    private final ProfilingServiceLookup profilingServiceLookup;
    private final EnumMap<DefinedMessage, RubyString> definedMessages = new EnumMap(DefinedMessage.class);
    private final EnumMap<RubyThread.Status, RubyString> threadStatuses = new EnumMap(RubyThread.Status.class);
    private IRubyObject originalStderr;
    private static final ObjectSpacer DISABLED_OBJECTSPACE;
    private static final ObjectSpacer ENABLED_OBJECTSPACE;
    private final ObjectSpacer objectSpacer;
    private final RubyArray emptyFrozenArray;
    private final RubyString emptyFrozenString;
    private final Map<FStringEqual, WeakReference<RubyString.FString>> dedupMap = new ConcurrentWeakHashMap<FStringEqual, WeakReference<RubyString.FString>>();
    private static final AtomicInteger RUNTIME_NUMBER;
    private final int runtimeNumber = RUNTIME_NUMBER.getAndIncrement();
    private final Config configBean;
    private final Runtime runtimeBean;
    private final FilenoUtil filenoUtil;
    private final Interpreter interpreter = new Interpreter();
    private final Object constant;
    private DynamicMethod baseNewMethod;
    private MethodHandle nullToNil;
    private MethodHandle nullToUndefined;
    public final ClassValue<TypePopulator> POPULATORS = new ClassValue<TypePopulator>(this){

        @Override
        protected TypePopulator computeValue(Class<?> type2) {
            return RubyModule.loadPopulatorFor(type2);
        }
    };
    public final JavaSites sites = new JavaSites();
    private final Map<Class, Consumer<RubyModule>> javaExtensionDefinitions = new WeakHashMap<Class, Consumer<RubyModule>>();
    private final Map<String, List<StrptimeToken>> strptimeFormatCache = new ConcurrentHashMap<String, List<StrptimeToken>>();
    transient RubyString tzVar;
    ParserManager parserManager;

    private Ruby(RubyInstanceConfig config2) {
        this.config = config2;
        this.threadService = new ThreadService(this);
        this.profilingServiceLookup = config2.isProfiling() ? new ProfilingServiceLookup(this) : null;
        this.constant = OptoFactory.newConstantWrapper(Ruby.class, this);
        this.jrubyClassLoader = this.initJRubyClassLoader(config2);
        this.staticScopeFactory = new StaticScopeFactory(this);
        this.beanManager = BeanManagerFactory.create(this, config2.isManagementEnabled());
        this.jitCompiler = new JITCompiler(this);
        this.irManager = new IRManager(this, config2);
        this.parserManager = new ParserManager(this);
        this.inlineStats = new InlineStats();
        this.caches = new Caches();
        this.random = this.initRandom();
        this.configBean = new Config(this);
        this.runtimeBean = new Runtime(this);
        this.registerMBeans();
        this.runtimeCache = new RuntimeCache();
        this.runtimeCache.initMethodCache(ClassIndex.MAX_CLASSES.ordinal() * MethodNames.values().length - 1);
        this.checkpointInvalidator = OptoFactory.newConstantInvalidator(this);
        this.objectSpacer = this.initObjectSpacer(config2);
        this.posix = POSIXFactory.getPOSIX(new JRubyPOSIXHandler(this), config2.isNativeEnabled());
        this.filenoUtil = new FilenoUtil(this.posix);
        this.reinitialize(false);
        this.loadService = this.config.createLoadService(this);
        this.javaSupport = this.loadJavaSupport();
        this.executor = new ThreadPoolExecutor(RubyInstanceConfig.POOL_MIN, RubyInstanceConfig.POOL_MAX, (long)RubyInstanceConfig.POOL_TTL, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory("Ruby-" + this.getRuntimeNumber() + "-Worker"));
        this.fiberExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, (long)RubyInstanceConfig.FIBER_POOL_TTL, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory("Ruby-" + this.getRuntimeNumber() + "-Fiber"));
        this.basicObjectClass = RubyClass.createBootstrapClass(this, "BasicObject", null, RubyBasicObject.BASICOBJECT_ALLOCATOR);
        this.objectClass = RubyClass.createBootstrapClass(this, "Object", this.basicObjectClass, RubyObject.OBJECT_ALLOCATOR);
        this.moduleClass = RubyClass.createBootstrapClass(this, "Module", this.objectClass, RubyModule.MODULE_ALLOCATOR);
        this.classClass = RubyClass.createBootstrapClass(this, "Class", this.moduleClass, RubyClass.CLASS_ALLOCATOR);
        this.refinementClass = RubyClass.createBootstrapClass(this, "Refinement", this.moduleClass, RubyModule.MODULE_ALLOCATOR);
        this.basicObjectClass.setMetaClass(this.classClass);
        this.objectClass.setMetaClass(this.basicObjectClass);
        this.moduleClass.setMetaClass(this.classClass);
        this.classClass.setMetaClass(this.classClass);
        this.refinementClass.setMetaClass(this.classClass);
        RubyClass metaClass = this.basicObjectClass.makeMetaClassBootstrap(this, this.classClass, this.classClass);
        metaClass = this.objectClass.makeMetaClassBootstrap(this, metaClass, this.classClass);
        metaClass = this.moduleClass.makeMetaClassBootstrap(this, metaClass, this.classClass);
        this.classClass.makeMetaClassBootstrap(this, metaClass, this.classClass);
        this.refinementClass.makeMetaClassBootstrap(this, metaClass, this.classClass);
        RubyObject.finishObjectClass(this.objectClass);
        RubyModule.finishModuleClass(this.moduleClass);
        RubyClass.finishClassClass(this, this.classClass);
        this.basicObjectClass.defineConstantBootstrap("BasicObject", this.basicObjectClass);
        this.objectClass.defineConstantBootstrap("BasicObject", this.basicObjectClass);
        this.objectClass.defineConstantBootstrap("Object", this.objectClass);
        this.objectClass.defineConstantBootstrap("Class", this.classClass);
        this.objectClass.defineConstantBootstrap("Module", this.moduleClass);
        this.objectClass.defineConstantBootstrap("Refinement", this.refinementClass);
        this.objectSpecializer = new RubyObjectSpecializer(this);
        this.kernelModule = this.defineModuleBootstrap("Kernel");
        this.topSelf = new RubyObject(this, this.objectClass);
        this.nilClass = RubyClass.newClassBootstrap(this, this.objectClass, this.classClass, "NilClass");
        this.falseClass = RubyClass.newClassBootstrap(this, this.objectClass, this.classClass, "FalseClass");
        this.trueClass = RubyClass.newClassBootstrap(this, this.objectClass, this.classClass, "TrueClass");
        this.nilObject = new RubyNil(this, this.nilClass);
        this.nilPrefilledArray = new IRubyObject[128];
        for (int i2 = 0; i2 < 128; ++i2) {
            this.nilPrefilledArray[i2] = this.nilObject;
        }
        this.singleNilArray = new IRubyObject[]{this.nilObject};
        this.falseObject = new RubyBoolean.False(this);
        this.falseObject.setFrozen(true);
        this.trueObject = new RubyBoolean.True(this);
        this.trueObject.setFrozen(true);
        this.threadService.initMainThread();
        ThreadContext context = this.getCurrentContext();
        RubyModule.finishCreateModuleClass(context, this.moduleClass);
        RubyClass.finishCreateClassClass(context, this.classClass);
        RubyKernel.finishKernelModule(context, this.kernelModule, config2);
        RubyNil.finishNilClass(context, this.nilClass);
        RubyBoolean.finishFalseClass(context, this.falseClass);
        RubyBoolean.finishTrueClass(context, this.trueClass);
        RubyModule.finishRefinementClass(context, this.refinementClass);
        RubyBasicObject.finishBasicObjectClass(context, this.basicObjectClass);
        TopSelfFactory.finishTopSelf(context, this.topSelf, this.objectClass, false);
        this.objectClass.includeModule(context, this.kernelModule);
        context.prepareTopLevel(this.objectClass, this.topSelf);
        this.comparableModule = RubyComparable.createComparable(context);
        this.enumerableModule = RubyEnumerable.createEnumerableModule(context);
        this.stringClass = RubyString.createStringClass(context, this.objectClass, this.comparableModule);
        this.emptyFrozenString = this.freezeAndDedupString(Create.newEmptyString(context));
        this.nilString = Create.newEmptyString(context);
        this.nilString.setFrozen(true);
        this.nilInspectString = this.newString(RubyNil.nil);
        this.nilInspectString.setFrozen(true);
        this.trueString = this.newString(RubyBoolean.TRUE_BYTES);
        this.trueString.setFrozen(true);
        this.falseString = Create.newString(context, RubyBoolean.FALSE_BYTES);
        this.falseString.setFrozen(true);
        this.encodingService = new EncodingService(this);
        this.symbolClass = RubySymbol.createSymbolClass(context, this.objectClass, this.comparableModule);
        this.symbolTable = new RubySymbol.SymbolTable(this);
        this.threadGroupClass = this.profile.allowClass("ThreadGroup") ? RubyThreadGroup.createThreadGroupClass(context, this.objectClass) : null;
        this.threadClass = this.profile.allowClass("Thread") ? RubyThread.createThreadClass(context, this.objectClass) : null;
        this.exceptionClass = this.profile.allowClass("Exception") ? RubyException.createExceptionClass(context, this.objectClass) : null;
        this.hashClass = this.profile.allowClass("Hash") ? RubyHash.createHashClass(context, this.objectClass, this.enumerableModule) : null;
        this.numericClass = this.profile.allowClass("Numeric") ? RubyNumeric.createNumericClass(context, this.objectClass, this.comparableModule) : null;
        this.integerClass = this.profile.allowClass("Integer") ? RubyInteger.createIntegerClass(context, this.numericClass) : null;
        this.fixnumClass = this.profile.allowClass("Fixnum") ? RubyFixnum.createFixnumClass(context, this.integerClass) : null;
        this.nilHash = Convert.asFixnum(context, this.nilObject.hashCode());
        this.nilID = Convert.asFixnum(context, 8);
        this.trueHash = Convert.asFixnum(context, this.trueObject.hashCode());
        this.trueID = Convert.asFixnum(context, 20);
        this.falseHash = Convert.asFixnum(context, this.falseObject.hashCode());
        this.encodingClass = RubyEncoding.createEncodingClass(context, this.objectClass);
        this.converterClass = RubyConverter.createConverterClass(context, this.objectClass, this.encodingClass);
        this.encodingService.defineEncodings(context);
        this.encodingService.defineAliases(context);
        this.initDefaultEncodings(context);
        this.complexClass = this.profile.allowClass("Complex") ? RubyComplex.createComplexClass(context, this.numericClass) : null;
        RubyClass rubyClass = this.rationalClass = this.profile.allowClass("Rational") ? RubyRational.createRationalClass(context, this.numericClass) : null;
        if (this.profile.allowClass("Array")) {
            this.arrayClass = RubyArray.createArrayClass(context, this.objectClass, this.enumerableModule);
            this.emptyFrozenArray = Create.newEmptyArray(context);
            this.emptyFrozenArray.setFrozen(true);
        } else {
            this.arrayClass = null;
            this.emptyFrozenArray = null;
        }
        this.floatClass = this.profile.allowClass("Float") ? RubyFloat.createFloatClass(context, this.numericClass) : null;
        this.randomClass = RubyRandom.createRandomClass(context, this.objectClass);
        this.setDefaultRandom(RubyRandom.newRandom(context, this.randomClass, (IRubyObject)RubyRandom.randomSeed(this)));
        this.ioClass = RubyIO.createIOClass(context, this.objectClass, this.enumerableModule);
        this.ioBufferClass = Options.FIBER_SCHEDULER.load() != false ? RubyIOBuffer.createIOBufferClass(context, this.objectClass, this.comparableModule, this.ioClass) : null;
        this.structClass = this.profile.allowClass("Struct") ? RubyStruct.createStructClass(context, this.objectClass, this.enumerableModule) : null;
        this.bindingClass = this.profile.allowClass("Binding") ? RubyBinding.createBindingClass(context, this.objectClass) : null;
        this.mathModule = this.profile.allowModule("Math") ? RubyMath.createMathModule(context) : null;
        this.regexpClass = this.profile.allowClass("Regexp") ? RubyRegexp.createRegexpClass(context, this.objectClass) : null;
        this.rangeClass = this.profile.allowClass("Range") ? RubyRange.createRangeClass(context, this.objectClass, this.enumerableModule) : null;
        this.objectSpaceModule = this.profile.allowModule("ObjectSpace") ? RubyObjectSpace.createObjectSpaceModule(context, this.objectClass) : null;
        this.gcModule = this.profile.allowModule("GC") ? RubyGC.createGCModule(context) : null;
        this.procClass = this.profile.allowClass("Proc") ? RubyProc.createProcClass(context, this.objectClass) : null;
        RubyClass rubyClass2 = this.methodClass = this.profile.allowClass("Method") ? RubyMethod.createMethodClass(context, this.objectClass) : null;
        if (this.profile.allowClass("MatchData")) {
            this.matchDataClass = RubyMatchData.createMatchDataClass(context, this.objectClass);
            this.objectClass.defineConstant(context, "MatchingData", this.matchDataClass);
        } else {
            this.matchDataClass = null;
        }
        this.marshalModule = this.profile.allowModule("Marshal") ? RubyMarshal.createMarshalModule(context) : null;
        this.dirClass = this.profile.allowClass("Dir") ? RubyDir.createDirClass(context, this.objectClass, this.enumerableModule) : null;
        this.fileTestModule = this.profile.allowModule("FileTest") ? RubyFileTest.createFileTestModule(context) : null;
        this.fileClass = this.profile.allowClass("File") ? RubyFile.createFileClass(context, this.ioClass) : null;
        this.fileStatClass = this.profile.allowClass("File::Stat") ? RubyFileStat.createFileStatClass(context, this.objectClass, this.fileClass, this.comparableModule) : null;
        this.processModule = this.profile.allowModule("Process") ? RubyProcess.createProcessModule(context, this.objectClass, this.structClass) : null;
        this.timeClass = this.profile.allowClass("Time") ? RubyTime.createTimeClass(context, this.objectClass, this.comparableModule) : null;
        RubyClass rubyClass3 = this.unboundMethodClass = this.profile.allowClass("UnboundMethod") ? RubyUnboundMethod.defineUnboundMethodClass(context, this.objectClass) : null;
        if (this.profile.allowModule("Signal")) {
            RubySignal.createSignal(context);
        }
        if (this.profile.allowClass("Enumerator")) {
            this.enumeratorClass = RubyEnumerator.defineEnumerator(context, this.objectClass, this.enumerableModule);
            this.generatorClass = RubyGenerator.createGeneratorClass(context, this.objectClass, this.enumeratorClass, this.enumerableModule);
            this.yielderClass = RubyYielder.createYielderClass(context, this.objectClass, this.enumeratorClass);
            this.chainClass = RubyChain.createChainClass(context, this.objectClass, this.enumeratorClass, this.enumerableModule);
            this.aseqClass = RubyArithmeticSequence.createArithmeticSequenceClass(context, this.enumeratorClass, this.enumerableModule);
            this.producerClass = RubyProducer.createProducerClass(context, this.objectClass, this.enumeratorClass, this.enumerableModule);
        } else {
            this.enumeratorClass = null;
            this.generatorClass = null;
            this.yielderClass = null;
            this.chainClass = null;
            this.aseqClass = null;
            this.producerClass = null;
        }
        this.continuationClass = this.initContinuation(context);
        TracePoint.createTracePointClass(context, this.objectClass);
        this.warningCategories = config2.getWarningCategories();
        this.warningModule = RubyWarnings.createWarningModule(context);
        this.initExceptions(context);
        this.mutexClass = Mutex.setup(context, this.threadClass, this.objectClass);
        this.conditionVariableClass = ConditionVariable.setup(context, this.threadClass, this.objectClass);
        this.queueClass = Queue.setup(context, this.threadClass, this.objectClass);
        this.closedQueueError = Queue.setupError(context, this.queueClass, this.stopIteration, this.objectClass);
        this.sizedQueueClass = SizedQueue.setup(context, this.threadClass, this.queueClass, this.objectClass);
        this.fiberClass = new ThreadFiberLibrary().createFiberClass(context, this.objectClass);
        this.dataClass = RubyData.createDataClass(context, this.objectClass);
        ThreadFiber.initRootFiber(context, context.getThread());
        this.initDefinedMessages(context);
        this.initThreadStatuses(context);
        IRScriptBody top = new IRScriptBody(this.irManager, "", context.getCurrentScope().getStaticScope());
        top.allocateInterpreterContext(Collections.EMPTY_LIST, 0, IRScope.allocateInitialFlags(top));
        this.dummyClass = new RubyClass(this, this.classClass);
        this.dummyClass.setFrozen(true);
        this.envObject = RubyGlobal.createGlobalsAndENV(context, this.globalVariables, config2);
        Access.loadService(context).init(this.config.getLoadPaths());
        this.coreIsBooted = true;
        if (!RubyInstanceConfig.DEBUG_PARSER) {
            this.initBootLibraries(context);
        }
        SecurityHelper.checkCryptoRestrictions(this);
        if (this.config.isProfiling()) {
            this.initProfiling(context);
        }
        if (this.config.getLoadGemfile()) {
            this.loadBundler();
        }
        this.runtimeIsBooted = true;
        if ("true".equals(System.getenv("USE_SUBSPAWN"))) {
            if (Platform.IS_WINDOWS) {
                LOG.warn("env USE_SUBSPAWN=true is unsupported on Windows at this time", new Object[0]);
            } else {
                Access.loadService(context).require("subspawn/replace-builtin");
            }
        }
    }

    private void initProfiling(ThreadContext context) {
        Access.loadService(context).require("jruby/profiler/shutdown_hook");
        this.kernelModule.invalidateCacheDescendants(context);
        RubyKernel.recacheBuiltinMethods(this, this.kernelModule);
        RubyBasicObject.recacheBuiltinMethods(context, this.basicObjectClass);
    }

    private void initBootLibraries(ThreadContext context) {
        this.initJavaSupport(context);
        this.initRubyKernel();
        if (!this.config.isDisableGems()) {
            Define.defineModule(context, "Gem");
            if (!this.config.isDisableErrorHighlight()) {
                this.warnings.warn("ErrorHighlight does not currently support JRuby and will not be loaded");
            }
            if (!this.config.isDisableDidYouMean()) {
                Define.defineModule(context, "DidYouMean");
            }
            if (!this.config.isDisableSyntaxSuggest()) {
                Define.defineModule(context, "SyntaxSuggest");
            }
        }
        this.loadService.provide("enumerator.rb");
        this.loadService.provide("rational.rb");
        this.loadService.provide("complex.rb");
        this.loadService.provide("thread.rb");
        this.loadService.provide("fiber.rb");
        this.loadService.provide("ruby2_keywords.rb");
        this.initRubyPreludes();
    }

    private ObjectSpacer initObjectSpacer(RubyInstanceConfig config2) {
        ObjectSpacer objectSpacer = config2.isObjectSpaceEnabled() ? ENABLED_OBJECTSPACE : DISABLED_OBJECTSPACE;
        return objectSpacer;
    }

    private JRubyClassLoader initJRubyClassLoader(RubyInstanceConfig config2) {
        JRubyClassLoader jrubyClassLoader = !Ruby.isSecurityRestricted() ? (config2.isClassloaderDelegate() ? new JRubyClassLoader(config2.getLoader()) : new SelfFirstJRubyClassLoader(config2.getLoader())) : null;
        return jrubyClassLoader;
    }

    private void initDefaultEncodings(ThreadContext context) {
        Encoding loadedEncoding;
        String encoding2 = this.config.getExternalEncoding();
        if (encoding2 != null && !encoding2.isEmpty()) {
            loadedEncoding = this.encodingService.loadEncoding(ByteList.create(encoding2));
            if (loadedEncoding == null) {
                throw new MainExitException(1, "unknown encoding name - " + encoding2);
            }
            this.setDefaultExternalEncoding(loadedEncoding);
        } else {
            Encoding consoleEncoding = this.encodingService.getConsoleEncoding();
            Encoding availableEncoding = consoleEncoding == null ? this.encodingService.getLocaleEncoding() : consoleEncoding;
            this.setDefaultExternalEncoding(availableEncoding);
        }
        if (Platform.IS_WINDOWS) {
            this.setDefaultFilesystemEncoding(this.encodingService.getWindowsFilesystemEncoding(context));
        } else {
            this.setDefaultFilesystemEncoding(this.getDefaultExternalEncoding());
        }
        encoding2 = this.config.getInternalEncoding();
        if (encoding2 != null && !encoding2.isEmpty()) {
            loadedEncoding = this.encodingService.loadEncoding(ByteList.create(encoding2));
            if (loadedEncoding == null) {
                throw new MainExitException(1, "unknown encoding name - " + encoding2);
            }
            this.setDefaultInternalEncoding(loadedEncoding);
        }
    }

    private Random initRandom() {
        Random myRandom;
        try {
            myRandom = new SecureRandom();
        }
        catch (Throwable t) {
            LOG.debug("unable to instantiate SecureRandom, falling back on Random", t);
            myRandom = new Random();
        }
        return myRandom;
    }

    public void registerMBeans() {
        this.beanManager.register(this.jitCompiler);
        this.beanManager.register(this.configBean);
        this.beanManager.register(this.getParserManager().getParserStats());
        this.beanManager.register(this.runtimeBean);
        this.beanManager.register(this.caches);
        this.beanManager.register(this.inlineStats);
    }

    public void reinitialize(boolean reinitCore) {
        this.doNotReverseLookupEnabled = true;
        this.in = this.config.getInput();
        this.out = this.config.getOutput();
        this.err = this.config.getError();
        this.objectSpaceEnabled = this.config.isObjectSpaceEnabled();
        this.siphashEnabled = this.config.isSiphashEnabled();
        this.profile = this.config.getProfile();
        this.currentDirectory = this.config.getCurrentDirectory();
        this.kcode = this.config.getKCode();
        if (reinitCore) {
            RubyGlobal.initARGV(this);
            RubyGlobal.initSTDIO(this, this.globalVariables);
        }
    }

    public static Ruby newInstance() {
        return Ruby.newInstance(new RubyInstanceConfig());
    }

    public static Ruby newInstance(RubyInstanceConfig config2) {
        Ruby ruby = new Ruby(config2);
        ruby.loadRequiredLibraries();
        Ruby.setGlobalRuntimeFirstTimeOnly(ruby);
        return ruby;
    }

    private void loadRequiredLibraries() {
        ThreadContext context = this.getCurrentContext();
        for (String scriptName : this.config.getRequiredLibraries()) {
            this.topSelf.callMethod(context, "require", Create.newString(context, scriptName));
        }
    }

    public static Ruby newInstance(InputStream in, PrintStream out, PrintStream err) {
        RubyInstanceConfig config2 = new RubyInstanceConfig();
        config2.setInput(in);
        config2.setOutput(out);
        config2.setError(err);
        return Ruby.newInstance(config2);
    }

    public static boolean isGlobalRuntimeReady() {
        return globalRuntime != null;
    }

    private static synchronized void setGlobalRuntimeFirstTimeOnly(Ruby runtime2) {
        if (globalRuntime == null) {
            globalRuntime = runtime2;
        }
    }

    public static synchronized Ruby getGlobalRuntime() {
        if (globalRuntime == null) {
            Ruby.newInstance();
        }
        return globalRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAsGlobalRuntime() {
        Class<Ruby> clazz = Ruby.class;
        synchronized (Ruby.class) {
            globalRuntime = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void clearGlobalRuntime() {
        globalRuntime = null;
    }

    public static Ruby getThreadLocalRuntime() {
        return threadLocalRuntime.get();
    }

    public static void setThreadLocalRuntime(Ruby ruby) {
        threadLocalRuntime.set(ruby);
    }

    public IRubyObject evalScriptlet(String script) {
        DynamicScope currentScope = this.getCurrentContext().getCurrentScope();
        ManyVarsDynamicScope newScope = new ManyVarsDynamicScope(this.getStaticScopeFactory().newEvalScope(currentScope.getStaticScope()), currentScope);
        return this.evalScriptlet(script, newScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject evalScriptlet(String script, DynamicScope scope) {
        ThreadContext context = this.getCurrentContext();
        RootNode rootNode = (RootNode)this.getParserManager().parseEval("<script>", 0, script, scope).getAST();
        context.preEvalScriptlet(scope);
        try {
            IRubyObject iRubyObject = (IRubyObject)this.interpreter.execute(context, rootNode, this.getTopSelf());
            return iRubyObject;
        }
        finally {
            context.postEvalScriptlet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject executeScript(String script, String filename2) {
        ByteArrayInputStream in = new ByteArrayInputStream(this.encodeToBytes(script));
        ParseResult root = this.getParserManager().parseMainFile(filename2, 0, in, this.setupSourceEncoding(this.getEncodingService().getLocaleEncoding()), this.getCurrentContext().getCurrentScope(), ParserType.NORMAL);
        ThreadContext context = this.getCurrentContext();
        String oldFile = context.getFile();
        int oldLine = context.getLine();
        try {
            context.setFileAndLine(root.getFile(), root.getLine());
            IRubyObject iRubyObject = this.runInterpreter(root);
            return iRubyObject;
        }
        finally {
            context.setFileAndLine(oldFile, oldLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFromMain(InputStream inputStream, String filename2) {
        Object script;
        ThreadContext context = this.getCurrentContext();
        this.globalVariables.set("$0", Create.newFrozenString(context, filename2));
        this.loadService.setMainScript(filename2, this.getCurrentDirectory());
        for (Map.Entry<String, String> entry : this.config.getOptionGlobals().entrySet()) {
            RubyObject varvalue = entry.getValue() != null ? this.newString(entry.getValue()) : this.getTrue();
            this.getGlobalVariables().set("$" + entry.getKey(), varvalue);
        }
        if (filename2.endsWith(".class")) {
            script = CompiledScriptLoader.loadScriptFromFile(this, inputStream, null, filename2, false);
            if (script == null) {
                throw new MainExitException(1, "error: .class file specified is not a compiled JRuby script");
            }
            ((IRScope)script).setFileName(filename2);
            this.runInterpreter((ParseResult)script);
            return;
        }
        if (Options.COMPILE_CACHE_CLASSES.load().booleanValue() && (script = this.tryScriptFromClass(filename2)) != null) {
            this.runScript((Script)script);
            return;
        }
        ParseResult result2 = this.parseFromMain(filename2, inputStream);
        if (this.objectClass.fetchConstant(context, "DATA") == null) {
            try {
                inputStream.close();
            }
            catch (IOException entry) {
                // empty catch block
            }
        }
        String oldFile = context.getFile();
        int oldLine = context.getLine();
        try {
            context.setFileAndLine(result2.getFile(), result2.getLine());
            if (this.config.isAssumePrinting() || this.config.isAssumeLoop()) {
                this.runWithGetsLoop(result2, this.config.isAssumePrinting(), this.config.isProcessLineEnds(), this.config.isSplit());
            } else {
                this.runNormally(result2, this.getTopSelf(), false);
            }
        }
        finally {
            context.setFileAndLine(oldFile, oldLine);
        }
    }

    private Script tryScriptFromClass(String filename2) {
        block4: {
            String clsName = JavaNameMangler.mangledFilenameForStartupClasspath(filename2);
            try {
                ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                if (systemClassLoader.getResource(clsName + ".class") == null) {
                    return null;
                }
                Class<?> scriptClass = systemClassLoader.loadClass(clsName.replace("/", "."));
                if (Options.COMPILE_CACHE_CLASSES_LOGGING.load().booleanValue()) {
                    System.err.println("found class " + scriptClass.getName() + " for " + filename2);
                }
                Script script = Compiler.getScriptFromClass(scriptClass);
                script.setFilename(filename2);
            }
            catch (ClassNotFoundException cnfe) {
                if (!Options.COMPILE_CACHE_CLASSES_LOGGING.load().booleanValue()) break block4;
                System.err.println("no class found for script " + filename2);
            }
        }
        return null;
    }

    @Deprecated(since="9.4.6.0")
    public Node parseFromMain(InputStream inputStream, String filename2) {
        return (Node)this.parseFromMain(filename2, inputStream).getAST();
    }

    public ParseResult parseFromMain(String fileName, InputStream in) {
        return this.getParserManager().parseMainFile(fileName, 0, in, this.setupSourceEncoding(UTF8Encoding.INSTANCE), this.getTopLevelBinding().getBinding().getDynamicScope(), this.config.isInlineScript() ? ParserType.INLINE : ParserType.MAIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject runWithGetsLoop(ParseResult scriptNode, boolean printing, boolean processLineEnds, boolean split2) {
        ThreadContext context = this.getCurrentContext();
        scriptNode = this.getParserManager().addGetsLoop(this, scriptNode, printing, processLineEnds, split2);
        Script script = null;
        boolean compile2 = this.getInstanceConfig().getCompileMode().shouldPrecompileCLI();
        if (compile2) {
            block12: {
                try {
                    script = this.tryCompile(scriptNode);
                    if (Options.JIT_LOGGING.load().booleanValue()) {
                        LOG.info("successfully compiled: {}", scriptNode.getFile());
                    }
                }
                catch (RaiseException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (!Options.JIT_LOGGING.load().booleanValue()) break block12;
                    if (Options.JIT_LOGGING_VERBOSE.load().booleanValue()) {
                        LOG.error("failed to compile: " + scriptNode.getFile(), e);
                    }
                    LOG.error("failed to compile: " + scriptNode.getFile() + " - " + String.valueOf(e), new Object[0]);
                }
            }
            if (!compile2 || script == null) {
                // empty if block
            }
        }
        Helpers.preLoad(context, scriptNode.getStaticScope().getVariables());
        try {
            if (script != null) {
                this.runScriptBody(script);
            } else {
                this.runInterpreter(scriptNode);
            }
        }
        finally {
            Helpers.postLoad(context);
        }
        return this.getNil();
    }

    @Deprecated(since="9.4.6.0")
    public IRubyObject runNormally(Node scriptNode, boolean wrap2) {
        return this.runNormally(scriptNode, this.getTopSelf(), wrap2);
    }

    @Deprecated(since="9.4.6.0")
    public IRubyObject runNormally(Node scriptNode, IRubyObject self2, boolean wrap2) {
        return this.runNormally((ParseResult)((Object)scriptNode), self2, wrap2);
    }

    public IRubyObject runNormally(ParseResult scriptNode, IRubyObject self2, boolean wrap2) {
        ScriptAndCode scriptAndCode = null;
        boolean compile2 = this.getInstanceConfig().getCompileMode().shouldPrecompileCLI();
        if (compile2 || this.config.isShowBytecode()) {
            scriptAndCode = this.precompileCLI(scriptNode);
        }
        if (scriptAndCode != null) {
            if (this.config.isShowBytecode()) {
                TraceClassVisitor tracer = new TraceClassVisitor(new PrintWriter(System.err));
                ClassReader reader = new ClassReader(scriptAndCode.bytecode());
                reader.accept(tracer, 0);
                return this.getNil();
            }
            return this.runScript(scriptAndCode.script(), self2, wrap2);
        }
        return this.runInterpreter(scriptNode);
    }

    @Deprecated(since="9.4.6.0")
    public IRubyObject runNormally(Node scriptNode) {
        return this.runNormally(scriptNode, false);
    }

    private ScriptAndCode precompileCLI(ParseResult scriptNode) {
        ScriptAndCode scriptAndCode;
        block5: {
            scriptAndCode = null;
            try {
                scriptAndCode = this.tryCompile(scriptNode, new ClassDefiningJRubyClassLoader(this.getJRubyClassLoader()));
                if (scriptAndCode != null && Options.JIT_LOGGING.load().booleanValue()) {
                    LOG.info("done compiling target script: {}", scriptNode.getFile());
                }
            }
            catch (RaiseException e) {
                throw e;
            }
            catch (Exception e) {
                if (!Options.JIT_LOGGING.load().booleanValue()) break block5;
                if (Options.JIT_LOGGING_VERBOSE.load().booleanValue()) {
                    LOG.error("failed to compile target script: " + scriptNode.getFile(), e);
                }
                LOG.error("failed to compile target script: " + scriptNode.getFile() + " - " + String.valueOf(e), new Object[0]);
            }
        }
        return scriptAndCode;
    }

    @Deprecated(since="9.4.6.0")
    public Script tryCompile(Node node) {
        return this.tryCompile((ParseResult)((Object)node));
    }

    public Script tryCompile(ParseResult result2) {
        return this.tryCompile(result2, new ClassDefiningJRubyClassLoader(this.getJRubyClassLoader())).script();
    }

    private ScriptAndCode tryCompile(ParseResult result2, ClassDefiningClassLoader classLoader) {
        try {
            return (ScriptAndCode)Compiler.getInstance().execute(this.getCurrentContext(), result2, classLoader);
        }
        catch (VerifyError | NotCompilableException e) {
            if (Options.JIT_LOGGING.load().booleanValue()) {
                if (Options.JIT_LOGGING_VERBOSE.load().booleanValue()) {
                    LOG.error("failed to compile target script: " + result2.getFile(), e);
                } else {
                    LOG.error("failed to compile target script: " + result2.getFile() + " - " + e.getLocalizedMessage(), new Object[0]);
                }
            }
            return null;
        }
    }

    public IRubyObject runScript(Script script) {
        return this.runScript(script, false);
    }

    public IRubyObject runScript(Script script, boolean wrap2) {
        return this.runScript(script, this.getTopSelf(), wrap2);
    }

    public IRubyObject runScript(Script script, IRubyObject self2, boolean wrap2) {
        return script.load(this.getCurrentContext(), self2, wrap2);
    }

    public IRubyObject runScriptBody(Script script) {
        return script.__file__(this.getCurrentContext(), this.getTopSelf(), Block.NULL_BLOCK);
    }

    public IRubyObject runInterpreter(ThreadContext context, ParseResult parseResult, IRubyObject self2) {
        try {
            return (IRubyObject)this.interpreter.execute(context, parseResult, self2);
        }
        catch (IRReturnJump ex) {
            if (!ex.methodToReturnFrom.getStaticScope().getIRScope().isScriptScope()) {
                System.err.println("Unexpected 'return' escaped the runtime from " + String.valueOf(ex.returnScope.getIRScope()) + " to " + String.valueOf(ex.methodToReturnFrom.getStaticScope().getIRScope()));
                System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(ex, false));
                Throwable t = ex;
                while ((t = t.getCause()) != null) {
                    System.err.println("Caused by:");
                    System.err.println(ThreadContext.createRawBacktraceStringFromThrowable(t, false));
                }
            }
            return context.nil;
        }
    }

    public IRubyObject runInterpreter(ThreadContext context, Node rootNode, IRubyObject self2) {
        assert (rootNode != null) : "scriptNode is not null";
        return (IRubyObject)this.interpreter.execute(context, (ParseResult)((Object)rootNode), self2);
    }

    public IRubyObject runInterpreter(Node scriptNode) {
        return this.runInterpreter(this.getCurrentContext(), scriptNode, this.getTopSelf());
    }

    public IRubyObject runInterpreter(ParseResult parseResult) {
        return this.runInterpreter(this.getCurrentContext(), parseResult, this.getTopSelf());
    }

    public IRubyObject runInterpreterBody(Node scriptNode) {
        assert (scriptNode != null) : "scriptNode is not null";
        assert (scriptNode instanceof RootNode) : "scriptNode is not a RootNode";
        return this.runInterpreter(scriptNode);
    }

    @Deprecated(since="9.4.6.0")
    public Parser getParser() {
        return this.getParserManager().getParser();
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public JITCompiler getJITCompiler() {
        return this.jitCompiler;
    }

    public InlineStats getInlineStats() {
        return this.inlineStats;
    }

    public Caches getCaches() {
        return this.caches;
    }

    public int allocSymbolId() {
        return this.symbolLastId.incrementAndGet();
    }

    public int allocModuleId() {
        return this.moduleLastId.incrementAndGet();
    }

    public void addModule(RubyModule module) {
        assert (module.getMetaClass() == this.moduleClass);
        this.allModules.put(module, RubyBasicObject.NEVER);
    }

    public void eachModule(Consumer<RubyModule> func) {
        Enumeration<RubyModule> e = this.allModules.keys();
        while (e.hasMoreElements()) {
            func.accept(e.nextElement());
        }
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule getModule(String name2) {
        return Access.getModule(this.getCurrentContext(), name2);
    }

    @Deprecated(since="10.0.0.0")
    public RubyClass getClass(String name2) {
        return Access.getClass(this.getCurrentContext(), name2);
    }

    @Deprecated(since="1.7.0")
    public RubyClass fastGetClass(String internedName) {
        return Access.getClass(this.getCurrentContext(), internedName);
    }

    @Deprecated(since="10.0.0.0")
    public RubyClass defineClass(String name2, RubyClass superClass, ObjectAllocator allocator, CallSite[] callSites) {
        return this.defineClassUnder(this.getCurrentContext(), name2, superClass, allocator, this.objectClass, callSites);
    }

    @Deprecated(since="10.0.0.0")
    public RubyClass defineClass(String name2, RubyClass superClass, ObjectAllocator allocator) {
        return this.defineClassUnder(this.getCurrentContext(), name2, superClass, allocator, this.objectClass, null);
    }

    @Extension
    @Deprecated(since="10.0.0.0")
    public RubyClass defineClassUnder(String name2, RubyClass superClass, ObjectAllocator allocator, RubyModule parent) {
        return this.defineClassUnder(this.runtimeError.getCurrentContext(), name2, superClass, allocator, parent, null);
    }

    @Deprecated(since="10.0.0.0")
    public RubyClass defineClassUnder(String id, RubyClass superClass, ObjectAllocator allocator, RubyModule parent, CallSite[] callSites) {
        return this.defineClassUnder(this.getCurrentContext(), id, superClass, allocator, parent, callSites);
    }

    public RubyClass defineClassUnder(ThreadContext context, String id, RubyClass superClass, ObjectAllocator allocator, RubyModule parent, CallSite[] callSites) {
        boolean parentIsObject;
        IRubyObject object = parent.getConstantAt(context, id);
        if (object != null) {
            return this.foundExistingClass(context, id, superClass, allocator, object);
        }
        boolean bl = parentIsObject = parent == this.objectClass;
        if (superClass == null) {
            superClass = this.determineSuperClass(context, id, parent, parentIsObject);
        }
        return RubyClass.newClass(context, superClass, id, allocator, parent, !parentIsObject, callSites);
    }

    private RubyClass determineSuperClass(ThreadContext context, String id, RubyModule parent, boolean parentIsObject) {
        RubyString className = parentIsObject ? RubyStringBuilder.ids(this, id) : parent.toRubyString(context).append(this.newString("::")).append(RubyStringBuilder.ids(this, id));
        Warn.warn(context, RubyStringBuilder.str(this, "no super class for '", className, "', Object assumed"));
        return this.objectClass;
    }

    private RubyClass foundExistingClass(ThreadContext context, String id, RubyClass superClass, ObjectAllocator allocator, IRubyObject obj) {
        if (!(obj instanceof RubyClass)) {
            throw Error.typeError(context, RubyStringBuilder.str(this, RubyStringBuilder.ids(this, id), " is not a class"));
        }
        RubyClass klazz = (RubyClass)obj;
        if (klazz.getSuperClass().getRealClass() != superClass) {
            throw Error.typeError(context, RubyStringBuilder.str(this, "superclass mismatch for ", RubyStringBuilder.ids(this, id)));
        }
        if (klazz.getAllocator() != allocator) {
            klazz.allocator(allocator);
        }
        return klazz;
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule defineModule(String name2) {
        return this.defineModuleUnder(this.getCurrentContext(), name2, this.objectClass);
    }

    public RubyModule defineModuleBootstrap(String name2) {
        return RubyModule.newModuleBootstrap(this, name2, this.objectClass);
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule defineModuleUnder(String name2, RubyModule parent) {
        return this.defineModuleUnder(this.getCurrentContext(), name2, parent);
    }

    public RubyModule defineModuleUnder(ThreadContext context, String name2, RubyModule parent) {
        boolean parentIsObject;
        IRubyObject moduleObj = parent.getConstantAt(context, name2);
        boolean bl = parentIsObject = parent == this.objectClass;
        return moduleObj != null ? this.foundExistingModule(context, parent, moduleObj, parentIsObject) : RubyModule.newModule(context, name2, parent, !parentIsObject, null, -1);
    }

    private RubyModule foundExistingModule(ThreadContext context, RubyModule parent, IRubyObject moduleObj, boolean parentIsObject) {
        if (moduleObj.isModule()) {
            return (RubyModule)moduleObj;
        }
        RubyString typeName = parentIsObject ? RubyStringBuilder.types(this, (RubyModule)moduleObj.getMetaClass()) : RubyStringBuilder.types(this, parent, moduleObj.getMetaClass());
        throw Error.typeError(context, RubyStringBuilder.str(this, typeName, " is not a module"));
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule getOrCreateModule(String id) {
        ThreadContext context = this.getCurrentContext();
        IRubyObject module = this.objectClass.getConstantAt(context, id);
        if (module == null) {
            module = Define.defineModule(context, id);
        } else if (!module.isModule()) {
            throw Error.typeError(context, RubyStringBuilder.str(this, RubyStringBuilder.ids(this, id), " is not a Module"));
        }
        return (RubyModule)module;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public void setKCode(KCode kcode) {
        this.kcode = kcode;
    }

    @Deprecated(since="10.0.0.0")
    public void defineGlobalConstant(String name2, IRubyObject value2) {
        this.objectClass.defineConstant(name2, value2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject fetchGlobalConstant(String name2) {
        return this.objectClass.fetchConstant(this.getCurrentContext(), name2, false);
    }

    @Deprecated(since="10.0.0.0")
    public boolean isClassDefined(String name2) {
        return Access.getModule(this.getCurrentContext(), name2) != null;
    }

    public JavaSupport loadJavaSupport() {
        return new JavaSupportImpl(this);
    }

    private void loadBundler() {
        this.loadService.loadFromClassLoader(Ruby.getClassLoader(), "jruby/bundler/startup.rb", false);
    }

    private boolean doesReflectionWork() {
        try {
            ClassLoader.class.getDeclaredMethod("getResourceAsStream", String.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void initDefinedMessages(ThreadContext context) {
        for (DefinedMessage definedMessage : DefinedMessage.values()) {
            RubyString str = this.freezeAndDedupString(Create.newString(context, ByteList.create(definedMessage.getText())));
            this.definedMessages.put(definedMessage, str);
        }
    }

    private void initThreadStatuses(ThreadContext context) {
        for (RubyThread.Status status2 : RubyThread.Status.values()) {
            this.threadStatuses.put(status2, this.freezeAndDedupString(Create.newString(context, status2.bytes)));
        }
    }

    private RubyClass initContinuation(ThreadContext context) {
        if (this.profile.allowClass("Continuation")) {
            return RubyContinuation.createContinuation(context, this.objectClass);
        }
        return null;
    }

    public IRubyObject[] getNilPrefilledArray() {
        return this.nilPrefilledArray;
    }

    private void initExceptions(ThreadContext context) {
        this.ifAllowed("StandardError", ruby -> {
            this.standardError = RubyStandardError.define(context, this.exceptionClass);
        });
        this.ifAllowed("RubyError", ruby -> {
            this.runtimeError = RubyRuntimeError.define(context, this.standardError);
        });
        this.ifAllowed("FrozenError", ruby -> {
            this.frozenError = RubyFrozenError.define(context, this.runtimeError);
        });
        this.ifAllowed("IOError", ruby -> {
            this.ioError = RubyIOError.define(context, this.standardError);
        });
        this.ifAllowed("IO::TimeoutError", ruby -> {
            this.ioTimeoutError = RubyIO.RubyIOTimeoutError.define(context, this.ioClass, this.ioError);
        });
        this.ifAllowed("ScriptError", ruby -> {
            this.scriptError = RubyScriptError.define(context, this.exceptionClass);
        });
        this.ifAllowed("RangeError", ruby -> {
            this.rangeError = RubyRangeError.define(context, this.standardError);
        });
        this.ifAllowed("SignalException", ruby -> {
            this.signalException = RubySignalException.define(context, this.exceptionClass);
        });
        this.ifAllowed("NameError", ruby -> {
            this.nameError = RubyNameError.define(context, this.standardError);
            this.nameErrorMessage = RubyNameError.RubyNameErrorMessage.define(context, this.objectClass, this.nameError);
        });
        this.ifAllowed("NoMethodError", ruby -> {
            this.noMethodError = RubyNoMethodError.define(context, this.nameError);
        });
        this.ifAllowed("SystemExit", ruby -> {
            this.systemExit = RubySystemExit.define(context, this.exceptionClass);
        });
        this.ifAllowed("LocalJumpError", ruby -> {
            this.localJumpError = RubyLocalJumpError.define(context, this.standardError);
        });
        this.ifAllowed("SystemCallError", ruby -> {
            this.systemCallError = RubySystemCallError.define(context, this.standardError);
        });
        this.ifAllowed("Fatal", ruby -> {
            this.fatal = RubyFatal.define(context, this.exceptionClass, this.objectClass);
        });
        this.ifAllowed("Interrupt", ruby -> {
            this.interrupt = RubyInterrupt.define(context, this.signalException);
        });
        this.ifAllowed("TypeError", ruby -> {
            this.typeError = RubyTypeError.define(context, this.standardError);
        });
        this.ifAllowed("NoMatchingPatternError", ruby -> {
            this.noMatchingPatternError = RubyNoMatchingPatternError.define(context, this.standardError);
        });
        this.ifAllowed("NoMatchingPatternKeyError", ruby -> {
            this.noMatchingPatternKeyError = RubyNoMatchingPatternKeyError.define(context, this.standardError);
        });
        this.ifAllowed("ArgumentError", ruby -> {
            this.argumentError = RubyArgumentError.define(context, this.standardError);
        });
        this.ifAllowed("UncaughtThrowError", ruby -> {
            this.uncaughtThrowError = RubyUncaughtThrowError.define(context, this.argumentError);
        });
        this.ifAllowed("IndexError", ruby -> {
            this.indexError = RubyIndexError.define(context, this.standardError);
        });
        this.ifAllowed("StopIteration", ruby -> {
            this.stopIteration = RubyStopIteration.define(context, this.indexError);
        });
        this.ifAllowed("SyntaxError", ruby -> {
            this.syntaxError = RubySyntaxError.define(context, this.scriptError);
        });
        this.ifAllowed("LoadError", ruby -> {
            this.loadError = RubyLoadError.define(context, this.scriptError);
        });
        this.ifAllowed("NotImplementedError", ruby -> {
            this.notImplementedError = RubyNotImplementedError.define(context, this.scriptError);
        });
        this.ifAllowed("SecurityError", ruby -> {
            this.securityError = RubySecurityError.define(context, this.exceptionClass);
        });
        this.ifAllowed("NoMemoryError", ruby -> {
            this.noMemoryError = RubyNoMemoryError.define(context, this.exceptionClass);
        });
        this.ifAllowed("RegexpError", ruby -> {
            this.regexpError = RubyRegexpError.define(context, this.standardError);
        });
        this.ifAllowed("InterruptedRegexpError", ruby -> {
            this.interruptedRegexpError = RubyInterruptedRegexpError.define(context, this.regexpError);
        });
        this.ifAllowed("EOFError", ruby -> {
            this.eofError = RubyEOFError.define(context, this.ioError);
        });
        this.ifAllowed("ThreadError", ruby -> {
            this.threadError = RubyThreadError.define(context, this.standardError);
        });
        this.ifAllowed("ConcurrencyError", ruby -> {
            this.concurrencyError = RubyConcurrencyError.define(context, this.threadError);
        });
        this.ifAllowed("SystemStackError", ruby -> {
            this.systemStackError = RubySystemStackError.define(context, this.exceptionClass);
        });
        this.ifAllowed("ZeroDivisionError", ruby -> {
            this.zeroDivisionError = RubyZeroDivisionError.define(context, this.standardError);
        });
        this.ifAllowed("FloatDomainError", ruby -> {
            this.floatDomainError = RubyFloatDomainError.define(context, this.rangeError);
        });
        this.ifAllowed("EncodingError", ruby -> {
            this.encodingError = RubyEncodingError.define(context, this.standardError);
            this.encodingCompatibilityError = RubyEncodingError.RubyCompatibilityError.define(context, this.encodingError, this.encodingClass);
            this.invalidByteSequenceError = RubyEncodingError.RubyInvalidByteSequenceError.define(context, this.encodingError, this.encodingClass);
            this.undefinedConversionError = RubyEncodingError.RubyUndefinedConversionError.define(context, this.encodingError, this.encodingClass);
            this.converterNotFoundError = RubyEncodingError.RubyConverterNotFoundError.define(context, this.encodingError, this.encodingClass);
        });
        this.ifAllowed("Fiber", ruby -> {
            this.fiberError = RubyFiberError.define(context, this.standardError);
        });
        this.ifAllowed("KeyError", ruby -> {
            this.keyError = RubyKeyError.define(context, this.indexError);
        });
        this.ifAllowed("DomainError", ruby -> {
            this.mathDomainError = RubyDomainError.define(context, this.argumentError, this.mathModule);
        });
        this.setRegexpTimeoutError((RubyClass)this.regexpClass.defineClassUnder(context, "TimeoutError", this.getRegexpError(), RubyRegexpError::new));
        RubyClass runtimeError = this.runtimeError;
        ObjectAllocator runtimeErrorAllocator = runtimeError.getAllocator();
        if (Options.FIBER_SCHEDULER.load().booleanValue()) {
            this.bufferLockedError = this.ioBufferClass.defineClassUnder(context, "LockedError", runtimeError, runtimeErrorAllocator);
            this.bufferAllocationError = this.ioBufferClass.defineClassUnder(context, "AllocationError", runtimeError, runtimeErrorAllocator);
            this.bufferAccessError = this.ioBufferClass.defineClassUnder(context, "AccessError", runtimeError, runtimeErrorAllocator);
            this.bufferInvalidatedError = this.ioBufferClass.defineClassUnder(context, "InvalidatedError", runtimeError, runtimeErrorAllocator);
            this.bufferMaskError = this.ioBufferClass.defineClassUnder(context, "MaskError", runtimeError, runtimeErrorAllocator);
        }
        this.initErrno(context);
        if (this.profile.allowClass("NativeException")) {
            this.nativeException = NativeException.createClass(context, runtimeError, this.objectClass);
        }
    }

    private void ifAllowed(String name2, Consumer<Ruby> callback) {
        if (this.profile.allowClass(name2)) {
            callback.accept(this);
        }
    }

    public RubyClass getErrno(int n) {
        return this.errnos.get(n);
    }

    private void initErrno(ThreadContext context) {
        if (this.profile.allowModule("Errno")) {
            this.errnoModule = Define.defineModule(context, "Errno");
            try {
                this.createSysErr(context, Errno.EAGAIN.intValue(), Errno.EAGAIN.name());
                for (Errno e : Errno.values()) {
                    if (e == Errno.EAGAIN || !Character.isUpperCase(e.name().charAt(0))) continue;
                    this.createSysErr(context, e.intValue(), e.name());
                }
                this.errnos.put(Errno.ENOSYS.intValue(), this.notImplementedError);
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    private void createSysErr(ThreadContext context, int i2, String name2) {
        if (this.profile.allowClass(name2)) {
            if (this.errnos.get(i2) == null) {
                this.errnos.put(i2, (RubyClass)((RubyModule)Access.errnoModule(context).defineClassUnder(context, name2, this.systemCallError, this.systemCallError.getAllocator())).defineConstant(context, "Errno", Convert.asFixnum(context, i2)));
            } else {
                Access.errnoModule(context).defineConstant(context, name2, this.errnos.get(i2));
            }
        }
    }

    private void initJavaSupport(ThreadContext context) {
        boolean reflectionWorks = this.doesReflectionWork();
        if (reflectionWorks) {
            new Java().load(context.runtime, false);
            new JRubyUtilLibrary().load(context.runtime, false);
            this.loadService.provide("java.rb");
            this.loadService.provide("jruby/util.rb");
        }
    }

    private void initRubyKernel() {
        this.loadService.loadFromClassLoader(Ruby.getClassLoader(), "jruby/kernel.rb", false);
    }

    private void initRubyPreludes() {
        if (RubyInstanceConfig.DEBUG_PARSER) {
            return;
        }
        this.loadService.loadFromClassLoader(Ruby.getClassLoader(), "jruby/preludes.rb", false);
    }

    public IRManager getIRManager() {
        return this.irManager;
    }

    public IRubyObject getTopSelf() {
        return this.topSelf;
    }

    public void setCurrentDirectory(String dir) {
        this.currentDirectory = dir;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentLine(int line) {
        this.currentLine = line;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public void setArgsFile(IRubyObject argsFile) {
        this.argsFile = argsFile;
    }

    public IRubyObject getArgsFile() {
        return this.argsFile;
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule getEtc() {
        return this.etcModule;
    }

    public void setEtc(RubyModule etcModule) {
        this.etcModule = etcModule;
    }

    public RubyClass getObject() {
        return this.objectClass;
    }

    public RubyClass getBasicObject() {
        return this.basicObjectClass;
    }

    public RubyClass getModule() {
        return this.moduleClass;
    }

    public RubyClass getRefinement() {
        return this.refinementClass;
    }

    public RubyClass getClassClass() {
        return this.classClass;
    }

    public RubyModule getKernel() {
        return this.kernelModule;
    }

    public DynamicMethod getPrivateMethodMissing() {
        return this.privateMethodMissing;
    }

    public void setPrivateMethodMissing(DynamicMethod method2) {
        this.privateMethodMissing = method2;
    }

    public DynamicMethod getProtectedMethodMissing() {
        return this.protectedMethodMissing;
    }

    public void setProtectedMethodMissing(DynamicMethod method2) {
        this.protectedMethodMissing = method2;
    }

    public DynamicMethod getVariableMethodMissing() {
        return this.variableMethodMissing;
    }

    public void setVariableMethodMissing(DynamicMethod method2) {
        this.variableMethodMissing = method2;
    }

    public DynamicMethod getSuperMethodMissing() {
        return this.superMethodMissing;
    }

    public void setSuperMethodMissing(DynamicMethod method2) {
        this.superMethodMissing = method2;
    }

    public DynamicMethod getNormalMethodMissing() {
        return this.normalMethodMissing;
    }

    public void setNormalMethodMissing(DynamicMethod method2) {
        this.normalMethodMissing = method2;
    }

    public DynamicMethod getDefaultMethodMissing() {
        return this.defaultMethodMissing;
    }

    public boolean isDefaultMethodMissing(DynamicMethod method2) {
        return this.defaultMethodMissing == method2 || this.defaultModuleMethodMissing == method2;
    }

    public void setDefaultMethodMissing(DynamicMethod method2, DynamicMethod moduleMethod) {
        this.defaultMethodMissing = method2;
        this.defaultModuleMethodMissing = moduleMethod;
    }

    public DynamicMethod getRespondToMethod() {
        return this.respondTo;
    }

    public void setRespondToMethod(DynamicMethod rtm) {
        this.respondTo = rtm;
    }

    public DynamicMethod getRespondToMissingMethod() {
        return this.respondToMissing;
    }

    public void setRespondToMissingMethod(DynamicMethod rtmm) {
        this.respondToMissing = rtmm;
    }

    public RubyClass getDummy() {
        return this.dummyClass;
    }

    public RubyModule getComparable() {
        return this.comparableModule;
    }

    public RubyClass getNumeric() {
        return this.numericClass;
    }

    public RubyClass getFloat() {
        return this.floatClass;
    }

    public RubyClass getInteger() {
        return this.integerClass;
    }

    public RubyClass getFixnum() {
        return this.fixnumClass;
    }

    public RubyClass getComplex() {
        return this.complexClass;
    }

    public RubyClass getRational() {
        return this.rationalClass;
    }

    public RubyModule getEnumerable() {
        return this.enumerableModule;
    }

    public RubyClass getEnumerator() {
        return this.enumeratorClass;
    }

    public RubyClass getYielder() {
        return this.yielderClass;
    }

    public RubyClass getGenerator() {
        return this.generatorClass;
    }

    public RubyClass getChain() {
        return this.chainClass;
    }

    public RubyClass getArithmeticSequence() {
        return this.aseqClass;
    }

    public RubyClass getProducer() {
        return this.producerClass;
    }

    public RubyClass getFiber() {
        return this.fiberClass;
    }

    public RubyClass getString() {
        return this.stringClass;
    }

    public RubyClass getEncoding() {
        return this.encodingClass;
    }

    public RubyClass getConverter() {
        return this.converterClass;
    }

    public RubyClass getSymbol() {
        return this.symbolClass;
    }

    public RubyClass getArray() {
        return this.arrayClass;
    }

    public RubyClass getHash() {
        return this.hashClass;
    }

    public RubyClass getRange() {
        return this.rangeClass;
    }

    public RubyBoolean getTrue() {
        return this.trueObject;
    }

    public RubyString getTrueString() {
        return this.trueString;
    }

    public RubyString getNilString() {
        return this.nilString;
    }

    public RubyString getNilInspectString() {
        return this.nilInspectString;
    }

    RubyFixnum getNilID() {
        return this.nilID;
    }

    RubyFixnum getNilHash() {
        return this.nilHash;
    }

    RubyFixnum getTrueID() {
        return this.trueID;
    }

    RubyFixnum getTrueHash() {
        return this.trueHash;
    }

    RubyFixnum getFalseHash() {
        return this.falseHash;
    }

    public RubyBoolean getFalse() {
        return this.falseObject;
    }

    public RubyString getFalseString() {
        return this.falseString;
    }

    public IRubyObject getNil() {
        return this.nilObject;
    }

    public IRubyObject[] getSingleNilArray() {
        return this.singleNilArray;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    public RubyClass getTrueClass() {
        return this.trueClass;
    }

    public RubyClass getFalseClass() {
        return this.falseClass;
    }

    public RubyClass getProc() {
        return this.procClass;
    }

    public RubyClass getBinding() {
        return this.bindingClass;
    }

    public RubyClass getMethod() {
        return this.methodClass;
    }

    public RubyClass getUnboundMethod() {
        return this.unboundMethodClass;
    }

    public RubyClass getMatchData() {
        return this.matchDataClass;
    }

    public RubyClass getRegexp() {
        return this.regexpClass;
    }

    public RubyClass getTime() {
        return this.timeClass;
    }

    public RubyModule getMath() {
        return this.mathModule;
    }

    public RubyModule getMarshal() {
        return this.marshalModule;
    }

    @Deprecated(since="10.0.0.0")
    public RubyClass getBignum() {
        return this.integerClass;
    }

    public RubyClass getDateError() {
        return this.dateErrorClass;
    }

    public void setDateError(RubyClass dateError) {
        this.dateErrorClass = dateError;
    }

    public RubyClass getDir() {
        return this.dirClass;
    }

    public RubyClass getFile() {
        return this.fileClass;
    }

    public RubyClass getFileStat() {
        return this.fileStatClass;
    }

    public RubyModule getFileTest() {
        return this.fileTestModule;
    }

    public RubyClass getIO() {
        return this.ioClass;
    }

    public RubyClass getIOBuffer() {
        return this.ioBufferClass;
    }

    public RubyClass getThread() {
        return this.threadClass;
    }

    public RubyClass getThreadGroup() {
        return this.threadGroupClass;
    }

    public RubyThreadGroup getDefaultThreadGroup() {
        return this.defaultThreadGroup;
    }

    void setDefaultThreadGroup(RubyThreadGroup defaultThreadGroup) {
        this.defaultThreadGroup = defaultThreadGroup;
    }

    public RubyClass getContinuation() {
        return this.continuationClass;
    }

    public RubyClass getStructClass() {
        return this.structClass;
    }

    public RubyClass getRandomClass() {
        return this.randomClass;
    }

    public IRubyObject getTmsStruct() {
        return this.tmsStruct;
    }

    void setTmsStruct(RubyClass tmsStruct) {
        this.tmsStruct = tmsStruct;
    }

    public IRubyObject getPasswdStruct() {
        return this.passwdStruct;
    }

    public void setPasswdStruct(RubyClass passwdStruct) {
        this.passwdStruct = passwdStruct;
    }

    public IRubyObject getGroupStruct() {
        return this.groupStruct;
    }

    public void setGroupStruct(RubyClass groupStruct) {
        this.groupStruct = groupStruct;
    }

    public RubyModule getGC() {
        return this.gcModule;
    }

    public RubyModule getObjectSpaceModule() {
        return this.objectSpaceModule;
    }

    public RubyModule getProcess() {
        return this.processModule;
    }

    public RubyClass getProcStatus() {
        return this.procStatusClass;
    }

    void setProcStatus(RubyClass procStatusClass) {
        this.procStatusClass = procStatusClass;
    }

    public RubyModule getProcUID() {
        return this.procUIDModule;
    }

    void setProcUID(RubyModule procUIDModule) {
        this.procUIDModule = procUIDModule;
    }

    public RubyModule getProcGID() {
        return this.procGIDModule;
    }

    void setProcGID(RubyModule procGIDModule) {
        this.procGIDModule = procGIDModule;
    }

    public RubyModule getProcSysModule() {
        return this.procSysModule;
    }

    void setProcSys(RubyModule procSysModule) {
        this.procSysModule = procSysModule;
    }

    public RubyModule getPrecision() {
        return this.precisionModule;
    }

    void setPrecision(RubyModule precisionModule) {
        this.precisionModule = precisionModule;
    }

    public RubyHash getENV() {
        return this.envObject;
    }

    public RubyClass getLocation() {
        return this.locationClass;
    }

    public void setLocation(RubyClass location) {
        this.locationClass = location;
    }

    public RubyClass getMutex() {
        return this.mutexClass;
    }

    public RubyClass getConditionVariable() {
        return this.conditionVariableClass;
    }

    public RubyClass getQueue() {
        return this.queueClass;
    }

    public RubyClass getClosedQueueError() {
        return this.closedQueueError;
    }

    public RubyClass getSizedQueueClass() {
        return this.sizedQueueClass;
    }

    public RubyModule getWarning() {
        return this.warningModule;
    }

    public RubyModule getErrno() {
        return this.errnoModule;
    }

    public RubyClass getException() {
        return this.exceptionClass;
    }

    public RubyClass getNameError() {
        return this.nameError;
    }

    public RubyClass getNameErrorMessage() {
        return this.nameErrorMessage;
    }

    public RubyClass getNoMethodError() {
        return this.noMethodError;
    }

    public RubyClass getSignalException() {
        return this.signalException;
    }

    public RubyClass getRangeError() {
        return this.rangeError;
    }

    public RubyClass getSystemExit() {
        return this.systemExit;
    }

    public RubyClass getLocalJumpError() {
        return this.localJumpError;
    }

    public RubyClass getNativeException() {
        return this.nativeException;
    }

    public RubyClass getSystemCallError() {
        return this.systemCallError;
    }

    public RubyClass getKeyError() {
        return this.keyError;
    }

    public RubyClass getFatal() {
        return this.fatal;
    }

    public RubyClass getInterrupt() {
        return this.interrupt;
    }

    public RubyClass getTypeError() {
        return this.typeError;
    }

    public RubyClass getNoMatchingPatternError() {
        return this.noMatchingPatternError;
    }

    public RubyClass getArgumentError() {
        return this.argumentError;
    }

    public RubyClass getUncaughtThrowError() {
        return this.uncaughtThrowError;
    }

    public RubyClass getIndexError() {
        return this.indexError;
    }

    public RubyClass getStopIteration() {
        return this.stopIteration;
    }

    public RubyClass getSyntaxError() {
        return this.syntaxError;
    }

    public RubyClass getStandardError() {
        return this.standardError;
    }

    public RubyClass getRuntimeError() {
        return this.runtimeError;
    }

    public RubyClass getFrozenError() {
        return this.frozenError;
    }

    public RubyClass getIOError() {
        return this.ioError;
    }

    public RubyClass getIOTimeoutError() {
        return this.ioTimeoutError;
    }

    public RubyClass getLoadError() {
        return this.loadError;
    }

    public RubyClass getNotImplementedError() {
        return this.notImplementedError;
    }

    public RubyClass getSecurityError() {
        return this.securityError;
    }

    public RubyClass getNoMemoryError() {
        return this.noMemoryError;
    }

    public RubyClass getRegexpError() {
        return this.regexpError;
    }

    public RubyClass getInterruptedRegexpError() {
        return this.interruptedRegexpError;
    }

    public RubyClass getEOFError() {
        return this.eofError;
    }

    public RubyClass getThreadError() {
        return this.threadError;
    }

    public RubyClass getConcurrencyError() {
        return this.concurrencyError;
    }

    public RubyClass getSystemStackError() {
        return this.systemStackError;
    }

    public RubyClass getZeroDivisionError() {
        return this.zeroDivisionError;
    }

    public RubyClass getFloatDomainError() {
        return this.floatDomainError;
    }

    public RubyClass getMathDomainError() {
        return this.mathDomainError;
    }

    public RubyClass getEncodingError() {
        return this.encodingError;
    }

    public RubyClass getEncodingCompatibilityError() {
        return this.encodingCompatibilityError;
    }

    public RubyClass getConverterNotFoundError() {
        return this.converterNotFoundError;
    }

    public RubyClass getFiberError() {
        return this.fiberError;
    }

    public RubyClass getUndefinedConversionError() {
        return this.undefinedConversionError;
    }

    public RubyClass getInvalidByteSequenceError() {
        return this.invalidByteSequenceError;
    }

    public RubyClass getBufferLockedError() {
        return this.bufferLockedError;
    }

    public RubyClass getBufferAllocationError() {
        return this.bufferAllocationError;
    }

    public RubyClass getBufferAccessError() {
        return this.bufferAccessError;
    }

    public RubyClass getBufferInvalidatedError() {
        return this.bufferInvalidatedError;
    }

    public RubyClass getBufferMaskError() {
        return this.bufferMaskError;
    }

    public RubyClass getData() {
        return this.dataClass;
    }

    public RubyRandom getDefaultRandom() {
        return this.defaultRandom;
    }

    public void setDefaultRandom(RubyRandom random) {
        this.defaultRandom = random;
    }

    public IRubyObject getVerbose() {
        return this.verboseValue;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean warningsEnabled() {
        return this.warningsEnabled && this.verboseWarnings;
    }

    public void setWarningsEnabled(boolean warningsEnabled) {
        this.warningsEnabled = warningsEnabled;
    }

    public void setVerbose(IRubyObject verbose) {
        this.verbose = verbose.isTrue();
        this.verboseValue = verbose;
        this.verboseWarnings = !verbose.isNil();
    }

    public void setVerbose(Boolean verbose) {
        this.setVerbose(verbose == null ? this.nilObject : (verbose != false ? this.trueObject : this.falseObject));
    }

    public IRubyObject getDebug() {
        return this.debug ? this.trueObject : this.falseObject;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(IRubyObject debug) {
        this.setDebug(debug.isTrue());
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Set<RubyWarnings.Category> getWarningCategories() {
        return this.warningCategories;
    }

    public JavaSupport getJavaSupport() {
        return this.javaSupport;
    }

    public RubyObjectSpecializer getObjectSpecializer() {
        return this.objectSpecializer;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader loader = Ruby.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public JRubyClassLoader getJRubyClassLoader() {
        return this.jrubyClassLoader;
    }

    public void defineVariable(final GlobalVariable variable, GlobalVariable.Scope scope) {
        this.globalVariables.define(variable.name(), new IAccessor(){

            @Override
            public IRubyObject getValue() {
                return variable.get();
            }

            @Override
            public IRubyObject setValue(IRubyObject newValue) {
                return variable.set(newValue);
            }
        }, scope);
    }

    public void defineReadonlyVariable(String name2, IRubyObject value2, GlobalVariable.Scope scope) {
        this.globalVariables.defineReadonly(name2, new ValueAccessor(value2), scope);
    }

    @Deprecated(since="9.4.6.0")
    public Node parseFile(InputStream in, String file2, DynamicScope scope) {
        return (Node)this.getParserManager().parseMainFile(file2, 0, in, this.setupSourceEncoding(UTF8Encoding.INSTANCE), scope, ParserType.MAIN).getAST();
    }

    @Deprecated(since="9.4.6.0")
    public ParseResult parseFile(String file2, InputStream in, DynamicScope scope) {
        return this.getParserManager().parseMainFile(file2, 0, in, this.setupSourceEncoding(UTF8Encoding.INSTANCE), scope, ParserType.MAIN);
    }

    @Deprecated(since="9.4.6.0")
    public Node parseFile(InputStream in, String file2, DynamicScope scope, int lineNumber) {
        return (Node)this.getParserManager().parseMainFile(file2, lineNumber, in, this.setupSourceEncoding(UTF8Encoding.INSTANCE), scope, ParserType.MAIN).getAST();
    }

    @Deprecated(since="9.4.6.0")
    public ParseResult parseFile(String file2, InputStream in, DynamicScope scope, int lineNumber) {
        return this.getParserManager().parseMainFile(file2, lineNumber, in, this.setupSourceEncoding(UTF8Encoding.INSTANCE), scope, ParserType.MAIN);
    }

    @Deprecated(since="9.4.6.0")
    public Node parseFileFromMain(InputStream in, String file2, DynamicScope scope) {
        return (Node)this.getParserManager().parseMainFile(file2, 0, in, this.setupSourceEncoding(UTF8Encoding.INSTANCE), scope, ParserType.MAIN).getAST();
    }

    @Deprecated(since="9.4.6.0")
    public ParseResult parseFileFromMain(String file2, InputStream in, DynamicScope scope) {
        return this.getParserManager().parseMainFile(file2, 0, in, this.setupSourceEncoding(UTF8Encoding.INSTANCE), scope, ParserType.MAIN);
    }

    @Deprecated(since="9.4.6.0")
    private Node parseFileFromMainAndGetAST(InputStream in, String file2, DynamicScope scope) {
        return (Node)this.getParserManager().parseMainFile(file2, 0, in, this.setupSourceEncoding(UTF8Encoding.INSTANCE), scope, ParserType.MAIN).getAST();
    }

    @Deprecated(since="9.4.6.0")
    private Node parseFileAndGetAST(InputStream in, String file2, DynamicScope scope, int lineNumber, boolean isFromMain) {
        if (isFromMain) {
            return (Node)this.getParserManager().parseMainFile(file2, lineNumber, in, this.setupSourceEncoding(UTF8Encoding.INSTANCE), scope, ParserType.MAIN).getAST();
        }
        return (Node)this.getParserManager().parseFile(file2, lineNumber, in, this.setupSourceEncoding(UTF8Encoding.INSTANCE)).getAST();
    }

    @Deprecated(since="9.4.6.0")
    public Node parseInline(InputStream in, String file2, DynamicScope scope) {
        return (Node)this.getParserManager().parseMainFile(file2, 0, in, this.setupSourceEncoding(this.getEncodingService().getLocaleEncoding()), scope, ParserType.INLINE).getAST();
    }

    public Encoding setupSourceEncoding(Encoding defaultEncoding) {
        if (this.config.getSourceEncoding() == null) {
            return defaultEncoding;
        }
        if (this.config.isVerbose()) {
            this.config.getError().println("-K is specified; it is for 1.8 compatibility and may cause odd behavior");
        }
        return this.getEncodingService().getEncodingFromString(this.config.getSourceEncoding());
    }

    @Deprecated(since="9.4.6.0")
    public Node parseEval(String source2, String file2, DynamicScope scope, int lineNumber) {
        return (Node)this.getParserManager().parseEval(file2, lineNumber, source2, scope).getAST();
    }

    private byte[] encodeToBytes(String string2) {
        Charset charset = this.getDefaultCharset();
        return charset == null ? string2.getBytes() : string2.getBytes(charset);
    }

    @Deprecated(since="9.4.6.0")
    public ParseResult parseEval(ByteList source2, String file2, DynamicScope scope, int lineNumber) {
        return this.getParserManager().parseEval(file2, lineNumber, source2, scope);
    }

    @Deprecated(since="9.4.6.0")
    public Node parse(ByteList content, String file2, DynamicScope scope, int lineNumber, boolean extraPositionInformation) {
        ByteArrayInputStream in = new ByteArrayInputStream(content.getUnsafeBytes(), content.begin(), content.length());
        if (extraPositionInformation) {
            return (Node)this.getParserManager().parseMainFile(file2, lineNumber, in, content.getEncoding(), scope, ParserType.INLINE).getAST();
        }
        return (Node)this.getParserManager().parseFile(file2, lineNumber, in, content.getEncoding()).getAST();
    }

    public ThreadService getThreadService() {
        return this.threadService;
    }

    public ThreadContext getCurrentContext() {
        return ThreadService.getCurrentContext(this.threadService);
    }

    public LoadService getLoadService() {
        return this.loadService;
    }

    public Encoding getDefaultInternalEncoding() {
        return this.encodingService.getDefaultInternalEncoding();
    }

    public void setDefaultInternalEncoding(Encoding defaultInternalEncoding) {
        this.encodingService.setDefaultInternalEncoding(defaultInternalEncoding);
    }

    public Encoding getDefaultExternalEncoding() {
        return this.encodingService.getDefaultExternalEncoding();
    }

    public void setDefaultExternalEncoding(Encoding defaultExternalEncoding) {
        this.encodingService.setDefaultExternalEncoding(defaultExternalEncoding);
    }

    public Encoding getDefaultFilesystemEncoding() {
        return this.encodingService.getDefaultFilesystemEncoding();
    }

    public void setDefaultFilesystemEncoding(Encoding defaultFilesystemEncoding) {
        this.encodingService.setDefaultFilesystemEncoding(defaultFilesystemEncoding);
    }

    public Charset getDefaultCharset() {
        try {
            return EncodingUtils.charsetForEncoding(this.getDefaultEncoding());
        }
        catch (UnsupportedCharsetException e) {
            return null;
        }
    }

    public Encoding getDefaultEncoding() {
        Encoding enc = this.getDefaultInternalEncoding();
        if (enc == null) {
            enc = UTF8Encoding.INSTANCE;
        }
        return enc;
    }

    public EncodingService getEncodingService() {
        return this.encodingService;
    }

    public RubyWarnings getWarnings() {
        return this.warnings;
    }

    WarnCallback getRegexpWarnings() {
        return this.regexpWarnings;
    }

    public IRubyObject getStderr() {
        return this.getGlobalVariables().get("$stderr");
    }

    public IRubyObject getOriginalStderr() {
        return this.originalStderr;
    }

    void setOriginalStderr(IRubyObject stderr) {
        this.originalStderr = stderr;
    }

    public PrintStream getErrorStream() {
        return new PrintStream(new IOOutputStream(this.getGlobalVariables().get("$stderr")));
    }

    public InputStream getInputStream() {
        return new IOInputStream(this.getGlobalVariables().get("$stdin"));
    }

    public PrintStream getOutputStream() {
        return new PrintStream(new IOOutputStream(this.getGlobalVariables().get("$stdout")));
    }

    public RubyModule getClassFromPath(String path2) {
        return this.getClassFromPath(path2, this.getTypeError(), true);
    }

    public RubyModule getClassFromPath(String path2, RubyClass undefinedExceptionClass, boolean flexibleSearch) {
        ThreadContext context = this.getCurrentContext();
        if (path2.length() == 0 || path2.charAt(0) == '#') {
            throw Error.typeError(context, RubyStringBuilder.str(this, "can't retrieve anonymous class ", RubyStringBuilder.ids(this, path2)));
        }
        RubyModule clazz = this.getObject();
        int pbeg = 0;
        int p2 = 0;
        int length2 = path2.length();
        while (p2 < length2) {
            IRubyObject cc;
            while (p2 < length2 && path2.charAt(p2) != ':') {
                ++p2;
            }
            String str = path2.substring(pbeg, p2);
            if (p2 < length2 && path2.charAt(p2) == ':') {
                if (++p2 < length2 && path2.charAt(p2) != ':') {
                    throw this.classPathUndefinedException(path2, undefinedExceptionClass, p2);
                }
                pbeg = ++p2;
            }
            IRubyObject iRubyObject = cc = flexibleSearch || Ruby.isJavaPackageOrJavaClassProxyType(clazz) ? clazz.getConstant(context, str) : clazz.getConstantAt(context, str);
            if (cc == null) {
                throw this.classPathUndefinedException(path2, undefinedExceptionClass, p2);
            }
            if (!(cc instanceof RubyModule)) {
                throw Error.typeError(context, RubyStringBuilder.str(this, RubyStringBuilder.ids(this, path2), " does not refer to class/module"));
            }
            RubyModule mod = (RubyModule)cc;
            clazz = mod;
        }
        return clazz;
    }

    private RaiseException classPathUndefinedException(String path2, RubyClass undefinedExceptionClass, int p2) {
        return this.newRaiseException(undefinedExceptionClass, RubyStringBuilder.str(this, "undefined class/module ", RubyStringBuilder.ids(this, path2.substring(0, p2))));
    }

    private static boolean isJavaPackageOrJavaClassProxyType(RubyModule type2) {
        return type2 instanceof JavaPackage || ClassUtils.isJavaClassProxyType(type2);
    }

    public void printError(RubyException ex) {
        if (ex == null) {
            return;
        }
        boolean formatted = this.getStderr() == this.getOriginalStderr() && this.getErr() == System.err && this.getPosix().isatty(FileDescriptor.err);
        String backtrace2 = this.config.getTraceType().printBacktrace(ex, formatted);
        this.printErrorString(backtrace2);
    }

    public void printError(Throwable ex) {
        if (ex instanceof RaiseException) {
            this.printError(((RaiseException)ex).getException());
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(baos));
        try {
            this.printErrorString(baos.toByteArray());
        }
        catch (Exception e) {
            try {
                System.err.write(baos.toByteArray());
            }
            catch (IOException ioe) {
                ioe.initCause(e);
                throw new RuntimeException("BUG: could not write exception trace", ioe);
            }
        }
    }

    public void printErrorString(String msg) {
        WritableByteChannel writeChannel;
        IRubyObject stderr = this.getStderr();
        if (stderr == this.getOriginalStderr() && (writeChannel = ((RubyIO)stderr).getOpenFile().fd().chWrite) != null) {
            Writer writer = Channels.newWriter(writeChannel, "UTF-8");
            try {
                writer.write(msg);
                writer.flush();
            }
            catch (IOException iOException) {}
        } else {
            this.getErrorStream().print(msg);
        }
    }

    public void printErrorString(byte[] msg) {
        IRubyObject stderr = this.getGlobalVariables().get("$stderr");
        try {
            WritableByteChannel writeChannel;
            if (stderr == this.getOriginalStderr() && (writeChannel = ((RubyIO)stderr).getOpenFile().fd().chWrite) != null) {
                writeChannel.write(ByteBuffer.wrap(msg));
            } else {
                this.getErrorStream().write(msg);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String scriptName, InputStream in, boolean wrap2) {
        Script script;
        IRubyObject self2;
        IRubyObject iRubyObject = self2 = wrap2 ? this.getTopSelf().rbClone() : this.getTopSelf();
        if (!wrap2 && Options.COMPILE_CACHE_CLASSES.load().booleanValue() && (script = this.tryScriptFromClass(scriptName)) != null) {
            this.runScript(script, self2, wrap2);
            return;
        }
        ThreadContext context = this.getCurrentContext();
        try {
            context.preNodeEval(self2);
            ParseResult parseResult = this.getParserManager().parseFile(scriptName, 0, in, this.setupSourceEncoding(UTF8Encoding.INSTANCE));
            if (wrap2) {
                this.wrapWithModule((RubyBasicObject)self2, parseResult);
            }
            this.runInterpreter(context, parseResult, self2);
        }
        finally {
            context.postNodeEval();
        }
    }

    public void loadScope(IRScope scope, boolean wrap2) {
        IRubyObject self2;
        IRubyObject iRubyObject = self2 = wrap2 ? this.getTopSelf().rbClone() : this.getTopSelf();
        if (wrap2) {
            scope.getStaticScope().setModule(new RubyModule(this));
        }
        this.runInterpreter(this.getCurrentContext(), scope, self2);
    }

    public void compileAndLoadFile(String filename2, InputStream in, boolean wrap2) {
        Script script;
        IRubyObject self2;
        IRubyObject iRubyObject = self2 = wrap2 ? this.getTopSelf().rbClone() : this.getTopSelf();
        if (!wrap2 && Options.COMPILE_CACHE_CLASSES.load().booleanValue() && (script = this.tryScriptFromClass(filename2)) != null) {
            this.runScript(script, self2, wrap2);
            return;
        }
        ParseResult parseResult = this.getParserManager().parseFile(filename2, 0, in, this.setupSourceEncoding(UTF8Encoding.INSTANCE));
        if (wrap2) {
            this.wrapWithModule((RubyBasicObject)self2, parseResult);
        } else {
            parseResult.getStaticScope().setModule(this.getObject());
        }
        this.runNormally(parseResult, self2, wrap2);
    }

    public StaticScope setupWrappedToplevel(IRubyObject self2, StaticScope top) {
        RubyModule wrapper = this.loadService.getWrapperSelf();
        if (wrapper == null || wrapper.isNil()) {
            wrapper = new RubyModule(this);
        }
        ((RubyBasicObject)self2).extend(new IRubyObject[]{wrapper});
        StaticScope newTop = this.staticScopeFactory.newLocalScope(null);
        top.setPreviousCRefScope(newTop);
        top.setModule(wrapper);
        return newTop;
    }

    private void wrapWithModule(RubyBasicObject self2, ParseResult result2) {
        this.setupWrappedToplevel(self2, result2.getStaticScope());
    }

    public void loadScript(Script script) {
        this.loadScript(script, false);
    }

    public void loadScript(Script script, boolean wrap2) {
        script.load(this.getCurrentContext(), this.getTopSelf(), wrap2);
    }

    public void loadExtension(String extName, BasicLibraryService extension, boolean wrap2) {
        ThreadContext context = this.getCurrentContext();
        RubyObject topSelf = new RubyObject(this, this.objectClass);
        IRubyObject self2 = wrap2 ? TopSelfFactory.finishTopSelf(context, topSelf, this.objectClass, true) : this.getTopSelf();
        try {
            context.preExtensionLoad(self2);
            extension.basicLoad(this);
        }
        catch (IOException ioe) {
            throw this.newIOErrorFromException(ioe);
        }
        finally {
            context.postNodeEval();
        }
    }

    public void addBoundMethod(String className, String methodName, String rubyName) {
        Map javaToRuby = this.boundMethods.computeIfAbsent(className, s2 -> new ConcurrentHashMap(2, 0.9f, 2));
        javaToRuby.putIfAbsent(methodName, rubyName);
    }

    public void addBoundMethods(String className, String ... tuples) {
        Map javaToRuby = this.boundMethods.computeIfAbsent(className, s2 -> new ConcurrentHashMap(2, 0.9f, 2));
        for (int i2 = 0; i2 < tuples.length; i2 += 2) {
            javaToRuby.putIfAbsent(tuples[i2], tuples[i2 + 1]);
        }
    }

    public void addBoundMethods(int tuplesIndex, String ... classNamesAndTuples) {
        int i2;
        HashMap<String, String> javaToRuby = new HashMap<String, String>((classNamesAndTuples.length - tuplesIndex) / 2 + 1, 1.0f);
        for (i2 = tuplesIndex; i2 < classNamesAndTuples.length; i2 += 2) {
            javaToRuby.put(classNamesAndTuples[i2], classNamesAndTuples[i2 + 1]);
        }
        for (i2 = 0; i2 < tuplesIndex; ++i2) {
            String className = classNamesAndTuples[i2];
            Map javaToRubyForClass = this.boundMethods.computeIfAbsent(className, s2 -> new ConcurrentHashMap((int)((float)javaToRuby.size() / 0.9f) + 1, 0.9f, 2));
            for (Map.Entry entry : javaToRuby.entrySet()) {
                javaToRubyForClass.putIfAbsent((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public Map<String, Map<String, String>> getBoundMethods() {
        return this.boundMethods;
    }

    public TraceEventManager getTraceEvents() {
        return this.traceEvents;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public void pushExitFunction(ExitFunction func) {
        this.exitBlocks.add(0, func);
    }

    public IRubyObject pushExitBlock(RubyProc proc2) {
        ProcExitFunction func = new ProcExitFunction(proc2);
        this.pushExitFunction(func);
        return proc2;
    }

    public void pushPostExitFunction(ExitFunction postExit) {
        this.postExitBlocks.add(0, postExit);
    }

    public void pushEndBlock(RubyProc proc2) {
        if (this.alreadyRegisteredEndBlock(proc2)) {
            return;
        }
        this.pushExitBlock(proc2);
    }

    private boolean alreadyRegisteredEndBlock(RubyProc newProc) {
        return this.exitBlocks.stream().anyMatch(func -> func.matches(newProc));
    }

    public void addInternalFinalizer(Finalizable finalizer) {
        this.internalFinalizersMutex.lock();
        try {
            this.internalFinalizers.put(finalizer, null);
        }
        finally {
            this.internalFinalizersMutex.unlock();
        }
    }

    public void addFinalizer(Finalizable finalizer) {
        this.finalizersMutex.lock();
        try {
            this.finalizers.put(finalizer, null);
        }
        finally {
            this.finalizersMutex.unlock();
        }
    }

    public void removeInternalFinalizer(Finalizable finalizer) {
        this.internalFinalizersMutex.lock();
        try {
            this.internalFinalizers.remove(finalizer);
        }
        finally {
            this.internalFinalizersMutex.unlock();
        }
    }

    public void removeFinalizer(Finalizable finalizer) {
        this.finalizersMutex.lock();
        try {
            this.finalizers.remove(finalizer);
        }
        finally {
            this.finalizersMutex.unlock();
        }
    }

    public void tearDown() {
        this.tearDown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void tearDown(boolean systemExit) {
        ThreadContext context = this.getCurrentContext();
        int status2 = this.userTeardown(context);
        this.systemTeardown(context);
        if (systemExit && status2 != 0) {
            throw this.newSystemExit(status2);
        }
        if (this != globalRuntime) return;
        Class<Ruby> clazz = Ruby.class;
        synchronized (Ruby.class) {
            if (this != globalRuntime) return;
            globalRuntime = null;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void systemTeardown(ThreadContext context) {
        RubyArray ary;
        IRubyObject[] trapResultEntries;
        IRubyObject exitHandlerProc;
        block11: {
            while (!this.postExitBlocks.isEmpty()) {
                ExitFunction fun = this.postExitBlocks.remove(0);
                fun.applyAsInt(context);
            }
            this.internalFinalizersMutex.lock();
            try {
                if (this.internalFinalizers.isEmpty()) break block11;
                Iterator<Finalizable> finalIter = new ArrayList<Finalizable>(this.internalFinalizers.keySet()).iterator();
                while (finalIter.hasNext()) {
                    Finalizable f = finalIter.next();
                    if (f != null) {
                        try {
                            f.finalize();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    finalIter.remove();
                }
            }
            finally {
                this.internalFinalizersMutex.unlock();
            }
        }
        this.getBeanManager().unregisterCompiler();
        this.getBeanManager().unregisterConfig();
        this.getBeanManager().unregisterParserStats();
        this.getBeanManager().unregisterMethodCache();
        this.getBeanManager().unregisterRuntime();
        this.getSelectorPool().cleanup();
        if (this.config.isProfilingEntireRun()) {
            ProfileCollection profileCollection = this.threadService.getMainThread().getContext().getProfileCollection();
            this.printProfileData(profileCollection);
        }
        if (Options.PARSER_SUMMARY.load().booleanValue()) {
            this.parserManager.getParserStats().printParserStatistics();
        }
        this.getJITCompiler().shutdown();
        this.getExecutor().shutdown();
        this.getFiberExecutor().shutdown();
        IRubyObject trapResult = RubySignal.__jtrap_osdefault_kernel(context, this.getNil(), this.newString("EXIT"));
        if (trapResult instanceof RubyArray && (exitHandlerProc = (trapResultEntries = (ary = (RubyArray)trapResult).toJavaArray(context))[0]) instanceof RubyProc) {
            ((RubyProc)exitHandlerProc).call(context, this.getSingleNilArray());
        }
        this.threadService.teardown();
        this.threadService = new ThreadService(this);
        this.releaseClassLoader();
        this.loadService.tearDown();
        this.boundMethods.clear();
        this.allModules.clear();
        this.constantNameInvalidators.clear();
        this.symbolTable.clear();
        this.javaSupport = this.loadJavaSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int userTeardown(ThreadContext context) {
        int status2 = 0;
        if (!context.hasAnyScopes()) {
            StaticScope topStaticScope = this.getStaticScopeFactory().newLocalScope(null);
            context.pushScope(new ManyVarsDynamicScope(topStaticScope, null));
        }
        while (!this.exitBlocks.isEmpty()) {
            ExitFunction fun = this.exitBlocks.remove(0);
            int ret = fun.applyAsInt(context);
            if (ret == 0) continue;
            status2 = ret;
        }
        if (this.finalizers != null) {
            ReentrantLock reentrantLock = this.finalizersMutex;
            synchronized (reentrantLock) {
                Iterator<Finalizable> finalIter = new ArrayList<Finalizable>(this.finalizers.keySet()).iterator();
                while (finalIter.hasNext()) {
                    Finalizable f = finalIter.next();
                    if (f != null) {
                        try {
                            f.finalize();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    finalIter.remove();
                }
            }
        }
        return status2;
    }

    public void releaseClassLoader() {
        if (this.jrubyClassLoader != null) {
            this.jrubyClassLoader.close();
        }
    }

    public synchronized void printProfileData(ProfileCollection profileData) {
        this.getProfilingService().newProfileReporter(this.getCurrentContext()).report(profileData);
    }

    private ProfilingServiceLookup getProfilingServiceLookup() {
        return this.profilingServiceLookup;
    }

    public ProfilingService getProfilingService() {
        ProfilingServiceLookup lockup = this.getProfilingServiceLookup();
        return lockup == null ? null : lockup.getService();
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray newEmptyArray() {
        return RubyArray.newEmptyArray(this);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray newArray() {
        return RubyArray.newArray(this.getCurrentContext());
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray newArrayLight() {
        return RubyArray.newArrayLight(this);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray newArray(IRubyObject object) {
        return RubyArray.newArray(this, object);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray newArray(IRubyObject car, IRubyObject cdr) {
        return RubyArray.newArray(this, car, cdr);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray newArray(IRubyObject ... objects) {
        return RubyArray.newArray(this, objects);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray newArrayNoCopy(IRubyObject ... objects) {
        return RubyArray.newArrayNoCopy(this, objects);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray newArrayNoCopyLight(IRubyObject ... objects) {
        return RubyArray.newArrayNoCopyLight(this, objects);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray newArray(List<IRubyObject> list2) {
        return RubyArray.newArray(this, list2);
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray newArray(int size2) {
        return RubyArray.newArray(this.getCurrentContext(), size2);
    }

    public RubyArray getEmptyFrozenArray() {
        return this.emptyFrozenArray;
    }

    public RubyString getEmptyFrozenString() {
        return this.emptyFrozenString;
    }

    public RubyBoolean newBoolean(boolean value2) {
        return value2 ? this.trueObject : this.falseObject;
    }

    public RubyFileStat newFileStat(String filename2, boolean lstat2) {
        return RubyFileStat.newFileStat(this, filename2, lstat2);
    }

    public RubyFileStat newFileStat(FileDescriptor descriptor) {
        return RubyFileStat.newFileStat(this, descriptor);
    }

    public RubyFixnum newFixnum(long value2) {
        return RubyFixnum.newFixnum(this, value2);
    }

    public RubyFixnum newFixnum(int value2) {
        return RubyFixnum.newFixnum(this, value2);
    }

    public RubyFixnum newFixnum(Constant value2) {
        return RubyFixnum.newFixnum(this, value2.intValue());
    }

    public RubyFloat newFloat(double value2) {
        return RubyFloat.newFloat(this, value2);
    }

    public RubyNumeric newNumeric() {
        return RubyNumeric.newNumeric(this);
    }

    public RubyRational newRational(long num, long den) {
        return RubyRational.newRationalRaw(this, this.newFixnum(num), this.newFixnum(den));
    }

    public RubyRational newRationalReduced(long num, long den) {
        return (RubyRational)RubyRational.newRationalConvert(this.getCurrentContext(), this.newFixnum(num), this.newFixnum(den));
    }

    public RubyProc newProc(Block.Type type2, Block block) {
        if (type2 != Block.Type.LAMBDA && block.getProcObject() != null) {
            return block.getProcObject();
        }
        return RubyProc.newProc(this, block, type2);
    }

    public RubyProc newBlockPassProc(Block.Type type2, Block block) {
        if (type2 != Block.Type.LAMBDA && block.getProcObject() != null) {
            return block.getProcObject();
        }
        return RubyProc.newProc(this, block, type2);
    }

    public RubyBinding newBinding() {
        return RubyBinding.newBinding(this, this.getCurrentContext().currentBinding());
    }

    public RubyBinding newBinding(Binding binding2) {
        return RubyBinding.newBinding(this, binding2);
    }

    public RubyString newString() {
        return RubyString.newString(this, new ByteList());
    }

    public RubyString newString(String string2) {
        return RubyString.newString(this, string2);
    }

    public RubyString newDeduplicatedString(String string2) {
        return this.freezeAndDedupString(RubyString.newString(this, string2));
    }

    public RubyString newString(ByteList byteList) {
        return RubyString.newString(this, byteList);
    }

    public RubySymbol newSymbol(String name2) {
        return this.symbolTable.getSymbol(name2);
    }

    public RubySymbol newSymbol(String name2, Encoding encoding2) {
        ByteList byteList = RubyString.encodeBytelist(name2, encoding2);
        return this.symbolTable.getSymbol(byteList);
    }

    public RubySymbol newSymbol(ByteList name2) {
        return this.symbolTable.getSymbol(name2);
    }

    public RubySymbol fastNewSymbol(String internedName) {
        return this.symbolTable.fastGetSymbol(internedName);
    }

    public RubyTime newTime(long milliseconds) {
        return RubyTime.newTime(this, milliseconds);
    }

    public RaiseException newRuntimeError(String message2) {
        return this.newRaiseException(this.getRuntimeError(), message2);
    }

    public RaiseException newArgumentError(String message2) {
        return this.newRaiseException(this.getArgumentError(), message2);
    }

    @Deprecated(since="10.0.0.0")
    public RaiseException newArgumentError(int got, int expected) {
        return this.newArgumentError(got, expected, expected);
    }

    public RaiseException newArgumentError(int got, int min2, int max2) {
        if (min2 == max2) {
            return this.newRaiseException(this.getArgumentError(), "wrong number of arguments (given " + got + ", expected " + min2 + ")");
        }
        if (max2 == -1) {
            return this.newRaiseException(this.getArgumentError(), "wrong number of arguments (given " + got + ", expected " + min2 + "+)");
        }
        return this.newRaiseException(this.getArgumentError(), "wrong number of arguments (given " + got + ", expected " + min2 + ".." + max2 + ")");
    }

    @Deprecated(since="10.0.0.0")
    public RaiseException newArgumentError(String name2, int got, int expected) {
        return this.newArgumentError(name2, got, expected, expected);
    }

    @Deprecated(since="10.0.0.0")
    public RaiseException newArgumentError(String name2, int got, int min2, int max2) {
        if (min2 == max2) {
            return this.newRaiseException(this.getArgumentError(), "wrong number of arguments (given " + got + ", expected " + min2 + ")");
        }
        if (max2 == -1) {
            return this.newRaiseException(this.getArgumentError(), "wrong number of arguments (given " + got + ", expected " + min2 + "+)");
        }
        return this.newRaiseException(this.getArgumentError(), "wrong number of arguments (given " + got + ", expected " + min2 + ".." + max2 + ")");
    }

    public RaiseException newErrnoEBADFError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EBADF"), "Bad file descriptor");
    }

    public RaiseException newErrnoEISCONNError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EISCONN"), "Socket is already connected");
    }

    public RaiseException newErrnoEINPROGRESSError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EINPROGRESS"), "Operation now in progress");
    }

    public RaiseException newErrnoEINPROGRESSWritableError() {
        ThreadContext context = this.getCurrentContext();
        return this.newLightweightErrnoException(this.getIO().getClass(context, "EINPROGRESSWaitWritable"), "");
    }

    public RaiseException newErrnoENOPROTOOPTError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ENOPROTOOPT"), "Protocol not available");
    }

    public RaiseException newErrnoEPIPEError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EPIPE"), "Broken pipe");
    }

    public RaiseException newErrnoECONNABORTEDError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ECONNABORTED"), "An established connection was aborted by the software in your host machine");
    }

    public RaiseException newErrnoECONNREFUSEDError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ECONNREFUSED"), "Connection refused");
    }

    public RaiseException newErrnoECONNREFUSEDError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ECONNREFUSED"), message2);
    }

    public RaiseException newErrnoECONNRESETError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ECONNRESET"), "Connection reset by peer");
    }

    public RaiseException newErrnoEADDRINUSEError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EADDRINUSE"), "Address in use");
    }

    public RaiseException newErrnoEADDRINUSEError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EADDRINUSE"), message2);
    }

    public RaiseException newErrnoEHOSTUNREACHError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EHOSTUNREACH"), message2);
    }

    public RaiseException newErrnoEINVALError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EINVAL"), "Invalid file");
    }

    public RaiseException newErrnoELOOPError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ELOOP"), "Too many levels of symbolic links");
    }

    public RaiseException newErrnoEMFILEError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EMFILE"), "Too many open files");
    }

    public RaiseException newErrnoENFILEError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ENFILE"), "Too many open files in system");
    }

    public RaiseException newErrnoENOENTError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ENOENT"), "File not found");
    }

    public RaiseException newErrnoEACCESError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EACCES"), message2);
    }

    public RaiseException newErrnoEAGAINError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newLightweightErrnoException(this.getErrno().getClass(context, "EAGAIN"), message2);
    }

    public RaiseException newErrnoEAGAINReadableError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newLightweightErrnoException(this.getIO().getClass(context, "EAGAINWaitReadable"), message2);
    }

    public RaiseException newErrnoEAGAINWritableError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newLightweightErrnoException(this.getIO().getClass(context, "EAGAINWaitWritable"), message2);
    }

    public RaiseException newErrnoEISDirError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EISDIR"), message2);
    }

    public RaiseException newErrnoEPERMError(String name2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EPERM"), "Operation not permitted - " + name2);
    }

    public RaiseException newErrnoEISDirError() {
        return this.newErrnoEISDirError("Is a directory");
    }

    public RaiseException newErrnoESPIPEError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ESPIPE"), "Illegal seek");
    }

    public RaiseException newErrnoEBADFError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EBADF"), message2);
    }

    public RaiseException newErrnoEINPROGRESSError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EINPROGRESS"), message2);
    }

    public RaiseException newErrnoEINPROGRESSWritableError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newLightweightErrnoException(this.getIO().getClass(context, "EINPROGRESSWaitWritable"), message2);
    }

    public RaiseException newErrnoEISCONNError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EISCONN"), message2);
    }

    public RaiseException newErrnoEINVALError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EINVAL"), message2);
    }

    public RaiseException newErrnoENOTDIRError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ENOTDIR"), message2);
    }

    public RaiseException newErrnoENOTEMPTYError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ENOTEMPTY"), message2);
    }

    public RaiseException newErrnoENOTSOCKError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ENOTSOCK"), message2);
    }

    public RaiseException newErrnoENOTCONNError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ENOTCONN"), message2);
    }

    public RaiseException newErrnoENOTCONNError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ENOTCONN"), "Socket is not connected");
    }

    public RaiseException newErrnoENOENTError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ENOENT"), message2);
    }

    public RaiseException newErrnoEOPNOTSUPPError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EOPNOTSUPP"), message2);
    }

    public RaiseException newErrnoESPIPEError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ESPIPE"), message2);
    }

    public RaiseException newErrnoEEXISTError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EEXIST"), message2);
    }

    public RaiseException newErrnoEDOMError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EDOM"), "Domain error - " + message2);
    }

    public RaiseException newErrnoEDOMError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EDOM"), "Numerical argument out of domain");
    }

    public RaiseException newErrnoECHILDError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ECHILD"), "No child processes");
    }

    public RaiseException newErrnoEADDRNOTAVAILError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EADDRNOTAVAIL"), message2);
    }

    public RaiseException newErrnoESRCHError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ESRCH"), null);
    }

    public RaiseException newErrnoEWOULDBLOCKError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EWOULDBLOCK"), null);
    }

    public RaiseException newErrnoEDESTADDRREQError(String func) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EDESTADDRREQ"), func);
    }

    public RaiseException newErrnoENETUNREACHError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ENETUNREACH"), null);
    }

    public RaiseException newErrnoEMSGSIZEError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EMSGSIZE"), null);
    }

    public RaiseException newErrnoEXDEVError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EXDEV"), message2);
    }

    public RaiseException newIndexError(String message2) {
        return this.newRaiseException(this.getIndexError(), message2);
    }

    public RaiseException newSecurityError(String message2) {
        return this.newRaiseException(this.getSecurityError(), message2);
    }

    public RaiseException newSystemCallError(String message2) {
        return this.newRaiseException(this.getSystemCallError(), message2);
    }

    public RaiseException newKeyError(String message2, IRubyObject recv2, IRubyObject key2) {
        return new RubyKeyError(this, this.getKeyError(), message2, recv2, key2).toThrowable();
    }

    public RaiseException newErrnoEINTRError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EINTR"), "Interrupted");
    }

    public RaiseException newErrnoEAFNOSUPPORTError(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "EAFNOSUPPORT"), message2);
    }

    public RaiseException newErrnoETIMEDOUTError() {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(this.getErrno().getClass(context, "ETIMEDOUT"), "Broken pipe");
    }

    public RaiseException newErrnoFromLastPOSIXErrno() {
        RubyClass errnoClass = this.getErrno(this.getPosix().errno());
        if (errnoClass == null) {
            errnoClass = this.systemCallError;
        }
        return this.newRaiseException(errnoClass, null);
    }

    public RaiseException newErrnoFromInt(int errno2, String methodName, String message2) {
        if (Platform.IS_WINDOWS && ("stat".equals(methodName) || "lstat".equals(methodName))) {
            if (errno2 == 20047) {
                return this.newErrnoENOENTError(message2);
            }
            if (errno2 == Errno.ESRCH.intValue()) {
                return this.newErrnoENOENTError(message2);
            }
        }
        return this.newErrnoFromInt(errno2, message2);
    }

    public RaiseException newErrnoFromInt(int errno2, String message2) {
        RubyClass errnoClass = this.getErrno(errno2);
        if (errnoClass != null) {
            return this.newRaiseException(errnoClass, message2);
        }
        return this.newSystemCallError("Unknown Error (" + errno2 + ") - " + message2);
    }

    public RaiseException newErrnoFromErrno(Errno errno2, String message2) {
        if (errno2 == null || errno2 == Errno.__UNKNOWN_CONSTANT__) {
            return this.newSystemCallError(message2);
        }
        return this.newErrnoFromInt(errno2.intValue(), message2);
    }

    public RaiseException newErrnoFromInt(int errno2) {
        Errno errnoObj = Errno.valueOf(errno2);
        if (errnoObj == null) {
            return this.newSystemCallError("Unknown Error (" + errno2 + ")");
        }
        String message2 = errnoObj.description();
        return this.newErrnoFromInt(errno2, message2);
    }

    public RaiseException newErrnoFromBindException(BindException be, String contextMessage) {
        Errno errno2 = Helpers.errnoFromException(be);
        if (errno2 != null) {
            return this.newErrnoFromErrno(errno2, contextMessage);
        }
        return this.newErrnoEADDRFromBindException(be, contextMessage);
    }

    public RaiseException newErrnoEADDRFromBindException(BindException be, String contextMessage) {
        Object msg = be.getMessage();
        msg = msg == null ? "bind" : "bind - " + (String)msg;
        if (contextMessage != null) {
            msg = (String)msg + contextMessage;
        }
        if (ADDR_NOT_AVAIL_PATTERN.matcher((CharSequence)msg).find()) {
            return this.newErrnoEADDRNOTAVAILError((String)msg);
        }
        return this.newErrnoEADDRINUSEError((String)msg);
    }

    @Deprecated(since="10.0.0.0")
    public RaiseException newTypeError(String message2) {
        return this.newRaiseException(this.getTypeError(), message2);
    }

    public RaiseException newThreadError(String message2) {
        return this.newRaiseException(this.getThreadError(), message2);
    }

    public RaiseException newConcurrencyError(String message2) {
        return this.newRaiseException(this.getConcurrencyError(), message2);
    }

    public RaiseException newSyntaxError(String message2) {
        return this.newRaiseException(this.getSyntaxError(), message2);
    }

    public RaiseException newSyntaxError(String message2, String path2) {
        RaiseException syntaxError = this.newRaiseException(this.getSyntaxError(), message2);
        syntaxError.getException().setInstanceVariable("@path", this.newString(path2));
        return syntaxError;
    }

    public RaiseException newRegexpError(String message2) {
        return this.newRaiseException(this.getRegexpError(), message2);
    }

    public RaiseException newInterruptedRegexpError(String message2) {
        return this.newRaiseException(this.getInterruptedRegexpError(), message2);
    }

    public RaiseException newRangeError(String message2) {
        return this.newRaiseException(this.getRangeError(), message2);
    }

    public RaiseException newNotImplementedError(String message2) {
        return this.newRaiseException(this.getNotImplementedError(), message2);
    }

    @Deprecated(since="9.4-")
    public RaiseException newInvalidEncoding(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(Access.getClass(context, "Iconv", "InvalidEncoding"), message2);
    }

    @Deprecated(since="9.4-")
    public RaiseException newIllegalSequence(String message2) {
        ThreadContext context = this.getCurrentContext();
        return this.newRaiseException(Access.getClass(context, "Iconv", "IllegalSequence"), message2);
    }

    public RaiseException newNameError(String message2, IRubyObject recv2, IRubyObject name2) {
        return this.newNameError(message2, recv2, name2, false);
    }

    public RaiseException newNameError(String message2, IRubyObject recv2, IRubyObject name2, boolean privateCall) {
        RubyNameError.RubyNameErrorMessage msg = new RubyNameError.RubyNameErrorMessage(this, message2, recv2, name2);
        RubyException err = RubyNameError.newNameError(this.getCurrentContext(), this.getNameError(), msg, name2, privateCall);
        return err.toThrowable();
    }

    public RaiseException newNameError(String message2, IRubyObject recv2, String name2) {
        return this.newNameError(message2, recv2, name2, false);
    }

    public RaiseException newNameError(String message2, IRubyObject recv2, String name2, boolean privateCall) {
        RubySymbol nameSym = this.newSymbol(name2);
        return this.newNameError(message2, recv2, nameSym, privateCall);
    }

    public RaiseException newNameError(String message2, String name2, Throwable exception2, boolean printWhenVerbose) {
        if (exception2 != null) {
            if (printWhenVerbose && this.isVerbose()) {
                LOG.error(exception2);
            } else if (this.isDebug()) {
                LOG.debug(exception2);
            }
        }
        return new RubyNameError(this, this.getNameError(), message2, name2).toThrowable();
    }

    public RaiseException newNameError(String message2, IRubyObject name2, Throwable exception2, boolean printWhenVerbose) {
        if (exception2 != null) {
            if (printWhenVerbose && this.isVerbose()) {
                LOG.error(exception2);
            } else if (this.isDebug()) {
                LOG.debug(exception2);
            }
        }
        return new RubyNameError(this, this.getNameError(), message2, name2).toThrowable();
    }

    @Deprecated(since="10.0.0.0")
    public RaiseException newNameError(String message2, String name2) {
        return this.newNameError(message2, name2, null, false);
    }

    @Deprecated(since="10.0.0.0")
    public RaiseException newNameError(String message2, IRubyObject name2) {
        return this.newNameError(message2, name2, (Throwable)null, false);
    }

    @Deprecated(since="10.0.0.0")
    public RaiseException newNameError(String message2, String name2, Throwable origException) {
        return this.newNameError(message2, name2, origException, false);
    }

    public RaiseException newNoMethodError(String message2, IRubyObject recv2, String name2, RubyArray args2) {
        return this.newNoMethodError(message2, recv2, name2, args2, false);
    }

    public RaiseException newNoMethodError(String message2, IRubyObject recv2, String name2, RubyArray args2, boolean privateCall) {
        RubySymbol nameStr = this.newSymbol(name2);
        RubyNameError.RubyNameErrorMessage msg = new RubyNameError.RubyNameErrorMessage(this, message2, recv2, nameStr);
        RubyException err = RubyNoMethodError.newNoMethodError(this.getNoMethodError(), msg, nameStr, args2, privateCall);
        return err.toThrowable();
    }

    public RaiseException newNoMethodError(String message2, String name2, IRubyObject args2) {
        return new RubyNoMethodError(this, this.getNoMethodError(), message2, name2, args2).toThrowable();
    }

    public RaiseException newLocalJumpError(RubyLocalJumpError.Reason reason2, IRubyObject exitValue, String message2) {
        return new RubyLocalJumpError(this, this.getLocalJumpError(), message2, reason2, exitValue).toThrowable();
    }

    public RaiseException newLocalJumpErrorNoBlock() {
        return this.newLocalJumpError(RubyLocalJumpError.Reason.NOREASON, this.getNil(), "no block given");
    }

    public RaiseException newRedoLocalJumpError() {
        return this.newLocalJumpError(RubyLocalJumpError.Reason.REDO, this.getNil(), "unexpected redo");
    }

    public RaiseException newLoadError(String message2) {
        return this.newRaiseException(this.getLoadError(), message2);
    }

    public RaiseException newLoadError(String message2, String path2) {
        RaiseException loadError = this.newRaiseException(this.getLoadError(), message2);
        loadError.getException().setInstanceVariable("@path", this.newString(path2));
        return loadError;
    }

    public RaiseException newFrozenError(String objectType, IRubyObject receiver2) {
        ThreadContext context = this.getCurrentContext();
        IRubyObject inspected = context.safeRecurse(Ruby::inspectFrozenObject, this, receiver2, "inspect", true);
        String message2 = "can't modify frozen " + objectType + ": " + inspected.convertToString().toString();
        return this.newFrozenError(receiver2, message2);
    }

    @Deprecated(since="10.0.0.0")
    public RaiseException newFrozenError(IRubyObject receiver2, String message2) {
        ThreadContext context = this.getCurrentContext();
        return RubyFrozenError.newFrozenError(context, this.newString(message2), receiver2).toThrowable();
    }

    public RaiseException newFrozenError(IRubyObject receiver2) {
        return this.newFrozenError(receiver2.getType().toString(), receiver2);
    }

    private static IRubyObject inspectFrozenObject(ThreadContext context, Ruby runtime2, IRubyObject obj, boolean recur) {
        return recur ? Create.newString(context, " ...") : obj.inspect(context);
    }

    public RaiseException newSystemStackError(String message2) {
        return this.newRaiseException(this.getSystemStackError(), message2);
    }

    public RaiseException newSystemStackError(String message2, StackOverflowError error2) {
        if (this.isDebug()) {
            LOG.debug(error2);
        }
        return this.newRaiseException(this.getSystemStackError(), message2);
    }

    public RaiseException newSystemExit(int status2) {
        return RubySystemExit.newInstance(this.getCurrentContext(), status2, "exit").toThrowable();
    }

    public RaiseException newSystemExit(int status2, String message2) {
        return RubySystemExit.newInstance(this.getCurrentContext(), status2, message2).toThrowable();
    }

    public RaiseException newIOError(String message2) {
        return this.newRaiseException(this.getIOError(), message2);
    }

    public RaiseException newStandardError(String message2) {
        return this.newRaiseException(this.getStandardError(), message2);
    }

    public RaiseException newIOErrorFromException(IOException ex) {
        return Helpers.newIOErrorFromException(this, ex);
    }

    @Deprecated(since="10.0.0.0")
    public RaiseException newTypeError(IRubyObject receivedObject, RubyClass expectedType) {
        ThreadContext context = this.getCurrentContext();
        return Error.createTypeError(context, Error.createTypeErrorMessage(context, receivedObject, expectedType));
    }

    @Deprecated(since="10.0.0.0")
    public RaiseException newTypeError(IRubyObject receivedObject, RubyModule expectedType) {
        ThreadContext context = this.getCurrentContext();
        return Error.createTypeError(context, Error.createTypeErrorMessage(context, receivedObject, expectedType));
    }

    @Deprecated(since="10.0.0.0")
    public RaiseException newTypeError(IRubyObject receivedObject, String expectedType) {
        return this.newRaiseException(this.getTypeError(), RubyStringBuilder.str(this, "wrong argument type ", receivedObject.getMetaClass().getRealClass().toRubyString(this.getCurrentContext()), " (expected ", RubyStringBuilder.ids(this, expectedType), ")"));
    }

    public RaiseException newEOFError() {
        return this.newRaiseException(this.getEOFError(), "End of file reached");
    }

    public RaiseException newEOFError(String message2) {
        return this.newRaiseException(this.getEOFError(), message2);
    }

    public RaiseException newZeroDivisionError() {
        return this.newRaiseException(this.getZeroDivisionError(), "divided by 0");
    }

    public RaiseException newFloatDomainError(String message2) {
        return this.newRaiseException(this.getFloatDomainError(), message2);
    }

    public RaiseException newMathDomainError(String message2) {
        return this.newRaiseException(this.getMathDomainError(), "Numerical argument is out of domain - \"" + message2 + "\"");
    }

    public RaiseException newEncodingError(String message2) {
        return this.newRaiseException(this.getEncodingError(), message2);
    }

    public RaiseException newEncodingCompatibilityError(String message2) {
        return this.newRaiseException(this.getEncodingCompatibilityError(), message2);
    }

    public RaiseException newConverterNotFoundError(String message2) {
        return this.newRaiseException(this.getConverterNotFoundError(), message2);
    }

    public RaiseException newFiberError(String message2) {
        return this.newRaiseException(this.getFiberError(), message2);
    }

    public RaiseException newUndefinedConversionError(String message2) {
        return this.newRaiseException(this.getUndefinedConversionError(), message2);
    }

    public RaiseException newInvalidByteSequenceError(String message2) {
        return this.newRaiseException(this.getInvalidByteSequenceError(), message2);
    }

    public RaiseException newBufferLockedError(String message2) {
        return this.newRaiseException(this.getBufferLockedError(), message2);
    }

    public RaiseException newBufferAllocationError(String message2) {
        return this.newRaiseException(this.getBufferAllocationError(), message2);
    }

    public RaiseException newBufferAccessError(String message2) {
        return this.newRaiseException(this.getBufferAccessError(), message2);
    }

    public RaiseException newBufferInvalidatedError(String message2) {
        return this.newRaiseException(this.getBufferInvalidatedError(), message2);
    }

    public RaiseException newBufferMaskError(String message2) {
        return this.newRaiseException(this.getBufferMaskError(), message2);
    }

    public RaiseException newRaiseException(RubyClass exceptionClass, String message2) {
        IRubyObject cause2 = this.getCurrentContext().getErrorInfo();
        RaiseException exception2 = RaiseException.from(this, exceptionClass, message2);
        if (cause2 != null && !cause2.isNil()) {
            exception2.getException().setCause(cause2);
        }
        return exception2;
    }

    private RaiseException newLightweightErrnoException(RubyClass exceptionClass, String message2) {
        if (RubyInstanceConfig.ERRNO_BACKTRACE) {
            return RaiseException.from(this, exceptionClass, message2);
        }
        return RaiseException.from(this, exceptionClass, ERRNO_BACKTRACE_MESSAGE, this.disabledBacktrace());
    }

    public RaiseException newStopIteration(IRubyObject result2, String message2) {
        ThreadContext context = this.getCurrentContext();
        if (message2 == null) {
            message2 = STOPIERATION_BACKTRACE_MESSAGE;
        }
        RubyStopIteration ex = RubyStopIteration.newInstance(context, result2, message2);
        if (!RubyInstanceConfig.STOPITERATION_BACKTRACE) {
            ex.setBacktrace(context, this.disabledBacktrace());
        }
        return ex.toThrowable();
    }

    private IRubyObject disabledBacktrace() {
        return RubyArray.newEmptyArray(this);
    }

    public RubyObject.Data newData(RubyClass objectClass, Object sval) {
        return new RubyObject.Data(this, objectClass, sval);
    }

    public RubySymbol.SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public ObjectSpace getObjectSpace() {
        return this.objectSpace;
    }

    public InputStream getIn() {
        return this.in;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.err;
    }

    public boolean isAbortOnException() {
        return this.abortOnException;
    }

    public void setAbortOnException(boolean abortOnException) {
        this.abortOnException = abortOnException;
    }

    @Deprecated(since="9.3.1.0")
    public boolean isGlobalAbortOnExceptionEnabled() {
        return this.abortOnException;
    }

    @Deprecated(since="9.3.1.0")
    public void setGlobalAbortOnExceptionEnabled(boolean enable2) {
        this.abortOnException = enable2;
    }

    @Deprecated(since="9.3.1.0")
    public IRubyObject getReportOnException() {
        return this.reportOnException ? this.getTrue() : this.getFalse();
    }

    public boolean isReportOnException() {
        return this.reportOnException;
    }

    public void setReportOnException(IRubyObject enable2) {
        this.reportOnException = enable2.isTrue();
    }

    public void setReportOnException(boolean enable2) {
        this.reportOnException = enable2;
    }

    public boolean isDoNotReverseLookupEnabled() {
        return this.doNotReverseLookupEnabled;
    }

    public void setDoNotReverseLookupEnabled(boolean b2) {
        this.doNotReverseLookupEnabled = b2;
    }

    public void registerInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        if (val == null) {
            val = new IdentityHashMap<Object, Object>(8);
            this.inspect.set(val);
        }
        val.put(obj, null);
    }

    public boolean isInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        return val != null && val.containsKey(obj);
    }

    public void unregisterInspecting(Object obj) {
        Map<Object, Object> val = this.inspect.get();
        if (val != null) {
            val.remove(obj);
        }
    }

    public boolean isObjectSpaceEnabled() {
        return this.objectSpaceEnabled;
    }

    public void setObjectSpaceEnabled(boolean objectSpaceEnabled) {
        this.objectSpaceEnabled = objectSpaceEnabled;
    }

    public boolean isSiphashEnabled() {
        return this.siphashEnabled;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getJRubyHome() {
        return this.config.getJRubyHome();
    }

    public void setJRubyHome(String home2) {
        this.config.setJRubyHome(home2);
    }

    public RubyInstanceConfig getInstanceConfig() {
        return this.config;
    }

    public static boolean isSecurityRestricted() {
        return securityRestricted;
    }

    public static void setSecurityRestricted(boolean restricted) {
        securityRestricted = restricted;
    }

    public POSIX getPosix() {
        return this.posix;
    }

    public POSIX getNativePosix() {
        POSIX nativePosix = this.nativePosix;
        if (nativePosix == null && this.config.isNativeEnabled()) {
            this.nativePosix = nativePosix = POSIXFactory.getNativePOSIX(new JRubyPOSIXHandler(this));
        }
        return nativePosix;
    }

    public void setRecordSeparatorVar(GlobalVariable recordSeparatorVar) {
        this.recordSeparatorVar = recordSeparatorVar;
    }

    public GlobalVariable getRecordSeparatorVar() {
        return this.recordSeparatorVar;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ExecutorService getFiberExecutor() {
        return this.fiberExecutor;
    }

    public Map<String, DateTimeZone> getTimezoneCache() {
        return this.timeZoneCache;
    }

    public Invalidator getConstantInvalidator(String constantName) {
        Invalidator invalidator = this.constantNameInvalidators.get(constantName);
        if (invalidator != null) {
            return invalidator;
        }
        return this.addConstantInvalidator(constantName);
    }

    private Invalidator addConstantInvalidator(String constantName) {
        Invalidator invalidator = OptoFactory.newConstantInvalidator(this);
        this.constantNameInvalidators.putIfAbsent(constantName, invalidator);
        return this.constantNameInvalidators.get(constantName);
    }

    public Invalidator getCheckpointInvalidator() {
        return this.checkpointInvalidator;
    }

    @Deprecated(since="10.0.0.0")
    public <C extends Enum<C>> void loadConstantSet(RubyModule module, Class<C> enumClass) {
        module.defineConstantsFrom(this.getCurrentContext(), enumClass);
    }

    @Deprecated(since="10.0.0.0")
    public void loadConstantSet(RubyModule module, String constantSetName) {
        ThreadContext context = this.getCurrentContext();
        for (Constant c : ConstantSet.getConstantSet(constantSetName)) {
            if (!c.defined() || !Character.isUpperCase(c.name().charAt(0))) continue;
            module.defineConstant(context, c.name(), this.newFixnum(c.intValue()));
        }
    }

    public long getNextDynamicMethodSerial() {
        return this.dynamicMethodSerial.getAndIncrement();
    }

    public int getNextModuleGeneration() {
        return MODULE_GENERATION.getAndAdd(this, 1);
    }

    public Object getHierarchyLock() {
        return this.hierarchyLock;
    }

    public SelectorPool getSelectorPool() {
        return this.selectorPool;
    }

    public RuntimeCache getRuntimeCache() {
        return this.runtimeCache;
    }

    public List<StrptimeToken> getCachedStrptimePattern(String pattern) {
        List<StrptimeToken> tokens = this.strptimeFormatCache.get(pattern);
        if (tokens == null) {
            tokens = new StrptimeParser().compilePattern(pattern);
            this.strptimeFormatCache.put(pattern, tokens);
        }
        return tokens;
    }

    void addProfiledMethod(String id, DynamicMethod method2) {
        if (!this.config.isProfiling() || method2.isUndefined()) {
            return;
        }
        this.getProfilingService().addProfiledMethod(id, method2);
    }

    public short[] getBuiltinBits() {
        return this.builtinBits;
    }

    void invalidateBuiltin(RubyModule module, String method2) {
        if (!this.isBootingCore()) {
            Builtins.invalidateBuiltin(this.builtinBits, module.getClassIndex(), method2);
        }
    }

    public void incrementExceptionCount() {
        int ignored = EXCEPTION_COUNT.getAndAdd(this, 1);
    }

    public int getExceptionCount() {
        return this.exceptionCount;
    }

    public void incrementBacktraceCount() {
        int ignored = BACKTRACE_COUNT.getAndAdd(this, 1);
    }

    public int getBacktraceCount() {
        return this.backtraceCount;
    }

    public void incrementWarningCount() {
        int ignored = WARNING_COUNT.getAndAdd(this, 1);
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void incrementCallerCount() {
        int ignored = CALLER_COUNT.getAndAdd(this, 1);
    }

    public int getCallerCount() {
        return this.callerCount;
    }

    public boolean isBootingCore() {
        return !this.coreIsBooted;
    }

    public boolean isBooting() {
        return !this.runtimeIsBooted;
    }

    public CoverageData getCoverageData() {
        CoverageData coverageData = this.coverageData;
        if (coverageData != null) {
            return coverageData;
        }
        COVERAGE_DATA.compareAndSet(this, null, new CoverageData());
        return this.coverageData;
    }

    public boolean isCoverageEnabled() {
        CoverageData coverageData = this.coverageData;
        return coverageData != null && coverageData.isCoverageEnabled();
    }

    @Deprecated
    public long getHashSeedK0() {
        return Ruby.getHashSeed0();
    }

    @Deprecated
    public long getHashSeedK1() {
        return Ruby.getHashSeed1();
    }

    public static long getHashSeed0() {
        return hashSeedK0;
    }

    public static long getHashSeed1() {
        return hashSeedK1;
    }

    public StaticScopeFactory getStaticScopeFactory() {
        return this.staticScopeFactory;
    }

    public FFI getFFI() {
        return this.ffi;
    }

    public void setFFI(FFI ffi2) {
        this.ffi = ffi2;
    }

    public RubyString getDefinedMessage(DefinedMessage definedMessage) {
        return this.definedMessages.get((Object)definedMessage);
    }

    public RubyString getThreadStatus(RubyThread.Status status2) {
        return this.threadStatuses.get((Object)status2);
    }

    public RubyString freezeAndDedupString(RubyString string2) {
        ThreadContext context = this.getCurrentContext();
        if (!string2.isBare(context)) {
            string2.setFrozen(true);
            return string2;
        }
        try (FStringEqual wrapper = FStringEqual.cached(this, string2);){
            RubyString.FString deduped;
            WeakReference<RubyString.FString> dedupedRef = this.dedupMap.get(wrapper);
            if (dedupedRef == null || (deduped = (RubyString.FString)dedupedRef.get()) == null) {
                this.DEDUP_WRAPPER_CACHE.remove();
                deduped = string2.dupAsFString(this);
                RubyString.FString fString = this.cacheFString(deduped);
                return fString;
            }
            RubyString.FString fString = deduped;
            return fString;
        }
    }

    public RubyString freezeAndDedupString(ByteList bytes2) {
        return this.freezeAndDedupString(new RubyString.FString(this, bytes2, RubyString.scanForCodeRange(bytes2)));
    }

    private RubyString.FString cacheFString(RubyString.FString candidate) {
        WeakReference dedupedRef;
        RubyString.FString deduped;
        FStringEqual wrapper = new FStringEqual(candidate);
        while ((deduped = (RubyString.FString)(dedupedRef = this.dedupMap.compute(wrapper, (key2, old) -> old != null && old.get() != null ? old : new WeakReference<RubyString.FString>(candidate))).get()) == null) {
        }
        return deduped;
    }

    public ParserManager getParserManager() {
        return this.parserManager;
    }

    public void defineDATA(IRubyObject io2) {
        IRubyObject verbose = this.getVerbose();
        this.setVerbose(this.getNil());
        this.objectClass.defineConstant(this.getCurrentContext(), "DATA", io2);
        this.setVerbose(verbose);
    }

    public void setTopLevelBinding(RubyBinding rubyBinding) {
        this.topLevelBinding = rubyBinding;
    }

    public RubyBinding getTopLevelBinding() {
        return this.topLevelBinding;
    }

    public void setRubyTimeout(IRubyObject timeout2) {
        this.regexpTimeout = timeout2;
    }

    public IRubyObject getRubyTimeout() {
        return this.regexpTimeout;
    }

    public void setRegexpTimeoutError(RubyClass error2) {
        this.regexpTimeoutError = error2;
    }

    public RubyClass getRegexpTimeoutError() {
        return this.regexpTimeoutError;
    }

    public void setChdirThread(RubyThread thread2) {
        this.chdirCurrentThread = thread2;
        this.chdirLocation = thread2 == null ? null : thread2.getContext().getSingleBacktrace();
    }

    public RubyThread getChdirThread() {
        return this.chdirCurrentThread;
    }

    public RubyStackTraceElement getChdirLocation() {
        return this.chdirLocation;
    }

    public int getRuntimeNumber() {
        return this.runtimeNumber;
    }

    @Override
    public Object constant() {
        return this.constant;
    }

    public void setBaseNewMethod(DynamicMethod baseNewMethod) {
        this.baseNewMethod = baseNewMethod;
    }

    public DynamicMethod getBaseNewMethod() {
        return this.baseNewMethod;
    }

    public MethodHandle getNullToNilHandle() {
        MethodHandle nullToNil = this.nullToNil;
        if (nullToNil != null) {
            return nullToNil;
        }
        nullToNil = InvokeDynamicSupport.findStatic(Helpers.class, "nullToNil", MethodType.methodType(IRubyObject.class, IRubyObject.class, IRubyObject.class));
        nullToNil = MethodHandles.insertArguments(nullToNil, 1, this.nilObject);
        this.nullToNil = nullToNil = MethodHandles.explicitCastArguments(nullToNil, MethodType.methodType(IRubyObject.class, Object.class));
        return this.nullToNil;
    }

    public MethodHandle getNullToUndefinedHandle() {
        MethodHandle filter = this.nullToUndefined;
        if (filter != null) {
            return filter;
        }
        filter = InvokeDynamicSupport.findStatic(Helpers.class, "nullToUndefined", MethodType.methodType(IRubyObject.class, IRubyObject.class));
        this.nullToUndefined = filter = MethodHandles.explicitCastArguments(filter, MethodType.methodType(IRubyObject.class, Object.class));
        return this.nullToUndefined;
    }

    public FilenoUtil getFilenoUtil() {
        return this.filenoUtil;
    }

    public Map<Class, Consumer<RubyModule>> getJavaExtensionDefinitions() {
        return this.javaExtensionDefinitions;
    }

    public void addToObjectSpace(boolean useObjectSpace, IRubyObject object) {
        this.objectSpacer.addToObjectSpace(this, useObjectSpace, object);
    }

    @Deprecated(since="9.3.0.0")
    public RaiseException newErrnoEADDRFromBindException(BindException be) {
        return this.newErrnoEADDRFromBindException(be, null);
    }

    @Deprecated(since="9.4.0.0")
    public RaiseException newFrozenError(String objectType) {
        return this.newFrozenError(objectType, null);
    }

    @Deprecated(since="9.4.0.0")
    public RaiseException newFrozenError(RubyModule type2) {
        return this.newRaiseException(this.getFrozenError(), RubyStringBuilder.str(this, "can't modify frozen ", RubyStringBuilder.types(this, type2)));
    }

    @Deprecated(since="9.4.0.0")
    public RaiseException newFrozenError(String objectType, boolean runtimeError) {
        return this.newRaiseException(this.getFrozenError(), RubyStringBuilder.str(this, "can't modify frozen ", RubyStringBuilder.ids(this, objectType)));
    }

    @Deprecated(since="9.4.3.0")
    public synchronized void addEventHook(EventHook hook) {
        this.traceEvents.addEventHook(this.getCurrentContext(), hook);
    }

    @Deprecated(since="9.4.3.0")
    public synchronized void removeEventHook(EventHook hook) {
        this.traceEvents.removeEventHook(hook);
    }

    @Deprecated(since="9.4.3.0")
    public void setTraceFunction(RubyProc traceFunction) {
        this.traceEvents.setTraceFunction(traceFunction);
    }

    @Deprecated(since="9.4.3.0")
    public void setTraceFunction(TraceEventManager.CallTraceFuncHook hook, RubyProc traceFunction) {
        this.traceEvents.setTraceFunction(hook, traceFunction);
    }

    @Deprecated(since="9.4.3.0")
    public void removeAllCallEventHooksFor(ThreadContext context) {
        this.traceEvents.removeAllCallEventHooksFor(context);
    }

    @Deprecated(since="9.4.3.0")
    public void callEventHooks(ThreadContext context, RubyEvent event2, String file2, int line, String name2, IRubyObject type2) {
        this.traceEvents.callEventHooks(context, event2, file2, line, name2, type2);
    }

    @Deprecated(since="9.4.3.0")
    public boolean hasEventHooks() {
        return this.traceEvents.hasEventHooks();
    }

    @Deprecated(since="10.0.0.0")
    public void setENV(RubyHash env) {
    }

    static {
        if (SafePropertyAccessor.isSecurityProtected("jruby.reflected.handles")) {
            securityRestricted = true;
        } else {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkCreateClassLoader();
                }
                catch (SecurityException se) {
                    securityRestricted = true;
                }
            }
        }
        try {
            MODULE_GENERATION = MethodHandles.lookup().findVarHandle(Ruby.class, "moduleGeneration", Integer.TYPE);
            EXCEPTION_COUNT = MethodHandles.lookup().findVarHandle(Ruby.class, "exceptionCount", Integer.TYPE);
            BACKTRACE_COUNT = MethodHandles.lookup().findVarHandle(Ruby.class, "backtraceCount", Integer.TYPE);
            CALLER_COUNT = MethodHandles.lookup().findVarHandle(Ruby.class, "callerCount", Integer.TYPE);
            WARNING_COUNT = MethodHandles.lookup().findVarHandle(Ruby.class, "warningCount", Integer.TYPE);
            COVERAGE_DATA = MethodHandles.lookup().findVarHandle(Ruby.class, "coverageData", CoverageData.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (RubyInstanceConfig.CONSISTENT_HASHING_ENABLED) {
            hashSeedK0 = -561135208506705104L;
            hashSeedK1 = 7114160726623585955L;
        } else {
            SecureRandom random = new SecureRandom();
            hashSeedK0 = random.nextLong();
            hashSeedK1 = random.nextLong();
        }
        threadLocalRuntime = new ThreadLocal();
        DISABLED_OBJECTSPACE = (runtime2, useObjectSpace, object) -> {};
        ENABLED_OBJECTSPACE = (runtime2, useObjectSpace, object) -> {
            if (useObjectSpace) {
                runtime2.objectSpace.add(object);
            }
        };
        RUNTIME_NUMBER = new AtomicInteger(0);
    }

    public static interface ObjectSpacer {
        public void addToObjectSpace(Ruby var1, boolean var2, IRubyObject var3);
    }

    private class ProcExitFunction
    implements ExitFunction {
        private final RubyProc proc;

        public ProcExitFunction(RubyProc proc2) {
            this.proc = proc2;
        }

        @Override
        public boolean matches(Object o) {
            return o instanceof RubyProc && ((RubyProc)o).getBlock().getBody() == this.proc.getBlock().getBody();
        }

        @Override
        public int applyAsInt(ThreadContext context) {
            try {
                this.proc.call(context, IRubyObject.NULL_ARRAY);
            }
            catch (LocalJumpError rj) {
                RubyLocalJumpError rlje = (RubyLocalJumpError)rj.getException();
                String filename2 = this.proc.getBlock().getBinding().filename;
                if (rlje.getReason() == RubyLocalJumpError.Reason.RETURN) {
                    Ruby.this.getWarnings().warn(filename2, "unexpected return");
                } else {
                    Ruby.this.getWarnings().warn(filename2, "break from proc-closure");
                }
            }
            catch (SystemExit exit2) {
                RubyException raisedException = exit2.getException();
                return Convert.toInt(context, raisedException.callMethod(context, "status"));
            }
            catch (RaiseException re) {
                Ruby.this.printError(re.getException());
                return 1;
            }
            catch (IRReturnJump e) {
                Ruby.this.getWarnings().warn(this.proc.getBlock().getBinding().filename, "unexpected return");
            }
            return 0;
        }
    }

    public static interface ExitFunction
    extends ToIntFunction<ThreadContext> {
        default public boolean matches(Object o) {
            return o == this;
        }
    }

    static class FStringEqual
    implements Closeable {
        RubyString string;

        static FStringEqual cached(Ruby runtime2, RubyString string2) {
            FStringEqual wrapper = runtime2.DEDUP_WRAPPER_CACHE.get();
            wrapper.string = string2;
            return wrapper;
        }

        FStringEqual() {
        }

        FStringEqual(RubyString string2) {
            this.string = string2;
        }

        @Override
        public void close() {
            this.string = null;
        }

        public boolean equals(Object other) {
            if (other instanceof FStringEqual) {
                RubyString otherString = ((FStringEqual)other).string;
                RubyString string2 = this.string;
                if (string2 == null || otherString == null) {
                    return false;
                }
                return string2.equals(otherString) && string2.getEncoding() == otherString.getEncoding();
            }
            return false;
        }

        public int hashCode() {
            RubyString string2 = this.string;
            if (string2 == null) {
                return 0;
            }
            return string2.hashCode();
        }
    }

    public static interface RecursiveFunctionEx<T>
    extends ThreadContext.RecursiveFunctionEx<T> {
        @Override
        public IRubyObject call(ThreadContext var1, T var2, IRubyObject var3, boolean var4);
    }
}

