/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jruby.RubySymbol;
import org.jruby.anno.FrameField;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.NOperandInstr;
import org.jruby.ir.instructions.Site;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.MutableString;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.Stringable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.RefinedCachingCallSite;
import org.jruby.util.ArraySupport;

public abstract class CallBase
extends NOperandInstr
implements ClosureAcceptingInstr,
Site {
    private static final EnumSet<FrameField> ALL = EnumSet.allOf(FrameField.class);
    public transient long callSiteId;
    private final CallType callType;
    protected final RubySymbol name;
    protected final transient CallSite callSite;
    protected final transient int argsCount;
    protected final transient boolean hasClosure;
    private transient boolean flagsComputed;
    private transient boolean canBeEval;
    private transient boolean targetRequiresCallersBinding;
    private transient boolean targetRequiresCallersFrame;
    private transient boolean dontInline;
    private transient boolean[] splatMap;
    private final boolean potentiallyRefined;
    private final int flags;
    private transient Set<FrameField> frameReads;
    private transient Set<FrameField> frameWrites;
    private static final int REQUIRED_OPERANDS = 1;

    protected CallBase(IRScope scope, Operation op, CallType callType, RubySymbol name2, Operand receiver2, Operand[] args2, Operand closure, int flags2, boolean potentiallyRefined) {
        super(op, CallBase.arrayifyOperands(receiver2, args2, closure));
        this.flags = flags2;
        this.callSiteId = scope.getManager().nextCallSiteID();
        this.argsCount = args2.length;
        this.hasClosure = closure != NullBlock.INSTANCE;
        this.name = name2;
        this.callType = callType;
        boolean effectivelyRefined = potentiallyRefined || scope != null && scope.maybeUsingRefinements();
        this.callSite = CallBase.getCallSiteFor(scope, callType, name2.idString(), this.callSiteId, this.hasLiteralClosure(), effectivelyRefined);
        this.splatMap = IRRuntimeHelpers.buildSplatMap(args2);
        this.flagsComputed = false;
        this.canBeEval = true;
        this.targetRequiresCallersBinding = true;
        this.targetRequiresCallersFrame = true;
        this.dontInline = false;
        this.potentiallyRefined = effectivelyRefined;
        this.captureFrameReadsAndWrites();
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getCallType().ordinal());
        e.encode(this.getName());
        e.encode(this.getReceiver());
        e.encode(this.calculateArity());
        for (Operand arg2 : this.getCallArgs()) {
            e.encode(arg2);
        }
        if (this.hasClosure) {
            e.encode(this.getClosureArg(NullBlock.INSTANCE));
        }
        e.encode(this.flags);
    }

    private int calculateArity() {
        return this.hasClosure ? -1 * (this.argsCount + 1) : this.argsCount;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getId() {
        return this.name.idString();
    }

    @Override
    public long getCallSiteId() {
        return this.callSiteId;
    }

    @Override
    public void setCallSiteId(long callSiteId) {
        this.callSiteId = callSiteId;
    }

    public RubySymbol getName() {
        return this.name;
    }

    @Override
    public Operand getClosureArg() {
        return this.hasClosure ? this.operands[this.argsCount + 1] : NullBlock.INSTANCE;
    }

    public Operand getClosureArg(Operand ifUnspecified) {
        return this.hasClosure ? this.getClosureArg() : ifUnspecified;
    }

    public Operand getReceiver() {
        return this.operands[0];
    }

    public abstract Variable getResult();

    public Operand getArg1() {
        return this.operands[1];
    }

    public int getArgsCount() {
        return this.argsCount;
    }

    public Operand[] getCallArgs() {
        Object[] callArgs = new Operand[this.argsCount];
        ArraySupport.copy(this.operands, 1, callArgs, 0, this.argsCount);
        return callArgs;
    }

    public CallSite getCallSite() {
        return this.callSite;
    }

    public CallType getCallType() {
        return this.callType;
    }

    public boolean[] splatMap() {
        return this.splatMap;
    }

    public void blockInlining() {
        this.dontInline = true;
    }

    public boolean inliningBlocked() {
        return this.dontInline;
    }

    protected static CallSite getCallSiteFor(IRScope scope, CallType callType, String name2, long callsiteId, boolean hasLiteralClosure, boolean potentiallyRefined) {
        assert (callType != null) : "Calltype should never be null";
        if (potentiallyRefined) {
            return new RefinedCachingCallSite(name2, scope.getStaticScope(), callType);
        }
        switch (callType) {
            case NORMAL: {
                if (IRManager.IR_INLINER && hasLiteralClosure) {
                    return MethodIndex.getProfilingCallSite(callType, name2, scope, callsiteId);
                }
                return MethodIndex.getCallSite(name2);
            }
            case FUNCTIONAL: {
                if (IRManager.IR_INLINER && hasLiteralClosure) {
                    return MethodIndex.getProfilingCallSite(callType, name2, scope, callsiteId);
                }
                return MethodIndex.getFunctionalCallSite(name2);
            }
            case VARIABLE: {
                return MethodIndex.getVariableCallSite(name2);
            }
            case SUPER: {
                return MethodIndex.getSuperCallSite();
            }
        }
        return null;
    }

    @Override
    public boolean hasLiteralClosure() {
        return this.getClosureArg() instanceof WrappedIRClosure;
    }

    public static boolean isAllFixnums(Operand[] args2) {
        for (Operand argument : args2) {
            if (argument instanceof Fixnum) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllFloats(Operand[] args2) {
        for (Operand argument : args2) {
            if (argument instanceof Float) continue;
            return false;
        }
        return true;
    }

    public boolean isPotentiallyRefined() {
        return this.potentiallyRefined;
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        boolean modifiedScope = super.computeScopeFlags(scope, flags2);
        if (this.targetRequiresCallersBinding()) {
            modifiedScope = true;
            flags2.add(IRFlags.BINDING_HAS_ESCAPED);
        }
        modifiedScope |= this.setIRFlagsFromFrameFields(flags2, this.frameReads);
        modifiedScope |= this.setIRFlagsFromFrameFields(flags2, this.frameWrites);
        if (this.hasLiteralClosure()) {
            modifiedScope = true;
            flags2.addAll(IRFlags.REQUIRE_ALL_FRAME_FIELDS);
        }
        if (this.canBeEval()) {
            modifiedScope = true;
            scope.setUsesEval();
            scope.setCanReceiveNonlocalReturns();
            if (scope.receivesClosureArg() && this.argsCount > 1) {
                scope.setCanCaptureCallersBinding();
            }
        }
        if (CallBase.potentiallySend(this.getId(), this.argsCount)) {
            Operand meth = this.getArg1();
            if (this.isPotentiallyRefined()) {
                modifiedScope = true;
                flags2.add(IRFlags.REQUIRES_DYNSCOPE);
            }
            if (meth instanceof MutableString) {
                String sendName = ((MutableString)meth).getString();
                if (MethodIndex.SCOPE_AWARE_METHODS.contains(sendName)) {
                    modifiedScope = true;
                    flags2.add(IRFlags.REQUIRES_DYNSCOPE);
                }
                if (MethodIndex.FRAME_AWARE_METHODS.contains(sendName)) {
                    modifiedScope = true;
                    flags2.addAll(IRFlags.REQUIRE_ALL_FRAME_EXCEPT_SCOPE);
                }
            } else {
                modifiedScope = true;
                flags2.addAll(IRFlags.REQUIRE_ALL_FRAME_FIELDS);
            }
        }
        return modifiedScope;
    }

    private boolean setIRFlagsFromFrameFields(EnumSet<IRFlags> flags2, Set<FrameField> frameFields) {
        boolean modifiedScope = false;
        for (FrameField field : frameFields) {
            modifiedScope = true;
            switch (field) {
                case LASTLINE: {
                    flags2.add(IRFlags.REQUIRES_LASTLINE);
                    break;
                }
                case BACKREF: {
                    flags2.add(IRFlags.REQUIRES_BACKREF);
                    break;
                }
                case VISIBILITY: {
                    flags2.add(IRFlags.REQUIRES_VISIBILITY);
                    break;
                }
                case BLOCK: {
                    flags2.add(IRFlags.REQUIRES_BLOCK);
                    break;
                }
                case SELF: {
                    flags2.add(IRFlags.REQUIRES_SELF);
                    break;
                }
                case METHODNAME: {
                    flags2.add(IRFlags.REQUIRES_METHODNAME);
                    break;
                }
                case LINE: {
                    flags2.add(IRFlags.REQUIRES_LINE);
                    break;
                }
                case CLASS: {
                    flags2.add(IRFlags.REQUIRES_CLASS);
                    break;
                }
                case FILENAME: {
                    flags2.add(IRFlags.REQUIRES_FILENAME);
                    break;
                }
                case SCOPE: {
                    flags2.add(IRFlags.REQUIRES_SCOPE);
                }
            }
        }
        return modifiedScope;
    }

    @Override
    protected void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        super.simplifyOperands(valueMap, force);
        this.splatMap = IRRuntimeHelpers.buildSplatMap(this.getCallArgs());
        this.flagsComputed = false;
    }

    public Operand[] cloneCallArgs(CloneInfo ii) {
        Operand[] clonedArgs = new Operand[this.argsCount];
        for (int i2 = 0; i2 < this.argsCount; ++i2) {
            clonedArgs[i2] = this.operands[i2 + 1].cloneForInlining(ii);
        }
        return clonedArgs;
    }

    private boolean computeEvalFlag() {
        String mname = this.getId();
        if (this.getArgsCount() != 0 && (mname.equals("eval") || mname.equals("module_eval") || mname.equals("class_eval") || mname.equals("instance_eval"))) {
            return true;
        }
        if (CallBase.potentiallySend(mname, this.argsCount)) {
            Operand meth = this.getArg1();
            if (!(meth instanceof MutableString)) {
                return true;
            }
            String name2 = ((MutableString)meth).getString();
            return name2.equals("call") || name2.equals("eval") || mname.equals("module_eval") || mname.equals("class_eval") || mname.equals("instance_eval") || name2.equals("send") || name2.equals("__send__");
        }
        return false;
    }

    private boolean computeRequiresCallersBindingFlag() {
        if (this.canBeEval()) {
            return true;
        }
        if (this.hasLiteralClosure()) {
            return true;
        }
        String mname = this.getId();
        if (MethodIndex.SCOPE_AWARE_METHODS.contains(mname)) {
            return true;
        }
        if (CallBase.potentiallySend(mname, this.argsCount)) {
            Operand meth = this.getArg1();
            if (!(meth instanceof MutableString)) {
                return true;
            }
            return MethodIndex.SCOPE_AWARE_METHODS.contains(((MutableString)meth).getString());
        }
        return false;
    }

    private boolean computeRequiresCallersFrameFlag() {
        if (this.canBeEval()) {
            return true;
        }
        if (this.hasLiteralClosure()) {
            return true;
        }
        String mname = this.getId();
        if (this.frameReads.size() > 0 || this.frameWrites.size() > 0) {
            return true;
        }
        if (CallBase.potentiallySend(mname, this.argsCount)) {
            Operand meth = this.getArg1();
            if (!(meth instanceof Stringable)) {
                return true;
            }
            String name2 = ((Stringable)((Object)meth)).getString();
            this.frameReads = MethodIndex.METHOD_FRAME_READS.getOrDefault(name2, Collections.EMPTY_SET);
            this.frameWrites = MethodIndex.METHOD_FRAME_WRITES.getOrDefault(name2, Collections.EMPTY_SET);
            if (this.frameReads.size() > 0 || this.frameWrites.size() > 0) {
                return true;
            }
        }
        return false;
    }

    private static boolean potentiallySend(String name2, int argsCount) {
        return (name2.equals("send") || name2.equals("__send__") || name2.equals("public_send")) && argsCount >= 1;
    }

    private void captureFrameReadsAndWrites() {
        if (CallBase.potentiallySend(this.getId(), this.argsCount)) {
            Operand meth = this.getArg1();
            if (meth instanceof Stringable) {
                String aliasName = ((Stringable)((Object)meth)).getString();
                this.frameReads = MethodIndex.METHOD_FRAME_READS.getOrDefault(aliasName, Collections.EMPTY_SET);
                this.frameWrites = MethodIndex.METHOD_FRAME_WRITES.getOrDefault(aliasName, Collections.EMPTY_SET);
            } else {
                this.frameReads = ALL;
                this.frameWrites = ALL;
            }
        } else {
            if (this.getId().equals("print") && this.argsCount != 0) {
                this.frameReads = Collections.EMPTY_SET;
                this.frameWrites = Collections.EMPTY_SET;
                return;
            }
            this.frameReads = MethodIndex.METHOD_FRAME_READS.getOrDefault(this.getId(), Collections.EMPTY_SET);
            this.frameWrites = MethodIndex.METHOD_FRAME_WRITES.getOrDefault(this.getId(), Collections.EMPTY_SET);
        }
    }

    private void computeFlags() {
        this.flagsComputed = true;
        this.canBeEval = this.computeEvalFlag();
        this.targetRequiresCallersBinding = this.canBeEval || this.computeRequiresCallersBindingFlag();
        this.targetRequiresCallersFrame = this.canBeEval || this.computeRequiresCallersFrameFlag();
    }

    public boolean canBeEval() {
        if (!this.flagsComputed) {
            this.computeFlags();
        }
        return this.canBeEval;
    }

    public boolean targetRequiresCallersBinding() {
        if (!this.flagsComputed) {
            this.computeFlags();
        }
        return this.targetRequiresCallersBinding;
    }

    public boolean targetRequiresCallersFrame() {
        if (!this.flagsComputed) {
            this.computeFlags();
        }
        return this.targetRequiresCallersFrame;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"n:" + String.valueOf(this.getName()), "t:" + this.callType.toString().substring(0, 2), "cl:" + this.hasClosure};
    }

    public static boolean containsArgSplat(Operand[] arguments) {
        for (Operand argument : arguments) {
            if (!(argument instanceof Splat)) continue;
            return true;
        }
        return false;
    }

    private static Operand[] arrayifyOperands(Operand receiver2, Operand[] callArgs, Operand closure) {
        assert (receiver2 != null) : "RECEIVER is null";
        assert (closure != null) : "CLOSURE is null";
        Operand[] allArgs = new Operand[callArgs.length + 1 + (closure != NullBlock.INSTANCE ? 1 : 0)];
        allArgs[0] = receiver2;
        for (int i2 = 0; i2 < callArgs.length; ++i2) {
            assert (callArgs[i2] != null) : "ARG " + i2 + " is null";
            allArgs[i2 + 1] = callArgs[i2];
        }
        if (closure != NullBlock.INSTANCE) {
            allArgs[callArgs.length + 1] = closure;
        }
        return allArgs;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope dynamicScope, IRubyObject self2, Object[] temp) {
        IRubyObject object = (IRubyObject)this.getReceiver().retrieve(context, self2, currScope, dynamicScope, temp);
        IRubyObject[] values2 = this.prepareArguments(context, self2, currScope, dynamicScope, temp);
        Block preparedBlock = this.prepareBlock(context, self2, currScope, dynamicScope, temp);
        IRRuntimeHelpers.setCallInfo(context, this.getFlags());
        if (this.hasLiteralClosure()) {
            return this.callSite.callIter(context, self2, object, values2, preparedBlock);
        }
        return this.callSite.call(context, self2, object, values2, preparedBlock);
    }

    public IRubyObject[] prepareArguments(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope dynamicScope, Object[] temp) {
        return this.splatMap != null ? this.prepareArgumentsComplex(context, self2, currScope, dynamicScope, temp) : this.prepareArgumentsSimple(context, self2, currScope, dynamicScope, temp);
    }

    protected IRubyObject[] prepareArgumentsSimple(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        IRubyObject[] newArgs = new IRubyObject[this.argsCount];
        for (int i2 = 0; i2 < this.argsCount; ++i2) {
            newArgs[i2] = (IRubyObject)this.operands[i2 + 1].retrieve(context, self2, currScope, currDynScope, temp);
        }
        return newArgs;
    }

    protected IRubyObject[] prepareArgumentsComplex(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        return IRRuntimeHelpers.splatArguments(this.prepareArgumentsSimple(context, self2, currScope, currDynScope, temp), this.splatMap);
    }

    public Block prepareBlock(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        if (this.getClosureArg() == null) {
            return Block.NULL_BLOCK;
        }
        if (this.potentiallyRefined) {
            return IRRuntimeHelpers.getRefinedBlockFromObject(context, currScope, this.getClosureArg().retrieve(context, self2, currScope, currDynScope, temp));
        }
        return IRRuntimeHelpers.getBlockFromObject(context, this.getClosureArg().retrieve(context, self2, currScope, currDynScope, temp));
    }
}

