/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.EnumSet;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySymbol;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class UnresolvedSuperInstr
extends CallInstr {
    private final boolean isLiteralBlock;
    private static final ByteList DYNAMIC_SUPER_TARGET = new ByteList("-dynamic-super_target-".getBytes(), USASCIIEncoding.INSTANCE, false);

    public UnresolvedSuperInstr(IRScope scope, Operation op, Variable result2, Operand receiver2, Operand[] args2, Operand closure, int flags2, boolean isPotentiallyRefined) {
        super(scope, op, CallType.SUPER, result2, scope.getManager().getRuntime().newSymbol(DYNAMIC_SUPER_TARGET), receiver2, args2, closure, flags2, isPotentiallyRefined);
        this.isLiteralBlock = closure instanceof WrappedIRClosure;
    }

    public UnresolvedSuperInstr(IRScope scope, Variable result2, Operand receiver2, Operand[] args2, Operand closure, int flags2, boolean isPotentiallyRefined) {
        this(scope, Operation.UNRESOLVED_SUPER, result2, receiver2, args2, closure, flags2, isPotentiallyRefined);
    }

    @Override
    public boolean computeScopeFlags(IRScope scope, EnumSet<IRFlags> flags2) {
        super.computeScopeFlags(scope, flags2);
        scope.setUsesSuper();
        flags2.add(IRFlags.REQUIRES_CLASS);
        flags2.add(IRFlags.REQUIRES_METHODNAME);
        return true;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new UnresolvedSuperInstr(ii.getScope(), Operation.UNRESOLVED_SUPER, ii.getRenamedVariable(this.getResult()), this.getReceiver().cloneForInlining(ii), this.cloneCallArgs(ii), this.getClosureArg().cloneForInlining(ii), this.getFlags(), this.isPotentiallyRefined());
    }

    public static UnresolvedSuperInstr decode(IRReaderDecoder d) {
        int argsLength;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call");
        }
        int callTypeOrdinal = d.decodeInt();
        CallType callType = CallType.fromOrdinal(callTypeOrdinal);
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, calltype(ord):  " + String.valueOf((Object)callType));
        }
        RubySymbol methAddr = d.decodeSymbol();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("decoding call, methaddr:  " + String.valueOf(methAddr));
        }
        Operand receiver2 = d.decodeOperand();
        int argsCount = d.decodeInt();
        boolean hasClosureArg = argsCount < 0;
        int n = argsLength = hasClosureArg ? -1 * (argsCount + 1) : argsCount;
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("ARGS: " + argsLength + ", CLOSURE: " + hasClosureArg);
        }
        Operand[] args2 = new Operand[argsLength];
        for (int i2 = 0; i2 < argsLength; ++i2) {
            args2[i2] = d.decodeOperand();
        }
        Operand closure = hasClosureArg ? d.decodeOperand() : NullBlock.INSTANCE;
        int flags2 = d.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("before result");
        }
        return new UnresolvedSuperInstr(d.getCurrentScope(), d.decodeVariable(), receiver2, args2, closure, flags2, d.getCurrentScope().maybeUsingRefinements());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject[] args2 = this.prepareArguments(context, self2, currScope, currDynScope, temp);
        Block block = this.prepareBlock(context, self2, currScope, currDynScope, temp);
        IRRuntimeHelpers.setCallInfo(context, this.getFlags());
        if (this.isLiteralBlock) {
            return IRRuntimeHelpers.unresolvedSuperIter(context, self2, args2, block);
        }
        return IRRuntimeHelpers.unresolvedSuper(context, self2, args2, block);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.UnresolvedSuperInstr(this);
    }
}

