/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.util;

import java.util.HashSet;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;

public final class ArgsUtil {
    private static final IRubyObject[] NULL_1 = new IRubyObject[]{null};
    private static final IRubyObject[] NULL_2 = new IRubyObject[]{null, null};
    private static final IRubyObject[] NULL_3 = new IRubyObject[]{null, null, null};
    public static final RubyHash.VisitorWithState<RubySymbol> SINGLE_KEY_CHECK_VISITOR = new RubyHash.VisitorWithState<RubySymbol>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, RubySymbol testKey) {
            if (!key2.equals(testKey)) {
                throw Error.argumentError(context, "unknown keyword: " + String.valueOf(key2.inspect(context)));
            }
        }
    };
    public static final RubyHash.VisitorWithState<Set<RubySymbol>> MULTI_KEY_CHECK_VISITOR = new RubyHash.VisitorWithState<Set<RubySymbol>>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Set<RubySymbol> validKeySet) {
            if (!validKeySet.contains(key2)) {
                throw Error.argumentError(context, "unknown keyword: " + String.valueOf(key2.inspect(context)));
            }
        }
    };

    public static RubyArray convertToRubyArray(Ruby runtime2, IRubyObject value2, boolean coerce2) {
        if (value2 == null) {
            return RubyArray.newEmptyArray(runtime2);
        }
        if (coerce2) {
            return ArgsUtil.convertToRubyArrayWithCoerce(runtime2, value2);
        }
        return RubyArray.newArrayLight(runtime2, value2);
    }

    public static RubyArray convertToRubyArrayWithCoerce(Ruby runtime2, IRubyObject value2) {
        if (value2 instanceof RubyArray) {
            RubyArray ary = (RubyArray)value2;
            return ary;
        }
        IRubyObject newValue = TypeConverter.convertToType(value2, runtime2.getArray(), "to_ary", false);
        return newValue.isNil() ? RubyArray.newArrayLight(runtime2, value2) : Convert.castAsArray(runtime2.getCurrentContext(), newValue);
    }

    public static int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }

    public static boolean hasExceptionOption(ThreadContext context, IRubyObject options2, boolean defaultValue) {
        IRubyObject value2;
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, options2, false);
        if (!opts.isNil() && (value2 = ArgsUtil.extractKeywordArg(context, "exception", (RubyHash)opts)) != null) {
            return TypeConverter.booleanExpected(context, value2, "exception");
        }
        return defaultValue;
    }

    public static IRubyObject getOptionsArg(Ruby runtime2, IRubyObject ... args2) {
        if (args2.length >= 1) {
            return TypeConverter.checkHashType(runtime2, args2[args2.length - 1]);
        }
        return runtime2.getNil();
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject getOptionsArg(Ruby runtime2, IRubyObject arg2) {
        return ArgsUtil.getOptionsArg(runtime2, arg2, true);
    }

    public static IRubyObject getOptionsArg(ThreadContext context, IRubyObject arg2) {
        return ArgsUtil.getOptionsArg(context.runtime, arg2, true);
    }

    public static IRubyObject getOptionsArg(Ruby runtime2, IRubyObject arg2, boolean raise2) {
        if (arg2 == null) {
            return runtime2.getNil();
        }
        return TypeConverter.checkHashType(runtime2, arg2, raise2);
    }

    public static IRubyObject[] extractKeywordArgs(ThreadContext context, RubyHash options2, String ... validKeys) {
        if (options2.isEmpty()) {
            return switch (validKeys.length) {
                case 1 -> NULL_1;
                case 2 -> NULL_2;
                case 3 -> NULL_3;
                default -> new IRubyObject[validKeys.length];
            };
        }
        IRubyObject[] ret = new IRubyObject[validKeys.length];
        HashSet<RubySymbol> validKeySet = new HashSet<RubySymbol>(ret.length);
        for (int i2 = 0; i2 < validKeys.length; ++i2) {
            IRubyObject val;
            String key2 = validKeys[i2];
            RubySymbol keySym = Convert.asSymbol(context, key2);
            ret[i2] = val = options2.fastARef(keySym);
            validKeySet.add(keySym);
        }
        options2.visitAll(context, MULTI_KEY_CHECK_VISITOR, validKeySet);
        return ret;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject[] extractKeywordArgs(ThreadContext context, IRubyObject[] args2, String ... validKeys) {
        return ArgsUtil.extractKeywordArgs(context, ArgsUtil.getOptionsArg(context.runtime, args2), validKeys);
    }

    public static IRubyObject[] extractKeywordArgs(ThreadContext context, IRubyObject maybeKwargs, String ... validKeys) {
        IRubyObject[] iRubyObjectArray;
        IRubyObject options2 = ArgsUtil.getOptionsArg(context, maybeKwargs);
        if (options2 instanceof RubyHash) {
            RubyHash hash2 = (RubyHash)options2;
            iRubyObjectArray = ArgsUtil.extractKeywordArgs(context, hash2, validKeys);
        } else {
            iRubyObjectArray = null;
        }
        return iRubyObjectArray;
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, IRubyObject maybeKwargs, String validKey) {
        IRubyObject iRubyObject;
        IRubyObject options2 = ArgsUtil.getOptionsArg(context, maybeKwargs);
        if (options2 instanceof RubyHash) {
            RubyHash hash2 = (RubyHash)options2;
            iRubyObject = ArgsUtil.extractKeywordArg(context, hash2, validKey);
        } else {
            iRubyObject = null;
        }
        return iRubyObject;
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, RubyHash options2, String validKey) {
        if (options2.isEmpty()) {
            return null;
        }
        RubySymbol testKey = Convert.asSymbol(context, validKey);
        IRubyObject ret = options2.fastARef(testKey);
        if (ret == null || options2.size() > 1) {
            options2.visitAll(context, SINGLE_KEY_CHECK_VISITOR, testKey);
        }
        return ret;
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, RubyHash opts) {
        return opts.op_aref(context, Convert.asSymbol(context, keyword));
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, IRubyObject arg2) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context, arg2);
        return opts == context.nil ? context.nil : ArgsUtil.extractKeywordArg(context, keyword, (RubyHash)opts);
    }

    public static IRubyObject extractKeywordArg(ThreadContext context, String keyword, IRubyObject ... args2) {
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, args2);
        return opts == context.nil ? context.nil : ArgsUtil.extractKeywordArg(context, keyword, (RubyHash)opts);
    }

    public static RubyHash extractKeywords(IRubyObject possiblyKeywordArg) {
        RubyHash hash2;
        return possiblyKeywordArg instanceof RubyHash ? (hash2 = (RubyHash)possiblyKeywordArg) : null;
    }

    public static IRubyObject getFreezeOpt(ThreadContext context, IRubyObject maybeOpts) {
        IRubyObject freeze2;
        IRubyObject kwfreeze = null;
        IRubyObject opts = ArgsUtil.getOptionsArg(context, maybeOpts);
        if (!opts.isNil() && (freeze2 = ArgsUtil.extractKeywordArg(context, (RubyHash)opts, "freeze")) != null) {
            if (!freeze2.isNil() && freeze2 != context.tru && freeze2 != context.fals) {
                throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "unexpected value for freeze: ", RubyStringBuilder.types(context.runtime, (RubyModule)freeze2.getType())));
            }
            kwfreeze = freeze2;
        }
        return kwfreeze;
    }
}

