/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Numeric;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

public class Sprintf {
    private static final int FLAG_NONE = 0;
    private static final int FLAG_SPACE = 1;
    private static final int FLAG_ZERO = 2;
    private static final int FLAG_PLUS = 4;
    private static final int FLAG_MINUS = 8;
    private static final int FLAG_SHARP = 16;
    private static final int FLAG_WIDTH = 32;
    private static final int FLAG_PRECISION = 64;
    private static final byte[] PREFIX_OCTAL = new byte[]{48};
    private static final byte[] PREFIX_HEX_LC = new byte[]{48, 120};
    private static final byte[] PREFIX_HEX_UC = new byte[]{48, 88};
    private static final byte[] PREFIX_BINARY_LC = new byte[]{48, 98};
    private static final byte[] PREFIX_BINARY_UC = new byte[]{48, 66};
    private static final byte[] PREFIX_NEGATIVE = new byte[]{46, 46};
    private static final byte[] NAN_VALUE = new byte[]{78, 97, 78};
    private static final byte[] INFINITY_VALUE = new byte[]{73, 110, 102};
    private static final BigInteger BIG_32 = BigInteger.valueOf(0x100000000L);
    private static final BigInteger BIG_64 = BIG_32.shiftLeft(32);
    private static final BigInteger BIG_MINUS_32 = BigInteger.valueOf(-4294967296L);
    private static final BigInteger BIG_MINUS_64 = BIG_MINUS_32.shiftLeft(32);
    private static final String ERR_MALFORMED_FORMAT = "malformed format string";
    private static final String ERR_MALFORMED_NUM = "malformed format string - %[0-9]";
    private static final String ERR_MALFORMED_DOT_NUM = "malformed format string - %.[0-9]";
    private static final String ERR_MALFORMED_STAR_NUM = "malformed format string - %*[0-9]";
    private static final String ERR_ILLEGAL_FORMAT_CHAR = "illegal format character - %";
    private static final String ERR_INCOMPLETE_FORMAT_SPEC = "incomplete format specifier; use %% (double %) instead";
    private static final String ERR_MALFORMED_NAME = "malformed name - unmatched parenthesis";
    private static final ThreadLocal<Map<Locale, NumberFormat>> LOCALE_NUMBER_FORMATS = new ThreadLocal();
    private static final ThreadLocal<Map<Locale, DecimalFormatSymbols>> LOCALE_DECIMAL_FORMATS = new ThreadLocal();
    private static final long SIGN_MASK = Long.MIN_VALUE;
    private static final long BIASED_EXP_MASK = 0x7FF0000000000000L;
    private static final long MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final byte[] HEX_DIGITS_UPPER_CASE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    private Sprintf() {
    }

    public static boolean sprintf(ByteList to, Locale locale, CharSequence format, IRubyObject args2) {
        Sprintf.rubySprintfToBuffer(to, format, new Args(locale, args2));
        return false;
    }

    public static boolean sprintf1_9(ByteList to, Locale locale, CharSequence format, IRubyObject args2) {
        Sprintf.rubySprintfToBuffer(to, format, new Args(locale, args2), false);
        return false;
    }

    public static boolean sprintf(ByteList to, CharSequence format, IRubyObject args2) {
        Sprintf.rubySprintf(to, format, new Args(args2));
        return false;
    }

    public static ByteList sprintf(Encoding encoding2, CharSequence format, IRubyObject args2) {
        ByteList to = new ByteList(16, encoding2);
        Sprintf.rubySprintfToBuffer(to, format, new Args(args2), false);
        return to;
    }

    public static boolean sprintf(Ruby runtime2, ByteList to, CharSequence format, int arg2) {
        Sprintf.rubySprintf(to, format, new Args(runtime2, arg2));
        return false;
    }

    public static boolean sprintf(Ruby runtime2, ByteList to, CharSequence format, long arg2) {
        Sprintf.rubySprintf(to, format, new Args(runtime2, arg2));
        return false;
    }

    public static boolean sprintf(ByteList to, RubyString format, IRubyObject args2) {
        Sprintf.rubySprintf(to, format.getByteList(), new Args(args2));
        return false;
    }

    private static void rubySprintf(ByteList to, CharSequence charFormat, Args args2) {
        Sprintf.rubySprintfToBuffer(to, charFormat, args2);
    }

    private static void rubySprintfToBuffer(ByteList buf, CharSequence charFormat, Args args2) {
        Sprintf.rubySprintfToBuffer(buf, charFormat, args2, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void rubySprintfToBuffer(ByteList buf, CharSequence charFormat, Args args, boolean usePrefixForZero) {
        context = args.runtime.getCurrentContext();
        if (charFormat instanceof ByteList) {
            list = (ByteList)charFormat;
            format = list.getUnsafeBytes();
            offset = begin = list.begin();
            length = begin + list.length();
            encoding /* !! */  = list.getEncoding();
        } else {
            format = Sprintf.stringToBytes(charFormat);
            offset = 0;
            length = charFormat.length();
            encoding /* !! */  = UTF8Encoding.INSTANCE;
        }
        while (offset < length) {
            name = null;
            start = offset;
            while (offset < length && format[offset] != 37) {
                ++offset;
            }
            if (offset > start) {
                buf.append(format, start, offset - start);
            }
            if (offset++ >= length) break;
            flags = 0;
            width = 0;
            precision = 0;
            incomplete = true;
            block73: while (incomplete && offset < length) {
                fchar = format[offset];
                switch (fchar) {
                    default: {
                        if (Sprintf.isPrintable(fchar)) {
                            Sprintf.raiseArgumentError(args, "malformed format string - %" + (char)fchar);
                            continue block73;
                        }
                        Sprintf.raiseArgumentError(args, "malformed format string");
                        continue block73;
                    }
                    case 32: {
                        flags |= 1;
                        ++offset;
                        continue block73;
                    }
                    case 43: {
                        flags |= 4;
                        ++offset;
                        continue block73;
                    }
                    case 45: {
                        flags |= 8;
                        ++offset;
                        continue block73;
                    }
                    case 35: {
                        flags |= 16;
                        ++offset;
                        continue block73;
                    }
                    case 48: {
                        flags |= 2;
                        ++offset;
                        continue block73;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        number = 0;
                        while (offset < length && Sprintf.isDigit(fchar = format[offset])) {
                            number = Sprintf.extendWidth(args, number, fchar, "width too big");
                            ++offset;
                        }
                        Sprintf.checkOffset(args, offset, length, "malformed format string - %[0-9]");
                        if (fchar == 36) {
                            if (args.nextObject != null) {
                                Sprintf.raiseArgumentError(args, "value given twice - " + number + "$");
                            }
                            args.nextObject = args.getPositionArg(number);
                            ++offset;
                            continue block73;
                        }
                        if ((flags & 32) != 0) {
                            Sprintf.raiseArgumentError(args, "width given twice");
                        }
                        width = number;
                        flags |= 32;
                        continue block73;
                    }
                    case 60: {
                        nameEnd = nameStart = ++offset;
                        while (offset < length) {
                            if (format[offset] == 62) {
                                nameEnd = offset++;
                                break;
                            }
                            ++offset;
                        }
                        if (nameEnd == nameStart) {
                            Sprintf.raiseArgumentError(args, "malformed name - unmatched parenthesis");
                        }
                        newName = new ByteList(format, nameStart, nameEnd - nameStart, encoding /* !! */ , false);
                        if (name != null) {
                            Sprintf.raiseArgumentError(args, "named<" + String.valueOf(Create.newString(context, newName)) + "> after <" + String.valueOf(Create.newString(context, name)) + ">");
                        }
                        name = newName;
                        args.nextObject = args.getHashValue(name, '<', '>');
                        continue block73;
                    }
                    case 123: {
                        nameEnd = nameStart = ++offset;
                        while (offset < length) {
                            if (format[offset] == 125) {
                                nameEnd = offset++;
                                break;
                            }
                            ++offset;
                        }
                        if (nameEnd == nameStart) {
                            Sprintf.raiseArgumentError(args, "malformed name - unmatched parenthesis");
                        }
                        localName = new ByteList(format, nameStart, nameEnd - nameStart, encoding /* !! */ , false);
                        value = args.getHashValue(localName, '{', '}');
                        str = (RubyString)TypeConverter.convertToType(value, Access.stringClass(context), "to_s");
                        bytes = str.getByteList();
                        if (offset < length && !Sprintf.isFormatSpecifier(format[offset]) || offset == length) {
                            len = bytes.length();
                            enc = RubyString.checkEncoding(context.runtime, buf, bytes);
                            if ((flags & 96) != 0) {
                                strLen = str.strLength();
                                if ((flags & 64) != 0 && precision < strLen) {
                                    strLen = precision;
                                    len = StringSupport.nth(enc, bytes.getUnsafeBytes(), bytes.begin(), bytes.begin() + bytes.getRealSize(), precision);
                                    if (len == -1) {
                                        len = 0;
                                    }
                                    len -= bytes.begin();
                                }
                                if ((flags & 32) == 0 || width <= strLen) continue block73;
                                width -= strLen;
                                if ((flags & 8) == 0) {
                                    buf.fill(32, width);
                                    width = 0;
                                }
                                buf.append(bytes.getUnsafeBytes(), bytes.begin(), len);
                                if ((flags & 8) != 0) {
                                    buf.fill(32, width);
                                }
                                buf.setEncoding(enc);
                                ++offset;
                                incomplete = false;
                                continue block73;
                            }
                            buf.append(bytes);
                            incomplete = false;
                            continue block73;
                        }
                        buf.append(bytes);
                        incomplete = false;
                        continue block73;
                    }
                    case 42: {
                        if ((flags & 32) != 0) {
                            Sprintf.raiseArgumentError(args, "width given twice");
                        }
                        flags |= 32;
                        p_width = Sprintf.GETASTER(context, args, format, offset, length, true);
                        offset = p_width[0];
                        width = p_width[1];
                        if (width >= 0) continue block73;
                        flags |= 8;
                        if ((width = -width) >= 0) continue block73;
                        throw Error.argumentError(context, "width too big");
                    }
                    case 46: {
                        if ((flags & 64) != 0) {
                            Sprintf.raiseArgumentError(args, "precision given twice");
                        }
                        flags |= 64;
                        Sprintf.checkOffset(args, ++offset, length, "malformed format string - %.[0-9]");
                        fchar = format[offset];
                        if (fchar == 42) {
                            p_prec = Sprintf.GETASTER(context, args, format, offset, length, false);
                            offset = p_prec[0];
                            precision = p_prec[1];
                            if (precision >= 0) continue block73;
                            flags &= -65;
                            continue block73;
                        }
                        number = 0;
                        while (offset < length && Sprintf.isDigit(fchar = format[offset])) {
                            number = Sprintf.extendWidth(args, number, fchar, "width too big");
                            ++offset;
                        }
                        Sprintf.checkOffset(args, offset, length, "malformed format string - %.[0-9]");
                        precision = number;
                        continue block73;
                    }
                    case 37: {
                        if (flags != 0) {
                            Sprintf.raiseArgumentError(args, "illegal format character - %");
                        }
                        buf.append(37);
                        ++offset;
                        incomplete = false;
                        continue block73;
                    }
                    case 99: {
                        arg = args.getArg();
                        tmp = arg.checkStringType();
                        if (!tmp.isNil()) {
                            if (((RubyString)tmp).strLength() == 0) {
                                c = 0;
                                n = 0;
                            } else {
                                bl = ((RubyString)tmp).getByteList();
                                c = StringSupport.codePoint(context, (Encoding)encoding /* !! */ , bl.unsafeBytes(), bl.begin(), bl.begin() + bl.realSize());
                                n = StringSupport.codeLength(bl.getEncoding(), c);
                            }
                        } else {
                            c = (int)Convert.toLong(context, arg) & -1;
                            if (c >= 0) {
                                try {
                                    n = StringSupport.codeLength(encoding /* !! */ , c);
                                }
                                catch (EncodingException e) {
                                    n = -1;
                                }
                            } else {
                                n = -1;
                            }
                        }
                        if (n <= 0) {
                            throw Error.argumentError(context, "invalid character");
                        }
                        appendableEncoding = EncodingUtils.rbAscii8bitAppendableEncodingIndex(context, encoding /* !! */ , c);
                        if (appendableEncoding != null && appendableEncoding != encoding /* !! */ ) {
                            buf.setEncoding(appendableEncoding);
                            encoding /* !! */  = appendableEncoding;
                        }
                        if ((flags & 32) == 0) {
                            buf.ensure(buf.length() + n);
                            EncodingUtils.encMbcput(context, c, buf.unsafeBytes(), buf.begin() + buf.realSize(), encoding /* !! */ );
                            buf.realSize(buf.realSize() + n);
                        } else if ((flags & 8) != 0) {
                            buf.ensure(buf.length() + n);
                            EncodingUtils.encMbcput(context, c, buf.unsafeBytes(), buf.begin() + buf.realSize(), encoding /* !! */ );
                            buf.realSize(buf.realSize() + n);
                            buf.fill(32, width - n);
                        } else {
                            buf.fill(32, width - n);
                            buf.ensure(buf.length() + n);
                            EncodingUtils.encMbcput(context, c, buf.unsafeBytes(), buf.begin() + buf.realSize(), encoding /* !! */ );
                            buf.realSize(buf.realSize() + n);
                        }
                        ++offset;
                        incomplete = false;
                        continue block73;
                    }
                    case 65: 
                    case 97: {
                        arg = args.getArg();
                        bytes = new ByteList();
                        positive = Sprintf.isPositive(context, arg);
                        fval = RubyKernel.new_float(context, arg).asDouble(context);
                        negative = fval < 0.0 || fval == 0.0 && Double.doubleToLongBits(fval) == Double.doubleToLongBits(-0.0);
                        isnan = Double.isNaN(fval);
                        v0 = isinf = fval == Infinity || fval == -Infinity;
                        if (isnan || isinf) {
                            Sprintf.printSpecialValue(buf, flags, width, isnan, negative);
                            ++offset;
                            incomplete = false;
                            continue block73;
                        }
                        if ((flags & 8) != 0) {
                            if (!positive) {
                                bytes.append(45);
                            } else if ((flags & 4) != 0) {
                                bytes.append(43);
                            } else if ((flags & 1) != 0) {
                                bytes.append(32);
                            }
                            bytes.append(48);
                            bytes.append(fchar == 97 ? 120 : 88);
                        }
                        precision = Sprintf.generateBinaryFloat(context, flags, precision, fchar, bytes, arg);
                        bytesLength = bytes.length();
                        if ((flags & 8) == 0) {
                            if (!positive) {
                                buf.append(45);
                            } else if ((flags & 4) != 0) {
                                buf.append(43);
                            } else if ((flags & 1) != 0) {
                                buf.append(32);
                            }
                        }
                        if ((flags & 8) == 0 && width <= bytesLength) {
                            buf.append(48);
                            buf.append(fchar == 97 ? 120 : 88);
                        } else if (width > bytesLength) {
                            if ((flags & 2) != 0) {
                                buf.append(48);
                                buf.append(fchar == 97 ? 120 : 88);
                                buf.fill(48, width - bytesLength - 2);
                            } else if ((flags & 8) == 0) {
                                buf.fill(32, width - bytesLength - 2);
                                buf.append(48);
                                buf.append(fchar == 97 ? 120 : 88);
                            }
                        }
                        buf.append(bytes);
                        if (width > bytesLength && (flags & 8) != 0) {
                            buf.fill(32, width - bytesLength);
                        }
                        ++offset;
                        incomplete = false;
                        continue block73;
                    }
                    case 112: 
                    case 115: {
                        arg = args.getArg();
                        if (fchar == 112) {
                            arg = arg.callMethod(context, "inspect");
                        }
                        str = arg.asString();
                        bytes = str.getByteList();
                        len = bytes.length();
                        enc = RubyString.checkEncoding(context.runtime, buf, bytes);
                        if ((flags & 96) != 0) {
                            strLen = str.strLength();
                            if ((flags & 64) != 0 && precision < strLen) {
                                strLen = precision;
                                len = StringSupport.nth(enc, bytes.getUnsafeBytes(), bytes.begin(), bytes.begin() + bytes.getRealSize(), precision);
                                if (len == -1) {
                                    len = 0;
                                }
                                len -= bytes.begin();
                            }
                            if ((flags & 32) != 0 && width > strLen) {
                                width -= strLen;
                                if ((flags & 8) == 0) {
                                    buf.fill(32, width);
                                    width = 0;
                                }
                                buf.append(bytes.getUnsafeBytes(), bytes.begin(), len);
                                if ((flags & 8) != 0) {
                                    buf.fill(32, width);
                                }
                                buf.setEncoding(enc);
                                ++offset;
                                incomplete = false;
                                continue block73;
                            }
                        }
                        buf.append(bytes.getUnsafeBytes(), bytes.begin(), len);
                        buf.setEncoding(enc);
                        ++offset;
                        incomplete = false;
                        continue block73;
                    }
                    case 66: 
                    case 88: 
                    case 98: 
                    case 100: 
                    case 105: 
                    case 111: 
                    case 117: 
                    case 120: {
                        arg = args.getArg();
                        switch (1.$SwitchMap$org$jruby$runtime$ClassIndex[arg.getMetaClass().getClassIndex().ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                arg = Convert.asInteger(context, ((RubyFloat)arg).asDouble(context));
                                break;
                            }
                            case 3: {
                                arg = ((RubyString)arg).stringToInum(0, true);
                                break;
                            }
                            default: {
                                arg = TypeConverter.convertToInteger(context, arg, 0);
                                if (arg instanceof RubyInteger) break;
                                throw Error.typeError(context, arg, Access.integerClass(context));
                            }
                        }
                        first = 0;
                        signChar = 0;
                        leadChar = 0;
                        switch (fchar) {
                            case 100: 
                            case 105: {
                                fchar = 100;
                                sign = true;
                                break;
                            }
                            case 117: {
                                if ((flags & 5) != 0) {
                                    fchar = 100;
                                }
                                sign = true;
                                break;
                            }
                            case 66: 
                            case 88: 
                            case 98: 
                            case 111: 
                            case 120: {
                                sign = (flags & 5) != 0;
                                break;
                            }
                            default: {
                                sign = false;
                            }
                        }
                        switch (fchar) {
                            case 111: {
                                base = 8;
                                break;
                            }
                            case 88: 
                            case 120: {
                                base = 16;
                                break;
                            }
                            case 66: 
                            case 98: {
                                base = 2;
                                break;
                            }
                            default: {
                                base = 10;
                            }
                        }
                        if (arg instanceof RubyFixnum) {
                            fixnum = (RubyFixnum)arg;
                            v = fixnum.getValue();
                            negative = v < 0L;
                            v1 = zero = v == 0L;
                            bytes = negative && fchar == 117 ? Sprintf.getUnsignedNegativeBytes(v) : Sprintf.getFixnumBytes(v, base, sign, fchar == 88);
                        } else {
                            v = ((RubyBignum)arg).getValue();
                            negative = v.signum() < 0;
                            v2 = zero = v.signum() == 0;
                            bytes = negative != false && fchar == 117 && usePrefixForZero != false ? Sprintf.getUnsignedNegativeBytes(v) : Sprintf.getBignumBytes(v, base, sign, fchar == 88);
                        }
                        prefix = null;
                        if ((flags & 16) != 0 && (!zero || usePrefixForZero)) {
                            switch (fchar) {
                                case 111: {
                                    if (negative) break;
                                    prefix = Sprintf.PREFIX_OCTAL;
                                    break;
                                }
                                case 120: {
                                    prefix = Sprintf.PREFIX_HEX_LC;
                                    break;
                                }
                                case 88: {
                                    prefix = Sprintf.PREFIX_HEX_UC;
                                    break;
                                }
                                case 98: {
                                    prefix = Sprintf.PREFIX_BINARY_LC;
                                    break;
                                }
                                case 66: {
                                    prefix = Sprintf.PREFIX_BINARY_UC;
                                }
                            }
                            if (prefix != null) {
                                width -= prefix.length;
                            }
                        }
                        len = 0;
                        if (sign) {
                            if (negative) {
                                signChar = 45;
                                --width;
                                first = 1;
                            } else if ((flags & 4) != 0) {
                                signChar = 43;
                                --width;
                            } else if ((flags & 1) != 0) {
                                signChar = 32;
                                --width;
                            }
                        } else if (negative) {
                            if (base == 10) {
                                Warn.warning(context, "negative number for %u specifier");
                                leadChar = 46;
                                len += 2;
                            } else {
                                if ((flags & 66) == 0) {
                                    len += 2;
                                }
                                first = Sprintf.skipSignBits(bytes, base);
                                switch (fchar) {
                                    case 66: 
                                    case 98: {
                                        leadChar = 49;
                                        break;
                                    }
                                    case 111: {
                                        leadChar = 55;
                                        break;
                                    }
                                    case 120: {
                                        leadChar = 102;
                                        break;
                                    }
                                    case 88: {
                                        leadChar = 70;
                                    }
                                }
                                if (leadChar != 0) {
                                    ++len;
                                }
                            }
                        }
                        numlen = bytes.length - first;
                        switch (fchar) {
                            case 100: 
                            case 105: 
                            case 117: {
                                if ((flags & 64) == 0 || precision != 0 || !zero) break;
                                numlen = 0;
                            }
                        }
                        len += numlen;
                        if ((flags & 66) == 2) {
                            precision = width;
                            width = 0;
                        } else {
                            if (precision < len) {
                                precision = len;
                            }
                            width -= precision;
                        }
                        if ((flags & 8) == 0) {
                            buf.fill(32, width);
                            width = 0;
                        }
                        if (signChar != 0) {
                            buf.append(signChar);
                        }
                        if (prefix != null) {
                            buf.append(prefix);
                        }
                        if (len < precision) {
                            if (leadChar == 0) {
                                if (fchar != 100 || usePrefixForZero || !negative || (flags & 64) != 0 || (flags & 2) != 0 && (flags & 8) == 0) {
                                    buf.fill(48, precision - len);
                                }
                            } else if (leadChar == 46) {
                                buf.fill(leadChar, precision - len);
                                buf.append(Sprintf.PREFIX_NEGATIVE);
                            } else if (!usePrefixForZero) {
                                buf.append(Sprintf.PREFIX_NEGATIVE);
                                buf.fill(leadChar, precision - len - 1);
                            } else {
                                buf.fill(leadChar, precision - len + 1);
                            }
                        } else if (leadChar != 0) {
                            if ((flags & 66) == 0 && usePrefixForZero || !usePrefixForZero && "xXbBo".indexOf(fchar) != -1) {
                                buf.append(Sprintf.PREFIX_NEGATIVE);
                            }
                            if (leadChar != 46) {
                                buf.append(leadChar);
                            }
                        }
                        buf.append(bytes, first, numlen);
                        if (width > 0) {
                            buf.fill(32, width);
                        }
                        if (len < precision && fchar == 100 && negative && !usePrefixForZero && (flags & 8) != 0) {
                            buf.fill(32, precision - len);
                        }
                        ++offset;
                        incomplete = false;
                        continue block73;
                    }
                    case 102: {
                        arg = args.getArg();
                        sign = (flags & 4) != 0 ? 1 : 0;
                        zero = 0;
                        if (arg instanceof RubyInteger) {
                            den = Convert.asFixnum(context, 1);
                            num = (RubyInteger)arg;
                        } else if (arg instanceof RubyRational) {
                            den = ((RubyRational)arg).getDenominator();
                            num = ((RubyRational)arg).getNumerator();
                        } else {
                            args.nextObject = arg;
                            num = null;
                            den = null;
                        }
                        if (num == null) break;
                        if ((flags & 64) == 0) {
                            precision = 6;
                        }
                        if (num.isNegativeNumber(context)) {
                            num = (RubyInteger)num.op_uminus(context);
                            sign = -1;
                        }
                        if (!(den instanceof RubyFixnum) || (fixnum = den).getValue() != 1L) {
                            num = (RubyInteger)num.op_mul(context, Numeric.int_pow(context, 10L, precision));
                            num = (RubyInteger)num.op_plus(context, den.idiv(context, 2L));
                            num = (RubyInteger)num.idiv(context, den);
                        } else if (precision >= 0) {
                            zero = precision;
                        }
                        val = num.to_s(context);
                        len = val.length() + zero;
                        if (precision >= len) {
                            len = precision + 1;
                        }
                        if (sign != 0 || (flags & 1) != 0) {
                            ++len;
                        }
                        if (precision > 0) {
                            ++len;
                        }
                        fill = width > len ? width - len : 0;
                        buf.ensure(buf.length() + fill + len);
                        if (fill > 0 && (flags & 10) == 0) {
                            buf.fill(32, fill);
                        }
                        if (sign != 0 || (flags & 1) != 0) {
                            buf.append(sign > 0 ? 43 : (sign < 0 ? 45 : 32));
                        }
                        if (fill > 0 && (flags & 10) == 2) {
                            buf.fill(48, fill);
                        }
                        if ((len = val.length() + zero) > precision) {
                            buf.append(val.getByteList(), 0, len - precision);
                        } else {
                            buf.append(48);
                        }
                        if (precision > 0) {
                            buf.append(46);
                        }
                        if (zero > 0) {
                            buf.fill(48, zero);
                        } else if (precision > len) {
                            buf.fill(48, precision - len);
                            buf.append(val.getByteList(), 0, len);
                        } else if (precision > 0) {
                            buf.append(val.getByteList(), len - precision, precision);
                        }
                        if (fill > 0 && (flags & 8) != 0) {
                            buf.fill(32, fill);
                        }
                        ++offset;
                        incomplete = false;
                        continue block73;
                    }
                    case 69: 
                    case 71: 
                    case 101: 
                    case 103: 
                }
                arg = args.getArg();
                fval = RubyKernel.new_float(context, arg).asDouble(context);
                isnan = Double.isNaN(fval);
                isinf = fval == Infinity || fval == -Infinity;
                negative = fval < 0.0 || fval == 0.0 && Double.doubleToLongBits(fval) == Double.doubleToLongBits(-0.0);
                nDigits = 0;
                exponent = 0;
                len = 0;
                if (isnan || isinf) {
                    Sprintf.printSpecialValue(buf, flags, width, isnan, negative);
                    ++offset;
                    incomplete = false;
                    continue;
                }
                nf = Sprintf.getNumberFormat(args.locale);
                nf.setMaximumFractionDigits(0x7FFFFFFF);
                str = nf.format(fval);
                strlen = str.length();
                digits = new byte[strlen];
                nTrailingZeroes = 0;
                v3 = i = negative != false ? 1 : 0;
                block78: while (i < strlen) {
                    ival = (byte)str.charAt(i++);
                    switch (ival) {
                        case 48: {
                            if (nDigits <= 0) ** GOTO lbl591
                            ++nTrailingZeroes;
                            ** GOTO lbl591
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (nTrailingZeroes > 0) {
                                while (nTrailingZeroes > 0) {
                                    digits[nDigits++] = 48;
                                    --nTrailingZeroes;
                                }
                            }
                            digits[nDigits++] = ival;
                            ** GOTO lbl591
                        }
                        case 46: {
                            break block78;
                        }
lbl591:
                        // 4 sources

                        default: {
                            continue block78;
                        }
                    }
                }
                decPos = nDigits + nTrailingZeroes;
                block80: while (i < strlen) {
                    ival = (byte)str.charAt(i++);
                    switch (ival) {
                        case 48: {
                            if (nDigits > 0) {
                                ++nTrailingZeroes;
                            } else {
                                --exponent;
                            }
                            ** GOTO lbl613
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            if (nTrailingZeroes > 0) {
                                while (nTrailingZeroes > 0) {
                                    digits[nDigits++] = 48;
                                    --nTrailingZeroes;
                                }
                            }
                            digits[nDigits++] = ival;
                            ** GOTO lbl613
                        }
                        case 69: {
                            break block80;
                        }
lbl613:
                        // 4 sources

                        default: {
                            continue block80;
                        }
                    }
                }
                if (i < strlen) {
                    expVal = 0;
                    if (str.charAt(i) == '-') {
                        expSign = -1;
                        ++i;
                    } else {
                        expSign = 1;
                    }
                    while (i < strlen) {
                        expVal = expVal * 10 + (str.charAt(i++) - 48);
                    }
                    exponent += expVal * expSign;
                }
                exponent += decPos - nDigits;
                if (nDigits == 0) {
                    digits[0] = 48;
                    nDigits = 1;
                    exponent = 0;
                }
                if (negative) {
                    sign = 45;
                    --width;
                } else if ((flags & 4) != 0) {
                    sign = 43;
                    --width;
                } else if ((flags & 1) != 0) {
                    sign = 32;
                    --width;
                } else {
                    sign = 0;
                }
                if ((flags & 64) == 0) {
                    precision = 6;
                }
                switch (fchar) {
                    case 69: 
                    case 71: {
                        expChar = 69;
                        break;
                    }
                    case 101: 
                    case 103: {
                        expChar = 101;
                        break;
                    }
                    default: {
                        expChar = 0;
                    }
                }
                switch (fchar) {
                    case 71: 
                    case 103: {
                        v4 = exponent + nDigits - 1 < -4 || exponent + nDigits > (precision == 0 ? 1 : precision) ? true : (expForm = false);
                        if (expForm) {
                            decDigits = nDigits - 1;
                            if ((precision = Math.max(0, precision - 1)) < decDigits) {
                                n = Sprintf.round(digits, nDigits, precision, precision != 0);
                                if (n > nDigits) {
                                    nDigits = n;
                                }
                                decDigits = Math.min(nDigits - 1, precision);
                            }
                            isSharp = (flags & 16) != 0;
                            ++len;
                            len = (exponent += nDigits - 1) > 99 ? (len += 5) : (len += 4);
                            if (isSharp) {
                                ++len;
                            }
                            if (precision > 0) {
                                if (!isSharp) {
                                    for (j = decDigits; j >= 1 && digits[j] == 48; --j) {
                                        --decDigits;
                                    }
                                    if (decDigits > 0) {
                                        ++len;
                                        len += decDigits;
                                    }
                                } else {
                                    len += precision;
                                }
                            }
                            if ((width -= len) > 0 && (flags & 10) == 0) {
                                buf.fill(32, width);
                                width = 0;
                            }
                            if (sign != 0) {
                                buf.append(sign);
                            }
                            if (width > 0 && (flags & 8) == 0) {
                                buf.fill(48, width);
                                width = 0;
                            }
                            buf.append(digits[0]);
                            v5 = dotToPrint = isSharp != false || precision > 0 && decDigits > 0;
                            if (dotToPrint) {
                                buf.append(args.getDecimalSeparator());
                            }
                            if (precision > 0 && decDigits > 0) {
                                buf.append(digits, 1, decDigits);
                                precision -= decDigits;
                            }
                            if (precision > 0 && isSharp) {
                                buf.fill(48, precision);
                            }
                            Sprintf.writeExp(buf, exponent, expChar);
                            if (width <= 0) break;
                            buf.fill(32, width);
                            break;
                        }
                        intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                        intZeroes = Math.max(0, exponent);
                        intLength = intDigits + intZeroes;
                        decDigits = nDigits - intDigits;
                        decZeroes = Math.max(0, -(decDigits + exponent));
                        decLength = decZeroes + decDigits;
                        if ((precision = Math.max(0, precision - intLength)) < decDigits) {
                            n = Sprintf.round(digits, nDigits, intDigits + precision - 1, precision != 0);
                            if (n > nDigits) {
                                nDigits = n;
                                intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                                intLength = intDigits + intZeroes;
                                decDigits = nDigits - intDigits;
                                decZeroes = Math.max(0, -(decDigits + exponent));
                                precision = Math.max(0, precision - 1);
                            }
                            decDigits = precision;
                            decLength = decZeroes + decDigits;
                        }
                        len += intLength;
                        if (decLength > 0) {
                            len += decLength + 1;
                        } else if ((flags & 16) != 0) {
                            ++len;
                            if (precision > 0) {
                                len += precision;
                            }
                        }
                        if ((width -= len) > 0 && (flags & 10) == 0) {
                            buf.fill(32, width);
                            width = 0;
                        }
                        if (sign != 0) {
                            buf.append(sign);
                        }
                        if (width > 0 && (flags & 8) == 0) {
                            buf.fill(48, width);
                            width = 0;
                        }
                        if (intLength > 0) {
                            if (intDigits > 0) {
                                buf.append(digits, 0, intDigits);
                            }
                            if (intZeroes > 0) {
                                buf.fill(48, intZeroes);
                            }
                        } else {
                            buf.append(48);
                        }
                        if (decLength > 0 || (flags & 16) != 0) {
                            buf.append(args.getDecimalSeparator());
                        }
                        if (decLength > 0) {
                            if (decZeroes > 0) {
                                buf.fill(48, decZeroes);
                                precision -= decZeroes;
                            }
                            if (decDigits > 0) {
                                buf.append(digits, intDigits, decDigits);
                                precision -= decDigits;
                            }
                            if ((flags & 16) != 0 && precision > 0) {
                                buf.fill(48, precision);
                                precision = 0;
                            }
                        }
                        if ((flags & 16) != 0 && precision > 0) {
                            buf.fill(48, precision);
                        }
                        if (width <= 0) break;
                        buf.fill(32, width);
                        break;
                    }
                    case 102: {
                        intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                        intZeroes = Math.max(0, exponent);
                        intLength = intDigits + intZeroes;
                        decDigits = nDigits - intDigits;
                        decZeroes = Math.max(0, -(decDigits + exponent));
                        decLength = decZeroes + decDigits;
                        if (precision < decLength) {
                            if (precision < decZeroes) {
                                decDigits = 0;
                                decZeroes = precision;
                            } else {
                                n = Sprintf.round(digits, nDigits, intDigits + precision - decZeroes - 1, false);
                                if (n > nDigits) {
                                    nDigits = n;
                                    intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                                    intLength = intDigits + intZeroes;
                                    decDigits = nDigits - intDigits;
                                    decZeroes = Math.max(0, -(decDigits + exponent));
                                    decLength = decZeroes + decDigits;
                                }
                                decDigits = precision - decZeroes;
                            }
                            decLength = decZeroes + decDigits;
                        }
                        if (precision > 0) {
                            len += Math.max(1, intLength) + 1 + precision;
                        } else {
                            len += Math.max(1, intLength);
                            if ((flags & 16) != 0) {
                                ++len;
                            }
                        }
                        if ((width -= len) > 0 && (flags & 10) == 0) {
                            buf.fill(32, width);
                            width = 0;
                        }
                        if (sign != 0) {
                            buf.append(sign);
                        }
                        if (width > 0 && (flags & 8) == 0) {
                            buf.fill(48, width);
                            width = 0;
                        }
                        if (intLength > 0) {
                            if (intDigits > 0) {
                                buf.append(digits, 0, intDigits);
                            }
                            if (intZeroes > 0) {
                                buf.fill(48, intZeroes);
                            }
                        } else {
                            buf.append(48);
                        }
                        if (precision > 0 || (flags & 16) != 0) {
                            buf.append(args.getDecimalSeparator());
                        }
                        if (precision > 0) {
                            if (decZeroes > 0) {
                                buf.fill(48, decZeroes);
                                precision -= decZeroes;
                            }
                            if (decDigits > 0) {
                                buf.append(digits, intDigits, decDigits);
                                precision -= decDigits;
                            }
                            if (precision > 0) {
                                buf.fill(48, precision);
                            }
                        }
                        if (width <= 0) break;
                        buf.fill(32, width);
                        break;
                    }
                    case 69: 
                    case 101: {
                        decDigits = nDigits - 1;
                        if (precision < decDigits) {
                            n = Sprintf.round(digits, nDigits, precision, precision != 0);
                            if (n > nDigits) {
                                nDigits = n;
                            }
                            decDigits = Math.min(nDigits - 1, precision);
                        }
                        isSharp = (flags & 16) != 0;
                        ++len;
                        len = (exponent += nDigits - 1) > 99 ? (len += 5) : (len += 4);
                        if (precision > 0) {
                            len += 1 + precision;
                        } else if (isSharp) {
                            ++len;
                        }
                        if ((width -= len) > 0 && (flags & 10) == 0) {
                            buf.fill(32, width);
                            width = 0;
                        }
                        if (sign != 0) {
                            buf.append(sign);
                        }
                        if (width > 0 && (flags & 8) == 0) {
                            buf.fill(48, width);
                            width = 0;
                        }
                        buf.append(digits[0]);
                        if (precision > 0) {
                            buf.append(args.getDecimalSeparator());
                            if (decDigits > 0) {
                                buf.append(digits, 1, decDigits);
                                precision -= decDigits;
                            }
                            if (precision > 0) {
                                buf.fill(48, precision);
                            }
                        } else if ((flags & 16) != 0) {
                            buf.append(args.getDecimalSeparator());
                        }
                        Sprintf.writeExp(buf, exponent, expChar);
                        if (width <= 0) break;
                        buf.fill(32, width);
                    }
                }
                ++offset;
                incomplete = false;
            }
            if (!incomplete) continue;
            if (flags == 0) {
                if (format[length - 1] == 37) {
                    Sprintf.raiseArgumentError(args, "incomplete format specifier; use %% (double %) instead");
                }
                buf.append(37);
                continue;
            }
            Sprintf.raiseArgumentError(args, "illegal format character - %");
        }
        if (args.rubyHash == null && args.positionIndex >= 0 && args.nextIndex <= args.length) {
            if (context.runtime.isDebug()) {
                args.raiseArgumentError("too many arguments for format string");
            } else if (context.runtime.isVerbose()) {
                Warn.warn(context, "too many arguments for format string");
            }
        }
    }

    private static boolean isFormatSpecifier(byte b2) {
        return "aAbBcdeEfgGiopsuxX".contains("" + b2);
    }

    private static int generateBinaryFloat(ThreadContext context, int flags2, int precision2, byte fchar, ByteList bytes2, IRubyObject arg2) {
        long exponent2 = Sprintf.getExponent(context, arg2);
        byte[] mantissaBytes = Sprintf.getMantissaBytes(context, arg2);
        if (mantissaBytes[0] == 0) {
            exponent2 = 0L;
            bytes2.append(48);
            if (precision2 > 0 || (flags2 & 1) != 0) {
                bytes2.append(46);
                while (precision2 > 0) {
                    bytes2.append(48);
                    --precision2;
                }
            }
        } else {
            byte digit;
            int i2 = 0;
            if ((digit = Sprintf.getDigit(i2++, mantissaBytes)) == 0) {
                digit = Sprintf.getDigit(i2++, mantissaBytes);
            }
            assert (digit == 1);
            bytes2.append(49);
            int digits2 = Sprintf.getNumberOfDigits(mantissaBytes);
            if (i2 < digits2 || (flags2 & 1) != 0 || precision2 > 0) {
                bytes2.append(46);
            }
            if ((flags2 & 0x40) == 0) {
                precision2 = -1;
            }
            while (precision2 < 0 && i2 < digits2 || precision2 > 0) {
                digit = Sprintf.getDigit(i2++, mantissaBytes);
                bytes2.append((fchar == 97 ? HEX_DIGITS : HEX_DIGITS_UPPER_CASE)[digit]);
                --precision2;
            }
        }
        bytes2.append(fchar == 97 ? 112 : 80);
        if (exponent2 >= 0L) {
            bytes2.append(43);
        }
        bytes2.append(Long.toString(exponent2).getBytes());
        return precision2;
    }

    private static void printSpecialValue(ByteList buf, int flags2, int width, boolean isnan, boolean negative) {
        byte sign2;
        int len;
        byte[] digits2;
        if (isnan) {
            digits2 = NAN_VALUE;
            len = NAN_VALUE.length;
        } else {
            digits2 = INFINITY_VALUE;
            len = INFINITY_VALUE.length;
        }
        if (negative) {
            sign2 = 45;
            --width;
        } else if ((flags2 & 4) != 0) {
            sign2 = 43;
            --width;
        } else if ((flags2 & 1) != 0) {
            sign2 = 32;
            --width;
        } else {
            sign2 = 0;
        }
        if ((width -= len) > 0 && (flags2 & 8) == 0) {
            buf.fill(32, width);
            width = 0;
        }
        if (sign2 != 0) {
            buf.append(sign2);
        }
        buf.append(digits2);
        if (width > 0) {
            buf.fill(32, width);
        }
    }

    public static NumberFormat getNumberFormat(Locale locale) {
        NumberFormat format;
        Map<Locale, NumberFormat> numberFormats = LOCALE_NUMBER_FORMATS.get();
        if (numberFormats == null) {
            numberFormats = new HashMap<Locale, NumberFormat>(4);
            LOCALE_NUMBER_FORMATS.set(numberFormats);
        }
        if ((format = numberFormats.get(locale)) == null) {
            format = NumberFormat.getNumberInstance(locale);
            numberFormats.put(locale, format);
        }
        return format;
    }

    public static DecimalFormatSymbols getDecimalFormat(Locale locale) {
        DecimalFormatSymbols format;
        Map<Locale, DecimalFormatSymbols> decimalFormats = LOCALE_DECIMAL_FORMATS.get();
        if (decimalFormats == null) {
            decimalFormats = new HashMap<Locale, DecimalFormatSymbols>(4);
            LOCALE_DECIMAL_FORMATS.set(decimalFormats);
        }
        if ((format = decimalFormats.get(locale)) == null) {
            format = new DecimalFormatSymbols(locale);
            decimalFormats.put(locale, format);
        }
        return format;
    }

    private static void writeExp(ByteList buf, int exponent2, byte expChar) {
        buf.append(expChar);
        buf.append(exponent2 >= 0 ? 43 : 45);
        if (exponent2 < 0) {
            exponent2 = -exponent2;
        }
        if (exponent2 > 99) {
            buf.append(exponent2 / 100 + 48);
            buf.append(exponent2 % 100 / 10 + 48);
        } else {
            buf.append(exponent2 / 10 + 48);
        }
        buf.append(exponent2 % 10 + 48);
    }

    private static void raiseArgumentError(Args args2, String message2) {
        args2.raiseArgumentError(message2);
    }

    private static void checkOffset(Args args2, int offset2, int length2, String message2) {
        if (offset2 >= length2) {
            Sprintf.raiseArgumentError(args2, message2);
        }
    }

    private static int[] GETASTER(ThreadContext context, Args args2, byte[] format, int offset2, int length2, boolean width) {
        IRubyObject tmp;
        String errMessage;
        Sprintf.checkOffset(args2, ++offset2, length2, ERR_MALFORMED_STAR_NUM);
        int mark = offset2;
        int number = 0;
        byte fchar = 0;
        String string2 = errMessage = width ? "width too big" : "prec too big";
        while (offset2 < length2 && Sprintf.isDigit(fchar = format[offset2])) {
            number = Sprintf.extendWidth(args2, number, fchar, errMessage);
            ++offset2;
        }
        Sprintf.checkOffset(args2, offset2, length2, ERR_MALFORMED_STAR_NUM);
        if (fchar == 36) {
            tmp = args2.getPositionArg(number);
        } else {
            tmp = args2.getNextArg();
            offset2 = mark;
        }
        return new int[]{++offset2, args2.intValue(context, tmp)};
    }

    private static int extendWidth(Args args2, int oldWidth, byte newChar, String errMessage) {
        int newWidth = oldWidth * 10 + (newChar - 48);
        if (newWidth / 10 != oldWidth) {
            Sprintf.raiseArgumentError(args2, errMessage);
        }
        return newWidth;
    }

    private static boolean isDigit(byte aChar) {
        return aChar >= 48 && aChar <= 57;
    }

    private static boolean isPrintable(byte aChar) {
        return aChar > 32 && aChar < 127;
    }

    private static int skipSignBits(byte[] bytes2, int base) {
        int skip2;
        int length2 = bytes2.length;
        switch (base) {
            case 2: {
                for (skip2 = 0; skip2 < length2 && bytes2[skip2] == 49; ++skip2) {
                }
                break;
            }
            case 8: {
                if (length2 > 0 && bytes2[0] == 51) {
                    ++skip2;
                }
                while (skip2 < length2 && bytes2[skip2] == 55) {
                    ++skip2;
                }
                break;
            }
            case 10: {
                if (length2 <= 0 || bytes2[0] != 45) break;
                ++skip2;
                break;
            }
            case 16: {
                byte b2;
                while (skip2 < length2 && ((b2 = bytes2[skip2]) == 102 || b2 == 70)) {
                    ++skip2;
                }
                break;
            }
        }
        return skip2;
    }

    private static int round(byte[] bytes2, int nDigits, int roundPos, boolean roundDown) {
        int nextPos = roundPos + 1;
        if (nextPos >= nDigits) {
            return nDigits;
        }
        if (bytes2[nextPos] < 53) {
            return nDigits;
        }
        if (roundPos < 0) {
            System.arraycopy(bytes2, 0, bytes2, 1, nDigits);
            bytes2[0] = 49;
            return nDigits + 1;
        }
        if (bytes2[nextPos] == 53) {
            if (nextPos == nDigits - 1 && (roundDown || (bytes2[roundPos] - 48) % 2 == 0)) {
                return nDigits;
            }
            int i2 = nextPos;
            while (++i2 < nDigits && bytes2[i2] == 48) {
            }
            if (i2 == nDigits - 1 && bytes2[i2] == 48 && (bytes2[roundPos] - 48) % 2 == 0) {
                return nDigits;
            }
        }
        int n = roundPos;
        bytes2[n] = (byte)(bytes2[n] + 1);
        while (bytes2[roundPos] > 57) {
            bytes2[roundPos] = 48;
            if (--roundPos >= 0) {
                int n2 = roundPos;
                bytes2[n2] = (byte)(bytes2[n2] + 1);
                continue;
            }
            System.arraycopy(bytes2, 0, bytes2, 1, nDigits);
            bytes2[0] = 49;
            return nDigits + 1;
        }
        return nDigits;
    }

    private static byte[] getFixnumBytes(long val, int base, boolean sign2, boolean upper) {
        if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
            if (sign2) {
                return ConvertBytes.intToByteArray((int)val, base, upper);
            }
            switch (base) {
                case 2: {
                    return ConvertBytes.intToBinaryBytes((int)val);
                }
                case 8: {
                    return ConvertBytes.intToOctalBytes((int)val);
                }
                default: {
                    return ConvertBytes.intToCharBytes((int)val);
                }
                case 16: 
            }
            return ConvertBytes.intToHexBytes((int)val, upper);
        }
        if (sign2) {
            return ConvertBytes.longToByteArray(val, base, upper);
        }
        switch (base) {
            case 2: {
                return ConvertBytes.longToBinaryBytes(val);
            }
            case 8: {
                return ConvertBytes.longToOctalBytes(val);
            }
            default: {
                return ConvertBytes.longToCharBytes(val);
            }
            case 16: 
        }
        return ConvertBytes.longToHexBytes(val, upper);
    }

    private static byte[] getBignumBytes(BigInteger val, int base, boolean sign2, boolean upper) {
        if (sign2 || base == 10 || val.signum() >= 0) {
            return Sprintf.stringToBytes(val.toString(base), upper);
        }
        switch (base) {
            case 2: {
                return ConvertBytes.twosComplementToBinaryBytes(val.toByteArray());
            }
            case 8: {
                return ConvertBytes.twosComplementToOctalBytes(val.toByteArray());
            }
            case 16: {
                return ConvertBytes.twosComplementToHexBytes(val.toByteArray(), upper);
            }
        }
        return Sprintf.stringToBytes(val.toString(base), upper);
    }

    private static byte[] getUnsignedNegativeBytes(long val) {
        if (val < 0L) {
            return ConvertBytes.longToCharBytes(0L + val);
        }
        return Sprintf.getUnsignedNegativeBytes(BigInteger.valueOf(val));
    }

    private static byte[] getUnsignedNegativeBytes(BigInteger val) {
        int shift2 = 0;
        BigInteger minus = BIG_MINUS_64;
        while (val.compareTo(minus) < 0) {
            minus = minus.shiftLeft(32);
            ++shift2;
        }
        BigInteger nPower32 = shift2 > 0 ? BIG_64.shiftLeft(32 * shift2) : BIG_64;
        return Sprintf.stringToBytes(nPower32.add(val).toString());
    }

    private static byte[] stringToBytes(CharSequence s2, boolean upper) {
        if (upper) {
            int len = s2.length();
            byte[] bytes2 = new byte[len];
            int i2 = len;
            while (--i2 >= 0) {
                byte b2 = (byte)(s2.charAt(i2) & 0xFF);
                if (b2 >= 97 && b2 <= 122) {
                    bytes2[i2] = (byte)(b2 & 0xFFFFFFDF);
                    continue;
                }
                bytes2[i2] = b2;
            }
            return bytes2;
        }
        return Sprintf.stringToBytes(s2);
    }

    private static byte[] stringToBytes(CharSequence s2) {
        return ByteList.plain(s2);
    }

    private static int getNumberOfDigits(byte[] bytes2) {
        int digits2 = bytes2.length * 2;
        if (Sprintf.getDigit(digits2 - 1, bytes2) == 0) {
            --digits2;
        }
        return digits2;
    }

    private static byte getDigit(int position, byte[] bytes2) {
        int index2 = position / 2;
        if (index2 < bytes2.length) {
            byte twoDigits = bytes2[index2];
            if (position % 2 == 0) {
                return (byte)(twoDigits >> 4 & 0xF);
            }
            return (byte)(twoDigits & 0xF);
        }
        return 0;
    }

    private static boolean isPositive(ThreadContext context, Object value2) {
        Object object = value2;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFloat.class, RubyFixnum.class, RubyBignum.class}, (Object)object2, n)) {
            case 0 -> {
                RubyFloat flote = (RubyFloat)object2;
                if ((Double.doubleToRawLongBits(flote.asDouble(context)) & Long.MIN_VALUE) == 0L) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                RubyFixnum fixnum = (RubyFixnum)object2;
                if (fixnum.getValue() >= 0L) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                RubyBignum bignum = (RubyBignum)object2;
                if (bignum.signum(context) >= 0) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private static byte[] getMantissaBytes(ThreadContext context, IRubyObject value2) {
        BigInteger bi;
        if (value2 instanceof RubyFloat) {
            long bits = Double.doubleToRawLongBits(((RubyFloat)value2).asDouble(context));
            long biasedExp = (bits & 0x7FF0000000000000L) >> 52;
            long mantissaBits = bits & 0xFFFFFFFFFFFFFL;
            if (biasedExp > 0L) {
                mantissaBits |= 0x10000000000000L;
            }
            bi = BigInteger.valueOf(mantissaBits);
        } else if (value2 instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)value2;
            bi = BigInteger.valueOf(fixnum.getValue());
        } else if (value2 instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)value2;
            bi = bignum.getValue();
        } else {
            bi = BigInteger.ZERO;
        }
        bi = bi.abs();
        if (BigInteger.ZERO.equals(bi)) {
            return new byte[1];
        }
        int bitLength = (bi = bi.shiftRight(bi.getLowestSetBit() - 1)).bitLength() % 4;
        if (bitLength != 1) {
            bi = bi.shiftLeft(5 - bitLength);
        }
        return bi.toByteArray();
    }

    private static long getExponent(ThreadContext context, IRubyObject value2) {
        if (value2 instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)value2;
            return bignum.getValue().abs().bitLength() - 1;
        }
        if (value2 instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)value2;
            long lval = fixnum.getValue();
            return lval == Long.MIN_VALUE ? 63L : (long)(63 - Long.numberOfLeadingZeros(Math.abs(lval)));
        }
        if (value2 instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)value2;
            long bits = Double.doubleToRawLongBits(flote.getValue());
            long biasedExp = (bits & 0x7FF0000000000000L) >> 52;
            long mantissaBits = bits & 0xFFFFFFFFFFFFFL;
            if (biasedExp == 0L) {
                int lz = Long.numberOfLeadingZeros(mantissaBits);
                biasedExp -= (long)(lz - 12);
            }
            return biasedExp - 1023L;
        }
        return 0L;
    }

    private static final class Args {
        private final Ruby runtime;
        private final Locale locale;
        private final IRubyObject rubyObject;
        private final RubyArray rubyArray;
        private final RubyHash rubyHash;
        private final int length;
        private int positionIndex;
        private int nextIndex;
        private IRubyObject nextObject;

        Args(Locale locale, IRubyObject rubyObject) {
            if (rubyObject == null) {
                throw new IllegalArgumentException("null IRubyObject passed to sprintf");
            }
            this.locale = locale == null ? Locale.getDefault() : locale;
            this.rubyObject = rubyObject;
            if (rubyObject instanceof RubyArray) {
                this.rubyArray = (RubyArray)rubyObject;
                this.rubyHash = this.rubyArray.last(this.rubyArray.getRuntime().getCurrentContext()) instanceof RubyHash ? (RubyHash)this.rubyArray.pop(this.rubyArray.getRuntime().getCurrentContext()) : null;
                this.length = this.rubyArray.size();
            } else if (rubyObject instanceof RubyHash) {
                this.rubyHash = (RubyHash)rubyObject;
                this.rubyArray = null;
                this.length = 1;
            } else {
                this.length = 1;
                this.rubyArray = null;
                this.rubyHash = null;
            }
            this.positionIndex = 0;
            this.nextIndex = 1;
            this.runtime = rubyObject.getRuntime();
        }

        Args(IRubyObject rubyObject) {
            this(Locale.getDefault(), rubyObject);
        }

        Args(Ruby runtime2, long value2) {
            this(RubyFixnum.newFixnum(runtime2, value2));
        }

        void raiseArgumentError(String message2) {
            throw Error.argumentError(this.runtime.getCurrentContext(), message2);
        }

        void raiseKeyError(String message2, IRubyObject recv2, IRubyObject key2) {
            throw this.runtime.newKeyError(message2, recv2, key2);
        }

        void warn(IRubyWarnings.ID id, String message2) {
            this.runtime.getWarnings().warn(id, message2);
        }

        private IRubyObject getHashValue(ByteList name2, char startDelim, char endDelim) {
            if (this.rubyHash == null) {
                this.raiseArgumentError("one hash required");
            }
            this.checkNameArg(name2, startDelim, endDelim);
            RubySymbol nameSym = this.runtime.newSymbol(name2);
            IRubyObject object = this.rubyHash.fastARef(nameSym);
            if (object == null) {
                object = this.rubyHash.getIfNone();
                if (object == RubyBasicObject.UNDEF) {
                    RubyString nameStr = Create.newString(this.runtime.getCurrentContext(), name2);
                    this.raiseKeyError("key" + startDelim + String.valueOf(nameStr) + endDelim + " not found", this.rubyHash, nameSym);
                } else if (this.rubyHash.hasDefaultProc()) {
                    object = object.callMethod(this.runtime.getCurrentContext(), "call", nameSym);
                }
                if (object.isNil()) {
                    throw this.runtime.newKeyError("key" + startDelim + String.valueOf(nameSym) + endDelim + " not found", this.rubyHash, nameSym);
                }
            }
            return object;
        }

        private IRubyObject getNthArg(int index2) {
            if (index2 > this.length) {
                if (index2 == this.length + 1 && this.rubyHash != null) {
                    return this.rubyHash;
                }
                this.raiseArgumentError("too few arguments");
            }
            return this.rubyArray == null ? this.rubyObject : this.rubyArray.eltInternal(index2 - 1);
        }

        private IRubyObject getArg() {
            IRubyObject nextObject = this.nextObject;
            if (nextObject != null) {
                this.nextObject = null;
                return nextObject;
            }
            return this.getNextArg();
        }

        private IRubyObject getNextArg() {
            this.checkNextArg();
            this.positionIndex = this.nextIndex++;
            return this.getNthArg(this.positionIndex);
        }

        private IRubyObject getPositionArg(int index2) {
            this.checkPositionArg(index2);
            this.positionIndex = -1;
            return this.getNthArg(index2);
        }

        private void checkNextArg() {
            if (this.positionIndex == -1) {
                this.raiseArgumentError("unnumbered(" + this.nextIndex + ") mixed with numbered");
            }
            if (this.positionIndex == -2) {
                this.raiseArgumentError("unnumbered(" + this.nextIndex + ") mixed with named");
            }
        }

        private void checkPositionArg(int nthArg) {
            if (this.positionIndex > 0) {
                this.raiseArgumentError("numbered(" + nthArg + ") after unnumbered(" + this.positionIndex + ")");
            }
            if (this.positionIndex == -2) {
                this.raiseArgumentError("numbered(" + nthArg + ") after named");
            }
            if (nthArg < 1) {
                this.raiseArgumentError("invalid index - " + nthArg + "$");
            }
        }

        private void checkNameArg(ByteList name2, char startDelim, char endDelim) {
            if (this.positionIndex > 0) {
                this.raiseArgumentError("named" + startDelim + String.valueOf(RubyString.newString(this.runtime, name2)) + endDelim + " after unnumbered(" + this.positionIndex + ")");
            }
            if (this.positionIndex == -1) {
                this.raiseArgumentError("named" + startDelim + String.valueOf(RubyString.newString(this.runtime, name2)) + endDelim + " after numbered");
            }
            this.positionIndex = -2;
        }

        @Deprecated(since="9.1.8.0")
        IRubyObject next(ByteList name2) {
            if (name2 != null) {
                RubySymbol nameSym;
                IRubyObject object;
                if (this.rubyHash == null && this.positionIndex == -1) {
                    this.raiseArgumentError("positional args mixed with named args");
                }
                if ((object = this.rubyHash.fastARef(nameSym = this.runtime.newSymbol(name2))) == null) {
                    object = this.rubyHash.getIfNone();
                    if (object == RubyBasicObject.UNDEF) {
                        RubyString nameStr = RubyString.newString(this.runtime, name2);
                        this.raiseKeyError("key<" + String.valueOf(name2) + "> not found", this.rubyHash, nameSym);
                    } else if (this.rubyHash.hasDefaultProc()) {
                        object = object.callMethod(this.runtime.getCurrentContext(), "call", nameSym);
                    }
                    if (object.isNil()) {
                        throw this.runtime.newKeyError("key " + String.valueOf(nameSym) + " not found", this.rubyHash, nameSym);
                    }
                }
                return object;
            }
            if (this.rubyHash != null) {
                this.raiseArgumentError("positional args mixed with named args");
            }
            if (this.positionIndex == -1) {
                this.raiseArgumentError("unnumbered" + (this.positionIndex + 1) + "mixed with numbered");
            }
            if (this.positionIndex >= this.length) {
                this.raiseArgumentError("too few arguments");
            }
            IRubyObject object = this.rubyArray == null ? this.rubyObject : this.rubyArray.eltInternal(this.positionIndex);
            ++this.positionIndex;
            return object;
        }

        int intValue(ThreadContext context, IRubyObject obj) {
            if (obj instanceof RubyNumeric) {
                RubyNumeric num = (RubyNumeric)obj;
                return num.asInt(context);
            }
            obj = TypeConverter.convertToType(obj, Access.fixnumClass(context), "to_int", true);
            return ((RubyFixnum)obj).asInt(context);
        }

        byte getDecimalSeparator() {
            return (byte)Sprintf.getDecimalFormat(this.locale).getDecimalSeparator();
        }
    }
}

