/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.net.InetSocketAddress;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.Sockaddr;

@JRubyClass(name={"IPSocket"}, parent="BasicSocket")
public class RubyIPSocket
extends RubyBasicSocket {
    static RubyClass createIPSocket(ThreadContext context, RubyClass BasicSocket) {
        return (RubyClass)((RubyModule)Define.defineClass(context, "IPSocket", BasicSocket, RubyIPSocket::new).defineMethods(context, RubyIPSocket.class)).undefMethods(context, "initialize");
    }

    public RubyIPSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(name={"addr"})
    public IRubyObject addr(ThreadContext context) {
        return this.addrCommon(context, !context.runtime.isDoNotReverseLookupEnabled());
    }

    @JRubyMethod(name={"addr"})
    public IRubyObject addr(ThreadContext context, IRubyObject reverse2) {
        return this.addrCommon(context, reverse2);
    }

    @JRubyMethod(name={"peeraddr"})
    public IRubyObject peeraddr(ThreadContext context) {
        return this.peeraddrCommon(context, !context.runtime.isDoNotReverseLookupEnabled());
    }

    @JRubyMethod(name={"peeraddr"})
    public IRubyObject peeraddr(ThreadContext context, IRubyObject reverse2) {
        return this.peeraddrCommon(context, reverse2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject getaddress(ThreadContext context, IRubyObject self2, IRubyObject hostname) {
        return SocketUtils.getaddress(context, hostname);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length) {
        String hostName;
        String hostAddress;
        int port;
        IRubyObject result2 = this.recv(context, _length);
        InetSocketAddress sender = this.getInetRemoteSocket(context);
        if (sender == null) {
            port = 0;
            hostAddress = "0.0.0.0";
            hostName = "0.0.0.0";
        } else {
            port = sender.getPort();
            hostName = sender.getHostName();
            hostAddress = sender.getAddress().getHostAddress();
        }
        RubyArray<?> addressArray = Create.newArrayNoCopy(context, Create.newString(context, "AF_INET"), Convert.asFixnum(context, port), Create.newString(context, hostName), Create.newString(context, hostAddress));
        return Create.newArray(context, result2, addressArray);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length, IRubyObject _flags) {
        return this.recvfrom(context, _length);
    }

    @Override
    @JRubyMethod(name={"getpeereid"}, notImplemented=true)
    public IRubyObject getpeereid(ThreadContext context) {
        throw context.runtime.newNotImplementedError("getpeereid not implemented");
    }

    @Override
    protected IRubyObject getSocknameCommon(ThreadContext context, String caller2) {
        return Sockaddr.packSockaddrFromAddress(context, this.getInetSocketAddress());
    }

    @Override
    public IRubyObject getpeername(ThreadContext context) {
        return Sockaddr.packSockaddrFromAddress(context, this.getInetRemoteSocket(context));
    }

    private IRubyObject addrCommon(ThreadContext context, IRubyObject reverse2) {
        Boolean doReverse = RubyIPSocket.doReverseLookup(context, reverse2);
        if (doReverse == null) {
            doReverse = false;
        }
        return this.addrCommon(context, doReverse);
    }

    private IRubyObject addrCommon(ThreadContext context, boolean reverse2) {
        InetSocketAddress address2 = this.getInetSocketAddress();
        this.checkAddress(context, address2);
        return this.addrFor(context, address2, reverse2);
    }

    private void checkAddress(ThreadContext context, InetSocketAddress address2) {
        if (address2 == null) {
            throw context.runtime.newErrnoENOTSOCKError("Not socket or not connected");
        }
    }

    private IRubyObject peeraddrCommon(ThreadContext context, IRubyObject reverse2) {
        Boolean doReverse = RubyIPSocket.doReverseLookup(context, reverse2);
        if (doReverse == null) {
            doReverse = !context.runtime.isDoNotReverseLookupEnabled();
        }
        return this.peeraddrCommon(context, doReverse);
    }

    private IRubyObject peeraddrCommon(ThreadContext context, boolean reverse2) {
        InetSocketAddress address2 = this.getInetRemoteSocket(context);
        this.checkAddress(context, address2);
        return this.addrFor(context, address2, reverse2);
    }

    public static Boolean doReverseLookup(ThreadContext context, IRubyObject noreverse) {
        if (noreverse == context.tru) {
            return false;
        }
        if (noreverse == context.fals) {
            return true;
        }
        if (noreverse == context.nil) {
            return null;
        }
        TypeConverter.checkType(context, noreverse, Access.symbolClass(context));
        return switch (noreverse.toString()) {
            case "numeric" -> true;
            case "hostname" -> false;
            default -> throw Error.argumentError(context, "invalid reverse_lookup flag: " + String.valueOf(noreverse));
        };
    }

    @Deprecated(since="1.7.0")
    public IRubyObject addr() {
        return this.addr(this.getCurrentContext());
    }

    @Deprecated(since="1.7.0")
    public IRubyObject peeraddr() {
        return this.peeraddr(this.getCurrentContext());
    }

    @Deprecated(since="1.7.0")
    public static IRubyObject getaddress(IRubyObject recv2, IRubyObject hostname) {
        return RubyIPSocket.getaddress(((RubyBasicObject)recv2).getCurrentContext(), recv2, hostname);
    }

    @Deprecated(since="1.7.0")
    public IRubyObject recvfrom(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.recvfrom(context, args2[0]);
            }
            case 2: {
                return this.recvfrom(context, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context, args2, 1, 2);
        return null;
    }
}

