/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.ivars;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.api.Error;
import org.jruby.java.codegen.Reified;
import org.jruby.javasupport.util.JavaClassConfiguration;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.ivars.AtomicVariableTable;
import org.jruby.runtime.ivars.FieldVariableAccessor;
import org.jruby.runtime.ivars.RawFieldVariableAccessor;
import org.jruby.runtime.ivars.StampedVariableAccessor;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.ivars.VariableAccessorField;
import org.jruby.specialized.RubyObjectSpecializer;
import org.jruby.util.ArraySupport;
import org.jruby.util.StringSupport;

public class VariableTableManager {
    private final RubyClass realClass;
    private Map<String, VariableAccessor> variableAccessors = Collections.EMPTY_MAP;
    private volatile String[] variableNames = StringSupport.EMPTY_STRING_ARRAY;
    private volatile int hasObjectID = 0;
    private volatile int hasFFI = 0;
    private volatile int hasObjectspaceGroup = 0;
    private volatile int fieldVariables = 0;
    private final VariableAccessorField objectIdVariableAccessorField = new VariableAccessorField("object_id");
    private final VariableAccessorField ffiHandleVariableAccessorField = new VariableAccessorField("ffi");
    private final VariableAccessorField objectGroupVariableAccessorField = new VariableAccessorField("objectspace_group");

    public VariableTableManager(RubyClass realClass) {
        this.realClass = realClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VariableTableManager(VariableTableManager original, RubyClass realClass) {
        VariableTableManager variableTableManager = original;
        synchronized (variableTableManager) {
            this.realClass = realClass;
            this.variableAccessors = VariableTableManager.copyVariableAccessors(original.variableAccessors);
            this.variableNames = (String[])original.variableNames.clone();
            this.hasObjectID = original.hasObjectID;
            this.hasFFI = original.hasFFI;
            this.hasObjectspaceGroup = original.hasObjectspaceGroup;
            this.fieldVariables = original.fieldVariables;
        }
    }

    public RubyClass getRealClass() {
        return this.realClass;
    }

    public Map<String, VariableAccessor> getVariableAccessorsForRead() {
        return this.variableAccessors;
    }

    public boolean hasObjectID() {
        return this.hasObjectID == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectId(RubyBasicObject self2) {
        VariableAccessor objectIdAccessor = this.getObjectIdAccessorForRead();
        Number id = (Number)objectIdAccessor.get(self2);
        if (id != null) {
            return id.longValue();
        }
        RubyBasicObject rubyBasicObject = self2;
        synchronized (rubyBasicObject) {
            objectIdAccessor = this.getObjectIdAccessorForRead();
            id = (Number)objectIdAccessor.get(self2);
            if (id != null) {
                return id.longValue();
            }
            objectIdAccessor = this.getObjectIdAccessorForWrite();
            return this.initObjectId(self2, objectIdAccessor);
        }
    }

    public void setVariableInternal(RubyBasicObject self2, int index2, Object value2) {
        AtomicVariableTable.setVariableAtomic(self2, this.realClass, true, index2, value2);
    }

    public static void setVariableInternal(RubyClass realClass, RubyBasicObject self2, int index2, Object value2) {
        AtomicVariableTable.setVariableAtomic(self2, realClass, true, index2, value2);
    }

    public synchronized void requestFieldStorage(String name2, Class<?> fieldType, Boolean unwrap, Class<?> toType) {
        JavaClassConfiguration.DirectFieldConfiguration config2 = new JavaClassConfiguration.DirectFieldConfiguration(name2, fieldType, unwrap, toType);
        if (this.realClass.reifiedClass() != null) {
            this.requestFieldStorage(config2);
        } else {
            if (this.realClass.getClassConfig().requestedStorageVariables == null) {
                this.realClass.getClassConfig().requestedStorageVariables = new ArrayList<JavaClassConfiguration.DirectFieldConfiguration>();
            }
            this.realClass.getClassConfig().requestedStorageVariables.add(config2);
        }
    }

    public void requestFieldStorage(JavaClassConfiguration.DirectFieldConfiguration config2) {
        try {
            Class<IRubyObject> unwrapType;
            Class<? extends Reified> reifiedClass = this.realClass.reifiedClass();
            Class<IRubyObject> fieldType = reifiedClass.getField(config2.name).getType();
            if (fieldType != config2.fieldType) {
                throw Error.typeError(this.realClass.getClassRuntime().getCurrentContext(), "java_field " + config2.name + " has incorrectly specified types for @ivar mapping");
            }
            boolean unwrap = config2.unwrap == null ? !fieldType.isAssignableFrom(IRubyObject.class) : config2.unwrap;
            Class<IRubyObject> clazz = unwrapType = config2.unwrapType == null ? fieldType : config2.unwrapType;
            if (unwrap && !fieldType.isAssignableFrom(unwrapType)) {
                throw Error.typeError(this.realClass.getClassRuntime().getCurrentContext(), config2.name + " has incorrectly specified unwrap type for @ivar mapping: type is incompatible");
            }
            this.getVariableAccessorForJavaMappedVar("@" + config2.name, unwrap, fieldType, unwrapType, RubyObjectSpecializer.LOOKUP.findGetter(reifiedClass, config2.name, fieldType), RubyObjectSpecializer.LOOKUP.findSetter(reifiedClass, config2.name, fieldType));
        }
        catch (NoSuchFieldException e) {
            throw Error.nameError(this.realClass.getClassRuntime().getCurrentContext(), "java_field " + config2.name + " was marked for @ivar mapping, but wasn't found (was the class reifed already?)", config2.name);
        }
        catch (IllegalAccessException e) {
            throw this.realClass.getClassRuntime().newSecurityError("Error in accessing java_field " + config2.name + ": " + e.getMessage());
        }
    }

    public VariableAccessor getVariableAccessorForWrite(String name2) {
        return this.getVariableAccessorWithBuilder(name2, this.makeTableVariableAccessorBuilder(name2));
    }

    public VariableAccessor getVariableAccessorForRubyVar(String name2, MethodHandle getter, MethodHandle setter) {
        return this.getVariableAccessorWithBuilder(name2, this.makeRubyFieldAccessorBuilder(name2, getter, setter));
    }

    public VariableAccessor getVariableAccessorForJavaMappedVar(String name2, boolean unwrap, Class<?> unwrapType, Class<?> fieldType, MethodHandle getter, MethodHandle setter) {
        return this.getVariableAccessorWithBuilder(name2, this.makeRawFieldAccessorBuilder(name2, unwrap, unwrapType, fieldType, getter, setter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VariableAccessor getVariableAccessorWithBuilder(String name2, Function<Integer, VariableAccessor> defaultAccessorBuilder) {
        VariableAccessor ivarAccessor = this.variableAccessors.get(name2);
        if (ivarAccessor == null) {
            RubyClass rubyClass = this.realClass;
            synchronized (rubyClass) {
                Map<String, VariableAccessor> myVariableAccessors = this.variableAccessors;
                ivarAccessor = myVariableAccessors.get(name2);
                if (ivarAccessor == null) {
                    ivarAccessor = this.allocateVariableAccessors(name2, defaultAccessorBuilder);
                    this.variableAccessors = VariableTableManager.copyVariableAccessors(myVariableAccessors, name2, ivarAccessor);
                }
            }
        }
        return ivarAccessor;
    }

    private static Map<String, VariableAccessor> copyVariableAccessors(Map<String, VariableAccessor> myVariableAccessors) {
        return new LinkedHashMap<String, VariableAccessor>(myVariableAccessors);
    }

    private static Map<String, VariableAccessor> copyVariableAccessors(Map<String, VariableAccessor> myVariableAccessors, String name2, VariableAccessor ivarAccessor) {
        LinkedHashMap<String, VariableAccessor> newVariableAccessors = new LinkedHashMap<String, VariableAccessor>(myVariableAccessors.size() + 1);
        newVariableAccessors.putAll(myVariableAccessors);
        newVariableAccessors.put(name2, ivarAccessor);
        return newVariableAccessors;
    }

    public VariableAccessor getVariableAccessorForRead(String name2) {
        VariableAccessor accessor = this.getVariableAccessorsForRead().get(name2);
        if (accessor == null) {
            accessor = VariableAccessor.DUMMY_ACCESSOR;
        }
        return accessor;
    }

    public VariableAccessor getObjectIdAccessorForRead() {
        return this.objectIdVariableAccessorField.getVariableAccessorForRead();
    }

    public VariableAccessor getObjectIdAccessorForWrite() {
        if (this.hasObjectID == 0) {
            this.hasObjectID = 1;
        }
        return this.objectIdVariableAccessorField.getVariableAccessorForWrite(this);
    }

    public VariableAccessor getFFIHandleAccessorForRead() {
        return this.ffiHandleVariableAccessorField.getVariableAccessorForRead();
    }

    public VariableAccessor getFFIHandleAccessorForWrite() {
        if (this.hasFFI == 0) {
            this.hasFFI = 1;
        }
        return this.ffiHandleVariableAccessorField.getVariableAccessorForWrite(this);
    }

    public VariableAccessor getObjectGroupAccessorForRead() {
        return this.objectGroupVariableAccessorField.getVariableAccessorForRead();
    }

    public VariableAccessor getObjectGroupAccessorForWrite() {
        if (this.hasObjectspaceGroup == 0) {
            this.hasObjectspaceGroup = 1;
        }
        return this.objectGroupVariableAccessorField.getVariableAccessorForWrite(this);
    }

    public final Object getFFIHandle(RubyBasicObject self2) {
        return this.getFFIHandleAccessorForRead().get(self2);
    }

    public final void setFFIHandle(RubyBasicObject self2, Object value2) {
        int index2 = this.getFFIHandleAccessorForWrite().getIndex();
        VariableTableManager.setVariableInternal(this.realClass, self2, index2, value2);
    }

    public int getVariableTableSize() {
        return this.variableAccessors.size();
    }

    public int getVariableTableSizeWithExtras() {
        return this.variableNames.length;
    }

    public Map<String, VariableAccessor> getVariableTableCopy() {
        return new LinkedHashMap<String, VariableAccessor>(this.getVariableAccessorsForRead());
    }

    public String[] getVariableNames() {
        return (String[])this.variableNames.clone();
    }

    public void syncVariables(RubyBasicObject self2, IRubyObject other) {
        boolean sameTable;
        RubyClass otherRealClass = other.getMetaClass().getRealClass();
        boolean bl = sameTable = otherRealClass == this.realClass;
        if (sameTable && this.fieldVariables == 0) {
            int oldStamp;
            int idIndex = otherRealClass.getVariableTableManager().getObjectIdAccessorForRead().getIndex();
            Object[] otherVars = ((RubyBasicObject)other).varTable;
            while (((oldStamp = self2.varTableStamp) & 1) == 1 || !VariableAccessor.STAMP_HANDLE.compareAndSet(self2, oldStamp++, oldStamp)) {
            }
            Object[] currentTable = VariableAccessor.VAR_TABLE_HANDLE.getVolatile(self2);
            Object[] newTable = VariableTableManager.makeSyncedTable(currentTable, otherVars, idIndex);
            VariableAccessor.VAR_TABLE_HANDLE.setRelease(self2, newTable);
            self2.varTableStamp = oldStamp + 1;
        } else {
            for (Map.Entry<String, VariableAccessor> entry : otherRealClass.getVariableAccessorsForRead().entrySet()) {
                VariableAccessor accessor = entry.getValue();
                Object value2 = accessor.get(other);
                if (value2 == null) continue;
                if (sameTable) {
                    accessor.set(self2, value2);
                    continue;
                }
                this.realClass.getVariableAccessorForWrite(accessor.getName()).set(self2, value2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasVariables(RubyBasicObject object) {
        if (this.fieldVariables > 0) return true;
        Object[] myVarTable = object.varTable;
        if (object.varTable == null) return false;
        if (myVarTable.length <= this.hasObjectID + this.hasFFI + this.hasObjectspaceGroup) return false;
        return true;
    }

    public boolean hasInstanceVariables(RubyBasicObject object) {
        if (this.fieldVariables > 0) {
            return true;
        }
        Object[] myVarTable = object.varTable;
        if (object.varTable != null && myVarTable.length > this.hasObjectID + this.hasFFI + this.hasObjectspaceGroup) {
            for (int i2 = 0; i2 < myVarTable.length; ++i2) {
                if (i2 == this.hasObjectID || i2 == this.hasFFI || i2 == this.hasObjectspaceGroup || myVarTable[i2] == null) continue;
                return true;
            }
        }
        return false;
    }

    public void serializeVariables(RubyBasicObject object, ObjectOutputStream oos) throws IOException {
        if (object.varTable != null) {
            Map<String, VariableAccessor> accessors = this.getVariableAccessorsForRead();
            oos.writeInt(accessors.size());
            for (VariableAccessor accessor : accessors.values()) {
                oos.writeUTF("Insecure: can't modify instance variable");
                oos.writeObject(accessor.get(object));
            }
        } else {
            oos.writeInt(0);
        }
    }

    public void deserializeVariables(RubyBasicObject object, ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int varCount = ois.readInt();
        for (int i2 = 0; i2 < varCount; ++i2) {
            String name2 = ois.readUTF();
            Object value2 = ois.readObject();
            this.getVariableAccessorForWrite(name2).set(object, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clearVariable(RubyBasicObject object, String name2) {
        RubyBasicObject rubyBasicObject = object;
        synchronized (rubyBasicObject) {
            Object value2 = this.getVariableAccessorForRead(name2).get(object);
            this.getVariableAccessorForWrite(name2).set(object, null);
            return value2;
        }
    }

    public VariableTableManager duplicateForData(RubyClass newRealClass) {
        return new VariableTableManager(this, newRealClass);
    }

    private long initObjectId(RubyBasicObject self2, VariableAccessor objectIdAccessor) {
        Ruby runtime2 = self2.getRuntime();
        long id = runtime2.isObjectSpaceEnabled() ? runtime2.getObjectSpace().createAndRegisterObjectId(self2) : ObjectSpace.calculateObjectId(self2);
        VariableTableManager.setObjectId(this.realClass, self2, objectIdAccessor.getIndex(), id);
        return id;
    }

    private static void setObjectId(RubyClass realClass, RubyBasicObject self2, int index2, long value2) {
        if (index2 < 0) {
            return;
        }
        VariableTableManager.setVariableInternal(realClass, self2, index2, VariableTableManager.smallestBox(value2));
    }

    private static Number smallestBox(long value2) {
        if (value2 >= -128L && value2 <= 127L) {
            return (byte)value2;
        }
        if (value2 >= -32768L && value2 <= 32767L) {
            return (short)value2;
        }
        if (value2 >= Integer.MIN_VALUE && value2 <= Integer.MAX_VALUE) {
            return (int)value2;
        }
        return value2;
    }

    private static Object[] makeSyncedTable(Object[] currentTable, Object[] otherTable, int objectIdIdx) {
        if (currentTable == null || currentTable.length < otherTable.length) {
            currentTable = (Object[])otherTable.clone();
        } else {
            ArraySupport.copy(otherTable, currentTable, 0, otherTable.length);
        }
        if (objectIdIdx >= 0 && objectIdIdx < currentTable.length) {
            currentTable[objectIdIdx] = null;
        }
        return currentTable;
    }

    final VariableAccessor allocateVariableAccessor(String name2) {
        return this.allocateVariableAccessors(name2, this.makeTableVariableAccessorBuilder(name2));
    }

    final Function<Integer, VariableAccessor> makeTableVariableAccessorBuilder(String name2) {
        return newIndex -> new StampedVariableAccessor(this.realClass, name2, (int)newIndex, this.realClass.id);
    }

    final Function<Integer, VariableAccessor> makeRawFieldAccessorBuilder(String name2, boolean unwrap, Class<?> unwrapType, Class<?> fieldType, MethodHandle getter, MethodHandle setter) {
        return newIndex -> {
            ++this.fieldVariables;
            return new RawFieldVariableAccessor(this.realClass, unwrap, unwrapType, fieldType, name2, (int)newIndex, this.realClass.id, getter, setter);
        };
    }

    final Function<Integer, VariableAccessor> makeRubyFieldAccessorBuilder(String name2, MethodHandle getter, MethodHandle setter) {
        return newIndex -> {
            ++this.fieldVariables;
            return new FieldVariableAccessor(this.realClass, name2, (int)newIndex, this.realClass.id, getter, setter);
        };
    }

    final synchronized VariableAccessor allocateVariableAccessors(String name2, Function<Integer, VariableAccessor> builder) {
        Object[] myVariableNames = this.variableNames;
        int newIndex = myVariableNames.length;
        VariableAccessor newVariableAccessor = builder.apply(newIndex);
        Object[] newVariableNames = new String[newIndex + 1];
        ArraySupport.copy(myVariableNames, 0, newVariableNames, 0, newIndex);
        newVariableNames[newIndex] = name2;
        this.variableNames = newVariableNames;
        return newVariableAccessor;
    }

    @Deprecated(since="9.4-")
    public VariableAccessorField getObjectIdAccessorField() {
        return this.objectIdVariableAccessorField;
    }

    @Deprecated(since="9.4-")
    public VariableAccessorField getFFIHandleAccessorField() {
        return this.ffiHandleVariableAccessorField;
    }

    @Deprecated(since="9.4-")
    public VariableAccessorField getObjectGroupAccessorField() {
        return this.objectGroupVariableAccessorField;
    }
}

