/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.AttributeName;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.LocalContextProvider;

public class LocalContext {
    private final RubyInstanceConfig config;
    private final LocalVariableBehavior behavior;
    private final boolean lazy;
    private Ruby runtime = null;
    private BiVariableMap varMap;
    private Map<AttributeName, Object> attributes;

    public LocalContext(RubyInstanceConfig config2, LocalVariableBehavior behavior) {
        this(config2, behavior, false);
    }

    public LocalContext(RubyInstanceConfig config2, LocalVariableBehavior behavior, boolean lazy) {
        this.config = config2;
        this.behavior = behavior;
        this.lazy = lazy;
    }

    @Deprecated(since="1.7.20")
    public Ruby getThreadSafeRuntime() {
        return this.getRuntime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BiVariableMap getVarMap(LocalContextProvider provider) {
        if (this.varMap == null) {
            LocalContext localContext = this;
            synchronized (localContext) {
                if (this.varMap == null) {
                    this.varMap = new BiVariableMap(provider, this.lazy);
                }
            }
        }
        return this.varMap;
    }

    public LocalVariableBehavior getLocalVariableBehavior() {
        return this.behavior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<?, Object> getAttributeMap() {
        if (this.attributes == null) {
            LocalContext localContext = this;
            synchronized (localContext) {
                if (this.attributes == null) {
                    this.attributes = new HashMap<AttributeName, Object>();
                    this.attributes.put(AttributeName.READER, new InputStreamReader(System.in));
                    this.attributes.put(AttributeName.WRITER, new PrintWriter(System.out, true));
                    this.attributes.put(AttributeName.ERROR_WRITER, new PrintWriter(System.err, true));
                }
            }
        }
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        LocalContext localContext;
        if (this.attributes != null) {
            localContext = this;
            synchronized (localContext) {
                this.attributes.clear();
            }
        }
        if (this.varMap != null) {
            localContext = this;
            synchronized (localContext) {
                this.varMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Ruby getRuntime() {
        if (this.runtime == null) {
            LocalContext localContext = this;
            synchronized (localContext) {
                if (this.runtime == null) {
                    this.runtime = Ruby.newInstance(this.config);
                }
            }
        }
        return this.runtime;
    }

    boolean isInitialized() {
        return this.runtime != null;
    }
}

