/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jruby.anno.MethodDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;

public class JavaMethodDescriptor
extends MethodDescriptor<Method> {
    public final Class[] parameters;
    public final Class returnClass;
    public final Class declaringClass;
    @Deprecated(since="9.2.0.0")
    public String signature;
    @Deprecated(since="9.2.0.0")
    public Class[] argumentTypes;

    public JavaMethodDescriptor(Method method2) {
        super(method2);
        this.declaringClass = method2.getDeclaringClass();
        this.parameters = method2.getParameterTypes();
        this.returnClass = method2.getReturnType();
    }

    public final Class[] getArgumentTypes() {
        if (this.argumentTypes == null) {
            int start2 = (this.hasContext ? 1 : 0) + (this.isStatic ? 1 : 0);
            int end2 = this.parameters.length - (this.hasBlock ? 1 : 0);
            Class[] argumentTypes = new Class[end2 - start2];
            System.arraycopy(this.parameters, start2, argumentTypes, 0, end2 - start2);
            this.argumentTypes = argumentTypes;
            return argumentTypes;
        }
        return this.argumentTypes;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public Class[] getParameterClasses() {
        return this.parameters;
    }

    public Class getReturnClass() {
        return this.returnClass;
    }

    @Override
    protected <A extends Annotation> A getAnnotation(Method methodObject, Class<A> annotationType) {
        return methodObject.getAnnotation(annotationType);
    }

    @Override
    protected int getModifiers(Method methodObject) {
        return methodObject.getModifiers();
    }

    @Override
    protected String getDeclaringClassName(Method methodObject) {
        return methodObject.getDeclaringClass().getName();
    }

    @Override
    protected String getSimpleName(Method methodObject) {
        return methodObject.getName();
    }

    @Override
    protected boolean hasContext(Method methodObject) {
        Class<?>[] parameters2 = methodObject.getParameterTypes();
        if (parameters2.length > 0) {
            return parameters2[0] == ThreadContext.class;
        }
        return false;
    }

    @Override
    protected boolean hasBlock(Method methodObject) {
        Class<?>[] parameters2 = methodObject.getParameterTypes();
        if (parameters2.length > 0) {
            return parameters2[parameters2.length - 1] == Block.class;
        }
        return false;
    }

    @Override
    protected int parameterCount(Method methodObject) {
        return methodObject.getParameterTypes().length;
    }

    @Override
    protected String parameterAsString(Method methodObject, int index2) {
        return methodObject.getParameterTypes()[index2].getName();
    }
}

