/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.JavaUtilities;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaInterfaceTemplate {
    public static RubyModule createJavaInterfaceTemplateModule(ThreadContext context) {
        return Define.defineModule(context, "JavaInterfaceTemplate").defineMethods(context, JavaProxy.ClassMethods.class).tap(m -> m.singletonClass(context).defineMethods(context, JavaInterfaceTemplate.class));
    }

    @JRubyMethod
    public static IRubyObject java_class(IRubyObject self2) {
        return JavaProxy.getJavaClass((RubyModule)self2);
    }

    @Deprecated(since="9.1.0.0")
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public static IRubyObject implement(ThreadContext context, IRubyObject self2, IRubyObject clazz) {
        RubyModule targetModule = Convert.castAsModule(context, self2);
        IRubyObject javaClass = JavaProxy.getJavaClass((RubyModule)self2);
        Class klass = (Class)JavaUtil.unwrapJavaObject(javaClass);
        Method[] javaInstanceMethods = klass.getMethods();
        DummyMethodImpl dummyMethodImpl = new DummyMethodImpl(targetModule);
        for (int i2 = 0; i2 < javaInstanceMethods.length; ++i2) {
            Method javaMethod = javaInstanceMethods[i2];
            String name2 = javaMethod.getName();
            if (!targetModule.searchMethod(name2).isUndefined()) continue;
            targetModule.addMethod(context, name2, dummyMethodImpl);
        }
        return context.nil;
    }

    @JRubyMethod(frame=true)
    public static IRubyObject append_features(ThreadContext context, IRubyObject self2, IRubyObject clazz, Block block) {
        if (clazz instanceof RubyClass) {
            JavaInterfaceTemplate.appendFeaturesToClass(context, self2, (RubyClass)clazz);
        } else if (clazz instanceof RubyModule) {
            RubyModule mod = (RubyModule)clazz;
            JavaInterfaceTemplate.appendFeaturesToModule(context, self2, mod);
        } else {
            throw Error.typeError(context, "received ", clazz, ", expected Class/Module");
        }
        return Helpers.invokeSuper(context, self2, clazz, block);
    }

    private static void appendFeaturesToClass(ThreadContext context, IRubyObject self2, RubyClass clazz) {
        JavaInterfaceTemplate.checkAlreadyReified(context, clazz);
        IRubyObject javaClass = JavaProxy.getJavaClass((RubyModule)self2);
        if (!clazz.hasInstanceVariable("@java_interfaces")) {
            RubyArray<?> javaInterfaces = Create.newArray(context, javaClass);
            clazz.setInstanceVariable("@java_interfaces", javaInterfaces);
            JavaInterfaceTemplate.initInterfaceImplMethods(context, clazz);
        } else {
            RubyArray javaInterfaces = (RubyArray)clazz.getInstanceVariable("@java_interfaces");
            if (!javaInterfaces.isFrozen() && !javaInterfaces.includes(context, javaClass)) {
                javaInterfaces.append(context, javaClass);
            }
        }
    }

    private static void checkAlreadyReified(ThreadContext context, RubyClass clazz) throws RaiseException {
        if (Java.NEW_STYLE_EXTENSION && clazz.reifiedClass() != null || clazz.hasInstanceVariable("@java_class") && clazz.getInstanceVariable("@java_class").isTrue() && !clazz.singletonClass(context).isMethodBound("java_proxy_class", false) || clazz.hasInstanceVariable("@java_proxy_class") && clazz.getInstanceVariable("@java_proxy_class").isTrue()) {
            throw Error.argumentError(context, "can not add Java interface to existing Java class");
        }
    }

    private static void initInterfaceImplMethods(ThreadContext context, RubyClass clazz) {
        RubyClass singleton;
        if (!clazz.isMethodBound("__jcreate!", false) && !clazz.isMethodBound("__jcreate_meta!", false)) {
            singleton = clazz.singletonClass(context);
            singleton.addReadAttribute(context, "java_interfaces");
            if (!Java.NEW_STYLE_EXTENSION && JavaProxy.getJavaClass(clazz.getSuperClass().getRealClass()) != null || RubyInstanceConfig.INTERFACES_USE_PROXY) {
                ObjectAllocator proxyAllocator = clazz.getAllocator();
                clazz.allocator((runtime2, klazz) -> {
                    IRubyObject newObj = proxyAllocator.allocate(runtime2, klazz);
                    Helpers.invoke(runtime2.getCurrentContext(), newObj, "__jcreate!");
                    return newObj;
                });
                clazz.addMethod(context, "__jcreate!", new InterfaceProxyFactory(clazz, "__jcreate!"));
            } else {
                JavaInterfaceTemplate.addRealImplClassNew(clazz);
            }
            clazz.addMethod(context, "__jcreate_meta!", new InterfaceProxyFactory(clazz, "__jcreate_meta!"));
            clazz.addMethod(context, "java_class", new JavaClassAccessor(clazz));
        }
        if (!clazz.isMethodBound("implement", false)) {
            singleton = clazz.singletonClass(context);
            singleton.addMethod(context, "implement", new JavaMethod.JavaMethodOne((RubyModule)clazz, Visibility.PRIVATE, "implement"){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject iface) {
                    RubyArray ifaces = JavaInterfaceTemplate.getJavaInterfaces(self2);
                    if (ifaces != null && ifaces.includes(context, iface)) {
                        return Helpers.invoke(context, iface, "implement", self2);
                    }
                    return context.nil;
                }
            });
            singleton.addMethod(context, "implement_all", new JavaMethod.JavaMethodOne((RubyModule)clazz, Visibility.PRIVATE, "implement_all"){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2) {
                    RubyArray ifaces = JavaInterfaceTemplate.getJavaInterfaces(self2);
                    if (ifaces == null) {
                        return context.nil;
                    }
                    for (int i2 = 0; i2 < ifaces.size(); ++i2) {
                        RubyModule iface = Java.get_interface_module(context, ifaces.eltInternal(i2));
                        Helpers.invoke(context, (IRubyObject)iface, "implement", self2);
                    }
                    return ifaces;
                }
            });
        }
    }

    public static void addRealImplClassNew(RubyClass clazz) {
        clazz.allocator(new ObjectAllocator(){
            private Constructor<? extends IRubyObject> proxyConstructor;

            @Override
            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                Class reifiedClass = klazz.getReifiedRubyClass();
                if (this.proxyConstructor == null || this.proxyConstructor.getDeclaringClass() != reifiedClass) {
                    if (reifiedClass == null) {
                        reifiedClass = Java.generateRealClass(klazz);
                    }
                    this.proxyConstructor = Java.getRealClassConstructor(runtime2, reifiedClass);
                }
                IRubyObject newObj = Java.constructProxy(runtime2, this.proxyConstructor, klazz);
                return newObj;
            }
        });
    }

    private static IRubyObject newInterfaceProxy(ThreadContext context, IRubyObject self2) {
        RubyClass current2 = self2.getMetaClass();
        Object impl2 = Java.newInterfaceImpl(context, self2, Java.getInterfacesFromRubyClass(current2));
        IRubyObject implWrapper = Java.getInstance(context.runtime, impl2);
        JavaUtilities.set_java_object(self2, self2, implWrapper);
        return implWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendFeaturesToModule(ThreadContext context, IRubyObject self2, RubyModule module) {
        IRubyObject java_class2 = module.getInstanceVariables().getInstanceVariable("@java_class");
        if (java_class2 != null && java_class2.isTrue()) {
            throw Error.typeError(context, "can not add Java interface to existing Java interface");
        }
        RubyModule rubyModule = module;
        synchronized (rubyModule) {
            if (JavaInterfaceTemplate.initInterfaceModules(context, self2, module)) {
                RubyClass singleton = module.singletonClass(context);
                singleton.addMethod(context, "append_features", new AppendFeatures(singleton));
            } else {
                RubyArray interfaceModules = JavaInterfaceTemplate.getInterfaceModules(module);
                if (!interfaceModules.includes(context, self2)) {
                    interfaceModules.append(context, self2);
                }
            }
        }
    }

    @JRubyMethod
    public static IRubyObject extended(ThreadContext context, IRubyObject self2, IRubyObject object) {
        RubyClass singleton = object.singletonClass(context);
        singleton.include(context, self2);
        return singleton;
    }

    @JRubyMethod(name={"[]"}, rest=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return JavaProxy.op_aref(context, self2, args2);
    }

    @JRubyMethod(name={"impl"}, rest=true)
    public static IRubyObject impl(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block implBlock) {
        Object[] methodNames;
        if (!implBlock.isGiven()) {
            throw Error.argumentError(context, "block required to call #impl on a Java interface");
        }
        boolean allMethods = true;
        if (args2.length == 0) {
            methodNames = null;
        } else if (args2.length == 1 && args2[0] instanceof RubyBoolean) {
            allMethods = args2[0].isTrue();
            methodNames = null;
        } else {
            methodNames = (IRubyObject[])args2.clone();
            Arrays.sort(methodNames);
        }
        RubyClass implClass = RubyClass.newClass(context, Access.objectClass(context), null);
        implClass.include(context, self2);
        BlockInterfaceImpl ifaceImpl = new BlockInterfaceImpl(implClass, implBlock, (IRubyObject[])methodNames);
        implClass.addMethod(context, "method_missing", ifaceImpl);
        Class<?> ifaceClass = JavaUtil.getJavaClass(context, (RubyModule)self2);
        if (methodNames == null) {
            for (Method method2 : ifaceClass.getMethods()) {
                BlockInterfaceImpl.ConcreteMethod implMethod = ifaceImpl.getConcreteMethod(method2.getName());
                if (method2.isBridge() || method2.isSynthetic() || Modifier.isStatic(method2.getModifiers()) || !allMethods && !Modifier.isAbstract(method2.getModifiers())) continue;
                implClass.addMethodInternal(context, method2.getName(), implMethod);
            }
        } else {
            Method[] decMethods = ifaceClass.getDeclaredMethods();
            block1: for (Object methodName : methodNames) {
                String name2 = methodName.toString();
                BlockInterfaceImpl.ConcreteMethod implMethod = ifaceImpl.getConcreteMethod(name2);
                for (int i2 = 0; i2 < decMethods.length; ++i2) {
                    Method method3 = decMethods[i2];
                    if (method3.isBridge() || method3.isSynthetic() || Modifier.isStatic(method3.getModifiers()) || !name2.equals(decMethods[i2].getName())) continue;
                    implClass.addMethodInternal(context, name2, implMethod);
                    continue block1;
                }
                Warn.warn(context, "'" + name2 + "' is not a declared method in interface " + ifaceClass.getName());
            }
        }
        return implClass.callMethod(context, "new");
    }

    private static RubyArray getJavaInterfaces(IRubyObject clazz) {
        return (RubyArray)clazz.getInstanceVariables().getInstanceVariable("@java_interfaces");
    }

    private static RubyArray getInterfaceModules(IRubyObject module) {
        return (RubyArray)module.getInstanceVariables().getInstanceVariable("@java_interface_mods");
    }

    private static boolean initInterfaceModules(ThreadContext context, IRubyObject self2, IRubyObject module) {
        if (!module.getInstanceVariables().hasInstanceVariable("@java_interface_mods")) {
            RubyArray<?> interfaceMods = Create.newArray(context, self2);
            module.getInstanceVariables().setInstanceVariable("@java_interface_mods", interfaceMods);
            return true;
        }
        return false;
    }

    private static class DummyMethodImpl
    extends JavaMethod {
        DummyMethodImpl(RubyModule targetModule) {
            super(targetModule, Visibility.PUBLIC, "");
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return context.nil;
        }
    }

    private static final class InterfaceProxyFactory
    extends JavaMethod.JavaMethodN {
        InterfaceProxyFactory(RubyClass clazz, String name2) {
            super((RubyModule)clazz, Visibility.PRIVATE, name2);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
            return JavaInterfaceTemplate.newInterfaceProxy(context, self2);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
            return JavaInterfaceTemplate.newInterfaceProxy(context, self2);
        }
    }

    private static class JavaClassAccessor
    extends JavaMethod.JavaMethodZero {
        JavaClassAccessor(RubyClass klass) {
            super((RubyModule)klass, Visibility.PUBLIC, "java_class");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            Object wrapped = self2.dataGetStruct();
            Class<?> javaClass = wrapped instanceof JavaProxy ? ((JavaProxy)wrapped).getJavaClass() : self2.getClass();
            return Java.getInstance(context.runtime, javaClass);
        }
    }

    private static class AppendFeatures
    extends JavaMethod.JavaMethodOneBlock {
        AppendFeatures(RubyModule singletonClass) {
            super(singletonClass, Visibility.PUBLIC, "append_features");
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2, Block block) {
            RubyModule target2 = Convert.castAsModule(context, arg2, "append_features called with non-module");
            target2.include(context, JavaInterfaceTemplate.getInterfaceModules(self2).toJavaArrayMaybeUnsafe());
            return Helpers.invokeAs(context, clazz.getSuperClass(), self2, name2, arg2, block);
        }
    }

    private static final class BlockInterfaceImpl
    extends JavaMethod {
        private final IRubyObject[] methodNames;
        private final Block implBlock;

        BlockInterfaceImpl(RubyClass implClass, Block implBlock, IRubyObject[] methodNames) {
            super((RubyModule)implClass, Visibility.PUBLIC, "method_missing");
            this.implBlock = implBlock;
            this.methodNames = methodNames;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            Arity.checkArgumentCount(context, name2, args2.length, 1, -1);
            return this.callImpl(context, clazz, block, args2);
        }

        private IRubyObject callImpl(ThreadContext context, RubyModule clazz, Block block, IRubyObject ... args2) {
            if (this.methodNames == null) {
                return this.implBlock.call(context, args2);
            }
            if (this.methodNames.length == 1 ? this.methodNames[0].equals(args2[0]) : Arrays.binarySearch(this.methodNames, args2[0]) >= 0) {
                return this.implBlock.call(context, args2);
            }
            return clazz.getSuperClass().callMethod(context, "method_missing", args2, block);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, Block block) {
            return this.callImpl(context, klazz, block, new IRubyObject[0]);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, Block block) {
            return this.callImpl(context, klazz, block, arg0);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return this.callImpl(context, klazz, block, arg0, arg1);
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return this.callImpl(context, klazz, block, arg0, arg1, arg2);
        }

        @Override
        public DynamicMethod dup() {
            return this;
        }

        final ConcreteMethod getConcreteMethod(String name2) {
            return new ConcreteMethod(name2);
        }

        private final class ConcreteMethod
        extends JavaMethod {
            ConcreteMethod(String name2) {
                super(BlockInterfaceImpl.this.implementationClass, Visibility.PUBLIC, name2);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, Block block) {
                return BlockInterfaceImpl.this.callImpl(context, klazz, block, Convert.asSymbol(context, name2));
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, Block block) {
                return BlockInterfaceImpl.this.callImpl(context, klazz, block, Convert.asSymbol(context, name2), arg0);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
                return BlockInterfaceImpl.this.callImpl(context, klazz, block, Convert.asSymbol(context, name2), arg0, arg1);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
                return BlockInterfaceImpl.this.callImpl(context, klazz, block, Convert.asSymbol(context, name2), arg0, arg1, arg2);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klazz, String name2, IRubyObject[] args2, Block block) {
                return switch (args2.length) {
                    case 0 -> this.call(context, self2, klazz, name2, block);
                    case 1 -> this.call(context, self2, klazz, name2, args2[0], block);
                    case 2 -> this.call(context, self2, klazz, name2, args2[0], args2[1], block);
                    case 3 -> this.call(context, self2, klazz, name2, args2[0], args2[1], args2[2], block);
                    default -> {
                        IRubyObject[] nargs = new IRubyObject[args2.length + 1];
                        nargs[0] = Convert.asSymbol(context, name2);
                        System.arraycopy(args2, 0, nargs, 1, args2.length);
                        yield BlockInterfaceImpl.this.callImpl(context, klazz, block, nargs);
                    }
                };
            }
        }
    }
}

