/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import org.jcodings.Encoding;
import org.jcodings.transcode.EConv;
import org.joda.time.DateTime;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.ext.zlib.JZlibRubyGzipReader;
import org.jruby.ext.zlib.JZlibRubyGzipWriter;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.IOEncodable;

@JRubyClass(name={"Zlib::GzipFile"})
public class RubyGzipFile
extends RubyObject
implements IOEncodable {
    protected boolean closed = false;
    protected boolean finished = false;
    protected boolean hasBOM;
    protected final byte osCode = (byte)-1;
    protected int level = -1;
    protected RubyString nullFreeOrigName;
    protected RubyString nullFreeComment;
    protected IRubyObject realIo;
    protected RubyTime mtime;
    protected Encoding enc;
    protected Encoding enc2;
    protected int ecflags;
    protected IRubyObject ecopts;
    protected EConv ec;
    protected boolean sync = false;
    protected EConv readTranscoder = null;
    protected EConv writeTranscoder = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IRubyObject wrapBlock(ThreadContext context, RubyGzipFile instance, Block block) {
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, instance);
                return iRubyObject;
            }
            finally {
                if (!instance.isClosed()) {
                    instance.close();
                }
            }
        }
        return instance;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject wrap(ThreadContext context, IRubyObject recv2, IRubyObject io2, Block block) {
        return RubyGzipFile.wrap(context, recv2, new IRubyObject[]{io2}, block);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject wrap19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyGzipFile.wrap(context, recv2, args2, block);
    }

    @JRubyMethod(meta=true, name={"wrap"}, required=1, optional=1, checkArity=false)
    public static IRubyObject wrap(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyGzipFile instance = ((RubyModule)recv2).isKindOfModule(Access.getClass(context, "Zlib", "GzipWriter")) ? JZlibRubyGzipWriter.newInstance(context, (RubyClass)recv2, args2) : JZlibRubyGzipReader.newInstance(context, (RubyClass)recv2, args2);
        return RubyGzipFile.wrapBlock(context, instance, block);
    }

    @Deprecated(since="10.0.0.0")
    public static RubyGzipFile newInstance(IRubyObject recv2, Block block) {
        return RubyGzipFile.newInstance(((RubyBasicObject)recv2).getCurrentContext(), recv2, block);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static RubyGzipFile newInstance(ThreadContext context, IRubyObject recv2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        RubyGzipFile result2 = (RubyGzipFile)klass.allocate(context);
        result2.callInit(IRubyObject.NULL_ARRAY, block);
        return result2;
    }

    @JRubyMethod
    public IRubyObject path(ThreadContext context) {
        return this.realIo.callMethod(context, "path");
    }

    @JRubyMethod(name={"respond_to?"}, frame=true)
    public IRubyObject respond_to(ThreadContext context, IRubyObject name2) {
        if (name2.asJavaString().equals("path")) {
            return RubyGzipFile.sites((ThreadContext)context).reader_respond_to.call(context, (IRubyObject)this, this.realIo, name2);
        }
        return Helpers.invokeSuper(context, (IRubyObject)this, name2, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"respond_to?"}, frame=true)
    public IRubyObject respond_to(ThreadContext context, IRubyObject name2, IRubyObject includePrivate) {
        if (name2.asJavaString().equals("path")) {
            return RubyGzipFile.sites((ThreadContext)context).reader_respond_to.call(context, (IRubyObject)this, this.realIo, name2, includePrivate);
        }
        return Helpers.invokeSuper(context, (IRubyObject)this, name2, Block.NULL_BLOCK);
    }

    public RubyGzipFile(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
        this.mtime = RubyTime.newTime(runtime2, new DateTime());
        this.enc = null;
        this.enc2 = null;
    }

    protected void ecopts(ThreadContext context, IRubyObject opts) {
        if (!opts.isNil()) {
            EncodingUtils.ioExtractEncodingOption(context, this, opts, null);
        }
        if (this.enc2 != null) {
            IRubyObject[] outOpts = new IRubyObject[]{opts};
            this.ecflags = EncodingUtils.econvPrepareOpts(context, opts, outOpts);
            this.ec = EncodingUtils.econvOpenOpts(context, this.enc.getName(), this.enc2.getName(), this.ecflags, opts);
            this.ecopts = opts;
        }
    }

    @Deprecated(since="10.0.0.0")
    public Encoding getReadEncoding() {
        return this.getReadEncoding(this.getCurrentContext());
    }

    public Encoding getReadEncoding(ThreadContext context) {
        return this.enc == null ? context.runtime.getDefaultExternalEncoding() : this.enc;
    }

    @Override
    public Encoding getEnc() {
        return this.enc;
    }

    public Encoding getInternalEncoding() {
        return this.enc2 == null ? this.getEnc() : this.enc2;
    }

    @Override
    public Encoding getEnc2() {
        return this.enc2;
    }

    @Deprecated(since="10.0.0.0")
    protected RubyString newStr(Ruby runtime2, ByteList value2) {
        return this.newStr(runtime2.getCurrentContext(), value2);
    }

    protected RubyString newStr(ThreadContext context, ByteList value2) {
        if (this.enc2 == null) {
            return Create.newString(context, value2, this.getReadEncoding(context));
        }
        return this.ec != null && this.enc2.isDummy() ? Create.newString(context, EncodingUtils.econvStrConvert(context, this.ec, value2, 0), this.getEnc()) : EncodingUtils.strConvEncOpts(context, Create.newString(context, value2), this.enc2, this.enc, this.ecflags, this.ecopts);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject os_code() {
        return this.os_code(this.getCurrentContext());
    }

    @JRubyMethod(name={"os_code"})
    public IRubyObject os_code(ThreadContext context) {
        return Convert.asFixnum(context, 255);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject closed_p() {
        return this.closed_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p(ThreadContext context) {
        return this.closed ? context.tru : context.fals;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject orig_name() {
        return this.orig_name(this.getCurrentContext());
    }

    @JRubyMethod(name={"orig_name"})
    public IRubyObject orig_name(ThreadContext context) {
        if (this.closed) {
            throw RubyZlib.newGzipFileError(context, "closed gzip stream");
        }
        return this.nullFreeOrigName == null ? context.nil : this.nullFreeOrigName;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject to_io() {
        return this.to_io(this.getCurrentContext());
    }

    @JRubyMethod(name={"to_io"})
    public IRubyObject to_io(ThreadContext context) {
        return this.realIo;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject comment() {
        return this.comment(this.getCurrentContext());
    }

    @JRubyMethod(name={"comment"})
    public IRubyObject comment(ThreadContext context) {
        if (this.closed) {
            throw RubyZlib.newGzipFileError(context, "closed gzip stream");
        }
        return this.nullFreeComment == null ? context.nil : this.nullFreeComment;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject crc() {
        return this.crc(this.getCurrentContext());
    }

    @JRubyMethod(name={"crc"})
    public IRubyObject crc(ThreadContext context) {
        return Convert.asFixnum(context, 0);
    }

    @JRubyMethod(name={"mtime"})
    public IRubyObject mtime() {
        return this.mtime;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject sync() {
        return this.sync(this.getCurrentContext());
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync(ThreadContext context) {
        return this.sync ? context.tru : context.fals;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject finish() {
        return this.finish(this.getCurrentContext());
    }

    @JRubyMethod(name={"finish"})
    public IRubyObject finish(ThreadContext context) {
        if (!this.finished) {
            // empty if block
        }
        this.finished = true;
        return this.realIo;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject close() {
        return this.close(this.getCurrentContext());
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close(ThreadContext context) {
        return this.realIo;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject level() {
        return this.level(this.getCurrentContext());
    }

    @JRubyMethod(name={"level"})
    public IRubyObject level(ThreadContext context) {
        return Convert.asFixnum(context, this.level);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject set_sync(IRubyObject arg2) {
        return this.set_sync(this.getCurrentContext(), arg2);
    }

    @JRubyMethod(name={"sync="})
    public IRubyObject set_sync(ThreadContext context, IRubyObject arg2) {
        this.sync = arg2.isTrue();
        return this.sync ? context.tru : context.fals;
    }

    @Override
    public void setEnc(Encoding readEncoding) {
        this.enc = readEncoding;
    }

    @Override
    public void setEnc2(Encoding writeEncoding) {
        this.enc2 = writeEncoding;
    }

    @Override
    public void setEcflags(int ecflags) {
        this.ecflags = ecflags;
    }

    @Override
    public int getEcflags() {
        return this.ecflags;
    }

    @Override
    public void setEcopts(IRubyObject ecopts) {
        this.ecopts = ecopts;
    }

    @Override
    public IRubyObject getEcopts() {
        return this.ecopts;
    }

    @Override
    public void setBOM(boolean bom) {
        this.hasBOM = bom;
    }

    @Override
    public boolean getBOM() {
        return this.hasBOM;
    }

    private static JavaSites.ZlibSites sites(ThreadContext context) {
        return context.sites.Zlib;
    }

    @JRubyClass(name={"Zlib::GzipFile::LengthError"}, parent="Zlib::GzipFile::Error")
    public static class LengthError
    extends Error {
    }

    @JRubyClass(name={"Zlib::GzipFile::NoFooter"}, parent="Zlib::GzipFile::Error")
    public static class NoFooter
    extends Error {
    }

    @JRubyClass(name={"Zlib::GzipFile::CRCError"}, parent="Zlib::GzipFile::Error")
    public static class CRCError
    extends Error {
    }

    @JRubyClass(name={"Zlib::GzipFile::Error"}, parent="Zlib::Error")
    public static class Error {
    }
}

