/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.PropertyName;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.LocalContextProvider;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.URLUtil;

public class SystemPropertyCatcher {
    public static LocalContextScope getScope(LocalContextScope defaultScope) {
        LocalContextScope scope = defaultScope;
        String s2 = SafePropertyAccessor.getProperty(PropertyName.LOCALCONTEXT_SCOPE.toString());
        if (s2 == null) {
            return scope;
        }
        if ("singlethread".equalsIgnoreCase(s2)) {
            return LocalContextScope.SINGLETHREAD;
        }
        if ("singleton".equalsIgnoreCase(s2)) {
            return LocalContextScope.SINGLETON;
        }
        if ("threadsafe".equalsIgnoreCase(s2)) {
            return LocalContextScope.THREADSAFE;
        }
        if ("concurrent".equalsIgnoreCase(s2)) {
            return LocalContextScope.CONCURRENT;
        }
        return scope;
    }

    public static LocalVariableBehavior getBehavior(LocalVariableBehavior defaultBehavior) {
        LocalVariableBehavior behavior = defaultBehavior;
        String s2 = SafePropertyAccessor.getProperty(PropertyName.LOCALVARIABLE_BEHAVIOR.toString());
        if (s2 == null) {
            return behavior;
        }
        if ("global".equalsIgnoreCase(s2)) {
            return LocalVariableBehavior.GLOBAL;
        }
        if ("persistent".equalsIgnoreCase(s2)) {
            return LocalVariableBehavior.PERSISTENT;
        }
        if ("transient".equalsIgnoreCase(s2)) {
            return LocalVariableBehavior.TRANSIENT;
        }
        if ("bsf".equalsIgnoreCase(s2)) {
            return LocalVariableBehavior.BSF;
        }
        return behavior;
    }

    public static boolean isLazy(boolean defaultLaziness) {
        boolean lazy = defaultLaziness;
        String s2 = SafePropertyAccessor.getProperty(PropertyName.LAZINESS.toString());
        if (s2 == null) {
            return lazy;
        }
        return Boolean.parseBoolean(s2);
    }

    public static void setClassLoader(ScriptingContainer container) {
        String loader = SafePropertyAccessor.getProperty(PropertyName.CLASSLOADER.toString());
        if (loader == null || "container".equals(loader) || "current".equals(loader)) {
            container.setClassLoader(container.getClass().getClassLoader());
            return;
        }
        if ("context".equals(loader)) {
            container.setClassLoader(Thread.currentThread().getContextClassLoader());
            return;
        }
        if ("none".equals(loader)) {
            return;
        }
    }

    public static void setConfiguration(ScriptingContainer container) {
        LocalContextProvider provider = container.getProvider();
        RubyInstanceConfig config2 = provider.getRubyInstanceConfig();
        String mode2 = SafePropertyAccessor.getProperty(PropertyName.COMPILEMODE.toString());
        if (mode2 != null) {
            if ("jit".equalsIgnoreCase(mode2)) {
                config2.setCompileMode(RubyInstanceConfig.CompileMode.JIT);
            } else if ("force".equalsIgnoreCase(mode2)) {
                config2.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
            } else {
                config2.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
            }
        }
    }

    @Deprecated(since="1.5.0")
    public static void setJRubyHome(ScriptingContainer container) {
        String jrubyhome = SystemPropertyCatcher.findJRubyHome(container);
        if (jrubyhome != null) {
            container.getProvider().getRubyInstanceConfig().setJRubyHome(jrubyhome);
        }
    }

    @Deprecated(since="9.0.3.0")
    public static String findJRubyHome(Object instance) {
        String jrubyhome = SafePropertyAccessor.getenv("JRUBY_HOME");
        if (jrubyhome != null) {
            return jrubyhome;
        }
        jrubyhome = SafePropertyAccessor.getProperty("jruby.home");
        if (jrubyhome != null) {
            return jrubyhome;
        }
        return "uri:classloader://META-INF/jruby.home";
    }

    @Deprecated(since="9.0.3.0")
    public static String findFromJar(Object instance) {
        String location;
        URL resource = instance.getClass().getResource("/META-INF/jruby.home");
        if (resource == null && (resource = instance.getClass().getResource("/META-INF/jruby.home/bin/jrubyc")) == null) {
            return null;
        }
        if (resource.getProtocol().equals("jar")) {
            location = URLUtil.getPath(resource);
            if (!location.startsWith("file:")) {
                location = "classpath:/META-INF/jruby.home";
            }
            if (location.startsWith("file:") && location.contains(" ")) {
                location = location.replaceAll(" ", "%20");
            }
        } else {
            location = "classpath:/META-INF/jruby.home";
        }
        if (location.endsWith("/")) {
            location = location.substring(0, location.length() - 1);
        }
        return location;
    }

    @Deprecated(since="9.0.3.0")
    public static List<String> findLoadPaths() {
        String paths = SafePropertyAccessor.getProperty(PropertyName.CLASSPATH.toString());
        ArrayList<String> loadPaths = new ArrayList<String>();
        if (paths == null) {
            paths = SafePropertyAccessor.getProperty("java.class.path");
        }
        if (paths == null) {
            return loadPaths;
        }
        String[] possiblePaths = paths.split(File.pathSeparator);
        String[] prefixes = new String[]{"file", "url"};
        for (int i2 = 0; i2 < possiblePaths.length; ++i2) {
            int startIndex = i2;
            for (int j = 0; j < prefixes.length; ++j) {
                if (!prefixes[j].equals(possiblePaths[i2]) || i2 >= possiblePaths.length - 1) continue;
                loadPaths.add(possiblePaths[i2] + ":" + possiblePaths[++i2]);
                break;
            }
            if (startIndex != i2) continue;
            loadPaths.add(possiblePaths[i2]);
        }
        return loadPaths;
    }

    private static boolean matches(String name2, String pattern) {
        Matcher matcher = Pattern.compile(pattern).matcher(name2);
        return matcher.matches();
    }

    public static String getBaseDir() {
        String baseDir = SafePropertyAccessor.getenv("PWD");
        if (baseDir == null || "/".equals(baseDir)) {
            baseDir = SafePropertyAccessor.getProperty("user.dir");
        }
        return baseDir;
    }
}

