/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Collections;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.WeakHashSet;

@JRubyClass(name={"ThreadGroup"})
public class RubyThreadGroup
extends RubyObject {
    private final Set<RubyThread> rubyThreadList = Collections.synchronizedSet(new WeakHashSet());
    private boolean enclosed = false;

    public static RubyClass createThreadGroupClass(ThreadContext context, RubyClass Object2) {
        RubyClass ThreadGroup2 = (RubyClass)((RubyModule)Define.defineClass(context, "ThreadGroup", Object2, RubyThreadGroup::new).classIndex(ClassIndex.THREADGROUP)).defineMethods(context, RubyThreadGroup.class);
        RubyThreadGroup defaultThreadGroup = new RubyThreadGroup(context.runtime, ThreadGroup2);
        context.runtime.setDefaultThreadGroup(defaultThreadGroup);
        ThreadGroup2.defineConstant(context, "Default", defaultThreadGroup);
        return ThreadGroup2;
    }

    @JRubyMethod(name={"add"})
    public IRubyObject add(ThreadContext context, IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw Error.typeError(context, rubyThread, "Thread");
        }
        RubyThread thread2 = (RubyThread)rubyThread;
        if (this.isFrozen()) {
            throw Error.typeError(context, "can't add to the frozen thread group");
        }
        if (this.enclosed) {
            throw Error.typeError(context, "can't move to the enclosed thread group");
        }
        RubyThreadGroup threadGroup = thread2.getThreadGroup();
        if (threadGroup != null) {
            if (threadGroup.isFrozen()) {
                throw Error.typeError(context, "can't move from the frozen thread group");
            }
            if (threadGroup.enclosed_p(block).isTrue()) {
                throw Error.typeError(context, "can't move from the enclosed thread group");
            }
        }
        if (thread2.isAlive()) {
            this.addDirectly(thread2);
        } else {
            thread2.setThreadGroup(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDirectly(RubyThread rubyThread) {
        RubyThread rubyThread2 = rubyThread;
        synchronized (rubyThread2) {
            IRubyObject oldGroup = rubyThread.group();
            if (!oldGroup.isNil()) {
                RubyThreadGroup threadGroup = (RubyThreadGroup)oldGroup;
                threadGroup.rubyThreadList.remove(rubyThread);
            }
            rubyThread.setThreadGroup(this);
            this.rubyThreadList.add(rubyThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(RubyThread rubyThread) {
        RubyThread rubyThread2 = rubyThread;
        synchronized (rubyThread2) {
            this.rubyThreadList.remove(rubyThread);
        }
    }

    @JRubyMethod
    public IRubyObject enclose(Block block) {
        this.enclosed = true;
        return this;
    }

    @JRubyMethod(name={"enclosed?"})
    public IRubyObject enclosed_p(ThreadContext context, Block block) {
        return Convert.asBoolean(context, this.enclosed);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject enclosed_p(Block block) {
        return this.enclosed_p(this.getRuntime().getCurrentContext(), block);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject list(Block block) {
        return this.list(this.getCurrentContext(), block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject list(ThreadContext context, Block block) {
        RubyArray<?> ary = Create.newArray(context);
        Set<RubyThread> set2 = this.rubyThreadList;
        synchronized (set2) {
            for (RubyThread thread2 : this.rubyThreadList) {
                if (thread2 == null) continue;
                ary.append(context, thread2);
            }
        }
        return ary;
    }

    public int size() {
        return this.rubyThreadList.size();
    }

    private RubyThreadGroup(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @Deprecated(since="9.4.6.0")
    public IRubyObject add(IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw Error.typeError(this.getRuntime().getCurrentContext(), rubyThread, "Thread");
        }
        return this.add(((RubyThread)rubyThread).getContext(), rubyThread, block);
    }
}

