/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class FlagRegistry {
    private final Map<Class, Integer> currentShift = new HashMap<Class, Integer>();
    private final Map<Class, BitSet> registry = new HashMap<Class, BitSet>();

    public synchronized int newFlag(Class klass) {
        BitSet flags2;
        Integer shift2 = null;
        for (Class currentKlass = klass; currentKlass != null && (shift2 = this.currentShift.get(currentKlass)) == null; currentKlass = currentKlass.getSuperclass()) {
        }
        if (shift2 == null) {
            shift2 = 0;
        }
        if ((flags2 = this.registry.get(klass)) == null) {
            flags2 = new BitSet();
            this.registry.put(klass, flags2);
        }
        flags2.set(shift2);
        assert (this.flagsAreValid(klass, shift2));
        this.currentShift.put(klass, shift2 + 1);
        Integer n = shift2;
        shift2 = shift2 + 1;
        return 1 << n;
    }

    public synchronized void printFlags() {
        System.out.println(this.registry);
    }

    private boolean flagsAreValid(Class klass, int bitIndex) {
        BitSet gathered = new BitSet();
        for (Class currentKlass = klass; currentKlass != null; currentKlass = currentKlass.getSuperclass()) {
            BitSet flags2 = this.registry.get(klass);
            if (flags2 == null) continue;
            if (flags2.intersects(gathered)) {
                throw new AssertionError((Object)(klass.getName() + " uses flag " + bitIndex + " that overlaps with " + String.valueOf(currentKlass)));
            }
            gathered.and(flags2);
        }
        return true;
    }
}

