/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.dataflow.analyses;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.dataflow.analyses.LiveVariableNode;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.representations.BasicBlock;

public class LiveVariablesProblem
extends DataFlowProblem<LiveVariablesProblem, LiveVariableNode> {
    public static final String NAME = "Live Variables Analysis";
    private final HashMap<Variable, Integer> dfVarMap = new HashMap();
    private final HashMap<Integer, Variable> varDfVarMap = new HashMap();
    private final HashSet<LocalVariable> localVars = new HashSet();
    private final Collection<LocalVariable> varsLiveOnScopeExit = new ArrayList<LocalVariable>();

    public LiveVariablesProblem(FullInterpreterContext fic) {
        super(DataFlowProblem.DF_Direction.BACKWARD);
        this.setup(fic);
    }

    public Integer getDFVar(Variable v) {
        return this.dfVarMap.get(v);
    }

    public boolean dfVarExists(Variable v) {
        return this.getDFVar(v) != null;
    }

    public Variable getVariable(int id) {
        return this.varDfVarMap.get(id);
    }

    @Override
    public LiveVariableNode buildFlowGraphNode(BasicBlock bb) {
        return new LiveVariableNode(this, bb);
    }

    public void addDFVar(Variable v) {
        Integer dfv = this.addDataFlowVar();
        this.dfVarMap.put(v, dfv);
        this.varDfVarMap.put(dfv, v);
        if (v instanceof LocalVariable && !v.isSelf()) {
            this.localVars.add((LocalVariable)v);
        }
    }

    public Collection<LocalVariable> getLocalVarsLiveOnScopeEntry() {
        ArrayList<LocalVariable> liveVars = new ArrayList<LocalVariable>();
        BitSet liveIn = ((LiveVariableNode)this.getFlowGraphNode(this.getFIC().getCFG().getEntryBB())).getLiveOutBitSet();
        for (int i2 = 0; i2 < liveIn.size(); ++i2) {
            Variable v;
            if (!liveIn.get(i2) || !((v = this.getVariable(i2)) instanceof LocalVariable)) continue;
            liveVars.add((LocalVariable)v);
        }
        return liveVars;
    }

    @Override
    public String getDataFlowVarsForOutput() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<Variable, Integer> entry : this.dfVarMap.entrySet()) {
            buf.append("DF Var ").append(entry.getValue()).append(" = ").append(entry.getKey()).append('\n');
        }
        return buf.toString();
    }

    public void markDeadInstructions() {
        for (LiveVariableNode n : this.flowGraphNodes) {
            n.markDeadInstructions();
        }
    }

    public void setVarsLiveOnScopeExit(Collection<LocalVariable> vars) {
        this.varsLiveOnScopeExit.addAll(vars);
    }

    public Collection<LocalVariable> getVarsLiveOnScopeExit() {
        return this.varsLiveOnScopeExit;
    }

    public Set<Variable> getAllVars() {
        return this.dfVarMap.keySet();
    }

    public Set<LocalVariable> getNonSelfLocalVars() {
        return this.localVars;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

