/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.MixedModeIRMethod;
import org.jruby.ir.Counter;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.CachingCallSite;

public class Profiler {
    private static final IRCallSite callerSite = new IRCallSite();
    private static int inlineCount = 0;
    private static int globalThreadPollCount = 0;
    private static int codeModificationsCount = 0;
    private static int numCyclesWithNoModifications = 0;
    private static int versionCount = 1;
    private static final HashMap<IRScope, Integer> scopeVersionMap = new HashMap();
    private static HashMap<IRScope, Counter> scopeThreadPollCounts = new HashMap();
    private static HashMap<Long, CallSiteProfile> callProfile = new HashMap();
    private static HashMap<Operation, Counter> opStats = new HashMap();

    private static void analyzeProfile() {
        ++versionCount;
        numCyclesWithNoModifications = codeModificationsCount == 0 ? ++numCyclesWithNoModifications : 0;
        codeModificationsCount = 0;
        if (numCyclesWithNoModifications < 3) {
            return;
        }
        HashMap<IRScope, Long> scopeCounts = new HashMap<IRScope, Long>();
        ArrayList<IRCallSite> callSites = new ArrayList<IRCallSite>();
        long total2 = 0L;
        for (Long id : callProfile.keySet()) {
            CallSite runtimeCS;
            CallSiteProfile csp = callProfile.get(id);
            IRCallSite cs = csp.cs;
            if (cs.v != scopeVersionMap.get(cs.s)) {
                System.out.println("Skipping callsite: <" + String.valueOf(cs.s) + "," + cs.v + "> with compiled version: " + String.valueOf(scopeVersionMap.get(cs.s)));
                continue;
            }
            Set<IRScope> calledScopes = csp.counters.keySet();
            cs.count = 0L;
            for (IRScope s2 : calledScopes) {
                Long c = (Long)scopeCounts.get(s2);
                if (c == null) {
                    c = 0L;
                    scopeCounts.put(s2, c);
                }
                long x = csp.counters.get((Object)s2).count;
                cs.count += x;
            }
            CallBase call2 = cs.call;
            if (calledScopes.size() == 1 && !call2.inliningBlocked() && (runtimeCS = call2.getCallSite()) != null && runtimeCS instanceof CachingCallSite) {
                CachingCallSite ccs = (CachingCallSite)runtimeCS;
                CacheEntry ce = ccs.getCache();
                if (!(ce.method instanceof MixedModeIRMethod)) continue;
                callSites.add(cs);
                cs.tgtM = (MixedModeIRMethod)ce.method;
            }
            total2 += cs.count;
        }
        Collections.sort(callSites, new Comparator<IRCallSite>(){

            @Override
            public int compare(IRCallSite a, IRCallSite b2) {
                if (a.count == b2.count) {
                    return 0;
                }
                return a.count < b2.count ? 1 : -1;
            }
        });
        double freq = 0.0;
        int i2 = 0;
        boolean noInlining = true;
        HashSet inlinedScopes = new HashSet();
        for (IRCallSite ircs : callSites) {
            double contrib = (double)ircs.count * 100.0 / (double)total2;
            if (contrib < 1.0) break;
            if (++i2 == 100 || (freq += contrib) > 99.0) break;
            System.out.println("Considering: " + String.valueOf(ircs.call) + " with id: " + ircs.call.callSiteId + " in scope " + String.valueOf(ircs.s) + " with count " + ircs.count + "; contrib " + contrib + "; freq: " + freq);
            CallBase call3 = ircs.call;
            IRScope hs = ircs.s;
            boolean isHotClosure = hs instanceof IRClosure;
            IRScope hc = isHotClosure ? hs : null;
            hs = isHotClosure ? hs.getLexicalParent() : hs;
            IRScope tgtMethod = ircs.tgtM.getIRScope();
            Instr[] instrs = tgtMethod.getInterpreterContext().getInstructions();
            if (instrs == null || instrs.length > 500) {
                if (instrs == null) {
                    System.out.println("no instrs!");
                    continue;
                }
                System.out.println("large method with " + instrs.length + " instrs. skipping!");
                continue;
            }
            RubyModule implClass = ircs.tgtM.getImplementationClass();
            int classToken = implClass.getGeneration();
            String n = tgtMethod.getId();
            boolean inlineCall = true;
            if (!isHotClosure) continue;
            Operand clArg = call3.getClosureArg(NullBlock.INSTANCE);
            inlineCall = clArg instanceof WrappedIRClosure && ((WrappedIRClosure)clArg).getClosure() == hc;
        }
        for (IRScope x : inlinedScopes) {
            scopeVersionMap.put(x, versionCount);
        }
        codeModificationsCount = 0;
        callProfile = new HashMap();
        if (globalThreadPollCount % 1000000 == 0) {
            globalThreadPollCount = 0;
        }
    }

    private static void outputProfileStats() {
        ArrayList<IRScope> scopes = new ArrayList<IRScope>(scopeThreadPollCounts.keySet());
        int i2 = 0;
        float f1 = 0.0f;
        for (IRScope s2 : scopes) {
            long n = Profiler.scopeThreadPollCounts.get((Object)s2).count;
            float p1 = (float)(n * 1000L / (long)globalThreadPollCount) / 10.0f;
            String msg = i2 + ". " + String.valueOf(s2) + " [file:" + s2.getFile() + ":" + s2.getLine() + "] = " + n + "; (" + p1 + "%)";
            if (s2 instanceof IRClosure) {
                IRMethod iRMethod = s2.getNearestMethod();
            }
            f1 += p1;
            if (++i2 != 20 && !((double)f1 >= 95.0)) continue;
            break;
        }
        codeModificationsCount = 0;
        if (globalThreadPollCount % 1000000 == 0) {
            scopeThreadPollCounts = new HashMap();
            globalThreadPollCount = 0;
        }
    }

    public static Integer initProfiling(IRScope scope) {
        if (scope == null) {
            return null;
        }
        Integer scopeVersion = scopeVersionMap.get(scope);
        if (scopeVersion == null) {
            scopeVersionMap.put(scope, versionCount);
            scopeVersion = versionCount;
        }
        if (Profiler.callerSite.call != null) {
            Counter csCount;
            Long id = Profiler.callerSite.call.callSiteId;
            CallSiteProfile csp = callProfile.get(id);
            if (csp == null) {
                csp = new CallSiteProfile(callerSite);
                callProfile.put(id, csp);
            }
            if ((csCount = csp.counters.get(scope)) == null) {
                csCount = new Counter();
                csp.counters.put(scope, csCount);
            }
            ++csCount.count;
        }
        return scopeVersion;
    }

    public static void updateCallSite(Instr instr, IRScope scope, Integer scopeVersion) {
        if (scope == null) {
            return;
        }
        if (instr instanceof CallBase) {
            Profiler.callerSite.s = scope;
            Profiler.callerSite.v = scopeVersion;
            Profiler.callerSite.call = (CallBase)instr;
        }
    }

    public static void clockTick() {
        if (++globalThreadPollCount % 20000 == 0) {
            Profiler.analyzeProfile();
        }
    }

    public static void instrTick(Operation operation) {
        if (operation.modifiesCode()) {
            ++codeModificationsCount;
        }
    }

    private static class CallSiteProfile {
        final IRCallSite cs;
        final HashMap<IRScope, Counter> counters;

        public CallSiteProfile(IRCallSite cs) {
            this.cs = new IRCallSite(cs);
            this.counters = new HashMap();
        }
    }

    private static class IRCallSite {
        IRScope s;
        int v;
        CallBase call;
        long count;
        MixedModeIRMethod tgtM;

        public IRCallSite() {
        }

        public IRCallSite(IRCallSite cs) {
            this.s = cs.s;
            this.v = cs.v;
            this.call = cs.call;
            this.count = 0L;
        }

        public int hashCode() {
            return (int)this.call.callSiteId;
        }
    }
}

