/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.api.Access;
import org.jruby.api.Define;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.load.Library;

public class FFIService
implements Library {
    @Override
    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        ThreadContext context = runtime2.getCurrentContext();
        if (!Access.instanceConfig(context).isNativeEnabled()) {
            throw runtime2.newLoadError("Native API access is disabled");
        }
        if (!Platform.getPlatform().isSupported()) {
            throw runtime2.newLoadError("Unsupported platform: " + Platform.getPlatform().getName());
        }
        try {
            Factory.getInstance().init(runtime2, Define.defineModule(context, "FFI"));
        }
        catch (Exception e) {
            throw runtime2.newLoadError("Could not load FFI Provider: " + e.getLocalizedMessage() + "\nSee https://github.com/jruby/jruby/wiki/Native-Libraries#could-not-load-ffi-provider");
        }
    }
}

