/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import json.ext.ByteListTranscoder;
import json.ext.SWARBasicStringEncoder;
import json.ext.Utils;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

class StringEncoder
extends ByteListTranscoder {
    protected static final int CHAR_LENGTH_MASK = 7;
    private static final byte[] BACKSLASH_DOUBLEQUOTE = new byte[]{92, 34};
    private static final byte[] BACKSLASH_BACKSLASH = new byte[]{92, 92};
    private static final byte[] BACKSLASH_FORWARDSLASH = new byte[]{92, 47};
    private static final byte[] BACKSLASH_B = new byte[]{92, 98};
    private static final byte[] BACKSLASH_F = new byte[]{92, 102};
    private static final byte[] BACKSLASH_N = new byte[]{92, 110};
    private static final byte[] BACKSLASH_R = new byte[]{92, 114};
    private static final byte[] BACKSLASH_T = new byte[]{92, 116};
    static final byte[] ESCAPE_TABLE = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] ASCII_ONLY_ESCAPE_TABLE = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 9, 9};
    static final byte[] SCRIPT_SAFE_ESCAPE_TABLE = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 11, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 9, 9};
    private static final byte[] BACKSLASH_U2028 = "\\u2028".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] BACKSLASH_U2029 = "\\u2029".getBytes(StandardCharsets.US_ASCII);
    protected final byte[] escapeTable;
    private static final String VECTORIZED_STRING_ENCODER_CLASS = "json.ext.VectorizedStringEncoder";
    private static final String USE_VECTORIZED_BASIC_ENCODER_PROP = "jruby.json.useVectorizedBasicEncoder";
    private static final String USE_VECTORIZED_BASIC_ENCODER_DEFAULT = "false";
    private static final boolean USE_VECTORIZED_BASIC_ENCODER;
    private static final StringEncoder VECTORIZED_SCANNER;
    private static final String USE_SWAR_BASIC_ENCODER_PROP = "jruby.json.useSWARBasicEncoder";
    private static final String USE_SWAR_BASIC_ENCODER_DEFAULT = "true";
    private static final boolean USE_BASIC_SWAR_ENCODER;
    OutputStream out;
    protected final byte[] aux = new byte[]{92, 117, 0, 0, 0, 0, 92, 117, 0, 0, 0, 0, 92, 0};
    protected static final byte[] HEX;

    StringEncoder(boolean bl) {
        this(bl ? SCRIPT_SAFE_ESCAPE_TABLE : ESCAPE_TABLE);
    }

    StringEncoder(byte[] byArray) {
        this.escapeTable = byArray;
    }

    public StringEncoder clone() {
        return new StringEncoder(this.escapeTable);
    }

    static StringEncoder createBasicEncoder() {
        if (USE_VECTORIZED_BASIC_ENCODER) {
            return VECTORIZED_SCANNER.clone();
        }
        if (USE_BASIC_SWAR_ENCODER) {
            return new SWARBasicStringEncoder();
        }
        return new StringEncoder(false);
    }

    void generate(ThreadContext threadContext, RubyString rubyString, OutputStream outputStream) throws IOException {
        rubyString = StringEncoder.ensureValidEncoding(threadContext, rubyString);
        ByteList byteList = rubyString.getByteList();
        this.init(byteList);
        this.out = outputStream;
        this.append(34);
        switch (rubyString.scanForCodeRange()) {
            case 16: 
            case 32: {
                this.encode(byteList);
                break;
            }
            default: {
                throw Utils.buildGeneratorError(threadContext, (IRubyObject)rubyString, "source sequence is illegal/malformed utf-8").toThrowable();
            }
        }
        this.quoteStop(this.pos);
        this.append(34);
    }

    static boolean hasValidEncoding(RubyString rubyString) {
        switch (rubyString.scanForCodeRange()) {
            case 16: {
                return true;
            }
            case 32: {
                return rubyString.getEncoding() == UTF8Encoding.INSTANCE || rubyString.getEncoding() == USASCIIEncoding.INSTANCE;
            }
        }
        return false;
    }

    static RubyString ensureValidEncoding(ThreadContext threadContext, RubyString rubyString) {
        Encoding encoding = rubyString.getEncoding();
        if (encoding == USASCIIEncoding.INSTANCE || encoding == UTF8Encoding.INSTANCE) {
            return rubyString;
        }
        return StringEncoder.tryWeirdEncodings(threadContext, rubyString, encoding);
    }

    private static RubyString tryWeirdEncodings(ThreadContext threadContext, RubyString rubyString, Encoding encoding) {
        Ruby ruby = threadContext.runtime;
        if (encoding == ASCIIEncoding.INSTANCE) {
            RubyString rubyString2 = rubyString.strDup(ruby);
            rubyString2.setEncoding((Encoding)UTF8Encoding.INSTANCE);
            switch (rubyString2.getCodeRange()) {
                case 16: {
                    return rubyString2;
                }
                case 32: {
                    ruby.getWarnings().warn("JSON.generate: UTF-8 string passed as BINARY, this will raise an encoding error in json 3.0");
                    return rubyString2;
                }
            }
        }
        try {
            rubyString = (RubyString)rubyString.encode(threadContext, ruby.getEncodingService().convertEncodingToRubyEncoding((Encoding)UTF8Encoding.INSTANCE));
        }
        catch (RaiseException raiseException) {
            RubyException rubyException = Utils.buildGeneratorError(threadContext, (IRubyObject)rubyString, raiseException.getMessage());
            rubyException.setCause((IRubyObject)raiseException.getException());
            throw rubyException.toThrowable();
        }
        return rubyString;
    }

    void encodeBasic(ByteList byteList) throws IOException {
        byte[] byArray = HEX;
        byte[] byArray2 = this.aux;
        byte[] byArray3 = byteList.unsafeBytes();
        int n = byteList.begin();
        int n2 = byteList.realSize();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = Byte.toUnsignedInt(byArray3[n + n4]);
            byte by = ESCAPE_TABLE[n5];
            if (by > 0) {
                n3 = n4 = this.flushPos(n4, n3, byArray3, n, 1);
                this.escapeAscii(n5, byArray2, byArray);
                continue;
            }
            ++n4;
        }
        if (n3 < n2) {
            this.append(byArray3, n + n3, n2 - n3);
        }
    }

    void encode(ByteList byteList) throws IOException {
        if (this.escapeTable == ESCAPE_TABLE) {
            this.encodeBasic(byteList);
            return;
        }
        byte[] byArray = HEX;
        byte[] byArray2 = this.aux;
        byte[] byArray3 = this.escapeTable;
        byte[] byArray4 = byteList.unsafeBytes();
        int n = byteList.begin();
        int n2 = byteList.realSize();
        int n3 = 0;
        int n4 = 0;
        block4: while (n4 < n2) {
            int n5 = Byte.toUnsignedInt(byArray4[n + n4]);
            int n6 = byArray3[n5];
            if (n6 > 0) {
                switch (n6) {
                    case 9: {
                        n3 = n4 = this.flushPos(n4, n3, byArray4, n, 1);
                        this.escapeAscii(n5, byArray2, byArray);
                        continue block4;
                    }
                    case 11: {
                        int n7 = Byte.toUnsignedInt(byArray4[n + n4 + 1]);
                        if (n7 == 128) {
                            int n8 = Byte.toUnsignedInt(byArray4[n + n4 + 2]);
                            if (n8 == 168) {
                                n3 = n4 = this.flushPos(n4, n3, byArray4, n, 3);
                                this.append(BACKSLASH_U2028, 0, 6);
                                continue block4;
                            }
                            if (n8 == 169) {
                                n3 = n4 = this.flushPos(n4, n3, byArray4, n, 3);
                                this.append(BACKSLASH_U2029, 0, 6);
                                continue block4;
                            }
                        }
                        n6 = 3;
                    }
                }
                n4 += n6;
                continue;
            }
            ++n4;
        }
        if (n3 < n2) {
            this.append(byArray4, n + n3, n2 - n3);
        }
    }

    protected int flushPos(int n, int n2, byte[] byArray, int n3, int n4) throws IOException {
        if (n > n2) {
            this.append(byArray, n3 + n2, n - n2);
        }
        return n + n4;
    }

    protected void escapeAscii(int n, byte[] byArray, byte[] byArray2) throws IOException {
        switch (n) {
            case 34: {
                this.appendEscape(BACKSLASH_DOUBLEQUOTE);
                break;
            }
            case 92: {
                this.appendEscape(BACKSLASH_BACKSLASH);
                break;
            }
            case 47: {
                this.appendEscape(BACKSLASH_FORWARDSLASH);
                break;
            }
            case 8: {
                this.appendEscape(BACKSLASH_B);
                break;
            }
            case 12: {
                this.appendEscape(BACKSLASH_F);
                break;
            }
            case 10: {
                this.appendEscape(BACKSLASH_N);
                break;
            }
            case 13: {
                this.appendEscape(BACKSLASH_R);
                break;
            }
            case 9: {
                this.appendEscape(BACKSLASH_T);
                break;
            }
            default: {
                byArray[2] = 48;
                byArray[3] = 48;
                byArray[4] = byArray2[n >> 4 & 0xF];
                byArray[5] = byArray2[n & 0xF];
                this.append(byArray, 0, 6);
            }
        }
    }

    private void appendEscape(byte[] byArray) throws IOException {
        this.append(byArray, 0, 2);
    }

    @Override
    protected void append(int n) throws IOException {
        this.out.write(n);
    }

    @Override
    protected void append(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    @Override
    protected RaiseException invalidUtf8(ThreadContext threadContext) {
        return Utils.newException(threadContext, "GeneratorError", "source sequence is illegal/malformed utf-8");
    }

    static {
        String string = System.getProperty(USE_VECTORIZED_BASIC_ENCODER_PROP, USE_VECTORIZED_BASIC_ENCODER_DEFAULT);
        if (USE_SWAR_BASIC_ENCODER_DEFAULT.equalsIgnoreCase(string) || "1".equalsIgnoreCase(string)) {
            StringEncoder stringEncoder;
            try {
                Class<?> clazz = StringEncoder.class.getClassLoader().loadClass(VECTORIZED_STRING_ENCODER_CLASS);
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                stringEncoder = (StringEncoder)constructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                stringEncoder = null;
            }
            VECTORIZED_SCANNER = stringEncoder;
            USE_VECTORIZED_BASIC_ENCODER = stringEncoder != null;
        } else {
            VECTORIZED_SCANNER = null;
            USE_VECTORIZED_BASIC_ENCODER = false;
        }
        USE_BASIC_SWAR_ENCODER = Boolean.parseBoolean(System.getProperty(USE_SWAR_BASIC_ENCODER_PROP, USE_SWAR_BASIC_ENCODER_DEFAULT));
        HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    }
}

