/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.util.ArrayUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ext.JavaLang;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Inspector;
import org.jruby.util.RubyStringBuilder;

public final class ArrayJavaProxy
extends JavaProxy {
    private final JavaUtil.JavaConverter converter;
    private static final byte[] END_BRACKET_COLON_SPACE = new byte[]{93, 58, 32};

    public ArrayJavaProxy(Ruby runtime2, RubyClass klazz, Object array2) {
        this(runtime2, klazz, array2, JavaUtil.getJavaConverter(array2.getClass().getComponentType()));
    }

    public ArrayJavaProxy(Ruby runtime2, RubyClass klazz, Object array2, JavaUtil.JavaConverter converter) {
        super(runtime2, klazz, array2);
        this.converter = converter;
    }

    public static RubyClass createArrayJavaProxy(ThreadContext context, RubyClass JavaProxy2, RubyModule Enumerable) {
        return ((RubyModule)Define.defineClass(context, "ArrayJavaProxy", JavaProxy2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR).defineMethods(context, ArrayJavaProxy.class)).include(context, Enumerable).tap(c -> c.singletonClass(context).addMethod(context, "new", new ArrayNewMethod(c.singletonClass(context), Visibility.PUBLIC)));
    }

    @Deprecated(since="10.0.0.0")
    public static ArrayJavaProxy newArray(Ruby runtime2, Class<?> elementType, int ... dimensions2) {
        return ArrayJavaProxy.newArray(runtime2.getCurrentContext(), elementType, dimensions2);
    }

    public static ArrayJavaProxy newArray(ThreadContext context, Class<?> elementType, int ... dimensions2) {
        Object array2;
        try {
            array2 = Array.newInstance(elementType, dimensions2);
        }
        catch (IllegalArgumentException e) {
            throw Error.argumentError(context, "can not create " + dimensions2.length + " dimensional array");
        }
        return new ArrayJavaProxy(context.runtime, Java.getProxyClassForObject(context, array2), array2);
    }

    @Override
    @Deprecated(since="9.4.0.0")
    protected JavaArray asJavaObject(Object array2) {
        return new JavaArray(this.getCurrentContext().runtime, array2);
    }

    @Deprecated(since="9.4.0.0")
    public final JavaArray getJavaArray() {
        return this.asJavaObject(this.object);
    }

    public Object get(int index2) {
        return Array.get(this.getObject(), index2);
    }

    public void set(int index2, Object value2) {
        Array.set(this.getObject(), index2, value2);
    }

    public IRubyObject setValue(Ruby runtime2, int index2, IRubyObject value2) {
        return ArrayUtils.asetDirect(runtime2, this.getObject(), this.converter, index2, value2);
    }

    public final int length() {
        return Array.getLength(this.getObject());
    }

    @JRubyMethod(name={"length", "size"})
    public RubyFixnum length(ThreadContext context) {
        return Convert.asFixnum(context, this.length());
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        return Convert.asBoolean(context, this.length() == 0);
    }

    @JRubyMethod(name={"[]"})
    public final IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof RubyRange) {
            return this.arrayRange(context, (RubyRange)arg2);
        }
        int i2 = ArrayJavaProxy.convertArrayIndex(context, arg2);
        return ArrayUtils.arefDirect(context.runtime, this.getObject(), this.converter, i2);
    }

    @JRubyMethod(name={"[]"}, required=1, rest=true, checkArity=false)
    public final IRubyObject op_aref(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        if (argc == 1) {
            return this.op_aref(context, args2[0]);
        }
        return this.getRange(context, args2);
    }

    @JRubyMethod(name={"[]="})
    public final IRubyObject op_aset(ThreadContext context, IRubyObject index2, IRubyObject value2) {
        return this.setValue(context.runtime, ArrayJavaProxy.convertArrayIndex(context, index2), value2);
    }

    @JRubyMethod(name={"include?", "member?"})
    public IRubyObject include_p(ThreadContext context, IRubyObject obj) {
        Object array2 = this.getObject();
        Class<?> componentClass = array2.getClass().getComponentType();
        if (componentClass.isPrimitive()) {
            switch (componentClass.getName().charAt(0)) {
                case 'b': {
                    if (componentClass == Byte.TYPE) {
                        return Convert.asBoolean(context, this.includes(context, (byte[])array2, obj));
                    }
                    return Convert.asBoolean(context, this.includes(context, (boolean[])array2, obj));
                }
                case 's': {
                    return Convert.asBoolean(context, this.includes(context, (short[])array2, obj));
                }
                case 'c': {
                    return Convert.asBoolean(context, this.includes(context, (char[])array2, obj));
                }
                case 'i': {
                    return Convert.asBoolean(context, this.includes(context, (int[])array2, obj));
                }
                case 'l': {
                    return Convert.asBoolean(context, this.includes(context, (long[])array2, obj));
                }
                case 'f': {
                    return Convert.asBoolean(context, this.includes(context, (float[])array2, obj));
                }
                case 'd': {
                    return Convert.asBoolean(context, this.includes(context, (double[])array2, obj));
                }
            }
        }
        return Convert.asBoolean(context, this.includes(context, (Object[])array2, obj));
    }

    private boolean includes(ThreadContext context, Object[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        Ruby runtime2 = context.runtime;
        for (int i2 = 0; i2 < len; ++i2) {
            IRubyObject value2 = JavaUtil.convertJavaArrayElementToRuby(runtime2, this.converter, array2, i2);
            if (!ArrayJavaProxy.equalInternal(context, value2, obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, byte[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        if (obj instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)obj;
            long objVal = fix2.getValue();
            if (objVal < -128L || objVal > 127L) {
                return false;
            }
            for (byte b2 : array2) {
                if ((byte)objVal != b2) continue;
                return true;
            }
            return false;
        }
        for (byte b3 : array2) {
            if (!ArrayJavaProxy.equalInternal(context, Convert.asFixnum(context, b3), obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, short[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        if (obj instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)obj;
            long objVal = fix2.getValue();
            if (objVal < -32768L || objVal > 32767L) {
                return false;
            }
            for (short value2 : array2) {
                if ((short)objVal != value2) continue;
                return true;
            }
            return false;
        }
        for (short item : array2) {
            if (!ArrayJavaProxy.equalInternal(context, Convert.asFixnum(context, item), obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, int[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        if (obj instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)obj;
            long objVal = fix2.getValue();
            if (objVal < Integer.MIN_VALUE || objVal > Integer.MAX_VALUE) {
                return false;
            }
            for (int j : array2) {
                if ((int)objVal != j) continue;
                return true;
            }
            return false;
        }
        for (int j : array2) {
            if (!ArrayJavaProxy.equalInternal(context, Convert.asFixnum(context, j), obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, long[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        if (obj instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)obj;
            long objVal = fix2.getValue();
            for (long l : array2) {
                if (objVal != l) continue;
                return true;
            }
            return false;
        }
        for (long l : array2) {
            if (!ArrayJavaProxy.equalInternal(context, Convert.asFixnum(context, l), obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, char[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        if (obj instanceof RubyFixnum) {
            RubyFixnum fix2 = (RubyFixnum)obj;
            long objVal = fix2.getValue();
            if (objVal < 0L || objVal > 65535L) {
                return false;
            }
            for (char c : array2) {
                if ((int)objVal != c) continue;
                return true;
            }
            return false;
        }
        for (char c : array2) {
            if (!ArrayJavaProxy.equalInternal(context, Convert.asFixnum(context, c), obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, boolean[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        if (obj instanceof RubyBoolean) {
            RubyBoolean bool2 = (RubyBoolean)obj;
            boolean objVal = bool2.isTrue();
            for (boolean b2 : array2) {
                if (objVal != b2) continue;
                return true;
            }
            return false;
        }
        for (boolean b3 : array2) {
            if (!ArrayJavaProxy.equalInternal(context, Convert.asBoolean(context, b3), obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, float[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        if (obj instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)obj;
            double objVal = flote.asDouble(context);
            for (float v : array2) {
                if ((float)objVal != v) continue;
                return true;
            }
            return false;
        }
        for (float v : array2) {
            if (!ArrayJavaProxy.equalInternal(context, Convert.asFloat(context, v), obj)) continue;
            return true;
        }
        return false;
    }

    private boolean includes(ThreadContext context, double[] array2, IRubyObject obj) {
        int len = array2.length;
        if (len == 0) {
            return false;
        }
        if (obj instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)obj;
            double objVal = flote.asDouble(context);
            for (double v : array2) {
                if (objVal != v) continue;
                return true;
            }
            return false;
        }
        for (double v : array2) {
            if (!ArrayJavaProxy.equalInternal(context, Convert.asFloat(context, v), obj)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"first"})
    public IRubyObject first(ThreadContext context) {
        Object array2 = this.getObject();
        if (Array.getLength(array2) == 0) {
            return context.nil;
        }
        return JavaUtil.convertJavaArrayElementToRuby(context.runtime, this.converter, array2, 0);
    }

    @JRubyMethod(name={"first"})
    public IRubyObject first(ThreadContext context, IRubyObject count2) {
        int size2;
        Object array2 = this.getObject();
        int len = Convert.toInt(context, count2);
        if (len > (size2 = Array.getLength(array2))) {
            len = size2;
        }
        Ruby runtime2 = context.runtime;
        if (len == 0) {
            return RubyArray.newEmptyArray(runtime2);
        }
        IRubyObject[] ary = new IRubyObject[len];
        for (int i2 = 0; i2 < len; ++i2) {
            ary[i2] = JavaUtil.convertJavaArrayElementToRuby(runtime2, this.converter, array2, i2);
        }
        return RubyArray.newArrayNoCopy(runtime2, ary);
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last(ThreadContext context) {
        Object array2 = this.getObject();
        int len = Array.getLength(array2);
        if (len == 0) {
            return context.nil;
        }
        return JavaUtil.convertJavaArrayElementToRuby(context.runtime, this.converter, array2, len - 1);
    }

    @JRubyMethod(name={"last"})
    public IRubyObject last(ThreadContext context, IRubyObject count2) {
        int end2;
        Object array2 = this.getObject();
        int len = Convert.toInt(context, count2);
        int size2 = Array.getLength(array2);
        int start2 = size2 - len;
        if (start2 < 0) {
            start2 = 0;
        }
        if ((end2 = start2 + len) > size2) {
            end2 = size2;
        }
        len = end2 - start2;
        Ruby runtime2 = context.runtime;
        if (len == 0) {
            return RubyArray.newEmptyArray(runtime2);
        }
        IRubyObject[] ary = new IRubyObject[len];
        for (int i2 = 0; i2 < len; ++i2) {
            ary[i2] = JavaUtil.convertJavaArrayElementToRuby(runtime2, this.converter, array2, i2 + start2);
        }
        return RubyArray.newArrayNoCopy(runtime2, ary);
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return Convert.asFixnum(context, this.length());
        }
        Object array2 = this.getObject();
        int count2 = 0;
        for (int i2 = 0; i2 < Array.getLength(array2); ++i2) {
            IRubyObject next2 = JavaUtil.convertJavaArrayElementToRuby(context.runtime, this.converter, array2, i2);
            if (!block.yield(context, next2).isTrue()) continue;
            ++count2;
        }
        return Convert.asFixnum(context, count2);
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count(ThreadContext context, IRubyObject obj, Block unused2) {
        Object array2 = this.getObject();
        int count2 = 0;
        for (int i2 = 0; i2 < Array.getLength(array2); ++i2) {
            IRubyObject next2 = JavaUtil.convertJavaArrayElementToRuby(context.runtime, this.converter, array2, i2);
            if (!RubyObject.equalInternal(context, next2, obj)) continue;
            ++count2;
        }
        return Convert.asFixnum(context, count2);
    }

    @JRubyMethod(name={"dig"}, required=1, rest=true, checkArity=false)
    public final IRubyObject dig(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, -1);
        return this.dig(context, args2, 0);
    }

    final IRubyObject dig(ThreadContext context, IRubyObject[] args2, int idx) {
        IRubyObject val = this.at(context, args2[idx++]);
        return idx == args2.length ? val : RubyObject.dig(context, val, args2, idx);
    }

    private static int convertArrayIndex(ThreadContext context, IRubyObject index2) {
        return index2 instanceof JavaProxy ? index2.toJava(Integer.class) : Convert.toInt(context, index2);
    }

    @JRubyMethod
    public IRubyObject at(ThreadContext context, IRubyObject index2) {
        return this.at(context, ArrayJavaProxy.convertArrayIndex(context, index2));
    }

    private final IRubyObject at(ThreadContext context, int i2) {
        Ruby runtime2 = context.runtime;
        Object array2 = this.getObject();
        int length2 = Array.getLength(array2);
        if (i2 < 0) {
            i2 += length2;
        }
        if (i2 >= 0 && i2 < length2) {
            return ArrayUtils.arefDirect(runtime2, array2, this.converter, i2);
        }
        return context.nil;
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        Object array2 = this.getObject();
        if (other instanceof ArrayJavaProxy) {
            Object otherArray = ((ArrayJavaProxy)other).getObject();
            Class<?> componentType = array2.getClass().getComponentType();
            if (componentType.isAssignableFrom(otherArray.getClass().getComponentType())) {
                return ArrayUtils.concatArraysDirect(context, array2, otherArray);
            }
        }
        return ArrayUtils.concatArraysDirect(context, array2, other);
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "each", ArrayJavaProxy::size);
        }
        Object array2 = this.getObject();
        int length2 = Array.getLength(array2);
        for (int i2 = 0; i2 < length2; ++i2) {
            IRubyObject element = ArrayUtils.arefDirect(runtime2, array2, this.converter, i2);
            block.yield(context, element);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_with_index(ThreadContext context, Block block) {
        Ruby runtime2 = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "each_with_index", ArrayJavaProxy::size);
        }
        boolean twoArguments = block.getSignature().isTwoArguments();
        Object array2 = this.getObject();
        int length2 = Array.getLength(array2);
        for (int i2 = 0; i2 < length2; ++i2) {
            IRubyObject element = ArrayUtils.arefDirect(runtime2, array2, this.converter, i2);
            RubyFixnum index2 = Convert.asFixnum(context, i2);
            if (twoArguments) {
                block.yieldSpecific(context, element, index2);
                continue;
            }
            block.yield(context, Create.newArray(context, element, (IRubyObject)index2));
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"to_a", "entries"}, alias={"to_ary"})
    public RubyArray to_a(ThreadContext context) {
        Object array2 = this.getObject();
        return JavaUtil.convertJavaArrayToRubyWithNesting(context, array2);
    }

    public Class<?> getComponentType() {
        return this.getObject().getClass().getComponentType();
    }

    @JRubyMethod(name={"component_type"})
    public IRubyObject component_type(ThreadContext context) {
        return Java.getProxyClass(context, this.getComponentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod
    public RubyString inspect(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        Class<?> componentClass = this.getObject().getClass().getComponentType();
        if (componentClass.isPrimitive()) {
            return this.inspectPrimitiveArray(runtime2, componentClass);
        }
        Object[] ary = (Object[])this.getObject();
        RubyModule type2 = Java.getProxyClass(context, componentClass);
        RubyString buf = Inspector.inspectPrefixTypeOnly(context, type2);
        RubyStringBuilder.cat(runtime2, buf, Inspector.BEG_BRACKET);
        RubyStringBuilder.cat(runtime2, buf, ConvertBytes.intToCharBytes(ary.length));
        RubyStringBuilder.cat(runtime2, buf, END_BRACKET_COLON_SPACE);
        if (ary.length == 0) {
            RubyStringBuilder.cat(runtime2, buf, Inspector.EMPTY_ARRAY_BL);
        } else if (runtime2.isInspecting(ary)) {
            RubyStringBuilder.cat(runtime2, buf, Inspector.RECURSIVE_ARRAY_BL);
        } else {
            try {
                runtime2.registerInspecting(ary);
                RubyStringBuilder.cat(runtime2, buf, Inspector.BEG_BRACKET);
                for (int i2 = 0; i2 < ary.length; ++i2) {
                    RubyString s2 = JavaUtil.inspectObject(context, ary[i2]);
                    if (i2 > 0) {
                        RubyStringBuilder.cat(runtime2, buf, Inspector.COMMA_SPACE);
                    } else {
                        buf.setEncoding(s2.getEncoding());
                    }
                    buf.catWithCodeRange(s2);
                }
                RubyStringBuilder.cat(runtime2, buf, Inspector.END_BRACKET);
            }
            finally {
                runtime2.unregisterInspecting(ary);
            }
        }
        RubyStringBuilder.cat(runtime2, buf, Inspector.GT);
        return buf;
    }

    private RubyString inspectPrimitiveArray(Ruby runtime2, Class<?> componentClass) {
        int len = Array.getLength(this.getObject());
        StringBuilder buffer = new StringBuilder(24);
        String name2 = componentClass.getName();
        buffer.append("#<Java::").append(name2).append('[').append(len).append("]: ");
        switch (name2.charAt(0)) {
            case 'b': {
                if (componentClass == Byte.TYPE) {
                    buffer.append(Arrays.toString((byte[])this.getObject()));
                    break;
                }
                buffer.append(Arrays.toString((boolean[])this.getObject()));
                break;
            }
            case 's': {
                buffer.append(Arrays.toString((short[])this.getObject()));
                break;
            }
            case 'c': {
                return ArrayJavaProxy.inspectCharArrayPart(runtime2, buffer, (char[])this.getObject(), len);
            }
            case 'i': {
                buffer.append(Arrays.toString((int[])this.getObject()));
                break;
            }
            case 'l': {
                buffer.append(Arrays.toString((long[])this.getObject()));
                break;
            }
            case 'f': {
                buffer.append(Arrays.toString((float[])this.getObject()));
                break;
            }
            case 'd': {
                buffer.append(Arrays.toString((double[])this.getObject()));
            }
        }
        return RubyString.newUSASCIIString(runtime2, buffer.append('>').toString());
    }

    private static RubyString inspectCharArrayPart(Ruby runtime2, StringBuilder buffer, char[] ary, int len) {
        buffer.append('[');
        if (len > 0) {
            int i2 = 0;
            while (true) {
                JavaLang.Character.inspectCharValue(buffer, ary[i2]);
                if (i2 == len - 1) break;
                buffer.append(", ");
                ++i2;
            }
        }
        buffer.append(']');
        return RubyString.newString(runtime2, buffer.append('>'));
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(24);
        Class<?> componentClass = this.getObject().getClass().getComponentType();
        String name2 = componentClass.getName();
        buffer.append(name2);
        if (componentClass.isPrimitive()) {
            switch (name2.charAt(0)) {
                case 'b': {
                    if (componentClass == Byte.TYPE) {
                        buffer.append(Arrays.toString((byte[])this.getObject()));
                        break;
                    }
                    buffer.append(Arrays.toString((boolean[])this.getObject()));
                    break;
                }
                case 's': {
                    buffer.append(Arrays.toString((short[])this.getObject()));
                    break;
                }
                case 'c': {
                    buffer.append(Arrays.toString((char[])this.getObject()));
                    break;
                }
                case 'i': {
                    buffer.append(Arrays.toString((int[])this.getObject()));
                    break;
                }
                case 'l': {
                    buffer.append(Arrays.toString((long[])this.getObject()));
                    break;
                }
                case 'f': {
                    buffer.append(Arrays.toString((float[])this.getObject()));
                    break;
                }
                case 'd': {
                    buffer.append(Arrays.toString((double[])this.getObject()));
                }
            }
        } else {
            buffer.append(Arrays.toString((Object[])this.getObject()));
        }
        return buffer.toString();
    }

    @Override
    @JRubyMethod(name={"=="})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyArray) {
            return Convert.asBoolean(context, this.equalsRubyArray((RubyArray)other));
        }
        return this.eql_p(context, other);
    }

    private boolean equalsRubyArray(RubyArray rubyArray) {
        Object thisArray = this.getObject();
        int len = rubyArray.size();
        if (len != Array.getLength(thisArray)) {
            return false;
        }
        Class<?> componentType = thisArray.getClass().getComponentType();
        for (int i2 = 0; i2 < len; ++i2) {
            Object ruby = rubyArray.eltInternal(i2).toJava(componentType);
            Object elem = Array.get(thisArray, i2);
            if (ruby == null) {
                return elem == null;
            }
            if (ruby.equals(elem)) continue;
            return false;
        }
        return true;
    }

    @Override
    @JRubyMethod(name={"eql?"})
    public RubyBoolean eql_p(ThreadContext context, IRubyObject obj) {
        boolean equals = false;
        if (obj instanceof ArrayJavaProxy) {
            ArrayJavaProxy that = (ArrayJavaProxy)obj;
            equals = ArrayJavaProxy.arraysEquals(this.getObject(), that.getObject());
        } else if (obj.getClass().isArray()) {
            equals = ArrayJavaProxy.arraysEquals(this.getObject(), obj);
        }
        return Convert.asBoolean(context, equals);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ArrayJavaProxy) {
            ArrayJavaProxy that = (ArrayJavaProxy)obj;
            Object thisArray = this.getObject();
            Object thatArray = that.getObject();
            return ArrayJavaProxy.arraysEquals(thisArray, thatArray);
        }
        return false;
    }

    private static boolean arraysEquals(Object thisArray, Object thatArray) {
        Class<?> componentType = thisArray.getClass().getComponentType();
        if (!componentType.equals(thatArray.getClass().getComponentType())) {
            return false;
        }
        if (componentType.isPrimitive()) {
            switch (componentType.getName().charAt(0)) {
                case 'b': {
                    if (componentType == Byte.TYPE) {
                        return Arrays.equals((byte[])thisArray, (byte[])thatArray);
                    }
                    return Arrays.equals((boolean[])thisArray, (boolean[])thatArray);
                }
                case 's': {
                    return Arrays.equals((short[])thisArray, (short[])thatArray);
                }
                case 'c': {
                    return Arrays.equals((char[])thisArray, (char[])thatArray);
                }
                case 'i': {
                    return Arrays.equals((int[])thisArray, (int[])thatArray);
                }
                case 'l': {
                    return Arrays.equals((long[])thisArray, (long[])thatArray);
                }
                case 'f': {
                    return Arrays.equals((float[])thisArray, (float[])thatArray);
                }
                case 'd': {
                    return Arrays.equals((double[])thisArray, (double[])thatArray);
                }
            }
        }
        return Arrays.equals((Object[])thisArray, (Object[])thatArray);
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.hashCode());
    }

    @Override
    public int hashCode() {
        Object array2 = this.getObject();
        Class<?> componentType = array2.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            switch (componentType.getName().charAt(0)) {
                case 'b': {
                    if (componentType == Byte.TYPE) {
                        return 11 * Arrays.hashCode((byte[])array2);
                    }
                    return 11 * Arrays.hashCode((boolean[])array2);
                }
                case 's': {
                    return 11 * Arrays.hashCode((short[])array2);
                }
                case 'c': {
                    return 11 * Arrays.hashCode((char[])array2);
                }
                case 'i': {
                    return 11 * Arrays.hashCode((int[])array2);
                }
                case 'l': {
                    return 11 * Arrays.hashCode((long[])array2);
                }
                case 'f': {
                    return 11 * Arrays.hashCode((float[])array2);
                }
                case 'd': {
                    return 11 * Arrays.hashCode((double[])array2);
                }
            }
        }
        return 11 * Arrays.hashCode((Object[])array2);
    }

    @Override
    public IRubyObject dup() {
        Ruby runtime2 = this.getRuntime();
        ArrayJavaProxy dup2 = new ArrayJavaProxy(runtime2, this.getMetaClass(), this.cloneObject(), this.converter);
        ArrayJavaProxy.initCopy(dup2, this, "initialize_dup");
        return dup2;
    }

    private static void initCopy(IRubyObject clone2, IRubyObject original, String method2) {
        original.copySpecialInstanceVariables(clone2);
        if (original.hasVariables()) {
            clone2.syncVariables(original);
        }
    }

    @Override
    @JRubyMethod(name={"clone"})
    public IRubyObject rbClone() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        ArrayJavaProxy clone2 = new ArrayJavaProxy(context.runtime, this.getMetaClass(), this.cloneObject(), this.converter);
        clone2.setMetaClass(this.getSingletonClassCloneAndAttach(context, null));
        ArrayJavaProxy.initCopy(clone2, this, "initialize_clone");
        if (this.isFrozen()) {
            clone2.setFrozen(true);
        }
        return clone2;
    }

    @Override
    protected Object cloneObject() {
        Object array2 = this.getObject();
        Class<?> componentType = array2.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            switch (componentType.getName().charAt(0)) {
                case 'b': {
                    if (componentType == Byte.TYPE) {
                        return ((byte[])array2).clone();
                    }
                    return ((boolean[])array2).clone();
                }
                case 's': {
                    return ((short[])array2).clone();
                }
                case 'c': {
                    return ((char[])array2).clone();
                }
                case 'i': {
                    return ((int[])array2).clone();
                }
                case 'l': {
                    return ((long[])array2).clone();
                }
                case 'f': {
                    return ((float[])array2).clone();
                }
                case 'd': {
                    return ((double[])array2).clone();
                }
            }
        }
        return ((Object[])array2).clone();
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject[] args2) {
        if (args2.length == 1) {
            return this.getRange(context, args2[0]);
        }
        if (args2.length == 2) {
            return this.getRange(context, args2[0], args2[1]);
        }
        throw Error.argumentError(context, args2.length, 1);
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject arg0) {
        return this.arrayRange(context, Convert.castAsRange(context, arg0));
    }

    private IRubyObject arrayRange(ThreadContext context, RubyRange range) {
        Object array2 = this.getObject();
        int arrayLength = Array.getLength(array2);
        int first2 = Convert.castAsFixnum(context, range.first(context), "Only Integer ranges supported").asInt(context);
        int last2 = Convert.castAsFixnum(context, range.last(context), "Only Integer ranges supported").asInt(context);
        int n = first2 = first2 >= 0 ? first2 : arrayLength + first2;
        if (first2 < 0 || first2 >= arrayLength) {
            return context.nil;
        }
        last2 = last2 >= 0 ? last2 : arrayLength + last2;
        int newLength = last2 - first2;
        if (!range.isExcludeEnd()) {
            ++newLength;
        }
        return newLength <= 0 ? ArrayUtils.emptyJavaArrayDirect(context, array2.getClass().getComponentType()) : this.subarrayProxy(context, array2, arrayLength, first2, newLength);
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject first2, IRubyObject length2) {
        return this.arrayRange(context, first2, length2);
    }

    private IRubyObject arrayRange(ThreadContext context, IRubyObject rFirst, IRubyObject rLength) {
        Object array2 = this.getObject();
        int arrayLength = Array.getLength(array2);
        int first2 = Convert.castAsFixnum(context, rFirst, "Only Integer ranges supported").asInt(context);
        int length2 = Convert.castAsFixnum(context, rLength, "Only Integer ranges supported").asInt(context);
        if (length2 > arrayLength) {
            throw Error.indexError(context, "length specified is longer than array");
        }
        if (length2 < 0) {
            return context.nil;
        }
        int n = first2 = first2 >= 0 ? first2 : arrayLength + first2;
        if (first2 >= arrayLength) {
            return context.nil;
        }
        return this.subarrayProxy(context, array2, arrayLength, first2, length2);
    }

    private IRubyObject subarrayProxy(ThreadContext context, Object ary, int aryLength, int index2, int size2) {
        if (index2 + size2 > aryLength) {
            size2 = aryLength - index2;
        }
        ArrayJavaProxy proxy2 = ArrayUtils.newProxiedArray(context, ary.getClass().getComponentType(), this.converter, size2);
        System.arraycopy(ary, index2, proxy2.getObject(), 0, size2);
        return proxy2;
    }

    protected static IRubyObject size(ThreadContext context, ArrayJavaProxy self2, IRubyObject[] args2) {
        return self2.length(context);
    }

    private static final class ArrayNewMethod
    extends JavaMethod.JavaMethodOne {
        private final DynamicMethod newMethod;

        ArrayNewMethod(RubyModule implClass, Visibility visibility) {
            this(implClass, visibility, implClass.searchMethod("new"));
        }

        public ArrayNewMethod(RubyModule implClass, Visibility visibility, DynamicMethod oldNew) {
            super(implClass, visibility, "new");
            this.newMethod = oldNew;
        }

        @Override
        public final IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0) {
            if (!(arg0 instanceof ArrayJavaProxy)) {
                throw Error.typeError(context, arg0, "ArrayJavaProxy");
            }
            IRubyObject proxy2 = this.newMethod.call(context, self2, clazz, "new_proxy");
            proxy2.dataWrapStruct(arg0);
            return proxy2;
        }
    }
}

