/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteOrder;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafePropertyAccessor;

public class Platform {
    private static final Locale LOCALE = Locale.ENGLISH;
    public static final CPU_TYPE CPU = Platform.determineCPU();
    public static final OS_TYPE OS = Platform.determineOS();
    private static final int ARCH_DATA_MODEL = Platform.determineArchDataModel();
    public static final String NAME = String.valueOf((Object)CPU) + "-" + String.valueOf((Object)OS);
    public static final String LIBPREFIX = OS == OS_TYPE.WINDOWS ? "" : "lib";
    public static final String LIBSUFFIX = Platform.determineLibExt();
    public static final String LIBC = Platform.determineLibC();
    public static final int BIG_ENDIAN = 4321;
    public static final int LITTLE_ENDIAN = 1234;
    public static final int BYTE_ORDER = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 4321 : 1234;
    protected final int addressSize = ARCH_DATA_MODEL;
    protected final int longSize;
    private final long addressMask = this.addressSize == 32 ? 0xFFFFFFFFL : -1L;
    protected final Pattern libPattern;

    private static final OS_TYPE determineOS() {
        String osName = System.getProperty("os.name").split(" ")[0];
        if (Platform.startsWithIgnoreCase(osName, "mac") || Platform.startsWithIgnoreCase(osName, "darwin")) {
            return OS_TYPE.DARWIN;
        }
        if (Platform.startsWithIgnoreCase(osName, "sunos") || Platform.startsWithIgnoreCase(osName, "solaris")) {
            return OS_TYPE.SOLARIS;
        }
        for (OS_TYPE os : OS_TYPE.values()) {
            if (!Platform.startsWithIgnoreCase(osName, os.toString())) continue;
            return os;
        }
        return OS_TYPE.UNKNOWN;
    }

    private static final Platform determinePlatform(OS_TYPE os) {
        switch (os.ordinal()) {
            case 0: {
                return new Darwin();
            }
            case 5: {
                return new Linux();
            }
            case 7: {
                return new AIX();
            }
            case 8: {
                return new Windows();
            }
            case 9: {
                return new Unsupported(os);
            }
        }
        return new Default(os);
    }

    private static final CPU_TYPE determineCPU() {
        String archString = System.getProperty("os.arch").toLowerCase(LOCALE);
        if ("x86".equals(archString) || "i386".equals(archString) || "i86pc".equals(archString)) {
            return CPU_TYPE.I386;
        }
        if ("x86_64".equals(archString) || "amd64".equals(archString)) {
            return CPU_TYPE.X86_64;
        }
        if ("ppc".equals(archString) || "powerpc".equals(archString)) {
            return CPU_TYPE.POWERPC;
        }
        if ("ppc64".equals(archString)) {
            return CPU_TYPE.POWERPC64;
        }
        if ("ppc64le".equals(archString)) {
            return CPU_TYPE.POWERPC64LE;
        }
        if ("sparc".equals(archString)) {
            return CPU_TYPE.SPARC;
        }
        if ("sparcv9".equals(archString)) {
            return CPU_TYPE.SPARCV9;
        }
        if ("s390x".equals(archString)) {
            return CPU_TYPE.S390X;
        }
        if ("arm".equals(archString)) {
            return CPU_TYPE.ARM;
        }
        if ("aarch64".equals(archString)) {
            return CPU_TYPE.AARCH64;
        }
        if ("loongarch64".equals(archString)) {
            return CPU_TYPE.LOONGARCH64;
        }
        if ("universal".equals(archString)) {
            String bits = SafePropertyAccessor.getProperty("sun.arch.data.model");
            if ("32".equals(bits)) {
                System.setProperty("os.arch", "i386");
                return CPU_TYPE.I386;
            }
            if ("64".equals(bits)) {
                System.setProperty("os.arch", "x86_64");
                return CPU_TYPE.X86_64;
            }
        }
        return CPU_TYPE.UNKNOWN;
    }

    private static final String determineLibC() {
        switch (OS.ordinal()) {
            case 8: {
                return "msvcrt.dll";
            }
            case 5: {
                return "libc.so.6";
            }
            case 7: {
                if (ARCH_DATA_MODEL == 32) {
                    return "libc.a(shr.o)";
                }
                return "libc.a(shr_64.o)";
            }
        }
        return LIBPREFIX + "c." + LIBSUFFIX;
    }

    private static final String determineLibExt() {
        switch (OS.ordinal()) {
            case 8: {
                return "dll";
            }
            case 7: {
                return "a";
            }
            case 0: {
                return "dylib";
            }
        }
        return "so";
    }

    private static int determineArchDataModel() {
        int dataModel = SafePropertyAccessor.getInt("sun.arch.data.model");
        if (dataModel != 32 && dataModel != 64) {
            switch (CPU.ordinal()) {
                case 0: 
                case 2: 
                case 5: {
                    dataModel = 32;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    dataModel = 64;
                    break;
                }
                default: {
                    dataModel = 0;
                }
            }
        }
        return dataModel;
    }

    protected Platform(OS_TYPE os) {
        this.longSize = os == OS_TYPE.WINDOWS ? 32 : this.addressSize;
        this.libPattern = Pattern.compile(switch (os.ordinal()) {
            case 8 -> ".*\\.dll$";
            case 0 -> "lib.*\\.(dylib|jnilib)$";
            case 7 -> "lib.*\\.a$";
            default -> "lib.*\\.so.*$";
        });
    }

    public static final Platform getPlatform() {
        return SingletonHolder.PLATFORM;
    }

    public final OS_TYPE getOS() {
        return OS;
    }

    public final CPU_TYPE getCPU() {
        return CPU;
    }

    @Deprecated(since="9.4.6.0")
    public final int getJavaMajorVersion() {
        return org.jruby.platform.Platform.JAVA_VERSION;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBSD() {
        if (OS == OS_TYPE.FREEBSD) return true;
        if (OS == OS_TYPE.OPENBSD) return true;
        if (OS == OS_TYPE.NETBSD) return true;
        if (OS == OS_TYPE.DARWIN) return true;
        if (OS != OS_TYPE.DRAGONFLYBSD) return false;
        return true;
    }

    public final boolean isUnix() {
        return OS != OS_TYPE.WINDOWS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSupported() {
        if (OS == OS_TYPE.UNKNOWN) return false;
        if (CPU == CPU_TYPE.UNKNOWN) return false;
        if (this.addressSize == 32) return true;
        if (this.addressSize != 64) return false;
        return true;
    }

    public static void createPlatformModule(ThreadContext context, RubyModule FFI2) {
        Platform platform = Platform.getPlatform();
        Object module = ((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)FFI2.defineModuleUnder(context, "Platform").defineMethods(context, Platform.class)).defineConstant(context, "ADDRESS_SIZE", Convert.asFixnum(context, platform.addressSize))).defineConstant(context, "LONG_SIZE", Convert.asFixnum(context, platform.longSize))).defineConstant(context, "LONG_DOUBLE_SIZE", Convert.asFixnum(context, 128))).defineConstant(context, "BYTE_ORDER", Convert.asFixnum(context, BYTE_ORDER))).defineConstant(context, "BIG_ENDIAN", Convert.asFixnum(context, 4321))).defineConstant(context, "LITTLE_ENDIAN", Convert.asFixnum(context, 1234));
        if (OS == OS_TYPE.LINUX) {
            ((RubyModule)module).defineConstant(context, "GNU_LIBC", Create.newString(context, LIBC));
        }
    }

    @JRubyMethod(name={"windows?"}, module=true)
    public static IRubyObject windows_p(ThreadContext context, IRubyObject recv2) {
        return Convert.asBoolean(context, OS == OS_TYPE.WINDOWS);
    }

    @JRubyMethod(name={"mac?"}, module=true)
    public static IRubyObject mac_p(ThreadContext context, IRubyObject recv2) {
        return Convert.asBoolean(context, OS == OS_TYPE.DARWIN);
    }

    @JRubyMethod(name={"unix?"}, module=true)
    public static IRubyObject unix_p(ThreadContext context, IRubyObject recv2) {
        return Convert.asBoolean(context, Platform.getPlatform().isUnix());
    }

    @JRubyMethod(name={"bsd?"}, module=true)
    public static IRubyObject bsd_p(ThreadContext context, IRubyObject recv2) {
        return Convert.asBoolean(context, Platform.getPlatform().isBSD());
    }

    @JRubyMethod(name={"linux?"}, module=true)
    public static IRubyObject linux_p(ThreadContext context, IRubyObject recv2) {
        return Convert.asBoolean(context, OS == OS_TYPE.LINUX);
    }

    @JRubyMethod(name={"solaris?"}, module=true)
    public static IRubyObject solaris_p(ThreadContext context, IRubyObject recv2) {
        return Convert.asBoolean(context, OS == OS_TYPE.SOLARIS);
    }

    public static String getProperty(String property, String defValue) {
        try {
            return System.getProperty(property, defValue);
        }
        catch (SecurityException se) {
            return defValue;
        }
    }

    public final int longSize() {
        return this.longSize;
    }

    public final int addressSize() {
        return this.addressSize;
    }

    public final long addressMask() {
        return this.addressMask;
    }

    public String getName() {
        return String.valueOf((Object)CPU) + "-" + String.valueOf((Object)OS);
    }

    public String mapLibraryName(String libName) {
        if (this.libPattern.matcher(libName).find()) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    private static boolean startsWithIgnoreCase(String s1, String s2) {
        return s1.startsWith(s2) || s1.toUpperCase(LOCALE).startsWith(s2.toUpperCase(LOCALE)) || s1.toLowerCase(LOCALE).startsWith(s2.toLowerCase(LOCALE));
    }

    public static enum OS_TYPE {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        DRAGONFLYBSD,
        LINUX,
        SOLARIS,
        AIX,
        WINDOWS,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }

    private static final class Darwin
    extends Supported {
        public Darwin() {
            super(OS_TYPE.DARWIN);
        }

        @Override
        public String mapLibraryName(String libName) {
            if (this.libPattern.matcher(libName).find()) {
                return libName;
            }
            return "lib" + libName + ".dylib";
        }
    }

    private static final class Linux
    extends Supported {
        public Linux() {
            super(OS_TYPE.LINUX);
        }

        @Override
        public String mapLibraryName(String libName) {
            return "c".equals(libName) || "libc.so".equals(libName) ? "libc.so.6" : super.mapLibraryName(libName);
        }
    }

    private static final class AIX
    extends Supported {
        public AIX() {
            super(OS_TYPE.AIX);
        }

        @Override
        public String mapLibraryName(String libName) {
            return "c".equals(libName) || "libc.so".equals(libName) ? LIBC : super.mapLibraryName(libName);
        }
    }

    private static class Windows
    extends Supported {
        public Windows() {
            super(OS_TYPE.WINDOWS);
        }
    }

    private static class Unsupported
    extends Platform {
        public Unsupported(OS_TYPE os) {
            super(os);
        }
    }

    private static final class Default
    extends Platform {
        public Default(OS_TYPE os) {
            super(os);
        }
    }

    public static enum CPU_TYPE {
        I386,
        X86_64,
        POWERPC,
        POWERPC64,
        POWERPC64LE,
        SPARC,
        SPARCV9,
        S390X,
        ARM,
        AARCH64,
        LOONGARCH64,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }

    private static final class SingletonHolder {
        private static final Platform PLATFORM = Platform.determinePlatform(Platform.determineOS());

        private SingletonHolder() {
        }
    }

    private static class Supported
    extends Platform {
        public Supported(OS_TYPE os) {
            super(os);
        }
    }
}

