/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jruby.EvalType;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyData;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.RecursiveComparator;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Struct"})
public class RubyStruct
extends RubyObject {
    public static final String NO_MEMBER_IN_STRUCT = "no member '%1$s' in struct";
    public static final String IDENTIFIER_NEEDS_TO_BE_CONSTANT = "identifier %1$s needs to be constant";
    public static final String UNINITIALIZED_CONSTANT = "uninitialized constant %1$s";
    private static final String KEYWORD_INIT_VAR = "__keyword_init__";
    private static final String SIZE_VAR = "__size__";
    public static final String MEMBER_VAR = "__member__";
    private final IRubyObject[] values;
    private static final byte[] STRUCT_BEG = new byte[]{35, 60, 115, 116, 114, 117, 99, 116, 32};
    private static final byte[] STRUCT_END = new byte[]{58, 46, 46, 46, 62};

    private RubyStruct(Ruby runtime2, RubyClass rubyClass) {
        this(runtime2.getCurrentContext(), rubyClass);
    }

    public RubyStruct(ThreadContext context, RubyClass rubyClass) {
        super(context.runtime, rubyClass);
        int size2 = Convert.toInt(context, RubyStruct.getInternalVariable(context, rubyClass, SIZE_VAR));
        this.values = new IRubyObject[size2];
        Helpers.fillNil(context, this.values);
    }

    public static RubyClass createStructClass(ThreadContext context, RubyClass Object2, RubyModule Enumerable) {
        return (RubyClass)((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "Struct", Object2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR).reifiedClass(RubyStruct.class)).classIndex(ClassIndex.STRUCT)).include(context, Enumerable)).defineMethods(context, RubyStruct.class);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.STRUCT;
    }

    private static IRubyObject getInternalVariable(ThreadContext context, RubyClass type2, String internedName) {
        RubyClass structClass = Access.structClass(context);
        while (type2 != null && type2 != structClass) {
            IRubyObject variable = (IRubyObject)type2.getInternalVariable(internedName);
            if (variable != null) {
                return variable;
            }
            type2 = type2.getSuperClass();
        }
        return context.nil;
    }

    private RubyClass classOf() {
        RubyClass metaClass = this.getMetaClass();
        return metaClass instanceof MetaClass ? metaClass.getSuperClass() : metaClass;
    }

    private void modify(ThreadContext context) {
        this.testFrozen();
    }

    @JRubyMethod
    public IRubyObject deconstruct_keys(ThreadContext context, IRubyObject keysArg) {
        if (keysArg.isNil()) {
            return this.to_h(context, Block.NULL_BLOCK);
        }
        if (!(keysArg instanceof RubyArray)) {
            throw Error.typeError(context, keysArg, "Array or nil");
        }
        RubyArray keys2 = (RubyArray)keysArg;
        int length2 = keys2.size();
        RubyHash hash2 = Create.newSmallHash(context);
        if (this.values.length < length2) {
            return hash2;
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            Object key2 = keys2.eltOk(i2);
            try {
                hash2.op_aset(context, (IRubyObject)key2, this.aref(context, (IRubyObject)key2));
                continue;
            }
            catch (RaiseException e) {
                break;
            }
        }
        return hash2;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        int h = this.getType().hashCode();
        IRubyObject[] values2 = this.values;
        for (int i2 = 0; i2 < values2.length; ++i2) {
            h = h << 1 | (h < 0 ? 1 : 0);
            IRubyObject hash2 = context.safeRecurse((ctx, runtime1, obj, recur) -> recur ? Convert.asFixnum(ctx, 0) : Helpers.invokedynamic(ctx, obj, MethodNames.HASH), context.runtime, values2[i2], "hash", true);
            h = (int)((long)h ^ Convert.toLong(context, hash2));
        }
        return Convert.asFixnum(context, h);
    }

    private IRubyObject setByName(ThreadContext context, String name2, IRubyObject value2) {
        RubyArray member = this.__member__(context);
        this.modify(context);
        for (int i2 = 0; i2 < member.getLength(); ++i2) {
            if (!member.eltInternal(i2).asJavaString().equals(name2)) continue;
            this.values[i2] = value2;
            return this.values[i2];
        }
        return null;
    }

    private IRubyObject getByName(ThreadContext context, String name2) {
        RubyArray member = this.__member__(context);
        for (int i2 = 0; i2 < member.getLength(); ++i2) {
            if (!member.eltInternal(i2).asJavaString().equals(name2)) continue;
            return this.values[i2];
        }
        return null;
    }

    private static IRubyObject extractKeywordArg(ThreadContext context, RubyHash options2, String validKey) {
        if (options2.isEmpty()) {
            return null;
        }
        RubySymbol testKey = Convert.asSymbol(context, validKey);
        IRubyObject ret = options2.fastARef(testKey);
        if (ret == null || options2.size() > 1) {
            options2.visitAll(context, (ctxt, self2, key2, value2, index2) -> {
                if (!key2.equals(testKey)) {
                    throw Error.typeError(ctxt, "unknown keyword: " + String.valueOf(key2.inspect(ctxt)));
                }
            });
        }
        return ret;
    }

    @Deprecated(since="10.0.0.0")
    public static RubyClass newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyStruct.newInstance(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2, block);
    }

    @JRubyMethod(name={"new"}, rest=true, checkArity=false, meta=true, keywords=true)
    public static RubyClass newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        int i2;
        Object newStruct2;
        int i3;
        int argc = Arity.checkArgumentCount(context, args2, 0, -1);
        String name2 = null;
        boolean nilName = false;
        RubyArray<?> member = Create.newArray(context);
        IRubyObject keywordInitValue = context.nil;
        if (argc > 0) {
            IRubyObject firstArgAsString = args2[0].checkStringType();
            if (!firstArgAsString.isNil()) {
                RubySymbol nameSym = ((RubyString)firstArgAsString).intern(context);
                if (!nameSym.validConstantName()) {
                    throw context.runtime.newNameError(IDENTIFIER_NEEDS_TO_BE_CONSTANT, recv2, nameSym.toString());
                }
                name2 = nameSym.idString();
            } else if (args2[0].isNil()) {
                nilName = true;
            }
            IRubyObject opts = args2[argc - 1];
            if (opts instanceof RubyHash) {
                --argc;
                keywordInitValue = RubyStruct.extractKeywordArg(context, (RubyHash)opts, "keyword_init");
            }
        }
        HashSet<RubySymbol> tmpMemberSet = new HashSet<RubySymbol>();
        int n = i3 = name2 == null && !nilName ? 0 : 1;
        while (i3 < argc) {
            RubySymbol sym1;
            IRubyObject arg2 = args2[i3];
            RubySymbol sym = arg2 instanceof RubySymbol ? (sym1 = (RubySymbol)arg2) : (arg2 instanceof RubyString ? Convert.asSymbol(context, arg2.convertToString().getByteList()) : Convert.asSymbol(context, arg2.asJavaString()));
            if (tmpMemberSet.contains(sym)) {
                throw Error.argumentError(context, "duplicate member: " + String.valueOf(sym));
            }
            tmpMemberSet.add(sym);
            member.append(context, sym);
            ++i3;
        }
        RubyClass superClass = (RubyClass)recv2;
        if (name2 == null || nilName) {
            newStruct2 = RubyClass.newClass(context, superClass, null).allocator(RubyStruct::new);
            ((RubyBasicObject)newStruct2).makeMetaClass(context, superClass.metaClass);
            superClass.invokeInherited(context, superClass, (IRubyObject)newStruct2);
        } else {
            IRubyObject type2 = superClass.getConstantAt(context, name2);
            if (type2 != null) {
                context.runtime.getWarnings().warn(IRubyWarnings.ID.STRUCT_CONSTANT_REDEFINED, context.getFile(), context.getLine(), "redefining constant " + String.valueOf(type2));
                superClass.deleteConstant(context, name2);
            }
            newStruct2 = superClass.defineClassUnder(context, name2, superClass, RubyStruct::new);
        }
        ((RubyModule)((RubyClass)newStruct2).reifiedClass(RubyStruct.class)).classIndex(ClassIndex.STRUCT);
        ((RubyBasicObject)newStruct2).setInternalVariable(SIZE_VAR, member.length(context));
        ((RubyBasicObject)newStruct2).setInternalVariable(MEMBER_VAR, member);
        ((RubyBasicObject)newStruct2).setInternalVariable(KEYWORD_INIT_VAR, keywordInitValue);
        ((RubyBasicObject)newStruct2).singletonClass(context).defineMethods(context, StructMethods.class);
        int n2 = i2 = name2 == null && !nilName ? 0 : 1;
        while (!(i2 >= argc || i2 == argc - 1 && args2[i2] instanceof RubyHash)) {
            String memberName = args2[i2].asJavaString();
            int index2 = name2 == null && !nilName ? i2 : i2 - 1;
            ((RubyModule)newStruct2).addMethod(context, memberName, new Accessor((RubyClass)newStruct2, memberName, index2));
            String nameAsgn = memberName + "=";
            ((RubyModule)newStruct2).addMethod(context, nameAsgn, new Mutator((RubyClass)newStruct2, nameAsgn, index2));
            ++i2;
        }
        if (block.isGiven()) {
            block = block.cloneBlockForEval((IRubyObject)newStruct2, EvalType.MODULE_EVAL);
            block.getBinding().setVisibility(Visibility.PUBLIC);
            block.yieldNonArray(context, (IRubyObject)newStruct2, (IRubyObject)newStruct2);
        }
        return newStruct2;
    }

    @Deprecated(since="10.0.0.0")
    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return Create.newStruct(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2, args2, block);
    }

    @Deprecated(since="10.0.0.0")
    public static RubyStruct newStruct(IRubyObject recv2, Block block) {
        return Create.newStruct(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2, block);
    }

    @Deprecated(since="10.0.0.0")
    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject arg0, Block block) {
        return Create.newStruct(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2, arg0, block);
    }

    @Deprecated(since="10.0.0.0")
    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Create.newStruct(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2, arg0, arg1, block);
    }

    @Deprecated(since="10.0.0.0")
    public static RubyStruct newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Create.newStruct(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2, arg0, arg1, arg2, block);
    }

    private void checkSize(ThreadContext context, int length2) {
        if (length2 > this.values.length) {
            throw Error.argumentError(context, "struct size differs (" + length2 + " for " + this.values.length + ")");
        }
    }

    private void checkForKeywords(ThreadContext context, boolean keywordInit) {
        if (ThreadContext.hasKeywords(ThreadContext.resetCallInfo(context)) && !keywordInit) {
            Warn.warn(context, "Passing only keyword arguments to Struct#initialize will behave differently from Ruby 3.2. Please use a Hash literal like .new({k: v}) instead of .new(k: v).");
        }
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE, keywords=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        IRubyObject keywordInit = RubyStruct.getInternalVariable(context, this.classOf(), KEYWORD_INIT_VAR);
        this.checkForKeywords(context, !keywordInit.isNil());
        ThreadContext.resetCallInfo(context);
        this.modify(context);
        this.checkSize(context, args2.length);
        if (keywordInit.isTrue()) {
            if (args2.length != 1) {
                throw Error.argumentError(context, args2.length, 0);
            }
            return this.initialize(context, args2[0]);
        }
        System.arraycopy(args2, 0, this.values, 0, args2.length);
        Helpers.fillNil(context, this.values, args2.length, this.values.length);
        return context.nil;
    }

    private IRubyObject setupStructValuesFromHash(ThreadContext context, RubyHash kwArgs) {
        RubyArray __members__ = this.__member__(context);
        Set entries2 = kwArgs.directEntrySet();
        entries2.stream().forEach(entry -> {
            IRubyObject index2;
            IRubyObject key2 = (IRubyObject)entry.getKey();
            if (!(key2 instanceof RubySymbol)) {
                key2 = Convert.asSymbol(context, key2.convertToString().getByteList());
            }
            if ((index2 = __members__.index(context, key2)).isNil()) {
                throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "unknown keywords: ", key2));
            }
            this.values[Convert.toInt((ThreadContext)context, (IRubyObject)index2)] = (IRubyObject)entry.getValue();
        });
        return context.nil;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        IRubyObject nil = context.nil;
        return this.initializeInternal(context, 0, nil, nil, nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0) {
        boolean keywords = ThreadContext.hasKeywords(ThreadContext.resetCallInfo(context));
        if (keywords) {
            return this.setupStructValuesFromHash(context, (RubyHash)arg0);
        }
        if (RubyStruct.getInternalVariable(context, this.classOf(), KEYWORD_INIT_VAR).isTrue()) {
            if (!(arg0 instanceof RubyHash)) {
                throw Error.argumentError(context, 1, 0);
            }
            RubyHash hash2 = (RubyHash)arg0;
            return this.setupStructValuesFromHash(context, hash2);
        }
        return this.initializeInternal(context, 1, arg0, context.nil, context.nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject keywordInit = RubyStruct.getInternalVariable(context, this.classOf(), KEYWORD_INIT_VAR);
        if (keywordInit.isTrue()) {
            throw Error.argumentError(context, 2, 0);
        }
        return this.initializeInternal(context, 2, arg0, arg1, context.nil);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject keywordInit = RubyStruct.getInternalVariable(context, this.classOf(), KEYWORD_INIT_VAR);
        if (keywordInit.isTrue()) {
            throw Error.argumentError(context, 3, 0);
        }
        return this.initializeInternal(context, 3, arg0, arg1, arg2);
    }

    public IRubyObject initializeInternal(ThreadContext context, int provided, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.modify(context);
        this.checkSize(context, provided);
        switch (provided) {
            case 3: {
                this.values[2] = arg2;
            }
            case 2: {
                this.values[1] = arg1;
            }
            case 1: {
                this.values[0] = arg0;
            }
        }
        if (provided < this.values.length) {
            Helpers.fillNil(context, this.values, provided, this.values.length);
        }
        return context.nil;
    }

    static RubyArray members(ThreadContext context, RubyClass type2) {
        RubyArray member = RubyStruct.__member__(context, type2);
        int len = member.getLength();
        IRubyObject[] result2 = new IRubyObject[len];
        for (int i2 = 0; i2 < len; ++i2) {
            result2[i2] = member.eltInternal(i2);
        }
        return RubyArray.newArrayNoCopy(context.runtime, result2);
    }

    @Deprecated(since="9.4-")
    public static RubyArray members(IRubyObject recv2, Block block) {
        return RubyStruct.members(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2);
    }

    private static RubyArray __member__(ThreadContext context, RubyClass clazz) {
        RubyArray member = (RubyArray)RubyStruct.getInternalVariable(context, clazz, MEMBER_VAR);
        assert (!member.isNil()) : "uninitialized struct";
        return member;
    }

    private RubyArray __member__(ThreadContext context) {
        return RubyStruct.__member__(context, this.classOf());
    }

    @Deprecated(since="10.0.0.0")
    public RubyArray members() {
        return this.members(this.getCurrentContext());
    }

    @JRubyMethod(name={"members"})
    public RubyArray members(ThreadContext context) {
        return RubyStruct.members(context, this.classOf());
    }

    @JRubyMethod
    public IRubyObject select(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorizeWithSize(context, this, "select", RubyStruct::size);
        }
        RubyArray<?> array2 = Create.newArray(context);
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            if (!block.yield(context, this.values[i2]).isTrue()) continue;
            array2.append(context, this.values[i2]);
        }
        return array2;
    }

    private static IRubyObject size(ThreadContext context, RubyStruct recv2, IRubyObject[] args2) {
        return recv2.size(context);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject set(IRubyObject value2, int index2) {
        return this.set(this.getCurrentContext(), value2, index2);
    }

    private IRubyObject set(ThreadContext context, IRubyObject value2, int index2) {
        this.modify(context);
        this.values[index2] = value2;
        return this.values[index2];
    }

    private RaiseException notStructMemberError(ThreadContext context, IRubyObject name2) {
        return context.runtime.newNameError(NO_MEMBER_IN_STRUCT, (IRubyObject)this, name2);
    }

    public final IRubyObject get(int index2) {
        return this.values[index2];
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        RubyStruct struct = (RubyStruct)clone2;
        System.arraycopy(this.values, 0, struct.values, 0, this.values.length);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        if (!(other instanceof RubyStruct)) {
            return context.fals;
        }
        if (this.getType() != other.getType()) {
            return context.fals;
        }
        if (other == this) {
            return context.tru;
        }
        return RecursiveComparator.compare(context, RubyStruct.sites((ThreadContext)context).op_equal, this, other, true);
    }

    @Override
    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        if (!(other instanceof RubyStruct)) {
            return context.fals;
        }
        if (this.metaClass != RubyStruct.getMetaClass(other)) {
            return context.fals;
        }
        return RecursiveComparator.compare(context, RubyStruct.sites((ThreadContext)context).eql, this, other, true);
    }

    public RubyBoolean compare(ThreadContext context, CallSite site, IRubyObject other) {
        if (!(other instanceof RubyStruct)) {
            return context.fals;
        }
        RubyStruct struct = (RubyStruct)other;
        if (this.values.length != struct.values.length) {
            return context.fals;
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            IRubyObject b2;
            IRubyObject a = this.aref(context, i2);
            if (site.call(context, a, a, b2 = struct.aref(context, i2)).isTrue()) continue;
            return context.fals;
        }
        return context.tru;
    }

    private RubyString inspectStruct(ThreadContext context, boolean recur) {
        RubyString buffer = Create.newString(context, new ByteList(32));
        buffer.cat(STRUCT_BEG);
        String cname = this.getMetaClass().getRealClass().getName(context);
        char first2 = cname.charAt(0);
        if (recur || first2 != '#') {
            buffer.cat(cname.getBytes());
        }
        if (recur) {
            return buffer.cat(STRUCT_END);
        }
        RubyArray member = this.__member__(context);
        for (int i2 = 0; i2 < member.getLength(); ++i2) {
            if (i2 > 0) {
                buffer.cat(44).cat(32);
            } else if (first2 != '#') {
                buffer.cat(32);
            }
            RubySymbol slot = (RubySymbol)member.eltInternal(i2);
            if (slot.validLocalVariableName() || slot.validConstantName()) {
                buffer.catWithCodeRange(RubyString.objAsString(context, slot));
            } else {
                buffer.catWithCodeRange((RubyString)slot.inspect(context));
            }
            buffer.cat(61);
            buffer.catWithCodeRange(RubyStruct.inspect(context, this.values[i2]));
        }
        buffer.cat(62);
        return buffer;
    }

    @Override
    @JRubyMethod(name={"inspect", "to_s"})
    public RubyString inspect(ThreadContext context) {
        return (RubyString)context.safeRecurse((ctx, self2, obj, recur) -> self2.inspectStruct(ctx, recur), this, this, "inspect", false);
    }

    @Override
    @JRubyMethod(name={"to_a", "deconstruct", "values"})
    public RubyArray to_a(ThreadContext context) {
        return Create.newArray(context, this.values);
    }

    @Deprecated(since="9.3.0.0")
    public RubyHash to_h(ThreadContext context) {
        return this.to_h(context, Block.NULL_BLOCK);
    }

    @JRubyMethod
    public RubyHash to_h(ThreadContext context, Block block) {
        RubyHash hash2 = Create.newHash(context);
        RubyArray members2 = this.__member__(context);
        if (block.isGiven()) {
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                IRubyObject elt = block.yieldValues(context, new IRubyObject[]{members2.eltOk(i2), this.values[i2]});
                IRubyObject keyValue = elt.checkArrayType();
                if (keyValue == context.nil) {
                    throw Error.typeError(context, "wrong element type ", elt, " at " + i2 + " (expected array)");
                }
                RubyArray ary = (RubyArray)keyValue;
                if (ary.getLength() != 2) {
                    throw Error.argumentError(context, "element has wrong array length (expected 2, was " + ary.getLength() + ")");
                }
                hash2.op_aset(context, (IRubyObject)ary.eltInternal(0), (IRubyObject)ary.eltInternal(1));
            }
        } else {
            for (int i3 = 0; i3 < this.values.length; ++i3) {
                hash2.op_aset(context, (IRubyObject)members2.eltOk(i3), this.values[i3]);
            }
        }
        return hash2;
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum size(ThreadContext context) {
        return Convert.asFixnum(context, this.values.length);
    }

    @Deprecated(since="10.0.0.0")
    public RubyFixnum size() {
        return this.size(this.getCurrentContext());
    }

    public IRubyObject eachInternal(ThreadContext context, Block block) {
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            block.yield(context, this.values[i2]);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each(ThreadContext context, Block block) {
        return block.isGiven() ? this.eachInternal(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each", RubyStruct::size);
    }

    public IRubyObject each_pairInternal(ThreadContext context, Block block) {
        RubyArray member = this.__member__(context);
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            block.yield(context, Create.newArray(context, member.eltInternal(i2), this.values[i2]));
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject each_pair(ThreadContext context, Block block) {
        return block.isGiven() ? this.each_pairInternal(context, block) : RubyEnumerator.enumeratorizeWithSize(context, this, "each_pair", RubyStruct::size);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject aref(IRubyObject key2) {
        return this.aref(this.getCurrentContext(), key2);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject aref(ThreadContext context, IRubyObject key2) {
        return this.arefImpl(context, key2, false);
    }

    private IRubyObject arefImpl(ThreadContext context, IRubyObject key2, boolean nilOnNoMember) {
        if (key2 instanceof RubyString || key2 instanceof RubySymbol) {
            String name2 = key2.asJavaString();
            IRubyObject value2 = this.getByName(context, name2);
            if (value2 == null) {
                if (nilOnNoMember) {
                    return context.nil;
                }
                throw this.notStructMemberError(context, key2);
            }
            return value2;
        }
        return this.aref(context, Convert.toInt(context, key2));
    }

    @Deprecated(since="10.0.0.0")
    final IRubyObject aref(int idx) {
        return this.aref(this.getCurrentContext(), idx);
    }

    private static void checkIndexBounds(ThreadContext context, int i2, int index2, int length2) {
        if (i2 < 0) {
            throw Error.indexError(context, "offset " + index2 + " too small for struct(size:" + length2 + ")");
        }
        if (i2 >= length2) {
            throw Error.indexError(context, "offset " + index2 + " too large for struct(size:" + length2 + ")");
        }
    }

    final IRubyObject aref(ThreadContext context, int originalIndex) {
        int index2 = originalIndex < 0 ? this.values.length + originalIndex : originalIndex;
        RubyStruct.checkIndexBounds(context, index2, originalIndex, this.values.length);
        return this.values[index2];
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject aset(IRubyObject key2, IRubyObject value2) {
        return this.aset(this.getCurrentContext(), key2, value2);
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        if (key2 instanceof RubyString || key2 instanceof RubySymbol) {
            String name2 = key2.asJavaString();
            IRubyObject val = this.setByName(context, name2, value2);
            if (val == null) {
                throw this.notStructMemberError(context, key2);
            }
            return value2;
        }
        return this.aset(context, Convert.toInt(context, key2), value2);
    }

    private IRubyObject aset(ThreadContext context, int originalIndex, IRubyObject value2) {
        int index2 = originalIndex < 0 ? this.values.length + originalIndex : originalIndex;
        RubyStruct.checkIndexBounds(context, index2, originalIndex, this.values.length);
        this.modify(context);
        this.values[index2] = value2;
        return this.values[index2];
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject values_at(IRubyObject[] args2) {
        return this.values_at(this.getCurrentContext(), args2);
    }

    @JRubyMethod(rest=true)
    public IRubyObject values_at(ThreadContext context, IRubyObject[] args2) {
        int olen = this.values.length;
        RubyArray<?> result2 = Create.allocArray(context, args2.length);
        for (int i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject arg2 = args2[i2];
            if (arg2 instanceof RubyFixnum) {
                result2.append(context, this.aref(context, arg2));
                continue;
            }
            int[] begLen = new int[2];
            if (arg2 instanceof RubyRange && RubyRange.rangeBeginLength(context, args2[i2], olen, begLen, 1).isTrue()) {
                int j;
                int beg = begLen[0];
                int len = begLen[1];
                int end2 = Math.min(olen, beg + len);
                for (j = beg; j < end2; ++j) {
                    result2.push(context, this.aref(context, j));
                }
                if (beg + len <= j) continue;
                IRubyObject[] tmp = new IRubyObject[beg + len - j];
                Helpers.fillNil(context, tmp);
                result2.push(context, tmp);
                continue;
            }
            result2.push(context, this.aref(context, Convert.toInt(context, arg2)));
        }
        return result2;
    }

    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0) {
        return this.arefImpl(context, arg0, true);
    }

    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject val = this.arefImpl(context, arg0, true);
        return RubyObject.dig1(context, val, arg1);
    }

    @JRubyMethod(name={"dig"})
    public IRubyObject dig(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject val = this.arefImpl(context, arg0, true);
        return RubyObject.dig2(context, val, arg1, arg2);
    }

    @JRubyMethod(name={"dig"}, required=1, rest=true, checkArity=false)
    public IRubyObject dig(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        IRubyObject val = this.arefImpl(context, args2[0], true);
        return argc == 1 ? val : RubyObject.dig(context, val, args2, 1);
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static void marshalTo(RubyStruct struct, MarshalStream output) throws IOException {
        ThreadContext context = struct.getRuntime().getCurrentContext();
        output.registerLinkTarget(context, struct);
        output.dumpDefaultObjectHeader(context, 'S', struct.getMetaClass());
        RubyArray member = RubyStruct.__member__(context, struct.classOf());
        output.writeInt(member.size());
        for (int i2 = 0; i2 < member.size(); ++i2) {
            RubySymbol name2 = (RubySymbol)member.eltInternal(i2);
            output.dumpObject(name2);
            output.dumpObject(struct.values[i2]);
        }
    }

    public static void marshalTo(ThreadContext context, RubyOutputStream out, RubyStruct struct, MarshalDumper output) {
        output.registerLinkTarget(struct);
        output.dumpDefaultObjectHeader(context, out, 'S', struct.getMetaClass());
        RubyArray member = RubyStruct.__member__(context, struct.classOf());
        output.writeInt(out, member.size());
        for (int i2 = 0; i2 < member.size(); ++i2) {
            RubySymbol name2 = (RubySymbol)member.eltInternal(i2);
            output.dumpObject(context, out, name2);
            output.dumpObject(context, out, struct.values[i2]);
        }
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static IRubyObject unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol className;
        Ruby runtime2 = input.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        RubyClass rbClass = RubyStruct.pathToClass(context, (className = input.unique()).asJavaString());
        if (rbClass == null) {
            throw runtime2.newNameError(UNINITIALIZED_CONSTANT, (IRubyObject)Access.structClass(context), className);
        }
        RubyArray member = RubyStruct.__member__(context, rbClass);
        int len = input.unmarshalInt();
        RubyStruct result2 = (RubyStruct)input.entry(new RubyStruct(context, rbClass));
        for (int i2 = 0; i2 < len; ++i2) {
            RubySymbol slot = input.symbol();
            RubySymbol elem = (RubySymbol)member.eltInternal(i2);
            if (!elem.equals(slot)) {
                throw Error.typeError(context, RubyStringBuilder.str(runtime2, "struct ", rbClass, " not compatible (:", slot, " for :", elem, ")").toString());
            }
            result2.aset(context, i2, input.unmarshalObject());
        }
        return result2;
    }

    public static IRubyObject unmarshalFrom(ThreadContext context, RubyInputStream in, MarshalLoader input) {
        Ruby runtime2 = context.runtime;
        RubySymbol className = input.unique(context, in);
        RubyClass rbClass = RubyStruct.pathToClass(context, className.asJavaString());
        if (rbClass == null) {
            throw runtime2.newNameError(UNINITIALIZED_CONSTANT, (IRubyObject)Access.structClass(context), className);
        }
        if (rbClass.isKindOfModule(runtime2.getData())) {
            return RubyData.unmarshalFrom(context, in, input, rbClass);
        }
        RubyArray member = RubyStruct.__member__(context, rbClass);
        int len = input.unmarshalInt(context, in);
        RubyStruct result2 = (RubyStruct)input.entry(new RubyStruct(context, rbClass));
        for (int i2 = 0; i2 < len; ++i2) {
            RubySymbol slot = input.symbol(context, in);
            RubySymbol elem = (RubySymbol)member.eltInternal(i2);
            if (!elem.equals(slot)) {
                throw Error.typeError(context, RubyStringBuilder.str(runtime2, "struct ", rbClass, " not compatible (:", slot, " for :", elem, ")").toString());
            }
            result2.aset(context, i2, input.unmarshalObject(context, in));
        }
        return result2;
    }

    static RubyClass pathToClass(ThreadContext context, String path2) {
        return (RubyClass)context.runtime.getClassFromPath(path2);
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject arg2) {
        if (this == arg2) {
            return this;
        }
        RubyStruct original = (RubyStruct)arg2;
        this.checkFrozen();
        System.arraycopy(original.values, 0, this.values, 0, original.values.length);
        return this;
    }

    private static JavaSites.StructSites sites(ThreadContext context) {
        return context.sites.Struct;
    }

    @Override
    @Deprecated(since="9.4-")
    public RubyArray to_a() {
        return this.to_a(this.getCurrentContext());
    }

    public static class StructMethods {
        @Deprecated(since="10.0.0.0")
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject[] args2, Block block) {
            return Create.newStruct(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2, args2, block);
        }

        @JRubyMethod(name={"new", "[]"}, rest=true, keywords=true)
        public static IRubyObject newStruct(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
            return Create.newStruct(context, (RubyClass)recv2, args2, block);
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject newStruct(IRubyObject recv2, Block block) {
            return Create.newStruct(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2, block);
        }

        @JRubyMethod(name={"new", "[]"}, keywords=true)
        public static IRubyObject newStruct(ThreadContext context, IRubyObject recv2, Block block) {
            return Create.newStruct(context, (RubyClass)recv2, block);
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject arg0, Block block) {
            return Create.newStruct(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2, arg0, block);
        }

        @JRubyMethod(name={"new", "[]"}, keywords=true)
        public static IRubyObject newStruct(ThreadContext context, IRubyObject recv2, IRubyObject arg0, Block block) {
            return Create.newStruct(context, (RubyClass)recv2, arg0, block);
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return Create.newStruct(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2, arg0, arg1, block);
        }

        @JRubyMethod(name={"new", "[]"}, keywords=true)
        public static IRubyObject newStruct(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, Block block) {
            return Create.newStruct(context, (RubyClass)recv2, arg0, arg1, block);
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject newStruct(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return Create.newStruct(((RubyBasicObject)recv2).getCurrentContext(), (RubyClass)recv2, arg0, arg1, arg2, block);
        }

        @JRubyMethod(name={"new", "[]"}, keywords=true)
        public static IRubyObject newStruct(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            return Create.newStruct(context, (RubyClass)recv2, arg0, arg1, arg2, block);
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject members(IRubyObject recv2, Block block) {
            return StructMethods.members(((RubyBasicObject)recv2).getCurrentContext(), recv2);
        }

        @JRubyMethod
        public static IRubyObject members(ThreadContext context, IRubyObject recv2) {
            return RubyStruct.members(context, (RubyClass)recv2);
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject inspect(IRubyObject recv2) {
            return StructMethods.inspect(((RubyBasicObject)recv2).getCurrentContext(), recv2);
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext context, IRubyObject recv2) {
            IRubyObject keywordInit = RubyStruct.getInternalVariable(context, (RubyClass)recv2, RubyStruct.KEYWORD_INIT_VAR);
            IRubyObject inspected = recv2.inspect(context);
            if (!keywordInit.isTrue()) {
                return inspected;
            }
            return inspected.convertToString().catString("(keyword_init: true)");
        }

        @Deprecated(since="10.0.0.0")
        public static IRubyObject keyword_init_p(IRubyObject self2) {
            return StructMethods.keyword_init_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"keyword_init?"})
        public static IRubyObject keyword_init_p(ThreadContext context, IRubyObject self2) {
            IRubyObject keywordInit = RubyStruct.getInternalVariable(context, (RubyClass)self2, RubyStruct.KEYWORD_INIT_VAR);
            return keywordInit.isTrue() ? context.tru : keywordInit;
        }
    }

    public static class Accessor
    extends DynamicMethod {
        private final int index;

        public Accessor(RubyClass newStruct2, String name2, int index2) {
            super((RubyModule)newStruct2, Visibility.PUBLIC, name2);
            this.index = index2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            Arity.checkArgumentCount(context, name2, args2, 0, 0);
            return ((RubyStruct)self2).get(this.index);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return ((RubyStruct)self2).get(this.index);
        }

        @Override
        public DynamicMethod dup() {
            return new Accessor((RubyClass)this.getImplementationClass(), this.name, this.index);
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static class Mutator
    extends DynamicMethod {
        private final int index;

        public Mutator(RubyClass newStruct2, String name2, int index2) {
            super((RubyModule)newStruct2, Visibility.PUBLIC, name2);
            this.index = index2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            Arity.checkArgumentCount(context, name2, args2, 1, 1);
            return ((RubyStruct)self2).set(context, args2[0], this.index);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg2) {
            return ((RubyStruct)self2).set(context, arg2, this.index);
        }

        @Override
        public DynamicMethod dup() {
            return new Mutator((RubyClass)this.getImplementationClass(), this.name, this.index);
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static class EqualRecursive
    implements ThreadContext.RecursiveFunctionEx<IRubyObject> {
        private static final EqualRecursive INSTANCE = new EqualRecursive();

        private EqualRecursive() {
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject other, IRubyObject self2, boolean recur) {
            if (recur) {
                return context.tru;
            }
            IRubyObject[] values2 = ((RubyStruct)self2).values;
            IRubyObject[] otherValues = ((RubyStruct)other).values;
            for (int i2 = 0; i2 < values2.length; ++i2) {
                if (RubyObject.equalInternal(context, values2[i2], otherValues[i2])) continue;
                return context.fals;
            }
            return context.tru;
        }
    }

    private static class EqlRecursive
    implements ThreadContext.RecursiveFunctionEx<IRubyObject> {
        static final EqlRecursive INSTANCE = new EqlRecursive();

        private EqlRecursive() {
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject other, IRubyObject self2, boolean recur) {
            if (recur) {
                return context.tru;
            }
            IRubyObject[] values2 = ((RubyStruct)self2).values;
            IRubyObject[] otherValues = ((RubyStruct)other).values;
            for (int i2 = 0; i2 < values2.length; ++i2) {
                if (RubyObject.eqlInternal(context, values2[i2], otherValues[i2])) continue;
                return context.fals;
            }
            return context.tru;
        }
    }
}

