/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.util.function.Function;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.ClassValueCalculator;
import org.jruby.util.collections.Java7ClassValue;
import org.jruby.util.collections.MapBasedClassValue;
import org.jruby.util.collections.StableClassValue;

public abstract class ClassValue<T> {
    protected final ClassValueCalculator<T> calculator;

    public ClassValue(ClassValueCalculator<T> calculator) {
        this.calculator = calculator;
    }

    public abstract T get(Class<?> var1);

    public static <T> ClassValue<T> newInstance(ClassValueCalculator<T> calculator) {
        if (Options.INVOKEDYNAMIC_CLASS_VALUES.load().booleanValue()) {
            return ClassValue.newJava7Instance(calculator);
        }
        return Options.JI_CLASS_VALUES.load().function.apply(calculator);
    }

    @Deprecated(since="9.4.13.0")
    private static <T> ClassValue<T> newJava7Instance(ClassValueCalculator<T> calculator) {
        return new Java7ClassValue<T>(calculator);
    }

    public static enum Type {
        STABLE(StableClassValue::new),
        HARD_MAP(MapBasedClassValue::new),
        HARD_VALUES(Java7ClassValue::new);

        final Function<ClassValueCalculator, ClassValue> function;

        private Type(Function<ClassValueCalculator, ClassValue> function) {
            this.function = function;
        }
    }
}

