/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.invokers;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.api.Error;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.dispatch.CallableSelector;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.IntHashMap;
import org.jruby.util.collections.NonBlockingHashMapLong;

public abstract class RubyToJavaInvoker<T extends JavaCallable>
extends org.jruby.internal.runtime.methods.JavaMethod {
    static final NonBlockingHashMapLong NULL_CACHE = new NullHashMapLong();
    protected T javaCallable;
    protected T[][] javaCallables;
    protected T[] javaVarargsCallables;
    NonBlockingHashMapLong<T> cache;
    volatile boolean initialized;
    private final Ruby runtime;
    private final Supplier<Member[]> members;

    RubyToJavaInvoker(RubyModule host, Supplier<Member[]> members2, String name2) {
        super(host, Visibility.PUBLIC, name2);
        this.runtime = host.getRuntime();
        this.members = members2;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        if (this.initialized) {
            return;
        }
        RubyToJavaInvoker rubyToJavaInvoker = this;
        synchronized (rubyToJavaInvoker) {
            JavaCallable[][] callables;
            int maxArity;
            int minArity;
            JavaCallable callable;
            if (this.initialized) {
                return;
            }
            JavaCallable[] varargsCallables = null;
            int minVarArgsArity = -1;
            Member[] members2 = this.members.get();
            int length2 = members2.length;
            if (length2 == 1) {
                callable = (JavaCallable)this.createCallable(this.runtime, members2[0]);
                maxArity = minArity = callable.getArity();
                if (callable.isVarArgs()) {
                    varargsCallables = this.createCallableArray(callable);
                    minVarArgsArity = this.getMemberArity(members2[0]) - 1;
                }
                callables = null;
                this.cache = NULL_CACHE;
            } else {
                callable = null;
                maxArity = -1;
                minArity = Integer.MAX_VALUE;
                IntHashMap<ArrayList<T>> arityMap = new IntHashMap<ArrayList<T>>(length2, 1.0f);
                ArrayList<T> varArgs = null;
                for (int i2 = 0; i2 < length2; ++i2) {
                    Member method2 = members2[i2];
                    int currentArity = this.getMemberArity(method2);
                    maxArity = Math.max(currentArity, maxArity);
                    minArity = Math.min(currentArity, minArity);
                    T javaMethod = this.createCallable(this.runtime, method2);
                    ArrayList<T> methodsForArity = (ArrayList<T>)arityMap.get(currentArity);
                    if (methodsForArity == null) {
                        methodsForArity = new ArrayList<T>(length2);
                        arityMap.put(currentArity, methodsForArity);
                    }
                    methodsForArity.add(javaMethod);
                    if (!((JavaCallable)javaMethod).isVarArgs()) continue;
                    int usableArity = currentArity - 1;
                    methodsForArity = (ArrayList<T>)arityMap.get(usableArity);
                    if (methodsForArity == null) {
                        methodsForArity = new ArrayList<T>(length2);
                        arityMap.put(usableArity, methodsForArity);
                    }
                    methodsForArity.add(javaMethod);
                    if (varArgs == null) {
                        varArgs = new ArrayList<T>(length2);
                    }
                    varArgs.add(javaMethod);
                    if (minVarArgsArity == -1) {
                        minVarArgsArity = Integer.MAX_VALUE;
                    }
                    minVarArgsArity = Math.min(usableArity, minVarArgsArity);
                }
                callables = this.createCallableArrayArray(maxArity + 1);
                for (IntHashMap.Entry entry : arityMap.entrySet()) {
                    ArrayList methodsForArity = (ArrayList)entry.getValue();
                    JavaCallable[] methodsArray = methodsForArity.toArray(this.createCallableArray(methodsForArity.size()));
                    callables[entry.getKey()] = methodsArray;
                }
                if (varArgs != null) {
                    varargsCallables = varArgs.toArray(this.createCallableArray(varArgs.size()));
                }
                this.cache = new NonBlockingHashMapLong(4, true);
            }
            this.javaCallable = callable;
            this.javaCallables = callables;
            this.javaVarargsCallables = varargsCallables;
            this.setSignature(minArity, maxArity, minVarArgsArity);
            this.setupNativeCall();
            this.initialized = true;
        }
    }

    private void setSignature(int minArity, int maxArity, int minVarArgsArity) {
        if (minVarArgsArity == -1) {
            if (minArity == maxArity) {
                this.setSignature(Signature.from(minArity, 0, 0, 0, 0, Signature.Rest.NONE, -1));
            } else {
                this.setSignature(Signature.from(minArity, maxArity - minArity, 0, 0, 0, Signature.Rest.NONE, -1));
            }
        } else {
            this.setSignature(Signature.from(minVarArgsArity < minArity ? minVarArgsArity : minArity, 0, 0, 0, 0, Signature.Rest.NORM, -1));
        }
    }

    final void setupNativeCall() {
        if (this.javaCallable != null) {
            if (this.javaCallable instanceof JavaMethod) {
                this.setNativeCallIfPublic(((JavaMethod)this.javaCallable).getValue());
            }
        } else {
            Method method2;
            T[] callablesForArity;
            for (int i2 = 0; !(i2 >= this.javaCallables.length || (callablesForArity = this.javaCallables[i2]) != null && callablesForArity.length == 1 && callablesForArity[0] instanceof JavaMethod && this.setNativeCallIfPublic(method2 = ((JavaMethod)callablesForArity[0]).getValue())); ++i2) {
            }
        }
    }

    private boolean setNativeCallIfPublic(Method method2) {
        int mod = method2.getModifiers();
        if (Modifier.isPublic(mod) && Modifier.isPublic(method2.getDeclaringClass().getModifiers())) {
            this.setNativeCall(method2.getDeclaringClass(), method2.getName(), method2.getReturnType(), method2.getParameterTypes(), Modifier.isStatic(mod), true);
            return true;
        }
        return false;
    }

    public final T getSignature(int signatureCode) {
        return (T)((JavaCallable)this.cache.get(signatureCode));
    }

    public final void putSignature(int signatureCode, T callable) {
        this.cache.put(signatureCode, callable);
    }

    protected abstract T createCallable(Ruby var1, Member var2);

    protected abstract T[] createCallableArray(T var1);

    protected abstract T[] createCallableArray(int var1);

    protected abstract T[][] createCallableArrayArray(int var1);

    protected abstract Class[] getMemberParameterTypes(Member var1);

    @Deprecated(since="9.0.3.0")
    protected abstract boolean isMemberVarArgs(Member var1);

    final int getMemberArity(Member member) {
        return this.getMemberParameterTypes(member).length;
    }

    public static Object[] convertArguments(ParameterTypes method2, IRubyObject[] args2) {
        return RubyToJavaInvoker.convertArguments(method2, args2, 0);
    }

    public static Object[] convertArguments(ParameterTypes method2, IRubyObject[] args2, int addSpace) {
        Object[] javaArgs;
        Class<?>[] paramTypes = method2.getParameterTypes();
        int len = args2.length;
        if (method2.isVarArgs()) {
            int last2 = paramTypes.length - 1;
            javaArgs = new Object[last2 + 1 + addSpace];
            for (int i2 = 0; i2 < last2; ++i2) {
                javaArgs[i2] = args2[i2].toJava(paramTypes[i2]);
            }
            javaArgs[last2] = RubyToJavaInvoker.convertVarArgumentsOnly(paramTypes[last2], last2, args2);
        } else {
            javaArgs = new Object[len + addSpace];
            for (int i3 = 0; i3 < len; ++i3) {
                javaArgs[i3] = args2[i3].toJava(paramTypes[i3]);
            }
        }
        return javaArgs;
    }

    public static Object[] convertArguments(ParameterTypes method2, IRubyObject arg0, int addSpace) {
        Object[] javaArgs;
        Class<?>[] paramTypes = method2.getParameterTypes();
        if (method2.isVarArgs()) {
            javaArgs = new Object[1 + addSpace];
            javaArgs[0] = RubyToJavaInvoker.convertVarArgumentsOnly(paramTypes[0], arg0);
        } else {
            javaArgs = new Object[1 + addSpace];
            javaArgs[0] = arg0.toJava(paramTypes[0]);
        }
        return javaArgs;
    }

    private static <T> Object convertVarArgumentsOnly(Class<T> varArrayType, int varStart, IRubyObject[] args2) {
        int varCount = args2.length - varStart;
        if (args2.length == 0 || varCount <= 0) {
            return Array.newInstance(varArrayType.getComponentType(), 0);
        }
        if (varCount == 1 && args2[varStart] instanceof ArrayJavaProxy) {
            return args2[varStart].toJava(varArrayType);
        }
        Class<?> compType = varArrayType.getComponentType();
        Object varArgs = Array.newInstance(compType, varCount);
        if (compType.isPrimitive()) {
            for (int i2 = 0; i2 < varCount; ++i2) {
                Array.set(varArgs, i2, args2[varStart + i2].toJava(compType));
            }
        } else {
            Object[] base = (Object[])varArgs;
            for (int i3 = 0; i3 < varCount; ++i3) {
                base[i3] = args2[varStart + i3].toJava(compType);
            }
        }
        return varArgs;
    }

    private static Object convertVarArgumentsOnly(Class<?> varArrayType, IRubyObject arg0) {
        if (arg0 instanceof ArrayJavaProxy) {
            return arg0.toJava(varArrayType);
        }
        Class<?> compType = varArrayType.getComponentType();
        Object varArgs = Array.newInstance(compType, 1);
        Array.set(varArgs, 0, arg0.toJava(compType));
        return varArgs;
    }

    static JavaProxy castJavaProxy(IRubyObject self2) {
        assert (self2 instanceof JavaProxy) : "Java methods can only be invoked on Java objects; got: " + String.valueOf(self2);
        return (JavaProxy)self2;
    }

    static Object unwrapIfJavaProxy(IRubyObject object) {
        if (object instanceof JavaProxy) {
            return ((JavaProxy)object).getObject();
        }
        return object;
    }

    static <T extends AccessibleObject> T setAccessible(T accessible) {
        if (!Java.isAccessible(accessible) && !Ruby.isSecurityRestricted() && Options.JI_SETACCESSIBLE.load().booleanValue() && accessible instanceof Member) {
            try {
                Java.trySetAccessible(accessible);
            }
            catch (SecurityException securityException) {
            }
            catch (RuntimeException re) {
                RubyToJavaInvoker.rethrowIfNotInaccessibleObject(re);
            }
        }
        return accessible;
    }

    static <T extends AccessibleObject> T[] setAccessible(T[] accessibles) {
        if (!Ruby.isSecurityRestricted() && Options.JI_SETACCESSIBLE.load().booleanValue()) {
            try {
                for (T accessible : accessibles) {
                    if (Java.isAccessible(accessible) || !(accessible instanceof Member)) continue;
                    Java.trySetAccessible(accessible);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (RuntimeException re) {
                RubyToJavaInvoker.rethrowIfNotInaccessibleObject(re);
            }
        }
        return accessibles;
    }

    private static void rethrowIfNotInaccessibleObject(RuntimeException re) {
        if (!re.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
            throw re;
        }
    }

    public T findCallable(IRubyObject self2, String name2, IRubyObject[] args2, int arity2) {
        switch (arity2) {
            case 0: {
                return this.findCallableArityZero(self2, name2);
            }
            case 1: {
                return this.findCallableArityOne(self2, name2, args2[0]);
            }
            case 2: {
                return this.findCallableArityTwo(self2, name2, args2[0], args2[1]);
            }
            case 3: {
                return this.findCallableArityThree(self2, name2, args2[0], args2[1], args2[2]);
            }
            case 4: {
                return this.findCallableArityFour(self2, name2, args2[0], args2[1], args2[2], args2[3]);
            }
        }
        return this.findCallableArityN(self2, name2, args2, arity2);
    }

    protected final T findCallableArityZero(IRubyObject self2, String name2) {
        Object callable = this.javaCallable;
        if (callable == null) {
            T[] callablesForArity;
            if (this.javaCallables.length == 0 || (callablesForArity = this.javaCallables[0]) == null) {
                callable = this.matchVarArgsCallableArityZero(self2);
                if (callable == null) {
                    throw this.newErrorDueNoMatchingCallable(self2, name2);
                }
                return callable;
            }
            callable = CallableSelector.matchingCallableArityZero((Ruby)this.runtime, (RubyToJavaInvoker)this, callablesForArity);
            if (callable == null && (callable = this.matchVarArgsCallableArityZero(self2)) == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, new IRubyObject[0]);
            }
        } else if (!((JavaCallable)callable).isVarArgs()) {
            this.checkCallableArity(callable, 0);
        }
        return callable;
    }

    protected final T findCallableArityOne(IRubyObject self2, String name2, IRubyObject arg0) {
        Object callable = this.javaCallable;
        if (callable == null) {
            T[] callablesForArity;
            if (this.javaCallables.length <= 1 || (callablesForArity = this.javaCallables[1]) == null) {
                callable = this.matchVarArgsCallableArityOne(self2, arg0);
                if (callable == null) {
                    throw Error.argumentError(this.runtime.getCurrentContext(), 1, this.javaCallables.length - 1);
                }
                return callable;
            }
            callable = CallableSelector.matchingCallableArityOne((Ruby)this.runtime, (RubyToJavaInvoker)this, callablesForArity, (IRubyObject)arg0);
            if (callable == null && (callable = this.matchVarArgsCallableArityOne(self2, arg0)) == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, new IRubyObject[]{arg0});
            }
        } else if (!((JavaCallable)callable).isVarArgs()) {
            this.checkCallableArity(callable, 1);
        }
        return callable;
    }

    protected final T findCallableArityTwo(IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1) {
        Object callable = this.javaCallable;
        if (callable == null) {
            T[] callablesForArity;
            if (this.javaCallables.length <= 2 || (callablesForArity = this.javaCallables[2]) == null) {
                callable = this.matchVarArgsCallableArityTwo(self2, arg0, arg1);
                if (callable == null) {
                    throw Error.argumentError(this.runtime.getCurrentContext(), 2, this.javaCallables.length - 1);
                }
                return callable;
            }
            callable = CallableSelector.matchingCallableArityTwo((Ruby)this.runtime, (RubyToJavaInvoker)this, callablesForArity, (IRubyObject)arg0, (IRubyObject)arg1);
            if (callable == null && (callable = this.matchVarArgsCallableArityTwo(self2, arg0, arg1)) == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, new IRubyObject[]{arg0, arg1});
            }
        } else if (!((JavaCallable)callable).isVarArgs()) {
            this.checkCallableArity(callable, 2);
        }
        return callable;
    }

    protected final T findCallableArityThree(IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Object callable = this.javaCallable;
        if (callable == null) {
            T[] callablesForArity;
            if (this.javaCallables.length <= 3 || (callablesForArity = this.javaCallables[3]) == null) {
                callable = this.matchVarArgsCallableArityThree(self2, arg0, arg1, arg2);
                if (callable == null) {
                    throw Error.argumentError(this.runtime.getCurrentContext(), 3, this.javaCallables.length - 1);
                }
                return callable;
            }
            callable = CallableSelector.matchingCallableArityThree((Ruby)this.runtime, (RubyToJavaInvoker)this, callablesForArity, (IRubyObject)arg0, (IRubyObject)arg1, (IRubyObject)arg2);
            if (callable == null && (callable = this.matchVarArgsCallableArityThree(self2, arg0, arg1, arg2)) == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, new IRubyObject[]{arg0, arg1, arg2});
            }
        } else if (!((JavaCallable)callable).isVarArgs()) {
            this.checkCallableArity(callable, 3);
        }
        return callable;
    }

    protected final T findCallableArityFour(IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        Object callable = this.javaCallable;
        if (callable == null) {
            T[] callablesForArity;
            if (this.javaCallables.length <= 4 || (callablesForArity = this.javaCallables[4]) == null) {
                callable = this.matchVarArgsCallableArityFour(self2, arg0, arg1, arg2, arg3);
                if (callable == null) {
                    throw Error.argumentError(this.runtime.getCurrentContext(), 4, this.javaCallables.length - 1);
                }
                return callable;
            }
            callable = CallableSelector.matchingCallableArityFour((Ruby)this.runtime, (RubyToJavaInvoker)this, callablesForArity, (IRubyObject)arg0, (IRubyObject)arg1, (IRubyObject)arg2, (IRubyObject)arg3);
            if (callable == null && (callable = this.matchVarArgsCallableArityFour(self2, arg0, arg1, arg2, arg3)) == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, new IRubyObject[]{arg0, arg1, arg2, arg3});
            }
        } else if (!((JavaCallable)callable).isVarArgs()) {
            this.checkCallableArity(callable, 4);
        }
        return callable;
    }

    private T findCallableArityN(IRubyObject self2, String name2, IRubyObject[] args2, int arity2) {
        Object callable = this.javaCallable;
        if (callable == null) {
            T[] callablesForArity;
            if (arity2 >= this.javaCallables.length || (callablesForArity = this.javaCallables[arity2]) == null) {
                callable = this.matchVarArgsCallableArityN(self2, args2);
                if (callable == null) {
                    throw Error.argumentError(this.runtime.getCurrentContext(), args2.length, this.javaCallables.length - 1);
                }
                return callable;
            }
            callable = CallableSelector.matchingCallableArityN((Ruby)this.runtime, (RubyToJavaInvoker)this, callablesForArity, (IRubyObject[])args2);
            if (callable == null && (callable = this.matchVarArgsCallableArityN(self2, args2)) == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, args2);
            }
        } else if (!((JavaCallable)callable).isVarArgs()) {
            this.checkCallableArity(callable, args2.length);
        }
        return callable;
    }

    private T matchVarArgsCallableArityZero(IRubyObject self2) {
        T[] varArgsCallables = this.javaVarargsCallables;
        if (varArgsCallables != null) {
            JavaCallable callable = CallableSelector.matchingCallableArityZero((Ruby)this.runtime, (RubyToJavaInvoker)this, varArgsCallables);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])varArgsCallables, new IRubyObject[0]);
            }
            return (T)callable;
        }
        return null;
    }

    private T matchVarArgsCallableArityOne(IRubyObject self2, IRubyObject arg0) {
        T[] varArgsCallables = this.javaVarargsCallables;
        if (varArgsCallables != null) {
            JavaCallable callable = CallableSelector.matchingCallableArityOne((Ruby)this.runtime, (RubyToJavaInvoker)this, varArgsCallables, (IRubyObject)arg0);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])varArgsCallables, new IRubyObject[]{arg0});
            }
            return (T)callable;
        }
        return null;
    }

    private T matchVarArgsCallableArityTwo(IRubyObject self2, IRubyObject arg0, IRubyObject arg1) {
        T[] varArgsCallables = this.javaVarargsCallables;
        if (varArgsCallables != null) {
            JavaCallable callable = CallableSelector.matchingCallableArityTwo((Ruby)this.runtime, (RubyToJavaInvoker)this, varArgsCallables, (IRubyObject)arg0, (IRubyObject)arg1);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])varArgsCallables, new IRubyObject[]{arg0, arg1});
            }
            return (T)callable;
        }
        return null;
    }

    private T matchVarArgsCallableArityThree(IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        T[] varArgsCallables = this.javaVarargsCallables;
        if (varArgsCallables != null) {
            JavaCallable callable = CallableSelector.matchingCallableArityThree((Ruby)this.runtime, (RubyToJavaInvoker)this, varArgsCallables, (IRubyObject)arg0, (IRubyObject)arg1, (IRubyObject)arg2);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])varArgsCallables, new IRubyObject[]{arg0, arg1, arg2});
            }
            return (T)callable;
        }
        return null;
    }

    private T matchVarArgsCallableArityFour(IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        T[] varArgsCallables = this.javaVarargsCallables;
        if (varArgsCallables != null) {
            JavaCallable callable = CallableSelector.matchingCallableArityFour((Ruby)this.runtime, (RubyToJavaInvoker)this, varArgsCallables, (IRubyObject)arg0, (IRubyObject)arg1, (IRubyObject)arg2, (IRubyObject)arg3);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])varArgsCallables, new IRubyObject[]{arg0, arg1, arg2, arg3});
            }
            return (T)callable;
        }
        return null;
    }

    private T matchVarArgsCallableArityN(IRubyObject self2, IRubyObject[] args2) {
        T[] varArgsCallables = this.javaVarargsCallables;
        if (varArgsCallables != null) {
            JavaCallable callable = CallableSelector.matchingCallableArityN((Ruby)this.runtime, (RubyToJavaInvoker)this, varArgsCallables, (IRubyObject[])args2);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])varArgsCallables, args2);
            }
            return (T)callable;
        }
        return null;
    }

    private void checkCallableArity(T callable, int expected) {
        int arity2 = ((JavaCallable)callable).getArity();
        if (arity2 != expected) {
            throw Error.argumentError(this.runtime.getCurrentContext(), expected, arity2);
        }
    }

    private T someCallable() {
        if (this.javaCallable == null) {
            for (int i2 = 0; i2 < this.javaCallables.length; ++i2) {
                T[] callables = this.javaCallables[i2];
                if (callables == null || callables.length <= 0) continue;
                for (int j = 0; j < callables.length; ++j) {
                    if (callables[j] == null) continue;
                    return callables[j];
                }
            }
            return null;
        }
        return this.javaCallable;
    }

    private boolean isConstructor() {
        return this.someCallable() instanceof JavaConstructor;
    }

    RaiseException newErrorDueArgumentTypeMismatch(IRubyObject receiver2, T[] methods2, IRubyObject ... args2) {
        Class[] argTypes = new Class[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            argTypes[i2] = RubyToJavaInvoker.getClass(args2[i2]);
        }
        StringBuilder error2 = new StringBuilder(64);
        error2.append("no ");
        if (this.isConstructor()) {
            error2.append("constructor");
        } else {
            JavaMethod method2 = (JavaMethod)methods2[0];
            error2.append("method '").append(method2.getValue().getName()).append("'");
        }
        error2.append(" for arguments ");
        CodegenUtils.prettyParams(error2, argTypes);
        error2.append(" on ").append(RubyToJavaInvoker.formatReceiver(receiver2));
        if (methods2.length > 1) {
            error2.append("\n  available overloads:");
            for (T method3 : methods2) {
                Class[] paramTypes = method3.getParameterTypes();
                error2.append("\n    ");
                CodegenUtils.prettyParams(error2, paramTypes);
            }
        }
        return Error.nameError(this.runtime.getCurrentContext(), error2.toString(), (String)null);
    }

    private RaiseException newErrorDueNoMatchingCallable(IRubyObject receiver2, String name2) {
        StringBuilder error2 = new StringBuilder(48);
        error2.append("no ");
        if (this.isConstructor()) {
            error2.append("constructor");
        } else {
            error2.append("method '").append(name2).append("'");
        }
        error2.append(" (for zero arguments) on ").append(RubyToJavaInvoker.formatReceiver(receiver2));
        return Error.argumentError(this.runtime.getCurrentContext(), error2.toString());
    }

    private static Class<?> getClass(IRubyObject object) {
        if (object == null) {
            return Void.TYPE;
        }
        if (object instanceof ConcreteJavaProxy) {
            return ((ConcreteJavaProxy)object).getJavaClass();
        }
        return object.getClass();
    }

    private static String formatReceiver(IRubyObject object) {
        String string2;
        ThreadContext context = object.getRuntime().getCurrentContext();
        if (object instanceof RubyModule) {
            RubyModule mod = (RubyModule)object;
            string2 = mod.getName(context);
        } else {
            string2 = object.getMetaClass().getRealClass().getName(context);
        }
        return string2;
    }

    private static class NullHashMapLong<V>
    extends NonBlockingHashMapLong<V> {
        NullHashMapLong() {
            super(0, false);
        }

        @Override
        public V put(long key2, V val) {
            return null;
        }

        @Override
        public V putIfAbsent(long key2, V val) {
            return null;
        }

        @Override
        public V get(Object key2) {
            return null;
        }
    }
}

