/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import com.headius.backport9.buffer.Buffers;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.OpenFile;

public class IOModule {
    public static void createIOModule(ThreadContext context, RubyModule FFI2) {
        FFI2.defineModuleUnder(context, "IO").defineMethods(context, IOModule.class);
    }

    @JRubyMethod(name={"native_read"}, module=true)
    public static final IRubyObject native_read(ThreadContext context, IRubyObject self2, IRubyObject src, IRubyObject dst, IRubyObject rbLength) {
        if (!(src instanceof RubyIO)) {
            throw Error.typeError(context, "wrong argument (expected IO)");
        }
        if (!(dst instanceof AbstractMemory)) {
            throw Error.typeError(context, "wrong argument (expected FFI memory)");
        }
        try {
            OpenFile openFile = ((RubyIO)src).getOpenFile();
            openFile.checkClosed();
            openFile.checkReadable(context);
            ByteBuffer buffer = ((AbstractMemory)dst).getMemoryIO().asByteBuffer();
            int count2 = Convert.toInt(context, rbLength);
            if (count2 > buffer.remaining()) {
                throw Error.indexError(context, "read count too big for output buffer");
            }
            if (count2 < buffer.remaining()) {
                buffer = buffer.duplicate();
                Buffers.limitBuffer(buffer, count2);
            }
            return Convert.asFixnum(context, openFile.readChannel().read(buffer));
        }
        catch (EOFException e) {
            return Convert.asFixnum(context, -1);
        }
        catch (IOException e) {
            throw context.runtime.newIOErrorFromException(e);
        }
    }
}

