/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.Inflater;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.ext.zlib.ZStream;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Zlib::Inflate"}, parent="Zlib::ZStream")
public class JZlibInflate
extends ZStream {
    public static final int BASE_SIZE = 100;
    private int windowBits;
    private byte[] collected;
    private int collectedIdx;
    private ByteList input;
    private Inflater flater = null;

    public JZlibInflate(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inflate"}, meta=true)
    public static IRubyObject s_inflate(ThreadContext context, IRubyObject recv2, IRubyObject string2) {
        RubyClass klass = (RubyClass)(recv2.isClass() ? recv2 : context.runtime.getClassFromPath("Zlib::Inflate"));
        JZlibInflate inflate2 = (JZlibInflate)klass.allocate(context);
        inflate2.init(15);
        try {
            IRubyObject iRubyObject = inflate2.inflate(context, string2, Block.NULL_BLOCK);
            return iRubyObject;
        }
        finally {
            inflate2.finish(context, Block.NULL_BLOCK);
            inflate2.close(context);
        }
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject _initialize(IRubyObject[] args2) {
        return this._initialize(this.getCurrentContext(), args2);
    }

    @JRubyMethod(name={"initialize"}, optional=1, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject _initialize(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        this.windowBits = argc > 0 && !args2[0].isNil() ? JZlibInflate.checkWindowBits(context, Convert.toInt(context, args2[0]), true) : 15;
        this.init(this.windowBits);
        return this;
    }

    private void init(int windowBits) {
        this.flater = new Inflater();
        this.flater.init(windowBits);
        this.collected = new byte[100];
        this.collectedIdx = 0;
        this.input = new ByteList();
    }

    @Override
    @JRubyMethod(name={"flush_next_out"})
    public IRubyObject flush_next_out(ThreadContext context, Block block) {
        return this.flushOutput(context, block);
    }

    private IRubyObject flushOutput(ThreadContext context, Block block) {
        if (this.collectedIdx > 0) {
            RubyString res = Create.newString(context, this.collected, 0, this.collectedIdx);
            this.collectedIdx = 0;
            this.flater.setOutput(this.collected);
            if (block.isGiven()) {
                block.yield(context, res);
                return context.nil;
            }
            return res;
        }
        return RubyString.newEmptyBinaryString(context.runtime);
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject append(ThreadContext context, IRubyObject arg2) {
        this.checkClosed(context);
        if (arg2.isNil()) {
            this.run(context, true);
        } else {
            this.append(context, arg2.convertToString().getByteList());
        }
        return this;
    }

    @Deprecated(since="10.0.0.0")
    public void append(ByteList obj) {
        this.append(this.getCurrentContext(), obj);
    }

    public void append(ThreadContext context, ByteList obj) {
        if (!this.internalFinished()) {
            this.flater.setInput(obj.bytes(), true);
        } else {
            this.input.append(obj);
        }
        this.run(context, false);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject sync_point_p() {
        return this.sync_point_p(this.getCurrentContext());
    }

    @JRubyMethod(name={"sync_point?"})
    public IRubyObject sync_point_p(ThreadContext context) {
        return this.sync_point(context);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject sync_point() {
        return this.sync_point(this.getCurrentContext());
    }

    public IRubyObject sync_point(ThreadContext context) {
        int ret = this.flater.syncPoint();
        return switch (ret) {
            case 1 -> context.tru;
            case -3 -> throw RubyZlib.newStreamError(context, "stream error");
            default -> context.fals;
        };
    }

    @JRubyMethod(name={"set_dictionary"})
    public IRubyObject set_dictionary(ThreadContext context, IRubyObject arg2) {
        try {
            byte[] tmp = arg2.convertToString().getBytes();
            int ret = this.flater.setDictionary(tmp, tmp.length);
            switch (ret) {
                case -2: {
                    throw RubyZlib.newStreamError(context, "stream error");
                }
                case -3: {
                    throw RubyZlib.newDataError(context, "wrong dictionary");
                }
            }
            this.run(context, false);
            return arg2;
        }
        catch (IllegalArgumentException iae) {
            throw RubyZlib.newStreamError(context, "stream error: " + iae.getMessage());
        }
    }

    @JRubyMethod(name={"inflate"})
    public IRubyObject inflate(ThreadContext context, IRubyObject string2, Block block) {
        ByteList data2 = null;
        if (!string2.isNil()) {
            data2 = string2.convertToString().getByteList();
        }
        return this.inflate(context, data2, block);
    }

    public IRubyObject inflate(ThreadContext context, ByteList str, Block block) {
        if (str == null) {
            return this.internalFinish(context, block);
        }
        this.append(context, str);
        return this.flushOutput(context, block);
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync(ThreadContext context, IRubyObject string2) {
        if (this.flater.avail_in > 0) {
            switch (this.flater.sync()) {
                case 0: {
                    this.flater.setInput(string2.convertToString().getByteList().bytes(), true);
                    return context.tru;
                }
                case -3: {
                    break;
                }
                default: {
                    throw RubyZlib.newStreamError(context, "stream error");
                }
            }
        }
        if (string2.convertToString().getByteList().length() <= 0) {
            return context.fals;
        }
        this.flater.setInput(string2.convertToString().getByteList().bytes(), true);
        switch (this.flater.sync()) {
            case 0: {
                return context.tru;
            }
            case -3: {
                return context.fals;
            }
        }
        throw RubyZlib.newStreamError(context, "stream error");
    }

    private void run(ThreadContext context, boolean finish2) {
        int err;
        int resultLength = -1;
        while (!this.internalFinished() && resultLength != 0) {
            boolean needsInput;
            boolean bl = needsInput = this.flater.avail_in < 0;
            if (finish2 && needsInput) {
                throw RubyZlib.newBufError(context, "buffer error");
            }
            this.flater.setOutput(this.collected, this.collectedIdx, this.collected.length - this.collectedIdx);
            int ret = this.flater.inflate(0);
            resultLength = this.flater.next_out_index - this.collectedIdx;
            this.collectedIdx = this.flater.next_out_index;
            switch (ret) {
                case -3: {
                    throw RubyZlib.newDataError(context, this.flater.getMessage());
                }
                case 2: {
                    throw RubyZlib.newDictError(context, "need dictionary");
                }
                case 1: {
                    if (this.flater.avail_in > 0) {
                        this.input.append(this.flater.next_in, this.flater.next_in_index, this.flater.avail_in);
                        this.flater.setInput("".getBytes());
                    }
                }
                case 0: {
                    resultLength = this.flater.next_out_index;
                    break;
                }
                default: {
                    resultLength = 0;
                }
            }
            if (this.collected.length != this.collectedIdx || this.internalFinished()) continue;
            byte[] tmp = new byte[this.collected.length * 3];
            System.arraycopy(this.collected, 0, tmp, 0, this.collected.length);
            this.collected = tmp;
        }
        if (finish2 && !this.internalFinished() && (err = this.flater.inflate(4)) != 0) {
            throw RubyZlib.newBufError(context, "buffer error");
        }
    }

    @Override
    protected int internalTotalIn() {
        return (int)this.flater.total_in;
    }

    @Override
    protected int internalTotalOut() {
        return (int)this.flater.total_out;
    }

    @Override
    protected boolean internalStreamEndP() {
        return this.flater.finished();
    }

    @Override
    protected void internalReset(ThreadContext context) {
        this.init(this.windowBits);
    }

    @Override
    protected boolean internalFinished() {
        return this.flater.finished();
    }

    @Override
    protected long internalAdler() {
        return this.flater.getAdler();
    }

    @Override
    protected IRubyObject internalFinish(ThreadContext context, Block block) {
        this.run(context, true);
        if (this.internalFinished() && this.input.getRealSize() > 0) {
            if (this.collected.length - this.collectedIdx < this.input.length()) {
                byte[] tmp = new byte[this.collected.length + this.input.length()];
                System.arraycopy(this.collected, 0, tmp, 0, this.collectedIdx);
                this.collected = tmp;
            }
            System.arraycopy(this.input.getUnsafeBytes(), this.input.begin(), this.collected, this.collectedIdx, this.input.length());
            this.collectedIdx += this.input.length();
            JZlibInflate.resetBuffer(this.input);
        }
        return this.flushOutput(context, block);
    }

    @Override
    protected void internalClose() {
        this.flater.end();
    }

    @Override
    public IRubyObject avail_in(ThreadContext context) {
        return Convert.asFixnum(context, this.flater.avail_in);
    }

    private static void resetBuffer(ByteList l) {
        l.setBegin(0);
        l.setRealSize(0);
        l.invalidate();
    }
}

