/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.date;

import org.joda.time.DateTime;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.ext.date.DateUtils;
import org.jruby.ext.date.RubyDate;
import org.jruby.ext.date.RubyDateTime;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class TimeExt {
    private TimeExt() {
    }

    static void load(ThreadContext context) {
        Access.timeClass(context).defineMethods(context, TimeExt.class);
    }

    @JRubyMethod
    public static RubyTime to_time(IRubyObject self2) {
        return (RubyTime)self2;
    }

    @JRubyMethod(name={"to_date"})
    public static RubyDate to_date(ThreadContext context, IRubyObject self2) {
        DateTime dt = ((RubyTime)self2).getDateTime();
        long jd2 = DateUtils.civil_to_jd(dt.getYear(), dt.getMonthOfYear(), dt.getDayOfMonth(), -9.223372036854776E18);
        return new RubyDate(context, RubyDate.getDate(context), (IRubyObject)RubyDate.jd_to_ajd(context, jd2), RubyDate.CHRONO_ITALY_UTC, 0);
    }

    @JRubyMethod(name={"to_datetime"})
    public static RubyDateTime to_datetime(ThreadContext context, IRubyObject self2) {
        RubyTime time = (RubyTime)self2;
        DateTime dt = ((RubyTime)self2).getDateTime();
        long subMillisNum = 0L;
        long subMillisDen = 1L;
        if (time.getNSec() != 0L) {
            IRubyObject subMillis = RubyRational.newRationalCanonicalize(context, time.getNSec(), 1000000L);
            if (subMillis instanceof RubyRational) {
                subMillisNum = ((RubyRational)subMillis).getNumerator().asLong(context);
                subMillisDen = ((RubyRational)subMillis).getDenominator().asLong(context);
            } else {
                subMillisNum = ((RubyInteger)subMillis).asLong(context);
            }
        }
        int off = dt.getZone().getOffset(dt.getMillis()) / 1000;
        int year2 = dt.getYear();
        if (year2 <= 0) {
            --year2;
        }
        if (year2 == 1582) {
            return TimeExt.calcAjdFromCivil(context, dt, off, subMillisNum, subMillisDen);
        }
        dt = new DateTime(year2, dt.getMonthOfYear(), dt.getDayOfMonth(), dt.getHourOfDay(), dt.getMinuteOfHour(), dt.getSecondOfMinute(), dt.getMillisOfSecond(), RubyDate.getChronology(context, 2299161L, dt.getZone()));
        return new RubyDateTime(context.runtime, RubyDate.getDateTime(context), dt, off, 2299161L, subMillisNum, subMillisDen);
    }

    private static RubyDateTime calcAjdFromCivil(ThreadContext context, DateTime dt, int off, long subMillisNum, long subMillisDen) {
        long jd2 = DateUtils.civil_to_jd(dt.getYear(), dt.getMonthOfYear(), dt.getDayOfMonth(), 2299161.0);
        RubyNumeric fr = RubyDate.timeToDayFraction(context, dt.getHourOfDay(), dt.getMinuteOfHour(), dt.getSecondOfMinute());
        RubyNumeric ajd2 = RubyDate.jd_to_ajd(context, jd2, fr, off);
        RubyDateTime dateTime = new RubyDateTime(context, RubyDate.getDateTime(context), (IRubyObject)ajd2, off, 2299161L);
        dateTime.dt = dateTime.dt.withMillisOfSecond(dt.getMillisOfSecond());
        dateTime.subMillisNum = subMillisNum;
        dateTime.subMillisDen = subMillisDen;
        return dateTime;
    }
}

