/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import org.jruby.IncludedModule;
import org.jruby.MetaClass;
import org.jruby.PrependedModule;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGC;
import org.jruby.RubyInteger;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyStopIteration;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.exceptions.StopIteration;
import org.jruby.javasupport.JavaPackage;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Inspector;
import org.jruby.util.Numeric;
import org.jruby.util.collections.WeakValuedIdentityMap;
import org.jruby.util.collections.WeakValuedMap;

@JRubyModule(name={"ObjectSpace"})
public class RubyObjectSpace {
    public static RubyModule createObjectSpaceModule(ThreadContext context, RubyClass Object2) {
        Object ObjectSpace2 = Define.defineModule(context, "ObjectSpace").defineMethods(context, RubyObjectSpace.class);
        WeakMap.createWeakMap(context, Object2, ObjectSpace2);
        WeakKeyMap.createWeakMap(context, Object2, ObjectSpace2);
        return ObjectSpace2;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject define_finalizer(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyObjectSpace.define_finalizer(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }

    @JRubyMethod(required=1, optional=1, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject define_finalizer(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject finalizer;
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        IRubyObject obj = args2[0];
        if (argc == 2) {
            finalizer = args2[1];
            if (!finalizer.respondsTo("call")) {
                throw Error.argumentError(context, "wrong type argument " + String.valueOf(finalizer.getType()) + " (should be callable)");
            }
            if (finalizer instanceof RubyMethod && ((RubyMethod)finalizer).getReceiver() == obj) {
                RubyObjectSpace.referenceWarning(context);
            }
            if (finalizer instanceof RubyProc && ((RubyProc)finalizer).getBlock().getBinding().getSelf() == obj) {
                RubyObjectSpace.referenceWarning(context);
            }
        } else {
            if (RubyObjectSpace.blockReferencesObject(obj, block)) {
                RubyObjectSpace.referenceWarning(context);
            }
            finalizer = context.runtime.newProc(Block.Type.PROC, block);
        }
        finalizer = context.runtime.getObjectSpace().addFinalizer(context, obj, finalizer);
        return Create.newArray(context, (IRubyObject)Convert.asFixnum(context, 0), finalizer);
    }

    private static void referenceWarning(ThreadContext context) {
        Warn.warn(context, "finalizer references object to be finalized");
    }

    private static boolean blockReferencesObject(IRubyObject object, Block block) {
        return block.getBinding().getSelf() == object;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject undefine_finalizer(IRubyObject recv2, IRubyObject obj, Block block) {
        return RubyObjectSpace.undefine_finalizer(((RubyBasicObject)recv2).getCurrentContext(), recv2, obj, block);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject undefine_finalizer(ThreadContext context, IRubyObject recv2, IRubyObject obj, Block block) {
        context.runtime.getObjectSpace().removeFinalizers(Convert.toLong(context, obj.__id__(context)));
        return recv2;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject id2ref(IRubyObject recv2, IRubyObject id) {
        return RubyObjectSpace.id2ref(((RubyBasicObject)recv2).getCurrentContext(), recv2, id);
    }

    @JRubyMethod(name={"_id2ref"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject id2ref(ThreadContext context, IRubyObject recv2, IRubyObject id) {
        long longId = Convert.castAsFixnum(context, id).getValue();
        if (longId == 0L) {
            return context.fals;
        }
        if (longId == 20L) {
            return context.tru;
        }
        if (longId == 8L) {
            return context.nil;
        }
        if ((longId & 1L) == 1L) {
            return Convert.asFixnum(context, (longId - 1L) / 2L);
        }
        if ((longId & 3L) == 2L) {
            double d = 0.0;
            if (longId != -9223372036854775806L) {
                long b63 = longId >>> 63;
                long longBits = Numeric.rotr(2L - b63 | longId & 0xFFFFFFFFFFFFFFFCL, 3);
                d = Double.longBitsToDouble(longBits);
            }
            return Convert.asFloat(context, d);
        }
        if (context.runtime.isObjectSpaceEnabled()) {
            IRubyObject object = context.runtime.getObjectSpace().id2ref(longId);
            if (object == null) {
                return context.nil;
            }
            return object;
        }
        Warn.warn(context, "ObjectSpace is disabled; _id2ref only supports immediates, pass -X+O to enable");
        throw Error.rangeError(context, String.format("0x%016x is not id value", longId));
    }

    public static IRubyObject each_objectInternal(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject obj2;
        RubyModule rubyClass;
        Ruby runtime2 = context.runtime;
        if (args2.length == 0) {
            rubyClass = Access.objectClass(context);
        } else {
            if (!(args2[0] instanceof RubyModule)) {
                throw Error.argumentError(context, "class or module required");
            }
            rubyClass = (RubyModule)args2[0];
        }
        if (rubyClass == Access.classClass(context) || rubyClass == Access.moduleClass(context)) {
            HashSet modules = new HashSet(96);
            if (rubyClass == Access.moduleClass(context)) {
                runtime2.eachModule(module -> modules.add(module));
            }
            Access.basicObjectClass(context).subclasses(true).forEach(module -> {
                if (!(!rubyClass.isInstance((IRubyObject)module) || module instanceof IncludedModule || module instanceof PrependedModule || module == runtime2.getJavaSupport().getJavaPackageClass() || module instanceof MetaClass && ((MetaClass)module).getAttached() instanceof JavaPackage)) {
                    modules.add(module);
                }
            });
            modules.forEach(obj -> block.yield(context, (IRubyObject)obj));
            return Convert.asFixnum(context, modules.size());
        }
        if (rubyClass.getClass() == MetaClass.class) {
            RubyBasicObject attached = ((MetaClass)args2[0]).getAttached();
            block.yield(context, attached);
            int count2 = 1;
            if (attached instanceof RubyClass) {
                for (RubyClass child : ((RubyClass)attached).subclasses(true)) {
                    if (child instanceof IncludedModule) continue;
                    ++count2;
                    block.yield(context, child);
                }
            }
            return Convert.asFixnum(context, count2);
        }
        if (!runtime2.isObjectSpaceEnabled()) {
            throw Error.runtimeError(context, "ObjectSpace is disabled; each_object will only work with Class, pass -X+O to enable");
        }
        Iterator iter = runtime2.getObjectSpace().iterator(rubyClass);
        int count3 = 0;
        while ((obj2 = (IRubyObject)iter.next()) != null) {
            ++count3;
            block.yield(context, obj2);
        }
        return Convert.asFixnum(context, count3);
    }

    @JRubyMethod(name={"each_object"}, optional=1, checkArity=false, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject each_object(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        return block.isGiven() ? RubyObjectSpace.each_objectInternal(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each_object", args2);
    }

    @JRubyMethod(name={"garbage_collect"}, module=true, visibility=Visibility.PRIVATE, optional=1, checkArity=false)
    public static IRubyObject garbage_collect(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyGC.start(context, recv2, args2);
    }

    public static class WeakMap
    extends AbstractWeakMap {
        private final WeakValuedIdentityMap<IRubyObject, IRubyObject> identityMap = new WeakValuedIdentityMap();
        private final WeakValuedMap<IRubyObject, IRubyObject> valueMap = new WeakValuedMap();

        static void createWeakMap(ThreadContext context, RubyClass Object2, RubyModule ObjectSpace2) {
            ((RubyModule)ObjectSpace2.defineClassUnder(context, "WeakMap", Object2, WeakMap::new)).defineMethods(context, AbstractWeakMap.class);
        }

        public WeakMap(Ruby runtime2, RubyClass cls) {
            super(runtime2, cls);
        }

        @Override
        protected Map<IRubyObject, IRubyObject> getWeakMapFor(IRubyObject key2) {
            if (key2 instanceof RubyFixnum || key2 instanceof RubyFloat) {
                return this.valueMap;
            }
            return this.identityMap;
        }

        @Override
        protected Stream<Map.Entry<IRubyObject, IRubyObject>> getEntryStream() {
            return Stream.concat(this.identityMap.entrySet().stream(), this.valueMap.entrySet().stream()).filter(entry -> entry.getValue() != null);
        }

        @Override
        public IRubyObject size(ThreadContext context) {
            return Convert.asFixnum(context, this.identityMap.size() + this.valueMap.size());
        }

        @Override
        public IRubyObject inspect(ThreadContext context) {
            RubyString part = Inspector.inspectPrefix(context, this.metaClass.getRealClass(), this.inspectHashCode());
            int base = part.length();
            this.getEntryStream().forEach(entry -> {
                part.cat(part.length() == base ? Inspector.COLON_SPACE : Inspector.COMMA_SPACE);
                part.cat(((IRubyObject)entry.getKey()).inspect(context).convertToString());
                part.cat(Inspector.SPACE_HASHROCKET_SPACE);
                part.cat(((IRubyObject)entry.getValue()).inspect(context).convertToString());
            });
            part.cat(Inspector.GT);
            return part;
        }

        @Override
        public IRubyObject clear(ThreadContext context) {
            this.identityMap.clear();
            this.valueMap.clear();
            return this;
        }
    }

    public static class WeakKeyMap
    extends AbstractWeakMap {
        private final WeakHashMap<IRubyObject, IRubyObject> weakMap = new WeakHashMap();

        static void createWeakMap(ThreadContext context, RubyClass Object2, RubyModule ObjectSpace2) {
            ((RubyModule)ObjectSpace2.defineClassUnder(context, "WeakKeyMap", Object2, WeakKeyMap::new)).defineMethods(context, AbstractWeakMap.class, WeakKeyMap.class);
        }

        public WeakKeyMap(Ruby runtime2, RubyClass cls) {
            super(runtime2, cls);
        }

        @Override
        protected Map<IRubyObject, IRubyObject> getWeakMapFor(IRubyObject key2) {
            if (key2 instanceof RubyInteger || key2 instanceof RubyFloat || key2 instanceof RubySymbol || key2 instanceof RubyNil || key2 instanceof RubyBoolean) {
                throw Error.argumentError(this.getRuntime().getCurrentContext(), "WeakKeyMap must be garbage collectable");
            }
            return this.weakMap;
        }

        @Override
        protected Stream<Map.Entry<IRubyObject, IRubyObject>> getEntryStream() {
            return this.weakMap.entrySet().stream();
        }

        @Override
        public IRubyObject op_aref(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            key2.callMethod(context, "hash");
            super.op_aref(context, key2, value2);
            return value2;
        }

        @Override
        public IRubyObject size(ThreadContext context) {
            return Convert.asFixnum(context, this.weakMap.size());
        }

        @Override
        public IRubyObject inspect(ThreadContext context) {
            RubyString part = Inspector.inspectPrefix(context, this.metaClass.getRealClass(), this.inspectHashCode());
            part.cat(Inspector.SPACE);
            part.cat(Inspector.SIZE_EQUALS);
            part.cat(ConvertBytes.longToCharBytes(this.weakMap.size()));
            part.cat(Inspector.GT);
            return part;
        }

        @JRubyMethod(name={"getkey"})
        public IRubyObject getkey(ThreadContext context, IRubyObject key2) {
            IRubyObject result2 = null;
            try {
                this.getWeakMapFor(key2).keySet().forEach(k -> {
                    if (key2.equals(k)) {
                        throw context.runtime.newStopIteration((IRubyObject)k, "");
                    }
                });
            }
            catch (StopIteration si) {
                result2 = ((RubyStopIteration)si.getException()).result();
            }
            if (result2 == null) {
                return context.nil;
            }
            return result2;
        }

        @Override
        public IRubyObject clear(ThreadContext context) {
            this.weakMap.clear();
            return this;
        }
    }

    public static abstract class AbstractWeakMap
    extends RubyObject {
        public AbstractWeakMap(Ruby runtime2, RubyClass cls) {
            super(runtime2, cls);
        }

        protected abstract Map<IRubyObject, IRubyObject> getWeakMapFor(IRubyObject var1);

        protected abstract Stream<Map.Entry<IRubyObject, IRubyObject>> getEntryStream();

        @JRubyMethod(name={"length", "size"})
        public abstract IRubyObject size(ThreadContext var1);

        @Override
        @JRubyMethod(name={"inspect"})
        public abstract IRubyObject inspect(ThreadContext var1);

        @JRubyMethod(name={"[]"})
        public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
            Map<IRubyObject, IRubyObject> weakMap = this.getWeakMapFor(key2);
            IRubyObject value2 = weakMap.get(key2);
            if (value2 != null) {
                return value2;
            }
            return context.nil;
        }

        @JRubyMethod(name={"[]="})
        public IRubyObject op_aref(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            Map<IRubyObject, IRubyObject> weakMap = this.getWeakMapFor(key2);
            weakMap.put(key2, value2);
            return Convert.asFixnum(context, System.identityHashCode(value2));
        }

        @JRubyMethod(name={"key?"})
        public IRubyObject key_p(ThreadContext context, IRubyObject key2) {
            Map<IRubyObject, IRubyObject> weakMap = this.getWeakMapFor(key2);
            return Convert.asBoolean(context, weakMap.get(key2) != null);
        }

        @JRubyMethod(name={"keys"})
        public IRubyObject keys(ThreadContext context) {
            return Create.newArrayNoCopy(context, (IRubyObject[])this.getEntryStream().map(Map.Entry::getKey).toArray(IRubyObject[]::new));
        }

        @JRubyMethod(name={"values"})
        public IRubyObject values(ThreadContext context) {
            return Create.newArrayNoCopy(context, (IRubyObject[])this.getEntryStream().map(Map.Entry::getValue).toArray(IRubyObject[]::new));
        }

        @JRubyMethod(name={"each", "each_pair"})
        public IRubyObject each(ThreadContext context, Block block) {
            this.getEntryStream().forEach(entry -> block.yieldSpecific(context, (IRubyObject)entry.getKey(), (IRubyObject)entry.getValue()));
            return this;
        }

        @JRubyMethod(name={"each_key"})
        public IRubyObject each_key(ThreadContext context, Block block) {
            this.getEntryStream().forEach(entry -> block.yieldSpecific(context, (IRubyObject)entry.getKey()));
            return this;
        }

        @JRubyMethod(name={"each_value"})
        public IRubyObject each_value(ThreadContext context, Block block) {
            this.getEntryStream().forEach(entry -> block.yieldSpecific(context, (IRubyObject)entry.getValue()));
            return this;
        }

        @JRubyMethod(name={"include?", "member?"})
        public IRubyObject member_p(ThreadContext context, IRubyObject key2) {
            return Convert.asBoolean(context, this.getWeakMapFor(key2).containsKey(key2));
        }

        @JRubyMethod(name={"delete"})
        public IRubyObject delete(ThreadContext context, IRubyObject key2, Block block) {
            IRubyObject value2 = this.getWeakMapFor(key2).remove(key2);
            if (value2 != null) {
                return value2;
            }
            if (block.isGiven()) {
                return block.yieldSpecific(context, key2);
            }
            return context.nil;
        }

        @JRubyMethod(name={"clear"})
        public abstract IRubyObject clear(ThreadContext var1);
    }
}

