/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.SystemExit;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"SystemExit"}, parent="Exception")
public class RubySystemExit
extends RubyException {
    IRubyObject status;

    static RubyClass define(ThreadContext context, RubyClass Exception2) {
        return (RubyClass)Define.defineClass(context, "SystemExit", Exception2, RubySystemExit::new).defineMethods(context, RubySystemExit.class);
    }

    @Deprecated(since="10.0.0.0")
    public static RubySystemExit newInstance(Ruby runtime2, int status2, String message2) {
        return RubySystemExit.newInstance(runtime2.getCurrentContext(), status2, message2);
    }

    public static RubySystemExit newInstance(ThreadContext context, int status2, String message2) {
        RubyClass klass = context.runtime.getSystemExit();
        IRubyObject[] args2 = new IRubyObject[]{Convert.asFixnum(context, status2), Create.newString(context, message2)};
        return (RubySystemExit)klass.newInstance(context, args2, Block.NULL_BLOCK);
    }

    protected RubySystemExit(Ruby runtime2, RubyClass exceptionClass) {
        super(runtime2, exceptionClass);
        this.status = runtime2.getNil();
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new SystemExit(message2, this);
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        return this.initialize(this.getRuntime().getCurrentContext(), args2, block);
    }

    @JRubyMethod(optional=2, checkArity=false, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 2);
        if (argc > 0) {
            IRubyObject arg2 = args2[0];
            if (arg2 instanceof RubyFixnum) {
                this.status = arg2;
                if (argc > 1) {
                    this.message = args2[1];
                }
            } else if (arg2 instanceof RubyBoolean) {
                this.status = Convert.asFixnum(context, arg2 == context.tru ? 0 : 1);
                if (argc > 1) {
                    this.message = args2[1];
                }
            } else {
                this.message = arg2;
                this.status = RubyFixnum.zero(context.runtime);
            }
        } else {
            this.status = RubyFixnum.zero(context.runtime);
        }
        super.initialize(NULL_ARRAY, block);
        return this;
    }

    @JRubyMethod
    public IRubyObject status() {
        return this.status;
    }

    @JRubyMethod(name={"success?"})
    public IRubyObject success_p() {
        Ruby runtime2 = this.getRuntime();
        IRubyObject status2 = this.status;
        if (status2.isNil()) {
            return runtime2.getTrue();
        }
        if (status2 == runtime2.getTrue() || status2 == runtime2.getFalse()) {
            return status2;
        }
        if (status2.equals(RubyFixnum.zero(runtime2))) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }
}

