/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.binding;

import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.binding.ClassInitializer;
import org.jruby.javasupport.binding.InterfaceInitializer;
import org.jruby.javasupport.binding.MethodGatherer;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class Initializer {
    static final Logger LOG = LoggerFactory.getLogger(Initializer.class);
    protected final Ruby runtime;
    protected final JavaSupport javaSupport;
    protected final Class javaClass;
    @Deprecated(since="9.2.9.0")
    public static final ClassValue<Method[]> DECLARED_METHODS = MethodGatherer.DECLARED_METHODS;

    public Initializer(Ruby runtime2, Class javaClass) {
        this.runtime = runtime2;
        this.javaSupport = runtime2.getJavaSupport();
        this.javaClass = javaClass;
    }

    @Deprecated(since="10.0.0.0")
    public static RubyModule setupProxyClass(Ruby runtime2, Class<?> javaClass, RubyClass proxy2) {
        return Initializer.setupProxyClass(runtime2.getCurrentContext(), javaClass, proxy2);
    }

    public static RubyModule setupProxyClass(ThreadContext context, Class<?> javaClass, RubyClass proxy2) {
        Initializer.setJavaClassFor(context, javaClass, proxy2);
        proxy2.reifiedClass(javaClass);
        if (javaClass.isArray()) {
            Initializer.flagAsJavaProxy(context, proxy2);
            return proxy2;
        }
        if (javaClass.isPrimitive()) {
            RubyClass proxySingleton = proxy2.singletonClass(context);
            proxySingleton.undefMethods(context, "new");
            if (javaClass == Void.TYPE) {
                proxySingleton.undefMethods(context, "[]", "new_array");
            }
            Initializer.flagAsJavaProxy(context, proxy2);
            return proxy2;
        }
        proxy2 = new ClassInitializer(context.runtime, javaClass).initialize(context, proxy2);
        Initializer.flagAsJavaProxy(context, proxy2);
        return proxy2;
    }

    @Deprecated(since="10.0.0.0")
    public static RubyModule setupProxyModule(Ruby runtime2, Class<?> javaClass, RubyModule proxy2) {
        return Initializer.setupProxyModule(runtime2.getCurrentContext(), javaClass, proxy2);
    }

    public static RubyModule setupProxyModule(ThreadContext context, Class<?> javaClass, RubyModule proxy2) {
        Initializer.setJavaClassFor(context, javaClass, proxy2);
        assert (javaClass.isInterface());
        proxy2 = new InterfaceInitializer(context.runtime, javaClass).initialize(context, proxy2);
        Initializer.flagAsJavaProxy(context, proxy2);
        return proxy2;
    }

    private static void flagAsJavaProxy(ThreadContext context, RubyModule proxy2) {
        proxy2.setJavaProxy(true);
        proxy2.singletonClass(context).setJavaProxy(true);
    }

    private static void setJavaClassFor(ThreadContext context, Class<?> javaClass, RubyModule proxy2) {
        JavaProxy.setJavaClass(context, proxy2, javaClass);
        proxy2.dataWrapStruct(javaClass);
    }

    @Deprecated(since="10.0.0.0")
    public RubyModule initialize(RubyModule proxy2) {
        return this.initialize(proxy2.getCurrentContext(), proxy2);
    }

    public abstract RubyModule initialize(ThreadContext var1, RubyModule var2);
}

