/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.nkf;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.jruby.ext.nkf.Option;

public class Options {
    private final Map<String, Option> shortOpts = new LinkedHashMap<String, Option>();
    private final Map<String, Option> longOpts = new LinkedHashMap<String, Option>();

    public Options addOption(String string) {
        return this.addOption(string, null);
    }

    public Options addOption(String string, String string2) {
        return this.addOption(string, string2, null);
    }

    public Options addOption(String string, String string2, String string3) {
        return this.addOption(new Option(string, string2, string3));
    }

    public Options addOption(Option option) {
        if (option.hasLongOpt()) {
            this.longOpts.put(option.getLongOpt(), option);
        }
        if (option.hasShortOpt()) {
            this.shortOpts.put(option.getOpt(), option);
        }
        return this;
    }

    boolean hasShortOption(String string) {
        for (Map.Entry<String, Option> entry : this.shortOpts.entrySet()) {
            if (!string.startsWith(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    public Option matchShortOption(String string) {
        for (Map.Entry<String, Option> entry : this.shortOpts.entrySet()) {
            Matcher matcher;
            if (!string.startsWith(entry.getKey())) continue;
            Option option = entry.getValue();
            if (option.hasArg() && (matcher = option.pattern().matcher(string)).find()) {
                option.setValue(matcher.group());
            }
            return option;
        }
        return null;
    }

    boolean hasLongOption(String string) {
        for (Map.Entry<String, Option> entry : this.longOpts.entrySet()) {
            if (!string.startsWith(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    Option matchLongOption(String string) {
        for (Map.Entry<String, Option> entry : this.longOpts.entrySet()) {
            Matcher matcher;
            if (!string.startsWith(entry.getKey())) continue;
            Option option = entry.getValue();
            if (option.hasArg() && (matcher = option.pattern().matcher(string)).find()) {
                option.setValue(matcher.group(1));
            }
            return option;
        }
        return null;
    }
}

