/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jruby.Appendable;
import org.jruby.RubyString;
import org.jruby.api.Convert;
import org.jruby.ir.targets.indy.SelfInvokeSite;
import org.jruby.ir.targets.indy.StringBootstrap;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class BuildDynamicStringSite
extends MutableCallSite {
    private static final Logger LOG = LoggerFactory.getLogger(BuildDynamicStringSite.class);
    public static final Handle BUILD_DSTRING_BOOTSTRAP = new Handle(6, CodegenUtils.p(BuildDynamicStringSite.class), "buildDString", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class), false);
    private static final int MAX_ELEMENTS_FOR_SPECIALIZE1 = 4;
    private static final int MAX_DYNAMIC_ARGS_FOR_SPECIALIZE2 = 5;
    public static final int MAX_ELEMENTS = 50;
    private static final int METADATA_ARGS_COUNT = 6;
    final int initialSize;
    final Encoding encoding;
    final long descriptor;
    final boolean frozen;
    final boolean chilled;
    final int elementCount;
    final ByteListAndCodeRange[] strings;

    public static CallSite buildDString(MethodHandles.Lookup lookup, String name2, MethodType type2, Object[] args2) {
        return new BuildDynamicStringSite(type2, args2);
    }

    public BuildDynamicStringSite(MethodType type2, Object[] stringArgs) {
        super(type2);
        int i2;
        int metadataIndex = stringArgs.length - 6;
        this.initialSize = (Integer)stringArgs[metadataIndex];
        this.encoding = StringBootstrap.encodingFromName((String)stringArgs[metadataIndex + 1]);
        this.frozen = (Integer)stringArgs[metadataIndex + 2] != 0;
        this.chilled = (Integer)stringArgs[metadataIndex + 3] != 0;
        this.descriptor = (Long)stringArgs[metadataIndex + 4];
        this.elementCount = (Integer)stringArgs[metadataIndex + 5];
        ByteListAndCodeRange[] strings = new ByteListAndCodeRange[this.elementCount];
        int stringArgsIdx = 0;
        Binder binder = Binder.from(type2);
        int dynamicArgs = type2.parameterCount() - 1;
        int to_sArgCount = 2;
        int[] permute = new int[to_sArgCount * dynamicArgs + 1];
        permute[0] = 0;
        for (i2 = 0; i2 < dynamicArgs; ++i2) {
            int base = i2 * to_sArgCount + 1;
            permute[base] = 0;
            permute[base + 1] = i2 + 1;
        }
        binder = binder.permute(permute);
        for (i2 = 0; i2 < dynamicArgs; ++i2) {
            binder = binder.collect(i2 + 1, to_sArgCount, Appendable.class, BuildDynamicStringSite.constructGuardedToStringFilter());
        }
        boolean specialize = this.elementCount <= 4;
        for (int i3 = 0; i3 < this.elementCount; ++i3) {
            ByteListAndCodeRange blcr;
            if (!BuildDynamicStringSite.isStringElement(this.descriptor, i3)) continue;
            strings[i3] = blcr = new ByteListAndCodeRange(StringBootstrap.bytelist((String)stringArgs[stringArgsIdx * 3], (String)stringArgs[stringArgsIdx * 3 + 1]), (Integer)stringArgs[stringArgsIdx * 3 + 2]);
            if (specialize) {
                binder = binder.insert(i3 + 1, blcr);
            }
            ++stringArgsIdx;
        }
        this.strings = strings;
        if (specialize) {
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info("dstring(" + Long.toBinaryString(this.descriptor) + ")\tbound directly", new Object[0]);
            }
            binder = binder.append(Helpers.arrayOf(Encoding.class, Integer.TYPE), new Object[]{this.encoding, this.initialSize});
            this.setTarget(binder.invokeStaticQuiet(BuildDynamicStringSite.class, "buildString"));
        } else if (dynamicArgs <= 5) {
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info("dstring(" + Long.toBinaryString(this.descriptor) + ")\tbound to unrolled loop", new Object[0]);
            }
            binder = binder.prepend(this).append(Helpers.arrayOf(Encoding.class, Integer.TYPE), new Object[]{this.encoding, this.initialSize});
            this.setTarget(binder.invokeVirtualQuiet("buildString2"));
        } else {
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info("dstring(" + Long.toBinaryString(this.descriptor) + ")\tbound to loop", new Object[0]);
            }
            binder = binder.prepend(this).collect(2, Appendable[].class);
            this.setTarget(binder.invokeVirtualQuiet("buildStringFromMany"));
        }
    }

    private static MethodHandle constructGuardedToStringFilter() {
        MethodType toSType = MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class);
        CallSite toS = SelfInvokeSite.bootstrap(MethodHandles.lookup(), "invokeFunctional:to_s", toSType, 0, 0, "", -1);
        MethodHandle toS_handle = toS.dynamicInvoker();
        MethodType checkedToSType = MethodType.methodType(Appendable.class, ThreadContext.class, IRubyObject.class);
        MethodHandle checkedToS = Binder.from(checkedToSType).fold(toS_handle).invokeStaticQuiet(BuildDynamicStringSite.class, "castToSResultOrAny");
        MethodHandle checkcast = Binder.from(toSType.changeReturnType(Boolean.TYPE)).permute(1).cast(Boolean.TYPE, Object.class).prepend(Appendable.class).invokeVirtualQuiet("isInstance");
        MethodHandle guardedToS = MethodHandles.guardWithTest(checkcast, Binder.from(toSType.changeReturnType(Appendable.class)).permute(1).cast(Appendable.class, Appendable.class).identity(), checkedToS);
        return guardedToS;
    }

    public static Appendable castToSResultOrAny(IRubyObject toSResult, ThreadContext context, IRubyObject original) {
        if (toSResult instanceof RubyString) {
            RubyString str = (RubyString)toSResult;
            return str;
        }
        return Convert.anyToString(context, original);
    }

    public static RubyString buildString(ThreadContext context, Appendable a, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, Appendable b2, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        b2.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, ByteListAndCodeRange b2, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, Appendable b2, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        b2.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, Appendable b2, Appendable c, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        b2.appendIntoString(buffer);
        c.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, Appendable b2, ByteListAndCodeRange c, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        b2.appendIntoString(buffer);
        buffer.catWithCodeRange(c.bl, c.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, ByteListAndCodeRange b2, Appendable c, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        c.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, ByteListAndCodeRange b2, ByteListAndCodeRange c, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.catWithCodeRange(c.bl, c.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, Appendable b2, Appendable c, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        b2.appendIntoString(buffer);
        c.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, Appendable b2, ByteListAndCodeRange c, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        b2.appendIntoString(buffer);
        buffer.catWithCodeRange(c.bl, c.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, Appendable c, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        c.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, ByteListAndCodeRange c, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.catWithCodeRange(c.bl, c.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, Appendable b2, Appendable c, Appendable d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        b2.appendIntoString(buffer);
        c.appendIntoString(buffer);
        d.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, Appendable b2, Appendable c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        b2.appendIntoString(buffer);
        c.appendIntoString(buffer);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, Appendable b2, ByteListAndCodeRange c, Appendable d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        b2.appendIntoString(buffer);
        buffer.catWithCodeRange(c.bl, c.cr);
        d.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, Appendable b2, ByteListAndCodeRange c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        b2.appendIntoString(buffer);
        buffer.catWithCodeRange(c.bl, c.cr);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, ByteListAndCodeRange b2, Appendable c, Appendable d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        c.appendIntoString(buffer);
        d.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, ByteListAndCodeRange b2, Appendable c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        c.appendIntoString(buffer);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, ByteListAndCodeRange b2, ByteListAndCodeRange c, Appendable d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.catWithCodeRange(c.bl, c.cr);
        d.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, Appendable a, ByteListAndCodeRange b2, ByteListAndCodeRange c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
        a.appendIntoString(buffer);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.catWithCodeRange(c.bl, c.cr);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, Appendable b2, Appendable c, Appendable d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        b2.appendIntoString(buffer);
        c.appendIntoString(buffer);
        d.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, Appendable b2, Appendable c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        b2.appendIntoString(buffer);
        c.appendIntoString(buffer);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, Appendable b2, ByteListAndCodeRange c, Appendable d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        b2.appendIntoString(buffer);
        buffer.catWithCodeRange(c.bl, c.cr);
        d.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, Appendable b2, ByteListAndCodeRange c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        b2.appendIntoString(buffer);
        buffer.catWithCodeRange(c.bl, c.cr);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, Appendable c, Appendable d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        c.appendIntoString(buffer);
        d.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, Appendable c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        c.appendIntoString(buffer);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, ByteListAndCodeRange c, Appendable d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.catWithCodeRange(c.bl, c.cr);
        d.appendIntoString(buffer);
        return buffer;
    }

    public static RubyString buildString(ThreadContext context, ByteListAndCodeRange a, ByteListAndCodeRange b2, ByteListAndCodeRange c, ByteListAndCodeRange d, Encoding encoding2, int initialSize) {
        RubyString buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, a);
        buffer.catWithCodeRange(b2.bl, b2.cr);
        buffer.catWithCodeRange(c.bl, c.cr);
        buffer.catWithCodeRange(d.bl, d.cr);
        return buffer;
    }

    public RubyString buildString2(ThreadContext context, Encoding encoding2, int initialSize) {
        return this.buildString2(context, null, null, null, null, encoding2, initialSize);
    }

    public RubyString buildString2(ThreadContext context, Appendable a, Encoding encoding2, int initialSize) {
        return this.buildString2(context, a, null, null, null, null, encoding2, initialSize);
    }

    public RubyString buildString2(ThreadContext context, Appendable a, Appendable b2, Encoding encoding2, int initialSize) {
        return this.buildString2(context, a, b2, null, null, null, encoding2, initialSize);
    }

    public RubyString buildString2(ThreadContext context, Appendable a, Appendable b2, Appendable c, Encoding encoding2, int initialSize) {
        return this.buildString2(context, a, b2, c, null, null, encoding2, initialSize);
    }

    public RubyString buildString2(ThreadContext context, Appendable a, Appendable b2, Appendable c, Appendable d, Encoding encoding2, int initialSize) {
        return this.buildString2(context, a, b2, c, d, null, encoding2, initialSize);
    }

    public RubyString buildString2(ThreadContext context, Appendable a, Appendable b2, Appendable c, Appendable d, Appendable e, Encoding encoding2, int initialSize) {
        int i2;
        RubyString buffer;
        long descriptor = this.descriptor;
        ByteListAndCodeRange[] strings = this.strings;
        if (BuildDynamicStringSite.isDynamicElement(descriptor, 0)) {
            buffer = StringBootstrap.bufferString(context, encoding2, initialSize, 16);
            i2 = 0;
        } else {
            buffer = BuildDynamicStringSite.createBufferFromStaticString(context, initialSize, strings[0]);
            i2 = 1;
        }
        int dynamicArg = 0;
        int elementCount = this.elementCount;
        while (i2 < elementCount) {
            if (BuildDynamicStringSite.isDynamicElement(descriptor, i2)) {
                Appendable dynamicElement = switch (dynamicArg++) {
                    case 0 -> a;
                    case 1 -> b2;
                    case 2 -> c;
                    case 3 -> d;
                    case 4 -> e;
                    default -> throw new RuntimeException("BUG: trying to use buildString2 with more than 5 dynamic args");
                };
                dynamicElement.appendIntoString(buffer);
            } else {
                ByteListAndCodeRange string2 = strings[i2];
                buffer.catWithCodeRange(string2.bl, string2.cr);
            }
            ++i2;
        }
        if (this.frozen) {
            buffer.freeze(context);
        } else if (this.chilled) {
            buffer.chill();
        }
        return buffer;
    }

    private static RubyString createBufferFromStaticString(ThreadContext context, int initialSize, ByteListAndCodeRange firstString) {
        ByteList firstStringByteList = firstString.bl;
        int firstStringCR = firstString.cr;
        byte[] bufferArray = Arrays.copyOfRange(firstStringByteList.unsafeBytes(), firstStringByteList.begin(), initialSize);
        ByteList bufferByteList = new ByteList(bufferArray, 0, firstStringByteList.realSize(), firstStringByteList.getEncoding(), false);
        RubyString buffer = RubyString.newString(context.runtime, bufferByteList, firstStringCR);
        return buffer;
    }

    private static boolean isDynamicElement(long descriptor, int i2) {
        if (i2 > 63) {
            throw new ArrayIndexOutOfBoundsException("bit " + i2 + " out of long range");
        }
        return (descriptor & 1L << i2) == 0L;
    }

    private static boolean isStringElement(long descriptor, int i2) {
        if (i2 > 63) {
            throw new ArrayIndexOutOfBoundsException("bit " + i2 + " out of long range");
        }
        return (descriptor & 1L << i2) != 0L;
    }

    public RubyString buildStringFromMany(ThreadContext context, Appendable ... values2) {
        RubyString buffer = StringBootstrap.bufferString(context, this.encoding, this.initialSize, 16);
        int valueIdx = 0;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            if (BuildDynamicStringSite.isStringElement(this.descriptor, i2)) {
                buffer.catWithCodeRange(this.strings[i2].bl, this.strings[i2].cr);
                continue;
            }
            values2[valueIdx++].appendIntoString(buffer);
        }
        if (this.frozen) {
            buffer.freeze(context);
        } else if (this.chilled) {
            buffer.chill();
        }
        return buffer;
    }

    record ByteListAndCodeRange(ByteList bl, int cr) {
    }
}

