/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.dirgra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.jruby.dirgra.DataIterable;
import org.jruby.dirgra.DirectedGraph;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.EdgeTypeIterable;
import org.jruby.dirgra.ExplicitVertexID;

public class Vertex<T extends ExplicitVertexID, U>
implements Comparable<Vertex<T, U>> {
    private static final Edge[] EMPTY_EDGE_LIST = new Edge[0];
    private DirectedGraph graph;
    private T data;
    private Edge<T, U>[] incoming = EMPTY_EDGE_LIST;
    private int incomingLength = 0;
    private Edge<T, U>[] outgoing = EMPTY_EDGE_LIST;
    private int outgoingLength = 0;
    int id;

    public Vertex(DirectedGraph graph, T data2, int id) {
        this.graph = graph;
        this.data = data2;
        this.id = id;
    }

    public void addEdgeTo(Vertex destination) {
        this.addEdgeTo((T)destination, null);
    }

    public void addEdgeTo(Vertex destination, U type2) {
        Edge newEdge = this.graph.addEdge(new Edge(this, destination, type2));
        this.addOutgoingEdge(newEdge);
        destination.addIncomingEdge(newEdge);
    }

    public void addEdgeTo(T destination) {
        this.addEdgeTo(destination, null);
    }

    public void addEdgeTo(T destination, U type2) {
        Vertex destinationVertex = this.graph.findOrCreateVertexFor(destination);
        this.addEdgeTo((T)destinationVertex, type2);
    }

    public boolean removeEdgeTo(Vertex destination) {
        for (int i2 = 0; i2 < this.outgoingLength; ++i2) {
            Edge<T, U> edge = this.outgoing[i2];
            if (edge.getDestination() != destination) continue;
            this.graph.removeEdge(edge);
            return true;
        }
        return false;
    }

    protected void addOutgoingEdge(Edge<T, U> newEdge) {
        for (int i2 = 0; i2 < this.outgoingLength; ++i2) {
            if (!this.outgoing[i2].equals(newEdge)) continue;
            return;
        }
        if (this.outgoingLength >= this.outgoing.length) {
            this.outgoing = this.graph.growEdges(this.outgoing, this.outgoingLength);
        }
        this.outgoing[this.outgoingLength++] = newEdge;
    }

    protected void addIncomingEdge(Edge<T, U> newEdge) {
        for (int i2 = 0; i2 < this.incomingLength; ++i2) {
            if (this.incoming[i2] != newEdge) continue;
            return;
        }
        if (this.incomingLength >= this.incoming.length) {
            this.incoming = this.graph.growEdges(this.incoming, this.incomingLength);
        }
        this.incoming[this.incomingLength++] = newEdge;
    }

    protected void removeOutgoingEdge(Edge<T, U> edge) {
        int splitIndex = -1;
        for (int i2 = 0; i2 < this.outgoingLength; ++i2) {
            if (!this.outgoing[i2].equals(edge)) continue;
            splitIndex = i2;
            break;
        }
        if (splitIndex == -1) {
            return;
        }
        if (splitIndex != this.outgoingLength - 1) {
            System.arraycopy(this.outgoing, splitIndex + 1, this.outgoing, splitIndex, this.outgoingLength - 1 - splitIndex);
        }
        this.outgoing[this.outgoingLength - 1] = null;
        --this.outgoingLength;
    }

    protected void removeIncomingEdge(Edge<T, U> edge) {
        int splitIndex = -1;
        for (int i2 = 0; i2 < this.incomingLength; ++i2) {
            if (!this.incoming[i2].equals(edge)) continue;
            splitIndex = i2;
            break;
        }
        if (splitIndex == -1) {
            return;
        }
        if (splitIndex != this.incomingLength - 1) {
            System.arraycopy(this.incoming, splitIndex + 1, this.incoming, splitIndex, this.incomingLength - 1 - splitIndex);
        }
        this.incoming[this.incomingLength - 1] = null;
        --this.incomingLength;
    }

    public void removeAllIncomingEdges() {
        while (this.incomingLength > 0) {
            this.graph.removeEdge(this.incoming[0]);
        }
        this.incoming = EMPTY_EDGE_LIST;
    }

    public void removeAllOutgoingEdges() {
        while (this.outgoingLength > 0) {
            this.graph.removeEdge(this.outgoing[0]);
        }
        this.outgoing = EMPTY_EDGE_LIST;
    }

    public void removeAllEdges() {
        this.removeAllIncomingEdges();
        this.removeAllOutgoingEdges();
    }

    public int inDegree() {
        return this.incomingLength;
    }

    public int outDegree() {
        return this.outgoingLength;
    }

    public Iterable<Edge<T, U>> getIncomingEdgesOfType(U type2) {
        return new EdgeTypeIterable<T, U>(this.incoming, this.incomingLength, type2);
    }

    public Iterable<Edge<T, U>> getIncomingEdgesNotOfType(U type2) {
        return new EdgeTypeIterable<T, U>(this.incoming, this.incomingLength, type2, true);
    }

    public Iterable<Edge<T, U>> getOutgoingEdgesOfType(U type2) {
        return new EdgeTypeIterable<T, U>(this.outgoing, this.outgoingLength, type2);
    }

    public T getIncomingSourceData() {
        Edge<T, U> edge = this.getFirstEdge(this.getIncomingEdges().iterator());
        return edge == null ? null : (T)edge.getSource().getData();
    }

    public T getIncomingSourceDataOfType(U type2) {
        Edge<T, U> edge = this.getFirstEdge(this.getIncomingEdgesOfType(type2).iterator());
        return edge == null ? null : (T)edge.getSource().getData();
    }

    public Iterable<T> getIncomingSourcesData() {
        return new DataIterable<T, U>(this.incoming, this.incomingLength, null, true, true);
    }

    public Iterable<T> getIncomingSourcesDataOfType(U type2) {
        return new DataIterable<T, U>(this.incoming, this.incomingLength, type2, true, false);
    }

    public Iterable<T> getIncomingSourcesDataNotOfType(U type2) {
        return new DataIterable<T, U>(this.incoming, this.incomingLength, type2, true, true);
    }

    public Iterable<Edge<T, U>> getOutgoingEdgesNotOfType(U type2) {
        return new EdgeTypeIterable<T, U>(this.outgoing, this.outgoingLength, type2, true);
    }

    public Iterable<T> getOutgoingDestinationsData() {
        return new DataIterable<T, U>(this.outgoing, this.outgoingLength, null, false, true);
    }

    public Iterable<T> getOutgoingDestinationsDataOfType(Object type2) {
        return new DataIterable<T, U>(this.outgoing, this.outgoingLength, type2, false, false);
    }

    public Iterable<T> getOutgoingDestinationsDataNotOfType(Object type2) {
        return new DataIterable<T, U>(this.outgoing, this.outgoingLength, type2, false, true);
    }

    public T getOutgoingDestinationData() {
        Edge<T, U> edge = this.getFirstEdge(this.getOutgoingEdges().iterator());
        return edge == null ? null : (T)edge.getDestination().getData();
    }

    public T getOutgoingDestinationDataOfType(U type2) {
        Edge<T, U> edge = this.getFirstEdge(this.getOutgoingEdgesOfType(type2).iterator());
        return edge == null ? null : (T)edge.getDestination().getData();
    }

    private Edge<T, U> getFirstEdge(Iterator<Edge<T, U>> iterator) {
        return iterator.hasNext() ? iterator.next() : null;
    }

    public Edge<T, U> getIncomingEdgeOfType(U type2) {
        return this.getFirstEdge(this.getIncomingEdgesOfType(type2).iterator());
    }

    public Edge<T, U> getOutgoingEdgeOfType(U type2) {
        return this.getFirstEdge(this.getOutgoingEdgesOfType(type2).iterator());
    }

    public Edge<T, U> getIncomingEdge() {
        return this.getFirstEdge(this.getIncomingEdgesNotOfType(null).iterator());
    }

    public Edge<T, U> getOutgoingEdge() {
        return this.getFirstEdge(this.getOutgoingEdgesNotOfType(null).iterator());
    }

    public Collection<Edge<T, U>> getIncomingEdges() {
        return Arrays.asList(Arrays.copyOf(this.incoming, this.incomingLength));
    }

    public Collection<Edge<T, U>> getOutgoingEdges() {
        return Arrays.asList(Arrays.copyOf(this.outgoing, this.outgoingLength));
    }

    public T getData() {
        return this.data;
    }

    public int getID() {
        return this.data.getID();
    }

    public String toString() {
        int i2;
        ArrayList<Edge<T, U>> e;
        boolean found = false;
        StringBuilder buf = new StringBuilder(this.data.toString());
        buf.append(":");
        Collection<Edge<T, U>> edges = this.getOutgoingEdges();
        int size2 = edges.size();
        if (size2 > 0) {
            found = true;
            buf.append(">[");
            e = new ArrayList<Edge<T, U>>(edges);
            Collections.sort(e, new DestinationCompare());
            for (i2 = 0; i2 < size2 - 1; ++i2) {
                buf.append(((Edge)e.get(i2)).getDestination().getID()).append(",");
            }
            buf.append(((Edge)e.get(size2 - 1)).getDestination().getID()).append("]");
        }
        if ((size2 = (edges = this.getIncomingEdges()).size()) > 0) {
            if (found) {
                buf.append(", ");
            }
            buf.append("<[");
            e = new ArrayList<Edge<T, U>>(edges);
            Collections.sort(e, new SourceCompare());
            for (i2 = 0; i2 < size2 - 1; ++i2) {
                buf.append(((Edge)e.get(i2)).getSource().getID()).append(",");
            }
            buf.append(((Edge)e.get(size2 - 1)).getSource().getID()).append("]");
        }
        buf.append("\n");
        return buf.toString();
    }

    @Override
    public int compareTo(Vertex<T, U> that) {
        if (this.getID() == that.getID()) {
            return 0;
        }
        if (this.getID() < that.getID()) {
            return -1;
        }
        return 1;
    }

    class DestinationCompare
    implements Comparator<Edge<T, U>> {
        DestinationCompare() {
        }

        @Override
        public int compare(Edge<T, U> o1, Edge<T, U> o2) {
            int i2;
            int i1 = o1.getDestination().getID();
            if (i1 == (i2 = o2.getDestination().getID())) {
                return 0;
            }
            return i1 < i2 ? -1 : 1;
        }
    }

    class SourceCompare
    implements Comparator<Edge<T, U>> {
        SourceCompare() {
        }

        @Override
        public int compare(Edge<T, U> o1, Edge<T, U> o2) {
            int i2;
            int i1 = o1.getSource().getID();
            if (i1 == (i2 = o2.getSource().getID())) {
                return 0;
            }
            return i1 < i2 ? -1 : 1;
        }
    }
}

