/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.exception.JOniException;
import org.joni.exception.TimeoutException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.exceptions.RaiseException;
import org.jruby.parser.ReOptions;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.MarshalEncoding;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RegexpSupport;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.WeakValuedMap;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Regexp"})
public class RubyRegexp
extends RubyObject
implements ReOptions,
EncodingCapable,
MarshalEncoding {
    Regex pattern;
    private ByteList str = ByteList.EMPTY_BYTELIST;
    private RegexpOptions options;
    private IRubyObject timeout;
    private static final ThreadLocal<IRubyObject[]> TL_HOLDER = ThreadLocal.withInitial(() -> new IRubyObject[1]);
    public static final int ARG_ENCODING_FIXED = 16;
    public static final int ARG_ENCODING_NONE = 32;
    static final WeakValuedMap<ByteList, Regex> patternCache = new WeakValuedMap();
    static final WeakValuedMap<ByteList, Regex> quotedPatternCache = new WeakValuedMap();
    static final WeakValuedMap<ByteList, Regex> preprocessedPatternCache = new WeakValuedMap();
    private static final int QUOTED_V = 11;
    private static double MAX_TIMEOUT_VALUE = 1.8446744073709553E10;
    private static final int EMBEDDABLE = 7;

    public void setLiteral() {
        this.setFrozen(true);
        this.options.setLiteral(true);
    }

    public void clearLiteral() {
        this.options.setLiteral(false);
    }

    public boolean isLiteral() {
        return this.options.isLiteral();
    }

    public boolean isKCodeDefault() {
        return this.options.isKcodeDefault();
    }

    public void setEncodingNone() {
        this.options.setEncodingNone(true);
    }

    public void clearEncodingNone() {
        this.options.setEncodingNone(false);
    }

    public boolean isEncodingNone() {
        return this.options.isEncodingNone();
    }

    public KCode getKCode() {
        return this.options.getKCode();
    }

    @Override
    public Encoding getEncoding() {
        return this.pattern.getEncoding();
    }

    @Override
    public void setEncoding(Encoding encoding2) {
    }

    @Override
    public boolean shouldMarshalEncoding() {
        return this.getEncoding() != ASCIIEncoding.INSTANCE;
    }

    @Override
    public Encoding getMarshalEncoding() {
        return this.getEncoding();
    }

    private static Regex makeRegexp(Ruby runtime2, ByteList bytes2, RegexpOptions options2, Encoding enc) {
        try {
            int p2 = bytes2.getBegin();
            return new Regex(bytes2.getUnsafeBytes(), p2, p2 + bytes2.getRealSize(), options2.toJoniOptions(), enc, Syntax.DEFAULT, runtime2.getRegexpWarnings());
        }
        catch (Exception e) {
            String err = e.getMessage();
            RegexpSupport.raiseRegexpError(runtime2, bytes2, enc, options2, err);
            return null;
        }
    }

    public static Regex getRegexpFromCache(Ruby runtime2, ByteList bytes2, Encoding enc, RegexpOptions options2) {
        Regex regex = patternCache.get(bytes2);
        if (regex != null && regex.getEncoding() == enc && regex.getOptions() == options2.toJoniOptions()) {
            return regex;
        }
        regex = RubyRegexp.makeRegexp(runtime2, bytes2, options2, enc);
        regex.setUserObject(bytes2);
        patternCache.put(bytes2, regex);
        return regex;
    }

    static Regex getQuotedRegexpFromCache(ThreadContext context, RubyString str, RegexpOptions options2) {
        Encoding enc;
        ByteList bytes2 = str.getByteList();
        Regex regex = quotedPatternCache.get(bytes2);
        Encoding encoding2 = enc = str.isAsciiOnly() ? USASCIIEncoding.INSTANCE : bytes2.getEncoding();
        if (regex != null && regex.getEncoding() == enc && regex.getOptions() == options2.toJoniOptions()) {
            return regex;
        }
        ByteList quoted = RubyRegexp.quote(str);
        regex = RubyRegexp.makeRegexp(context.runtime, quoted, options2, quoted.getEncoding());
        regex.setUserObject(quoted);
        quotedPatternCache.put(bytes2, regex);
        return regex;
    }

    private static Regex getPreprocessedRegexpFromCache(ThreadContext context, ByteList bytes2, Encoding enc, RegexpOptions options2, RegexpSupport.ErrorMode mode2) {
        Regex regex = preprocessedPatternCache.get(bytes2);
        if (regex != null && regex.getEncoding() == enc && regex.getOptions() == options2.toJoniOptions()) {
            return regex;
        }
        ByteList preprocessed = RegexpSupport.preprocess(context.runtime, bytes2, enc, new Encoding[]{null}, RegexpSupport.ErrorMode.RAISE);
        regex = RubyRegexp.makeRegexp(context.runtime, preprocessed, options2, enc);
        regex.setUserObject(preprocessed);
        preprocessedPatternCache.put(bytes2, regex);
        return regex;
    }

    public static RubyClass createRegexpClass(ThreadContext context, RubyClass Object2) {
        RubyClass Regexp2 = ((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "Regexp", Object2, RubyRegexp::new).reifiedClass(RubyRegexp.class)).kindOf(new RubyModule.JavaClassKindOf(RubyRegexp.class))).classIndex(ClassIndex.REGEXP)).defineConstant(context, "IGNORECASE", Convert.asFixnum(context, 1))).defineConstant(context, "EXTENDED", Convert.asFixnum(context, 2))).defineConstant(context, "MULTILINE", Convert.asFixnum(context, 4))).defineConstant(context, "FIXEDENCODING", Convert.asFixnum(context, 16))).defineConstant(context, "NOENCODING", Convert.asFixnum(context, 32))).defineMethods(context, RubyRegexp.class).tap(c -> c.singletonClass(context).defineAlias(context, "compile", "new"));
        context.runtime.setRubyTimeout(context.nil);
        return Regexp2;
    }

    public static int matcherSearch(ThreadContext context, Matcher matcher, int start2, int range, int option) {
        if (!Access.instanceConfig(context).isInterruptibleRegexps()) {
            return matcher.search(start2, range, option);
        }
        try {
            return context.getThread().executeRegexp(context, matcher, start2, range, option, Matcher::searchInterruptible);
        }
        catch (TimeoutException e) {
            throw context.runtime.newRaiseException(context.runtime.getRegexpTimeoutError(), "regexp match timeout");
        }
        catch (InterruptedException e) {
            throw context.runtime.newInterruptedRegexpError("Regexp Interrupted");
        }
    }

    public static int matcherMatch(ThreadContext context, Matcher matcher, int start2, int range, int option) {
        if (!Access.instanceConfig(context).isInterruptibleRegexps()) {
            return matcher.match(start2, range, option);
        }
        try {
            return context.getThread().executeRegexp(context, matcher, start2, range, option, Matcher::matchInterruptible);
        }
        catch (TimeoutException e) {
            throw context.runtime.newRaiseException(context.runtime.getRegexpTimeoutError(), "regexp match timeout");
        }
        catch (InterruptedException e) {
            throw context.runtime.newInterruptedRegexpError("Regexp Interrupted");
        }
    }

    @Deprecated(since="9.2.0.0")
    public static int matcherSearch(Ruby runtime2, Matcher matcher, int start2, int range, int option) {
        return RubyRegexp.matcherSearch(runtime2.getCurrentContext(), matcher, start2, range, option);
    }

    @Deprecated(since="9.2.0.0")
    public static int matcherMatch(Ruby runtime2, Matcher matcher, int start2, int range, int option) {
        return RubyRegexp.matcherMatch(runtime2.getCurrentContext(), matcher, start2, range, option);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.REGEXP;
    }

    private RubyRegexp(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
        this.options = new RegexpOptions();
    }

    RubyRegexp(Ruby runtime2) {
        super(runtime2, runtime2.getRegexp());
        this.options = new RegexpOptions();
    }

    public RubyRegexp(Ruby runtime2, Regex pattern, ByteList str, RegexpOptions options2) {
        super(runtime2, runtime2.getRegexp());
        this.pattern = pattern;
        this.str = str;
        this.options = options2;
    }

    private RubyRegexp(Ruby runtime2, ByteList str) {
        this(runtime2);
        assert (str != null);
        this.str = str;
        this.pattern = RubyRegexp.getRegexpFromCache(runtime2, str, str.getEncoding(), RegexpOptions.NULL_OPTIONS);
    }

    private RubyRegexp(Ruby runtime2, ByteList str, RegexpOptions options2) {
        this(runtime2);
        assert (str != null);
        this.regexpInitialize(str, str.getEncoding(), options2, null);
    }

    public static RubyRegexp newRegexp(Ruby runtime2, String pattern, RegexpOptions options2) {
        return RubyRegexp.newRegexp(runtime2, ByteList.create(pattern), options2);
    }

    public static RubyRegexp newRegexp(Ruby runtime2, ByteList pattern, int options2) {
        return RubyRegexp.newRegexp(runtime2, pattern, RegexpOptions.fromEmbeddedOptions(options2));
    }

    public static RubyRegexp newRegexp(Ruby runtime2, ByteList pattern, RegexpOptions options2) {
        try {
            return new RubyRegexp(runtime2, pattern, options2.clone());
        }
        catch (RaiseException re) {
            throw runtime2.newSyntaxError(re.getMessage());
        }
    }

    public static RubyRegexp newRegexpParser(Ruby runtime2, ByteList pattern, RegexpOptions options2) {
        return new RubyRegexp(runtime2, pattern, options2.clone());
    }

    public static RubyRegexp newDRegexp(Ruby runtime2, RubyString pattern, RegexpOptions options2) {
        try {
            return new RubyRegexp(runtime2, pattern.getByteList(), options2.clone());
        }
        catch (RaiseException re) {
            throw runtime2.newRegexpError(re.getMessage());
        }
    }

    public static RubyRegexp newDRegexp(Ruby runtime2, RubyString pattern, int joniOptions) {
        try {
            RegexpOptions options2 = RegexpOptions.fromJoniOptions(joniOptions);
            return new RubyRegexp(runtime2, pattern.getByteList(), options2);
        }
        catch (RaiseException re) {
            throw runtime2.newRegexpError(re.getMessage());
        }
    }

    public static RubyRegexp newRegexp(Ruby runtime2, ByteList pattern) {
        return new RubyRegexp(runtime2, pattern);
    }

    static RubyRegexp newRegexp(Ruby runtime2, ByteList str, Regex pattern) {
        RubyRegexp regexp2 = new RubyRegexp(runtime2);
        assert (str != null);
        regexp2.str = str;
        regexp2.options = RegexpOptions.fromJoniOptions(pattern.getOptions());
        regexp2.pattern = pattern;
        return regexp2;
    }

    static RubyRegexp newDummyRegexp(Ruby runtime2, Regex regex) {
        RubyRegexp regexp2 = new RubyRegexp(runtime2);
        regexp2.pattern = regex;
        regexp2.str = ByteList.EMPTY_BYTELIST;
        regexp2.options.setFixed(true);
        return regexp2;
    }

    public static RubyRegexp newRegexpFromStr(Ruby runtime2, RubyString s2, int options2) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyRegexp re = (RubyRegexp)runtime2.getRegexp().allocate(context);
        re.regexpInitializeString(context, s2, RegexpOptions.fromJoniOptions(options2), null);
        return re;
    }

    @Deprecated(since="10.0.0.0")
    public final RegexpOptions getOptions() {
        return this.getOptions(this.getCurrentContext());
    }

    public final RegexpOptions getOptions(ThreadContext context) {
        this.check(context);
        return this.options;
    }

    @Deprecated(since="10.0.0.0")
    public final Regex getPattern() {
        return this.getPattern(this.getCurrentContext());
    }

    public final Regex getPattern(ThreadContext context) {
        this.check(context);
        return this.pattern;
    }

    Encoding checkEncoding(ThreadContext context, RubyString other) {
        Encoding enc = other.isCompatibleWith(this);
        if (enc == null) {
            RubyRegexp.encodingMatchError(context, this.pattern, other.getEncoding());
        }
        return enc;
    }

    private static void encodingMatchError(ThreadContext context, Regex pattern, Encoding strEnc) {
        throw context.runtime.newEncodingCompatibilityError("incompatible encoding regexp match (" + String.valueOf(pattern.getEncoding()) + " regexp with " + String.valueOf(strEnc) + " string)");
    }

    private Encoding prepareEncoding(ThreadContext context, RubyString str, boolean warn2) {
        Encoding enc = str.getEncoding();
        int cr = str.scanForCodeRange();
        if (cr == 48) {
            throw Error.argumentError(context, "invalid byte sequence in " + String.valueOf(enc));
        }
        this.check(context);
        Encoding patternEnc = this.pattern.getEncoding();
        if (patternEnc != enc) {
            if (cr == 16 && patternEnc == USASCIIEncoding.INSTANCE) {
                enc = patternEnc;
            } else if (!enc.isAsciiCompatible()) {
                RubyRegexp.encodingMatchError(context, this.pattern, enc);
            } else if (this.options.isFixed()) {
                if (!(enc == patternEnc || patternEnc.isAsciiCompatible() && cr == 16)) {
                    RubyRegexp.encodingMatchError(context, this.pattern, enc);
                }
                enc = patternEnc;
            }
        }
        if (warn2 && this.isEncodingNone() && enc != ASCIIEncoding.INSTANCE && cr != 16) {
            Warn.warn(context, "historical binary regexp match /.../n against " + String.valueOf(enc) + " string");
        }
        return enc;
    }

    @Deprecated(since="10.0.0.0")
    public final Regex preparePattern(RubyString str) {
        return this.preparePattern(this.getCurrentContext(), str);
    }

    public final Regex preparePattern(ThreadContext context, RubyString str) {
        Encoding enc = this.prepareEncoding(context, str, true);
        if (enc == this.pattern.getEncoding()) {
            return this.pattern;
        }
        return RubyRegexp.getPreprocessedRegexpFromCache(context, this.str, enc, this.options, RegexpSupport.ErrorMode.PREPROCESS);
    }

    private static void preprocessLight(ThreadContext context, ByteList str, Encoding enc, Encoding[] fixedEnc, RegexpSupport.ErrorMode mode2) {
        fixedEnc[0] = enc.isAsciiCompatible() ? null : enc;
        boolean hasProperty = RegexpSupport.unescapeNonAscii(context.runtime, null, str.getUnsafeBytes(), str.getBegin(), str.getBegin() + str.getRealSize(), enc, fixedEnc, str, mode2);
        if (hasProperty && fixedEnc[0] == null) {
            fixedEnc[0] = enc;
        }
    }

    public static void preprocessCheck(Ruby runtime2, ByteList bytes2) {
        RegexpSupport.preprocess(runtime2, bytes2, bytes2.getEncoding(), new Encoding[]{null}, RegexpSupport.ErrorMode.RAISE);
    }

    @Deprecated(since="9.2.10.0")
    public static RubyString preprocessDRegexp(Ruby runtime2, RubyString[] strings, int embeddedOptions) {
        return RubyRegexp.preprocessDRegexp(runtime2, (IRubyObject[])strings, RegexpOptions.fromEmbeddedOptions(embeddedOptions));
    }

    public static RubyString preprocessDRegexp(Ruby runtime2, IRubyObject[] strings, RegexpOptions options2) {
        return RubyRegexp.preprocessDRegexp(runtime2.getCurrentContext(), options2, strings);
    }

    public static RubyString preprocessDRegexp(ThreadContext context, RegexpOptions options2, IRubyObject ... args2) {
        RubyString string2 = null;
        Encoding regexpEnc = null;
        for (IRubyObject arg2 : args2) {
            RubyString str = arg2.convertToString();
            regexpEnc = RubyRegexp.processDRegexpElement(context, options2, regexpEnc, context.encodingHolder(), str);
            string2 = string2 == null ? (RubyString)str.dup() : string2.append(str);
        }
        if (regexpEnc != null) {
            string2.setEncoding(regexpEnc);
        }
        return string2;
    }

    public static RubyString preprocessDRegexp(ThreadContext context, RegexpOptions options2, IRubyObject arg0) {
        return RubyRegexp.processElementIntoResult(context, null, arg0, options2, null, context.encodingHolder());
    }

    @Deprecated(since="9.2.10.0")
    public static RubyString preprocessDRegexp(Ruby runtime2, IRubyObject arg0, RegexpOptions options2) {
        ThreadContext context = runtime2.getCurrentContext();
        return RubyRegexp.processElementIntoResult(context, null, arg0, options2, null, context.encodingHolder());
    }

    public static RubyString preprocessDRegexp(ThreadContext context, RegexpOptions options2, IRubyObject arg0, IRubyObject arg1) {
        return RubyRegexp.processElementIntoResult(context, null, arg0, arg1, options2, null, context.encodingHolder());
    }

    @Deprecated(since="9.2.10.0")
    public static RubyString preprocessDRegexp(Ruby runtime2, IRubyObject arg0, IRubyObject arg1, RegexpOptions options2) {
        ThreadContext context = runtime2.getCurrentContext();
        return RubyRegexp.processElementIntoResult(context, null, arg0, arg1, options2, null, context.encodingHolder());
    }

    public static RubyString preprocessDRegexp(ThreadContext context, RegexpOptions options2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RubyRegexp.processElementIntoResult(context, null, arg0, arg1, arg2, options2, null, context.encodingHolder());
    }

    @Deprecated(since="9.2.10.0")
    public static RubyString preprocessDRegexp(Ruby runtime2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, RegexpOptions options2) {
        ThreadContext context = runtime2.getCurrentContext();
        return RubyRegexp.processElementIntoResult(context, null, arg0, arg1, arg2, options2, null, context.encodingHolder());
    }

    @Deprecated(since="9.2.10.0")
    public static RubyString preprocessDRegexp(Ruby runtime2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, RegexpOptions options2) {
        ThreadContext context = runtime2.getCurrentContext();
        return RubyRegexp.processElementIntoResult(context, null, arg0, arg1, arg2, arg3, options2, null, context.encodingHolder());
    }

    @Deprecated(since="9.2.10.0")
    public static RubyString preprocessDRegexp(Ruby runtime2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, RegexpOptions options2) {
        ThreadContext context = runtime2.getCurrentContext();
        return RubyRegexp.processElementIntoResult(context, null, arg0, arg1, arg2, arg3, arg4, options2, null, context.encodingHolder());
    }

    private static RubyString processElementIntoResult(ThreadContext context, RubyString result2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, RegexpOptions options2, Encoding regexpEnc, Encoding[] fixedEnc) {
        RubyString str = arg0.convertToString();
        regexpEnc = RubyRegexp.processDRegexpElement(context, options2, regexpEnc, fixedEnc, str);
        return RubyRegexp.processElementIntoResult(context, result2 == null ? Create.dupString(context, str) : result2.append(str), arg1, arg2, arg3, arg4, options2, regexpEnc, fixedEnc);
    }

    private static RubyString processElementIntoResult(ThreadContext context, RubyString result2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, RegexpOptions options2, Encoding regexpEnc, Encoding[] fixedEnc) {
        RubyString str = arg0.convertToString();
        regexpEnc = RubyRegexp.processDRegexpElement(context, options2, regexpEnc, fixedEnc, str);
        return RubyRegexp.processElementIntoResult(context, result2 == null ? Create.dupString(context, str) : result2.append(str), arg1, arg2, arg3, options2, regexpEnc, fixedEnc);
    }

    private static RubyString processElementIntoResult(ThreadContext context, RubyString result2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, RegexpOptions options2, Encoding regexpEnc, Encoding[] fixedEnc) {
        RubyString str = arg0.convertToString();
        regexpEnc = RubyRegexp.processDRegexpElement(context, options2, regexpEnc, fixedEnc, str);
        return RubyRegexp.processElementIntoResult(context, result2 == null ? Create.dupString(context, str) : result2.append(str), arg1, arg2, options2, regexpEnc, fixedEnc);
    }

    private static RubyString processElementIntoResult(ThreadContext context, RubyString result2, IRubyObject arg0, IRubyObject arg1, RegexpOptions options2, Encoding regexpEnc, Encoding[] fixedEnc) {
        RubyString str = arg0.convertToString();
        regexpEnc = RubyRegexp.processDRegexpElement(context, options2, regexpEnc, fixedEnc, str);
        return RubyRegexp.processElementIntoResult(context, result2 == null ? Create.dupString(context, str) : result2.append(str), arg1, options2, regexpEnc, fixedEnc);
    }

    private static RubyString processElementIntoResult(ThreadContext context, RubyString result2, IRubyObject arg0, RegexpOptions options2, Encoding regexpEnc, Encoding[] fixedEnc) {
        RubyString str = arg0.convertToString();
        regexpEnc = RubyRegexp.processDRegexpElement(context, options2, regexpEnc, fixedEnc, str);
        RubyString rubyString = result2 = result2 == null ? Create.dupString(context, str) : result2.append(str);
        if (regexpEnc != null) {
            result2.setEncoding(regexpEnc);
        }
        return result2;
    }

    private static Encoding processDRegexpElement(ThreadContext context, RegexpOptions options2, Encoding regexpEnc, Encoding[] fixedEnc, RubyString str) {
        Encoding strEnc = str.getEncoding();
        if (options2.isEncodingNone() && strEnc != ASCIIEncoding.INSTANCE) {
            if (str.scanForCodeRange() != 16) {
                throw context.runtime.newRegexpError("/.../n has a non escaped non ASCII character in non ASCII-8BIT script");
            }
            strEnc = ASCIIEncoding.INSTANCE;
        }
        RubyRegexp.preprocessLight(context, str.getByteList(), strEnc, fixedEnc, RegexpSupport.ErrorMode.PREPROCESS);
        if (fixedEnc[0] != null) {
            if (regexpEnc != null && regexpEnc != fixedEnc[0]) {
                throw context.runtime.newRegexpError("encoding mismatch in dynamic regexp: " + new String(regexpEnc.getName()) + " and " + new String(fixedEnc[0].getName()));
            }
            regexpEnc = fixedEnc[0];
        }
        return regexpEnc;
    }

    private void check(ThreadContext context) {
        if (this.pattern == null) {
            throw Error.typeError(context, "uninitialized Regexp");
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject try_convert(ThreadContext context, IRubyObject recv2, IRubyObject args2) {
        return TypeConverter.convertToTypeWithCheck(args2, context.runtime.getRegexp(), "to_regexp");
    }

    @JRubyMethod(name={"quote", "escape"}, meta=true)
    public static RubyString quote(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return Create.newSharedString(context, RubyRegexp.quote(RubyRegexp.operandCheck(context, arg2)));
    }

    static ByteList quote(RubyString str) {
        ByteList bytes2 = str.getByteList();
        ByteList qBytes = RubyRegexp.quote(bytes2, str.isAsciiOnly());
        if (qBytes == bytes2) {
            str.setByteListShared();
        }
        return qBytes;
    }

    static ByteList quote(ByteList bs, boolean asciiOnly) {
        Encoding enc;
        byte[] bytes2;
        int end2;
        int p2;
        block23: {
            p2 = bs.getBegin();
            end2 = p2 + bs.getRealSize();
            bytes2 = bs.getUnsafeBytes();
            enc = bs.getEncoding();
            while (p2 < end2) {
                int c;
                int cl;
                if (enc.isAsciiCompatible()) {
                    cl = 1;
                    c = bytes2[p2] & 0xFF;
                } else {
                    cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                    if (cl < 0) {
                        p2 += StringSupport.length(enc, bytes2, p2, end2);
                        continue;
                    }
                    c = enc.mbcToCode(bytes2, p2, end2);
                }
                if (!Encoding.isAscii(c)) {
                    p2 += StringSupport.length(enc, bytes2, p2, end2);
                    continue;
                }
                switch (c) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 32: 
                    case 35: 
                    case 36: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 45: 
                    case 46: 
                    case 63: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 123: 
                    case 124: 
                    case 125: {
                        break block23;
                    }
                    default: {
                        p2 += cl;
                        break;
                    }
                }
            }
            if (asciiOnly) {
                ByteList tmp = bs.shallowDup();
                tmp.setEncoding(USASCIIEncoding.INSTANCE);
                return tmp;
            }
            return bs;
        }
        ByteList result2 = new ByteList(end2 * 2);
        result2.setEncoding(asciiOnly ? USASCIIEncoding.INSTANCE : bs.getEncoding());
        byte[] obytes = result2.getUnsafeBytes();
        int op = p2 - bs.getBegin();
        System.arraycopy(bytes2, bs.getBegin(), obytes, 0, op);
        block13: while (p2 < end2) {
            int c;
            int cl;
            if (enc.isAsciiCompatible()) {
                cl = 1;
                c = bytes2[p2] & 0xFF;
            } else {
                cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                c = enc.mbcToCode(bytes2, p2, end2);
            }
            if (!Encoding.isAscii(c)) {
                int n = StringSupport.length(enc, bytes2, p2, end2);
                while (n-- > 0) {
                    obytes[op++] = bytes2[p2++];
                }
                continue;
            }
            p2 += cl;
            switch (c) {
                case 35: 
                case 36: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 63: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 123: 
                case 124: 
                case 125: {
                    op += enc.codeToMbc(92, obytes, op);
                    break;
                }
                case 32: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(32, obytes, op);
                    continue block13;
                }
                case 9: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(116, obytes, op);
                    continue block13;
                }
                case 10: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(110, obytes, op);
                    continue block13;
                }
                case 13: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(114, obytes, op);
                    continue block13;
                }
                case 12: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(102, obytes, op);
                    continue block13;
                }
                case 11: {
                    op += enc.codeToMbc(92, obytes, op);
                    op += enc.codeToMbc(118, obytes, op);
                    continue block13;
                }
            }
            op += enc.codeToMbc(c, obytes, op);
        }
        result2.setRealSize(op);
        return result2;
    }

    @JRubyMethod(name={"last_match"}, meta=true, reads={FrameField.BACKREF})
    public static IRubyObject last_match_s(ThreadContext context, IRubyObject recv2) {
        return context.getBackRef();
    }

    @JRubyMethod(name={"last_match"}, meta=true, reads={FrameField.BACKREF})
    public static IRubyObject last_match_s(ThreadContext context, IRubyObject recv2, IRubyObject nth) {
        IRubyObject iRubyObject;
        IRubyObject iRubyObject2 = context.getBackRef();
        if (iRubyObject2 instanceof RubyMatchData) {
            RubyMatchData match2 = (RubyMatchData)iRubyObject2;
            iRubyObject = RubyRegexp.nth_match(context, match2.backrefNumber(context, nth), match2);
        } else {
            iRubyObject = context.nil;
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"union"}, rest=true, meta=true)
    public static IRubyObject union(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject obj;
        if (args2.length == 1 && !(obj = args2[0].checkArrayType()).isNil()) {
            RubyArray ary = (RubyArray)obj;
            IRubyObject[] tmp = new IRubyObject[ary.size()];
            ary.copyInto(context, tmp, 0);
            args2 = tmp;
        }
        Ruby runtime2 = context.runtime;
        if (args2.length == 0) {
            return runtime2.getRegexp().newInstance(context, Create.newString(context, "(?!)"), Block.NULL_BLOCK);
        }
        if (args2.length == 1) {
            IRubyObject re = TypeConverter.convertToTypeWithCheck(args2[0], runtime2.getRegexp(), "to_regexp");
            return !re.isNil() ? re : RubyRegexp.newRegexpFromStr(runtime2, RubyRegexp.quote(context, recv2, args2[0]), 0);
        }
        boolean hasAsciiOnly = false;
        RubyString source2 = runtime2.newString();
        Encoding hasAsciiCompatFixed = null;
        Encoding hasAsciiIncompat = null;
        byte[] verticalVarBytes = new byte[]{124};
        for (int i2 = 0; i2 < args2.length; ++i2) {
            ByteList re;
            Encoding enc;
            IRubyObject v;
            IRubyObject e = args2[i2];
            if (i2 > 0) {
                source2.catAscii(verticalVarBytes, 0, 1);
            }
            if ((v = TypeConverter.convertToTypeWithCheck(e, runtime2.getRegexp(), "to_regexp")) != context.nil) {
                RubyRegexp regex = (RubyRegexp)v;
                enc = regex.getEncoding();
                if (!enc.isAsciiCompatible()) {
                    if (hasAsciiIncompat == null) {
                        hasAsciiIncompat = enc;
                    } else if (hasAsciiIncompat != enc) {
                        throw Error.argumentError(context, "incompatible encodings: " + String.valueOf(hasAsciiIncompat) + " and " + String.valueOf(enc));
                    }
                } else if (regex.getOptions(context).isFixed()) {
                    if (hasAsciiCompatFixed == null) {
                        hasAsciiCompatFixed = enc;
                    } else if (hasAsciiCompatFixed != enc) {
                        throw Error.argumentError(context, "incompatible encodings: " + String.valueOf(hasAsciiCompatFixed) + " and " + String.valueOf(enc));
                    }
                } else {
                    hasAsciiOnly = true;
                }
                re = regex.to_s(context).getByteList();
            } else {
                RubyString str = e.convertToString();
                enc = str.getEncoding();
                if (!enc.isAsciiCompatible()) {
                    if (hasAsciiIncompat == null) {
                        hasAsciiIncompat = enc;
                    } else if (hasAsciiIncompat != enc) {
                        throw Error.argumentError(context, "incompatible encodings: " + String.valueOf(hasAsciiIncompat) + " and " + String.valueOf(enc));
                    }
                } else if (str.isAsciiOnly()) {
                    hasAsciiOnly = true;
                } else if (hasAsciiCompatFixed == null) {
                    hasAsciiCompatFixed = enc;
                } else if (hasAsciiCompatFixed != enc) {
                    throw Error.argumentError(context, "incompatible encodings: " + String.valueOf(hasAsciiCompatFixed) + " and " + String.valueOf(enc));
                }
                re = RubyRegexp.quote(str);
            }
            if (hasAsciiIncompat != null) {
                if (hasAsciiOnly) {
                    throw Error.argumentError(context, "ASCII incompatible encoding: " + String.valueOf(hasAsciiIncompat));
                }
                if (hasAsciiCompatFixed != null) {
                    throw Error.argumentError(context, "incompatible encodings: " + String.valueOf(hasAsciiIncompat) + " and " + String.valueOf(hasAsciiCompatFixed));
                }
            }
            if (i2 == 0) {
                source2.setEncoding(enc);
            }
            source2.cat(re);
        }
        if (hasAsciiIncompat != null) {
            source2.setEncoding(hasAsciiIncompat);
        } else if (hasAsciiCompatFixed != null) {
            source2.setEncoding(hasAsciiCompatFixed);
        } else {
            source2.setEncoding(ASCIIEncoding.INSTANCE);
        }
        return runtime2.getRegexp().newInstance(context, source2, Block.NULL_BLOCK);
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject re) {
        if (this == re) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != re.getMetaClass().getRealClass()) {
            throw Error.typeError(context, "wrong argument type");
        }
        RubyRegexp regexp2 = (RubyRegexp)re;
        regexp2.check(context);
        return this.regexpInitialize(regexp2.str, regexp2.str.getEncoding(), regexp2.getOptions(context), regexp2.timeout);
    }

    private static int objectAsJoniOptions(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)arg2;
            return Convert.toInt(context, fixnum);
        }
        if (arg2 instanceof RubyString) {
            RubyString str = (RubyString)arg2;
            return RegexpOptions.fromByteList(context, str.getByteList()).toJoniOptions();
        }
        if (arg2 instanceof RubyBoolean) {
            return arg2.isTrue() ? 1 : 0;
        }
        if (arg2.isNil()) {
            return 0;
        }
        Warn.warning(context, RubyStringBuilder.str(context.runtime, "expected true or false as ignorecase: ", arg2));
        return 1;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject initialize_m(IRubyObject arg2) {
        return this.initialize_m(this.getCurrentContext(), arg2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_m(ThreadContext context, IRubyObject arg2) {
        IRubyObject iRubyObject;
        if (arg2 instanceof RubyRegexp) {
            RubyRegexp regexp2 = (RubyRegexp)arg2;
            iRubyObject = this.initializeByRegexp(context, regexp2, null);
        } else {
            iRubyObject = this.regexpInitializeString(context, arg2.convertToString(), new RegexpOptions(), null);
        }
        return iRubyObject;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject initialize_m(IRubyObject arg0, IRubyObject arg1) {
        return this.initialize_m(this.getCurrentContext(), arg0, arg1);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, keywords=true)
    public IRubyObject initialize_m(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject timeout2;
        RegexpOptions regexpOptions;
        boolean keywords;
        boolean bl = keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        if (keywords) {
            regexpOptions = new RegexpOptions();
            timeout2 = this.timeoutFromArg(context, arg1);
            if (arg0 instanceof RubyRegexp) {
                RubyRegexp regexp2 = (RubyRegexp)arg0;
                return this.initializeByRegexp(context, regexp2, timeout2);
            }
        } else {
            if (arg0 instanceof RubyRegexp && Options.PARSER_WARN_FLAGS_IGNORED.load().booleanValue()) {
                Warn.warn(context, "flags ignored");
                return this.initializeByRegexp(context, (RubyRegexp)arg0, null);
            }
            regexpOptions = RegexpOptions.fromJoniOptions(RubyRegexp.objectAsJoniOptions(context, arg1));
            timeout2 = null;
        }
        return this.regexpInitializeString(context, arg0.convertToString(), regexpOptions, timeout2);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject initialize_m(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.initialize_m(this.getCurrentContext(), arg0, arg1, arg2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, keywords=true)
    public IRubyObject initialize_m(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        boolean keywords;
        boolean bl = keywords = (ThreadContext.resetCallInfo(context) & 2) != 0;
        if (arg0 instanceof RubyRegexp && Options.PARSER_WARN_FLAGS_IGNORED.load().booleanValue()) {
            Warn.warn(context, "flags ignored");
            return this.initializeByRegexp(context, (RubyRegexp)arg0, this.timeoutFromArg(context, arg2));
        }
        RegexpOptions newOptions = RegexpOptions.fromJoniOptions(RubyRegexp.objectAsJoniOptions(context, arg1));
        if (!keywords) {
            throw Error.argumentError(context, 3, 1, 2);
        }
        return this.regexpInitializeString(context, arg0.convertToString(), newOptions, this.timeoutFromArg(context, arg2));
    }

    private IRubyObject timeoutFromArg(ThreadContext context, IRubyObject arg2) {
        return Convert.castAsHash(context, arg2).fastARef(Convert.asSymbol(context, "timeout"));
    }

    private IRubyObject initializeByRegexp(ThreadContext context, RubyRegexp regexp2, IRubyObject timeoutProvided) {
        RegexpOptions newOptions = regexp2.getOptions(context).clone();
        newOptions.setLiteral(false);
        return this.regexpInitialize(regexp2.str, regexp2.getEncoding(), newOptions, timeoutProvided != null ? timeoutProvided : regexp2.timeout);
    }

    private RubyRegexp regexpInitializeString(ThreadContext context, RubyString str, RegexpOptions options2, IRubyObject timeout2) {
        if (this.isLiteral()) {
            throw context.runtime.newFrozenError(this);
        }
        ByteList bytes2 = str.getByteList();
        Encoding enc = bytes2.getEncoding();
        if (options2.isEncodingNone() && enc != ASCIIEncoding.INSTANCE) {
            if (str.scanForCodeRange() != 16) {
                RegexpSupport.raiseRegexpError(context.runtime, bytes2, enc, options2, "/.../n has a non escaped non ASCII character in non ASCII-8BIT script");
            }
            enc = ASCIIEncoding.INSTANCE;
        }
        return this.regexpInitialize(bytes2, enc, options2, timeout2);
    }

    @Deprecated(since="10.0.0.0")
    public final RubyRegexp regexpInitialize(ByteList bytes2, Encoding enc, RegexpOptions options2) {
        return this.regexpInitialize(bytes2, enc, options2, null);
    }

    public final RubyRegexp regexpInitialize(ByteList bytes2, Encoding enc, RegexpOptions options2, IRubyObject timeout2) {
        Ruby runtime2 = this.metaClass.runtime;
        this.options = options2;
        this.timeout = RubyRegexp.processTimeoutArg(runtime2.getCurrentContext(), timeout2);
        this.checkFrozen();
        if (this.pattern != null) {
            throw Error.typeError(runtime2.getCurrentContext(), "already initialized regexp");
        }
        if (enc.isDummy()) {
            RegexpSupport.raiseRegexpError(runtime2, bytes2, enc, options2, "can't make regexp with dummy encoding");
        }
        Encoding[] fixedEnc = new Encoding[]{null};
        ByteList unescaped = RegexpSupport.preprocess(runtime2, bytes2, enc, fixedEnc, RegexpSupport.ErrorMode.RAISE);
        if (fixedEnc[0] != null) {
            if (fixedEnc[0] != enc && options2.isFixed() || fixedEnc[0] != ASCIIEncoding.INSTANCE && options2.isEncodingNone()) {
                RegexpSupport.raiseRegexpError(runtime2, bytes2, enc, options2, "incompatible character encoding");
            }
            if (fixedEnc[0] != ASCIIEncoding.INSTANCE) {
                options2.setFixed(true);
                enc = fixedEnc[0];
            }
        } else if (!options2.isFixed()) {
            enc = USASCIIEncoding.INSTANCE;
        }
        if (fixedEnc[0] != null) {
            options2.setFixed(true);
        }
        if (options2.isEncodingNone()) {
            this.setEncodingNone();
        }
        this.pattern = RubyRegexp.getRegexpFromCache(runtime2, unescaped, enc, options2);
        assert (bytes2 != null);
        this.str = bytes2;
        return this;
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        this.check(context);
        int hash2 = this.pattern.getOptions();
        int len = this.str.getRealSize();
        int p2 = this.str.getBegin();
        byte[] bytes2 = this.str.getUnsafeBytes();
        while (len-- > 0) {
            hash2 = hash2 * 33 + bytes2[p2++];
        }
        return Convert.asFixnum(context, hash2 + (hash2 >> 5));
    }

    @Override
    @JRubyMethod(name={"==", "eql?"})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.tru;
        }
        if (!(other instanceof RubyRegexp)) {
            return context.fals;
        }
        RubyRegexp otherRegex = (RubyRegexp)other;
        this.check(context);
        otherRegex.check(context);
        return Convert.asBoolean(context, this.str.equal(otherRegex.str) && this.options.equals(otherRegex.options));
    }

    @JRubyMethod(name={"~"}, reads={FrameField.LASTLINE}, writes={FrameField.BACKREF})
    public IRubyObject op_match2(ThreadContext context) {
        int start2;
        IRubyObject line = context.getLastLine();
        if (line instanceof RubyString && (start2 = this.searchString(context, (RubyString)line, 0, false)) >= 0) {
            context.updateBackref();
            return Convert.asFixnum(context, start2);
        }
        context.clearBackRef();
        return context.nil;
    }

    @JRubyMethod(name={"==="}, writes={FrameField.BACKREF})
    public IRubyObject eqq(ThreadContext context, IRubyObject arg2) {
        int start2;
        if (!(arg2 = RubyRegexp.operandNoCheck(context, arg2)).isNil() && (start2 = this.searchString(context, (RubyString)arg2, 0, false)) >= 0) {
            context.updateBackref();
            return context.tru;
        }
        context.clearBackRef();
        return context.fals;
    }

    @Override
    @JRubyMethod(name={"=~"}, writes={FrameField.BACKREF})
    public IRubyObject op_match(ThreadContext context, IRubyObject str) {
        RubyString[] strp = new RubyString[]{null};
        int pos2 = this.matchPos(context, str, strp, true, 0);
        if (pos2 < 0) {
            return context.nil;
        }
        pos2 = strp[0].subLength(pos2);
        return Convert.asFixnum(context, pos2);
    }

    @JRubyMethod(name={"match"}, writes={FrameField.BACKREF})
    public IRubyObject match_m(ThreadContext context, IRubyObject str, Block block) {
        return this.matchCommon(context, str, 0, true, block);
    }

    @JRubyMethod(name={"match"}, writes={FrameField.BACKREF})
    public IRubyObject match_m(ThreadContext context, IRubyObject str, IRubyObject pos2, Block block) {
        return this.matchCommon(context, str, Convert.toInt(context, pos2), true, block);
    }

    public final IRubyObject match_m(ThreadContext context, IRubyObject str, boolean useBackref) {
        return this.matchCommon(context, str, 0, useBackref, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"match?"})
    public IRubyObject match_p(ThreadContext context, IRubyObject str) {
        return this.matchP(context, str, 0);
    }

    @JRubyMethod(name={"match?"})
    public IRubyObject match_p(ThreadContext context, IRubyObject str, IRubyObject pos2) {
        return this.matchP(context, str, Convert.toInt(context, pos2));
    }

    private IRubyObject matchCommon(ThreadContext context, IRubyObject str, int pos2, boolean setBackref, Block block) {
        if (this.matchPos(context, str, null, setBackref, pos2) < 0) {
            return context.nil;
        }
        IRubyObject backref = context.getLocalMatchOrNil();
        if (block.isGiven()) {
            return block.yield(context, backref);
        }
        return backref;
    }

    private int matchPos(ThreadContext context, IRubyObject arg2, RubyString[] strp, boolean useBackref, int pos2) {
        if (arg2 == context.nil) {
            context.clearLocalMatch();
            if (useBackref) {
                context.updateBackref();
            }
            return -1;
        }
        RubyString str = RubyRegexp.operandCheck(context, arg2);
        if (strp != null) {
            strp[0] = str;
        }
        if (pos2 != 0) {
            if (pos2 < 0 && (pos2 += str.strLength()) < 0) {
                return pos2;
            }
            pos2 = str.rbStrOffset(pos2);
        }
        int result2 = this.searchString(context, str, pos2, false);
        if (useBackref) {
            context.updateBackref();
        }
        return result2;
    }

    private RubyBoolean matchP(ThreadContext context, IRubyObject arg2, int pos2) {
        RubyString rubyString;
        if (arg2 == context.nil) {
            return context.fals;
        }
        if (arg2 instanceof RubySymbol) {
            RubySymbol sym = (RubySymbol)arg2;
            rubyString = (RubyString)sym.to_s(context);
        } else {
            rubyString = arg2.convertToString();
        }
        RubyString str = rubyString;
        return this.matchP(context, str, pos2);
    }

    final RubyBoolean matchP(ThreadContext context, RubyString str, int pos2) {
        if (pos2 != 0) {
            if (pos2 < 0 && (pos2 += str.strLength()) < 0) {
                return context.fals;
            }
            pos2 = str.rbStrOffset(pos2);
        }
        Regex reg = this.preparePattern(context, str);
        ByteList strBL = str.getByteList();
        int beg = strBL.begin();
        long timeout2 = this.getRegexpTimeout(context);
        Matcher matcher = reg.matcherNoRegion(strBL.unsafeBytes(), beg, beg + strBL.realSize(), timeout2);
        try {
            int result2 = RubyRegexp.matcherSearch(context, matcher, beg + pos2, beg + strBL.realSize(), 0);
            return result2 == -1 ? context.fals : context.tru;
        }
        catch (JOniException je) {
            throw context.runtime.newRegexpError(je.getMessage());
        }
    }

    @JRubyMethod(meta=true, name={"timeout="})
    public static IRubyObject timeout_set(ThreadContext context, IRubyObject recv2, IRubyObject timeout2) {
        context.runtime.setRubyTimeout(RubyRegexp.processTimeoutArg(context, timeout2));
        return timeout2;
    }

    private static IRubyObject processTimeoutArg(ThreadContext context, IRubyObject timeout2) {
        if (timeout2 == null) {
            return null;
        }
        if (timeout2.isNil()) {
            return context.nil;
        }
        RubyFloat converted = timeout2.convertToFloat();
        if (converted.isInfinite() || converted.value > MAX_TIMEOUT_VALUE) {
            converted = Convert.asFloat(context, MAX_TIMEOUT_VALUE);
        }
        if (converted.value <= 0.0) {
            throw Error.argumentError(context, "invalid timeout: " + String.valueOf(timeout2));
        }
        return converted;
    }

    @JRubyMethod(meta=true, name={"timeout"})
    public static IRubyObject timeout(ThreadContext context, IRubyObject recv2) {
        return context.runtime.getRubyTimeout();
    }

    @JRubyMethod(name={"timeout"})
    public IRubyObject timeout(ThreadContext context) {
        return this.timeout == null ? context.nil : this.timeout;
    }

    private long getRegexpTimeout(ThreadContext context) {
        IRubyObject timeout2 = this.timeout;
        if (timeout2 != null && timeout2.isNil()) {
            return -1L;
        }
        if (timeout2 == null) {
            timeout2 = context.runtime.getRubyTimeout();
        }
        return timeout2.isNil() ? -1L : (long)(timeout2.convertToFloat().asDouble(context) * 1.0E9);
    }

    public final int search(ThreadContext context, RubyString str, int pos2, boolean reverse2) {
        int result2 = this.searchString(context, str, pos2, reverse2);
        context.updateBackref();
        return result2;
    }

    final boolean startsWith(ThreadContext context, RubyString str) {
        ByteList strBL = str.getByteList();
        int beg = strBL.begin();
        Regex reg = this.preparePattern(context, str);
        Matcher matcher = reg.matcher(strBL.unsafeBytes(), beg, beg + strBL.realSize());
        try {
            int result2 = RubyRegexp.matcherMatch(context, matcher, beg, beg + strBL.realSize(), 0);
            if (result2 == -1) {
                context.setLocalMatch(null);
                context.updateBackref();
                return false;
            }
            RubyMatchData match2 = context.getLocalMatch();
            if (match2 == null || match2.used()) {
                match2 = RubyRegexp.createMatchData(context, str, matcher, reg);
            } else {
                match2.initMatchData(str, matcher, reg);
            }
            match2.regexp = this;
            context.setLocalMatch(match2);
            context.updateBackref();
            return true;
        }
        catch (JOniException je) {
            throw context.runtime.newRegexpError(je.getMessage());
        }
    }

    @Deprecated(since="9.3.0.0")
    public final RubyBoolean startWithP(ThreadContext context, RubyString str) {
        return this.startsWith(context, str) ? context.tru : context.fals;
    }

    public final int searchString(ThreadContext context, RubyString str, int pos2, boolean reverse2) {
        int beg;
        ByteList strBL = str.getByteList();
        int range = beg = strBL.begin();
        if (pos2 > str.size() || pos2 < 0) {
            context.setLocalMatch(null);
            return -1;
        }
        Regex reg = this.preparePattern(context, str);
        if (!reverse2) {
            range += str.size();
        }
        long timeout2 = this.getRegexpTimeout(context);
        Matcher matcher = reg.matcher(strBL.unsafeBytes(), beg, beg + strBL.realSize(), timeout2);
        try {
            int result2 = RubyRegexp.matcherSearch(context, matcher, beg + pos2, range, 0);
            if (result2 == -1) {
                context.setLocalMatch(null);
                return -1;
            }
            RubyMatchData match2 = context.getLocalMatch();
            if (match2 == null || match2.used()) {
                match2 = RubyRegexp.createMatchData(context, str, matcher, reg);
            } else {
                match2.initMatchData(str, matcher, reg);
            }
            match2.regexp = this;
            context.setLocalMatch(match2);
            return result2;
        }
        catch (JOniException je) {
            throw context.runtime.newRegexpError(je.getMessage());
        }
    }

    static RubyMatchData createMatchData(ThreadContext context, RubyString str, Matcher matcher, Regex pattern) {
        RubyMatchData match2 = new RubyMatchData(context.runtime);
        match2.initMatchData(str, matcher, pattern);
        return match2;
    }

    static RubyMatchData createMatchData(ThreadContext context, RubyString str, int pos2, RubyString pattern) {
        RubyMatchData match2 = new RubyMatchData(context.runtime);
        match2.initMatchData(str, pos2, pattern);
        return match2;
    }

    @JRubyMethod
    public IRubyObject options(ThreadContext context) {
        return Convert.asFixnum(context, this.getOptions(context).toOptions());
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject options() {
        return this.options(this.getCurrentContext());
    }

    @JRubyMethod(name={"casefold?"})
    public IRubyObject casefold_p(ThreadContext context) {
        return Convert.asBoolean(context, this.getOptions(context).isIgnorecase());
    }

    @JRubyMethod
    public IRubyObject source(ThreadContext context) {
        this.check(context);
        Encoding enc = this.pattern == null ? this.str.getEncoding() : this.pattern.getEncoding();
        ByteList newStr = this.str.dup();
        newStr.setEncoding(enc);
        return Create.newString(context, newStr);
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject source() {
        return this.source(this.getCurrentContext());
    }

    public ByteList rawSource() {
        return this.str;
    }

    public final int length() {
        return this.str.getRealSize();
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return this.pattern == null ? this.anyToString() : Create.newString(context, RegexpSupport.regexpDescription(context.runtime, this.str, this.options, this.str.getEncoding()));
    }

    @Override
    @Deprecated(since="10.0.0.0")
    public RubyString to_s() {
        return this.to_s(this.getCurrentContext());
    }

    @Override
    @JRubyMethod
    public RubyString to_s(ThreadContext context) {
        this.check(context);
        RegexpOptions newOptions = this.options.clone();
        int p2 = this.str.getBegin();
        int len = this.str.getRealSize();
        byte[] bytes2 = this.str.getUnsafeBytes();
        ByteList result2 = new ByteList(len);
        result2.append((byte)40).append((byte)63);
        while (len >= 4 && bytes2[p2] == 40 && bytes2[p2 + 1] == 63) {
            boolean err = true;
            p2 += 2;
            if ((len -= 2) > 0) {
                do {
                    if (bytes2[p2] == 109) {
                        newOptions.setMultiline(true);
                    } else if (bytes2[p2] == 105) {
                        newOptions.setIgnorecase(true);
                    } else {
                        if (bytes2[p2] != 120) break;
                        newOptions.setExtended(true);
                    }
                    ++p2;
                } while (--len > 0);
            }
            if (len > 1 && bytes2[p2] == 45) {
                ++p2;
                --len;
                do {
                    if (bytes2[p2] == 109) {
                        newOptions.setMultiline(false);
                    } else if (bytes2[p2] == 105) {
                        newOptions.setIgnorecase(false);
                    } else {
                        if (bytes2[p2] != 120) break;
                        newOptions.setExtended(false);
                    }
                    ++p2;
                } while (--len > 0);
            }
            if (bytes2[p2] == 41) {
                --len;
                ++p2;
                continue;
            }
            if (bytes2[p2] == 58 && bytes2[p2 + len - 1] == 41) {
                try {
                    Regex regex = new Regex(bytes2, ++p2, p2 + (len -= 2), 0, this.str.getEncoding(), Syntax.DEFAULT, WarnCallback.NONE);
                    err = false;
                }
                catch (JOniException e) {
                    err = true;
                }
            }
            if (!err) break;
            newOptions = this.options;
            p2 = this.str.getBegin();
            len = this.str.getRealSize();
            break;
        }
        RegexpSupport.appendOptions(result2, newOptions);
        if (!newOptions.isEmbeddable()) {
            result2.append((byte)45);
            if (!newOptions.isMultiline()) {
                result2.append((byte)109);
            }
            if (!newOptions.isIgnorecase()) {
                result2.append((byte)105);
            }
            if (!newOptions.isExtended()) {
                result2.append((byte)120);
            }
        }
        result2.append((byte)58);
        Encoding enc = this.str.getEncoding();
        RegexpSupport.appendRegexpString(context.runtime, result2, bytes2, p2, len, enc, null);
        result2.append((byte)41);
        return Create.newString(context, result2, this.getEncoding());
    }

    public String[] getNames() {
        int nameLength = this.pattern.numberOfNames();
        if (nameLength == 0) {
            return StringSupport.EMPTY_STRING_ARRAY;
        }
        String[] names2 = new String[nameLength];
        int j = 0;
        Iterator<NameEntry> i2 = this.pattern.namedBackrefIterator();
        while (i2.hasNext()) {
            NameEntry e = i2.next();
            names2[j++] = new String(e.name, e.nameP, e.nameEnd - e.nameP).intern();
        }
        return names2;
    }

    @JRubyMethod
    public IRubyObject names(ThreadContext context) {
        this.check(context);
        if (this.pattern.numberOfNames() == 0) {
            return Create.newEmptyArray(context);
        }
        RubyArray ary = RubyArray.newBlankArray(context, this.pattern.numberOfNames());
        int index2 = 0;
        Iterator<NameEntry> i2 = this.pattern.namedBackrefIterator();
        while (i2.hasNext()) {
            NameEntry e = i2.next();
            RubyString name2 = RubyString.newStringShared(context.runtime, e.name, e.nameP, e.nameEnd - e.nameP, this.pattern.getEncoding());
            ary.storeInternal(context, index2++, name2);
        }
        return ary;
    }

    @JRubyMethod
    public IRubyObject named_captures(ThreadContext context) {
        this.check(context);
        RubyHash hash2 = Create.newHash(context);
        if (this.pattern.numberOfNames() == 0) {
            return hash2;
        }
        Iterator<NameEntry> i2 = this.pattern.namedBackrefIterator();
        while (i2.hasNext()) {
            NameEntry e = i2.next();
            int[] backrefs = e.getBackRefs();
            RubyArray ary = RubyArray.newBlankArrayInternal(context.runtime, backrefs.length);
            for (int idx = 0; idx < backrefs.length; ++idx) {
                ary.storeInternal(context, idx, Convert.asFixnum(context, backrefs[idx]));
            }
            RubyString name2 = RubyString.newStringShared(context.runtime, e.name, e.nameP, e.nameEnd - e.nameP);
            hash2.fastASet(name2.freeze(context), ary);
        }
        return hash2;
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext context) {
        Encoding enc = this.pattern == null ? this.str.getEncoding() : this.pattern.getEncoding();
        return Access.encodingService(context).getEncoding(enc);
    }

    @JRubyMethod(name={"fixed_encoding?"})
    public IRubyObject fixed_encoding_p(ThreadContext context) {
        return Convert.asBoolean(context, this.options.isFixed());
    }

    private static RegexpArgs extractRegexpArgs(ThreadContext context, IRubyObject[] args2) {
        RubyString string2;
        int callInfo = ThreadContext.resetCallInfo(context);
        int length2 = args2.length;
        IRubyObject timeout2 = null;
        if ((callInfo & 2) != 0) {
            --length2;
            RubyHash opts = Convert.castAsHash(context, args2[args2.length - 1]);
            timeout2 = opts.fastARef(Convert.asSymbol(context, "timeout"));
        }
        int opts = 0;
        if (args2[0] instanceof RubyRegexp) {
            if (length2 > 1) {
                Warn.warn(context, "flags ignored");
            }
            string2 = null;
        } else {
            if (length2 > 1) {
                opts = RubyRegexp.objectAsJoniOptions(context, args2[1]);
            }
            string2 = args2[0].convertToString();
        }
        return new RegexpArgs(string2, opts, timeout2);
    }

    @JRubyMethod(name={"linear_time?"}, meta=true, required=1, optional=1)
    public static IRubyObject linear_time_p(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        RubyRegexp reg;
        RegexpArgs regexpArgs = RubyRegexp.extractRegexpArgs(context, args2);
        IRubyObject iRubyObject = args2[0];
        RubyRegexp regexp2 = iRubyObject instanceof RubyRegexp ? (reg = (RubyRegexp)iRubyObject) : RubyRegexp.newRegexpFromStr(context.runtime, regexpArgs.string, regexpArgs.options);
        regexp2.check(context);
        Regex pattern = regexp2.pattern;
        return pattern != null && pattern.isLinear() ? context.tru : context.fals;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject nth_match(int nth, IRubyObject match2) {
        return RubyRegexp.nth_match(((RubyBasicObject)match2).getCurrentContext(), nth, match2);
    }

    public static IRubyObject nth_match(ThreadContext context, int nth, IRubyObject matchArg) {
        IRubyObject iRubyObject;
        if (matchArg instanceof RubyMatchData) {
            RubyMatchData match2 = (RubyMatchData)matchArg;
            iRubyObject = RubyRegexp.nth_match(context, nth, match2);
        } else {
            iRubyObject = context.nil;
        }
        return iRubyObject;
    }

    static IRubyObject nth_match(ThreadContext context, int nth, RubyMatchData match2) {
        int end2;
        int start2;
        match2.check(context);
        if (match2.regs == null) {
            if (nth >= 1 || nth < 0 && ++nth <= 0) {
                return context.nil;
            }
            start2 = match2.begin;
            end2 = match2.end;
        } else {
            if (nth >= match2.regs.getNumRegs() || nth < 0 && (nth += match2.regs.getNumRegs()) <= 0) {
                return context.nil;
            }
            start2 = match2.regs.getBeg(nth);
            end2 = match2.regs.getEnd(nth);
        }
        return start2 == -1 ? context.nil : match2.str.makeSharedString(context.runtime, start2, end2 - start2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject last_match(IRubyObject match2) {
        return RubyRegexp.last_match(((RubyBasicObject)match2).getCurrentContext(), match2);
    }

    public static IRubyObject last_match(ThreadContext context, IRubyObject match2) {
        return RubyRegexp.nth_match(context, 0, match2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject match_pre(IRubyObject match2) {
        return RubyRegexp.match_pre(((RubyBasicObject)match2).getCurrentContext(), match2);
    }

    public static IRubyObject match_pre(ThreadContext context, IRubyObject matchArg) {
        if (!(matchArg instanceof RubyMatchData)) {
            return context.nil;
        }
        RubyMatchData match2 = (RubyMatchData)matchArg;
        match2.check(context);
        return match2.begin == -1 ? context.nil : match2.str.makeShared(context.runtime, 0, match2.begin);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject match_post(IRubyObject match2) {
        return RubyRegexp.match_post(((RubyBasicObject)match2).getCurrentContext(), match2);
    }

    public static IRubyObject match_post(ThreadContext context, IRubyObject matchArg) {
        if (!(matchArg instanceof RubyMatchData)) {
            return context.nil;
        }
        RubyMatchData match2 = (RubyMatchData)matchArg;
        match2.check(context);
        return match2.begin != -1 ? match2.str.makeShared(context.runtime, match2.end, match2.str.getByteList().getRealSize() - match2.end) : context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject match_last(IRubyObject match2) {
        return RubyRegexp.match_last(((RubyBasicObject)match2).getCurrentContext(), match2);
    }

    public static IRubyObject match_last(ThreadContext context, IRubyObject matchArg) {
        int i2;
        if (!(matchArg instanceof RubyMatchData)) {
            return matchArg;
        }
        RubyMatchData match2 = (RubyMatchData)matchArg;
        match2.check(context);
        if (match2.regs == null || match2.regs.getBeg(0) == -1) {
            return context.nil;
        }
        for (i2 = match2.regs.getNumRegs() - 1; match2.regs.getBeg(i2) == -1 && i2 > 0; --i2) {
        }
        return i2 == 0 ? context.nil : RubyRegexp.nth_match(context, i2, match2);
    }

    private static final int ASCGET(boolean acompat, byte[] sBytes, int s2, int e, int[] cl, Encoding strEnc) {
        if (acompat) {
            cl[0] = 1;
            return Encoding.isAscii(sBytes[s2]) ? sBytes[s2] & 0xFF : -1;
        }
        return EncodingUtils.encAscget(sBytes, s2, e, cl, strEnc);
    }

    static RubyString regsub(ThreadContext context, RubyString str, RubyString src, Regex pattern, Matcher matcher) {
        return RubyRegexp.regsub(context, str, src, pattern, matcher.getRegion(), matcher.getBegin(), matcher.getEnd());
    }

    static RubyString regsub(ThreadContext context, RubyString str, RubyString src, Regex pattern, Region regs, int begin2, int end2) {
        int s2;
        RubyString val = null;
        int no = 0;
        int[] clen = new int[]{0};
        Encoding strEnc = EncodingUtils.encGet(context, str);
        Encoding srcEnc = EncodingUtils.encGet(context, src);
        boolean acompat = EncodingUtils.encAsciicompat(strEnc);
        ByteList bs = str.getByteList();
        ByteList srcbs = src.getByteList();
        byte[] sBytes = bs.getUnsafeBytes();
        int p2 = s2 = bs.getBegin();
        int e = p2 + bs.getRealSize();
        block11: while (s2 < e) {
            int c = RubyRegexp.ASCGET(acompat, sBytes, s2, e, clen, strEnc);
            if (c == -1) {
                s2 += StringSupport.length(strEnc, sBytes, s2, e);
                continue;
            }
            int ss = s2;
            if (c != 92 || (s2 += clen[0]) == e) continue;
            if (val == null) {
                val = Create.newString(context, new ByteList(ss - p2));
            }
            EncodingUtils.encStrBufCat(context.runtime, val, sBytes, p2, ss - p2, strEnc);
            c = RubyRegexp.ASCGET(acompat, sBytes, s2, e, clen, strEnc);
            if (c == -1) {
                s2 += StringSupport.length(strEnc, sBytes, s2, e);
                EncodingUtils.encStrBufCat(context.runtime, val, sBytes, ss, s2 - ss, strEnc);
                p2 = s2;
                continue;
            }
            p2 = s2 += clen[0];
            switch (c) {
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (!pattern.noNameGroupIsActive(Syntax.RUBY)) continue block11;
                    no = c - 48;
                    break;
                }
                case 107: {
                    if (s2 < e && RubyRegexp.ASCGET(acompat, sBytes, s2, e, clen, strEnc) == 60) {
                        int name2;
                        int nameEnd;
                        for (nameEnd = name2 = s2 + clen[0]; nameEnd < e && (c = RubyRegexp.ASCGET(acompat, sBytes, nameEnd, e, clen, strEnc)) != 62; nameEnd += c == -1 ? StringSupport.length(strEnc, sBytes, nameEnd, e) : clen[0]) {
                        }
                        if (nameEnd < e) {
                            try {
                                no = pattern.nameToBackrefNumber(sBytes, name2, nameEnd, regs);
                            }
                            catch (JOniException je) {
                                throw Error.indexError(context, je.getMessage());
                            }
                            p2 = s2 = nameEnd + clen[0];
                            break;
                        }
                        throw Error.runtimeError(context, "invalid group name reference format");
                    }
                    EncodingUtils.encStrBufCat(context.runtime, val, sBytes, ss, s2 - ss, strEnc);
                    continue block11;
                }
                case 38: 
                case 48: {
                    no = 0;
                    break;
                }
                case 96: {
                    EncodingUtils.encStrBufCat(context.runtime, val, srcbs.getUnsafeBytes(), srcbs.getBegin(), begin2, srcEnc);
                    continue block11;
                }
                case 39: {
                    EncodingUtils.encStrBufCat(context.runtime, val, srcbs.getUnsafeBytes(), srcbs.getBegin() + end2, srcbs.getRealSize() - end2, srcEnc);
                    continue block11;
                }
                case 43: {
                    if (regs != null) {
                        for (no = regs.getNumRegs() - 1; regs.getBeg(no) == -1 && no > 0; --no) {
                        }
                    }
                    if (no != 0) break;
                    continue block11;
                }
                case 92: {
                    EncodingUtils.encStrBufCat(context.runtime, val, sBytes, s2 - clen[0], clen[0], strEnc);
                    continue block11;
                }
                default: {
                    EncodingUtils.encStrBufCat(context.runtime, val, sBytes, ss, s2 - ss, strEnc);
                    continue block11;
                }
            }
            if (regs != null) {
                if (no < 0 || no >= regs.getNumRegs() || regs.getBeg(no) == -1) continue;
                EncodingUtils.encStrBufCat(context.runtime, val, srcbs.getUnsafeBytes(), srcbs.getBegin() + regs.getBeg(no), regs.getEnd(no) - regs.getBeg(no), srcEnc);
                continue;
            }
            if (no != 0 || begin2 == -1) continue;
            EncodingUtils.encStrBufCat(context.runtime, val, srcbs.getUnsafeBytes(), srcbs.getBegin() + begin2, end2 - begin2, srcEnc);
        }
        if (val == null) {
            return str;
        }
        if (p2 < e) {
            EncodingUtils.encStrBufCat(context.runtime, val, sBytes, p2, e - p2, strEnc);
        }
        return val;
    }

    final int adjustStartPos(ThreadContext context, RubyString str, int pos2, boolean reverse2) {
        this.check(context);
        return RubyRegexp.adjustStartPosInternal(str, this.pattern.getEncoding(), pos2, reverse2);
    }

    private static int adjustStartPosInternal(RubyString str, Encoding enc, int pos2, boolean reverse2) {
        ByteList value2 = str.getByteList();
        int len = value2.getRealSize();
        if (pos2 > 0 && enc.maxLength() != 1 && pos2 < len) {
            int start2 = value2.getBegin();
            if ((reverse2 ? -pos2 : len - pos2) > 0) {
                return enc.rightAdjustCharHead(value2.getUnsafeBytes(), start2, start2 + pos2, start2 + len) - start2;
            }
            return enc.leftAdjustCharHead(value2.getUnsafeBytes(), start2, start2 + pos2, start2 + len) - start2;
        }
        return pos2;
    }

    private static IRubyObject operandNoCheck(ThreadContext context, IRubyObject str) {
        return RubyRegexp.regOperand(context, str, false);
    }

    private static RubyString operandCheck(ThreadContext context, IRubyObject str) {
        return (RubyString)RubyRegexp.regOperand(context, str, true);
    }

    private static IRubyObject regOperand(ThreadContext context, IRubyObject str, boolean check) {
        if (str instanceof RubySymbol) {
            RubySymbol sym = (RubySymbol)str;
            return sym.to_s(context);
        }
        return check ? str.convertToString() : str.checkStringType();
    }

    @Deprecated(forRemoval=true)
    public static RubyRegexp unmarshalFrom(UnmarshalStream input) throws IOException {
        return RubyRegexp.newRegexp(input.getRuntime(), input.unmarshalString(), RegexpOptions.fromJoniOptions(input.readSignedByte()));
    }

    @Deprecated(since="10.0.0.0", forRemoval=true)
    public static void marshalTo(RubyRegexp regexp2, MarshalStream output) throws IOException {
        ThreadContext context = regexp2.getRuntime().getCurrentContext();
        output.registerLinkTarget(context, regexp2);
        output.writeString(regexp2.str);
        int options2 = regexp2.pattern.getOptions() & 7;
        if (regexp2.getOptions(context).isFixed()) {
            options2 |= 0x10;
        }
        output.writeByte(options2);
    }

    public static void marshalTo(ThreadContext context, RubyRegexp regexp2, MarshalDumper output, RubyOutputStream out) {
        output.registerLinkTarget(regexp2);
        output.writeString(out, regexp2.str);
        int options2 = regexp2.pattern.getOptions() & 7;
        if (regexp2.getOptions(context).isFixed()) {
            options2 |= 0x10;
        }
        output.writeByte(out, options2);
    }

    @Deprecated(since="9.3.0.0")
    public final int search(ThreadContext context, RubyString str, int pos2, boolean reverse2, IRubyObject[] holder) {
        int result2 = this.searchString(context, str, pos2, reverse2);
        if (holder != null) {
            holder[0] = context.getLocalMatchOrNil();
        } else {
            context.setBackRef(context.getLocalMatchOrNil());
        }
        return result2;
    }

    @Deprecated(since="9.3.0.0")
    public static IRubyObject getBackRef(ThreadContext context) {
        return context.getBackRef();
    }

    @Deprecated(since="10.0.0.0")
    public boolean isSimpleString() {
        return this.isSimpleString(this.getCurrentContext());
    }

    public boolean isSimpleString(ThreadContext context) {
        return this.isLiteral() && this.getEncoding().isAsciiCompatible() && RubyString.scanForCodeRange(this.str) == 16 && !this.getOptions(context).isIgnorecase() && (this.str.realSize() == 1 && this.str.charAt(0) != '.' && this.str.charAt(0) != '^' && this.str.charAt(0) != '$' && this.str.charAt(0) != ' ' || this.isExact(this.str));
    }

    private boolean isExact(ByteList str) {
        int size2 = str.realSize();
        byte[] bytes2 = str.unsafeBytes();
        int begin2 = str.begin();
        for (int i2 = 0; i2 < size2; ++i2) {
            switch (bytes2[begin2 + i2]) {
                case 36: 
                case 40: 
                case 42: 
                case 43: 
                case 46: 
                case 63: 
                case 91: 
                case 92: 
                case 94: 
                case 123: 
                case 124: {
                    return false;
                }
            }
        }
        return true;
    }

    private record RegexpArgs(RubyString string, int options, IRubyObject timeout) {
    }
}

