/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.nio.ByteBuffer;
import jnr.constants.platform.Errno;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyIOBuffer;
import org.jruby.RubyInteger;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class FiberScheduler {
    public static IRubyObject kernelSleep(ThreadContext context, IRubyObject scheduler, IRubyObject timeout2) {
        return scheduler.callMethod(context, "kernel_sleep", timeout2);
    }

    public static IRubyObject kernelSleep(ThreadContext context, IRubyObject scheduler, IRubyObject[] args2) {
        return scheduler.callMethod(context, "kernel_sleep", args2);
    }

    public static IRubyObject processWait(ThreadContext context, IRubyObject scheduler, long pid2, int flags2) {
        return Helpers.invokeChecked(context, scheduler, "process_wait", Convert.asFixnum(context, pid2), Convert.asFixnum(context, flags2));
    }

    public static IRubyObject block(ThreadContext context, IRubyObject scheduler, IRubyObject blocker, IRubyObject timeout2) {
        return Helpers.invoke(context, scheduler, "block", blocker, timeout2);
    }

    public static IRubyObject unblock(ThreadContext context, IRubyObject scheduler, IRubyObject blocker, IRubyObject fiber2) {
        return Helpers.invoke(context, scheduler, "unblock", blocker, fiber2);
    }

    public static IRubyObject ioWait(ThreadContext context, IRubyObject scheduler, IRubyObject io2, IRubyObject events, IRubyObject timeout2) {
        return Helpers.invoke(context, scheduler, "io_wait", io2, events, timeout2);
    }

    public static IRubyObject ioWaitReadable(ThreadContext context, IRubyObject scheduler, IRubyObject io2) {
        return FiberScheduler.ioWait(context, scheduler, io2, Convert.asFixnum(context, 1), context.nil);
    }

    public static IRubyObject ioWaitWritable(ThreadContext context, IRubyObject scheduler, IRubyObject io2) {
        return FiberScheduler.ioWait(context, scheduler, io2, Convert.asFixnum(context, 2), context.nil);
    }

    public static IRubyObject ioSelect(ThreadContext context, IRubyObject scheduler, IRubyObject readables, IRubyObject writables, IRubyObject exceptables, IRubyObject timeout2) {
        return FiberScheduler.ioSelectv(context, scheduler, readables, writables, exceptables, timeout2);
    }

    public static IRubyObject ioSelectv(ThreadContext context, IRubyObject scheduler, IRubyObject ... args2) {
        return Helpers.invokeChecked(context, scheduler, "io_select", args2);
    }

    public static IRubyObject ioRead(ThreadContext context, IRubyObject scheduler, IRubyObject io2, IRubyObject buffer, int length2, int offset2) {
        Ruby runtime2 = context.runtime;
        return Helpers.invokeChecked(context, scheduler, "io_read", io2, buffer, Convert.asFixnum(context, length2), Convert.asFixnum(context, offset2));
    }

    public static IRubyObject ioRead(ThreadContext context, IRubyObject scheduler, IRubyObject io2, IRubyObject buffer, RubyInteger length2, RubyInteger offset2) {
        return Helpers.invokeChecked(context, scheduler, "io_read", io2, buffer, length2, offset2);
    }

    public static IRubyObject ioPRead(ThreadContext context, IRubyObject scheduler, IRubyObject io2, IRubyObject buffer, int from, int length2, int offset2) {
        return Helpers.invokeChecked(context, scheduler, "io_pread", io2, buffer, Convert.asFixnum(context, from), Convert.asFixnum(context, length2), Convert.asFixnum(context, offset2));
    }

    public static IRubyObject ioPRead(ThreadContext context, IRubyObject scheduler, IRubyObject io2, IRubyObject buffer, RubyInteger from, RubyInteger length2, RubyInteger offset2) {
        return Helpers.invokeChecked(context, scheduler, "io_pread", io2, buffer, from, length2, offset2);
    }

    public static IRubyObject ioWrite(ThreadContext context, IRubyObject scheduler, IRubyObject io2, IRubyObject buffer, int length2, int offset2) {
        return Helpers.invokeChecked(context, scheduler, "io_write", io2, buffer, Convert.asFixnum(context, length2), Convert.asFixnum(context, offset2));
    }

    public static IRubyObject ioWrite(ThreadContext context, IRubyObject scheduler, IRubyObject io2, IRubyObject buffer, RubyInteger length2, RubyInteger offset2) {
        return Helpers.invokeChecked(context, scheduler, "io_write", io2, buffer, length2, offset2);
    }

    public static IRubyObject ioPWrite(ThreadContext context, IRubyObject scheduler, IRubyObject io2, IRubyObject buffer, int from, int length2, int offset2) {
        return Helpers.invokeChecked(context, scheduler, "io_pwrite", io2, buffer, Convert.asFixnum(context, from), Convert.asFixnum(context, length2), Convert.asFixnum(context, offset2));
    }

    public static IRubyObject ioPWrite(ThreadContext context, IRubyObject scheduler, IRubyObject io2, IRubyObject buffer, RubyInteger from, RubyInteger length2, RubyInteger offset2) {
        return Helpers.invokeChecked(context, scheduler, "io_pwrite", io2, buffer, from, length2, offset2);
    }

    public static IRubyObject ioReadMemory(ThreadContext context, IRubyObject scheduler, IRubyObject io2, ByteBuffer base, int size2, int length2) {
        RubyIOBuffer buffer = RubyIOBuffer.newBuffer(context, base, size2, 32);
        IRubyObject result2 = FiberScheduler.ioRead(context, scheduler, io2, (IRubyObject)buffer, length2, 0);
        buffer.unlock(context);
        buffer.free(context);
        return result2;
    }

    public static IRubyObject ioPReadMemory(ThreadContext context, IRubyObject scheduler, IRubyObject io2, ByteBuffer base, int from, int size2, int length2) {
        RubyIOBuffer buffer = RubyIOBuffer.newBuffer(context, base, size2, 32);
        IRubyObject result2 = FiberScheduler.ioPRead(context, scheduler, io2, (IRubyObject)buffer, from, length2, 0);
        buffer.unlock(context);
        buffer.free(context);
        return result2;
    }

    public static IRubyObject ioWriteMemory(ThreadContext context, IRubyObject scheduler, IRubyObject io2, ByteBuffer base, int size2, int length2) {
        RubyIOBuffer buffer = RubyIOBuffer.newBuffer(context, base, size2, 160);
        IRubyObject result2 = FiberScheduler.ioWrite(context, scheduler, io2, (IRubyObject)buffer, length2, 0);
        buffer.unlock(context);
        buffer.free(context);
        return result2;
    }

    public static IRubyObject ioPWriteMemory(ThreadContext context, IRubyObject scheduler, IRubyObject io2, ByteBuffer base, int from, int size2, int length2) {
        RubyIOBuffer buffer = RubyIOBuffer.newBuffer(context, base, size2, 160);
        IRubyObject result2 = FiberScheduler.ioPWrite(context, scheduler, io2, (IRubyObject)buffer, from, length2, 0);
        buffer.unlock(context);
        buffer.free(context);
        return result2;
    }

    public static IRubyObject ioClose(ThreadContext context, IRubyObject scheduler, IRubyObject io2) {
        return Helpers.invokeChecked(context, scheduler, "io_close", io2);
    }

    public static IRubyObject addressResolve(ThreadContext context, IRubyObject scheduler, IRubyObject hostname) {
        return Helpers.invokeChecked(context, scheduler, "address_resolve", hostname);
    }

    static void verifyInterface(ThreadContext context, IRubyObject scheduler) {
        if (!scheduler.respondsTo("block")) {
            throw Error.argumentError(context, "Scheduler must implement #block");
        }
        if (!scheduler.respondsTo("unblock")) {
            throw Error.argumentError(context, "Scheduler must implement #unblock");
        }
        if (!scheduler.respondsTo("kernel_sleep")) {
            throw Error.argumentError(context, "Scheduler must implement #kernel_sleep");
        }
        if (!scheduler.respondsTo("io_wait")) {
            throw Error.argumentError(context, "Scheduler must implement #io_wait");
        }
    }

    public static IRubyObject close(ThreadContext context, IRubyObject scheduler) {
        IRubyObject result2 = Helpers.invokeChecked(context, scheduler, "scheduler_close");
        if (result2 != null) {
            return result2;
        }
        result2 = Helpers.invokeChecked(context, scheduler, "close");
        if (result2 != null) {
            return result2;
        }
        return context.nil;
    }

    public static int resultApply(ThreadContext context, IRubyObject result2) {
        RubyFixnum fixnum;
        int resultInt;
        if (result2 instanceof RubyFixnum && (resultInt = (fixnum = (RubyFixnum)result2).asInt(context)) < 0) {
            context.runtime.getPosix().errno(-resultInt);
            return -1;
        }
        return Convert.toInt(context, result2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject result(Ruby runtime2, int result2, Errno error2) {
        return FiberScheduler.result(runtime2.getCurrentContext(), result2, error2);
    }

    public static IRubyObject result(ThreadContext context, int result2, Errno error2) {
        return Convert.asFixnum(context, result2 == -1 ? error2.value() : result2);
    }
}

