/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaClassConfiguration
implements Cloneable {
    private static final Set<String> DEFAULT_EXCLUDES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("class", "finalize", "initialize", "java_class", "java_object", "__jcreate!", "java_interfaces", "java_proxy_class")));
    public Map<String, List<Map<Class<?>, Map<String, Object>>>> parameterAnnotations;
    public Map<String, Map<Class<?>, Map<String, Object>>> methodAnnotations;
    public Map<String, Map<Class<?>, Map<String, Object>>> fieldAnnotations;
    public Map<Class<?>, Map<String, Object>> classAnnotations;
    public Map<String, List<Class<?>[]>> methodSignatures;
    public Map<String, Class<?>> fieldSignatures;
    public List<DirectFieldConfiguration> requestedStorageVariables;
    public boolean callInitialize = true;
    public boolean allMethods = true;
    public boolean allClassMethods = true;
    public boolean javaConstructable = true;
    public List<Class<?>[]> extraCtors = new ArrayList<Class<?>[]>(4);
    public boolean allCtors = false;
    public boolean rubyConstructable = true;
    public boolean IroCtors = true;
    public Map<String, String> renamedMethods = new HashMap<String, String>(4);
    public String javaCtorMethodName = "initialize";
    private Set<String> excluded = null;
    private Set<String> included = null;

    public JavaClassConfiguration clone() {
        JavaClassConfiguration other = new JavaClassConfiguration();
        if (this.excluded != null) {
            other.excluded = new HashSet<String>(this.excluded);
        }
        if (this.included != null) {
            other.included = new HashSet<String>(this.included);
        }
        other.javaCtorMethodName = this.javaCtorMethodName;
        other.IroCtors = this.IroCtors;
        other.rubyConstructable = this.rubyConstructable;
        other.allCtors = this.allCtors;
        other.javaConstructable = this.javaConstructable;
        other.allClassMethods = this.allClassMethods;
        other.allMethods = this.allMethods;
        other.callInitialize = this.callInitialize;
        other.renamedMethods = new HashMap<String, String>(this.renamedMethods);
        other.extraCtors = new ArrayList<Class<?>[]>(this.extraCtors);
        if (this.parameterAnnotations != null) {
            other.parameterAnnotations = new HashMap(this.parameterAnnotations);
        }
        if (this.methodAnnotations != null) {
            other.methodAnnotations = new HashMap(this.methodAnnotations);
        }
        if (this.fieldAnnotations != null) {
            other.fieldAnnotations = new HashMap(this.fieldAnnotations);
        }
        if (this.classAnnotations != null) {
            other.classAnnotations = new HashMap(this.classAnnotations);
        }
        if (this.methodSignatures != null) {
            other.methodSignatures = new HashMap<String, List<Class<?>[]>>(this.methodSignatures);
        }
        if (this.fieldSignatures != null) {
            other.fieldSignatures = new HashMap(this.fieldSignatures);
        }
        if (this.requestedStorageVariables != null) {
            other.requestedStorageVariables = new ArrayList<DirectFieldConfiguration>(this.requestedStorageVariables);
        }
        return other;
    }

    public synchronized Set<String> getExcluded() {
        if (this.excluded == null) {
            return DEFAULT_EXCLUDES;
        }
        return this.excluded;
    }

    public synchronized void exclude(String name2) {
        if (this.included == null) {
            this.included = new HashSet<String>();
        }
        if (this.excluded == null) {
            this.excluded = new HashSet<String>(DEFAULT_EXCLUDES);
        }
        this.excluded.add(name2);
        this.included.remove(name2);
    }

    public synchronized Set<String> getIncluded() {
        if (this.included == null) {
            return Collections.EMPTY_SET;
        }
        return this.included;
    }

    public synchronized void include(String name2) {
        if (this.included == null) {
            this.included = new HashSet<String>();
        }
        if (this.excluded == null) {
            this.excluded = new HashSet<String>(DEFAULT_EXCLUDES);
        }
        this.included.add(name2);
        this.excluded.remove(name2);
    }

    public static class DirectFieldConfiguration {
        public String name;
        public Class<?> fieldType;
        public Boolean unwrap;
        public Class<?> unwrapType;

        public DirectFieldConfiguration(String name2, Class<?> fieldType, Boolean unwrap, Class<?> unwrapType) {
            this.name = name2;
            this.fieldType = fieldType;
            this.unwrap = unwrap;
            this.unwrapType = unwrapType;
        }
    }
}

