/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.AbstractRubyMethod;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.internal.runtime.methods.PartialDelegatingMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.MethodBlockBody;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

@JRubyClass(name={"Method"})
public class RubyMethod
extends AbstractRubyMethod {
    protected IRubyObject receiver;

    protected RubyMethod(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public static RubyClass createMethodClass(ThreadContext context, RubyClass Object2) {
        return (RubyClass)((RubyModule)((RubyModule)Define.defineClass(context, "Method", Object2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR).reifiedClass(RubyMethod.class)).classIndex(ClassIndex.METHOD)).defineMethods(context, AbstractRubyMethod.class, RubyMethod.class);
    }

    public static RubyMethod newMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, CacheEntry entry, IRubyObject receiver2) {
        Ruby runtime2 = implementationModule.getRuntime();
        RubyMethod newMethod = new RubyMethod(runtime2, runtime2.getMethod());
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.entry = entry;
        newMethod.method = entry.method;
        newMethod.sourceModule = entry.sourceModule;
        newMethod.receiver = receiver2;
        return newMethod;
    }

    @JRubyMethod(name={"call", "[]"}, keywords=true)
    public IRubyObject call(ThreadContext context, Block block) {
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, block);
    }

    @JRubyMethod(name={"call", "[]"}, keywords=true)
    public IRubyObject call(ThreadContext context, IRubyObject arg2, Block block) {
        arg2 = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, arg2);
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, arg2, block);
    }

    @JRubyMethod(name={"call", "[]"}, keywords=true)
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        arg1 = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, arg1);
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, arg0, arg1, block);
    }

    @JRubyMethod(name={"call", "[]"}, keywords=true)
    public IRubyObject call(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        arg2 = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, arg2);
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, arg0, arg1, arg2, block);
    }

    @JRubyMethod(name={"call", "[]"}, rest=true, keywords=true)
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
        if (args2.length > 0) {
            args2[args2.length - 1] = IRRuntimeHelpers.dupIfKeywordRestAtCallsite(context, args2[args2.length - 1]);
        }
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, args2, block);
    }

    @Override
    @JRubyMethod
    public RubyFixnum arity(ThreadContext context) {
        int max2;
        Signature signature = this.method.getSignature();
        int min2 = signature.min();
        return Convert.asFixnum(context, min2 == (max2 = signature.max()) ? min2 : -min2 - 1);
    }

    @Override
    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql(ThreadContext context, IRubyObject other) {
        return this.op_equal(context, other);
    }

    @Override
    @JRubyMethod(name={"=="})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        return Convert.asBoolean(context, this.equals(other));
    }

    @Override
    @JRubyMethod(name={"==="})
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return this.method.call(context, this.receiver, this.sourceModule, this.methodName, other, Block.NULL_BLOCK);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RubyMethod)) {
            return false;
        }
        if (this.method instanceof ProcMethod) {
            return ((ProcMethod)this.method).isSame(((RubyMethod)other).getMethod());
        }
        if (this.getMetaClass() != ((RubyBasicObject)other).getMetaClass()) {
            return false;
        }
        RubyMethod otherMethod = (RubyMethod)other;
        return this.receiver == otherMethod.receiver && (this.isSerialMatch(otherMethod.method) || this.isMethodMissingMatch(otherMethod.getMethod().getRealMethod()));
    }

    private boolean isMethodMissingMatch(DynamicMethod other) {
        return this.method.getRealMethod() instanceof RubyModule.RespondToMissingMethod && ((RubyModule.RespondToMissingMethod)this.method.getRealMethod()).equals(other);
    }

    private boolean isSerialMatch(DynamicMethod otherMethod) {
        return this.method.getRealMethod().getSerialNumber() == otherMethod.getRealMethod().getSerialNumber();
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.hashCodeImpl());
    }

    @Override
    public int hashCode() {
        return (int)this.hashCodeImpl();
    }

    private long hashCodeImpl() {
        return (long)this.receiver.hashCode() * this.method.getRealMethod().getSerialNumber();
    }

    @Override
    @JRubyMethod(name={"clone"})
    public RubyMethod rbClone() {
        RubyMethod newMethod = RubyMethod.newMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.entry, this.receiver);
        ThreadContext context = this.getRuntime().getCurrentContext();
        return (RubyMethod)this.cloneSetup(context, newMethod, context.nil);
    }

    @Override
    @JRubyMethod
    public RubyMethod dup(ThreadContext context) {
        RubyMethod newMethod = RubyMethod.newMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.entry, this.receiver);
        return (RubyMethod)this.dupSetup(context, newMethod);
    }

    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context) {
        Signature signature = this.method.getSignature();
        ArgumentDescriptor[] argsDesc = this.method instanceof IRMethodArgs ? ((IRMethodArgs)((Object)this.method)).getArgumentDescriptors() : Helpers.methodToArgumentDescriptors(context, this.method);
        int line = this.getLine();
        MethodBlockBody body = new MethodBlockBody(context.runtime.getStaticScopeFactory().getDummyScope(), signature, this.entry, argsDesc, this.receiver, this.originModule, this.originName, this.getFilename(), line == -1 ? -1 : line - 1);
        Block b2 = MethodBlockBody.createMethodBlock(body);
        RubyProc proc2 = RubyProc.newMethodProc(context.runtime, b2);
        return proc2;
    }

    @JRubyMethod
    public RubyUnboundMethod unbind() {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.entry);
        return unboundMethod;
    }

    @Override
    @JRubyMethod(name={"inspect", "to_s"})
    public IRubyObject inspect(ThreadContext context) {
        return this.inspect(this.receiver);
    }

    @JRubyMethod
    public IRubyObject receiver(ThreadContext context) {
        return this.receiver;
    }

    @Override
    @JRubyMethod
    public IRubyObject source_location(ThreadContext context) {
        String filename2 = this.getFilename();
        return filename2 == null ? context.nil : Create.newArray(context, (IRubyObject)Create.newString(context, filename2), (IRubyObject)Convert.asFixnum(context, this.getLine()));
    }

    @Override
    @JRubyMethod
    public IRubyObject parameters(ThreadContext context) {
        return Helpers.methodToParameters(context, (AbstractRubyMethod)this);
    }

    @JRubyMethod
    public IRubyObject curry(ThreadContext context) {
        IRubyObject proc2 = this.to_proc(context);
        return RubyMethod.sites((ThreadContext)context).curry.call(context, proc2, proc2);
    }

    @JRubyMethod
    public IRubyObject curry(ThreadContext context, IRubyObject arg0) {
        IRubyObject proc2 = this.to_proc(context);
        return RubyMethod.sites((ThreadContext)context).curry.call(context, proc2, proc2, arg0);
    }

    @JRubyMethod
    public IRubyObject super_method(ThreadContext context) {
        RubyClass superClass = null;
        if (this.method instanceof PartialDelegatingMethod || this.method instanceof AliasMethod) {
            RubyModule definedClass = this.method.getRealMethod().getDefinedClass();
            RubyModule module = this.sourceModule.findImplementer(definedClass);
            if (module != null) {
                superClass = module.getSuperClass();
            }
        } else {
            superClass = this.sourceModule.getSuperClass();
        }
        return this.super_method(context, this.receiver, superClass);
    }

    @Override
    @JRubyMethod
    public IRubyObject original_name(ThreadContext context) {
        return this.method instanceof AliasMethod ? Convert.asSymbol(context, ((AliasMethod)this.method).getOldName()) : this.name(context);
    }

    public IRubyObject getReceiver() {
        return this.receiver;
    }

    @Deprecated(since="9.4.6.0")
    public IRubyObject curry(ThreadContext context, IRubyObject[] args2) {
        IRubyObject proc2 = this.to_proc(context);
        return RubyMethod.sites((ThreadContext)context).curry.call(context, proc2, proc2, args2);
    }

    private static JavaSites.MethodSites sites(ThreadContext context) {
        return context.sites.Method;
    }
}

