/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubySymbol;
import org.jruby.api.Error;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.ComplexNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.NumericNode;
import org.jruby.ast.RationalNode;
import org.jruby.ast.StrNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.LexingCommon;
import org.jruby.lexer.yacc.HeredocTerm;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.StringTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.ProductionState;
import org.jruby.parser.RubyParserBase;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;

public class RubyLexer
extends LexingCommon {
    private static final HashMap<String, Keyword> map = new HashMap();
    private static final Map<ByteList, Keyword> byteList2Keyword;
    private RubyParserBase parser;
    private IRubyWarnings warnings;
    private StrTerm lex_strterm;
    private final ByteList TRUE = new ByteList(new byte[]{116, 114, 117, 101});
    private final ByteList FALSE = new ByteList(new byte[]{102, 97, 108, 115, 101});
    private ByteList numberBuffer = new ByteList(10);

    private BignumNode newBignumNode(String value2, int radix) {
        return new BignumNode(this.ruby_sourceline, new BigInteger(value2, radix));
    }

    private FixnumNode newFixnumNode(String value2, int radix) throws NumberFormatException {
        return new FixnumNode(this.ruby_sourceline, Long.parseLong(value2, radix));
    }

    private RationalNode newRationalNode(String value2, int radix) throws NumberFormatException {
        NumericNode numerator2;
        try {
            numerator2 = new FixnumNode(this.ruby_sourceline, Long.parseLong(value2, radix));
        }
        catch (NumberFormatException e) {
            numerator2 = new BignumNode(this.ruby_sourceline, new BigInteger(value2, radix));
        }
        return new RationalNode(this.ruby_sourceline, numerator2, new FixnumNode(this.ruby_sourceline, 1L));
    }

    private ComplexNode newComplexNode(NumericNode number) {
        return new ComplexNode(this.ruby_sourceline, number);
    }

    @Override
    protected void ambiguousOperator(String op, String syn) {
        this.warning(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, "'" + op + "' after local variable or literal is interpreted as binary operator");
        this.warning(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, "even though it seems like " + syn);
    }

    private void warning(IRubyWarnings.ID id, String message2) {
        this.warning(id, this.getFile(), this.getRubySourceline(), message2);
    }

    private void warning(IRubyWarnings.ID id, String file2, int line, String message2) {
        this.warnings.warning(id, file2, line + 1, message2);
    }

    private void warn(IRubyWarnings.ID id, String message2) {
        this.warnings.warn(id, this.getFile(), this.getRubySourceline(), message2);
    }

    public static Keyword getKeyword(ByteList str) {
        return byteList2Keyword.get(str);
    }

    public static Keyword getKeyword(String str) {
        return map.get(str);
    }

    public Ruby getRuntime() {
        return this.parser.getRuntime();
    }

    @Override
    public int tokenize_ident(int result2) {
        ByteList value2 = this.createTokenByteList();
        String id = this.getRuntime().newSymbol(value2).idString();
        if (RubyLexer.IS_lex_state(this.last_state, 384) && this.parser.getCurrentScope().isDefined(id) >= 0) {
            this.setState(2);
        }
        this.yaccValue = value2;
        return result2;
    }

    public RubyLexer(RubyParserBase parser, LexerSource source2, IRubyWarnings warnings) {
        super(source2);
        this.parser = parser;
        this.warnings = warnings;
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.lex_strterm = null;
        this.ruby_sourceline = this.src.getLineOffset() - 1;
        this.parser_prepare();
    }

    @Override
    public int nextc() {
        if (this.lex_p == this.lex_pend) {
            this.line_offset += this.lex_pend;
            ByteList v = this.lex_nextline;
            this.lex_nextline = null;
            if (v == null) {
                if (this.eofp) {
                    return -1;
                }
                if (this.src == null || (v = this.src.gets()) == null) {
                    this.eofp = true;
                    this.lex_goto_eol();
                    return -1;
                }
            }
            if (this.heredoc_end > 0) {
                this.ruby_sourceline = this.heredoc_end;
                this.heredoc_end = 0;
            }
            ++this.ruby_sourceline;
            ++this.line_count;
            this.lex_p = 0;
            this.lex_pbeg = 0;
            this.lex_pend = this.lex_p + v.length();
            this.lexb = v;
            this.flush();
            this.lex_lastline = v;
        }
        int c = this.p(this.lex_p);
        ++this.lex_p;
        if (c == 13) {
            if (this.peek(10)) {
                ++this.lex_p;
                c = 10;
            } else if (this.ruby_sourceline > this.last_cr_line) {
                this.last_cr_line = this.ruby_sourceline;
                this.warn(IRubyWarnings.ID.VOID_VALUE_EXPRESSION, "encountered \\r in middle of line, treated as a mere space");
            }
        }
        return c;
    }

    public void heredoc_dedent(Node root) {
        int indent = this.heredoc_indent;
        if (indent <= 0) {
            return;
        }
        this.heredoc_indent = 0;
        if (root == null) {
            return;
        }
        if (root instanceof StrNode) {
            StrNode str = (StrNode)root;
            if (str.isNewline()) {
                RubyLexer.dedent_string(str.getValue(), indent);
            }
        } else if (root instanceof ListNode) {
            ListNode list2 = (ListNode)root;
            int length2 = list2.size();
            for (int i2 = 0; i2 < length2; ++i2) {
                Node child = list2.get(i2);
                if (!(child instanceof StrNode) || !child.isNewline()) continue;
                RubyLexer.dedent_string(((StrNode)child).getValue(), indent);
            }
        }
    }

    public void compile_error(String message2, long start2, long end2) {
        throw new SyntaxException(this.getFile(), this.ruby_sourceline, this.prepareMessage(message2, this.lexb, start2, end2));
    }

    @Override
    public void compile_error(String message2) {
        throw new SyntaxException(this.getFile(), this.ruby_sourceline, this.prepareMessage(message2, this.lex_lastline, this.start, this.end));
    }

    @Override
    public void parse_error(String message2) {
        this.compile_error(message2);
    }

    private String prepareMessage(String message2, ByteList line, long start2, long end2) {
        if (line != null && line.length() > 5) {
            String shortLine;
            boolean addNewline;
            int lim;
            int ptr;
            int max_line_margin = 30;
            int start_line = ProductionState.line(start2);
            int start_column = ProductionState.column(start2);
            int end_line = ProductionState.line(end2);
            int end_column = ProductionState.column(end2);
            if (start_line != this.ruby_sourceline && end_line != this.ruby_sourceline || start_line == end_line && start_column == end_column) {
                return message2;
            }
            int pend = this.lex_pend;
            if (pend > this.lex_pbeg && this.lexb.get(this.lex_pend - 1) == 10 && --pend > this.lex_pbeg && this.lexb.get(this.lex_pend - 1) == 13) {
                --pend;
            }
            int pt = this.ruby_sourceline == end_line ? this.lex_pbeg + end_column : this.lex_pend;
            int ptr_end = ptr = pt < pend ? pt : pend;
            int n = lim = ptr - this.lex_pbeg > max_line_margin ? ptr - max_line_margin : this.lex_pbeg;
            while (lim < ptr && this.lexb.get(ptr - 1) != 10) {
                --ptr;
            }
            int n2 = lim = pend - ptr_end > max_line_margin ? ptr_end + max_line_margin : pend;
            while (ptr_end < lim && this.lexb.get(ptr_end) != 10) {
                ++ptr_end;
            }
            String pre = "";
            String post = "";
            int len = ptr_end - ptr;
            if (len > 4) {
                if (ptr > this.lex_pbeg && ptr > this.lex_pbeg) {
                    pre = "...";
                }
                if (ptr_end < pend && ptr_end < pend) {
                    post = "...";
                }
            }
            int pb = this.lex_pbeg;
            if (this.ruby_sourceline == start_line) {
                pb += start_column;
            }
            if (pb < ptr) {
                pb = ptr;
            }
            if (len <= 4 && start_line == end_line) {
                return message2;
            }
            lim = pt < pend ? pt : pend;
            boolean bl = addNewline = message2 != null && !((String)message2).endsWith("\n");
            if (ptr - 1 < 0) {
                ptr = 0;
            }
            if (ptr_end - 1 < 0) {
                ptr_end = 0;
            }
            if (ptr_end > (shortLine = this.createAsEncodedString(line.unsafeBytes(), line.begin(), line.length())).length()) {
                ptr_end = shortLine.length() - 1;
            }
            shortLine = shortLine.substring(ptr, ptr_end);
            message2 = (String)message2 + (addNewline ? "\n" : "") + pre + shortLine + post;
            addNewline = !((String)message2).endsWith("\n");
            int highlightSize = pb + (pre.length() == 3 ? -4 : 0);
            Object highlightLine = "";
            if (highlightSize >= 0) {
                highlightLine = new String(new char[highlightSize]);
                highlightLine = ((String)highlightLine).replace("\u0000", " ") + "^";
                if (end_column - start_column > 1) {
                    String underscore = new String(new char[end_column - start_column - 1]);
                    underscore = underscore.replace("\u0000", "~");
                    highlightLine = (String)highlightLine + underscore;
                }
            }
            message2 = (String)message2 + (addNewline ? "\n" : "") + (String)highlightLine;
        }
        return message2;
    }

    public void heredoc_restore(HeredocTerm here) {
        ByteList line;
        this.lex_lastline = line = here.lastLine;
        this.lex_pbeg = 0;
        this.lex_pend = this.lex_pbeg + line.length();
        this.lex_p = this.lex_pbeg + here.nth;
        this.lexb = line;
        this.heredoc_end = this.ruby_sourceline;
        this.ruby_sourceline = here.line;
        this.flush();
    }

    public int nextToken() throws IOException {
        this.token = this.yylex();
        this.updateTokenPosition();
        return this.token == -1 ? 0 : this.token;
    }

    @Override
    protected void setCompileOptionFlag(String name2, ByteList value2) {
        if (this.tokenSeen) {
            this.warnings.warn(IRubyWarnings.ID.ACCESSOR_MODULE_FUNCTION, "'" + name2 + "' is ignored after any tokens");
            return;
        }
        int b2 = this.asTruth(name2, value2);
        if (b2 < 0) {
            return;
        }
        this.parser.setStringStyle(b2 == 1);
    }

    @Override
    protected RegexpOptions parseRegexpFlags() throws IOException {
        StringBuilder unknownFlags = new StringBuilder(10);
        RegexpOptions options2 = this.parseRegexpFlags(unknownFlags);
        if (unknownFlags.length() != 0) {
            this.compile_error("unknown regexp option" + (unknownFlags.length() > 1 ? "s" : "") + " - " + String.valueOf(unknownFlags));
        }
        return options2;
    }

    @Override
    protected void mismatchedRegexpEncodingError(Encoding optionEncoding, Encoding encoding2) {
        this.compile_error("regexp encoding option '" + this.optionsEncodingChar(optionEncoding) + "' differs from source encoding '" + String.valueOf(encoding2) + "'");
    }

    protected int asTruth(String name2, ByteList value2) {
        int result2 = value2.caseInsensitiveCmp(this.TRUE);
        if (result2 == 0) {
            return 1;
        }
        result2 = value2.caseInsensitiveCmp(this.FALSE);
        if (result2 == 0) {
            return 0;
        }
        this.warnings.warn(IRubyWarnings.ID.ACCESSOR_MODULE_FUNCTION, "invalid value for " + name2 + ": " + String.valueOf(value2));
        return -1;
    }

    @Override
    protected void setTokenInfo(String name2, ByteList value2) {
    }

    @Override
    protected void setEncoding(ByteList name2) {
        Ruby runtime2 = this.getRuntime();
        Encoding newEncoding = runtime2.getEncodingService().loadEncoding(name2);
        if (newEncoding == null) {
            throw Error.argumentError(runtime2.getCurrentContext(), "unknown encoding name: " + name2.toString());
        }
        if (!newEncoding.isAsciiCompatible()) {
            throw Error.argumentError(runtime2.getCurrentContext(), String.valueOf(name2) + " is not ASCII compatible");
        }
        this.setEncoding(newEncoding);
    }

    public StrTerm getStrTerm() {
        return this.lex_strterm;
    }

    public void setStrTerm(StrTerm strterm) {
        this.lex_strterm = strterm;
    }

    public void setWarnings(IRubyWarnings warnings) {
        this.warnings = warnings;
    }

    private int considerComplex(int token2, int suffix) {
        int type2;
        if ((suffix & 2) == 0) {
            type2 = token2;
        } else {
            this.yaccValue = this.newComplexNode((NumericNode)this.yaccValue);
            type2 = 316;
        }
        this.setState(2);
        return type2;
    }

    private int getFloatToken(String number, int suffix) {
        double d;
        if ((suffix & 1) != 0) {
            BigDecimal bd = new BigDecimal(number);
            BigDecimal denominator2 = BigDecimal.ONE.scaleByPowerOfTen(bd.scale());
            BigDecimal numerator2 = bd.multiply(denominator2);
            try {
                this.yaccValue = new RationalNode(this.ruby_sourceline, new FixnumNode(this.ruby_sourceline, numerator2.longValueExact()), new FixnumNode(this.ruby_sourceline, denominator2.longValueExact()));
            }
            catch (ArithmeticException ae) {
                this.yaccValue = new RationalNode(this.ruby_sourceline, new BignumNode(this.ruby_sourceline, numerator2.toBigIntegerExact()), new BignumNode(this.ruby_sourceline, denominator2.toBigIntegerExact()));
            }
            return this.considerComplex(315, suffix);
        }
        try {
            d = Double.valueOf(number);
        }
        catch (NumberFormatException e) {
            this.warning(IRubyWarnings.ID.FLOAT_OUT_OF_RANGE, "Float " + number + " out of range.");
            d = number.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        this.yaccValue = new FloatNode(this.ruby_sourceline, d);
        return this.considerComplex(314, suffix);
    }

    private int getIntegerToken(String value2, int radix, int suffix) {
        NumericNode literalValue;
        if ((suffix & 1) != 0) {
            literalValue = this.newRationalNode(value2, radix);
        } else {
            try {
                literalValue = this.newFixnumNode(value2, radix);
            }
            catch (NumberFormatException e) {
                literalValue = this.newBignumNode(value2, radix);
            }
        }
        this.yaccValue = literalValue;
        return this.considerComplex(313, suffix);
    }

    public StrNode createStr(ByteList buffer, int flags2) {
        Encoding bufferEncoding = buffer.getEncoding();
        int codeRange = StringSupport.codeRangeScan(bufferEncoding, buffer);
        if ((flags2 & 4) == 0 && bufferEncoding.isAsciiCompatible() && codeRange != 16 && this.getEncoding() == USASCII_ENCODING && bufferEncoding != UTF8_ENCODING) {
            codeRange = RubyParserBase.associateEncoding(buffer, ASCII8BIT_ENCODING, codeRange);
        }
        return new StrNode(this.ruby_sourceline, buffer, codeRange, this.parser.getStringStyle());
    }

    private int parseQuote(int c) {
        int end2;
        boolean shortHand;
        int begin2;
        if (c == -1) {
            this.compile_error("unterminated quoted string meets end of file");
            return -1;
        }
        if (!Character.isLetterOrDigit(c)) {
            begin2 = c;
            c = 81;
            shortHand = true;
        } else {
            shortHand = false;
            begin2 = this.nextc();
            if (Character.isLetterOrDigit(begin2)) {
                this.compile_error("unknown type of %string");
            }
        }
        if (begin2 == -1) {
            this.compile_error("unterminated quoted string meets end of file");
            return -1;
        }
        switch (begin2) {
            case 40: {
                end2 = 41;
                break;
            }
            case 91: {
                end2 = 93;
                break;
            }
            case 123: {
                end2 = 125;
                break;
            }
            case 60: {
                end2 = 62;
                break;
            }
            default: {
                end2 = begin2;
                begin2 = 0;
            }
        }
        switch (c) {
            case 81: {
                this.lex_strterm = new StringTerm(2, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + (shortHand ? "" + end2 : "" + c + begin2);
                return 362;
            }
            case 113: {
                this.lex_strterm = new StringTerm(0, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 362;
            }
            case 87: {
                this.lex_strterm = new StringTerm(16394, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 365;
            }
            case 119: {
                this.lex_strterm = new StringTerm(16392, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 366;
            }
            case 120: {
                this.lex_strterm = new StringTerm(2, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 363;
            }
            case 114: {
                this.lex_strterm = new StringTerm(7, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 364;
            }
            case 115: {
                this.lex_strterm = new StringTerm(16, begin2, end2, this.ruby_sourceline);
                this.setState(4224);
                this.yaccValue = "%" + c + begin2;
                return 361;
            }
            case 73: {
                this.lex_strterm = new StringTerm(16394, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 368;
            }
            case 105: {
                this.lex_strterm = new StringTerm(16392, begin2, end2, this.ruby_sourceline);
                this.yaccValue = "%" + c + begin2;
                return 369;
            }
        }
        this.compile_error("unknown type of %string");
        return -1;
    }

    private int hereDocumentIdentifier() {
        int c = this.nextc();
        int indent = 0;
        int func = 0;
        if (c == 45) {
            c = this.nextc();
            func = 32;
        } else if (c == 126) {
            c = this.nextc();
            func = 32;
            indent = Integer.MAX_VALUE;
        }
        int token2 = 362;
        ByteList markerValue = new ByteList();
        markerValue.setEncoding(this.getEncoding());
        if (c == 39 || c == 34 || c == 96) {
            if (c == 39) {
                this.yaccValue = Q;
                func |= 0;
            } else if (c == 34) {
                this.yaccValue = QQ;
                func |= 2;
            } else {
                this.yaccValue = BACKTICK;
                token2 = 363;
                func |= 2;
            }
            int newline = 0;
            int term = c;
            while ((c = this.nextc()) != -1 && c != term) {
                if (!this.tokadd_mbchar(c, markerValue)) {
                    return -1;
                }
                if (newline == 0 && c == 10) {
                    newline = 1;
                    continue;
                }
                if (newline <= 0) continue;
                newline = 2;
            }
            if (c == -1) {
                this.compile_error("unterminated here document identifier");
            }
            switch (newline) {
                case 1: {
                    this.parser.warn("here document identifier ends with a newline");
                    markerValue.setRealSize(markerValue.realSize() - 1);
                    if (markerValue.get(markerValue.realSize() - 1) != 13) break;
                    markerValue.setRealSize(markerValue.realSize() - 1);
                    break;
                }
                case 2: {
                    this.compile_error("here document identifier across newlines, never match");
                }
            }
            this.pushback(term);
            this.nextc();
        } else {
            if (!RubyLexer.isIdentifierChar(c)) {
                this.pushback(c);
                if ((func & 0x20) != 0) {
                    this.pushback(this.heredoc_indent > 0 ? 126 : 45);
                }
                return 0;
            }
            this.newtok(true);
            func |= 2;
            do {
                if (this.tokadd_mbchar(c, markerValue)) continue;
                return -1;
            } while ((c = this.nextc()) != -1 && RubyLexer.isIdentifierChar(c));
            this.pushback(c);
        }
        int len = this.lex_p - this.lex_pbeg;
        this.lex_goto_eol();
        this.lex_strterm = new HeredocTerm(markerValue, func, len, this.ruby_sourceline, this.lex_lastline);
        this.heredoc_indent = indent;
        this.heredoc_line_indent = 0;
        this.flush();
        return token2;
    }

    private boolean arg_ambiguous(int c) {
        if (this.warnings.isVerbose() && Options.PARSER_WARN_AMBIGUOUS_ARGUMENTS.load().booleanValue()) {
            if (c == 47) {
                this.warning(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, "ambiguity between regexp and two divisions: wrap regexp in parentheses or add a space after '/' operator");
            } else {
                this.warning(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, "ambiguous first argument; put parentheses or a space even after '" + (char)c + "' operator");
            }
        }
        return true;
    }

    private void printToken(int token2) {
        switch (token2) {
            case 256: {
                System.err.print("yyErrorCode,");
                break;
            }
            case 306: {
                System.err.print("tIDENTIFIER[" + String.valueOf(this.value()) + "],");
                break;
            }
            case 307: {
                System.err.print("tFID[" + String.valueOf(this.value()) + "],");
                break;
            }
            case 308: {
                System.err.print("tGVAR[" + String.valueOf(this.value()) + "],");
                break;
            }
            case 309: {
                System.err.print("tIVAR[" + String.valueOf(this.value()) + "],");
                break;
            }
            case 310: {
                System.err.print("tCONSTANT[" + String.valueOf(this.value()) + "],");
                break;
            }
            case 311: {
                System.err.print("tCVAR,");
                break;
            }
            case 313: {
                System.err.print("tINTEGER,");
                break;
            }
            case 314: {
                System.err.print("tFLOAT,");
                break;
            }
            case 320: {
                System.err.print("tSTRING_CONTENT[" + String.valueOf(((StrNode)this.value()).getValue()) + "],");
                break;
            }
            case 362: {
                System.err.print("tSTRING_BEG,");
                break;
            }
            case 367: {
                System.err.print("tSTRING_END,");
                break;
            }
            case 370: {
                System.err.print("tSTRING_DEND,");
                break;
            }
            case 371: {
                System.err.print("tSTRING_DBEG,");
                break;
            }
            case 372: {
                System.err.print("tSTRING_DVAR,");
                break;
            }
            case 363: {
                System.err.print("tXSTRING_BEG,");
                break;
            }
            case 364: {
                System.err.print("tREGEXP_BEG,");
                break;
            }
            case 321: {
                System.err.print("tREGEXP_END,");
                break;
            }
            case 365: {
                System.err.print("tWORDS_BEG,");
                break;
            }
            case 366: {
                System.err.print("tQWORDS_BEG,");
                break;
            }
            case 319: {
                System.err.print("tBACK_REF,");
                break;
            }
            case 318: {
                System.err.print("tNTH_REF,");
                break;
            }
            case 326: {
                System.err.print("tUPLUS");
                break;
            }
            case 327: {
                System.err.print("tUMINUS,");
                break;
            }
            case 328: {
                System.err.print("tPOW,");
                break;
            }
            case 329: {
                System.err.print("tCMP,");
                break;
            }
            case 330: {
                System.err.print("tEQ,");
                break;
            }
            case 331: {
                System.err.print("tEQQ,");
                break;
            }
            case 332: {
                System.err.print("tNEQ,");
                break;
            }
            case 333: {
                System.err.print("tGEQ,");
                break;
            }
            case 334: {
                System.err.print("tLEQ,");
                break;
            }
            case 335: {
                System.err.print("tANDOP,");
                break;
            }
            case 336: {
                System.err.print("tOROP,");
                break;
            }
            case 337: {
                System.err.print("tMATCH,");
                break;
            }
            case 338: {
                System.err.print("tNMATCH,");
                break;
            }
            case 339: {
                System.err.print("tDOT2,");
                break;
            }
            case 340: {
                System.err.print("tDOT3,");
                break;
            }
            case 343: {
                System.err.print("tAREF,");
                break;
            }
            case 344: {
                System.err.print("tASET,");
                break;
            }
            case 345: {
                System.err.print("tLSHFT,");
                break;
            }
            case 346: {
                System.err.print("tRSHFT,");
                break;
            }
            case 348: {
                System.err.print("tCOLON2,");
                break;
            }
            case 349: {
                System.err.print("tCOLON3,");
                break;
            }
            case 350: {
                System.err.print("tOP_ASGN,");
                break;
            }
            case 351: {
                System.err.print("tASSOC,");
                break;
            }
            case 352: {
                System.err.print("tLPAREN,");
                break;
            }
            case 353: {
                System.err.print("tLPAREN_ARG,");
                break;
            }
            case 354: {
                System.err.print("tLBRACK,");
                break;
            }
            case 355: {
                System.err.print("tLBRACE,");
                break;
            }
            case 356: {
                System.err.print("tLBRACE_ARG,");
                break;
            }
            case 357: {
                System.err.print("tSTAR,");
                break;
            }
            case 359: {
                System.err.print("tAMPER,");
                break;
            }
            case 361: {
                System.err.print("tSYMBEG,");
                break;
            }
            case 360: {
                System.err.print("tLAMBDA,");
                break;
            }
            case 373: {
                System.err.print("tLAMBEG,");
                break;
            }
            case 312: {
                System.err.print("tLABEL(" + String.valueOf(this.value()) + ":),");
                break;
            }
            case 374: {
                System.err.print("tLABEL_END");
                break;
            }
            case 259: {
                System.err.print("keyword_def,");
                break;
            }
            case 270: {
                System.err.print("keyword_case,");
                break;
            }
            case 279: {
                System.err.print("keyword_in,");
                break;
            }
            case 280: {
                System.err.print("keyword_do,");
                break;
            }
            case 282: {
                System.err.print("keyword_do_block,");
                break;
            }
            case 281: {
                System.err.print("keyword_do_cond,");
                break;
            }
            case 264: {
                System.err.print("keyword_end,");
                break;
            }
            case 285: {
                System.err.print("keyword_yield,");
                break;
            }
            case 10: {
                System.err.println("NL");
                break;
            }
            case -1: {
                System.out.println("EOF");
                break;
            }
            case 358: {
                System.err.print("tDSTAR");
                break;
            }
            default: {
                System.err.print("'" + (char)token2 + "',");
            }
        }
    }

    private int yylex2() throws IOException {
        int currentToken = this.yylex2();
        this.printToken(currentToken);
        return currentToken;
    }

    private int yylex() throws IOException {
        int c;
        boolean spaceSeen = false;
        boolean tokenSeen = this.tokenSeen;
        if (this.lex_strterm != null) {
            return this.lex_strterm.parseString(this);
        }
        boolean commandState = this.commandStart;
        this.commandStart = false;
        this.tokenSeen = true;
        block43: while (true) {
            this.last_state = this.lex_state;
            this.flush();
            c = this.nextc();
            switch (c) {
                case -1: 
                case 0: 
                case 4: 
                case 26: {
                    return -1;
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    spaceSeen = true;
                    continue block43;
                }
                case 35: {
                    this.tokenSeen = tokenSeen;
                    if ((!tokenSeen || this.warnings.isVerbose()) && !this.parser_magic_comment(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p)) && this.comment_at_top()) {
                        this.set_file_encoding(this.lex_p, this.lex_pend);
                    }
                    this.lex_p = this.lex_pend;
                }
                case 10: {
                    boolean normalArg;
                    this.tokenSeen = tokenSeen;
                    boolean bl = normalArg = RubyLexer.IS_lex_state(this.lex_state, 897) && !RubyLexer.IS_lex_state(this.lex_state, 2048);
                    if (normalArg || this.IS_lex_state_all(this.lex_state, 2064)) {
                        if (normalArg || !this.getLexContext().in_kwarg) continue block43;
                        this.commandStart = true;
                        this.setState(1);
                        return 10;
                    }
                    boolean done = false;
                    block44: while (!done) {
                        c = this.nextc();
                        switch (c) {
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                spaceSeen = true;
                                continue block44;
                            }
                            case 35: {
                                this.pushback(c);
                                continue block43;
                            }
                            case 38: 
                            case 46: {
                                if (this.peek(46) != (c == 38)) break;
                                this.pushback(c);
                                continue block43;
                            }
                        }
                        done = true;
                    }
                    if (c == -1) {
                        return -1;
                    }
                    this.pushback(c);
                    this.commandStart = true;
                    this.setState(1);
                    return 10;
                }
                case 42: {
                    return this.star(spaceSeen);
                }
                case 33: {
                    return this.bang();
                }
                case 61: {
                    if (this.was_bol() && this.strncmp(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p), BEGIN_DOC_MARKER, BEGIN_DOC_MARKER.length()) && Character.isWhitespace(this.p(this.lex_p + 5))) {
                        do {
                            this.lex_goto_eol();
                            c = this.nextc();
                            if (c != -1) continue;
                            this.compile_error("embedded document meets end of file");
                            return -1;
                        } while (c != 61 || !this.strncmp(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p), END_DOC_MARKER, END_DOC_MARKER.length()) || this.lex_p + 3 != this.lex_pend && !Character.isWhitespace(this.p(this.lex_p + 3)));
                        this.lex_goto_eol();
                        continue block43;
                    }
                    this.setState(this.IS_AFTER_OPERATOR() ? 16 : 1);
                    c = this.nextc();
                    if (c == 61) {
                        c = this.nextc();
                        if (c == 61) {
                            this.yaccValue = EQ_EQ_EQ;
                            return 331;
                        }
                        this.pushback(c);
                        this.yaccValue = EQ_EQ;
                        return 330;
                    }
                    if (c == 126) {
                        this.yaccValue = EQ_TILDE;
                        return 337;
                    }
                    if (c == 62) {
                        this.yaccValue = EQ_GT;
                        return 351;
                    }
                    this.pushback(c);
                    this.yaccValue = EQ;
                    return 61;
                }
                case 60: {
                    return this.lessThan(spaceSeen);
                }
                case 62: {
                    return this.greaterThan();
                }
                case 34: {
                    return this.doubleQuote(commandState);
                }
                case 96: {
                    return this.backtick(commandState);
                }
                case 39: {
                    return this.singleQuote(commandState);
                }
                case 63: {
                    return this.questionMark();
                }
                case 38: {
                    return this.ampersand(spaceSeen);
                }
                case 124: {
                    return this.pipe();
                }
                case 43: {
                    return this.plus(spaceSeen);
                }
                case 45: {
                    return this.minus(spaceSeen);
                }
                case 46: {
                    return this.dot();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumber(c);
                }
                case 41: {
                    return this.rightParen();
                }
                case 93: {
                    return this.rightBracket();
                }
                case 125: {
                    return this.rightCurly();
                }
                case 58: {
                    return this.colon(spaceSeen);
                }
                case 47: {
                    return this.slash(spaceSeen);
                }
                case 94: {
                    return this.caret();
                }
                case 59: {
                    this.commandStart = true;
                    this.setState(1);
                    this.yaccValue = SEMICOLON;
                    return 59;
                }
                case 44: {
                    return this.comma(c);
                }
                case 126: {
                    return this.tilde();
                }
                case 40: {
                    return this.leftParen(spaceSeen);
                }
                case 91: {
                    return this.leftBracket(spaceSeen);
                }
                case 123: {
                    return this.leftCurly();
                }
                case 92: {
                    c = this.nextc();
                    if (c == 10) {
                        spaceSeen = true;
                        continue block43;
                    }
                    if (c == 32) {
                        return 325;
                    }
                    if (Character.isWhitespace(c)) {
                        return c;
                    }
                    this.pushback(c);
                    this.yaccValue = BACKSLASH;
                    return 92;
                }
                case 37: {
                    return this.percent(spaceSeen);
                }
                case 36: {
                    return this.dollar();
                }
                case 64: {
                    return this.at();
                }
                case 95: {
                    if (this.was_bol() && this.whole_match_p(END_MARKER, false)) {
                        this.line_offset += this.lex_pend;
                        this.__end__seen = true;
                        this.eofp = true;
                        this.lex_goto_eol();
                        return -1;
                    }
                    return this.identifier(c, commandState);
                }
            }
            break;
        }
        return this.identifier(c, commandState);
    }

    private int identifierToken(int result2, ByteList value2) {
        RubySymbol symbol = this.getRuntime().newSymbol(value2);
        String id = symbol.idString();
        if (result2 == 310 && !symbol.validConstantName()) {
            result2 = 306;
        }
        if (result2 == 306 && !RubyLexer.IS_lex_state(this.last_state, 384) && this.parser.getCurrentScope().isDefined(id) >= 0) {
            this.setState(1026);
        }
        this.set_yylval_name(value2);
        this.yaccValue = value2;
        return result2;
    }

    private int ampersand(boolean spaceSeen) {
        int c = this.nextc();
        switch (c) {
            case 38: {
                this.setState(1);
                c = this.nextc();
                if (c == 61) {
                    this.yaccValue = AMPERSAND_AMPERSAND;
                    this.set_yylval_id(AMPERSAND_AMPERSAND);
                    this.setState(1);
                    return 350;
                }
                this.pushback(c);
                this.yaccValue = AMPERSAND_AMPERSAND;
                return 335;
            }
            case 61: {
                this.yaccValue = AMPERSAND;
                this.set_yylval_id(AMPERSAND);
                this.setState(1);
                return 350;
            }
            case 46: {
                this.setState(256);
                this.yaccValue = AMPERSAND_DOT;
                this.set_yylval_id(AMPERSAND_DOT);
                return 347;
            }
        }
        this.pushback(c);
        int tmpLine = this.ruby_sourceline;
        if (this.IS_SPCARG(c, spaceSeen)) {
            if (this.warnings.isVerbose() && Options.PARSER_WARN_ARGUMENT_PREFIX.load().booleanValue()) {
                this.warning(IRubyWarnings.ID.ARGUMENT_AS_PREFIX, this.getFile(), tmpLine, "'&' interpreted as argument prefix");
            }
            c = 359;
        } else {
            c = this.IS_BEG() ? 359 : this.warn_balanced(c, spaceSeen, 38, "&", "argument prefix");
        }
        this.setState(this.IS_AFTER_OPERATOR() ? 16 : 1);
        this.yaccValue = AMPERSAND;
        return c;
    }

    private int at() {
        int result2;
        this.newtok(true);
        int c = this.nextc();
        if (c == 64) {
            c = this.nextc();
            result2 = 311;
        } else {
            result2 = 309;
        }
        this.setState(RubyLexer.IS_lex_state(this.last_state, 128) ? 8 : 2);
        if (c == -1 || !RubyLexer.isIdentifierChar(c)) {
            if (result2 == 309) {
                this.compile_error("'@' without identifiers is not allowed as an instance variable name");
            } else {
                this.compile_error("'@@' without identifiers is not allowed as a class variable name");
            }
            this.setState(2);
            return result2;
        }
        if (Character.isDigit(c)) {
            this.pushback(c);
            if (result2 == 309) {
                this.compile_error("'@" + (char)c + "' is not allowed as an instance variable name");
            } else {
                this.compile_error("'@@" + (char)c + "' is not allowed as a class variable name");
            }
            this.setState(2);
            return result2;
        }
        if (!this.tokadd_ident(c)) {
            return -1;
        }
        return this.tokenize_ident(result2);
    }

    private int backtick(boolean commandState) {
        this.yaccValue = BACKTICK;
        if (RubyLexer.IS_lex_state(this.lex_state, 128)) {
            this.setState(8);
            return 96;
        }
        if (RubyLexer.IS_lex_state(this.lex_state, 256)) {
            this.setState(commandState ? 32 : 16);
            return 96;
        }
        this.lex_strterm = new StringTerm(2, 0, 96, this.ruby_sourceline);
        return 363;
    }

    private int bang() {
        int c = this.nextc();
        if (this.IS_AFTER_OPERATOR()) {
            this.setState(16);
            if (c == 64) {
                this.yaccValue = BANG;
                return 33;
            }
        } else {
            this.setState(1);
        }
        switch (c) {
            case 61: {
                this.yaccValue = BANG_EQ;
                return 332;
            }
            case 126: {
                this.yaccValue = BANG_TILDE;
                return 338;
            }
        }
        this.pushback(c);
        this.yaccValue = BANG;
        return 33;
    }

    private int caret() {
        this.yaccValue = CARET;
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            this.set_yylval_id(CARET);
            return 350;
        }
        this.setState(this.IS_AFTER_OPERATOR() ? 16 : 1);
        this.pushback(c);
        return 94;
    }

    private int colon(boolean spaceSeen) {
        int c = this.nextc();
        if (c == 58) {
            if (this.IS_BEG() || RubyLexer.IS_lex_state(this.lex_state, 512) || this.IS_SPCARG(-1, spaceSeen)) {
                this.setState(1);
                this.yaccValue = COLON_COLON;
                return 349;
            }
            this.setState(256);
            this.yaccValue = COLON_COLON;
            this.set_yylval_id(COLON_COLON);
            return 348;
        }
        if (this.IS_END() || RubyLexer.ISSPACE(c) || c == 35) {
            this.pushback(c);
            this.setState(1);
            this.yaccValue = COLON;
            return this.warn_balanced(c, spaceSeen, 58, ":", "symbol literal");
        }
        switch (c) {
            case 39: {
                this.lex_strterm = new StringTerm(16, 0, c, this.ruby_sourceline);
                break;
            }
            case 34: {
                this.lex_strterm = new StringTerm(18, 0, c, this.ruby_sourceline);
                break;
            }
            default: {
                this.pushback(c);
            }
        }
        this.setState(128);
        this.yaccValue = COLON;
        return 361;
    }

    private int comma(int c) {
        this.setState(1025);
        this.yaccValue = COMMA;
        return c;
    }

    private int doKeyword(int state2) {
        if (this.isLambdaBeginning()) {
            this.setLeftParenBegin(-1);
            return 283;
        }
        if (this.conditionState.set_p()) {
            return 281;
        }
        if (this.cmdArgumentState.set_p() && !RubyLexer.IS_lex_state(state2, 32)) {
            return 282;
        }
        return 280;
    }

    private int dollar() {
        this.setState(2);
        this.newtok(true);
        int c = this.nextc();
        switch (c) {
            case 95: {
                c = this.nextc();
                if (RubyLexer.isIdentifierChar(c)) {
                    if (!this.tokadd_ident(c)) {
                        return -1;
                    }
                    this.last_state = this.lex_state;
                    return this.identifierToken(308, this.createTokenByteList());
                }
                this.pushback(c);
                c = 95;
            }
            case 33: 
            case 34: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 126: {
                this.yaccValue = new ByteList(new byte[]{36, (byte)c}, USASCII_ENCODING);
                this.set_yylval_name(new ByteList(new byte[]{36, (byte)c}));
                return 308;
            }
            case 45: {
                c = this.nextc();
                if (RubyLexer.isIdentifierChar(c)) {
                    if (!this.tokadd_mbchar(c)) {
                        return -1;
                    }
                } else {
                    this.pushback(c);
                    this.pushback(45);
                    return 36;
                }
                this.yaccValue = this.createTokenByteList();
                return 308;
            }
            case 38: 
            case 39: 
            case 43: 
            case 96: {
                if (RubyLexer.IS_lex_state(this.last_state, 128)) {
                    this.yaccValue = new ByteList(new byte[]{36, (byte)c}, USASCII_ENCODING);
                    this.set_yylval_name(new ByteList(new byte[]{36, (byte)c}));
                    return 308;
                }
                this.yaccValue = new BackRefNode(this.ruby_sourceline, c);
                return 319;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int ref;
                while (Character.isDigit(c = this.nextc())) {
                }
                this.pushback(c);
                if (RubyLexer.IS_lex_state(this.last_state, 128)) {
                    this.yaccValue = this.createTokenByteList();
                    this.set_yylval_name(new ByteList(new byte[]{36, (byte)c}));
                    return 308;
                }
                String refAsString = this.createTokenString();
                try {
                    ref = Integer.parseInt(refAsString.substring(1));
                }
                catch (NumberFormatException e) {
                    this.warn(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, "'" + refAsString + "' is too big for a number variable, always nil");
                    ref = 0;
                }
                this.yaccValue = new NthRefNode(this.ruby_sourceline, ref);
                return 318;
            }
            case 48: {
                return this.identifierToken(308, new ByteList(new byte[]{36, (byte)c}));
            }
        }
        if (!RubyLexer.isIdentifierChar(c)) {
            if (c == -1 || RubyLexer.isSpace(c)) {
                this.compile_error("'$' without identifiers is not allowed as a global variable name");
            } else {
                this.pushback(c);
                this.compile_error("'$" + (char)c + "' is not allowed as a global variable name");
            }
        }
        this.last_state = this.lex_state;
        this.setState(2);
        this.tokadd_ident(c);
        return this.identifierToken(308, this.createTokenByteList());
    }

    private int dot() {
        boolean isBeg = this.IS_BEG();
        this.setState(1);
        int c = this.nextc();
        if (c == 46) {
            c = this.nextc();
            if (c == 46) {
                this.yaccValue = DOT_DOT_DOT;
                if (this.getLexContext().in_argdef) {
                    this.setState(4);
                    return 342;
                }
                if (this.parenNest == 0 && this.isLookingAtEOL()) {
                    this.warn(IRubyWarnings.ID.MISCELLANEOUS, "... at EOL, should be parenthesized?");
                } else if (this.getLeftParenBegin() >= 0 && this.getLeftParenBegin() + 1 == this.parenNest && RubyLexer.IS_lex_state(this.last_state, 1024)) {
                    return 340;
                }
                return isBeg ? 342 : 340;
            }
            this.pushback(c);
            this.yaccValue = DOT_DOT;
            this.set_yylval_id(DOT);
            return isBeg ? 341 : 339;
        }
        this.pushback(c);
        if (Character.isDigit(c)) {
            this.compile_error("no .<digit> floating literal anymore; put 0 before dot");
        }
        this.setState(256);
        this.yaccValue = DOT;
        return 46;
    }

    private int doubleQuote(boolean commandState) {
        int label2 = this.IS_LABEL_POSSIBLE(commandState) ? 64 : 0;
        this.lex_strterm = new StringTerm(2 | label2, 0, 34, this.ruby_sourceline);
        this.yaccValue = QQ;
        return 362;
    }

    private int greaterThan() {
        this.setState(this.IS_AFTER_OPERATOR() ? 16 : 1);
        int c = this.nextc();
        switch (c) {
            case 61: {
                this.yaccValue = GT_EQ;
                return 333;
            }
            case 62: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = GT_GT;
                    this.set_yylval_id(GT_GT);
                    return 350;
                }
                this.pushback(c);
                this.yaccValue = GT_GT;
                return 346;
            }
        }
        this.pushback(c);
        this.yaccValue = GT;
        return 62;
    }

    private int identifier(int c, boolean commandState) {
        Keyword keyword;
        ByteList tempVal;
        int result2;
        if (!RubyLexer.isIdentifierChar(c)) {
            StringBuilder builder = new StringBuilder();
            Formatter formatter = new Formatter(builder, Locale.US);
            formatter.format("Invalid char '\\x%02x' in expression", c & 0xFF);
            this.compile_error(builder.toString());
        }
        this.newtok(true);
        do {
            if (this.tokadd_mbchar(c)) continue;
            return -1;
        } while (RubyLexer.isIdentifierChar(c = this.nextc()));
        this.last_state = this.lex_state;
        if (!(c != 33 && c != 63 || this.peek(61))) {
            result2 = 307;
            tempVal = this.createTokenByteList();
        } else if (c == 61 && RubyLexer.IS_lex_state(this.lex_state, 128)) {
            int c2 = this.nextc();
            if (c2 != 126 && c2 != 62 && (c2 != 61 || this.peek(62))) {
                result2 = 306;
                this.pushback(c2);
            } else {
                result2 = 310;
                this.pushback(c2);
                this.pushback(c);
            }
            tempVal = this.createTokenByteList();
        } else {
            result2 = 310;
            this.pushback(c);
            tempVal = this.createTokenByteList();
        }
        if (this.IS_LABEL_POSSIBLE(commandState) && this.IS_LABEL_SUFFIX()) {
            this.setState(2064);
            this.nextc();
            this.yaccValue = tempVal;
            this.set_yylval_name(this.createTokenByteList());
            return 312;
        }
        if (this.lex_state != 256 && (keyword = RubyLexer.getKeyword(tempVal)) != null) {
            int state2 = this.lex_state;
            this.setState(keyword.state);
            this.yaccValue = keyword.bytes;
            if (RubyLexer.IS_lex_state(state2, 128)) {
                this.setState(8);
                this.set_yylval_name(this.createTokenByteList());
                return keyword.id0;
            }
            if (RubyLexer.IS_lex_state(this.lex_state, 1)) {
                this.commandStart = true;
            }
            if (keyword.id0 == 280) {
                return this.doKeyword(state2);
            }
            if (RubyLexer.IS_lex_state(state2, 2049)) {
                return keyword.id0;
            }
            if (keyword.id0 != keyword.id1) {
                this.setState(1025);
            }
            return keyword.id1;
        }
        if (RubyLexer.IS_lex_state(this.lex_state, 881)) {
            this.setState(commandState ? 32 : 16);
        } else if (this.lex_state == 128) {
            this.setState(8);
        } else {
            this.setState(2);
        }
        return this.identifierToken(result2, tempVal);
    }

    private int leftBracket(boolean spaceSeen) {
        ++this.parenNest;
        int c = 91;
        if (this.IS_AFTER_OPERATOR()) {
            c = this.nextc();
            if (c == 93) {
                --this.parenNest;
                this.setState(16);
                if (this.peek(61)) {
                    this.nextc();
                    this.yaccValue = LBRACKET_RBRACKET_EQ;
                    return 344;
                }
                this.yaccValue = LBRACKET_RBRACKET;
                return 343;
            }
            this.pushback(c);
            this.setState(1040);
            this.yaccValue = LBRACKET;
            return 91;
        }
        if (this.IS_BEG() || this.IS_ARG() && (spaceSeen || RubyLexer.IS_lex_state(this.lex_state, 2048))) {
            c = 354;
        }
        this.setState(1025);
        this.conditionState.push0();
        this.cmdArgumentState.push0();
        this.yaccValue = LBRACKET;
        return c;
    }

    private int leftCurly() {
        ++this.braceNest;
        int c = this.isLambdaBeginning() ? 373 : (RubyLexer.IS_lex_state(this.lex_state, 2048) ? 355 : (RubyLexer.IS_lex_state(this.lex_state, 58) ? 123 : (RubyLexer.IS_lex_state(this.lex_state, 4) ? 356 : 355)));
        if (c != 355) {
            this.commandStart = true;
            this.setState(1);
        } else {
            this.setState(1025);
        }
        ++this.parenNest;
        this.conditionState.push0();
        this.cmdArgumentState.push0();
        this.yaccValue = this.ruby_sourceline;
        return c;
    }

    private int leftParen(boolean spaceSeen) {
        int result2;
        if (this.IS_BEG()) {
            result2 = 352;
        } else if (!spaceSeen) {
            result2 = 40;
        } else if (this.IS_ARG() || this.IS_lex_state_all(this.lex_state, 1026)) {
            result2 = 353;
        } else if (RubyLexer.IS_lex_state(this.lex_state, 8) && !this.isLambdaBeginning()) {
            this.warnings.warn(IRubyWarnings.ID.MISCELLANEOUS, "parentheses after method name is interpreted as an argument list, not a decomposed argument");
            result2 = 40;
        } else {
            result2 = 40;
        }
        ++this.parenNest;
        this.conditionState.push0();
        this.cmdArgumentState.push0();
        this.setState(1025);
        this.yaccValue = this.ruby_sourceline;
        return result2;
    }

    private int lessThan(boolean spaceSeen) {
        int tok;
        this.last_state = this.lex_state;
        int c = this.nextc();
        if (!(c != 60 || RubyLexer.IS_lex_state(this.lex_state, 768) || this.IS_END() || this.IS_ARG() && !RubyLexer.IS_lex_state(this.lex_state, 2048) && !spaceSeen || (tok = this.hereDocumentIdentifier()) == 0)) {
            return tok;
        }
        if (this.IS_AFTER_OPERATOR()) {
            this.setState(16);
        } else {
            if (RubyLexer.IS_lex_state(this.lex_state, 512)) {
                this.commandStart = true;
            }
            this.setState(1);
        }
        switch (c) {
            case 61: {
                c = this.nextc();
                if (c == 62) {
                    this.yaccValue = LT_EQ_RT;
                    return 329;
                }
                this.pushback(c);
                this.yaccValue = LT_EQ;
                return 334;
            }
            case 60: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = LT_LT;
                    return 350;
                }
                this.pushback(c);
                this.yaccValue = LT_LT;
                return this.warn_balanced(c, spaceSeen, 345, "<<", "here document");
            }
        }
        this.yaccValue = LT;
        this.pushback(c);
        return 60;
    }

    private int minus(boolean spaceSeen) {
        int c = this.nextc();
        if (this.IS_AFTER_OPERATOR()) {
            this.setState(16);
            if (c == 64) {
                this.yaccValue = MINUS_AT;
                return 327;
            }
            this.pushback(c);
            this.yaccValue = MINUS;
            return 45;
        }
        if (c == 61) {
            this.setState(1);
            this.yaccValue = MINUS;
            this.set_yylval_id(MINUS);
            return 350;
        }
        if (c == 62) {
            this.setState(8);
            this.yaccValue = MINUS_GT;
            return 360;
        }
        if (this.IS_BEG() || this.IS_SPCARG(c, spaceSeen) && this.arg_ambiguous(45)) {
            this.setState(1);
            this.pushback(c);
            this.yaccValue = MINUS_AT;
            if (Character.isDigit(c)) {
                return 323;
            }
            return 327;
        }
        this.setState(1);
        this.pushback(c);
        this.yaccValue = MINUS;
        return this.warn_balanced(c, spaceSeen, 45, "-", "unary operator");
    }

    private int percent(boolean spaceSeen) {
        if (this.IS_BEG()) {
            return this.parseQuote(this.nextc());
        }
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            this.yaccValue = PERCENT;
            return 350;
        }
        if (this.IS_SPCARG(c, spaceSeen) || RubyLexer.IS_lex_state(this.lex_state, 4096) && c == 115) {
            return this.parseQuote(c);
        }
        this.setState(this.IS_AFTER_OPERATOR() ? 16 : 1);
        this.pushback(c);
        this.yaccValue = PERCENT;
        this.set_yylval_id(PERCENT);
        return this.warn_balanced(c, spaceSeen, 37, "%", "string literal");
    }

    private int pipe() {
        int c = this.nextc();
        switch (c) {
            case 124: {
                this.setState(1);
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = OR_OR;
                    this.set_yylval_id(OR_OR);
                    return 350;
                }
                this.pushback(c);
                if (this.IS_lex_state_all(this.last_state, 1)) {
                    this.yaccValue = OR;
                    this.pushback(124);
                    return 124;
                }
                this.yaccValue = OR_OR;
                return 336;
            }
            case 61: {
                this.setState(1);
                this.yaccValue = OR;
                this.set_yylval_id(OR);
                return 350;
            }
        }
        this.setState(this.IS_AFTER_OPERATOR() ? 16 : 1025);
        this.pushback(c);
        this.yaccValue = OR;
        return 124;
    }

    private int plus(boolean spaceSeen) {
        int c = this.nextc();
        if (this.IS_AFTER_OPERATOR()) {
            this.setState(16);
            if (c == 64) {
                this.yaccValue = PLUS_AT;
                return 326;
            }
            this.pushback(c);
            this.yaccValue = PLUS;
            return 43;
        }
        if (c == 61) {
            this.setState(1);
            this.yaccValue = PLUS;
            this.set_yylval_id(PLUS);
            return 350;
        }
        if (this.IS_BEG() || this.IS_SPCARG(c, spaceSeen) && this.arg_ambiguous(43)) {
            this.setState(1);
            this.pushback(c);
            if (Character.isDigit(c)) {
                c = 43;
                return this.parseNumber(c);
            }
            this.yaccValue = PLUS_AT;
            return 326;
        }
        this.setState(1);
        this.pushback(c);
        this.yaccValue = PLUS;
        return this.warn_balanced(c, spaceSeen, 43, "+", "unary operator");
    }

    private int questionMark() throws IOException {
        if (this.IS_END()) {
            this.setState(1);
            this.yaccValue = QUESTION;
            return 63;
        }
        int c = this.nextc();
        if (c == -1) {
            this.compile_error("incomplete character syntax");
        }
        if (Character.isWhitespace(c)) {
            if (!this.IS_ARG()) {
                int c2 = 0;
                switch (c) {
                    case 32: {
                        c2 = 115;
                        break;
                    }
                    case 10: {
                        c2 = 110;
                        break;
                    }
                    case 9: {
                        c2 = 116;
                        break;
                    }
                    case 13: {
                        c2 = 114;
                        break;
                    }
                    case 12: {
                        c2 = 102;
                    }
                }
                if (c2 != 0) {
                    this.warning(IRubyWarnings.ID.INVALID_CHAR_SEQUENCE, "invalid character syntax; use ?\\" + c2);
                }
            }
            this.pushback(c);
            this.setState(1);
            this.yaccValue = QUESTION;
            return 63;
        }
        if (!RubyLexer.isASCII(c)) {
            if (!this.tokadd_mbchar(c)) {
                return -1;
            }
            this.yaccValue = new StrNode(this.ruby_sourceline, this.createTokenByteList(1));
            this.setState(2);
            return 317;
        }
        if (RubyLexer.isIdentifierChar(c) && !this.peek(10) && this.isNext_identchar()) {
            this.newtok(true);
            this.pushback(c);
            this.setState(1);
            this.yaccValue = QUESTION;
            return 63;
        }
        if (c == 92) {
            if (this.peek(117)) {
                this.nextc();
                ByteList oneCharBL = new ByteList(2);
                oneCharBL.setEncoding(this.getEncoding());
                c = this.readUTFEscape(oneCharBL, false, new boolean[]{false});
                if (c >= 128) {
                    this.tokaddmbc(c, oneCharBL);
                } else {
                    oneCharBL.append(c);
                }
                this.setState(2);
                this.yaccValue = new StrNode(this.ruby_sourceline, oneCharBL);
                return 317;
            }
            c = this.readEscape();
        } else {
            this.newtok(true);
        }
        ByteList oneCharBL = new ByteList(1);
        oneCharBL.setEncoding(this.getEncoding());
        oneCharBL.append(c);
        this.yaccValue = new StrNode(this.ruby_sourceline, oneCharBL);
        this.setState(2);
        return 317;
    }

    private int rightBracket() {
        --this.parenNest;
        this.conditionState.pop();
        this.cmdArgumentState.pop();
        this.setState(2);
        this.yaccValue = RBRACKET;
        return 93;
    }

    private int rightCurly() {
        this.yaccValue = RCURLY;
        --this.braceNest;
        if (this.braceNest < 0) {
            return 370;
        }
        this.conditionState.pop();
        this.cmdArgumentState.pop();
        this.setState(2);
        --this.parenNest;
        return 125;
    }

    private int rightParen() {
        --this.parenNest;
        this.conditionState.pop();
        this.cmdArgumentState.pop();
        this.setState(8);
        this.yaccValue = RPAREN;
        return 41;
    }

    private int singleQuote(boolean commandState) {
        int label2 = this.IS_LABEL_POSSIBLE(commandState) ? 64 : 0;
        this.lex_strterm = new StringTerm(0 | label2, 0, 39, this.ruby_sourceline);
        this.yaccValue = Q;
        return 362;
    }

    private int slash(boolean spaceSeen) {
        this.yaccValue = SLASH;
        if (this.IS_BEG()) {
            this.lex_strterm = new StringTerm(7, 0, 47, this.ruby_sourceline);
            return 364;
        }
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            this.set_yylval_id(SLASH);
            return 350;
        }
        this.pushback(c);
        if (this.IS_SPCARG(c, spaceSeen)) {
            this.arg_ambiguous(47);
            this.lex_strterm = new StringTerm(7, 0, 47, this.ruby_sourceline);
            return 364;
        }
        this.setState(this.IS_AFTER_OPERATOR() ? 16 : 1);
        return this.warn_balanced(c, spaceSeen, 47, "/", "regexp literal");
    }

    private int star(boolean spaceSeen) {
        int c = this.nextc();
        switch (c) {
            case 42: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = STAR_STAR;
                    this.set_yylval_id(STAR_STAR);
                    return 350;
                }
                this.pushback(c);
                this.yaccValue = STAR_STAR;
                if (this.IS_SPCARG(c, spaceSeen)) {
                    if (this.warnings.isVerbose() && Options.PARSER_WARN_ARGUMENT_PREFIX.load().booleanValue()) {
                        this.warning(IRubyWarnings.ID.ARGUMENT_AS_PREFIX, "'**' interpreted as argument prefix");
                    }
                    c = 358;
                    break;
                }
                if (this.IS_BEG()) {
                    c = 358;
                    break;
                }
                c = this.warn_balanced(c, spaceSeen, 328, "**", "argument prefix");
                break;
            }
            case 61: {
                this.setState(1);
                this.yaccValue = STAR;
                this.set_yylval_id(STAR);
                return 350;
            }
            default: {
                this.pushback(c);
                if (this.IS_SPCARG(c, spaceSeen)) {
                    if (this.warnings.isVerbose() && Options.PARSER_WARN_ARGUMENT_PREFIX.load().booleanValue()) {
                        this.warning(IRubyWarnings.ID.ARGUMENT_AS_PREFIX, "'*' interpreted as argument prefix");
                    }
                    c = 357;
                } else {
                    c = this.IS_BEG() ? 357 : this.warn_balanced(c, spaceSeen, 42, "*", "argument prefix");
                }
                this.yaccValue = STAR;
            }
        }
        this.setState(this.IS_AFTER_OPERATOR() ? 16 : 1);
        return c;
    }

    private int tilde() {
        if (this.IS_AFTER_OPERATOR()) {
            int c = this.nextc();
            if (c != 64) {
                this.pushback(c);
            }
            this.setState(16);
        } else {
            this.setState(1);
        }
        this.yaccValue = TILDE;
        return 126;
    }

    private int parseNumber(int c) {
        this.setState(2);
        this.newtok(true);
        this.numberBuffer.setRealSize(0);
        if (c == 45) {
            this.numberBuffer.append((char)c);
            c = this.nextc();
        } else if (c == 43) {
            c = this.nextc();
        }
        int nondigit = 0;
        if (c == 48) {
            int startLen = this.numberBuffer.length();
            c = this.nextc();
            switch (c) {
                case 88: 
                case 120: {
                    c = this.nextc();
                    if (RubyLexer.isHexChar(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!RubyLexer.isHexChar(c)) break;
                                nondigit = 0;
                                this.numberBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.length() == startLen) {
                        this.compile_error("Hexadecimal number without hex-digits.");
                    } else if (nondigit != 0) {
                        this.compile_error("Trailing '_' in number.");
                    }
                    return this.getIntegerToken(this.numberBuffer.toString(), 16, this.numberLiteralSuffix(3));
                }
                case 66: 
                case 98: {
                    c = this.nextc();
                    if (c == 48 || c == 49) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (c != 48 && c != 49) break;
                                nondigit = 0;
                                this.numberBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.length() == startLen) {
                        this.parse_error("numeric literal without digits.");
                    } else if (nondigit != 0) {
                        this.compile_error_pos("Trailing '_' in number.");
                    }
                    return this.getIntegerToken(this.numberBuffer.toString(), 2, this.numberLiteralSuffix(3));
                }
                case 68: 
                case 100: {
                    c = this.nextc();
                    if (Character.isDigit(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!Character.isDigit(c)) break;
                                nondigit = 0;
                                this.numberBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.length() == startLen) {
                        this.compile_error_pos("Binary number without digits.");
                    } else if (nondigit != 0) {
                        this.compile_error_pos("Trailing '_' in number.");
                    }
                    return this.getIntegerToken(this.numberBuffer.toString(), 10, this.numberLiteralSuffix(3));
                }
                case 79: 
                case 111: {
                    c = this.nextc();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 95: {
                    while (true) {
                        if (c == 95) {
                            if (nondigit != 0) break;
                            nondigit = c;
                        } else {
                            if (c < 48 || c > 55) break;
                            nondigit = 0;
                            this.numberBuffer.append((char)c);
                        }
                        c = this.nextc();
                    }
                    if (this.numberBuffer.length() > startLen) {
                        this.pushback(c);
                        if (nondigit != 0) {
                            this.compile_error_pos("Trailing '_' in number.");
                        }
                        return this.getIntegerToken(this.numberBuffer.toString(), 8, this.numberLiteralSuffix(3));
                    }
                }
                case 56: 
                case 57: {
                    this.compile_error_pos("Illegal octal digit.");
                }
                case 46: 
                case 69: 
                case 101: {
                    this.numberBuffer.append(48);
                    break;
                }
                default: {
                    this.pushback(c);
                    this.numberBuffer.append(48);
                    return this.getIntegerToken(this.numberBuffer.toString(), 10, this.numberLiteralSuffix(3));
                }
            }
        }
        boolean seen_point = false;
        boolean seen_e = false;
        while (true) {
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    nondigit = 0;
                    this.numberBuffer.append((char)c);
                    break;
                }
                case 46: {
                    if (nondigit != 0) {
                        this.pushback(c);
                        this.compile_error("Trailing '_' in number.");
                        break;
                    }
                    if (seen_point || seen_e) {
                        this.pushback(c);
                        return this.getNumberToken(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    int c2 = this.nextc();
                    if (!Character.isDigit(c2)) {
                        this.pushback(c2);
                        this.pushback(46);
                        if (c == 95) break;
                        return this.getIntegerToken(this.numberBuffer.toString(), 10, this.numberLiteralSuffix(3));
                    }
                    this.numberBuffer.append(46);
                    this.numberBuffer.append((char)c2);
                    seen_point = true;
                    nondigit = 0;
                    break;
                }
                case 69: 
                case 101: {
                    if (nondigit != 0) {
                        this.pushback(c);
                        return this.getNumberToken(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    if (seen_e) {
                        this.pushback(c);
                        return this.getNumberToken(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    int c1 = this.nextc();
                    if (c1 != 45 && c1 != 43 && !Character.isDigit(c1)) {
                        this.pushback(c1);
                        this.pushback(c);
                        nondigit = 0;
                        return this.getNumberToken(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    this.numberBuffer.append((char)c);
                    this.numberBuffer.append((char)c1);
                    seen_e = true;
                    nondigit = c1 == 45 || c1 == 43 ? c1 : 0;
                    break;
                }
                case 95: {
                    if (nondigit != 0) {
                        this.compile_error_pos("Trailing '_' in number.");
                    }
                    nondigit = c;
                    break;
                }
                default: {
                    this.pushback(c);
                    return this.getNumberToken(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                }
            }
            c = this.nextc();
        }
    }

    private int getNumberToken(String number, boolean seen_e, boolean seen_point, int nondigit) {
        boolean isFloat;
        boolean bl = isFloat = seen_e || seen_point;
        if (nondigit != 0) {
            this.compile_error_pos("Trailing '_' in number.");
        } else if (isFloat) {
            int suffix = this.numberLiteralSuffix(seen_e ? 2 : 3);
            return this.getFloatToken(number, suffix);
        }
        return this.getIntegerToken(number, 10, this.numberLiteralSuffix(3));
    }

    static {
        map.put("end", Keyword.END);
        map.put("else", Keyword.ELSE);
        map.put("case", Keyword.CASE);
        map.put("ensure", Keyword.ENSURE);
        map.put("module", Keyword.MODULE);
        map.put("elsif", Keyword.ELSIF);
        map.put("def", Keyword.DEF);
        map.put("rescue", Keyword.RESCUE);
        map.put("not", Keyword.NOT);
        map.put("then", Keyword.THEN);
        map.put("yield", Keyword.YIELD);
        map.put("for", Keyword.FOR);
        map.put("self", Keyword.SELF);
        map.put("false", Keyword.FALSE);
        map.put("retry", Keyword.RETRY);
        map.put("return", Keyword.RETURN);
        map.put("true", Keyword.TRUE);
        map.put("if", Keyword.IF);
        map.put("defined?", Keyword.DEFINED_P);
        map.put("super", Keyword.SUPER);
        map.put("undef", Keyword.UNDEF);
        map.put("break", Keyword.BREAK);
        map.put("in", Keyword.IN);
        map.put("do", Keyword.DO);
        map.put("nil", Keyword.NIL);
        map.put("until", Keyword.UNTIL);
        map.put("unless", Keyword.UNLESS);
        map.put("or", Keyword.OR);
        map.put("next", Keyword.NEXT);
        map.put("when", Keyword.WHEN);
        map.put("redo", Keyword.REDO);
        map.put("and", Keyword.AND);
        map.put("begin", Keyword.BEGIN);
        map.put("__LINE__", Keyword.__LINE__);
        map.put("class", Keyword.CLASS);
        map.put("__FILE__", Keyword.__FILE__);
        map.put("END", Keyword.LEND);
        map.put("BEGIN", Keyword.LBEGIN);
        map.put("while", Keyword.WHILE);
        map.put("alias", Keyword.ALIAS);
        map.put("__ENCODING__", Keyword.__ENCODING__);
        byteList2Keyword = new HashMap<ByteList, Keyword>();
        byteList2Keyword.put(Keyword.END.bytes, Keyword.END);
        byteList2Keyword.put(Keyword.ELSE.bytes, Keyword.ELSE);
        byteList2Keyword.put(Keyword.CASE.bytes, Keyword.CASE);
        byteList2Keyword.put(Keyword.ENSURE.bytes, Keyword.ENSURE);
        byteList2Keyword.put(Keyword.MODULE.bytes, Keyword.MODULE);
        byteList2Keyword.put(Keyword.ELSIF.bytes, Keyword.ELSIF);
        byteList2Keyword.put(Keyword.DEF.bytes, Keyword.DEF);
        byteList2Keyword.put(Keyword.RESCUE.bytes, Keyword.RESCUE);
        byteList2Keyword.put(Keyword.NOT.bytes, Keyword.NOT);
        byteList2Keyword.put(Keyword.THEN.bytes, Keyword.THEN);
        byteList2Keyword.put(Keyword.YIELD.bytes, Keyword.YIELD);
        byteList2Keyword.put(Keyword.FOR.bytes, Keyword.FOR);
        byteList2Keyword.put(Keyword.SELF.bytes, Keyword.SELF);
        byteList2Keyword.put(Keyword.FALSE.bytes, Keyword.FALSE);
        byteList2Keyword.put(Keyword.RETRY.bytes, Keyword.RETRY);
        byteList2Keyword.put(Keyword.RETURN.bytes, Keyword.RETURN);
        byteList2Keyword.put(Keyword.TRUE.bytes, Keyword.TRUE);
        byteList2Keyword.put(Keyword.IF.bytes, Keyword.IF);
        byteList2Keyword.put(Keyword.DEFINED_P.bytes, Keyword.DEFINED_P);
        byteList2Keyword.put(Keyword.SUPER.bytes, Keyword.SUPER);
        byteList2Keyword.put(Keyword.UNDEF.bytes, Keyword.UNDEF);
        byteList2Keyword.put(Keyword.BREAK.bytes, Keyword.BREAK);
        byteList2Keyword.put(Keyword.IN.bytes, Keyword.IN);
        byteList2Keyword.put(Keyword.DO.bytes, Keyword.DO);
        byteList2Keyword.put(Keyword.NIL.bytes, Keyword.NIL);
        byteList2Keyword.put(Keyword.UNTIL.bytes, Keyword.UNTIL);
        byteList2Keyword.put(Keyword.UNLESS.bytes, Keyword.UNLESS);
        byteList2Keyword.put(Keyword.OR.bytes, Keyword.OR);
        byteList2Keyword.put(Keyword.NEXT.bytes, Keyword.NEXT);
        byteList2Keyword.put(Keyword.WHEN.bytes, Keyword.WHEN);
        byteList2Keyword.put(Keyword.REDO.bytes, Keyword.REDO);
        byteList2Keyword.put(Keyword.AND.bytes, Keyword.AND);
        byteList2Keyword.put(Keyword.BEGIN.bytes, Keyword.BEGIN);
        byteList2Keyword.put(Keyword.__LINE__.bytes, Keyword.__LINE__);
        byteList2Keyword.put(Keyword.CLASS.bytes, Keyword.CLASS);
        byteList2Keyword.put(Keyword.__FILE__.bytes, Keyword.__FILE__);
        byteList2Keyword.put(Keyword.LEND.bytes, Keyword.LEND);
        byteList2Keyword.put(Keyword.LBEGIN.bytes, Keyword.LBEGIN);
        byteList2Keyword.put(Keyword.WHILE.bytes, Keyword.WHILE);
        byteList2Keyword.put(Keyword.ALIAS.bytes, Keyword.ALIAS);
        byteList2Keyword.put(Keyword.__ENCODING__.bytes, Keyword.__ENCODING__);
    }

    public static enum Keyword {
        END("end", new ByteList(new byte[]{101, 110, 100}, LexingCommon.USASCII_ENCODING), 264, 264, 2),
        ELSE("else", new ByteList(new byte[]{101, 108, 115, 101}, LexingCommon.USASCII_ENCODING), 269, 269, 1),
        CASE("case", new ByteList(new byte[]{99, 97, 115, 101}, LexingCommon.USASCII_ENCODING), 270, 270, 1),
        ENSURE("ensure", new ByteList(new byte[]{101, 110, 115, 117, 114, 101}, LexingCommon.USASCII_ENCODING), 263, 263, 1),
        MODULE("module", new ByteList(new byte[]{109, 111, 100, 117, 108, 101}, LexingCommon.USASCII_ENCODING), 258, 258, 1),
        ELSIF("elsif", new ByteList(new byte[]{101, 108, 115, 105, 102}, LexingCommon.USASCII_ENCODING), 268, 268, 1),
        DEF("def", new ByteList(new byte[]{100, 101, 102}, LexingCommon.USASCII_ENCODING), 259, 259, 128),
        RESCUE("rescue", new ByteList(new byte[]{114, 101, 115, 99, 117, 101}, LexingCommon.USASCII_ENCODING), 262, 298, 64),
        NOT("not", new ByteList(new byte[]{110, 111, 116}, LexingCommon.USASCII_ENCODING), 293, 293, 16),
        THEN("then", new ByteList(new byte[]{116, 104, 101, 110}, LexingCommon.USASCII_ENCODING), 267, 267, 1),
        YIELD("yield", new ByteList(new byte[]{121, 105, 101, 108, 100}, LexingCommon.USASCII_ENCODING), 285, 285, 16),
        FOR("for", new ByteList(new byte[]{102, 111, 114}, LexingCommon.USASCII_ENCODING), 274, 274, 1),
        SELF("self", new ByteList(new byte[]{115, 101, 108, 102}, LexingCommon.USASCII_ENCODING), 287, 287, 2),
        FALSE("false", new ByteList(new byte[]{102, 97, 108, 115, 101}, LexingCommon.USASCII_ENCODING), 290, 290, 2),
        RETRY("retry", new ByteList(new byte[]{114, 101, 116, 114, 121}, LexingCommon.USASCII_ENCODING), 278, 278, 2),
        RETURN("return", new ByteList(new byte[]{114, 101, 116, 117, 114, 110}, LexingCommon.USASCII_ENCODING), 284, 284, 64),
        TRUE("true", new ByteList(new byte[]{116, 114, 117, 101}, LexingCommon.USASCII_ENCODING), 289, 289, 2),
        IF("if", new ByteList(new byte[]{105, 102}, LexingCommon.USASCII_ENCODING), 265, 294, 1),
        DEFINED_P("defined?", new ByteList(new byte[]{100, 101, 102, 105, 110, 101, 100, 63}, LexingCommon.USASCII_ENCODING), 300, 300, 16),
        SUPER("super", new ByteList(new byte[]{115, 117, 112, 101, 114}, LexingCommon.USASCII_ENCODING), 286, 286, 16),
        UNDEF("undef", new ByteList(new byte[]{117, 110, 100, 101, 102}, LexingCommon.USASCII_ENCODING), 260, 260, 4224),
        BREAK("break", new ByteList(new byte[]{98, 114, 101, 97, 107}, LexingCommon.USASCII_ENCODING), 275, 275, 64),
        IN("in", new ByteList(new byte[]{105, 110}, LexingCommon.USASCII_ENCODING), 279, 279, 1),
        DO("do", new ByteList(new byte[]{100, 111}, LexingCommon.USASCII_ENCODING), 280, 280, 1),
        NIL("nil", new ByteList(new byte[]{110, 105, 108}, LexingCommon.USASCII_ENCODING), 288, 288, 2),
        UNTIL("until", new ByteList(new byte[]{117, 110, 116, 105, 108}, LexingCommon.USASCII_ENCODING), 273, 297, 1),
        UNLESS("unless", new ByteList(new byte[]{117, 110, 108, 101, 115, 115}, LexingCommon.USASCII_ENCODING), 266, 295, 1),
        OR("or", new ByteList(new byte[]{111, 114}, LexingCommon.USASCII_ENCODING), 292, 292, 1),
        NEXT("next", new ByteList(new byte[]{110, 101, 120, 116}, LexingCommon.USASCII_ENCODING), 276, 276, 64),
        WHEN("when", new ByteList(new byte[]{119, 104, 101, 110}, LexingCommon.USASCII_ENCODING), 271, 271, 1),
        REDO("redo", new ByteList(new byte[]{114, 101, 100, 111}, LexingCommon.USASCII_ENCODING), 277, 277, 2),
        AND("and", new ByteList(new byte[]{97, 110, 100}, LexingCommon.USASCII_ENCODING), 291, 291, 1),
        BEGIN("begin", new ByteList(new byte[]{98, 101, 103, 105, 110}, LexingCommon.USASCII_ENCODING), 261, 261, 1),
        __LINE__("__LINE__", new ByteList(new byte[]{95, 95, 76, 73, 78, 69, 95, 95}, LexingCommon.USASCII_ENCODING), 303, 303, 2),
        CLASS("class", new ByteList(new byte[]{99, 108, 97, 115, 115}, LexingCommon.USASCII_ENCODING), 257, 257, 512),
        __FILE__("__FILE__", new ByteList(new byte[]{95, 95, 70, 73, 76, 69, 95, 95}, LexingCommon.USASCII_ENCODING), 304, 304, 2),
        LEND("END", new ByteList(new byte[]{69, 78, 68}, LexingCommon.USASCII_ENCODING), 302, 302, 2),
        LBEGIN("BEGIN", new ByteList(new byte[]{66, 69, 71, 73, 78}, LexingCommon.USASCII_ENCODING), 301, 301, 2),
        WHILE("while", new ByteList(new byte[]{119, 104, 105, 108, 101}, LexingCommon.USASCII_ENCODING), 272, 296, 1),
        ALIAS("alias", new ByteList(new byte[]{97, 108, 105, 97, 115}, LexingCommon.USASCII_ENCODING), 299, 299, 4224),
        __ENCODING__("__ENCODING__", new ByteList(new byte[]{95, 95, 69, 78, 67, 79, 68, 73, 78, 71, 95, 95}, LexingCommon.USASCII_ENCODING), 305, 305, 2);

        public final String name;
        public final ByteList bytes;
        public final int id0;
        public final int id1;
        public final int state;

        private Keyword(String name2, ByteList bytes2, int id0, int id1, int state2) {
            this.name = name2;
            this.bytes = bytes2;
            this.id0 = id0;
            this.id1 = id1;
            this.state = state2;
        }
    }
}

