/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyYielder;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

@JRubyClass(name={"Enumerator::Generator"})
public class RubyGenerator
extends RubyObject {
    private RubyProc proc;

    public static RubyClass createGeneratorClass(ThreadContext context, RubyClass Object2, RubyClass Enumerator, RubyModule Enumerable) {
        return (RubyClass)((RubyModule)((RubyModule)Enumerator.defineClassUnder(context, "Generator", Object2, RubyGenerator::new)).include(context, Enumerable)).defineMethods(context, RubyGenerator.class);
    }

    public RubyGenerator(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, optional=1, checkArity=false)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        if (Arity.checkArgumentCount(context, args2, 0, 1) == 0) {
            this.proc = RubyProc.newProc(context.runtime, block, Block.Type.PROC);
        } else {
            this.proc = Convert.castAsProc(context, args2[0]);
            if (block.isGiven()) {
                Warn.warn(context, "given block not used");
            }
        }
        return this;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyGenerator) {
            RubyGenerator generator = (RubyGenerator)other;
            this.checkFrozen();
            this.proc = generator.proc;
            return this;
        }
        throw Error.typeError(context, other, context.runtime.getGenerator());
    }

    @JRubyMethod(rest=true, keywords=true)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.proc.call(context, ArraySupport.newCopy(RubyYielder.newYielder(context, block), args2));
    }

    public RubyProc getProc() {
        return this.proc;
    }
}

